/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.batch.functionsample.sample001;

import jp.terasoluna.fw.batch.openapi.BLogic;
import jp.terasoluna.fw.batch.openapi.BLogicResult;
import jp.terasoluna.fw.batch.openapi.JobContext;
import jp.terasoluna.fw.batch.openapi.ReturnCode;
import jp.terasoluna.fw.dao.QueryDAO;
import jp.terasoluna.fw.dao.UpdateDAO;
import jp.terasoluna.batch.functionsample.common.NyusyukkinData;
import jp.terasoluna.batch.functionsample.common.ZandakaData;

/**
 * rWlXWbNNX
 * <p>ce[uXVB</p>
 */
public class Sample001BLogic implements BLogic<NyusyukkinData, JobContext> {

    /**
     * DAONXB
     * SpringɂCX^Xݒ肳B
     */
    private QueryDAO queryDAO;
   
    /**
     * DAONXB
     * SpringɂCX^Xݒ肳B
     */
    private UpdateDAO updateDAO;

    //o敪́uv
    private static final int NYUKIN = 0;
    
    public BLogicResult execute(NyusyukkinData nyusyukkin, JobContext jobContext) {
    
    //ce[uof[^̌ڋqCDɂЂÂf[^擾
    ZandakaData zandakaData
        = queryDAO.executeForObject("SAMPLE001.getZandakaDataByKokyakucd", 
            nyusyukkin.getKokyakucd(), ZandakaData.class);

    //o敪`FbNAcvZs
    int zandaka = 0;
    if(nyusyukkin.getNyusyukkincd() == NYUKIN){
        zandaka = nyusyukkin.getKingaku();
    }else{
        zandaka = zandaka - nyusyukkin.getKingaku();
    }
    
    //R[hǉ
    if(zandakaData != null){
        zandaka = zandaka + zandakaData.getZandaka();
        zandakaData.setZandaka(zandaka);
        zandakaData.setSaisyutorihikibi(nyusyukkin.getTorihikibi());
        updateDAO.execute("SAMPLE001.updateZandakaData", zandakaData);
    
    //R[hXV
    }else{
        zandakaData = new ZandakaData();
        zandakaData.setKokyakucd(nyusyukkin.getKokyakucd());
        zandakaData.setZandaka(zandaka);
        zandakaData.setSaisyutorihikibi(nyusyukkin.getTorihikibi());
        updateDAO.execute("SAMPLE001.insertZandakaData", zandakaData);
    }
    
    return new BLogicResult(ReturnCode.NORMAL_CONTINUE);
    }

    /**
     * QueryDAOݒ肷B
     * @param queryDAO ݒ肷QueryDAO
     */
    public void setQueryDAO(QueryDAO queryDAO) {
        this.queryDAO = queryDAO;
    }
    
    /**
     * UpdateDAOݒ肷B
     * @param updateDAO ݒ肷UpdateDAO
     */
    public void setUpdateDAO(UpdateDAO updateDAO) {
        this.updateDAO = updateDAO;
    }
}
