/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.fmv.ui.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import jp.sourceforge.talisman.fmv.ui.FmvGraphSetting;
import jp.sourceforge.talisman.i18n.MessageManager;

public class FmvGraphSettingPane
extends JPanel {
    private static final long serialVersionUID = -8658533959286291229L;
    private MessageManager mm;
    private JCheckBox showConfigurationButton;
    private JCheckBox showDetails;
    private JCheckBox showGrid;
    private JCheckBox showSubGrid;
    private JCheckBox showGraphLabel;
    private JCheckBox fill;
    private ColorButton stringColor;
    private ColorButton backgroundColor;
    private ColorButton foregroundColor;
    private ColorButton gridColor;
    private ColorButton subGridColor;
    private JTextField history;
    private JTextField step;
    private JTextField interval;
    private JTextField width;
    private JTextField height;

    public FmvGraphSettingPane(MessageManager mm) {
        this(mm, new FmvGraphSetting());
    }

    public FmvGraphSettingPane(MessageManager mm, FmvGraphSetting fgs) {
        this.mm = mm;
        if (fgs == null) {
            fgs = new FmvGraphSetting();
        }
        this.initLayout(fgs);
    }

    public FmvGraphSetting getGraphSetting() {
        FmvGraphSetting fgs = new FmvGraphSetting();
        fgs.setShowConfigurationButton(this.showConfigurationButton.isSelected());
        fgs.setShowDetails(this.showDetails.isSelected());
        fgs.setShowGrid(this.showGrid.isSelected());
        fgs.setShowSubGrid(this.showSubGrid.isSelected());
        fgs.setShowGraphLabel(this.showGraphLabel.isSelected());
        fgs.setFill(this.fill.isSelected());
        fgs.setStringColor(this.stringColor.getColor());
        fgs.setBackgroundColor(this.backgroundColor.getColor());
        fgs.setForegroundColor(this.foregroundColor.getColor());
        fgs.setGridColor(this.gridColor.getColor());
        fgs.setSubGridColor(this.subGridColor.getColor());
        fgs.setHistoryCount(Integer.parseInt(this.history.getText()));
        fgs.setStepCount(Integer.parseInt(this.step.getText()));
        fgs.setInterval(Integer.parseInt(this.interval.getText()));
        fgs.setMinimumSize(new Dimension(Integer.parseInt(this.width.getText()), Integer.parseInt(this.height.getText())));
        return fgs;
    }

    private void initLayout(FmvGraphSetting fgs) {
        this.showConfigurationButton = new JCheckBox(this.mm.getMessages().get("show.configuration"), fgs.isShowConfigurationButton());
        this.showDetails = new JCheckBox(this.mm.getMessages().get("show.details"), fgs.isShowDetails());
        this.showGraphLabel = new JCheckBox(this.mm.getMessages().get("show.graphlabel"), fgs.isShowGraphLabel());
        this.showGrid = new JCheckBox(this.mm.getMessages().get("show.grid"), fgs.isShowGrid());
        this.showSubGrid = new JCheckBox(this.mm.getMessages().get("show.subgrid"), fgs.isShowSubGrid());
        this.fill = new JCheckBox(this.mm.getMessages().get("fill.graph"), fgs.isFill());
        this.stringColor = new ColorButton(this.mm, "stringcolor", fgs.getStringColor());
        this.backgroundColor = new ColorButton(this.mm, "background", fgs.getBackgroundColor());
        this.foregroundColor = new ColorButton(this.mm, "foreground", fgs.getForegroundColor());
        this.gridColor = new ColorButton(this.mm, "gridcolor", fgs.getGridColor());
        this.subGridColor = new ColorButton(this.mm, "subgridcolor", fgs.getSubGridColor());
        this.history = new JTextField(String.valueOf(fgs.getHistoryCount()));
        this.history.setHorizontalAlignment(4);
        this.history.setInputVerifier(new IntegerInputVerifier());
        this.history.setBorder(new TitledBorder(this.mm.getMessages().get("history.count")));
        this.step = new JTextField(String.valueOf(fgs.getStepCount()));
        this.step.setHorizontalAlignment(4);
        this.step.setInputVerifier(new IntegerInputVerifier());
        this.step.setBorder(new TitledBorder(this.mm.getMessages().get("step.count")));
        this.interval = new JTextField(String.valueOf(fgs.getInterval()));
        this.interval.setHorizontalAlignment(4);
        this.interval.setInputVerifier(new IntegerInputVerifier());
        this.interval.setBorder(new TitledBorder(this.mm.getMessages().get("interval")));
        this.width = new JTextField(String.valueOf(fgs.getMinimumSize().width));
        this.width.setHorizontalAlignment(4);
        this.width.setInputVerifier(new IntegerInputVerifier());
        this.width.setBorder(new TitledBorder(this.mm.getMessages().get("minimumsize.width")));
        this.height = new JTextField(String.valueOf(fgs.getMinimumSize().height));
        this.height.setHorizontalAlignment(4);
        this.height.setInputVerifier(new IntegerInputVerifier());
        this.height.setBorder(new TitledBorder(this.mm.getMessages().get("minimumsize.height")));
        this.setLayout(new GridLayout(6, 3));
        this.add(this.showConfigurationButton);
        this.add(this.showDetails);
        this.add(this.fill);
        this.add(this.showGrid);
        this.add(this.showSubGrid);
        this.add(this.showGraphLabel);
        this.add(this.stringColor);
        this.add(this.backgroundColor);
        this.add(this.foregroundColor);
        this.add(this.gridColor);
        this.add(this.subGridColor);
        this.add(new JPanel());
        this.add(this.history);
        this.add(this.step);
        this.add(this.interval);
        this.add(this.width);
        this.add(this.height);
    }

    private static class IntegerInputVerifier
    extends InputVerifier {
        private IntegerInputVerifier() {
        }

        public boolean verify(JComponent c) {
            boolean verified = false;
            JTextField textField = (JTextField)c;
            try {
                Integer.parseInt(textField.getText());
                verified = true;
            }
            catch (NumberFormatException e) {
                UIManager.getLookAndFeel().provideErrorFeedback(c);
            }
            return verified;
        }
    }

    private static class ColorButton
    extends JButton {
        private static final long serialVersionUID = -7735369010520675405L;
        private Color color;

        public ColorButton(final MessageManager mm, String label, Color defaultColor) {
            super(mm.getMessages().get(label));
            this.color = defaultColor;
            this.setBackground(this.color);
            this.setForeground(this.getContraColor(this.color));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Color newColor = JColorChooser.showDialog(ColorButton.this, mm.getMessages().get("colorselect"), ColorButton.this.color);
                    if (newColor != null) {
                        ColorButton.this.color = newColor;
                        ColorButton.this.setBackground(newColor);
                        ColorButton.this.setForeground(ColorButton.this.getContraColor(newColor));
                    }
                }
            });
        }

        public Color getColor() {
            return this.color;
        }

        private Color getContraColor(Color c) {
            Color cc = new Color(255 - c.getRed(), 255 - c.getGreen(), 255 - c.getBlue());
            if (Math.abs(cc.getRed() - c.getRed()) < 10 && Math.abs(cc.getGreen() - c.getGreen()) < 10 && Math.abs(cc.getBlue() - c.getBlue()) < 10) {
                cc = Color.WHITE;
            }
            return cc;
        }
    }
}

