///////////////////////////////////////////////////////////////////////////
// KeywordList.h
// ɤΥꥹȤݻ륯饹
///////////////////////////////////////////////////////////////////////////

#if !defined( KEYWORDLIST_H_INCLUDED_ )
#define KEYWORDLIST_H_INCLUDED_

#include <ctype.h>
#include <assert.h>
#include <stdio.h>
#include <wchar.h>
#include <vector>
#include <string>
#include <algorithm>

namespace NLangExt {

// ɤΥꥹȤ
class CKeywordList
{
public:
	CKeywordList()
	{}

	// ɤΥꥹȤɤ߹
	bool Initialize( const char *fname, bool IsSensitive )
	{
		assert( NULL != this && NULL != fname );
		FILE *infile;
		std::wstring LineStr;
		int i;

		// ե̾ꤵʤäϡꥹȤɤ߹ޤ˽λ
		if ( strlen( fname ) == 0 ) return true;

		// ե򳫤
		infile = fopen( fname, "r" );
		if ( NULL == infile ) {
			// Ԥϵ֤ƽλ
			return false;
		}

		// Ԥɤ߹
		while ( !feof( infile ) && !ferror( infile ) ) {
			// ɤ߹
			ReadLine( &LineStr, infile, IsSensitive );

			// ԤɤФ
			if ( LineStr.empty() ) continue;

			// ɲä
			vKeyword.push_back( LineStr );
			LineStr = L"";
		}

		fclose( infile );
		infile = NULL;

		// ե٥åȽ¤ؤ
		std::sort( vKeyword.begin(), vKeyword.end() );

		// ʣ
		i = 1;
		while ( i < vKeyword.size() ) {
			if ( vKeyword[ i - 1 ] == vKeyword[i] )
				vKeyword.erase( vKeyword.begin() + i );
			else
				i++;
		}
		return true;
	};

	// ɤ
	const std::vector< std::wstring >& GetKeywordList() const
	{
		assert( NULL != this );
		return vKeyword;
	};
protected:

	// ɤ߹
	void ReadLine( std::wstring *pStr, FILE *infile, bool IsSensitive ) const
	{
		wchar_t c;

		pStr->clear();
		c = fgetwc( infile );
		if ( !IsSensitive ) c = towupper( c );
		while ( !ferror( infile ) && !feof( infile ) && c != L'\n' ) {
			(*pStr) += c;
			c = fgetwc( infile );
			if ( !IsSensitive ) c = towupper( c );
		}
	};
	std::vector< std::wstring > vKeyword;	// 
};


} // namespace NLangExt

#endif // KEYWORDLIST_H_INCLUDED_

