////////////////////////////////////////////////////////////////////////////
// CCursor 饹Υץơ
//
////////////////////////////////////////////////////////////////////////////

#include "Cursor.h"
#include "TaEditDraw.h"
#include "TaEditShell.h"

////////////////////////////////////////////////////////////////////////////
// /˴
////////////////////////////////////////////////////////////////////////////

CCursor::CCursor( const CTaEditDraw *argpDraw, const CTaEditDoc *argpDoc, VClsPtr< CXimMgr > argXimMgr ) :
	pDraw( argpDraw ),
	pDoc( argpDoc ),
	pXimMgr( argXimMgr ),
	xpPos( 0 ),
	ypPos( 0 ),
	OldPsitiveXpPos( 0 )
{
	CurDFlg = false;
}

CCursor::~CCursor()
{

}

////////////////////////////////////////////////////////////////////////////
// ᥽å
////////////////////////////////////////////////////////////////////////////

// ʸñ̤ΰ֤顢֤
void CCursor::SetCurPos( T_CurPos argPos, ScrollInfoPacket *pPacket, bool OnShift, bool RedrawCursor, bool IsPositive )
{
	int i;
	const T_CurPos Before = CurPos;	// ߤΥ֤
	bool flg = true;
	bool RedrawUB;

	assert( argPos.GetLine() >= 0 && argPos.GetLine() < pDoc->RefData().size() );

	// ֤ѲʤСκԤʤ
	if ( Before == argPos ) flg = false;

	// ưˡõ
	if ( CurDFlg && flg && RedrawCursor ) OnTimer();
	RedrawUB = ( Before.GetLine() != argPos.GetLine() );

	// ȤιԤѤä顢¸βõ
	if ( RedrawUB ) pDraw->DrawCurLineUnderbar( Before.GetLine(), false );

	const CLineData &rLineData = pDoc->RefData()[ argPos.GetLine() ];
	assert( argPos.GetCPos() >= 0 );
	if ( argPos.GetCPos() > rLineData.length() )
		argPos.SetCPos( rLineData.length() );
	CurPos = argPos;

	JdgIsScroll( pPacket );
	RefleshXIMPos();	// XIMΰ֤
	ProcSelRange( Before, CurPos, OnShift, pPacket );	// ϰϤ
	if ( flg && RedrawCursor ) OnTimer();	// κ
	UpdateCopyPasteMenuSensitive();	// ˥塼ξ֤򹹿
	m_TaEditShell->DelayCursorTimer();

	// ¸β
	if ( RedrawUB ) pDraw->DrawCurLineUnderbar( argPos.GetLine(), true );

	// ݥƥ֤ʰưʤ줿ȤΡXɸ
	if ( IsPositive ) OldPsitiveXpPos = CalcXPosition( CurPos );
}

// ֤ϰϤ
void CCursor::SetCurPos( T_CurPos argPos, ScrollInfoPacket *pPacket, const T_SelRange& rArgSelRange, bool RedrawCursor, bool IsPositive)
{
	T_SelRange BeforeSelRange = SelRange;
	pPacket->IsSelCange = false;

	// ư
	SetCurPos( argPos, pPacket, false, RedrawCursor );	// ϰϤ
	SelRange = rArgSelRange;		// ϰϤꤹ

	// ϰϤѲϰϤ
	if ( BeforeSelRange != rArgSelRange ) {
		// ۤʤϰϤꤵ줿
		pPacket->IsSelCange = true;
		SelRange = rArgSelRange;	// ϰϤ
		Calc_SRChangeLine( &(pPacket->ChangeSLine), &(pPacket->ChangeELine), BeforeSelRange, rArgSelRange );
	}

	UpdateCopyPasteMenuSensitive();	// ˥塼ξ֤򹹿
	m_TaEditShell->DelayCursorTimer();

	// ݥƥ֤ʰưʤ줿ȤΡXɸ
	if ( IsPositive ) OldPsitiveXpPos = CalcXPosition( CurPos );
}

// ֤ȤΥ
void CCursor::OnTimer()
{
	int x;
	int y;

	// ɥ˥եʤХ褷ʤ
	// ξõϹԤ
	if ( !pDraw->GetForcusState() && !CurDFlg ) return ;

	if ( !CurDFlg ) {
		CalcDrawCurPos( &x, &y );
		xpPos = x;	// 褹ˤϡ
		ypPos = y;	// κɸ¸롣
	}
	else {
		x = xpPos;	// õȤ
		y = ypPos;	// Ǹ褷֤Ѥ
	}
	if ( x < 0 || y < 0 ) {
		// 뤬ϰϤ˴ޤޤƤʤ
		CurDFlg = false;
		return ;
	}
	pDraw->DrawCursor( x, y );
	CurDFlg = !CurDFlg;
}

// 褵줿
void CCursor::OnRedraw()
{
	// 褵ȥϾä뤿ᡢ⤦٥褹
	CurDFlg = false;
	OnTimer();
	pDraw->DrawCurLineUnderbar( CurPos.GetLine(), true );
}

// ΰư
// ΰư̤ˤꡢ̤򥹥뤹ɬפˤϡ
// pIsXScrollpIsYScrolltrueꤷpX_pixˤϺüꤹ٤֡ʥԥñ̡ˡ
// pY_lineˤϾüꤹ٤֡ʹñ̡ˤꤹ롣
void CCursor::Up( ScrollInfoPacket *pPacket, bool OnShift )
{
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	T_CurPos wCurPos = CurPos;
	int NextXPos;

	if ( wCurPos.GetLine() <= 0 ) {
		// ʾ˰ưǤʤϡƬذư
		wCurPos.SetCPos( 0 );
	}
	else {
		// ľ˰ư
		wCurPos.DecrLine();

		// β֤η
		switch ( pConf->GetCursorBehaviorMode() ) {
		case CBM_FORGET:
			// ֤߰ꤹ
			NextXPos = CalcXPosition( CurPos );
			break;
		case CBM_MEMORY:
			// Ǹ˥ݥƥ֤ʰưʤ줿Ȥβ֤ꤹ
			NextXPos = OldPsitiveXpPos;
			break;
		}
		wCurPos.SetCPos( CalcCPosByXPosition( wCurPos.GetLine(), NextXPos ) );
	}

	// ֤
	SetCurPos( wCurPos, pPacket, OnShift, true, false );
}

void CCursor::Down( ScrollInfoPacket *pPacket, bool OnShift )
{
	VClsPtr< CConfigInfo > pConf = m_TaEditShell->GetConfigInfo();
	T_CurPos wCurPos = CurPos;
	int NextXPos;

	if ( wCurPos.GetLine() >= pDoc->RefData().size() - 1 ) {
		// ʾ岼ˤϹԤʤˤϡذư
		wCurPos.SetCPos( pDoc->RefData()[ wCurPos.GetLine() ].length() );
	}
	else {
		// Ĳ˰ư
		wCurPos.IncrLine();

		// β֤η
		switch ( pConf->GetCursorBehaviorMode() ) {
		case CBM_FORGET:
			// ֤߰ꤹ
			NextXPos = CalcXPosition( CurPos );
			break;
		case CBM_MEMORY:
			// Ǹ˥ݥƥ֤ʰưʤ줿Ȥβ֤ꤹ
			NextXPos = OldPsitiveXpPos;
			break;
		}
		wCurPos.SetCPos( CalcCPosByXPosition( wCurPos.GetLine(), NextXPos ) );
	}

	// ֤
	SetCurPos( wCurPos, pPacket, OnShift, true, false );
}

void CCursor::Right( ScrollInfoPacket *pPacket, bool OnShift, bool OnCtrl )
{
	T_CurPos wCurPos = CurPos;
	const wstring &rStr = pDoc->RefData()[ CurPos.GetLine() ].getString();
	int length = rStr.length();

	if ( wCurPos.GetCPos() >= length ) {
		// ιԤؤ
		if ( wCurPos.GetLine() >= pDoc->RefData().size() - 1 ) {
			// ιԤˤԤʤᡢɰưϤʤ
			// ϰϤ꡿뤿ᡢ֤ϹԤ
			SetCurPos( wCurPos, pPacket, OnShift, true, true );
			return ;
		}
		wCurPos.SetCPos( 0 );
		wCurPos.IncrLine();
	}
	else {
		if ( !OnCtrl )
			wCurPos.IncrCPos();
		else {
			// ññ̤Ǥΰư
			wCurPos.SetCPos( WordSkip(
				rStr,
				wCurPos.GetCPos(),
				true,
				m_TaEditShell->GetConfigInfo()->RefWordCharSet()
			) );
		}
	}

	// ֤
	SetCurPos( wCurPos, pPacket, OnShift, true, true );
}

void CCursor::Left( ScrollInfoPacket *pPacket, bool OnShift, bool OnCtrl )
{
	T_CurPos wCurPos = CurPos;
	if ( wCurPos.GetCPos() <= 0 ) {
		// ιԤؤ
		if ( wCurPos.GetLine() <= 0 ) {
			// ιԤˤԤʤᡢɰưϤʤ
			// ϰϤ꡿뤿ᡢ֤ϹԤ
			SetCurPos( wCurPos, pPacket, OnShift, true, true );
			return ;
		}
		wCurPos.DecrLine();
		int length = pDoc->RefData()[ wCurPos.GetLine() ].length();
		wCurPos.SetCPos( length );
	}
	else {
		if ( !OnCtrl )
			wCurPos.DecrCPos();
		else {
			// ññ̤Ǥΰư
			wCurPos.SetCPos( WordSkip( 
				pDoc->RefData()[ CurPos.GetLine() ].getString(),
				 wCurPos.GetCPos() - 1,
				 false,
				m_TaEditShell->GetConfigInfo()->RefWordCharSet()
			) );
		}
	}

	// ֤
	SetCurPos( wCurPos, pPacket, OnShift, true, true );
}

// ññ̤Ǥΰưˤơư
int CCursor::WordSkip( const wstring &rStr, int cpos, int IsRight, const wstring &rWordCharSet ) const
{
	// ưʤ
	if ( IsRight && rStr.length() == cpos ) return rStr.length();
	if ( !IsRight && 0 == cpos ) return 0;

	bool flg = wcschr( rWordCharSet.c_str(), rStr[cpos] ) == NULL;

	// ư
	// cpos˻ꤵ줿֤ñ׾ǤСñ⤷Ƭޤǰư롣
	// ǤʤСñƬ⤷ޤǰư롣
	if ( IsRight )
		for (; cpos < rStr.length() && !( wcschr( rWordCharSet.c_str(), rStr[cpos] ) == NULL ^ flg ); ++cpos );
	else {
		for (; cpos >= 0 && !( wcschr( rWordCharSet.c_str(), rStr[cpos] ) == NULL ^ flg ); --cpos );
		++cpos;
	}
	return cpos;
}

void CCursor::PageUp( ScrollInfoPacket *pPacket, bool OnShift )
{
	T_CurPos wCurPos = CurPos;
	int ViewLineCnt = pDraw->GetViewLineCnt();	// ̤ιԿ
	int wl = wCurPos.GetLine() - ViewLineCnt;	// ưιֹ򻻽
	if ( wl < 0 ) wl = 0;

	// ֤ʲΰ֤ϡǸ˥ݥƥ֤ʰưʤ줿ΰ֤Ȥ
	wCurPos.SetLine( wl );
	wCurPos.SetCPos( CalcCPosByXPosition( wCurPos.GetLine(), OldPsitiveXpPos ) );

	SetCurPos( wCurPos, pPacket, OnShift, true, false );
}

void CCursor::PageDown( ScrollInfoPacket *pPacket, bool OnShift )
{
	T_CurPos wCurPos = CurPos;
	int ViewLineCnt = pDraw->GetViewLineCnt();	// ̤ιԿ
	int TatalLineCnt = pDoc->RefData().size();	// Կ
	int wl = wCurPos.GetLine() + ViewLineCnt;	// ưιֹ׻
	if ( wl >= TatalLineCnt ) wl = TatalLineCnt - 1;

	// ֤ʲΰ֤ϡǸ˥ݥƥ֤ʰưʤ줿ΰ֤Ȥ
	wCurPos.SetLine( wl );
	wCurPos.SetCPos( CalcCPosByXPosition( wCurPos.GetLine(), OldPsitiveXpPos ) );

	SetCurPos( wCurPos, pPacket, OnShift, true, false );
}

void CCursor::End( ScrollInfoPacket *pPacket, bool OnShift, bool OnCtrl )
{
	T_CurPos wCurPos = CurPos;
	if ( !OnCtrl )
		wCurPos.SetCPos( pDoc->RefData()[ wCurPos.GetLine() ].length() );
	else {
		// ȥ륭Ƥϡʸذư
		int wLineCnt = pDoc->RefData().size() - 1;
		int wCharCnt = pDoc->RefData()[ wLineCnt ].length();
		wCurPos = T_CurPos( wLineCnt, wCharCnt );
	}

	SetCurPos( wCurPos, pPacket, OnShift, true, true );
}

void CCursor::Home( ScrollInfoPacket *pPacket, bool OnShift, bool OnCtrl )
{
	T_CurPos wCurPos = CurPos;
	if ( !OnCtrl )
		wCurPos.SetCPos( 0 );	// ưΰ֤򻻽
	else
		wCurPos = T_CurPos( 0, 0 );	// ʸƬ

	SetCurPos( wCurPos, pPacket, OnShift, true, true );
}

// ñ
void CCursor::SelectWord( ScrollInfoPacket *pPacket, const T_CurPos &rPos )
{
	const wstring &rStr = pDoc->RefData()[ rPos.GetLine() ].getString();
	int length = rStr.length();
	bool wIsSelCange;
	int wChangeSLine;
	int wChangeELine;

	// ޤϡꤵ줿֤˰ư
	SetCurPos( rPos, pPacket, false );

	// ϰϤѲξ򤹤
	wIsSelCange = pPacket->IsSelCange;
	wChangeSLine = pPacket->ChangeSLine;
	wChangeELine = pPacket->ChangeELine;

	// ꤵ줿֤顢ö˰ưθ屦ưϰԤ
	// ԤޤϹԤʤ
	pPacket->IsSelCange = false;
	if ( rPos.GetCPos() > 0 )
		Left( pPacket, false, true );
	if ( CurPos.GetCPos() < length )
		Right( 	pPacket, true, true );	

	// ѤˡϰϤѲξꤹ
	if ( !wIsSelCange ) return ;	// ǽʳѲʤСäˤ뤳ȤϤʤ

	if ( !pPacket->IsSelCange ) {
		// ܤʳѲʤСǽѲΤߤꤹ롣
		pPacket->IsSelCange = wIsSelCange;
		pPacket->ChangeSLine = wChangeSLine;
		pPacket->ChangeELine = wChangeELine;
	}
	else {
		pPacket->IsSelCange = true;
		// ܤܤȤѹϰϤ񤹤ϰϤ
		if ( wChangeSLine < pPacket->ChangeSLine )
			pPacket->ChangeSLine = wChangeSLine;
		if ( wChangeELine > pPacket->ChangeELine )
			pPacket->ChangeELine = wChangeELine;
	}
}

// ʸñ̤ǤΥ֤
const T_CurPos& CCursor::GetCurPos() const
{
	return CurPos;
}

// XIMΰ֤ꤹ
void CCursor::RefleshXIMPos() const
{
	int x, y;
	CalcDrawCurPos( &x, &y );

	if ( x < 0 || y < 0 ) return ;

	// XIMϰ֤
	y += pDraw->GetTextAscent();
	pXimMgr->SetPosition( x, y );
}

// ꤵ줿ʸϰϤ˴ޤޤƤ뤫ݤ
bool CCursor::IsCharSelected( const T_CurPos &r ) const
{
	return ( SelRange.GetSPos() <= r && SelRange.GetEPos() > r );
}

// ϰϤ
const T_SelRange& CCursor::GetSelRange() const
{
	return SelRange;
}

// ̤򥹥뤹ɬפ̵ͭȽǤ
void CCursor::JdgIsScroll( ScrollInfoPacket *pPacket ) const
{
	int TopLineNum = pDraw->GetTopLineNum();
	int ViewLineCnt = pDraw->GetViewLineCnt();
	int LeftPixPos = pDraw->GetLeftPixPos();
	int ViewWidth = pDraw->GetViewWidth();
	int pixCurX = CalcXPosition( CurPos );

	pPacket->NeedYScroll = false;
	pPacket->NeedXScroll = false;

	if ( CurPos.GetLine() < TopLineNum ) {
		pPacket->NeedYScroll = true;
		pPacket->lineY = CurPos.GetLine();
	}
	if ( CurPos.GetLine() >= TopLineNum + ViewLineCnt ) {
		pPacket->NeedYScroll = true;
		pPacket->lineY = CurPos.GetLine() - ViewLineCnt + 1;
	}
	if ( pixCurX < LeftPixPos ){
		pPacket->NeedXScroll = true;
		pPacket->pixX = pixCurX;
	}
	if ( pixCurX > LeftPixPos + ViewWidth ) {
		pPacket->NeedXScroll = true;
		pPacket->pixX = pixCurX - ViewWidth;
	}
}

// ֤򻻽Сʲ̤κ0Ȥ͡
void CCursor::CalcDrawCurPos( int *px, int *py ) const
{
	int TopLineNum = pDraw->GetTopLineNum();
	int ViewLineCnt = pDraw->GetViewLineCnt();
	int LeftPixPos = pDraw->GetLeftPixPos();
	int ViewWidth = pDraw->GetViewWidth();
	int pixCurX = CalcXPosition( CurPos );

	if ( CurPos.GetLine() < TopLineNum || CurPos.GetLine() >= TopLineNum + ViewLineCnt  )
		(*py) = -1;
	else
		(*py) = ( CurPos.GetLine() - TopLineNum ) * pDraw->GetTextHeight();

	if ( pixCurX < LeftPixPos || pixCurX > LeftPixPos + ViewWidth )
		(*px) = -1;
	else
		(*px) = pixCurX - LeftPixPos;
}

// ֡Xɸˤ
int CCursor::GetCurPosX() const
{
	return CalcXPosition( CurPos );
}

// ˤϰϤѲ
void CCursor::ProcSelRange( const T_CurPos &Before, const T_CurPos &After, bool OnShift, ScrollInfoPacket *pPacket )
{
	T_SelRange hSelRange = SelRange;	// ϰϤ

	if ( !OnShift ) {
		// ShiftƤʤäϡϰϤ
		SelStartPos = After;
		SelRange = T_SelRange( After, After );
	}
	else {
		// ShiftƤϡϰԤ
		if ( SelRange.GetLength() == T_CurPos( 0, 0 ) )
			SelStartPos = Before;	// Ԥϡ򳫻ϰ֤ꤹ
		SelRange = T_SelRange( SelStartPos, After );
	}

	if ( hSelRange == SelRange || ( hSelRange.GetLength() == 0 && SelRange.GetLength() == 0 ) ) {
		// ϰϤѲʤ
		pPacket->IsSelCange = false;
	}
	else {
		// ϰϤѲϡѤξꤹ
		pPacket->IsSelCange = true;
		Calc_SRChangeLine( &(pPacket->ChangeSLine), &(pPacket->ChangeELine), hSelRange, SelRange );
	}
}

// ϰϤѲԤϰϤ
void CCursor::Calc_SRChangeLine( int *pSLine, int *pELine, const T_SelRange& rSR1, const T_SelRange& rSR2 ) const
{
	assert( NULL != pSLine && NULL != pELine );

	if ( rSR1.GetSPos() < rSR2.GetSPos() )
		(*pSLine) = rSR1.GetSPos().GetLine();
	else {
		if ( rSR1.GetSPos() > rSR2.GetSPos() )
			(*pSLine) = rSR2.GetSPos().GetLine();
		else {
			if ( rSR1.GetEPos() < rSR2.GetEPos() )
				(*pSLine) = rSR1.GetEPos().GetLine();
			else
				(*pSLine) = rSR2.GetEPos().GetLine();
		}
	}
	if ( rSR1.GetEPos() < rSR2.GetEPos() )
		(*pELine) = rSR2.GetEPos().GetLine();
	else {
		if ( rSR1.GetEPos() > rSR2.GetEPos() )
			(*pELine) = rSR1.GetEPos().GetLine();
		else {
			if ( rSR1.GetSPos() < SelRange.GetSPos() )
				(*pELine) = rSR2.GetSPos().GetLine();
			else
				(*pELine) = rSR1.GetSPos().GetLine();
		}
	}
	(*pELine)++;	// ϰϽüϡоݤ˴ޤޤʤ
}

// ڤꡦԡ˥塼̵ͭ򹹿
void CCursor::UpdateCopyPasteMenuSensitive() const
{
	bool flg = true;
	if ( SelRange.GetLength() == T_CurPos( 0, 0 ) )
		flg = false;
	m_TaEditShell->SetEnableCopyPasteMenu( flg );
}

// ꤵ줿֤Xɸ
int CCursor::CalcXPosition( T_CurPos pos ) const
{
	assert( NULL != this && NULL != pDoc && NULL != pDraw );
	assert( pos.GetLine() >= 0 && pos.GetLine() < pDoc->RefData().size() );
	const CLineData &rLineData = pDoc->RefData()[ pos.GetLine() ];

	assert( pos.GetCPos() >= 0 );
	if ( pos.GetCPos() > rLineData.length() )
		pos.SetCPos( rLineData.length() );

	// ɬפ˱־򹹿
	if ( !rLineData.IsEnableDrawCharPos() )
		rLineData.UpdateDrawCharPos( pDraw );

	// ֤
	if ( pos.GetCPos() < rLineData.length() )
		return rLineData.GetDrawCharPos().GetCharPos( pos.GetCPos() );
	else
		return rLineData.GetDrawCharPos().GetRightXPos();
}

// ꤵ줿Ԥˤơꤵ줿Xɸ˺Ǥᤤʸ֤򻻽Ф
int CCursor::CalcCPosByXPosition( int line, int xpos ) const
{
	assert( NULL != this && NULL != pDraw );
	return pDraw->XPosToCharNum( line, xpos - pDraw->GetLeftPixPos() );
}
