////////////////////////////////////////////////////////////////////////////
// GlbFunc.h
// Хؿ
////////////////////////////////////////////////////////////////////////////

#include "GlbFunc.h"
#include "VPtr.h"

#include <unistd.h>
#include <limits.h>
#include <assert.h>

#include <vector>
#include <string>

using namespace std;

// ʸꤵ줿ʸʬ䤹
vector< string > GlbFunc::DiviteString( const string &r, char c )
{
	vector< string > wv;
	int i, j;

	if ( r.length() == 0 ) return vector< string >();

	// Ƭ/Ϳ줿ϡʸܤϥåפ
	if ( r[0] == c )
		i = 1;
	else
		i = 0;
	while ( i < r.length() ) {
		for ( j = i; j < r.length() && r[j] != c; j++ );
		wv.push_back( r.substr( i, j - i ) );
		i = j + 1;
	}
	return wv;
}

// ѥ̾褹
string GlbFunc::ResolvPath( const string &r )
{
	string ws;
	int i;
	vector< string > wv;
	vector< string > wv2;

	if ( r.length() == 0 ) return "";

	if ( r[0] != '/' ) {
		// ХѥͿ줿ϡȤǥǥ쥯ȥΥѥ̾Ϣ뤹
		char *pCurDir = getcwd( NULL, PATH_MAX );
		if ( NULL == pCurDir ) return r;
		ws = pCurDir;
		free( pCurDir );
		if ( ws.length() == 0 ) return r;
		if ( ws[ ws.length() - 1 ] != '/' ) ws += '/';
	}
	ws += r;

	// ѥ̾/Ƕڤ
	wv = DiviteString( ws, '/' );

	// פǤ
	wv2.clear();
	for ( i = 0; i < wv.size(); i++ ) {
		// Ĺ0ʸ/Ϣ³ˤ䡢"."Ͻ
		if ( wv[i].length() == 0 || wv[i] == "." ) continue;
		if ( wv[i] == ".." ) {
			// ƥǥ쥯ȥλ
			if ( wv2.size() > 0 ) wv2.pop_back();
			continue;
		}
		// 嵭ʳϡɲä
		wv2.push_back( wv[i] );
	}

	// ͤۤ
	ws = "";
	for ( i = 0; i < wv2.size(); i++ ) {
		ws += string( "/" ) + wv2[i];
	}
	if ( ws.length() == 0 ) ws += "/";
	return ws;
}


// ĤFILEؤ
bool GlbFunc::SwapPort( FILE *a, FILE *b )
{
	int a_no;
	int b_no;
	int a_no2;

	assert( a && b );
	fflush( a );
	fflush( b );

	/* ǥץץ */
	a_no = fileno( a );
	b_no = fileno( b );

	/* aʣ */
	a_no2 = dup( a_no );
	if ( a_no < 0 ) return false;

	/* ab˺ؤ */
	if ( dup2( b_no, a_no ) < 0 ) return false;

	/* bʣaȺؤ */
	if ( dup2( a_no2, b_no ) < 0 ) {
		/* ɤ褦ʤȤꤢ᤹Ϥ򤹤 */
		dup2( a_no2, a_no );
		close( a_no2 );
		return false;
	}
	close( a_no2 );

	clearerr( a );
	clearerr( b );

	return true;
}

// ʸsƬscv˴ޤޤƤʸ
// ecv˴ޤޤƤʸ̤֤
string GlbFunc::Trim( const string &s, const string &scv, const string &ecv )
{
	int i, j, sp, ep;

	// ƬνϰϤ
	for ( i = 0; i < s.length(); i++ ) {
		// s[i]scv˴ޤޤƤ뤫ݤ
		for ( j = 0; j < scv.length() && s[i] != scv[j]; j++ );
		if ( j >= scv.length() ) break;
	}
	if ( i >= s.length() ) return "";
	sp = i;

	// νϰϤ
	for ( i = s.length() - 1; i >= 0 && i >= sp; i-- ) {
		// s[i]ecv˴ޤޤƤ뤫ݤ
		for ( j = 0; j < ecv.length() && s[i] != ecv[j]; j++ );
		if ( j >= ecv.length() ) break;
	}
	if ( i < 0 || i < sp ) return "";
	ep = i + 1;

	return s.substr( sp, ep - sp );
}

// ʸΤ٤ƤξʸʸѴ
string GlbFunc::ToUpper( const string &r )
{
	const char *pO = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
	const char *pK = "abcdefghijklmnopqrstuvwxyz";
	int len = 26;
	int i, j;
	string result;

	result = "";
	for ( i = 0; i < r.length(); i++ ) {
		for ( j = 0; j < len && r[i] != pK[j]; j++ );
		if ( j >= len )
			result += r[i];
		else
			result += pO[j];
	}
	return result;
}

// 磻ɥХʸ󤫤ޥХʸѴ
bool GlbFunc::WCStoMBS( const wchar_t *pWCS, std::string *pMBS )
{
	NNabikiVPtr::VPtr< char > pBuf;
	size_t len = wcstombs( NULL, pWCS, 0 ) + 1;
	if ( len == 0 ) return false;

	pMBS->clear();

	// ΰ
	if ( !pBuf.Malloc( len * sizeof( wchar_t ) ) )
		return false;

	// ޥХʸѴ
	if ( wcstombs( pBuf.GetPtr(), pWCS, len * sizeof( wchar_t ) ) == (size_t)-1 )
		return false;

	// ͤ
	(*pMBS) = pBuf.GetPtr();
	return true;
}

// ޥХʸ󤫤磻ɥХʸѴ
bool GlbFunc::MBStoWCS( const char *pMBS, std::wstring *pWCS )
{
	NNabikiVPtr::VPtr< wchar_t > pBuf;
	size_t len = mbstowcs( NULL, pMBS, 0 ) + 1;
	if ( len == 0 ) return false;
	pWCS->clear();

	// ΰ
	if ( !pBuf.Malloc( len * sizeof( wchar_t ) ) )
		return false;

	// 磻ɥХʸѴ
	if ( mbstowcs( pBuf.GetPtr(), pMBS, len * sizeof( wchar_t ) ) == (size_t)-1 )
		return false;

	// ͤ
	(*pWCS) = pBuf.GetPtr();
	return true;
}

