#include <locale.h>
#include <stdio.h>
#include "../syuhitu/PluginFuncID.h"
#include <malloc.h>
#include <stdlib.h>
#include <wchar.h>
#include <widec.h>

void Set( PFT_GetAPIFunction GetAPIFunction )
{
	PFT_GetCurPosition GetCurPosition = (PFT_GetCurPosition)GetAPIFunction( PFID_GETCURSORPOSITION );
	PTF_GetExtendInfo GetExtendInfo = (PTF_GetExtendInfo)GetAPIFunction( PFID_GETEXTENDINFO );
	PTF_SetExtendInfo SetExtendInfo = (PTF_SetExtendInfo)GetAPIFunction( PFID_SETEXTENDINFO );
	PFT_GetExtendInfoCount GetExtendInfoCount = (PFT_GetExtendInfoCount)GetAPIFunction( PFID_GETEXTENDINFOCOUNT );
	PFT_GetConfigValue GetConfigValue = (PFT_GetConfigValue)GetAPIFunction( PFID_GETCONFIGVALUE );

	unsigned long L, C;
	PFT_BOOL Flg;
	int UseExInfo;
	int ExInfoCnt = GetExtendInfoCount();
	UseExInfo = watoi( GetConfigValue( L"ExtendInfoID" ) );
	if ( UseExInfo >= ExInfoCnt ) return ;
	if ( !GetCurPosition( &L, &C ) ) return ;
	if ( !GetExtendInfo( L, UseExInfo, &Flg ) ) return ;
	if ( !SetExtendInfo( L, UseExInfo, !Flg ) ) return ;
}

void Next( PFT_GetAPIFunction GetAPIFunction )
{
	PFT_GetCurPosition GetCurPosition = (PFT_GetCurPosition)GetAPIFunction( PFID_GETCURSORPOSITION );
	PFT_SetCurPosition SetCurPosition = (PFT_SetCurPosition)GetAPIFunction( PFID_SETCURSORPOSITION );
	PTF_GetExtendInfo GetExtendInfo = (PTF_GetExtendInfo)GetAPIFunction( PFID_GETEXTENDINFO );
	PFT_GetLineCount GetLineCount = (PFT_GetLineCount)GetAPIFunction( PFID_GETLINECOUNT );
	PFT_GetExtendInfoCount GetExtendInfoCount = (PFT_GetExtendInfoCount)GetAPIFunction( PFID_GETEXTENDINFOCOUNT );
	PFT_GetConfigValue GetConfigValue = (PFT_GetConfigValue)GetAPIFunction( PFID_GETCONFIGVALUE );

	unsigned long L, C;
	unsigned long i;
	unsigned long LineCnt;
	PFT_BOOL Flg;
	int UseExInfo;
	int ExInfoCnt = GetExtendInfoCount();

	UseExInfo = watoi( GetConfigValue( L"ExtendInfoID" ) );
	if ( UseExInfo >= ExInfoCnt ) return ;

	if ( !GetLineCount( &LineCnt ) ) return ;
	if ( !GetCurPosition( &L, &C ) ) return ;

	for ( i = L + 1; i < LineCnt; i++ ) {
		if ( !GetExtendInfo( i, UseExInfo, &Flg ) ) return ;
		if ( Flg ) {
			SetCurPosition( i, 0 );
			return ;
		}
	}
}

void Before( PFT_GetAPIFunction GetAPIFunction )
{
	PFT_GetCurPosition GetCurPosition = (PFT_GetCurPosition)GetAPIFunction( PFID_GETCURSORPOSITION );
	PFT_SetCurPosition SetCurPosition = (PFT_SetCurPosition)GetAPIFunction( PFID_SETCURSORPOSITION );
	PTF_GetExtendInfo GetExtendInfo = (PTF_GetExtendInfo)GetAPIFunction( PFID_GETEXTENDINFO );
	PFT_GetLineCount GetLineCount = (PFT_GetLineCount)GetAPIFunction( PFID_GETLINECOUNT );
	PFT_GetExtendInfoCount GetExtendInfoCount = (PFT_GetExtendInfoCount)GetAPIFunction( PFID_GETEXTENDINFOCOUNT );
	PFT_GetConfigValue GetConfigValue = (PFT_GetConfigValue)GetAPIFunction( PFID_GETCONFIGVALUE );

	unsigned long L, C;
	unsigned long i;
	PFT_BOOL Flg;
	int UseExInfo;
	int ExInfoCnt = GetExtendInfoCount();

	UseExInfo = watoi( GetConfigValue( L"ExtendInfoID" ) );
	if ( UseExInfo >= ExInfoCnt ) return ;

	if ( !GetCurPosition( &L, &C ) ) return ;

	for ( i = L - 1; i >= 0; i-- ) {
		if ( !GetExtendInfo( i, UseExInfo, &Flg ) ) return ;
		if ( Flg ) {
			SetCurPosition( i, UseExInfo );
			return ;
		}
	}
}

void AllClear( PFT_GetAPIFunction GetAPIFunction )
{
	PFT_GetLineCount GetLineCount = (PFT_GetLineCount)GetAPIFunction( PFID_GETLINECOUNT );
	PTF_GetExtendInfo GetExtendInfo = (PTF_GetExtendInfo)GetAPIFunction( PFID_GETEXTENDINFO );
	PTF_SetExtendInfo SetExtendInfo = (PTF_SetExtendInfo)GetAPIFunction( PFID_SETEXTENDINFO );
	PFT_GetExtendInfoCount GetExtendInfoCount = (PFT_GetExtendInfoCount)GetAPIFunction( PFID_GETEXTENDINFOCOUNT );
	PFT_GetConfigValue GetConfigValue = (PFT_GetConfigValue)GetAPIFunction( PFID_GETCONFIGVALUE );

	unsigned long i;
	unsigned long LineCnt;
	PFT_BOOL Flg;
	int UseExInfo;
	int ExInfoCnt = GetExtendInfoCount();

	UseExInfo = watoi( GetConfigValue( L"ExtendInfoID" ) );

	if ( !GetLineCount( &LineCnt ) ) return ;

	for ( i = 0; i < LineCnt; i++ ) {
		if ( !GetExtendInfo( i, UseExInfo, &Flg ) ) return ;
		if ( Flg ) {
			if ( !SetExtendInfo( i, UseExInfo, PFT_FALSE ) ) return ;
		}
	}
}
