package jp.sourceforge.sxdbutils.query;

import jp.sourceforge.sxdbutils.bean.ColumnProperty;

public class BeanQueryFactory implements QueryFactory {
	private final String sql;
	private final ColumnProperty[] columnProperties;
	
	BeanQueryFactory(String sql, ColumnProperty[] columnProperties) {
		this.sql = sql;
		this.columnProperties = columnProperties;
	}

	public Query toQuery(Object object) {
		SimpleQueryBuilder builder = new SimpleQueryBuilder(this.sql);
		for (int i = 0; i < columnProperties.length; i++) {
			builder.bind(columnProperties[i].readProperty(object));
		}
		return builder.toQuery();
	}
	public String getSql() {
		return this.sql;
	}

	public Object[] toBindParameters(Object object) {
		Object[] params = new Object[columnProperties.length];
		for (int i = 0; i < columnProperties.length; i++) {
			params[i] = columnProperties[i].readProperty(object);
		}
		return params;
	}

}
