/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.do_johodai.j314.sw.je;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.rulesys.BindingEnvironment;
import com.hp.hpl.jena.reasoner.rulesys.RuleContext;
import com.hp.hpl.jena.reasoner.rulesys.builtins.BaseBuiltin;

public class ListBuiltin
extends BaseBuiltin {
    public String getName() {
        return "list";
    }

    public int getArgLength() {
        return 0;
    }

    public boolean bodyCall(Node[] args, int length, RuleContext context) {
        if (length == 0) {
            return false;
        }
        this.makeListAndBind(args, length, context);
        return true;
    }

    public void headAction(Node[] args, int length, RuleContext context) {
        this.makeListAndBind(args, length, context);
    }

    void makeListAndBind(Node[] args, int length, RuleContext context) {
        Node first = Node.create((String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#first");
        Node rest = Node.create((String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#rest");
        Node list = Node.create((String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#nil");
        for (int i = length - 1; i > 0; --i) {
            Node tail = list;
            list = Node.createAnon();
            context.add(new Triple(list, first, args[i]));
            context.add(new Triple(list, rest, tail));
        }
        BindingEnvironment env = context.getEnv();
        env.bind(args[0], list);
    }
}

