//
//  STInfoViewController.m
//  SmokingTimer
//
//  Created by 森 邦彦 on 10/11/14.
//  Copyright 2010 supermeteor. All rights reserved.
//

#import "STInfoTableViewController.h"
#import "STAboutViewController.h"


//----------------------------------------------------------
//
// 内部型定義
//
//----------------------------------------------------------
// 各テーブル項目の情報
typedef struct {
	NSString* title;				//!< 項目の名前
	NSString* viewControllerName;	//!< 遷移先のViewController名
	NSString* nibName;				//!< 遷移先のViewのNib名
} TableItem;


//----------------------------------------------------------
//
// ファイル内グローバル変数
//
//----------------------------------------------------------
static TableItem g_tableItem[] = {
	{ 
//		NSLocalizedString(@"AppCopyright", @"アプリの著作権情報"),
		@"著作権情報",
		@"STAboutViewController",
		@"AboutView",
	},
	{ 
//		NSLocalizedString(@"AppVersion", @"アプリのバージョン"),
		@"バージョン",
		@"STAboutViewController",
		@"AboutView",
	},
	{ 
//		NSLocalizedString(@"AppInfo", @"アプリの情報"),
		@"このアプリについて",
		@"STAboutViewController",
		@"AboutView",
	},
	{ 
//		NSLocalizedString(@"AppUpgrade", @"アップグレード"),
		@"アップグレード",
		@"STAboutViewController",
		@"AboutView",
	}
};
	

//----------------------------------------------------------
//
// クラス実装
//
//----------------------------------------------------------
@implementation STInfoTableViewController


#pragma mark -
#pragma mark Initialization

/*
- (id)initWithStyle:(UITableViewStyle)style {
    // Override initWithStyle: if you create the controller programmatically and want to perform customization that is not appropriate for viewDidLoad.
    if ((self = [super initWithStyle:style])) {
    }
    return self;
}
*/


#pragma mark -
#pragma mark View lifecycle

/*
- (void)viewDidLoad {
    [super viewDidLoad];

    // Uncomment the following line to display an Edit button in the navigation bar for this view controller.
    // self.navigationItem.rightBarButtonItem = self.editButtonItem;
}
*/

/*
- (void)viewWillAppear:(BOOL)animated {
    [super viewWillAppear:animated];
}
*/
/*
- (void)viewDidAppear:(BOOL)animated {
    [super viewDidAppear:animated];
}
*/
/*
- (void)viewWillDisappear:(BOOL)animated {
    [super viewWillDisappear:animated];
}
*/
/*
- (void)viewDidDisappear:(BOOL)animated {
    [super viewDidDisappear:animated];
}
*/
/*
// Override to allow orientations other than the default portrait orientation.
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation {
    // Return YES for supported orientations
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}
*/


#pragma mark -
#pragma mark Table view data source

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    // Return the number of sections.
    return 1;
}


- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section 
{
    // Return the number of rows in the section.
	return STD_ARRAY_SIZE(g_tableItem);
}


// Customize the appearance of table view cells.
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    
    static NSString *CellIdentifier = @"Cell";
    
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
    if (cell == nil) {
        cell = [[[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:CellIdentifier] autorelease];
    }
    
    // Configure the cell...
	cell.textLabel.text = g_tableItem[indexPath.row].title;
    
    return cell;
}


/*
// Override to support conditional editing of the table view.
- (BOOL)tableView:(UITableView *)tableView canEditRowAtIndexPath:(NSIndexPath *)indexPath {
    // Return NO if you do not want the specified item to be editable.
    return YES;
}
*/


/*
// Override to support editing the table view.
- (void)tableView:(UITableView *)tableView commitEditingStyle:(UITableViewCellEditingStyle)editingStyle forRowAtIndexPath:(NSIndexPath *)indexPath {
    
    if (editingStyle == UITableViewCellEditingStyleDelete) {
        // Delete the row from the data source
        [tableView deleteRowsAtIndexPaths:[NSArray arrayWithObject:indexPath] withRowAnimation:UITableViewRowAnimationFade];
    }   
    else if (editingStyle == UITableViewCellEditingStyleInsert) {
        // Create a new instance of the appropriate class, insert it into the array, and add a new row to the table view
    }   
}
*/


/*
// Override to support rearranging the table view.
- (void)tableView:(UITableView *)tableView moveRowAtIndexPath:(NSIndexPath *)fromIndexPath toIndexPath:(NSIndexPath *)toIndexPath {
}
*/


/*
// Override to support conditional rearranging of the table view.
- (BOOL)tableView:(UITableView *)tableView canMoveRowAtIndexPath:(NSIndexPath *)indexPath {
    // Return NO if you do not want the item to be re-orderable.
    return YES;
}
*/


#pragma mark -
#pragma mark Table view delegate

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath 
{
	TTDPRINT(@"Selected row = %d", indexPath.row);
	
	NSString* viewControllerName	= g_tableItem[indexPath.row].viewControllerName;
	NSString* viewNibName			= g_tableItem[indexPath.row].nibName;

	TTDPRINT(@"Next view controller = %@", viewControllerName);
	TTDPRINT(@"Next view nib        = %@", viewNibName);
	
	// 遷移先のViewControllerのクラスを生成する。
	Class viewControllerClass = NSClassFromString(viewControllerName);
	UIViewController* nextViewController
		= [[viewControllerClass alloc] initWithNibName:viewNibName
												bundle:nil];
	[self.navigationController pushViewController:nextViewController 
										 animated:YES];
	[nextViewController release];
}


#pragma mark -
#pragma mark Memory management

- (void)didReceiveMemoryWarning {
    // Releases the view if it doesn't have a superview.
    [super didReceiveMemoryWarning];
    
    // Relinquish ownership any cached data, images, etc that aren't in use.
}

- (void)viewDidUnload {
    // Relinquish ownership of anything that can be recreated in viewDidLoad or on demand.
    // For example: self.myOutlet = nil;
}


- (void)dealloc {
    [super dealloc];
}


@end


//----------------------------------------------------------
//
// EOF
//
//----------------------------------------------------------

