/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eclemma.internal.ui.coverageview;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.eclemma.core.CoverageTools;
import org.eclipse.eclemma.core.ICoverageSession;
import org.eclipse.eclemma.core.ISessionListener;
import org.eclipse.eclemma.core.analysis.IJavaCoverageListener;
import org.eclipse.eclemma.internal.ui.ContextHelp;
import org.eclipse.eclemma.internal.ui.RedGreenBar;
import org.eclipse.eclemma.internal.ui.UIMessages;
import org.eclipse.eclemma.internal.ui.coverageview.CellTextConverter;
import org.eclipse.eclemma.internal.ui.coverageview.CopyHandler;
import org.eclipse.eclemma.internal.ui.coverageview.CoverageViewSorter;
import org.eclipse.eclemma.internal.ui.coverageview.CoveredElementsContentProvider;
import org.eclipse.eclemma.internal.ui.coverageview.HideUnusedElementsHandler;
import org.eclipse.eclemma.internal.ui.coverageview.LinkWithSelectionHandler;
import org.eclipse.eclemma.internal.ui.coverageview.MaxTotalCache;
import org.eclipse.eclemma.internal.ui.coverageview.RefreshSessionHandler;
import org.eclipse.eclemma.internal.ui.coverageview.SelectCountersHandler;
import org.eclipse.eclemma.internal.ui.coverageview.SelectRootElementsHandler;
import org.eclipse.eclemma.internal.ui.coverageview.SelectionTracker;
import org.eclipse.eclemma.internal.ui.coverageview.ViewSettings;
import org.eclipse.jdt.ui.actions.OpenAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.handlers.CollapseAllHandler;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.part.ViewPart;
import org.jacoco.core.analysis.ICounter;
import org.jacoco.core.analysis.ICoverageNode;

public class CoverageView
extends ViewPart
implements IShowInTarget {
    public static final String ID = "org.eclipse.eclemma.ui.CoverageView";
    public static final Object LOADING_ELEMENT = new Object();
    private final ViewSettings settings = new ViewSettings();
    private final CellTextConverter cellTextConverter = new CellTextConverter(this.settings);
    private final MaxTotalCache maxTotalCache = new MaxTotalCache(this.settings);
    protected static final int COLUMN_ELEMENT = 0;
    protected static final int COLUMN_RATIO = 1;
    protected static final int COLUMN_COVERED = 2;
    protected static final int COLUMN_MISSED = 3;
    protected static final int COLUMN_TOTAL = 4;
    private TreeViewer viewer;
    private OpenAction openAction;
    private final List<IHandler> handlers = new ArrayList<IHandler>();
    private SelectionTracker selectiontracker;
    private CoverageViewSorter sorter = new CoverageViewSorter(this.settings, this);
    private final ISessionListener descriptionUpdater = new ISessionListener(){

        public void sessionActivated(ICoverageSession session) {
            CoverageView.this.getViewSite().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    ICoverageSession active = CoverageTools.getSessionManager().getActiveSession();
                    CoverageView.this.setContentDescription(active == null ? "" : active.getDescription());
                }
            });
        }

        public void sessionAdded(ICoverageSession addedSession) {
        }

        public void sessionRemoved(ICoverageSession removedSession) {
        }
    };
    private final IJavaCoverageListener coverageListener = new IJavaCoverageListener(){

        public void coverageChanged() {
            CoverageView.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    CoverageView.this.maxTotalCache.reset();
                    CoverageView.this.viewer.setInput((Object)CoverageTools.getJavaModelCoverage());
                }
            });
        }
    };

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.settings.init(memento);
    }

    public void saveState(IMemento memento) {
        this.settings.storeColumnWidth(this.viewer);
        this.settings.save(memento);
        super.saveState(memento);
    }

    public void createPartControl(Composite parent) {
        ContextHelp.setHelp((Control)parent, "org.eclipse.eclemma.ui.coverage_view_context");
        Tree tree = new Tree(parent, 2);
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        this.viewer = new TreeViewer(tree);
        TreeViewerColumn column0 = new TreeViewerColumn(this.viewer, 16384);
        column0.setLabelProvider(new CellLabelProvider(){
            private final ILabelProvider delegate = new WorkbenchLabelProvider();

            public void update(ViewerCell cell) {
                if (cell.getElement() == LOADING_ELEMENT) {
                    cell.setText(UIMessages.CoverageView_loadingMessage);
                    cell.setImage(null);
                } else {
                    cell.setText(CoverageView.this.cellTextConverter.getElementName(cell.getElement()));
                    cell.setImage(this.delegate.getImage(cell.getElement()));
                }
            }
        });
        this.sorter.addColumn(column0, 0);
        final TreeViewerColumn column1 = new TreeViewerColumn(this.viewer, 131072);
        column1.setLabelProvider((CellLabelProvider)new OwnerDrawLabelProvider(){

            public void update(ViewerCell cell) {
                if (cell.getElement() == LOADING_ELEMENT) {
                    cell.setText("");
                } else {
                    cell.setText(CoverageView.this.cellTextConverter.getRatio(cell.getElement()));
                }
            }

            protected void erase(Event event, Object element) {
            }

            protected void measure(Event event, Object element) {
            }

            protected void paint(Event event, Object element) {
                ICoverageNode coverage = CoverageTools.getCoverageInfo((Object)element);
                if (coverage != null) {
                    ICounter counter = coverage.getCounter(CoverageView.this.settings.getCounters());
                    RedGreenBar.draw(event, column1.getColumn().getWidth(), counter, CoverageView.this.maxTotalCache.getMaxTotal(element));
                }
            }
        });
        this.sorter.addColumn(column1, 1);
        TreeViewerColumn column2 = new TreeViewerColumn(this.viewer, 131072);
        column2.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                if (cell.getElement() == LOADING_ELEMENT) {
                    cell.setText("");
                } else {
                    cell.setText(CoverageView.this.cellTextConverter.getCovered(cell.getElement()));
                }
            }
        });
        this.sorter.addColumn(column2, 2);
        TreeViewerColumn column3 = new TreeViewerColumn(this.viewer, 131072);
        column3.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                if (cell.getElement() == LOADING_ELEMENT) {
                    cell.setText("");
                } else {
                    cell.setText(CoverageView.this.cellTextConverter.getMissed(cell.getElement()));
                }
            }
        });
        this.sorter.addColumn(column3, 3);
        TreeViewerColumn column4 = new TreeViewerColumn(this.viewer, 131072);
        column4.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                if (cell.getElement() == LOADING_ELEMENT) {
                    cell.setText("");
                } else {
                    cell.setText(CoverageView.this.cellTextConverter.getTotal(cell.getElement()));
                }
            }
        });
        this.sorter.addColumn(column4, 4);
        this.viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element == LOADING_ELEMENT) {
                    return true;
                }
                ICoverageNode c = CoverageTools.getCoverageInfo((Object)element);
                if (c == null) {
                    return false;
                }
                ICounter instructions = c.getInstructionCounter();
                if (instructions.getTotalCount() == 0) {
                    return false;
                }
                return !CoverageView.this.settings.getHideUnusedElements() || instructions.getCoveredCount() != 0;
            }
        });
        this.settings.updateColumnHeaders(this.viewer);
        this.settings.restoreColumnWidth(this.viewer);
        this.viewer.setComparator((ViewerComparator)this.sorter);
        this.viewer.setContentProvider((IContentProvider)new CoveredElementsContentProvider(this.settings));
        this.viewer.setInput((Object)CoverageTools.getJavaModelCoverage());
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.selectiontracker = new SelectionTracker((IViewPart)this, (StructuredViewer)this.viewer);
        this.createHandlers();
        this.createActions();
        this.viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                CoverageView.this.openAction.run((IStructuredSelection)event.getSelection());
            }
        });
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        tree.setMenu(menuMgr.createContextMenu((Control)tree));
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
        CoverageTools.getSessionManager().addSessionListener(this.descriptionUpdater);
        CoverageTools.addJavaCoverageListener((IJavaCoverageListener)this.coverageListener);
    }

    private void createHandlers() {
        this.activateHandler("org.eclipse.eclemma.ui.selectRootElements", (IHandler)new SelectRootElementsHandler(this.settings, this));
        this.activateHandler("org.eclipse.eclemma.ui.selectCounters", (IHandler)new SelectCountersHandler(this.settings, this));
        this.activateHandler("org.eclipse.eclemma.ui.hideUnusedElements", (IHandler)new HideUnusedElementsHandler(this.settings, this));
        this.activateHandler("org.eclipse.ui.edit.copy", (IHandler)new CopyHandler(this.settings, this.getSite().getShell().getDisplay(), (ISelectionProvider)this.viewer));
        this.activateHandler("org.eclipse.ui.file.refresh", (IHandler)new RefreshSessionHandler(CoverageTools.getSessionManager()));
        this.activateHandler("org.eclipse.ui.navigate.collapseAll", (IHandler)new CollapseAllHandler((AbstractTreeViewer)this.viewer));
        this.activateHandler("org.eclipse.eclemma.ui.linkWithSelection", (IHandler)new LinkWithSelectionHandler(this.settings, this.selectiontracker));
    }

    private void activateHandler(String id, IHandler handler) {
        IHandlerService hs = (IHandlerService)this.getSite().getService(IHandlerService.class);
        hs.activateHandler(id, handler);
        this.handlers.add(handler);
    }

    private void createActions() {
        IActionBars ab = this.getViewSite().getActionBars();
        this.openAction = new OpenAction((IWorkbenchSite)this.getSite());
        this.openAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.open.editor");
        ab.setGlobalActionHandler("org.eclipse.jdt.ui.actions.Open", (IAction)this.openAction);
        this.openAction.setEnabled(false);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.openAction);
        PropertyDialogAction propertiesAction = new PropertyDialogAction((IShellProvider)this.getSite(), (ISelectionProvider)this.viewer);
        propertiesAction.setActionDefinitionId("org.eclipse.ui.file.properties");
        ab.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)propertiesAction);
        propertiesAction.setEnabled(false);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)propertiesAction);
    }

    public void setFocus() {
        this.viewer.getTree().setFocus();
    }

    public void dispose() {
        for (IHandler h : this.handlers) {
            h.dispose();
        }
        this.handlers.clear();
        CoverageTools.removeJavaCoverageListener((IJavaCoverageListener)this.coverageListener);
        CoverageTools.getSessionManager().removeSessionListener(this.descriptionUpdater);
        this.selectiontracker.dispose();
        super.dispose();
    }

    protected void refreshViewer() {
        this.maxTotalCache.reset();
        this.settings.updateColumnHeaders(this.viewer);
        this.viewer.refresh();
    }

    public boolean show(ShowInContext context) {
        ISelection selection = context.getSelection();
        if (selection instanceof IStructuredSelection) {
            this.viewer.setSelection(selection);
            return true;
        }
        return false;
    }
}

