/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.tools.emf.ui.common.IClassContributionProvider;
import org.eclipse.e4.tools.emf.ui.common.ProviderStatus;
import org.eclipse.e4.tools.emf.ui.common.ResourceSearchScope;
import org.eclipse.e4.tools.emf.ui.internal.Messages;
import org.eclipse.e4.tools.emf.ui.internal.common.ClassContributionCollector;
import org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs.AbstractIconDialogWithScopeAndFilter;
import org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs.BundleImageCache;
import org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs.ContributionDataFile;
import org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs.SaveDialogBoundsSettingsDialog;
import org.eclipse.e4.tools.emf.ui.internal.common.component.tabs.empty.E;
import org.eclipse.e4.tools.emf.ui.internal.common.component.tabs.empty.TitleAreaFilterDialog;
import org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.TargetPlatformClassContributionCollector;
import org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.TargetPlatformContributionCollector;
import org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.TargetPlatformIconContributionCollector;
import org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.dialogs.NonReferencedResourceDialog;
import org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.dialogs.NonReferencedResourceWizard;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.core.text.bundle.BundleModel;
import org.eclipse.pde.internal.core.text.bundle.ImportPackageHeader;
import org.eclipse.pde.internal.core.text.bundle.ImportPackageObject;
import org.eclipse.pde.internal.core.text.bundle.RequireBundleHeader;
import org.eclipse.pde.internal.core.text.bundle.RequireBundleObject;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class FilteredContributionDialog
extends SaveDialogBoundsSettingsDialog {
    private static final int MAX_RESULTS = 500;
    private Image contributionTypeImage;
    private TableViewer viewer;
    private static final String PREF_SEARCHSCOPE = "searchScope";
    private ResourceSearchScope searchScope = ResourceSearchScope.PROJECT;
    private static final String PREF_SEARCHSCOPES = "searchScopes";
    private EnumSet<ResourceSearchScope> searchScopes = EnumSet.of(ResourceSearchScope.PROJECT);
    protected ClassContributionCollector collector;
    private Text textBox;
    private Button btnFilterNone;
    private Button btnFilterBundle;
    private Button btnFilterPackage;
    private List<String> filterBundles;
    private List<String> filterPackages;
    private Button btnFilterLocation;
    private List<String> filterLocations;
    private Button btnClearCache;
    private final IEclipseContext context;
    private Composite compOptions;
    protected boolean includeNonBundles;
    private Label lblStatus;
    private Button btnIncludeNoneBundle;
    private WritableList<IClassContributionProvider.ContributionData> viewerList;
    protected BundleImageCache imageCache;
    protected Job currentSearchThread;
    private ContributionResultHandlerImpl currentResultHandler;
    protected ProviderStatus providerStatus;
    protected int hint;
    protected int maxResults;
    protected boolean searching;

    protected abstract ClassContributionCollector getCollector();

    protected abstract String getFilterTextMessage();

    protected abstract String getResourceNameText();

    protected abstract String getDialogMessage();

    protected abstract String getDialogTitle();

    protected abstract String getShellTitle();

    private void updateStatusMessage() {
        String message = "";
        if (this.searching) {
            message = String.valueOf(message) + Messages.FilteredContributionDialog_Searching;
        }
        if (this.hint != 0) {
            message = this.hint == -2 ? String.valueOf(message) + Messages.FilteredContributionDialog_SearchWasCancelled : String.valueOf(message) + Messages.FilteredContributionDialog_MoreThan + this.maxResults + Messages.FilteredContributionDialog_itemsWereFound;
        }
        if (this.getCollector() instanceof TargetPlatformContributionCollector && this.providerStatus != null) {
            switch (this.providerStatus) {
                case READY: {
                    break;
                }
                case INITIALIZING: {
                    message = String.valueOf(message) + Messages.FilteredContributionDialog_ProviderInitializing;
                    break;
                }
                case CANCELLED: {
                    message = String.valueOf(message) + Messages.FilteredContributionDialog_ProviderWasCancelled;
                }
            }
        }
        this.setMessage(message);
    }

    @Override
    public boolean close() {
        this.stopSearchThread(true);
        this.getPreferences().put(PREF_SEARCHSCOPE, this.searchScope.toString());
        this.getPreferences().put(PREF_SEARCHSCOPES, this.searchScopes.toString());
        return super.close();
    }

    protected Control createContents(Composite parent) {
        Control ret = super.createContents(parent);
        this.textBox.notifyListeners(24, new Event());
        this.textBox.setFocus();
        return ret;
    }

    public FilteredContributionDialog(Shell parentShell, IEclipseContext context) {
        super(parentShell);
        this.context = context;
        this.imageCache = new BundleImageCache((Display)context.get(Display.class), ((Object)((Object)this)).getClass().getClassLoader());
        String searchScopeString = this.getPreferences().get(PREF_SEARCHSCOPE, ResourceSearchScope.PROJECT.toString());
        this.searchScope = ResourceSearchScope.valueOf(searchScopeString);
        String searchScopesString = this.getPreferences().get(PREF_SEARCHSCOPES, EnumSet.of(ResourceSearchScope.PROJECT).toString());
        this.searchScopes = FilteredContributionDialog.valueOf(ResourceSearchScope.class, searchScopesString);
    }

    public static <TheType extends Enum<TheType>> EnumSet<TheType> valueOf(Class<TheType> eClass, String str) {
        String[] arr = str.substring(1, str.length() - 1).split(",");
        EnumSet<TheType> set = EnumSet.noneOf(eClass);
        String[] stringArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            String e = stringArray[n2];
            set.add(Enum.valueOf(eClass, e.trim()));
            ++n2;
        }
        return set;
    }

    public void setStatus(String message) {
        this.getShell().getDisplay().asyncExec(() -> this.lblStatus.setText(message));
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, Messages.FilteredContributionDialog_Select, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        ((GridLayout)parent.getLayout()).numColumns = 4;
        this.btnClearCache = new Button(parent, 8);
        this.btnClearCache.setText(Messages.FilteredContributionDialog_ClearCache);
        this.btnClearCache.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilteredContributionDialog.this.getCollector().clearModelCache();
            }
        });
        this.btnClearCache.moveAbove((Control)this.getButton(0));
        this.lblStatus = new Label(parent, 0);
        this.lblStatus.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.lblStatus.setText("");
        this.lblStatus.moveAbove((Control)this.btnClearCache);
        this.updateUiState();
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = (Composite)super.createDialogArea(parent);
        this.getShell().addDisposeListener(e -> {
            this.imageCache.dispose();
            if (!this.contributionTypeImage.isDisposed()) {
                this.contributionTypeImage.dispose();
            }
            if (this.getTitleImageLabel().getImage() != null && !this.getTitleImage().isDisposed()) {
                this.getTitleImageLabel().getImage().dispose();
            }
        });
        this.getShell().setText(this.getShellTitle());
        this.setTitle(this.getDialogTitle());
        this.setMessage(this.getDialogMessage());
        Image titleImage = this.getTitleImage();
        this.setTitleImage(titleImage);
        this.contributionTypeImage = this.imageCache.create("/icons/full/obj16/class_obj.png");
        this.compOptions = new Composite(comp, 0);
        this.compOptions.setLayoutData((Object)new GridData(1808));
        this.compOptions.setLayout((Layout)new GridLayout(2, false));
        this.createOptions(this.compOptions);
        Label l = new Label(this.compOptions, 0);
        l.setText(this.getResourceNameText());
        this.textBox = new Text(this.compOptions, 2688);
        this.textBox.setLayoutData((Object)new GridData(768));
        this.textBox.setMessage(this.getFilterTextMessage());
        new Label(this.compOptions, 0);
        this.rebuildViewer();
        this.collector = this.getCollector();
        this.textBox.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002 && FilteredContributionDialog.this.viewer.getTable().getItemCount() > 0) {
                    FilteredContributionDialog.this.viewer.getTable().setFocus();
                    FilteredContributionDialog.this.viewer.getTable().select(0);
                }
            }
        });
        this.viewer.getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                super.keyPressed(e);
                if (e.keyCode == 0x1000001 && FilteredContributionDialog.this.viewer.getTable().getSelectionIndex() == 0) {
                    FilteredContributionDialog.this.textBox.setFocus();
                }
            }
        });
        this.textBox.addModifyListener(e -> {
            this.stopSearchThread(true);
            this.setMessage("");
            this.viewerList.clear();
            if (this.doSearch()) {
                return;
            }
            this.searching = true;
            this.updateStatusMessage();
            this.currentSearchThread = new Job(Messages.FilteredContributionDialog_ContributionSearch){
                IClassContributionProvider.Filter filter;

                protected IStatus run(IProgressMonitor monitor) {
                    monitor.beginTask(Messages.FilteredContributionDialog_ContributionSearch, -1);
                    FilteredContributionDialog.this.currentResultHandler = new ContributionResultHandlerImpl((IObservableList<IClassContributionProvider.ContributionData>)FilteredContributionDialog.this.viewerList);
                    FilteredContributionDialog.this.getShell().getDisplay().syncExec(() -> {
                        this.filter = FilteredContributionDialog.this.searchScopes.contains((Object)ResourceSearchScope.PROJECT) ? new IClassContributionProvider.Filter((IProject)FilteredContributionDialog.this.context.get(IProject.class), FilteredContributionDialog.this.textBox.getText()) : new IClassContributionProvider.Filter((IProject)FilteredContributionDialog.this.context.get(IProject.class), FilteredContributionDialog.this.textBox.getText());
                    });
                    this.filter.maxResults = 500;
                    this.filter.userData = FilteredContributionDialog.this;
                    this.filter.setBundles(FilteredContributionDialog.this.filterBundles);
                    this.filter.setPackages(FilteredContributionDialog.this.filterPackages);
                    this.filter.setLocations(FilteredContributionDialog.this.filterLocations);
                    this.filter.setSearchScope(FilteredContributionDialog.this.searchScopes);
                    this.filter.setIncludeNonBundles(FilteredContributionDialog.this.includeNonBundles);
                    this.filter.setProgressMonitor(monitor);
                    this.filter.setProviderStatusCallback(status -> {
                        FilteredContributionDialog.this.providerStatus = status;
                        try {
                            FilteredContributionDialog.this.getShell().getDisplay().syncExec(() -> {
                                FilteredContributionDialog.this.updateStatusMessage();
                                switch (status) {
                                    case READY: {
                                        FilteredContributionDialog.this.currentSearchThread = null;
                                        if (FilteredContributionDialog.this.currentResultHandler != null) {
                                            FilteredContributionDialog.this.currentResultHandler.cancled = true;
                                        }
                                        FilteredContributionDialog.this.refreshSearch();
                                        break;
                                    }
                                }
                            });
                        }
                        catch (Exception exception) {}
                    });
                    FilteredContributionDialog.this.collector.findContributions(this.filter, FilteredContributionDialog.this.currentResultHandler);
                    monitor.done();
                    FilteredContributionDialog.this.searching = false;
                    FilteredContributionDialog.this.currentSearchThread = null;
                    FilteredContributionDialog.this.getShell().getDisplay().syncExec(() -> FilteredContributionDialog.this.updateStatusMessage());
                    return Status.OK_STATUS;
                }
            };
            this.currentSearchThread.schedule();
        });
        return comp;
    }

    protected Image getTitleImage() {
        return this.imageCache.create("/icons/full/wizban/newsearch_wiz.gif");
    }

    protected void createOptions(Composite compOptions) {
        Label lblScope = new Label(compOptions, 0);
        lblScope.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        lblScope.setText(Messages.FilteredContributionDialog_Scope);
        Composite compScope = new Composite(compOptions, 0);
        compScope.setLayoutData((Object)new GridData(1, 128, false, false));
        compScope.setLayout((Layout)new RowLayout());
        final Button btnScopeProject = new Button(compScope, 16);
        btnScopeProject.setText(Messages.FilteredContributionDialog_ProjectOnly);
        btnScopeProject.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (btnScopeProject.getSelection()) {
                    FilteredContributionDialog.this.searchScope = ResourceSearchScope.PROJECT;
                    FilteredContributionDialog.this.searchScopes = EnumSet.of(ResourceSearchScope.PROJECT);
                    FilteredContributionDialog.this.updateUiState();
                    FilteredContributionDialog.this.getCollector();
                    FilteredContributionDialog.this.refreshSearch();
                }
            }
        });
        btnScopeProject.setSelection(this.searchScopes.contains((Object)ResourceSearchScope.PROJECT) && !this.searchScopes.contains((Object)ResourceSearchScope.REFERENCES));
        final Button btnProjectAndReferences = new Button(compScope, 16);
        btnProjectAndReferences.setText(Messages.FilteredContributionDialog_ProjectAndReferences);
        btnProjectAndReferences.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (btnProjectAndReferences.getSelection()) {
                    FilteredContributionDialog.this.searchScope = ResourceSearchScope.PROJECT;
                    FilteredContributionDialog.this.searchScopes = EnumSet.of(ResourceSearchScope.PROJECT, ResourceSearchScope.REFERENCES);
                    FilteredContributionDialog.this.updateUiState();
                    FilteredContributionDialog.this.getCollector();
                    FilteredContributionDialog.this.refreshSearch();
                }
            }
        });
        btnProjectAndReferences.setSelection(this.searchScopes.contains((Object)ResourceSearchScope.PROJECT) && this.searchScopes.contains((Object)ResourceSearchScope.REFERENCES));
        final Button btnScopeWorkspace = new Button(compScope, 16);
        btnScopeWorkspace.setText(Messages.FilteredContributionDialog_Workspace);
        btnScopeWorkspace.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (btnScopeWorkspace.getSelection()) {
                    FilteredContributionDialog.this.searchScope = ResourceSearchScope.WORKSPACE;
                    FilteredContributionDialog.this.searchScopes = EnumSet.of(ResourceSearchScope.WORKSPACE);
                    FilteredContributionDialog.this.updateUiState();
                    FilteredContributionDialog.this.getCollector();
                    FilteredContributionDialog.this.refreshSearch();
                }
            }
        });
        btnScopeWorkspace.setSelection(this.searchScopes.contains((Object)ResourceSearchScope.WORKSPACE));
        final Button btnScopeTargetPlatform = new Button(compScope, 16);
        btnScopeTargetPlatform.setText(Messages.FilteredContributionDialog_TargetPlatform);
        btnScopeTargetPlatform.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (btnScopeTargetPlatform.getSelection()) {
                    FilteredContributionDialog.this.searchScope = ResourceSearchScope.TARGET_PLATFORM;
                    FilteredContributionDialog.this.searchScopes = EnumSet.of(ResourceSearchScope.TARGET_PLATFORM);
                    FilteredContributionDialog.this.updateUiState();
                    FilteredContributionDialog.this.getCollector();
                    FilteredContributionDialog.this.refreshSearch();
                }
            }
        });
        btnScopeTargetPlatform.setSelection(this.searchScopes.contains((Object)ResourceSearchScope.TARGET_PLATFORM));
        Label lblFilter = new Label(compOptions, 0);
        lblFilter.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        lblFilter.setText(Messages.FilteredContributionDialog_ScopeFilter);
        Composite compFilter = new Composite(compOptions, 0);
        compFilter.setLayoutData((Object)new GridData(1, 128, false, false));
        compFilter.setLayout((Layout)new RowLayout());
        this.btnFilterNone = new Button(compFilter, 32);
        this.btnFilterNone.setText(Messages.FilteredContributionDialog_None);
        this.btnFilterNone.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FilteredContributionDialog.this.btnFilterNone.getSelection()) {
                    FilteredContributionDialog.this.removeFilters();
                }
            }
        });
        this.btnFilterBundle = new Button(compFilter, 32);
        this.btnFilterBundle.setText(Messages.FilteredContributionDialog_Bundle);
        this.btnFilterBundle.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FilteredContributionDialog.this.btnFilterBundle.getSelection()) {
                    FilteredContributionDialog.this.showBundleFilter();
                } else {
                    FilteredContributionDialog.this.filterBundles = null;
                    FilteredContributionDialog.this.refreshSearch();
                    FilteredContributionDialog.this.updateUiState();
                }
            }
        });
        this.btnFilterPackage = new Button(compFilter, 32);
        this.btnFilterPackage.setText(Messages.FilteredContributionDialog_Package);
        this.btnFilterPackage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FilteredContributionDialog.this.btnFilterPackage.getSelection()) {
                    FilteredContributionDialog.this.showPackageFilter();
                } else {
                    FilteredContributionDialog.this.filterPackages = null;
                    FilteredContributionDialog.this.refreshSearch();
                    FilteredContributionDialog.this.updateUiState();
                }
            }
        });
        this.btnFilterLocation = new Button(compFilter, 32);
        this.btnFilterLocation.setText(Messages.FilteredContributionDialog_Location);
        this.btnFilterLocation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FilteredContributionDialog.this.btnFilterLocation.getSelection()) {
                    FilteredContributionDialog.this.showLocationFilter();
                } else {
                    FilteredContributionDialog.this.filterLocations = null;
                    FilteredContributionDialog.this.refreshSearch();
                    FilteredContributionDialog.this.updateUiState();
                }
            }
        });
        Label lblIncludeNoneBundle = new Label(compOptions, 0);
        lblIncludeNoneBundle.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        lblIncludeNoneBundle.setText(Messages.FilteredContributionDialog_NonBundles);
        this.btnIncludeNoneBundle = new Button(compOptions, 32);
        this.btnIncludeNoneBundle.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.btnIncludeNoneBundle.setText("");
        this.btnIncludeNoneBundle.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilteredContributionDialog.this.includeNonBundles = FilteredContributionDialog.this.btnIncludeNoneBundle.getSelection();
                FilteredContributionDialog.this.refreshSearch();
            }
        });
    }

    protected boolean doSearch() {
        return false;
    }

    protected void updateUiState() {
        this.btnFilterNone.setSelection(E.isEmpty(this.filterBundles) && E.isEmpty(this.filterPackages) && E.isEmpty(this.filterLocations));
        this.btnFilterBundle.setSelection(E.notEmpty(this.filterBundles));
        this.btnFilterPackage.setSelection(E.notEmpty(this.filterPackages));
        this.btnFilterLocation.setSelection(E.notEmpty(this.filterLocations));
        boolean enabled = !this.searchScopes.contains((Object)ResourceSearchScope.PROJECT);
        this.btnFilterNone.setEnabled(enabled);
        this.btnFilterBundle.setEnabled(enabled);
        this.btnFilterLocation.setEnabled(enabled);
        this.btnFilterPackage.setEnabled(enabled);
        this.btnClearCache.setEnabled(enabled);
        this.btnIncludeNoneBundle.setEnabled(enabled);
    }

    protected void removeFilters() {
        this.filterBundles = null;
        this.setFilterPackages(null);
        this.filterLocations = null;
        this.refreshSearch();
        this.updateUiState();
    }

    protected boolean isResizable() {
        return true;
    }

    public List<String> getFilterPackages() {
        return this.filterPackages;
    }

    public void setFilterPackages(List<String> filterPackages) {
        this.filterPackages = filterPackages;
    }

    public List<String> getFilterLocations() {
        return this.filterLocations;
    }

    public void setFilterLocations(List<String> filterLocations) {
        this.filterLocations = filterLocations;
    }

    public List<String> getFilterBundles() {
        return this.filterBundles;
    }

    public void setFilterBundles(List<String> filterBundles) {
        this.filterBundles = filterBundles;
    }

    protected void refreshSearch() {
        this.textBox.notifyListeners(24, new Event());
    }

    protected void showBundleFilter() {
        Collection<String> bundleIds;
        if (this.getCollector() instanceof TargetPlatformClassContributionCollector) {
            bundleIds = TargetPlatformClassContributionCollector.getInstance().getBundleIds();
        } else if (this.getCollector() instanceof TargetPlatformIconContributionCollector) {
            bundleIds = TargetPlatformIconContributionCollector.getInstance().getBundleIds();
        } else {
            return;
        }
        final ArrayList<String> sorted = new ArrayList<String>(bundleIds);
        Collections.sort(sorted);
        TitleAreaFilterDialog dlg = new TitleAreaFilterDialog(this.getShell(), (ILabelProvider)new ColumnLabelProvider()){

            protected Control createContents(Composite parent) {
                Control ret = super.createContents(parent);
                this.getViewer().setInput((Object)sorted);
                this.setMessage(Messages.FilteredContributionDialog_SelectTheBundle);
                this.setTitle(Messages.FilteredContributionDialog_BundleFilter);
                this.getShell().setText(Messages.FilteredContributionDialog_BundleFilter);
                try {
                    this.setTitleImage(FilteredContributionDialog.this.imageCache.create("/icons/full/wizban/plugin_wiz.gif"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return ret;
            }
        };
        if (dlg.open() == 0) {
            ArrayList<String> result = new ArrayList<String>();
            result.add(dlg.getFirstSelection());
            this.setFilterBundles(result);
            this.refreshSearch();
        }
        this.updateUiState();
    }

    protected void showPackageFilter() {
        Collection<String> packages;
        if (this.getCollector() instanceof TargetPlatformClassContributionCollector) {
            packages = TargetPlatformClassContributionCollector.getInstance().getPackages();
        } else if (this.getCollector() instanceof TargetPlatformIconContributionCollector) {
            packages = TargetPlatformIconContributionCollector.getInstance().getPackages();
        } else {
            return;
        }
        final ArrayList<String> sorted = new ArrayList<String>(packages);
        Collections.sort(sorted);
        TitleAreaFilterDialog dlg = new TitleAreaFilterDialog(this.getShell(), (ILabelProvider)new ColumnLabelProvider()){

            protected Control createContents(Composite parent) {
                Control ret = super.createContents(parent);
                this.getViewer().setInput((Object)sorted);
                this.setMessage(Messages.FilteredContributionDialog_SelectThePackage);
                this.setTitle(Messages.FilteredContributionDialog_PackageFilter);
                this.getShell().setText(Messages.FilteredContributionDialog_PackageFilter);
                this.setTitleImage(FilteredContributionDialog.this.imageCache.create("/icons/full/wizban/package_wiz.png"));
                return ret;
            }
        };
        if (dlg.open() == 0) {
            ArrayList<String> result = new ArrayList<String>();
            result.add(dlg.getFirstSelection());
            this.setFilterBundles(result);
            this.refreshSearch();
        }
        this.updateUiState();
    }

    public ResourceSearchScope getScope() {
        return this.searchScope;
    }

    public void setScope(ResourceSearchScope scope) {
        this.searchScope = scope;
    }

    public void setCollector(ClassContributionCollector collector) {
        this.collector = collector;
    }

    protected void showLocationFilter() {
        Collection<String> locations;
        if (this.getCollector() instanceof TargetPlatformClassContributionCollector) {
            locations = TargetPlatformClassContributionCollector.getInstance().getLocations();
        } else if (this.getCollector() instanceof TargetPlatformIconContributionCollector) {
            locations = TargetPlatformIconContributionCollector.getInstance().getLocations();
        } else {
            return;
        }
        HashSet<String> parentLocations = new HashSet<String>();
        for (String location : locations) {
            if (location.endsWith(".jar")) {
                int index = location.lastIndexOf(File.separator);
                if (index < 0) continue;
                location = location.substring(0, index);
                parentLocations.add(location);
                continue;
            }
            parentLocations.add(location);
        }
        final ArrayList sorted = new ArrayList(parentLocations);
        Collections.sort(sorted);
        TitleAreaFilterDialog dlg = new TitleAreaFilterDialog(this.getShell(), (ILabelProvider)new ColumnLabelProvider()){

            protected Control createContents(Composite parent) {
                Control ret = super.createContents(parent);
                this.getViewer().setInput((Object)sorted);
                this.setMessage(Messages.FilteredContributionDialog_SelectTheLocation);
                this.setTitle(Messages.FilteredContributionDialog_LocationFilter);
                this.getShell().setText(Messages.FilteredContributionDialog_LocationFilter);
                this.setTitleImage(FilteredContributionDialog.this.imageCache.create("/icons/full/wizban/location_wiz.png"));
                return ret;
            }
        };
        if (dlg.open() == 0) {
            ArrayList<String> result = new ArrayList<String>();
            result.add(dlg.getFirstSelection());
            this.setFilterBundles(result);
            this.refreshSearch();
        }
        this.updateUiState();
    }

    protected void rebuildViewer() {
        this.viewerList = new WritableList();
        TableViewer oldViewer = this.viewer;
        this.viewer = new TableViewer(this.compOptions, 67584);
        if (oldViewer != null) {
            this.viewer.getTable().moveAbove((Control)oldViewer.getTable());
            oldViewer.getTable().dispose();
        }
        GridData gd = new GridData(1808);
        this.viewer.getControl().setLayoutData((Object)gd);
        this.viewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new StyledCellLabelProvider(){

            public void update(ViewerCell cell) {
                IClassContributionProvider.ContributionData data;
                if (cell.getElement() instanceof IClassContributionProvider.ContributionData) {
                    data = (IClassContributionProvider.ContributionData)cell.getElement();
                } else if (cell.getElement() instanceof ContributionDataFile) {
                    data = ((ContributionDataFile)cell.getElement()).getContributionData();
                } else {
                    return;
                }
                StyledString styledString = new StyledString();
                if (data.className != null) {
                    styledString.append(data.className, null);
                }
                if (data.bundleName != null) {
                    styledString.append(" - " + data.bundleName, StyledString.DECORATIONS_STYLER);
                } else if (data.installLocation != null) {
                    styledString.append(" - " + data.installLocation, StyledString.DECORATIONS_STYLER);
                }
                if (data.sourceType != null) {
                    styledString.append(" - ", StyledString.DECORATIONS_STYLER);
                    styledString.append(String.valueOf(data.sourceType), StyledString.COUNTER_STYLER);
                }
                if (data.iconPath == null) {
                    cell.setImage(FilteredContributionDialog.this.contributionTypeImage);
                }
                cell.setText(styledString.getString());
                cell.setStyleRanges(styledString.getStyleRanges());
            }
        });
        this.viewer.addDoubleClickListener(event -> this.okPressed());
        this.viewer.setInput(this.viewerList);
        if (oldViewer != null) {
            this.getViewer().getTable().getParent().layout(true, true);
            this.getViewer().getTable().getParent().redraw();
        }
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    public void setViewer(TableViewer viewer) {
        this.viewer = viewer;
    }

    protected Text getFilterTextBox() {
        return this.textBox;
    }

    public ResourceSearchScope getSearchScope() {
        return this.searchScope;
    }

    protected IFile getSelectedIfile() {
        IStructuredSelection s = (IStructuredSelection)this.getViewer().getSelection();
        if (!s.isEmpty()) {
            Object selected = s.getFirstElement();
            if (selected instanceof IClassContributionProvider.ContributionData) {
                IClassContributionProvider.ContributionData contributionData = (IClassContributionProvider.ContributionData)selected;
                return new ContributionDataFile(contributionData);
            }
            if (selected instanceof IFile) {
                return (IFile)selected;
            }
            if (selected instanceof AbstractIconDialogWithScopeAndFilter.Entry) {
                AbstractIconDialogWithScopeAndFilter.Entry entry = (AbstractIconDialogWithScopeAndFilter.Entry)selected;
                IClassContributionProvider.ContributionData cd = new IClassContributionProvider.ContributionData(null, null, Messages.FilteredContributionDialog_Java, entry.file.getFullPath().toOSString());
                cd.installLocation = entry.installLocation;
                cd.resourceRelativePath = entry.file.getProjectRelativePath().toOSString();
                return new ContributionDataFile(cd);
            }
        }
        return null;
    }

    protected IFile checkResourceAccessible(IFile file, String installLocation) {
        if (file == null) {
            return null;
        }
        String bundle = FilteredContributionDialog.getBundle(file);
        if (bundle == null) {
            String message = Messages.FilteredContributionDialog_ResourceIsNotContainedInABundle;
            NonReferencedResourceWizard wizard = new NonReferencedResourceWizard(this.getShell(), (IProject)this.context.get(IProject.class), bundle, file, installLocation, this.context);
            wizard.setMessage(message);
            WizardDialog wizDlg = new WizardDialog(this.getShell(), (IWizard)wizard);
            wizDlg.setBlockOnOpen(true);
            if (wizDlg.open() == 0) {
                return wizard.getResult();
            }
            return null;
        }
        IProject currentProject = (IProject)this.context.get(IProject.class);
        if (currentProject != null && !FilteredContributionDialog.getBundle(currentProject).equals(bundle)) {
            boolean found;
            block13: {
                found = false;
                try {
                    BundleModel model = this.loadBundleModel(currentProject);
                    RequireBundleHeader rbh = (RequireBundleHeader)model.getBundle().getManifestHeader("Require-Bundle");
                    if (rbh != null) {
                        RequireBundleObject[] requireBundleObjectArray = rbh.getRequiredBundles();
                        int n = requireBundleObjectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            RequireBundleObject item = requireBundleObjectArray[n2];
                            if (item.getValue().equals(bundle)) {
                                found = true;
                                break;
                            }
                            ++n2;
                        }
                    }
                    if (found || !(file instanceof ContributionDataFile)) break block13;
                    ContributionDataFile cdFile = (ContributionDataFile)file;
                    String className = cdFile.getContributionData().className;
                    if (className == null) break block13;
                    String pakage = NonReferencedResourceDialog.getPackageFromClassName(className);
                    ImportPackageHeader iph = (ImportPackageHeader)model.getBundle().getManifestHeader("Import-Package");
                    if (iph == null) break block13;
                    ImportPackageObject[] importPackageObjectArray = iph.getPackages();
                    int n = importPackageObjectArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        ImportPackageObject item = importPackageObjectArray[n3];
                        if (item.getValue().equals(pakage)) {
                            found = true;
                            break;
                        }
                        ++n3;
                    }
                }
                catch (Exception exception) {}
            }
            if (!found) {
                String message = Messages.FilteredContributionDialog_ResourceIsNotReferencedByThisBundle;
                NonReferencedResourceWizard wizard = new NonReferencedResourceWizard(this.getShell(), (IProject)this.context.get(IProject.class), bundle, file, installLocation, this.context);
                wizard.setMessage(message);
                WizardDialog wiz = new WizardDialog(this.getShell(), (IWizard)wizard);
                wiz.setBlockOnOpen(true);
                if (wiz.open() == 0) {
                    return wizard.getResult();
                }
                return null;
            }
        }
        return file;
    }

    public BundleModel loadBundleModel(IProject currentProject) throws CoreException {
        Document document = new Document();
        Throwable throwable = null;
        Object var4_5 = null;
        try (Scanner scanner = new Scanner(PDEProject.getManifest((IProject)currentProject).getContents());){
            String content = scanner.useDelimiter("\\Z").next();
            document.set(content);
            BundleModel model = new BundleModel((IDocument)document, false);
            model.load();
            return model;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected EnumSet<ResourceSearchScope> getSearchScopes() {
        return this.searchScopes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void stopSearchThread(boolean bJoin) {
        if (this.currentSearchThread == null) return;
        this.currentResultHandler.cancled = true;
        this.currentSearchThread.cancel();
        if (bJoin) {
            try {
                try {
                    if (this.currentSearchThread == null) return;
                    this.currentSearchThread.join();
                    return;
                }
                catch (InterruptedException interruptedException) {
                    this.currentSearchThread = null;
                }
                return;
            }
            finally {
                this.currentSearchThread = null;
            }
        } else {
            this.currentSearchThread = null;
        }
    }

    public static String getBundle(IFile file) {
        if (file instanceof ContributionDataFile) {
            ContributionDataFile cdFile = (ContributionDataFile)file;
            String ret = cdFile.getBundle();
            if (ret != null) {
                return ret;
            }
            if (cdFile.getContributionData().installLocation != null) {
                return FilteredContributionDialog.getBundle(cdFile.getContributionData().installLocation);
            }
            return null;
        }
        IProject project = file.getProject();
        return FilteredContributionDialog.getBundle(project);
    }

    /*
     * Exception decompiling
     */
    static String getBundle(IProject project) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 11[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static String getBundle(String rootDirectory) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 10[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private class ContributionResultHandlerImpl
    implements IClassContributionProvider.ContributionResultHandler {
        private boolean cancled = false;
        private final IObservableList<IClassContributionProvider.ContributionData> list;

        public ContributionResultHandlerImpl(IObservableList<IClassContributionProvider.ContributionData> list) {
            this.list = list;
        }

        @Override
        public void result(IClassContributionProvider.ContributionData data) {
            if (!this.cancled) {
                FilteredContributionDialog.this.getShell().getDisplay().syncExec(() -> {
                    boolean bl = this.list.add((Object)data);
                });
            }
        }

        @Override
        public void moreResults(int hint, IClassContributionProvider.Filter filter) {
            if (!this.cancled) {
                FilteredContributionDialog.this.getShell().getDisplay().syncExec(() -> {
                    FilteredContributionDialog dlg = (FilteredContributionDialog)((Object)((Object)filter.userData));
                    dlg.hint = hint;
                    dlg.maxResults = filter.maxResults;
                    dlg.updateStatusMessage();
                });
            }
        }
    }
}

