--
-- Copyright (C) 2022  <fastrgv@gmail.com>
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You may read the full text of the GNU General Public License
-- at <http://www.gnu.org/licenses/>.
--


with snd4ada;
with aliens;
with globals;
with ufo;

package body player is

procedure playerreset is
begin

	player.posX:=globals.screenwidth/2 - 3;
	player.posY:=globals.playerposy;
	player.speed:=2;
	player.missileX:=0;
	player.missileY:=0;
	player.missileFired:=0;

end playerreset;


procedure playermove(newPosX: integer) is
begin
	player.posX:=newPosX;
end playermove;

procedure playermoveright is
begin
	if player.posX<globals.screenwidth-globals.playerwidth-player.speed then
		playerMove(player.posX + player.speed);
	else
		playerMove(globals.screenwidth-globals.playerwidth);
	end if;
end playerMoveRight;


procedure playerMoveLeft is
begin
	if player.posX>0+player.speed then
		playerMove(player.posX - player.speed);
	else
		playerMove(0);
	end if;
end playerMoveLeft;



function playerHitCheck( hostileShotX, hostileShotY: integer) return integer is
	fplayerWasHit: integer := 0;
begin
	if hostileShotY=player.posY then
		if hostileShotX>=player.posX 
		and hostileShotX<=player.posX+globals.playerwidth-1 then
			fplayerWasHit:=1;
		end if;
	end if;
	return fplayerWasHit;
end playerHitCheck;

procedure playerLaunchMissile is
begin
	if player.missileFired=0 then --no other is on its way
		player.missileFired:=1;
		player.missileX := player.posX + globals.playerwidth/2;
		player.missileY := player.posY;
		snd4ada.playSnd(globals.myshoot);
	end if;
end playerLaunchMissile;

procedure playerReloadMissile is
begin
	player.missileFired:=0;
end playerReloadMissile;



procedure doscoring( alientype: integer ) is
	points : constant array(0..3) of integer := (500,200,150,100);
begin
	globals.score := globals.score + points(alientype);

	if (globals.score mod 6000)=0 then
		globals.lives:=globals.lives+1; -- get another life
	end if;

end doscoring;




function playerMoveMissile return integer is
	ret, fNoAliensLeft, alienTypeHit: integer := 0;
begin
	if player.missileFired=1 then
		player.missileY
			:= player.missileY-1;
		if player.missileY<0 then -- went offscreen
			playerReloadMissile;
		end if;

		alienTypeHit:=aliens.aliensHitCheck(player.missileX,player.missileY);
		if alienTypeHit /= 0 then --player missile hits an alien
			doScoring(alienTypeHit);
			playerReloadMissile;

			aliens.analyze;
			if globals.shipnum=0 then fNoAliensLeft:=1; end if;

		end if;

		-- if hit, next line deletes element from bunker array:
		ret := aliens.bunkersHitCheck(player.missileX,player.missileY);
		if ret = 1 then -- player missile hits a bunker
			playerReloadMissile;
		end if;

		ret := ufo.ufoHitCheck(player.missileX, player.missileY);
		if ret = 1 then -- player missile hits the UFO
			--ufo.ufoReset; now done inside ufoHitCheck
			null;
		end if;

	end if;

	return fNoAliensLeft;

end playerMoveMissile;


procedure playerExplode is
begin
	null;
end playerExplode;

end player;

