/*
 * Decompiled with CFR 0.152.
 */
package settings;

import application.Shutter;
import application.VideoPlayer;
import library.EXIFTOOL;
import library.FFPROBE;

public class Timecode
extends Shutter {
    public static String setTimecode() {
        if (grpSetTimecode.isVisible()) {
            String dropFrame = ":";
            if (Timecode.isDropFrame()) {
                dropFrame = ";";
            }
            if (Shutter.caseConform.isSelected()) {
                dropFrame = Shutter.comboFPS.getSelectedItem().toString().equals("29,97") || Shutter.comboFPS.getSelectedItem().toString().equals("59,94") ? ";" : ":";
            }
            if (caseGenerateFromDate.isSelected()) {
                String[] s = EXIFTOOL.creationHours.split(":");
                return " -timecode \"" + s[0] + ":" + s[1] + ":" + s[2] + dropFrame + "00" + '\"';
            }
            if (caseSetTimecode.isSelected()) {
                return " -timecode \"" + TCset1.getText() + ":" + TCset2.getText() + ":" + TCset3.getText() + dropFrame + TCset4.getText() + '\"';
            }
            if (FFPROBE.timecode1 != "") {
                return " -timecode \"" + FFPROBE.timecode1 + ":" + FFPROBE.timecode2 + ":" + FFPROBE.timecode3 + dropFrame + FFPROBE.timecode4 + '\"';
            }
        }
        return "";
    }

    public static boolean isDropFrame() {
        return !FFPROBE.dropFrameTC.equals(":") && (FFPROBE.currentFPS == 29.97f || FFPROBE.currentFPS == 59.94f);
    }

    public static boolean isNonDropFrame() {
        return FFPROBE.dropFrameTC.equals(":") && (FFPROBE.currentFPS == 29.97f || FFPROBE.currentFPS == 59.94f) || FFPROBE.currentFPS == 23.98f;
    }

    public static float setNonDropFrameTC(float currentFrame) {
        if (Timecode.isNonDropFrame() && currentFrame > 0.0f) {
            float currentTime = VideoPlayer.playerCurrentFrame * VideoPlayer.inputFramerateMS;
            if (FFPROBE.currentFPS == 23.98f) {
                currentFrame = (float)((double)currentFrame - ((double)currentTime * 0.024 / 1000.0 - 1.0));
            }
            if (FFPROBE.currentFPS == 29.97f) {
                currentFrame = (float)((double)currentFrame - ((double)currentTime * 0.03 / 1000.0 - 1.0));
            } else if (FFPROBE.currentFPS == 59.94f) {
                currentFrame = (float)((double)currentFrame - ((double)currentTime * 0.06 / 1000.0 - 1.0));
            }
        }
        return currentFrame;
    }

    public static float getNonDropFrameTC(float currentFrame) {
        if (Timecode.isNonDropFrame()) {
            float currentTime = currentFrame * VideoPlayer.inputFramerateMS;
            if (FFPROBE.currentFPS == 23.98f) {
                currentFrame = (float)((double)currentFrame + (double)currentTime * 0.024 / 1000.0);
            } else if (FFPROBE.currentFPS == 29.97f) {
                currentFrame = (float)((double)currentFrame + (double)currentTime * 0.03 / 1000.0);
            } else if (FFPROBE.currentFPS == 59.94f) {
                currentFrame = (float)((double)currentFrame + (double)currentTime * 0.06 / 1000.0);
            }
            return (float)Math.floor(currentFrame);
        }
        return currentFrame;
    }
}

