/*
 * Decompiled with CFR 0.152.
 */
package settings;

import application.Settings;
import application.Shutter;
import library.FFPROBE;
import settings.FunctionUtils;

public class AdvancedFeatures
extends Shutter {
    public static String setDeinterlace(boolean progressiveOutput) {
        if (caseForcerDesentrelacement.isSelected() && comboForcerDesentrelacement.getSelectedItem().toString().equals("detelecine")) {
            String detelecineFields = "top";
            if (lblTFF.getText().equals("BFF")) {
                detelecineFields = "bottom";
            }
            return String.valueOf(comboForcerDesentrelacement.getSelectedItem().toString()) + "=first_field=" + detelecineFields;
        }
        if (FFPROBE.interlaced.equals("1") && !caseForcerEntrelacement.isSelected() && progressiveOutput || FFPROBE.interlaced.equals("1") && caseConform.isSelected() && (comboConform.getSelectedItem().toString().equals(language.getProperty("conformBySlowMotion")) || comboConform.getSelectedItem().toString().equals(language.getProperty("conformByInterpolation"))) || caseForcerDesentrelacement.isSelected()) {
            int doubler = 0;
            if (lblTFF.getText().equals("x2") && caseForcerDesentrelacement.isSelected()) {
                doubler = 1;
            }
            return String.valueOf(comboForcerDesentrelacement.getSelectedItem().toString()) + "=" + doubler + ":" + FFPROBE.fieldOrder + ":0";
        }
        return "";
    }

    public static String setPreset() {
        switch (comboFonctions.getSelectedItem().toString()) {
            case "AV1": {
                if (caseQMax.isSelected()) {
                    return " -preset 0";
                }
                if (caseForceSpeed.isSelected()) {
                    return " -preset " + Shutter.comboForceSpeed.getSelectedItem().toString();
                }
                if (!caseAccel.isSelected()) {
                    return " -preset 8";
                }
            }
            case "H.264": 
            case "H.265": {
                if (caseQMax.isSelected()) {
                    if (caseAccel.isSelected() && comboAccel.getSelectedItem().equals("Nvidia NVENC")) {
                        return " -preset p7";
                    }
                    if (caseAccel.isSelected() && comboAccel.getSelectedItem().equals("AMD AMF Encoder")) {
                        return " -quality quality";
                    }
                    return " -preset veryslow";
                }
                if (!caseForcePreset.isSelected()) break;
                if (caseAccel.isSelected() && comboAccel.getSelectedItem().equals("Nvidia NVENC")) {
                    return " -preset p" + (comboForcePreset.getSelectedIndex() + 1);
                }
                return " -preset " + comboForcePreset.getSelectedItem().toString();
            }
            case "Blu-ray": {
                if (!caseQMax.isSelected()) break;
                return " -preset veryslow";
            }
            case "MPEG-1": 
            case "MPEG-2": 
            case "WMV": {
                if (!caseQMax.isSelected()) break;
                return " -trellis 2 -cmp 2 -subcmp 2 -g 300";
            }
            case "Xvid": {
                if (!caseQMax.isSelected()) break;
                return " -mbd rd -flags +mv4+aic -trellis 2 -cmp 2 -subcmp 2 -g 300";
            }
            case "VP8": 
            case "VP9": {
                if (caseQMax.isSelected()) {
                    return " -speed 0 -quality best";
                }
                if (caseForceSpeed.isSelected()) {
                    if (caseForceQuality.isSelected()) {
                        return " -speed " + Shutter.comboForceSpeed.getSelectedItem().toString() + " -quality " + Shutter.comboForceQuality.getSelectedItem().toString();
                    }
                    return " -speed " + Shutter.comboForceSpeed.getSelectedItem().toString();
                }
                if (caseForceQuality.isSelected()) {
                    return " -speed 4 -quality " + Shutter.comboForceQuality.getSelectedItem().toString();
                }
                return " -speed 4";
            }
        }
        return "";
    }

    public static String setProfile() {
        switch (comboFonctions.getSelectedItem().toString()) {
            case "AV1": {
                if (!caseForceLevel.isSelected()) break;
                return " -profile:v " + Shutter.comboForceProfile.getSelectedItem().toString() + " -level " + Shutter.comboForceLevel.getSelectedItem().toString();
            }
            case "H.264": {
                if (caseForceLevel.isSelected()) {
                    String profile = Shutter.comboForceProfile.getSelectedItem().toString().replace("base", "baseline");
                    if (caseColorspace.isSelected() && profile.equals("high") && comboColorspace.getSelectedItem().toString().contains("10bits") && !caseAccel.isSelected()) {
                        profile = "high10";
                    }
                    return " -profile:v " + profile + " -level " + Shutter.comboForceLevel.getSelectedItem().toString();
                }
                String profile = "high";
                if (caseColorspace.isSelected() && comboColorspace.getSelectedItem().toString().contains("10bits") && !caseAccel.isSelected()) {
                    profile = "high10";
                }
                String[] s = FFPROBE.imageResolution.split("x");
                if (!comboResolution.getSelectedItem().toString().equals(language.getProperty("source"))) {
                    if (comboResolution.getSelectedItem().toString().contains("%")) {
                        double value = (double)Integer.parseInt(comboResolution.getSelectedItem().toString().replace("%", "")) / 100.0;
                        s[0] = String.valueOf((int)((double)Integer.parseInt(s[0]) * value));
                        s[1] = String.valueOf((int)((double)Integer.parseInt(s[1]) * value));
                    } else if (comboResolution.getSelectedItem().toString().contains("x")) {
                        s = comboResolution.getSelectedItem().toString().split("x");
                    } else if (comboResolution.getSelectedItem().toString().contains(":")) {
                        String[] i = FFPROBE.imageResolution.split("x");
                        s = comboResolution.getSelectedItem().toString().replace("auto", "1").split(":");
                        int iw = Integer.parseInt(i[0]);
                        int ih = Integer.parseInt(i[1]);
                        int ow = Integer.parseInt(s[0]);
                        int oh = Integer.parseInt(s[1]);
                        float ir = (float)iw / (float)ih;
                        if (s[0].toString().equals("1")) {
                            s[0] = String.valueOf(Math.round((float)oh * ir));
                        } else {
                            s[1] = String.valueOf(Math.round((float)ow / ir));
                        }
                    }
                }
                int width = Integer.parseInt(s[0]);
                int height = Integer.parseInt(s[1]);
                if (width > 1920 || height > 1080) {
                    return " -profile:v " + profile + " -level 5.2";
                }
                return " -profile:v " + profile + " -level 5.1";
            }
            case "H.265": {
                if (caseForceLevel.isSelected()) {
                    String profile = Shutter.comboForceProfile.getSelectedItem().toString();
                    if (caseColorspace.isSelected() && profile.equals("main") && comboColorspace.getSelectedItem().toString().contains("10bits")) {
                        profile = "main10";
                    } else if (caseColorspace.isSelected() && profile.equals("main") && comboColorspace.getSelectedItem().toString().contains("12bits")) {
                        profile = "main12";
                    } else if (profile.equals("main422")) {
                        profile = caseColorspace.isSelected() && comboColorspace.getSelectedItem().toString().contains("12bits") ? "main422-12" : "main422-10";
                    } else if (profile.equals("main444")) {
                        profile = caseColorspace.isSelected() && comboColorspace.getSelectedItem().toString().contains("12bits") ? "main444-12" : "main444-10";
                    }
                    return " -profile:v " + profile + " -level " + Shutter.comboForceLevel.getSelectedItem().toString();
                }
                String profile = "main";
                if (caseColorspace.isSelected() && comboColorspace.getSelectedItem().toString().contains("10bits")) {
                    profile = "main10";
                } else if (caseColorspace.isSelected() && comboColorspace.getSelectedItem().toString().contains("12bits")) {
                    profile = "main12";
                }
                String[] s = FFPROBE.imageResolution.split("x");
                if (!comboResolution.getSelectedItem().toString().equals(language.getProperty("source"))) {
                    if (comboResolution.getSelectedItem().toString().contains("%")) {
                        double value = (double)Integer.parseInt(comboResolution.getSelectedItem().toString().replace("%", "")) / 100.0;
                        s[0] = String.valueOf((int)((double)Integer.parseInt(s[0]) * value));
                        s[1] = String.valueOf((int)((double)Integer.parseInt(s[1]) * value));
                    } else if (comboResolution.getSelectedItem().toString().contains("x")) {
                        s = comboResolution.getSelectedItem().toString().split("x");
                    } else if (comboResolution.getSelectedItem().toString().contains(":")) {
                        String[] i = FFPROBE.imageResolution.split("x");
                        s = comboResolution.getSelectedItem().toString().replace("auto", "1").split(":");
                        int iw = Integer.parseInt(i[0]);
                        int ih = Integer.parseInt(i[1]);
                        int ow = Integer.parseInt(s[0]);
                        int oh = Integer.parseInt(s[1]);
                        float ir = (float)iw / (float)ih;
                        if (s[0].toString().equals("1")) {
                            s[0] = String.valueOf(Math.round((float)oh * ir));
                        } else {
                            s[1] = String.valueOf(Math.round((float)ow / ir));
                        }
                    }
                }
                int width = Integer.parseInt(s[0]);
                int height = Integer.parseInt(s[1]);
                if (width > 1920 || height > 1080 || FFPROBE.currentFPS >= 59.94f) {
                    if (caseAccel.isSelected() && comboAccel.getSelectedItem().equals("Nvidia NVENC")) {
                        return " -profile:v " + profile + " -level 6.1";
                    }
                    return " -profile:v " + profile + " -level 5.2";
                }
                return " -profile:v " + profile + " -level 5.1";
            }
        }
        return "";
    }

    public static String setTune() {
        switch (comboFonctions.getSelectedItem().toString()) {
            case "H.264": 
            case "H.265": {
                if (!caseForceTune.isSelected()) break;
                return " -tune " + Shutter.comboForceTune.getSelectedItem().toString();
            }
            case "VP8": 
            case "VP9": {
                if (!caseForceTune.isSelected()) break;
                return " -tune-content " + Shutter.comboForceTune.getSelectedItem().toString();
            }
        }
        return "";
    }

    public static String setInterlace() {
        switch (comboFonctions.getSelectedItem().toString()) {
            case "MPEG-1": 
            case "MPEG-2": {
                if (!FFPROBE.interlaced.equals("1") || caseForcerDesentrelacement.isSelected() || comboFilter.getSelectedIndex() != 1) break;
                if (FFPROBE.interlaced.equals("1") && FFPROBE.fieldOrder.equals("1")) {
                    return " -field_order bt -flags +ildct -top 1";
                }
                return " -flags +ildct -top 1";
            }
            case "QT Animation": 
            case "Apple ProRes": 
            case "GoPro CineForm": 
            case "Uncompressed": {
                if (caseForcerProgressif.isSelected()) {
                    return " -field_order progressive";
                }
                if (!FFPROBE.interlaced.equals("1") && !caseForcerEntrelacement.isSelected()) break;
                if (FFPROBE.interlaced.equals("1") && FFPROBE.fieldOrder.equals("1") || caseForcerInversion.isSelected()) {
                    return " -field_order bt";
                }
                return " -field_order tt";
            }
            case "DNxHD": {
                if ((!FFPROBE.interlaced.equals("1") || caseForcerProgressif.isSelected()) && !caseForcerEntrelacement.isSelected()) break;
                switch (comboFilter.getSelectedItem().toString()) {
                    case "120": 
                    case "185": 
                    case "185 X": {
                        if (FFPROBE.interlaced.equals("1") && FFPROBE.fieldOrder.equals("1") || caseForcerInversion.isSelected()) {
                            return " -field_order bt -flags +ildct -top 1";
                        }
                        return " -flags +ildct -top 1";
                    }
                }
                break;
            }
            case "AVC-Intra 100": 
            case "HAP": 
            case "FFV1": 
            case "XAVC": 
            case "XDCAM HD422": {
                if ((!FFPROBE.interlaced.equals("1") || caseForcerProgressif.isSelected()) && !caseForcerEntrelacement.isSelected()) break;
                return " -flags +ildct+ilme -top 1";
            }
            case "DVD": {
                if (caseForcerProgressif.isSelected()) break;
                return " -flags +ildct -top 1";
            }
        }
        return "";
    }

    public static String setGOP() {
        switch (comboFonctions.getSelectedItem().toString()) {
            case "MPEG-1": 
            case "MPEG-2": 
            case "AV1": 
            case "VP8": 
            case "VP9": 
            case "H.264": 
            case "H.265": {
                if (!caseGOP.isSelected()) break;
                return " -g " + Shutter.gopSize.getText();
            }
        }
        return "";
    }

    public static String setCABAC() {
        if (caseCABAC.isSelected()) {
            return " -coder:v vlc";
        }
        return "";
    }

    public static String setDecimate(String filterComplex) {
        switch (comboFonctions.getSelectedItem().toString()) {
            case "MPEG-1": 
            case "MPEG-2": 
            case "AV1": 
            case "OGV": 
            case "VP8": 
            case "VP9": 
            case "WMV": 
            case "Xvid": 
            case "H.264": 
            case "H.265": 
            case "MJPEG": {
                if (!caseDecimate.isSelected()) break;
                if (filterComplex != "") {
                    filterComplex = String.valueOf(filterComplex) + ",";
                }
                filterComplex = String.valueOf(filterComplex) + "mpdecimate";
            }
        }
        return filterComplex;
    }

    public static String setConform(String filterComplex) {
        if (caseConform.isSelected() && comboConform.getSelectedItem().toString().equals(language.getProperty("conformByBlending"))) {
            float newFPS = Float.valueOf(comboFPS.getSelectedItem().toString().replace(",", ".")).floatValue();
            float FPS = FFPROBE.currentFPS;
            if (caseEnableSequence.isSelected()) {
                FPS = Float.valueOf(caseSequenceFPS.getSelectedItem().toString().replace(",", ".").replace(",", ".")).floatValue();
            }
            if (FPS != newFPS) {
                if (filterComplex != "") {
                    filterComplex = String.valueOf(filterComplex) + ",";
                }
                filterComplex = String.valueOf(filterComplex) + "minterpolate=fps=" + newFPS + ":mi_mode=blend";
            }
        }
        return filterComplex;
    }

    public static String setInterpolation(String filterComplex) {
        if (caseConform.isSelected() && comboConform.getSelectedItem().toString().equals(language.getProperty("conformByInterpolation"))) {
            float newFPS = Float.parseFloat(comboFPS.getSelectedItem().toString().replace(",", "."));
            if (filterComplex != "") {
                filterComplex = String.valueOf(filterComplex) + ",";
            }
            filterComplex = String.valueOf(filterComplex) + "minterpolate=fps=" + newFPS;
        }
        return filterComplex;
    }

    public static String setSlowMotion(String filterComplex) {
        if (caseConform.isSelected() && comboConform.getSelectedItem().toString().equals(language.getProperty("conformBySlowMotion"))) {
            float newFPS = Float.parseFloat(comboFPS.getSelectedItem().toString().replace(",", "."));
            if (filterComplex != "") {
                filterComplex = String.valueOf(filterComplex) + ",";
            }
            filterComplex = String.valueOf(filterComplex) + "minterpolate=fps=" + newFPS + ",setpts=" + newFPS / FFPROBE.currentFPS + "*PTS";
        }
        return filterComplex;
    }

    public static String setPTS(String filterComplex) {
        if (caseConform.isSelected() && (comboConform.getSelectedItem().toString().equals(language.getProperty("conformBySpeed")) || comboConform.getSelectedItem().toString().equals(language.getProperty("conformByReverse")))) {
            float newFPS = Float.parseFloat(comboFPS.getSelectedItem().toString().replace(",", "."));
            if (filterComplex != "") {
                filterComplex = String.valueOf(filterComplex) + ",";
            }
            filterComplex = String.valueOf(filterComplex) + "setpts=" + FFPROBE.currentFPS / newFPS + "*PTS";
            if (comboConform.getSelectedItem().toString().equals(language.getProperty("conformByReverse"))) {
                filterComplex = String.valueOf(filterComplex) + ",reverse";
            }
        }
        return filterComplex;
    }

    public static String setFramerate(boolean mxfCompatible) {
        if (caseForcerEntrelacement.isSelected() && caseConform.isSelected() && comboFPS.getSelectedItem().toString().equals("50")) {
            return " -r 25";
        }
        if (caseForcerEntrelacement.isSelected() && caseConform.isSelected() && comboFPS.getSelectedItem().toString().equals("59,94")) {
            if (mxfCompatible) {
                return " -r 30000/1001";
            }
            return " -r 29.97";
        }
        if (caseForcerEntrelacement.isSelected() && caseConform.isSelected() && comboFPS.getSelectedItem().toString().equals("60")) {
            return " -r 30";
        }
        if (caseConform.isSelected() && comboConform.getSelectedItem().toString().equals(language.getProperty("conformBySlowMotion"))) {
            return " -r " + FFPROBE.currentFPS;
        }
        if (caseConform.isSelected()) {
            if (comboFPS.getSelectedItem().toString().equals("59,94")) {
                return " -r 60000/1001";
            }
            if (comboFPS.getSelectedItem().toString().equals("29,97")) {
                return " -r 30000/1001";
            }
            if (comboFPS.getSelectedItem().toString().equals("23,98")) {
                return " -r 24000/1001";
            }
            return " -r " + Float.parseFloat(comboFPS.getSelectedItem().toString().replace(",", "."));
        }
        if (inputDeviceIsRunning) {
            return " -vsync vfr";
        }
        if (!caseForcerDesentrelacement.isSelected() || !lblTFF.getText().equals("x2") && !comboForcerDesentrelacement.getSelectedItem().toString().equals("detelecine")) {
            if (FFPROBE.currentFPS == 59.94f) {
                return " -r 60000/1001";
            }
            if (FFPROBE.currentFPS == 29.97f) {
                return " -r 30000/1001";
            }
            if (FFPROBE.currentFPS == 23.98f) {
                return " -r 24000/1001";
            }
        }
        return "";
    }

    public static String setForceTFF(String filterComplex) {
        if (comboFonctions.getSelectedItem().toString().equals("XDCAM HD422") && caseForcerEntrelacement.isSelected()) {
            if (filterComplex != "") {
                filterComplex = String.valueOf(filterComplex) + ",";
            }
            filterComplex = String.valueOf(filterComplex) + "setfield=tff";
        }
        return filterComplex;
    }

    public static String setInterlace50p(String filterComplex) {
        switch (comboFonctions.getSelectedItem().toString()) {
            case "QT Animation": 
            case "Apple ProRes": 
            case "AVC-Intra 100": 
            case "GoPro CineForm": 
            case "HAP": 
            case "FFV1": 
            case "XAVC": 
            case "DNxHD": 
            case "H.264": 
            case "H.265": 
            case "Blu-ray": 
            case "XDCAM HD422": 
            case "Uncompressed": {
                if (!caseForcerEntrelacement.isSelected()) break;
                if (caseConform.isSelected() && !comboConform.getSelectedItem().toString().equals(language.getProperty("conformBySlowMotion"))) {
                    if (!caseConform.isSelected() || !(Float.valueOf(comboFPS.getSelectedItem().toString().replace(",", ".")).floatValue() >= 50.0f)) break;
                    if (filterComplex != "") {
                        filterComplex = String.valueOf(filterComplex) + ",";
                    }
                    filterComplex = String.valueOf(filterComplex) + "format=yuv444p,interlace";
                    break;
                }
                if (FFPROBE.currentFPS != 50.0f && FFPROBE.currentFPS != 59.94f && FFPROBE.currentFPS != 60.0f) break;
                if (filterComplex != "") {
                    filterComplex = String.valueOf(filterComplex) + ",";
                }
                filterComplex = String.valueOf(filterComplex) + "format=yuv444p,interlace";
            }
        }
        return filterComplex;
    }

    public static String setOPATOM(String audio) {
        if (comboFonctions.getSelectedItem().toString().equals("DNxHR") && caseCreateOPATOM.isSelected() && lblOPATOM.getText().equals("OP-Atom")) {
            return " -an";
        }
        if (caseOPATOM.isSelected()) {
            return audio;
        }
        return "";
    }

    public static String setFlags(String fileName) {
        String flags = " -sws_flags " + Settings.comboScale.getSelectedItem().toString();
        if (!Settings.comboSync.getSelectedItem().equals("auto") && !caseDecimate.isSelected()) {
            flags = String.valueOf(flags) + " -vsync " + Settings.comboSync.getSelectedItem();
        }
        switch (comboFonctions.getSelectedItem().toString()) {
            case "H.265": {
                flags = String.valueOf(flags) + " -tag:v hvc1";
            }
            case "AV1": {
                String av1Flags = "";
                if (caseFastDecode.isSelected()) {
                    av1Flags = String.valueOf(av1Flags) + "fast-decode=1";
                }
                if (caseForceTune.isSelected()) {
                    if (av1Flags != "") {
                        av1Flags = String.valueOf(av1Flags) + ",";
                    }
                    av1Flags = String.valueOf(av1Flags) + "tune=" + comboForceTune.getSelectedIndex();
                }
                if (caseFilmGrain.isSelected()) {
                    if (av1Flags != "") {
                        av1Flags = String.valueOf(av1Flags) + ",";
                    }
                    av1Flags = String.valueOf(av1Flags) + "film-grain=" + comboFilmGrain.getSelectedIndex();
                }
                if (av1Flags != "") {
                    flags = String.valueOf(flags) + " -svtav1-params " + av1Flags;
                }
            }
            case "VP8": 
            case "VP9": 
            case "H.264": {
                if (caseFastStart.isSelected() && (comboFilter.getSelectedItem().toString().equals(".mp4") || comboFilter.getSelectedItem().toString().equals(".mov"))) {
                    flags = String.valueOf(flags) + " -movflags faststart";
                }
                if (!caseDecimate.isSelected()) break;
                flags = String.valueOf(flags) + " -vsync vfr";
                break;
            }
            case "DVD": {
                flags = String.valueOf(flags) + " -f dvd";
                break;
            }
            case "MPEG-1": 
            case "MPEG-2": 
            case "OGV": 
            case "WMV": 
            case "Xvid": 
            case "MJPEG": {
                if (!caseDecimate.isSelected()) break;
                flags = String.valueOf(flags) + " -vsync vfr";
                break;
            }
            case "Apple ProRes": {
                flags = String.valueOf(flags) + " -metadata:s \"encoder=" + comboFonctions.getSelectedItem().toString() + " " + comboFilter.getSelectedItem().toString() + '\"' + " -vendor apl0 -movflags write_colr+write_gama -flags bitexact";
                break;
            }
            case "AVC-Intra 100": 
            case "XAVC": {
                flags = String.valueOf(flags) + " -f mxf";
                break;
            }
            case "DNxHR": {
                if (!caseCreateOPATOM.isSelected() || !lblOPATOM.getText().equals("OP-Atom")) break;
                flags = String.valueOf(flags) + " -metadata material_package_name=\"" + fileName + '\"' + " -f mxf_opatom";
            }
        }
        return flags;
    }

    public static String setOptions() {
        String options = "";
        int maxrate = FunctionUtils.setVideoBitrate();
        if (!maximumBitrate.getSelectedItem().toString().equals("auto")) {
            maxrate = Integer.parseInt(maximumBitrate.getSelectedItem().toString());
        }
        switch (comboFonctions.getSelectedItem().toString()) {
            case "H.264": {
                if (caseForcerEntrelacement.isSelected()) {
                    options = " -x264opts tff=1";
                    if (!lblVBR.getText().equals("CBR")) break;
                    options = String.valueOf(options) + ":nal-hrd=cbr:force-cfr=1 -minrate " + FunctionUtils.setVideoBitrate() + "k -maxrate " + maxrate + "k -bufsize " + Integer.valueOf(maxrate * 2) + "k";
                    break;
                }
                if (!lblVBR.getText().equals("CBR")) break;
                options = " -x264opts nal-hrd=cbr:force-cfr=1 -minrate " + FunctionUtils.setVideoBitrate() + "k -maxrate " + maxrate + "k -bufsize " + Integer.valueOf(maxrate * 2) + "k";
                break;
            }
            case "H.265": {
                if (caseForcerEntrelacement.isSelected()) {
                    options = " -x265-params interlace=1";
                    if (caseGOP.isSelected()) {
                        options = String.valueOf(options) + ":keyint=" + Shutter.gopSize.getText();
                    }
                    if (lblVBR.getText().equals("CBR")) {
                        options = String.valueOf(options) + ":strict-cbr=1 -minrate " + FunctionUtils.setVideoBitrate() + "k -maxrate " + maxrate + "k -bufsize " + Integer.valueOf(maxrate * 2) + "k";
                        break;
                    }
                    if (!lblVBR.getText().equals("CQ") || !debitVideo.getSelectedItem().toString().equals("0")) break;
                    options = String.valueOf(options) + ":lossless=1";
                    break;
                }
                if (caseGOP.isSelected()) {
                    options = " -x265-params keyint=" + Shutter.gopSize.getText();
                    if (lblVBR.getText().equals("CBR")) {
                        options = String.valueOf(options) + ":strict-cbr=1 -minrate " + FunctionUtils.setVideoBitrate() + "k -maxrate " + maxrate + "k -bufsize " + Integer.valueOf(maxrate * 2) + "k";
                        break;
                    }
                    if (!lblVBR.getText().equals("CQ") || !debitVideo.getSelectedItem().toString().equals("0")) break;
                    options = String.valueOf(options) + ":lossless=1";
                    break;
                }
                if (lblVBR.getText().equals("CBR")) {
                    options = " -x265-params strict-cbr=1 -minrate " + FunctionUtils.setVideoBitrate() + "k -maxrate " + maxrate + "k -bufsize " + Integer.valueOf(maxrate * 2) + "k";
                    break;
                }
                if (!lblVBR.getText().equals("CQ") || !debitVideo.getSelectedItem().toString().equals("0")) break;
                options = " -x265-params lossless=1";
            }
        }
        return options;
    }
}

