/*
 * Decompiled with CFR 0.152.
 */
package functions;

import application.Ftp;
import application.RecordInputDevice;
import application.Settings;
import application.Shutter;
import application.Utils;
import application.VideoPlayer;
import application.Wetransfer;
import functions.VideoEncoders;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import library.DCRAW;
import library.FFMPEG;
import library.FFPROBE;
import library.XPDF;
import settings.Colorimetry;
import settings.Corrections;
import settings.Filter;
import settings.FunctionUtils;
import settings.Image;
import settings.InputAndOutput;
import settings.Overlay;

public class Picture
extends Shutter {
    public static void main(final boolean encode, final boolean videoPlayerCapture) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (!scanIsRunning) {
                    FunctionUtils.completed = 0;
                }
                lblFilesEnded.setText(FunctionUtils.completedFiles(FunctionUtils.completed));
                int i = 0;
                while (i < liste.getSize()) {
                    File file = FunctionUtils.setInputFile(new File((String)liste.getElementAt(i)));
                    if (file == null) break;
                    if (videoPlayerCapture) {
                        file = new File(VideoPlayer.videoPath);
                    }
                    try {
                        String fileName = file.getName();
                        lblCurrentEncoding.setText(fileName);
                        String extension = fileName.substring(fileName.lastIndexOf("."));
                        boolean isRaw = false;
                        switch (extension.toLowerCase()) {
                            case ".3fr": 
                            case ".arw": 
                            case ".cr2": 
                            case ".cr3": 
                            case ".crw": 
                            case ".dng": 
                            case ".kdc": 
                            case ".mrw": 
                            case ".nef": 
                            case ".nrw": 
                            case ".orf": 
                            case ".pef": 
                            case ".r3d": 
                            case ".ptx": 
                            case ".raf": 
                            case ".rw2": 
                            case ".srw": 
                            case ".x3f": {
                                isRaw = true;
                            }
                        }
                        if (FunctionUtils.analyze(file, isRaw) && Filter.dateFilter(file)) {
                            String frameRate = Picture.setFramerate();
                            String filterComplex = Picture.setDeinterlace(extension, isRaw);
                            FFMPEG.isGPUCompatible = false;
                            if (VideoEncoders.setScalingFirst()) {
                                filterComplex = Image.setScale(filterComplex, false);
                                filterComplex = Image.setPad(filterComplex, false);
                            }
                            filterComplex = Colorimetry.setLUT(filterComplex);
                            filterComplex = Colorimetry.setLevels(filterComplex);
                            filterComplex = Colorimetry.setColormatrix(filterComplex);
                            filterComplex = Image.setRotate(filterComplex);
                            filterComplex = Colorimetry.setColor(filterComplex);
                            filterComplex = Corrections.setDeflicker(filterComplex);
                            filterComplex = Corrections.setDeband(filterComplex);
                            filterComplex = Corrections.setDetails(filterComplex);
                            filterComplex = Corrections.setDenoiser(filterComplex);
                            filterComplex = Corrections.setSmoothExposure(filterComplex);
                            filterComplex = Overlay.setOverlay(filterComplex, false);
                            String logo = Overlay.setLogo();
                            filterComplex = Overlay.setWatermark(filterComplex);
                            filterComplex = Overlay.showTimecode(filterComplex, fileName.replace(extension, ""), videoPlayerCapture);
                            filterComplex = Image.setCrop(filterComplex);
                            if (!VideoEncoders.setScalingFirst()) {
                                filterComplex = Image.setScale(filterComplex, false);
                                filterComplex = Image.setPad(filterComplex, false);
                            }
                            if (comboFilter.getSelectedItem().toString().equals(".gif")) {
                                if (filterComplex != "") {
                                    filterComplex = String.valueOf(filterComplex) + ",";
                                }
                                filterComplex = String.valueOf(filterComplex) + "split[a][b];[a]palettegen[p];[b][p]paletteuse,fps=" + comboImageOption.getSelectedItem().toString().replace(" " + Shutter.language.getProperty("fps"), "");
                            }
                            filterComplex = FunctionUtils.setFilterComplex(filterComplex, "");
                            String hardwareDecoding = " -hwaccel " + Settings.comboGPU.getSelectedItem().toString().replace(language.getProperty("aucun"), "none");
                            InputAndOutput.getInputAndOutput();
                            if (videoPlayerCapture && VideoPlayer.waveformContainer.isVisible()) {
                                InputAndOutput.inPoint = " -ss " + (long)(VideoPlayer.playerCurrentFrame * VideoPlayer.inputFramerateMS) + "ms";
                            }
                            String flags = Picture.setFlags();
                            String colorspace = Colorimetry.setColorspace();
                            String inputCodec = Colorimetry.setInputCodec(extension);
                            String compression = Picture.setCompression();
                            String labelOutput = FunctionUtils.setOutputDestination("", file);
                            String container = Picture.setExtension();
                            String singleFrame = Picture.setFrame();
                            String fileOutputName = String.valueOf(labelOutput.replace("\\", "/")) + "/" + fileName.replace(extension, container);
                            File fileOut = new File(fileOutputName);
                            if (!fileOut.exists() || (fileOut = FunctionUtils.fileReplacement(labelOutput, fileName, extension, "_", container)) != null) {
                                String cmd = String.valueOf(filterComplex) + singleFrame + colorspace + compression + flags + " -an -y ";
                                if (extension.toLowerCase().equals(".pdf")) {
                                    int p = 1;
                                    while (p < XPDF.pagesCount + 1) {
                                        int n = 1;
                                        do {
                                            fileOut = new File(String.valueOf(labelOutput) + "/" + fileName.replace(extension, "_" + n + container));
                                            ++n;
                                        } while (fileOut.exists());
                                        if (!cancelled) {
                                            XPDF.run(" -r 300 -f " + p + " -l " + p + " " + '\"' + file.toString() + '\"' + " - | PathToFFMPEG -i -" + logo + cmd + '\"' + fileOut + '\"');
                                        }
                                        do {
                                            Thread.sleep(100L);
                                        } while (XPDF.runProcess.isAlive());
                                        ++p;
                                    }
                                    btnStart.setEnabled(true);
                                } else if (isRaw) {
                                    btnStart.setEnabled(false);
                                    DCRAW.run(" -v -w -c -q 3 -o 1 -6 -g 2.4 12.92 \"" + file.toString() + '\"' + " | PathToFFMPEG -i -" + logo + cmd + '\"' + fileOut + '\"');
                                } else if (inputDeviceIsRunning) {
                                    String timeStamp = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss").format(Calendar.getInstance().getTime());
                                    if ((((String)liste.getElementAt(0)).equals("Capture.current.screen") || System.getProperty("os.name").contains("Mac")) && RecordInputDevice.audioDeviceIndex > 0) {
                                        cmd = cmd.replace("1:v", "2:v").replace("-map v:0", "-map 1:v").replace("0:v", "1:v");
                                    }
                                    FFMPEG.run(" " + RecordInputDevice.setInputDevices() + logo + cmd + '\"' + fileOut.toString().replace("Capture.current", timeStamp).replace("Capture.input", timeStamp) + '\"');
                                    fileOut = new File(fileOut.toString().replace("Capture.current", timeStamp).replace("Capture.input", timeStamp));
                                } else {
                                    FFMPEG.run(String.valueOf(hardwareDecoding) + InputAndOutput.inPoint + frameRate + inputCodec + " -i " + '\"' + file.toString() + '\"' + logo + InputAndOutput.outPoint + cmd + '\"' + fileOut + '\"');
                                }
                                if (isRaw) {
                                    do {
                                        Thread.sleep(100L);
                                    } while (DCRAW.runProcess.isAlive());
                                    btnStart.setEnabled(true);
                                } else {
                                    do {
                                        Thread.sleep(100L);
                                    } while (FFMPEG.runProcess.isAlive());
                                }
                                if (!FFMPEG.saveCode && !btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender")) && (Picture.lastActions(file, fileName, extension, fileOut, labelOutput) || videoPlayerCapture)) {
                                    break;
                                }
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        FFMPEG.error = true;
                    }
                    ++i;
                }
                if (!btnStart.getText().equals(Shutter.language.getProperty("btnAddToRender")) && encode) {
                    Picture.enfOfFunction();
                }
            }
        });
        thread.start();
    }

    private static String setFramerate() {
        if (caseCreateSequence.isSelected()) {
            return " -r " + FFPROBE.currentFPS / Float.parseFloat(comboInterpret.getSelectedItem().toString().replace(",", "."));
        }
        return "";
    }

    private static String setDeinterlace(String extension, boolean isRaw) {
        if (isRaw || extension.toLowerCase().equals(".pdf")) {
            return "";
        }
        if (FFPROBE.interlaced.equals("1")) {
            return "yadif=0:" + FFPROBE.fieldOrder + ":0";
        }
        return "";
    }

    private static String setFlags() {
        return " -sws_flags " + Settings.comboScale.getSelectedItem().toString();
    }

    private static String setCompression() {
        if (comboFonctions.getSelectedItem().equals("JPEG")) {
            int q = Math.round(31.0f - (float)Integer.valueOf(comboFilter.getSelectedItem().toString().replace("%", "")).intValue() * 31.0f / 100.0f);
            return " -q:v " + q;
        }
        if (comboFilter.getSelectedItem().toString().equals(".webp")) {
            return " -quality " + comboImageOption.getSelectedItem().toString().replace("%", "");
        }
        if (comboFilter.getSelectedItem().toString().equals(".avif")) {
            return " -crf " + Math.round(63.0f - (float)Integer.valueOf(comboImageOption.getSelectedItem().toString().replace("%", "")).intValue() * 63.0f / 100.0f);
        }
        if (comboFilter.getSelectedItem().toString().equals(".tif")) {
            return " -compression_algo " + comboImageOption.getSelectedItem().toString();
        }
        return " -q:v 0";
    }

    private static String setExtension() {
        if (comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionPicture"))) {
            if (caseCreateSequence.isSelected()) {
                return "_%06d" + comboFilter.getSelectedItem().toString();
            }
            return comboFilter.getSelectedItem().toString();
        }
        if (comboFonctions.getSelectedItem().equals("JPEG") && caseCreateSequence.isSelected()) {
            return "_%06d.jpg";
        }
        return ".jpg";
    }

    private static String setFrame() {
        if (caseCreateSequence.isSelected()) {
            return " -r 1";
        }
        if (comboFilter.getSelectedItem().toString().equals(".gif")) {
            return "";
        }
        if (comboFilter.getSelectedItem().toString().equals(".apng")) {
            return " -r " + comboImageOption.getSelectedItem().toString().replace(" " + Shutter.language.getProperty("fps"), "").replace(",", ".");
        }
        return " -vframes 1";
    }

    private static boolean lastActions(File file, String fileName, String extension, File fileOut, String output) {
        if (FunctionUtils.cleanFunction(fileName, fileOut, output)) {
            return true;
        }
        FunctionUtils.addFileForMail(fileName);
        Wetransfer.addFile(fileOut);
        Ftp.sendToFtp(fileOut);
        Utils.copyFile(fileOut);
        if (Shutter.scanIsRunning) {
            FunctionUtils.moveScannedFiles(file);
            Picture.main(true, false);
            return true;
        }
        return false;
    }
}

