/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.Console;
import application.ListeFileTransferHandler;
import application.RecordInputDevice;
import application.RenderQueue;
import application.RoundedLineBorder;
import application.Settings;
import application.Shutter;
import application.SubtitlesEmbed;
import application.SubtitlesTimeline;
import application.Utils;
import com.formdev.flatlaf.extras.FlatSVGIcon;
import functions.Picture;
import java.awt.AWTEvent;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.imageio.ImageIO;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.SourceDataLine;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import library.DCRAW;
import library.EXIFTOOL;
import library.FFMPEG;
import library.FFPROBE;
import library.MEDIAINFO;
import library.XPDF;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import settings.Colorimetry;
import settings.Corrections;
import settings.FunctionUtils;
import settings.ImageSequence;
import settings.InputAndOutput;
import settings.Timecode;
import settings.Transitions;

public class VideoPlayer {
    public static JFrame frame;
    JLabel title = new JLabel(Shutter.language.getProperty("changeInOutPoint"));
    ImageIcon header = new ImageIcon(this.getClass().getClassLoader().getResource("contents/header.png"));
    private static int taskBarHeight;
    private JLabel quit;
    private JLabel fullscreen;
    private JLabel reduce;
    private JPanel topPanel;
    private JLabel topImage;
    private JLabel bottomImage;
    public static JPanel player;
    public static Process playerVideo;
    public static Process playerAudio;
    private static InputStream audio;
    private static AudioInputStream audioInputStream;
    private static SourceDataLine line;
    private static FloatControl gainControl;
    public static Thread playerThread;
    public static Thread setTime;
    public static float playerCurrentFrame;
    private static long fpsTime;
    private static int fps;
    private static int displayCurrentFPS;
    private static JLabel showFPS;
    private static JLabel showScale;
    public static int playerInMark;
    public static int playerOutMark;
    public static Image frameVideo;
    private static double screenRefreshRate;
    private static long lastEvTime;
    public static boolean playerLoop;
    public static boolean frameIsComplete;
    public static boolean playerPlayVideo;
    private static boolean windowDrag;
    public static boolean sliderChange;
    private static JLabel lblVolume;
    public static JSlider sliderVolume;
    public static JLabel lblPosition;
    public static JLabel lblDuration;
    private static JLabel lblMode;
    public static JComboBox<Object> comboMode;
    private static JLabel lblSpeed;
    private static JSlider sliderSpeed;
    private static boolean showInfoMessage;
    public static boolean playTransition;
    private static boolean closeAudioStream;
    private static JButton btnCapture;
    private static JLabel btnPreview;
    public static JTextField splitValue;
    private static JLabel lblSplitSec;
    private JButton btnApply;
    public static JButton btnPrevious;
    public static JButton btnNext;
    public static JButton btnStop;
    public static JButton btnPlay;
    public static JButton btnMarkIn;
    public static JButton btnMarkOut;
    public static JButton btnGoToIn;
    public static JButton btnGoToOut;
    public static JButton btnNextFile;
    public static JButton btnPreviousFile;
    public static JSlider slider;
    public static JCheckBox caseGPU;
    public static JCheckBox caseVuMeter;
    public static JCheckBox casePlaySound;
    public static JCheckBox caseInternalTc;
    private static NumberFormat formatter;
    private static NumberFormat formatterToMs;
    public static JLabel lblVideo;
    public static String videoPath;
    public static float inputFramerateMS;
    private static float totalFrames;
    private static JPanel grpIn;
    public static JTextField caseInH;
    public static JTextField caseInM;
    public static JTextField caseInS;
    public static JTextField caseInF;
    public static JPanel grpOut;
    public static JTextField caseOutH;
    public static JTextField caseOutM;
    public static JTextField caseOutS;
    public static JTextField caseOutF;
    public static float offset;
    public static int durationH;
    public static int durationM;
    public static int durationS;
    public static int durationF;
    static boolean frameControl;
    static boolean seekOnKeyFrames;
    public static boolean addWaveformIsRunning;
    public static File waveform;
    public static JLabel waveformIcon;
    public static JLabel waveformContainer;
    public static JPanel cursorWaveform;
    private static boolean mouseIsPressed;
    public static File preview;
    private static Thread runProcess;
    public static JPanel grpColorimetry;
    public static JPanel panelColorimetryComponents;
    private JScrollBar scrollBarColorimetry = new JScrollBar();
    int scrollColorimetryValue = 0;
    private static JButton btnReset;
    public static JCheckBox caseEnableColorimetry;
    public static JComboBox<String> comboRGB;
    public static JSlider sliderExposure;
    public static JSlider sliderGamma;
    public static JSlider sliderContrast;
    public static JSlider sliderHighlights;
    public static JSlider sliderMediums;
    public static JSlider sliderShadows;
    public static JSlider sliderWhite;
    public static JSlider sliderBlack;
    public static JSlider sliderBalance;
    public static JSlider sliderHUE;
    public static JSlider sliderRED;
    public static JSlider sliderGREEN;
    public static JSlider sliderBLUE;
    public static JSlider sliderVibrance;
    public static JComboBox<String> comboVibrance;
    public static JSlider sliderSaturation;
    public static JSlider sliderGrain;
    public static JSlider sliderVignette;
    public static JSlider sliderAngle;
    public static JPanel grpCorrections;
    public static JCheckBox caseStabilisation;
    private static String stabilisation;
    public static JCheckBox caseDeflicker;
    public static JCheckBox caseBanding;
    public static JCheckBox caseLimiter;
    public static JCheckBox caseDetails;
    public static JSlider sliderDetails;
    public static JCheckBox caseDenoise;
    public static JSlider sliderDenoise;
    public static JCheckBox caseSmoothExposure;
    public static JSlider sliderSmoothExposure;
    public static JPanel grpTransitions;
    public static JLabel lblFadeInColor;
    public static JCheckBox caseVideoFadeIn;
    public static JTextField spinnerVideoFadeIn;
    public static JCheckBox caseAudioFadeIn;
    public static JTextField spinnerAudioFadeIn;
    public static JLabel lblFadeOutColor;
    public static JCheckBox caseVideoFadeOut;
    public static JTextField spinnerVideoFadeOut;
    public static JCheckBox caseAudioFadeOut;
    public static JTextField spinnerAudioFadeOut;
    public static JPanel grpCrop;
    private static JPanel selection;
    private static JPanel overImage;
    private static boolean selectionDrag;
    private static int anchorRight;
    private static int anchorBottom;
    private static int startCropX;
    private static int startCropY;
    private static int frameCropX;
    private static int frameCropY;
    private static boolean shift;
    private static boolean ctrl;
    public static JCheckBox caseEnableCrop;
    private static JComboBox<String> comboPreset;
    private static int mouseCropOffsetX;
    private static int mouseCropOffsetY;
    public static JTextField textCropPosX;
    public static JTextField textCropPosY;
    public static JTextField textCropWidth;
    public static JTextField textCropHeight;
    public static JPanel grpOverlay;
    public static float imageRatio;
    private static boolean ratioChanged;
    private int tcPosX = 0;
    private int tcPosY = 0;
    private static int tcLocX;
    private static int tcLocY;
    private static int filePosX;
    private static int filePosY;
    private static int fileLocX;
    private static int fileLocY;
    private static JPanel timecode;
    private static JPanel fileName;
    public static JTextField textTcPosX;
    public static JTextField textTcPosY;
    public static JTextField textNamePosX;
    public static JTextField textNamePosY;
    public static JTextField textTcSize;
    public static JTextField textNameSize;
    public static JTextField textTcOpacity;
    public static JTextField textNameOpacity;
    public static JCheckBox caseAddTimecode;
    public static JLabel lblTimecode;
    public static JTextField TC1;
    public static JTextField TC2;
    public static JTextField TC3;
    public static JTextField TC4;
    public static JTextField text;
    private static long textTime;
    private static Thread changeText;
    public static JCheckBox caseShowTimecode;
    public static JCheckBox caseShowFileName;
    public static JCheckBox caseAddText;
    public static JComboBox<String> comboOverlayFont;
    public static JLabel lblTcBackground;
    private static JPanel panelTcColor;
    private static JPanel panelTcColor2;
    public static Color foregroundColor;
    public static Color backgroundColor;
    public static String foregroundHex;
    public static String backgroundHex;
    public static String foregroundTcAlpha;
    public static String foregroundNameAlpha;
    public static String backgroundTcAlpha;
    public static String backgroundNameAlpha;
    public static JPanel grpSubtitles;
    public static JCheckBox caseAddSubtitles;
    public static String outline;
    public static JComboBox<String> comboSubsFont;
    public static Color fontSubsColor;
    public static Color backgroundSubsColor;
    public static String subsHex;
    public static String subsHex2;
    public static String subsAlpha;
    private static int alphaHeight;
    private static JPanel panelSubsColor;
    private static JLabel lblSubsOutline;
    private static JPanel panelSubsColor2;
    public static JButton btnI;
    public static JButton btnG;
    public static JTextField textSubsSize;
    public static JTextField textSubsOutline;
    public static JTextField textSubtitlesPosition;
    public static JTextField textSubsWidth;
    public static JLabel lblSubsBackground;
    public static File subtitlesFile;
    private static JPanel subsCanvas;
    public static JPanel grpWatermark;
    public static JPanel logo;
    public static Image logoPNG;
    public static JCheckBox caseAddWatermark;
    public static JTextField textWatermarkPosX;
    public static JTextField textWatermarkPosY;
    public static JTextField textWatermarkSize;
    public static JTextField textWatermarkOpacity;
    private static JCheckBox caseSafeArea;
    public static String logoFile;
    private int logoPosX = 0;
    private int logoPosY = 0;
    private static int logoLocX;
    private static int logoLocY;
    private static int MousePositionX;
    private static int MousePositionY;

    static {
        playerCurrentFrame = 0.0f;
        fpsTime = 0L;
        fps = 0;
        displayCurrentFPS = 0;
        playerInMark = 0;
        playerOutMark = 0;
        screenRefreshRate = 16.7;
        lastEvTime = 0L;
        playerLoop = false;
        frameIsComplete = false;
        playerPlayVideo = true;
        sliderChange = false;
        comboMode = new JComboBox<String>(new String[]{Shutter.language.getProperty("cutUpper"), Shutter.language.getProperty("removeMode"), Shutter.language.getProperty("splitMode")});
        showInfoMessage = true;
        playTransition = false;
        closeAudioStream = false;
        formatter = new DecimalFormat("00");
        formatterToMs = new DecimalFormat("000");
        videoPath = null;
        inputFramerateMS = 40.0f;
        offset = 0.0f;
        durationH = 0;
        durationM = 0;
        durationS = 0;
        durationF = 0;
        frameControl = false;
        seekOnKeyFrames = false;
        addWaveformIsRunning = false;
        waveform = new File(String.valueOf(Shutter.dirTemp) + "waveform.png");
        mouseIsPressed = false;
        preview = new File(String.valueOf(Shutter.dirTemp) + "preview.bmp");
        runProcess = new Thread();
        caseEnableColorimetry = new JCheckBox(Shutter.language.getProperty("enable"));
        comboRGB = new JComboBox();
        sliderExposure = new JSlider();
        sliderGamma = new JSlider();
        sliderContrast = new JSlider();
        sliderHighlights = new JSlider();
        sliderMediums = new JSlider();
        sliderShadows = new JSlider();
        sliderWhite = new JSlider();
        sliderBlack = new JSlider();
        sliderBalance = new JSlider();
        sliderHUE = new JSlider();
        sliderRED = new JSlider();
        sliderGREEN = new JSlider();
        sliderBLUE = new JSlider();
        sliderVibrance = new JSlider();
        comboVibrance = new JComboBox();
        sliderSaturation = new JSlider();
        sliderGrain = new JSlider();
        sliderVignette = new JSlider();
        sliderAngle = new JSlider();
        caseStabilisation = new JCheckBox(Shutter.language.getProperty("caseStabilisation"));
        stabilisation = "";
        caseDeflicker = new JCheckBox(Shutter.language.getProperty("caseDeflicker"));
        caseBanding = new JCheckBox(Shutter.language.getProperty("caseBanding"));
        caseLimiter = new JCheckBox(Shutter.language.getProperty("caseLimiter"));
        caseDetails = new JCheckBox(Shutter.language.getProperty("caseDetails"));
        caseDenoise = new JCheckBox(Shutter.language.getProperty("caseBruit"));
        caseSmoothExposure = new JCheckBox(Shutter.language.getProperty("caseExposure"));
        spinnerVideoFadeIn = new JTextField("25");
        spinnerAudioFadeIn = new JTextField("25");
        spinnerVideoFadeOut = new JTextField("25");
        spinnerAudioFadeOut = new JTextField("25");
        startCropX = 0;
        startCropY = 0;
        shift = false;
        ctrl = false;
        caseEnableCrop = new JCheckBox(Shutter.language.getProperty("enable"));
        comboPreset = new JComboBox();
        imageRatio = 3.0f;
        ratioChanged = false;
        tcLocX = 0;
        tcLocY = 0;
        filePosX = 0;
        filePosY = 0;
        fileLocX = 0;
        fileLocY = 0;
        caseAddTimecode = new JCheckBox(Shutter.language.getProperty("caseAddTimecode"));
        lblTimecode = new JLabel(Shutter.language.getProperty("lblTimecode"));
        TC1 = new JTextField("00");
        TC2 = new JTextField("00");
        TC3 = new JTextField("00");
        TC4 = new JTextField("00");
        text = new JTextField("");
        textTime = System.currentTimeMillis();
        caseShowTimecode = new JCheckBox(Shutter.language.getProperty("caseShowTimecode"));
        caseShowFileName = new JCheckBox(Shutter.language.getProperty("caseShowFileName"));
        caseAddText = new JCheckBox(Shutter.language.getProperty("caseShowText"));
        panelTcColor = new JPanel();
        panelTcColor2 = new JPanel();
        foregroundColor = Color.WHITE;
        backgroundColor = Color.BLACK;
        foregroundHex = "ffffff";
        backgroundHex = "000000";
        foregroundTcAlpha = "ff";
        foregroundNameAlpha = "ff";
        backgroundTcAlpha = "7f";
        backgroundNameAlpha = "7f";
        caseAddSubtitles = new JCheckBox(Shutter.language.getProperty("caseSubtitles"));
        outline = "1";
        fontSubsColor = Color.WHITE;
        backgroundSubsColor = Color.BLACK;
        subsHex = "FFFFFF";
        subsHex2 = "000000";
        subsAlpha = "7F";
        panelSubsColor = new JPanel();
        lblSubsOutline = new JLabel();
        panelSubsColor2 = new JPanel();
        textSubsWidth = new JTextField();
        caseAddWatermark = new JCheckBox(Shutter.language.getProperty("frameLogo"));
        logoFile = new String();
        logoLocX = 0;
        logoLocY = 0;
    }

    public VideoPlayer() {
        showInfoMessage = true;
        frame = new JFrame();
        frame.getContentPane().setBackground(new Color(45, 45, 45));
        frame.setDefaultCloseOperation(2);
        frame.getContentPane().setLayout(null);
        frame.setVisible(false);
        frame.setSize(1300, 624);
        frame.setMinimumSize(new Dimension(1300, 624));
        frame.setTitle(Shutter.language.getProperty("changeInOutPoint"));
        frame.setForeground(Color.WHITE);
        if (!frame.isUndecorated()) {
            frame.setUndecorated(true);
            frame.setIconImage(new ImageIcon(this.getClass().getClassLoader().getResource("contents/icon.png")).getImage());
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            frame.setLocation(dim.width / 2 - VideoPlayer.frame.getSize().width / 2, dim.height / 2 - VideoPlayer.frame.getSize().height / 2);
            Rectangle winSize = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
            taskBarHeight = (int)(dim.getHeight() - (double)winSize.height);
            Area shape1 = new Area(new RoundRectangle2D.Double(0.0, 0.0, frame.getWidth(), frame.getHeight(), 15.0, 15.0));
            Area shape2 = new Area(new Rectangle(0, frame.getHeight() - 15, frame.getWidth(), 15));
            shape1.add(shape2);
            frame.setShape(shape1);
            frame.getRootPane().setBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, new Color(100, 100, 100)));
        }
        GraphicsConfiguration config = frame.getGraphicsConfiguration();
        GraphicsDevice myScreen = config.getDevice();
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] allScreens = env.getScreenDevices();
        int screenIndex = -1;
        int i = 0;
        while (i < allScreens.length) {
            if (allScreens[i].equals(myScreen)) {
                screenIndex = i;
                break;
            }
            ++i;
        }
        DisplayMode dm = allScreens[screenIndex].getDisplayMode();
        int refreshRate = dm.getRefreshRate();
        screenRefreshRate = refreshRate == 0 ? 16.666666 : 1000.0 / (double)refreshRate;
        this.topPanel();
        btnCapture = new JButton(Shutter.language.getProperty("btnCaptureIn"));
        btnCapture.setFont(new Font(Shutter.montserratFont, 0, 12));
        btnCapture.setMargin(new Insets(0, 0, 0, 0));
        btnCapture.setBounds(9, this.topPanel.getSize().height + 10, 310, 21);
        frame.getContentPane().add(btnCapture);
        btnCapture.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.setCursor(Cursor.getPredefinedCursor(3));
                if (FFPROBE.totalLength <= 40 || Shutter.inputDeviceIsRunning) {
                    Picture.main(true, true);
                } else {
                    Picture.main(true, true);
                }
                frame.setCursor(Cursor.getPredefinedCursor(0));
                if (RenderQueue.frame != null && RenderQueue.frame.isVisible()) {
                    Shutter.btnStart.setText(Shutter.language.getProperty("btnAddToRender"));
                } else {
                    Shutter.btnStart.setText(Shutter.language.getProperty("btnStartFunction"));
                }
            }
        });
        this.btnApply = new JButton(Shutter.language.getProperty("btnApply"));
        this.btnApply.setFont(new Font(Shutter.montserratFont, 0, 12));
        this.btnApply.setMargin(new Insets(0, 0, 0, 0));
        this.btnApply.setBounds(VideoPlayer.frame.getSize().width - 8 - 310 - 2, this.topPanel.getSize().height + 10, 310, 21);
        frame.getContentPane().add(this.btnApply);
        this.btnApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles"))) {
                    Shutter.caseInAndOut.setSelected(false);
                    SubtitlesTimeline.frame.dispose();
                } else {
                    Utils.changeFrameVisibility(frame, true);
                }
            }
        });
        lblVideo = new JLabel();
        lblVideo.setVisible(false);
        lblVideo.setFont(new Font("SansSerif", 1, 13));
        lblVideo.setForeground(Utils.themeColor);
        lblVideo.setHorizontalAlignment(0);
        frame.getContentPane().add(lblVideo);
        this.player();
        this.buttons();
        this.grpColorimetry();
        this.grpCorrections();
        this.grpTransitions();
        this.grpCrop();
        this.grpOverlay();
        this.grpSubtitles();
        this.grpWatermark();
        this.grpIn();
        this.sliders();
        this.grpOut();
        lblPosition = new JLabel();
        lblPosition.setHorizontalAlignment(0);
        lblPosition.setFont(new Font(Shutter.montserratFont, 0, 13));
        lblPosition.setForeground(Utils.themeColor);
        frame.getContentPane().add(lblPosition);
        lblDuration = new JLabel();
        lblDuration.setHorizontalAlignment(0);
        lblDuration.setFont(new Font(Shutter.montserratFont, 0, 13));
        lblDuration.setForeground(Utils.themeColor);
        frame.getContentPane().add(lblDuration);
        VideoPlayer.setMedia();
        VideoPlayer.totalDuration();
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Settings.saveSettings();
            }
        });
        frame.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (windowDrag) {
                    frame.setSize(e.getX() + 10, e.getY() + 10);
                    VideoPlayer.this.resizeAll();
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (MouseInfo.getPointerInfo().getLocation().x - VideoPlayer.frame.getLocation().x > VideoPlayer.frame.getSize().width - 20 || MouseInfo.getPointerInfo().getLocation().y - VideoPlayer.frame.getLocation().y > VideoPlayer.frame.getSize().height - 20) {
                    frame.setCursor(Cursor.getPredefinedCursor(5));
                } else if (!windowDrag && !frame.getCursor().equals(Cursor.getPredefinedCursor(3))) {
                    frame.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        frame.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (frame.getCursor().getType() == 5) {
                    windowDrag = true;
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (Shutter.liste.getSize() > 0 && !Shutter.fileList.getSelectedValue().equals(videoPath)) {
                    VideoPlayer.setMedia();
                }
                windowDrag = false;
                VideoPlayer.this.resizeAll();
                frame.setCursor(Cursor.getPredefinedCursor(0));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (frame.getCursor().getType() == 5) {
                    frame.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        frame.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
                frame.toFront();
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }
        });
        frame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                if (!windowDrag) {
                    VideoPlayer.this.resizeAll();
                }
            }
        });
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                KeyEvent e = (KeyEvent)event;
                if (caseAddWatermark.isSelected()) {
                    if (e.getID() == 401) {
                        boolean update = false;
                        if (e.getKeyCode() == 38) {
                            logo.setLocation(VideoPlayer.logo.getLocation().x, VideoPlayer.logo.getLocation().y - 1);
                            update = true;
                        }
                        if (e.getKeyCode() == 40) {
                            logo.setLocation(VideoPlayer.logo.getLocation().x, VideoPlayer.logo.getLocation().y + 1);
                            update = true;
                        }
                        if (e.getKeyCode() == 37) {
                            logo.setLocation(VideoPlayer.logo.getLocation().x - 1, VideoPlayer.logo.getLocation().y);
                            update = true;
                        }
                        if (e.getKeyCode() == 39) {
                            logo.setLocation(VideoPlayer.logo.getLocation().x + 1, VideoPlayer.logo.getLocation().y);
                            update = true;
                        }
                        if (update) {
                            textWatermarkPosX.setText(String.valueOf((Object)((int)Math.floor((float)VideoPlayer.logo.getLocation().x * imageRatio))));
                            textWatermarkPosY.setText(String.valueOf((Object)((int)Math.floor((float)VideoPlayer.logo.getLocation().y * imageRatio))));
                            logoLocX = VideoPlayer.logo.getLocation().x;
                            logoLocY = VideoPlayer.logo.getLocation().y;
                        }
                    }
                } else {
                    int mouseInPictureX = MouseInfo.getPointerInfo().getLocation().x - VideoPlayer.frame.getLocation().x - frameCropX;
                    int mouseInPictureY = MouseInfo.getPointerInfo().getLocation().y - VideoPlayer.frame.getLocation().y - frameCropY;
                    if (mouseInPictureX > 0 && mouseInPictureX < player.getWidth() && mouseInPictureY > 0 && mouseInPictureY < player.getHeight() && e.getID() == 401) {
                        if (e.getKeyCode() == 16) {
                            shift = true;
                        }
                        if (e.getKeyCode() == 17) {
                            ctrl = true;
                        }
                        if (e.getKeyCode() == 38) {
                            selection.setLocation(VideoPlayer.selection.getLocation().x, VideoPlayer.selection.getLocation().y - 1);
                        }
                        if (e.getKeyCode() == 40) {
                            selection.setLocation(VideoPlayer.selection.getLocation().x, VideoPlayer.selection.getLocation().y + 1);
                        }
                        if (e.getKeyCode() == 37) {
                            selection.setLocation(VideoPlayer.selection.getLocation().x - 1, VideoPlayer.selection.getLocation().y);
                        }
                        if (e.getKeyCode() == 39) {
                            selection.setLocation(VideoPlayer.selection.getLocation().x + 1, VideoPlayer.selection.getLocation().y);
                        }
                        if (e.getKeyCode() == 27) {
                            selection.setBounds(player.getWidth() / 4, player.getHeight() / 4, player.getWidth() / 2, player.getHeight() / 2);
                            anchorRight = VideoPlayer.selection.getLocation().x + selection.getWidth();
                            anchorBottom = VideoPlayer.selection.getLocation().y + selection.getHeight();
                        }
                        VideoPlayer.checkSelection();
                    }
                    if (e.getID() == 402) {
                        if (e.getKeyCode() == 16) {
                            shift = false;
                        }
                        if (e.getKeyCode() == 17) {
                            ctrl = false;
                        }
                    }
                }
            }
        }, 8L);
        KeyListener keyListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 109 || e.getKeyCode() == 107) {
                    boolean resfreshSliderSpeed = false;
                    if (e.getKeyCode() == 107 && sliderSpeed.getValue() < 4) {
                        sliderSpeed.setValue(sliderSpeed.getValue() + 1);
                        resfreshSliderSpeed = true;
                    }
                    if (e.getKeyCode() == 109 && sliderSpeed.getValue() > 0) {
                        sliderSpeed.setValue(sliderSpeed.getValue() - 1);
                        resfreshSliderSpeed = true;
                    }
                    if (resfreshSliderSpeed) {
                        if (sliderSpeed.getValue() == 0) {
                            lblSpeed.setText(String.valueOf(Shutter.language.getProperty("conformBySpeed")) + " x0.25");
                        } else if (sliderSpeed.getValue() == 1) {
                            lblSpeed.setText(String.valueOf(Shutter.language.getProperty("conformBySpeed")) + " x0.5");
                        } else if (sliderSpeed.getValue() == 2) {
                            lblSpeed.setText(String.valueOf(Shutter.language.getProperty("conformBySpeed")) + " x1");
                        } else if (sliderSpeed.getValue() == 3) {
                            lblSpeed.setText(String.valueOf(Shutter.language.getProperty("conformBySpeed")) + " x1.5");
                        } else if (sliderSpeed.getValue() == 4) {
                            lblSpeed.setText(String.valueOf(Shutter.language.getProperty("conformBySpeed")) + " x2");
                        }
                        lblSpeed.setBounds(sliderSpeed.getX() - VideoPlayer.lblSpeed.getPreferredSize().width - 2, sliderSpeed.getY() + 2, VideoPlayer.lblSpeed.getPreferredSize().width, 16);
                        if (slider.getValue() > 0) {
                            frameIsComplete = false;
                            VideoPlayer.playerSetTime(slider.getValue());
                        }
                    }
                }
                if (e.getKeyCode() == 75 || e.getKeyCode() == 32) {
                    e.consume();
                    btnPlay.doClick();
                }
                if (e.getKeyCode() == 74) {
                    VideoPlayer.playerSetTime(playerCurrentFrame - 10.0f);
                }
                if (e.getKeyCode() == 76) {
                    VideoPlayer.playerSetTime(playerCurrentFrame + 10.0f);
                }
                if (!Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles"))) {
                    if (e.getID() == 401 && e.getKeyCode() == 16) {
                        shift = true;
                    }
                    if (e.getKeyCode() == 73) {
                        if (shift) {
                            btnGoToIn.doClick();
                        } else {
                            btnMarkIn.doClick();
                        }
                    }
                    if (e.getKeyCode() == 79) {
                        if (shift) {
                            btnGoToOut.doClick();
                        } else if (cursorWaveform.getX() > playerInMark) {
                            btnMarkOut.doClick();
                        }
                    }
                }
                if (playerVideo != null) {
                    if (e.getKeyCode() == 37) {
                        btnPrevious.doClick();
                    }
                    if (e.getKeyCode() == 39) {
                        btnNext.doClick();
                    }
                    if (e.getKeyCode() == 38) {
                        btnGoToOut.doClick();
                    }
                    if (e.getKeyCode() == 40) {
                        btnGoToIn.doClick();
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getID() == 402 && e.getKeyCode() == 16) {
                    shift = false;
                }
            }
        };
        Component[] componentArray = frame.getContentPane().getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            component.addKeyListener(keyListener);
            ++n2;
        }
        frame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e2) {
                Area shape1 = new Area(new RoundRectangle2D.Double(0.0, 0.0, frame.getWidth(), frame.getHeight(), 15.0, 15.0));
                Area shape2 = new Area(new Rectangle(0, frame.getHeight() - 15, frame.getWidth(), 15));
                shape1.add(shape2);
                frame.setShape(shape1);
            }
        });
        Utils.changeFrameVisibility(frame, false);
        frame.setCursor(Cursor.getPredefinedCursor(0));
        Shutter.frame.setCursor(Cursor.getPredefinedCursor(0));
        this.resizeAll();
    }

    public static void playerProcess(float inputTime) {
        try {
            ProcessBuilder pba;
            ProcessBuilder pbv;
            String PathToFFMPEG = Shutter.class.getProtectionDomain().getCodeSource().getLocation().getPath();
            if (System.getProperty("os.name").contains("Windows")) {
                PathToFFMPEG = PathToFFMPEG.substring(1, PathToFFMPEG.length() - 1);
                PathToFFMPEG = String.valueOf(PathToFFMPEG.substring(0, PathToFFMPEG.lastIndexOf("/")).replace("%20", " ")) + "\\Library\\ffmpeg.exe";
                pbv = new ProcessBuilder("cmd.exe", "/c", String.valueOf('\"') + PathToFFMPEG + '\"' + VideoPlayer.setVideoCommand(inputTime, player.getWidth(), player.getHeight(), playerPlayVideo));
                playerVideo = pbv.start();
                if (casePlaySound.isSelected() || !mouseIsPressed || !sliderChange && !frameControl) {
                    pba = new ProcessBuilder("cmd.exe", "/c", String.valueOf('\"') + PathToFFMPEG + '\"' + VideoPlayer.setAudioCommand(inputTime));
                    playerAudio = pba.start();
                }
            } else {
                PathToFFMPEG = PathToFFMPEG.substring(0, PathToFFMPEG.length() - 1);
                PathToFFMPEG = String.valueOf(PathToFFMPEG.substring(0, PathToFFMPEG.lastIndexOf("/")).replace("%20", "\\ ")) + "/Library/ffmpeg";
                pbv = new ProcessBuilder("/bin/bash", "-c", String.valueOf(PathToFFMPEG) + VideoPlayer.setVideoCommand(inputTime, player.getWidth(), player.getHeight(), playerPlayVideo));
                playerVideo = pbv.start();
                if (casePlaySound.isSelected() || !mouseIsPressed || !sliderChange && !frameControl) {
                    pba = new ProcessBuilder("/bin/bash", "-c", String.valueOf(PathToFFMPEG) + VideoPlayer.setAudioCommand(inputTime));
                    playerAudio = pba.start();
                }
            }
            final InputStream video = playerVideo.getInputStream();
            final BufferedInputStream videoInputStream = new BufferedInputStream(video);
            if (casePlaySound.isSelected() || !mouseIsPressed || !sliderChange && !frameControl) {
                audio = playerAudio.getInputStream();
                audioInputStream = AudioSystem.getAudioInputStream(audio);
                AudioFormat audioFormat = audioInputStream.getFormat();
                DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
                line = (SourceDataLine)AudioSystem.getLine(info);
                line.open(audioFormat);
                gainControl = (FloatControl)line.getControl(FloatControl.Type.MASTER_GAIN);
                line.start();
            }
            playerThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    byte[] bytes = new byte[(int)Math.ceil((float)(FFPROBE.audioSampleRate * 4) / FFPROBE.currentFPS)];
                    int bytesRead = 0;
                    do {
                        long startTime = System.nanoTime() + (long)((int)(inputFramerateMS * 1000000.0f));
                        if (playerLoop) {
                            long time3;
                            long delay;
                            block34: {
                                Throwable throwable2;
                                block36: {
                                    long time2;
                                    block35: {
                                        try {
                                            try {
                                                if (casePlaySound.isSelected() || !sliderChange && !frameControl) {
                                                    closeAudioStream = true;
                                                    double gain = (double)sliderVolume.getValue() / 100.0;
                                                    float dB = (float)(Math.log(gain) / Math.log(10.0) * 20.0) + (float)sliderVolume.getValue() / 16.666666f;
                                                    gainControl.setValue(dB);
                                                    bytesRead = audioInputStream.read(bytes, 0, bytes.length);
                                                    line.write(bytes, 0, bytesRead);
                                                } else {
                                                    closeAudioStream = false;
                                                }
                                                frameVideo = ImageIO.read(videoInputStream);
                                                VideoPlayer.playerRepaint();
                                                ++fps;
                                                playerCurrentFrame = sliderSpeed.getValue() != 2 ? (sliderSpeed.getValue() != 0 ? (playerCurrentFrame += 1.0f * ((float)sliderSpeed.getValue() / 2.0f)) : (playerCurrentFrame += 0.25f)) : (playerCurrentFrame += 1.0f);
                                                break block34;
                                            }
                                            catch (Exception exception) {
                                                if (frameControl) {
                                                    playerLoop = false;
                                                    VideoPlayer.getTimePoint(playerCurrentFrame);
                                                    break block35;
                                                }
                                                if (!playerPlayVideo || (delay = startTime - System.nanoTime()) <= 0L) break block35;
                                                try {
                                                    Thread.sleep((int)(delay / 1000000L / 2L));
                                                }
                                                catch (InterruptedException interruptedException) {
                                                    // empty catch block
                                                }
                                                delay = startTime - System.nanoTime();
                                                time3 = System.nanoTime();
                                            }
                                        }
                                        catch (Throwable throwable2) {
                                            if (frameControl) {
                                                playerLoop = false;
                                                VideoPlayer.getTimePoint(playerCurrentFrame);
                                                break block36;
                                            }
                                            if (!playerPlayVideo || (delay = startTime - System.nanoTime()) <= 0L) break block36;
                                            try {
                                                Thread.sleep((int)(delay / 1000000L / 2L));
                                            }
                                            catch (InterruptedException time3) {
                                                // empty catch block
                                            }
                                            delay = startTime - System.nanoTime();
                                            time2 = System.nanoTime();
                                        }
                                        while (System.nanoTime() - time3 < delay) {
                                        }
                                    }
                                    frameIsComplete = true;
                                    continue;
                                    while (System.nanoTime() - time2 < delay) {
                                    }
                                }
                                frameIsComplete = true;
                                throw throwable2;
                            }
                            if (frameControl) {
                                playerLoop = false;
                                VideoPlayer.getTimePoint(playerCurrentFrame);
                            } else if (playerPlayVideo && (delay = startTime - System.nanoTime()) > 0L) {
                                try {
                                    Thread.sleep((int)(delay / 1000000L / 2L));
                                }
                                catch (InterruptedException time2) {
                                    // empty catch block
                                }
                                delay = startTime - System.nanoTime();
                                time3 = System.nanoTime();
                                while (System.nanoTime() - time3 < delay) {
                                }
                            }
                            frameIsComplete = true;
                            continue;
                        }
                        if (line != null && closeAudioStream) {
                            line.flush();
                        }
                        try {
                            Thread.sleep(1L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } while (playerVideo.isAlive());
                    try {
                        video.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        videoInputStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (audio != null && closeAudioStream) {
                        try {
                            audio.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        try {
                            audioInputStream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        line.close();
                    }
                }
            });
            playerThread.setPriority(10);
            playerThread.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void playerPlay() {
        if (playerVideo == null || !playerVideo.isAlive()) {
            VideoPlayer.playerProcess(playerCurrentFrame);
        }
    }

    public static void playerStop() {
        closeAudioStream = true;
        playerLoop = false;
        if (playerVideo != null) {
            playerVideo.destroy();
            playerThread.interrupt();
        }
        if (playerAudio != null) {
            playerAudio.destroy();
        }
    }

    public static void playerRepaint() {
        long time;
        if (frameVideo != null && (double)(time = System.currentTimeMillis()) > (double)lastEvTime + screenRefreshRate) {
            lastEvTime = time;
            player.repaint();
            VideoPlayer.getTimePoint(playerCurrentFrame);
        }
    }

    public static boolean playerIsPlaying() {
        return playerVideo != null && playerVideo.isAlive() && btnPlay.getText().equals(Shutter.language.getProperty("btnPause"));
    }

    public static void playerSetTime(final float time) {
        if (setTime == null || !setTime.isAlive() && frameVideo != null) {
            setTime = new Thread(new Runnable(){

                @Override
                public void run() {
                    int t = (int)Math.ceil(time);
                    if (t < 0) {
                        t = 0;
                    }
                    VideoPlayer.writeCurrentSubs(t);
                    playerPlayVideo = false;
                    boolean playback = VideoPlayer.playerIsPlaying();
                    if (frameVideo != null) {
                        VideoPlayer.playerStop();
                        do {
                            try {
                                Thread.sleep(1L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        } while (playerThread.isAlive());
                        frameControl = true;
                        frameIsComplete = false;
                        playerLoop = true;
                        VideoPlayer.playerProcess(t);
                        long time2 = System.currentTimeMillis();
                        do {
                            try {
                                Thread.sleep(1L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            if (System.currentTimeMillis() - time2 <= 1000L) continue;
                            frameIsComplete = true;
                        } while (!frameIsComplete);
                        playerLoop = playback && !mouseIsPressed;
                        playerCurrentFrame = t;
                        VideoPlayer.getTimePoint(playerCurrentFrame);
                        timecode.repaint();
                    }
                    frameControl = false;
                    playerPlayVideo = true;
                }
            });
            setTime.start();
        }
    }

    public static void playerFreeze() {
        frameControl = true;
        playerPlayVideo = false;
        if (playerVideo == null || !playerVideo.isAlive()) {
            frameControl = true;
            frameIsComplete = false;
            playerLoop = true;
            VideoPlayer.playerProcess(playerCurrentFrame);
            long time = System.currentTimeMillis();
            do {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (System.currentTimeMillis() - time <= 1000L) continue;
                frameIsComplete = true;
            } while (!frameIsComplete);
            if (playerCurrentFrame > 0.0f) {
                playerCurrentFrame -= 1.0f;
            }
            VideoPlayer.getTimePoint(playerCurrentFrame);
        }
        frameControl = false;
        playerPlayVideo = true;
    }

    public static void setMedia() {
        block123: {
            block125: {
                block124: {
                    int c2;
                    int n;
                    Component[] componentArray;
                    Object[] objectArray;
                    block122: {
                        if (!Shutter.caseInAndOut.isSelected()) break block123;
                        if (Shutter.liste.getSize() == 0) break block124;
                        if (Shutter.fileList.getSelectedIndices().length == 0) {
                            Shutter.fileList.setSelectedIndex(0);
                        }
                        videoPath = Shutter.fileList.getSelectedValue();
                        VideoPlayer.refreshTimecodeAndText();
                        if (preview.exists()) {
                            preview.delete();
                        }
                        if (Shutter.scanIsRunning) {
                            File dir = new File(Shutter.liste.firstElement());
                            File[] fileArray = dir.listFiles();
                            int n2 = fileArray.length;
                            int n3 = 0;
                            while (n3 < n2) {
                                File f = fileArray[n3];
                                if (!f.isHidden() && f.isFile()) {
                                    videoPath = f.toString();
                                    break;
                                }
                                ++n3;
                            }
                        }
                        if (frame.isVisible() && !lblVideo.getText().equals(new File(videoPath).getName()) && cursorWaveform.isVisible() && !Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles"))) {
                            if (waveform.exists()) {
                                waveform.delete();
                            }
                            if (FFMPEG.isRunning) {
                                FFMPEG.process.destroy();
                            }
                        }
                        if (lblVideo.isVisible() && lblVideo.getText().equals(new File(videoPath).getName())) break block125;
                        String extension = videoPath.substring(videoPath.lastIndexOf("."));
                        try {
                            if (extension.toLowerCase().equals(".pdf")) {
                                XPDF.info(videoPath);
                                do {
                                    Thread.sleep(100L);
                                } while (XPDF.isRunning);
                                XPDF.toFFPROBE(videoPath);
                                do {
                                    Thread.sleep(100L);
                                } while (XPDF.isRunning);
                                break block122;
                            }
                            FFPROBE.Data(videoPath);
                            do {
                                Thread.sleep(100L);
                            } while (FFPROBE.isRunning);
                            FFPROBE.FrameData(videoPath);
                            do {
                                Thread.sleep(100L);
                            } while (FFPROBE.isRunning);
                            FFMPEG.checkGPUCapabilities(videoPath, true);
                            if (FFPROBE.interlaced == null) {
                                MEDIAINFO.run(videoPath, false);
                                do {
                                    Thread.sleep(100L);
                                } while (MEDIAINFO.isRunning);
                                if (FFPROBE.interlaced == null) {
                                    FFPROBE.interlaced = "0";
                                    FFPROBE.fieldOrder = "0";
                                }
                            }
                            boolean isRaw = false;
                            switch (extension.toLowerCase()) {
                                case ".3fr": 
                                case ".arw": 
                                case ".cr2": 
                                case ".cr3": 
                                case ".crw": 
                                case ".dng": 
                                case ".kdc": 
                                case ".mrw": 
                                case ".nef": 
                                case ".nrw": 
                                case ".orf": 
                                case ".pef": 
                                case ".r3d": 
                                case ".ptx": 
                                case ".raf": 
                                case ".rw2": 
                                case ".srw": 
                                case ".x3f": {
                                    isRaw = true;
                                }
                            }
                            if (extension.toLowerCase().equals(".pdf")) {
                                XPDF.toFFPROBE(videoPath);
                                do {
                                    Thread.sleep(100L);
                                } while (XPDF.isRunning);
                            } else if (isRaw || Shutter.comboFonctions.getSelectedItem().toString().equals("JPEG") || Shutter.comboFonctions.getSelectedItem().toString().equals(Shutter.language.getProperty("functionPicture"))) {
                                EXIFTOOL.run(videoPath);
                                do {
                                    Thread.sleep(100L);
                                } while (EXIFTOOL.isRunning);
                            }
                            if (FFPROBE.imageRatio < 1.77f) {
                                frame.setMinimumSize(new Dimension(1300, 724));
                            } else {
                                frame.setMinimumSize(new Dimension(1300, 624));
                            }
                            Area shape1 = new Area(new RoundRectangle2D.Double(0.0, 0.0, frame.getWidth(), frame.getHeight(), 15.0, 15.0));
                            Area shape2 = new Area(new Rectangle(0, frame.getHeight() - 15, frame.getWidth(), 15));
                            shape1.add(shape2);
                            frame.setShape(shape1);
                            frame.getRootPane().setBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, new Color(100, 100, 100)));
                        }
                        catch (InterruptedException isRaw) {
                            // empty catch block
                        }
                    }
                    if (Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles"))) {
                        btnPreviousFile.setVisible(false);
                        btnNextFile.setVisible(false);
                        grpColorimetry.setVisible(false);
                        grpCorrections.setVisible(false);
                        grpTransitions.setVisible(false);
                        grpCrop.setVisible(false);
                        grpOverlay.setVisible(false);
                        grpSubtitles.setVisible(false);
                        grpWatermark.setVisible(false);
                        waveformContainer.setVisible(true);
                        grpIn.setVisible(false);
                        grpOut.setVisible(false);
                        lblDuration.setVisible(false);
                        lblPosition.setVisible(true);
                        lblVolume.setVisible(true);
                        sliderVolume.setVisible(true);
                        lblSpeed.setVisible(false);
                        sliderSpeed.setVisible(false);
                        lblMode.setVisible(false);
                        comboMode.setVisible(false);
                        btnPreview.setVisible(false);
                        splitValue.setVisible(false);
                        lblSplitSec.setVisible(false);
                        btnGoToIn.setVisible(false);
                        btnMarkIn.setVisible(false);
                        btnPlay.setVisible(true);
                        btnPrevious.setVisible(true);
                        btnNext.setVisible(true);
                        btnStop.setVisible(true);
                        btnMarkOut.setVisible(false);
                        btnGoToOut.setVisible(false);
                        caseInternalTc.setVisible(false);
                        caseGPU.setVisible(true);
                        caseVuMeter.setVisible(true);
                        casePlaySound.setVisible(true);
                        btnCapture.setEnabled(false);
                        showScale.setVisible(false);
                    } else if (FFPROBE.totalLength <= 40) {
                        btnPreviousFile.setVisible(true);
                        btnNextFile.setVisible(true);
                        grpColorimetry.setVisible(true);
                        grpCorrections.setVisible(true);
                        grpTransitions.setVisible(true);
                        grpTransitions.setEnabled(false);
                        grpCrop.setVisible(true);
                        grpOverlay.setVisible(true);
                        grpSubtitles.setVisible(true);
                        grpWatermark.setVisible(true);
                        waveformContainer.setVisible(false);
                        grpIn.setVisible(false);
                        grpOut.setVisible(false);
                        lblDuration.setVisible(false);
                        lblPosition.setVisible(false);
                        lblVolume.setVisible(false);
                        sliderVolume.setVisible(false);
                        lblSpeed.setVisible(false);
                        sliderSpeed.setVisible(false);
                        lblMode.setVisible(false);
                        comboMode.setVisible(false);
                        btnPreview.setVisible(false);
                        splitValue.setVisible(false);
                        lblSplitSec.setVisible(false);
                        btnGoToIn.setVisible(false);
                        btnMarkIn.setVisible(false);
                        float ratio = FFPROBE.imageRatio;
                        if (Shutter.caseRotate.isSelected() && (Shutter.comboRotate.getSelectedIndex() == 0 || Shutter.comboRotate.getSelectedIndex() == 1)) {
                            ratio = (float)FFPROBE.imageHeight / (float)FFPROBE.imageWidth;
                        }
                        if (ratio > 0.8f) {
                            showScale.setVisible(true);
                        } else {
                            showScale.setVisible(false);
                        }
                        showFPS.setVisible(false);
                        if (Shutter.caseEnableSequence.isSelected()) {
                            btnPlay.setVisible(true);
                        } else {
                            btnPlay.setVisible(false);
                        }
                        btnPrevious.setVisible(false);
                        btnNext.setVisible(false);
                        if (Shutter.caseEnableSequence.isSelected()) {
                            btnStop.setVisible(true);
                        } else {
                            btnStop.setVisible(false);
                        }
                        btnMarkOut.setVisible(false);
                        btnGoToOut.setVisible(false);
                        caseInternalTc.setVisible(false);
                        caseGPU.setVisible(false);
                        caseVuMeter.setVisible(false);
                        casePlaySound.setVisible(false);
                        btnCapture.setEnabled(true);
                        if (Shutter.caseEnableSequence.isSelected()) {
                            grpSubtitles.setEnabled(true);
                            caseAddSubtitles.setEnabled(true);
                        } else {
                            grpSubtitles.setEnabled(false);
                            objectArray = grpSubtitles.getComponents();
                            int n4 = objectArray.length;
                            int n5 = 0;
                            while (n5 < n4) {
                                Component c2 = objectArray[n5];
                                c2.setEnabled(false);
                                ++n5;
                            }
                        }
                    } else {
                        btnPreviousFile.setVisible(true);
                        btnNextFile.setVisible(true);
                        if (FFPROBE.audioOnly) {
                            grpColorimetry.setVisible(false);
                            grpCorrections.setVisible(false);
                            grpTransitions.setVisible(true);
                            grpTransitions.setEnabled(true);
                            grpTransitions.setLocation(grpColorimetry.getLocation());
                            caseVideoFadeIn.setEnabled(false);
                            caseVideoFadeOut.setEnabled(false);
                            grpCrop.setVisible(false);
                            grpOverlay.setVisible(false);
                            grpSubtitles.setVisible(false);
                            grpWatermark.setVisible(false);
                        } else {
                            grpColorimetry.setVisible(true);
                            grpCorrections.setVisible(true);
                            grpTransitions.setVisible(true);
                            grpTransitions.setEnabled(true);
                            grpTransitions.setLocation(VideoPlayer.grpColorimetry.getLocation().x, VideoPlayer.grpCorrections.getSize().height + VideoPlayer.grpCorrections.getLocation().y + 6);
                            caseVideoFadeIn.setEnabled(true);
                            if (caseVideoFadeIn.isSelected()) {
                                spinnerVideoFadeIn.setEnabled(true);
                            }
                            caseVideoFadeOut.setEnabled(true);
                            if (caseVideoFadeOut.isSelected()) {
                                spinnerVideoFadeOut.setEnabled(true);
                            }
                            grpCrop.setVisible(true);
                            grpOverlay.setVisible(true);
                            grpSubtitles.setVisible(true);
                            grpWatermark.setVisible(true);
                        }
                        waveformContainer.setVisible(true);
                        grpIn.setVisible(true);
                        grpOut.setVisible(true);
                        lblDuration.setVisible(true);
                        lblPosition.setVisible(true);
                        lblVolume.setVisible(true);
                        sliderVolume.setVisible(true);
                        lblSpeed.setVisible(true);
                        sliderSpeed.setVisible(true);
                        lblMode.setVisible(true);
                        comboMode.setVisible(true);
                        if (comboMode.getSelectedItem().equals(Shutter.language.getProperty("removeMode"))) {
                            btnPreview.setVisible(true);
                            splitValue.setVisible(false);
                            lblSplitSec.setVisible(false);
                        } else if (comboMode.getSelectedItem().equals(Shutter.language.getProperty("splitMode"))) {
                            btnPreview.setVisible(false);
                            splitValue.setVisible(true);
                            lblSplitSec.setVisible(true);
                        } else {
                            btnPreview.setVisible(true);
                            splitValue.setVisible(false);
                            lblSplitSec.setVisible(false);
                        }
                        btnGoToIn.setVisible(true);
                        btnMarkIn.setVisible(true);
                        btnPlay.setVisible(true);
                        btnPrevious.setVisible(true);
                        btnNext.setVisible(true);
                        btnStop.setVisible(true);
                        btnMarkOut.setVisible(true);
                        btnGoToOut.setVisible(true);
                        caseGPU.setVisible(true);
                        caseVuMeter.setVisible(true);
                        casePlaySound.setVisible(true);
                        if (FFPROBE.audioOnly || Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles"))) {
                            btnCapture.setEnabled(false);
                            caseInternalTc.setVisible(false);
                            showScale.setVisible(false);
                            showFPS.setVisible(false);
                        } else {
                            btnCapture.setEnabled(true);
                            caseInternalTc.setVisible(true);
                            showScale.setVisible(true);
                        }
                        grpSubtitles.setEnabled(true);
                        caseAddSubtitles.setEnabled(true);
                        if (caseShowTimecode.isSelected() || caseInternalTc.isSelected()) {
                            if (FFPROBE.timecode1.equals("")) {
                                if (caseShowTimecode.isSelected()) {
                                    caseShowTimecode.setSelected(false);
                                    caseAddTimecode.doClick();
                                }
                                if (caseInternalTc.isSelected()) {
                                    caseInternalTc.setSelected(false);
                                    offset = 0.0f;
                                }
                            } else {
                                if (caseShowTimecode.isSelected()) {
                                    TC1.setEnabled(false);
                                    TC2.setEnabled(false);
                                    TC3.setEnabled(false);
                                    TC4.setEnabled(false);
                                    caseAddTimecode.setSelected(false);
                                    player.add(timecode);
                                    if (caseEnableCrop.isSelected()) {
                                        player.remove(selection);
                                        player.remove(overImage);
                                        player.add(selection);
                                        player.add(overImage);
                                    }
                                }
                                if (caseInternalTc.isSelected()) {
                                    offset = (float)(Integer.valueOf(FFPROBE.timecode1) * 3600) * FFPROBE.currentFPS + (float)(Integer.valueOf(FFPROBE.timecode2) * 60) * FFPROBE.currentFPS + (float)Integer.valueOf(FFPROBE.timecode3).intValue() * FFPROBE.currentFPS + (float)Integer.valueOf(FFPROBE.timecode4).intValue();
                                }
                            }
                        }
                    }
                    seekOnKeyFrames = false;
                    if (!FFPROBE.audioOnly && (Shutter.comboFonctions.getSelectedItem().toString().equals(Shutter.language.getProperty("functionCut")) || Shutter.comboFonctions.getSelectedItem().toString().equals(Shutter.language.getProperty("functionRewrap")))) {
                        FFPROBE.AnalyzeGOP(videoPath, false);
                        do {
                            try {
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException ratio) {
                                // empty catch block
                            }
                            if (FFPROBE.gopCount <= 2) continue;
                            seekOnKeyFrames = true;
                            FFPROBE.process.destroy();
                            break;
                        } while (FFPROBE.isRunning);
                        grpCrop.setEnabled(false);
                        componentArray = grpCrop.getComponents();
                        n = componentArray.length;
                        c2 = 0;
                        while (c2 < n) {
                            Component c3 = componentArray[c2];
                            c3.setEnabled(false);
                            ++c2;
                        }
                        grpOverlay.setEnabled(false);
                        componentArray = grpOverlay.getComponents();
                        n = componentArray.length;
                        c2 = 0;
                        while (c2 < n) {
                            Component c4 = componentArray[c2];
                            c4.setEnabled(false);
                            ++c2;
                        }
                        grpWatermark.setEnabled(false);
                        componentArray = grpWatermark.getComponents();
                        n = componentArray.length;
                        c2 = 0;
                        while (c2 < n) {
                            Component c5 = componentArray[c2];
                            c5.setEnabled(false);
                            ++c2;
                        }
                    } else {
                        grpCrop.setEnabled(true);
                        caseEnableCrop.setEnabled(true);
                        grpOverlay.setEnabled(true);
                        componentArray = grpOverlay.getComponents();
                        n = componentArray.length;
                        c2 = 0;
                        while (c2 < n) {
                            Component c6 = componentArray[c2];
                            c6.setEnabled(true);
                            ++c2;
                        }
                        grpWatermark.setEnabled(true);
                        caseAddWatermark.setEnabled(true);
                        caseSafeArea.setEnabled(true);
                    }
                    if (Shutter.caseEnableSequence.isSelected()) {
                        FunctionUtils.setConcat(new File("concat.txt"), Shutter.dirTemp);
                        inputFramerateMS = Float.parseFloat(Shutter.caseSequenceFPS.getSelectedItem().toString().replace(",", "."));
                    } else {
                        inputFramerateMS = 1000.0f / FFPROBE.currentFPS;
                    }
                    totalFrames = Math.round((float)FFPROBE.totalLength / inputFramerateMS);
                    playerCurrentFrame = 0.0f;
                    caseInternalTc.setEnabled(true);
                    caseShowTimecode.setEnabled(true);
                    textSubsWidth.setText(String.valueOf(FFPROBE.imageWidth));
                    lblVideo.setText(new File(videoPath).getName());
                    lblVideo.setVisible(true);
                    if (FFPROBE.videoCodec != null && FFPROBE.totalLength > 40) {
                        Object vcodec = FFPROBE.videoCodec.replace("video", "");
                        objectArray = Shutter.functionsList;
                        int n6 = Shutter.functionsList.length;
                        n = 0;
                        while (n < n6) {
                            Object s = objectArray[n];
                            if (((String)vcodec).toLowerCase().equals(((String)s).replace(".", "").replace("-", "").toLowerCase()) || ((String)s).toLowerCase().contains(((String)vcodec).toLowerCase())) {
                                vcodec = s;
                                break;
                            }
                            vcodec = ((String)vcodec).toUpperCase();
                            ++n;
                        }
                        showScale.setText(String.valueOf(FFPROBE.imageResolution) + " " + (String)vcodec);
                    } else {
                        showScale.setText(FFPROBE.imageResolution);
                    }
                    btnPlay.setEnabled(true);
                    btnPrevious.setEnabled(true);
                    btnNext.setEnabled(true);
                    btnStop.setEnabled(true);
                    btnMarkIn.setEnabled(true);
                    btnMarkOut.setEnabled(true);
                    btnGoToIn.setEnabled(true);
                    btnGoToOut.setEnabled(true);
                    btnStop.doClick();
                    playerInMark = 0;
                    playerOutMark = waveformContainer.getWidth() - 2;
                    waveformContainer.repaint();
                    VideoPlayer.updateGrpIn(0.0f);
                    VideoPlayer.updateGrpOut(FFPROBE.totalLength);
                    slider.setMaximum((int)totalFrames);
                    if (Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles"))) {
                        SubtitlesTimeline.timelineScrollBar.setMaximum(slider.getMaximum());
                    }
                    break block125;
                }
                btnStop.doClick();
                videoPath = null;
                lblVideo.setVisible(false);
                showScale.setVisible(false);
                VideoPlayer.playerStop();
                slider.setValue(0);
                btnPlay.setText(Shutter.language.getProperty("btnPlay"));
                btnPlay.setEnabled(false);
                btnPrevious.setEnabled(false);
                btnNext.setEnabled(false);
                btnStop.setEnabled(false);
                btnMarkIn.setEnabled(false);
                btnMarkOut.setEnabled(false);
                btnGoToIn.setEnabled(false);
                btnGoToOut.setEnabled(false);
                caseInternalTc.setEnabled(false);
                caseInternalTc.setSelected(false);
            }
            if (Shutter.lblCurrentEncoding.getText().equals(Shutter.language.getProperty("processEnded"))) {
                Shutter.progressBar1.setValue(Shutter.progressBar1.getMaximum());
            }
            if (Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles")) || Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionReplaceAudio"))) {
                grpOut.setVisible(false);
            } else if (waveformContainer.isVisible()) {
                grpOut.setVisible(true);
            }
            if (Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles"))) {
                File video = new File(videoPath);
                String videoWithoutExt = video.getName().substring(0, video.getName().lastIndexOf("."));
                SubtitlesTimeline.srt = new File(String.valueOf(video.getParent()) + "/" + videoWithoutExt + ".srt");
                Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
                frame.setLocation(VideoPlayer.frame.getLocation().x, dim.height / 3 - frame.getHeight() / 2);
                if (caseAddSubtitles.isSelected()) {
                    player.remove(subsCanvas);
                    caseAddSubtitles.setSelected(false);
                }
                if (SubtitlesTimeline.frame == null) {
                    new SubtitlesTimeline(dim.width / 2 - 500, VideoPlayer.frame.getLocation().y + frame.getHeight() + 7);
                } else {
                    SubtitlesTimeline.frame.setVisible(true);
                    SubtitlesTimeline.subtitlesNumber();
                }
            }
            waveformContainer.requestFocus();
        }
    }

    public static String setVideoCommand(float inputTime, int width, int height, boolean isPlaying) throws InterruptedException {
        String yadif = "";
        if (FFPROBE.interlaced.equals("1")) {
            yadif = "yadif=0:" + FFPROBE.fieldOrder + ":0";
        }
        String speed = "";
        if (sliderSpeed.getValue() != 2) {
            speed = sliderSpeed.getValue() != 0 ? String.valueOf(speed) + "setpts=" + 1.0f / ((float)sliderSpeed.getValue() / 2.0f) + "*PTS" : String.valueOf(speed) + "setpts=4*PTS";
        }
        if (FFPROBE.audioOnly) {
            FFPROBE.currentFPS = 25.0f;
            String filter = "";
            if (caseVuMeter.isSelected()) {
                String aspeed = "";
                if (sliderSpeed.getValue() != 2) {
                    aspeed = sliderSpeed.getValue() != 0 ? String.valueOf(aspeed) + "atempo=" + (float)sliderSpeed.getValue() / 2.0f + "," : String.valueOf(aspeed) + "atempo=0.5,atempo=0.5,";
                }
                String channels = "";
                String audioOutput = "";
                int i = 0;
                while (i < FFPROBE.channels) {
                    channels = String.valueOf(channels) + "[0:a:" + i + "]" + aspeed + "showvolume=f=0:w=" + width + ":h=" + Math.round(height / 30) + ":b=4:s=0[a" + i + "];";
                    audioOutput = String.valueOf(audioOutput) + "[a" + i + "]";
                    ++i;
                }
                if (FFPROBE.channels > 1) {
                    audioOutput = String.valueOf(audioOutput) + "vstack=" + i + "[volume];";
                    filter = " -filter_complex \"" + channels + audioOutput + "[1:v][volume]overlay=W*0.5-w*0.5:H*0.5-h*0.5" + '\"';
                } else {
                    audioOutput = audioOutput.replace("[a0]", "");
                    filter = " -filter_complex \"" + channels + audioOutput + "[1:v][a0]overlay=W*0.5-w*0.5:H*0.5-h*0.5" + '\"';
                }
            }
            return " -v quiet -ss " + (long)(inputTime * inputFramerateMS) + "ms -i " + '\"' + videoPath + '\"' + " -f lavfi -i " + '\"' + "color=c=black:r=25:s=" + width + "x" + height + '\"' + filter + " -c:v bmp -an -f image2pipe pipe:-";
        }
        String video = videoPath;
        String concat = "";
        if (Shutter.caseEnableSequence.isSelected()) {
            concat = FunctionUtils.setConcat(new File("concat.txt"), Shutter.dirTemp);
            video = String.valueOf(Shutter.dirTemp) + "concat.txt";
        }
        String gpuDecoding = "";
        if (caseGPU.isSelected()) {
            if (FFMPEG.isGPUCompatible) {
                gpuDecoding = FFMPEG.cudaAvailable ? " -hwaccel cuda -hwaccel_output_format cuda" : (FFMPEG.qsvAvailable ? " -hwaccel qsv -hwaccel_output_format qsv" : " -hwaccel auto");
            } else if (System.getProperty("os.name").contains("Mac")) {
                gpuDecoding = " -hwaccel auto";
            }
        }
        String cmd = String.valueOf(gpuDecoding) + " -v quiet -ss " + (long)(inputTime * inputFramerateMS) + "ms" + concat + " -i " + '\"' + video + '\"' + VideoPlayer.setFilter(yadif, speed, false) + " -c:v bmp -an -f image2pipe pipe:-";
        Console.consoleFFMPEG.append(String.valueOf(System.lineSeparator()) + cmd + System.lineSeparator());
        return cmd;
    }

    public static String setAudioCommand(float inputTime) {
        String speed = "";
        if (sliderSpeed.getValue() != 2) {
            speed = sliderSpeed.getValue() != 0 ? " -af atempo=" + (float)sliderSpeed.getValue() / 2.0f : " -af atempo=0.5,atempo=0.5";
        }
        String audioFade = "";
        if (caseAudioFadeIn.isSelected() || caseAudioFadeOut.isSelected()) {
            audioFade = speed != "" ? String.valueOf(audioFade) + "," : String.valueOf(audioFade) + " -af ";
            audioFade = String.valueOf(audioFade) + Transitions.setAudioFadeIn(true);
            if (Transitions.setAudioFadeIn(true) != "" && Transitions.setAudioFadeOut(true) != "") {
                audioFade = String.valueOf(audioFade) + ",";
            }
            audioFade = String.valueOf(audioFade) + Transitions.setAudioFadeOut(true);
        }
        if (playTransition) {
            playTransition = false;
        }
        if (!FFPROBE.hasAudio) {
            return " -v quiet -f lavfi -i \"anullsrc=channel_layout=stereo:sample_rate=48000\"" + speed + audioFade + " -vn -c:a pcm_s16le -ar 48k -ac 2 -f wav pipe:-";
        }
        return " -v quiet -ss " + (long)(inputTime * inputFramerateMS) + "ms -i " + '\"' + videoPath + '\"' + speed + audioFade + " -vn -c:a pcm_s16le -ac 2 -f wav pipe:-";
    }

    public static void addWaveform(final boolean newWaveform) {
        addWaveformIsRunning = true;
        if (newWaveform || !waveform.exists()) {
            waveformIcon.setVisible(false);
            if (newWaveform) {
                waveform.delete();
            }
        }
        Thread addWaveform = new Thread(new Runnable(){

            @Override
            public void run() {
                block23: {
                    if (FFMPEG.isRunning || playerVideo == null && !frame.isVisible()) {
                        do {
                            try {
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        } while (FFMPEG.isRunning && playerVideo == null && !frame.isVisible());
                    }
                    if ((!FFMPEG.isRunning || Shutter.btnStart.getText().equals(Shutter.language.getProperty("btnPauseFunction"))) && FFPROBE.hasAudio) {
                        if (newWaveform || !waveform.exists()) {
                            long size = 1920L;
                            String start = "";
                            String duration = "";
                            if (Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles"))) {
                                do {
                                    try {
                                        Thread.sleep(100L);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                } while (SubtitlesTimeline.frame == null);
                                if (SubtitlesTimeline.waveform == null) {
                                    SubtitlesTimeline.waveform = new JLabel();
                                }
                                long time = (long)((double)SubtitlesTimeline.timelineScrollBar.getValue() / SubtitlesTimeline.zoom);
                                String h = formatter.format(Math.floor(time / 1000L) / 3600.0);
                                String m = formatter.format(Math.floor(time / 1000L) / 60.0 % 60.0);
                                String s = formatter.format(Math.floor(time / 1000L) % 60.0);
                                String f = formatterToMs.format(time % 1000L);
                                start = " -ss " + h + ":" + m + ":" + s + "." + f;
                                duration = "atrim=duration=" + SubtitlesTimeline.frame.getWidth() / 100 + ",";
                                size = (long)((double)(SubtitlesTimeline.frame.getWidth() * 10) * SubtitlesTimeline.zoom);
                            }
                            if (size > 549944L) {
                                size = 549944L;
                            }
                            FFMPEG.run(String.valueOf(start) + " -i " + '\"' + videoPath + '\"' + " -filter:a aresample=8000 -filter_complex " + '\"' + "[0:a]" + duration + "aformat=channel_layouts=mono,compand,showwavespic=size=" + size + "x360:colors=green|green" + '\"' + " -pix_fmt rgba -vn -frames:v 1 -y " + '\"' + waveform + '\"');
                            Shutter.enableAll();
                            if (RenderQueue.frame != null && RenderQueue.frame.isVisible()) {
                                Shutter.btnStart.setText(Shutter.language.getProperty("btnAddToRender"));
                            } else {
                                Shutter.btnStart.setText(Shutter.language.getProperty("btnStartFunction"));
                            }
                            do {
                                try {
                                    Thread.sleep(10L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            } while (!waveform.exists() && FFMPEG.isRunning);
                        }
                        try {
                            try {
                                if (Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles")) && Shutter.caseInAndOut.isSelected()) {
                                    BufferedImage imageBMP = ImageIO.read(waveform);
                                    ImageIcon resizedWaveform = new ImageIcon(new ImageIcon(imageBMP).getImage().getScaledInstance((int)((double)(SubtitlesTimeline.frame.getWidth() * 10) * SubtitlesTimeline.zoom), SubtitlesTimeline.timeline.getHeight(), 16));
                                    SubtitlesTimeline.waveform.setIcon(resizedWaveform);
                                    SubtitlesTimeline.waveform.setBounds(SubtitlesTimeline.timelineScrollBar.getValue(), SubtitlesTimeline.waveform.getY(), (int)((double)(SubtitlesTimeline.frame.getWidth() * 10) * SubtitlesTimeline.zoom), SubtitlesTimeline.timeline.getHeight());
                                    SubtitlesTimeline.waveform.repaint();
                                    break block23;
                                }
                                BufferedImage imageBMP = ImageIO.read(waveform);
                                ImageIcon resizedWaveform = new ImageIcon(new ImageIcon(imageBMP).getImage().getScaledInstance(waveformContainer.getWidth(), waveformContainer.getHeight(), 16));
                                waveformIcon.setIcon(resizedWaveform);
                                waveformIcon.repaint();
                                waveformIcon.setVisible(true);
                            }
                            catch (Exception exception) {
                                addWaveformIsRunning = false;
                            }
                        }
                        finally {
                            addWaveformIsRunning = false;
                        }
                    }
                }
            }
        });
        addWaveform.start();
    }

    private void buttons() {
        btnPrevious = new JButton("<");
        btnPrevious.setFont(new Font(Shutter.montserratFont, 0, 12));
        btnPrevious.setBounds(VideoPlayer.player.getLocation().x + VideoPlayer.player.getSize().width / 2 - 21 - 4, VideoPlayer.player.getLocation().y + VideoPlayer.player.getSize().height + 10, 22, 21);
        frame.getContentPane().add(btnPrevious);
        btnPrevious.addActionListener(new ActionListener(){
            int i = 0;

            @Override
            public void actionPerformed(ActionEvent e) {
                ++this.i;
                if (frameVideo != null && this.i <= 1) {
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            if (sliderSpeed.getValue() != 2) {
                                sliderSpeed.setValue(2);
                                lblSpeed.setText(String.valueOf(Shutter.language.getProperty("conformBySpeed")) + " x1");
                                lblSpeed.setBounds(sliderSpeed.getX() - VideoPlayer.lblSpeed.getPreferredSize().width - 2, sliderSpeed.getY() + 2, VideoPlayer.lblSpeed.getPreferredSize().width, 16);
                                VideoPlayer.playerSetTime(playerCurrentFrame - 1.0f);
                            }
                            frameControl = true;
                            if (playerVideo != null && frameVideo != null) {
                                if (playerLoop) {
                                    btnPlay.setText(Shutter.language.getProperty("btnPlay"));
                                    playerLoop = false;
                                }
                                frameIsComplete = false;
                                if (seekOnKeyFrames && !FFPROBE.isRunning) {
                                    FFPROBE.Keyframes(videoPath, (playerCurrentFrame - 2.0f) * inputFramerateMS, false);
                                    do {
                                        try {
                                            Thread.sleep(10L);
                                        }
                                        catch (InterruptedException interruptedException) {
                                            // empty catch block
                                        }
                                    } while (FFPROBE.isRunning);
                                    if (FFPROBE.keyFrame > 0.0f) {
                                        VideoPlayer.playerSetTime(FFPROBE.keyFrame);
                                    }
                                } else {
                                    VideoPlayer.playerSetTime(playerCurrentFrame - 1.0f);
                                }
                                long time = System.currentTimeMillis();
                                do {
                                    try {
                                        Thread.sleep(1L);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                    if (System.currentTimeMillis() - time <= 1000L) continue;
                                    frameIsComplete = true;
                                } while (!frameIsComplete);
                            }
                            i = 0;
                        }
                    });
                    t.start();
                }
            }
        });
        btnNext = new JButton(">");
        btnNext.setFont(new Font(Shutter.montserratFont, 0, 12));
        btnNext.setBounds(VideoPlayer.player.getLocation().x + VideoPlayer.player.getSize().width / 2 + 4, VideoPlayer.btnPrevious.getLocation().y, 22, 21);
        frame.getContentPane().add(btnNext);
        btnNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (sliderSpeed.getValue() != 2) {
                    sliderSpeed.setValue(2);
                    lblSpeed.setText(String.valueOf(Shutter.language.getProperty("conformBySpeed")) + " x1");
                    lblSpeed.setBounds(sliderSpeed.getX() - VideoPlayer.lblSpeed.getPreferredSize().width - 2, sliderSpeed.getY() + 2, VideoPlayer.lblSpeed.getPreferredSize().width, 16);
                    VideoPlayer.playerSetTime(playerCurrentFrame + 1.0f);
                }
                if (preview.exists() || caseAddSubtitles.isSelected()) {
                    preview.delete();
                    VideoPlayer.playerSetTime(playerCurrentFrame + 1.0f);
                }
                frameControl = true;
                if (playerVideo != null) {
                    if (playerLoop) {
                        btnPlay.setText(Shutter.language.getProperty("btnPlay"));
                        playerLoop = false;
                    }
                    if (seekOnKeyFrames && !FFPROBE.isRunning) {
                        FFPROBE.Keyframes(videoPath, playerCurrentFrame * inputFramerateMS, true);
                        do {
                            try {
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        } while (FFPROBE.isRunning);
                        if (FFPROBE.keyFrame > 0.0f) {
                            VideoPlayer.playerSetTime(FFPROBE.keyFrame);
                        }
                    } else {
                        playerLoop = true;
                    }
                }
            }
        });
        btnPlay = new JButton(Shutter.language.getProperty("btnPlay"));
        btnPlay.setFont(new Font(Shutter.montserratFont, 0, 12));
        btnPlay.setMargin(new Insets(0, 0, 0, 0));
        btnPlay.setBounds(VideoPlayer.btnPrevious.getLocation().x - 80 - 4, VideoPlayer.btnPrevious.getLocation().y, 80, 21);
        frame.getContentPane().add(btnPlay);
        btnPlay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                long time = System.currentTimeMillis();
                if (!VideoPlayer.playerIsPlaying()) {
                    do {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } while (System.currentTimeMillis() - time <= 1000L && playerLoop);
                }
                if (btnPlay.getText().equals(Shutter.language.getProperty("btnPause"))) {
                    btnPlay.setText(Shutter.language.getProperty("btnPlay"));
                    playerLoop = false;
                    showFPS.setVisible(false);
                    if (sliderSpeed.getValue() != 2) {
                        VideoPlayer.playerSetTime(slider.getValue());
                    }
                } else if (btnPlay.getText().equals(Shutter.language.getProperty("btnPlay"))) {
                    if (preview.exists() || caseAddSubtitles.isSelected()) {
                        preview.delete();
                        VideoPlayer.playerSetTime(playerCurrentFrame);
                    }
                    frameControl = false;
                    btnPlay.setText(Shutter.language.getProperty("btnPause"));
                    playerLoop = true;
                    fpsTime = System.nanoTime();
                    displayCurrentFPS = 0;
                }
            }
        });
        btnStop = new JButton(Shutter.language.getProperty("btnStop"));
        btnStop.setFont(new Font(Shutter.montserratFont, 0, 12));
        btnStop.setMargin(new Insets(0, 0, 0, 0));
        btnStop.setBounds(VideoPlayer.btnNext.getLocation().x + VideoPlayer.btnNext.getSize().width + 4, VideoPlayer.btnNext.getLocation().y, 80, 21);
        frame.getContentPane().add(btnStop);
        btnStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (playerVideo != null) {
                    playerCurrentFrame = 0.0f;
                    if (playerVideo != null) {
                        VideoPlayer.playerStop();
                        do {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        } while (playerVideo.isAlive());
                        slider.setValue(0);
                    }
                    VideoPlayer.this.resizeAll();
                    btnPlay.setText(Shutter.language.getProperty("btnPlay"));
                    playerLoop = false;
                    if (Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles"))) {
                        SubtitlesTimeline.actualSubOut = 0L;
                    }
                    playerCurrentFrame = 0.0f;
                } else if (FFPROBE.totalLength <= 40 || Shutter.caseEnableSequence.isSelected()) {
                    VideoPlayer.this.resizeAll();
                }
            }
        });
        btnPreviousFile = new JButton(Shutter.language.getProperty("btnPrevious"));
        btnPreviousFile.setFont(new Font(Shutter.montserratFont, 0, 12));
        btnPreviousFile.setMargin(new Insets(0, 0, 0, 0));
        btnPreviousFile.setBounds(player.getX(), btnCapture.getY(), 84, 21);
        frame.getContentPane().add(btnPreviousFile);
        btnPreviousFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Shutter.fileList.getSelectedIndex() > 0) {
                    Shutter.fileList.setSelectedIndex(Shutter.fileList.getSelectedIndex() - 1);
                    VideoPlayer.setMedia();
                }
            }
        });
        btnNextFile = new JButton(Shutter.language.getProperty("btnNext"));
        btnNextFile.setFont(new Font(Shutter.montserratFont, 0, 12));
        btnNextFile.setMargin(new Insets(0, 0, 0, 0));
        btnNextFile.setBounds(player.getX() + player.getWidth() - 84, btnPreviousFile.getY(), btnPreviousFile.getWidth(), 21);
        frame.getContentPane().add(btnNextFile);
        btnNextFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Shutter.fileList.getSelectedIndex() < Shutter.liste.getSize()) {
                    Shutter.fileList.setSelectedIndex(Shutter.fileList.getSelectedIndex() + 1);
                    if (playerLoop) {
                        btnPlay.setText(Shutter.language.getProperty("btnPlay"));
                        playerLoop = false;
                    }
                    VideoPlayer.setMedia();
                }
            }
        });
        btnMarkIn = new JButton("\u2b25");
        btnMarkIn.setFont(new Font("", 0, 12));
        btnMarkIn.setBounds(VideoPlayer.btnPlay.getLocation().x - 22 - 4, VideoPlayer.btnPlay.getLocation().y, 22, 21);
        frame.getContentPane().add(btnMarkIn);
        btnMarkIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                playerInMark = cursorWaveform.getX();
                waveformContainer.repaint();
                VideoPlayer.updateGrpIn(playerCurrentFrame);
                timecode.repaint();
            }
        });
        btnGoToIn = new JButton("\u2b25<");
        btnGoToIn.setMargin(new Insets(0, 0, 0, 0));
        btnGoToIn.setFont(new Font("", 0, 12));
        btnGoToIn.setBounds(VideoPlayer.btnMarkIn.getLocation().x - 40 - 4, VideoPlayer.btnMarkIn.getLocation().y, 40, 21);
        frame.getContentPane().add(btnGoToIn);
        btnGoToIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                playTransition = true;
                playerCurrentFrame = (float)(Integer.parseInt(caseInH.getText()) * 3600 + Integer.parseInt(caseInM.getText()) * 60 + Integer.parseInt(caseInS.getText())) * FFPROBE.currentFPS + (float)Integer.parseInt(caseInF.getText());
                playerCurrentFrame = Timecode.getNonDropFrameTC(playerCurrentFrame);
                VideoPlayer.playerSetTime(playerCurrentFrame);
            }
        });
        btnMarkOut = new JButton("\u2b25");
        btnMarkOut.setFont(new Font("", 0, 12));
        btnMarkOut.setBounds(VideoPlayer.btnStop.getLocation().x + VideoPlayer.btnStop.getSize().width + 4, VideoPlayer.btnStop.getLocation().y, 22, 21);
        frame.getContentPane().add(btnMarkOut);
        btnMarkOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                playerOutMark = cursorWaveform.getX();
                waveformContainer.repaint();
                VideoPlayer.updateGrpOut(playerCurrentFrame + 1.0f);
            }
        });
        btnGoToOut = new JButton(">\u2b25");
        btnGoToOut.setMargin(new Insets(0, 0, 0, 0));
        btnGoToOut.setFont(new Font("", 0, 12));
        btnGoToOut.setBounds(VideoPlayer.btnMarkOut.getLocation().x + VideoPlayer.btnMarkOut.getSize().width + 4, VideoPlayer.btnMarkOut.getLocation().y, 40, 21);
        frame.getContentPane().add(btnGoToOut);
        btnGoToOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                playerCurrentFrame = (float)(Integer.parseInt(caseOutH.getText()) * 3600 + Integer.parseInt(caseOutM.getText()) * 60 + Integer.parseInt(caseOutS.getText())) * FFPROBE.currentFPS + (float)Integer.parseInt(caseOutF.getText());
                playerCurrentFrame = Timecode.getNonDropFrameTC(playerCurrentFrame);
                VideoPlayer.playerSetTime(playerCurrentFrame - 1.0f);
            }
        });
        showFPS = new JLabel("25 fps");
        showFPS.setVisible(false);
        showFPS.setFont(new Font(Shutter.freeSansFont, 1, 12));
        showFPS.setHorizontalAlignment(4);
        showFPS.setBounds(player.getX() + player.getWidth() / 2, player.getY() - 18, player.getWidth() / 2, VideoPlayer.showFPS.getPreferredSize().height);
        frame.getContentPane().add(showFPS);
        showScale = new JLabel("1920x1080");
        showScale.setVisible(false);
        showScale.setEnabled(false);
        showScale.setFont(new Font(Shutter.freeSansFont, 1, 12));
        showScale.setHorizontalAlignment(2);
        showScale.setBounds(player.getX(), showFPS.getY(), player.getWidth() / 2, VideoPlayer.showScale.getPreferredSize().height);
        frame.getContentPane().add(showScale);
    }

    private void player() {
        player = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g2.setColor(Color.BLACK);
                if (Shutter.liste.getSize() == 0) {
                    g2.fillRect(0, 0, player.getWidth(), player.getHeight());
                } else {
                    g2.drawImage(frameVideo, 0, 0, player.getWidth(), player.getHeight(), this);
                }
                if (!FFPROBE.audioOnly && FFPROBE.totalLength > 40) {
                    if (System.nanoTime() - fpsTime >= 1000000000L) {
                        displayCurrentFPS = fps;
                        fpsTime = System.nanoTime();
                        fps = 0;
                    }
                    if (displayCurrentFPS > 0 && playerLoop && sliderSpeed.getValue() == 2) {
                        showFPS.setVisible(true);
                        if ((float)displayCurrentFPS >= FFPROBE.currentFPS) {
                            showFPS.setForeground(Color.GREEN);
                            String[] fps = String.valueOf(FFPROBE.currentFPS).split("\\.");
                            if (fps[1].equals("0")) {
                                showFPS.setText(String.valueOf(String.valueOf(FFPROBE.currentFPS).replace(".0", "")) + " " + Shutter.language.getProperty("fps"));
                            } else {
                                showFPS.setText(String.valueOf(String.valueOf(FFPROBE.currentFPS)) + " " + Shutter.language.getProperty("fps"));
                            }
                        } else {
                            showFPS.setForeground(Color.RED);
                            showFPS.setText(String.valueOf(String.valueOf(displayCurrentFPS)) + " " + Shutter.language.getProperty("fps"));
                        }
                    } else {
                        showFPS.setVisible(false);
                    }
                }
                if (stabilisation != "") {
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                    g2.setColor(Color.WHITE);
                    g2.setFont(new Font("SansSerif", 2, (int)Math.floor(player.getHeight() / 16)));
                    FontMetrics metrics = g.getFontMetrics(g2.getFont());
                    int x = (player.getWidth() - metrics.stringWidth(Shutter.language.getProperty("preview"))) / 2;
                    int y = player.getHeight() - player.getHeight() / 24;
                    g2.drawString(Shutter.language.getProperty("preview"), x, y);
                }
                if (Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles"))) {
                    SubtitlesTimeline.refreshData();
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                    String[] text = SubtitlesTimeline.txtSubtitles.getText().split("\\r?\\n");
                    if (text[0].contains("i>") && text[0].contains("b>")) {
                        g2.setFont(new Font("SansSerif", 3, (int)Math.floor(player.getHeight() / 16)));
                    } else if (text[0].contains("i>")) {
                        g2.setFont(new Font("SansSerif", 2, (int)Math.floor(player.getHeight() / 16)));
                    } else if (text[0].contains("b>")) {
                        g2.setFont(new Font("SansSerif", 1, (int)Math.floor(player.getHeight() / 16)));
                    } else {
                        g2.setFont(new Font("SansSerif", 0, (int)Math.floor(player.getHeight() / 16)));
                    }
                    String firstLine = text[0].replace("<i>", "").replace("</i>", "").replace("<b>", "").replace("</b>", "");
                    FontMetrics metrics = g.getFontMetrics(g2.getFont());
                    int x = (player.getWidth() - metrics.stringWidth(firstLine)) / 2;
                    int y = player.getHeight() - player.getHeight() / 24;
                    if (text.length > 1 && text[1].length() > 0) {
                        y = player.getHeight() - (int)((double)player.getHeight() / 9.5);
                        g2.setColor(Color.BLACK);
                        g2.drawString(firstLine, this.ShiftWest(x, 1), this.ShiftNorth(y, 1));
                        g2.drawString(firstLine, this.ShiftWest(x, 1), this.ShiftSouth(y, 1));
                        g2.drawString(firstLine, this.ShiftEast(x, 1), this.ShiftNorth(y, 1));
                        g2.drawString(firstLine, this.ShiftEast(x, 1), this.ShiftSouth(y, 1));
                        g2.setColor(Color.WHITE);
                        g2.drawString(firstLine, x, y);
                        if (text[1].contains("i>") && text[1].contains("b>")) {
                            g2.setFont(new Font("SansSerif", 3, (int)Math.floor(player.getHeight() / 16)));
                        } else if (text[1].contains("i>")) {
                            g2.setFont(new Font("SansSerif", 2, (int)Math.floor(player.getHeight() / 16)));
                        } else if (text[1].contains("b>")) {
                            g2.setFont(new Font("SansSerif", 1, (int)Math.floor(player.getHeight() / 16)));
                        } else {
                            g2.setFont(new Font("SansSerif", 0, (int)Math.floor(player.getHeight() / 16)));
                        }
                        String secondLine = text[1].replace("<i>", "").replace("</i>", "").replace("<b>", "").replace("</b>", "");
                        x = (player.getWidth() - metrics.stringWidth(secondLine)) / 2;
                        y = player.getHeight() - player.getHeight() / 24;
                        g2.setColor(Color.BLACK);
                        g2.drawString(secondLine, this.ShiftWest(x, 1), this.ShiftNorth(y, 1));
                        g2.drawString(secondLine, this.ShiftWest(x, 1), this.ShiftSouth(y, 1));
                        g2.drawString(secondLine, this.ShiftEast(x, 1), this.ShiftNorth(y, 1));
                        g2.drawString(secondLine, this.ShiftEast(x, 1), this.ShiftSouth(y, 1));
                        g2.setColor(Color.WHITE);
                        g2.drawString(secondLine, x, y);
                    } else if (firstLine.length() > 0) {
                        g2.setColor(Color.BLACK);
                        g2.drawString(firstLine, this.ShiftWest(x, 1), this.ShiftNorth(y, 1));
                        g2.drawString(firstLine, this.ShiftWest(x, 1), this.ShiftSouth(y, 1));
                        g2.drawString(firstLine, this.ShiftEast(x, 1), this.ShiftNorth(y, 1));
                        g2.drawString(firstLine, this.ShiftEast(x, 1), this.ShiftSouth(y, 1));
                        g2.setColor(Color.WHITE);
                        g2.drawString(firstLine, x, y);
                    }
                }
            }

            int ShiftNorth(int p, int distance) {
                return p - distance;
            }

            int ShiftSouth(int p, int distance) {
                return p + distance;
            }

            int ShiftEast(int p, int distance) {
                return p + distance;
            }

            int ShiftWest(int p, int distance) {
                return p - distance;
            }
        };
        player.setTransferHandler(new ListeFileTransferHandler());
        player.setLayout(null);
        player.setBackground(Color.BLACK);
        frame.getContentPane().add(player);
    }

    private void sliders() {
        slider = new JSlider();
        slider.setPaintLabels(true);
        slider.setValue(0);
        slider.setVisible(false);
        slider.setBounds(VideoPlayer.grpIn.getLocation().x + VideoPlayer.grpIn.getSize().width + 6, VideoPlayer.grpIn.getLocation().y, VideoPlayer.frame.getSize().width - (VideoPlayer.grpIn.getLocation().x + VideoPlayer.grpIn.getSize().width + 6) * 2 - 6, 60);
        frame.getContentPane().add(slider);
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (playerVideo != null && sliderChange) {
                    if (preview.exists()) {
                        preview.delete();
                    }
                    if (slider.getValue() > 0) {
                        VideoPlayer.playerSetTime(slider.getValue());
                    } else {
                        VideoPlayer.playerSetTime(0.0f);
                    }
                }
            }
        });
        waveformContainer = new JLabel(){

            @Override
            protected void paintComponent(Graphics g) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setColor(new Color(65, 65, 65));
                g2.drawRoundRect(0, 0, this.getWidth() - 1, this.getHeight() - 1, 5, 5);
                if (Shutter.liste.getSize() > 0 && !Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles"))) {
                    g2.setColor(Utils.themeColor);
                    if (playerOutMark > waveformContainer.getWidth() - 2) {
                        playerOutMark = waveformContainer.getWidth() - 2;
                    }
                    if (playerInMark < 0) {
                        playerInMark = 0;
                    }
                    g2.drawRoundRect(playerInMark + 1, 0, playerOutMark - playerInMark, this.getHeight() - 1, 5, 5);
                    if (comboMode.isVisible() && comboMode.getSelectedItem().equals(Shutter.language.getProperty("splitMode"))) {
                        g2.setColor(Utils.themeColor);
                        int alpha = 255;
                        int splitTime = playerInMark + Math.round((float)(VideoPlayer.waveformContainer.getSize().width * Integer.parseInt(splitValue.getText())) * FFPROBE.currentFPS / totalFrames);
                        do {
                            g2.fillRect(splitTime + 1, 0, 1, this.getHeight() - 1);
                            g2.setColor(new Color(Utils.themeColor.getRed(), Utils.themeColor.getGreen(), Utils.themeColor.getBlue(), alpha));
                        } while ((alpha -= 10) >= 0 && (splitTime += Math.round((float)(VideoPlayer.waveformContainer.getSize().width * Integer.parseInt(splitValue.getText())) * FFPROBE.currentFPS / totalFrames)) < playerOutMark);
                    }
                    g2.setColor(new Color(45, 45, 45, 120));
                    if (comboMode.getSelectedItem().equals(Shutter.language.getProperty("removeMode"))) {
                        g2.fillRoundRect(playerInMark + 2, 1, playerOutMark - playerInMark - 1, this.getHeight() - 2, 5, 5);
                    } else {
                        g2.fillRoundRect(0, 0, playerInMark + 1, this.getHeight() - 1, 5, 5);
                        g2.fillRoundRect(playerOutMark + 2, 0, this.getWidth() - playerOutMark - 2, this.getHeight() - 1, 5, 5);
                    }
                    VideoPlayer.totalDuration();
                }
            }
        };
        waveformContainer.setBounds(slider.getX(), slider.getY() + 7, slider.getWidth(), grpIn.getHeight() - 9);
        frame.getContentPane().add(waveformContainer);
        waveformIcon = new JLabel();
        waveformIcon.setOpaque(false);
        waveformIcon.setBounds(waveformContainer.getBounds());
        frame.getContentPane().add(waveformIcon);
        playerOutMark = waveformContainer.getWidth() - 2;
        waveformContainer.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                mouseIsPressed = true;
                if (Shutter.liste.getSize() > 0) {
                    waveformContainer.requestFocus();
                    sliderChange = true;
                    if (VideoPlayer.playerIsPlaying()) {
                        btnPlay.setText(Shutter.language.getProperty("btnPause"));
                    }
                    if (e.getX() >= 0 && e.getX() <= waveformContainer.getWidth() - 2) {
                        cursorWaveform.setLocation(e.getX(), VideoPlayer.cursorWaveform.getLocation().y);
                        slider.setValue((int)((long)slider.getMaximum() * (long)VideoPlayer.cursorWaveform.getLocation().x / (long)VideoPlayer.waveformContainer.getSize().width));
                    } else if (e.getX() < 0) {
                        cursorWaveform.setLocation(0, VideoPlayer.cursorWaveform.getLocation().y);
                        slider.setValue((int)((long)slider.getMaximum() * (long)VideoPlayer.cursorWaveform.getLocation().x / (long)VideoPlayer.waveformContainer.getSize().width));
                    } else if (e.getX() > waveformContainer.getWidth() - 2) {
                        cursorWaveform.setLocation(waveformContainer.getWidth() - 2, VideoPlayer.cursorWaveform.getLocation().y);
                        slider.setValue((int)((long)slider.getMaximum() * (long)VideoPlayer.cursorWaveform.getLocation().x / (long)VideoPlayer.waveformContainer.getSize().width));
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                mouseIsPressed = false;
                if (Shutter.liste.getSize() > 0) {
                    long time = System.currentTimeMillis();
                    if (!VideoPlayer.playerIsPlaying()) {
                        do {
                            try {
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        } while (System.currentTimeMillis() - time <= 1000L && playerLoop);
                    }
                    float timeIn = (float)(Integer.parseInt(caseInH.getText()) * 3600 + Integer.parseInt(caseInM.getText()) * 60 + Integer.parseInt(caseInS.getText())) * FFPROBE.currentFPS + (float)Integer.parseInt(caseInF.getText());
                    float timeOut = (float)(Integer.parseInt(caseOutH.getText()) * 3600 + Integer.parseInt(caseOutM.getText()) * 60 + Integer.parseInt(caseOutS.getText())) * FFPROBE.currentFPS + (float)Integer.parseInt(caseOutF.getText());
                    playerInMark = Math.round((float)VideoPlayer.waveformContainer.getSize().width * timeIn / totalFrames);
                    playerOutMark = (float)((int)Math.ceil(timeOut)) < totalFrames ? Math.round(((float)VideoPlayer.waveformContainer.getSize().width * timeOut - 1.0f) / totalFrames) : waveformContainer.getWidth();
                    if (waveformContainer.getCursor().equals(Cursor.getPredefinedCursor(10)) && cursorWaveform.getX() < playerOutMark && mouseIsPressed) {
                        cursorWaveform.setLocation(playerInMark, 0);
                        VideoPlayer.updateGrpIn(playerCurrentFrame);
                    } else if (waveformContainer.getCursor().equals(Cursor.getPredefinedCursor(11)) && cursorWaveform.getX() > playerInMark && mouseIsPressed) {
                        cursorWaveform.setLocation(playerOutMark, 0);
                        VideoPlayer.updateGrpOut(playerCurrentFrame + 1.0f);
                    }
                    sliderChange = false;
                    if (waveformContainer.getCursor().equals(Cursor.getPredefinedCursor(10)) && mouseIsPressed) {
                        playerCurrentFrame = (float)(Integer.parseInt(caseInH.getText()) * 3600 + Integer.parseInt(caseInM.getText()) * 60 + Integer.parseInt(caseInS.getText())) * FFPROBE.currentFPS + (float)Integer.parseInt(caseInF.getText());
                        playerCurrentFrame = Timecode.getNonDropFrameTC(playerCurrentFrame);
                        VideoPlayer.playerSetTime(playerCurrentFrame);
                    } else if (waveformContainer.getCursor().equals(Cursor.getPredefinedCursor(11)) && mouseIsPressed) {
                        playerCurrentFrame = (float)(Integer.parseInt(caseOutH.getText()) * 3600 + Integer.parseInt(caseOutM.getText()) * 60 + Integer.parseInt(caseOutS.getText())) * FFPROBE.currentFPS + (float)Integer.parseInt(caseOutF.getText()) - 1.0f;
                        playerCurrentFrame = Timecode.getNonDropFrameTC(playerCurrentFrame);
                        VideoPlayer.playerSetTime(playerCurrentFrame);
                    } else {
                        do {
                            try {
                                Thread.sleep(1L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        } while (setTime.isAlive());
                        playerCurrentFrame = Timecode.getNonDropFrameTC(playerCurrentFrame);
                        VideoPlayer.playerSetTime(playerCurrentFrame);
                    }
                    waveformContainer.repaint();
                    waveformContainer.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        waveformContainer.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (Shutter.liste.getSize() > 0) {
                    if (e.getX() > 0 && e.getX() <= waveformContainer.getWidth() - 2) {
                        int value = (int)((long)slider.getMaximum() * (long)VideoPlayer.cursorWaveform.getLocation().x / (long)VideoPlayer.waveformContainer.getSize().width);
                        sliderChange = true;
                        cursorWaveform.setLocation(e.getX(), VideoPlayer.cursorWaveform.getLocation().y);
                        if ((float)value < totalFrames) {
                            slider.setValue(value);
                        }
                    } else if (e.getX() <= 0) {
                        sliderChange = true;
                        cursorWaveform.setLocation(0, VideoPlayer.cursorWaveform.getLocation().y);
                        slider.setValue(0);
                        VideoPlayer.playerSetTime(0.0f);
                    } else if (e.getX() > waveformContainer.getWidth() - 2) {
                        sliderChange = true;
                        cursorWaveform.setLocation(waveformContainer.getWidth() - 2, VideoPlayer.cursorWaveform.getLocation().y);
                        slider.setValue((int)(totalFrames - 2.0f));
                        VideoPlayer.playerSetTime(totalFrames - 2.0f);
                    }
                    if (waveformContainer.getCursor().equals(Cursor.getPredefinedCursor(10)) && cursorWaveform.getX() < playerOutMark && mouseIsPressed) {
                        playerInMark = cursorWaveform.getX();
                        waveformContainer.repaint();
                    } else if (waveformContainer.getCursor().equals(Cursor.getPredefinedCursor(11)) && cursorWaveform.getX() > playerInMark && mouseIsPressed) {
                        playerOutMark = cursorWaveform.getX();
                        waveformContainer.repaint();
                    }
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (e.getX() >= playerInMark - 5 && e.getX() <= playerInMark + 5) {
                    waveformContainer.setCursor(Cursor.getPredefinedCursor(10));
                } else if (e.getX() >= playerOutMark - 5 && e.getX() <= playerOutMark + 5) {
                    waveformContainer.setCursor(Cursor.getPredefinedCursor(11));
                } else {
                    waveformContainer.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        cursorWaveform = new JPanel();
        cursorWaveform.setBackground(Color.RED);
        cursorWaveform.setBounds(0, 0, 2, VideoPlayer.waveformContainer.getSize().height);
        waveformContainer.add(cursorWaveform);
        sliderVolume = new JSlider();
        sliderVolume.setName("sliderVolume");
        sliderVolume.setValue(Settings.videoPlayerVolume);
        frame.getContentPane().add(sliderVolume);
        sliderVolume.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                Settings.videoPlayerVolume = sliderVolume.getValue();
            }
        });
        lblVolume = new JLabel(String.valueOf(Shutter.language.getProperty("volume")) + " ");
        lblVolume.setFont(new Font(Shutter.freeSansFont, 0, 13));
        lblVolume.setSize(VideoPlayer.lblVolume.getPreferredSize().width + 3, 16);
        lblVolume.setLocation(btnGoToOut.getX() + btnGoToOut.getWidth() + 7, lblSpeed.getY());
        frame.getContentPane().add(lblVolume);
        VideoPlayer.addWaveform(true);
    }

    private void topPanel() {
        this.topPanel = new JPanel();
        this.topPanel.setLayout(null);
        this.topPanel.setBounds(0, 0, VideoPlayer.frame.getSize().width, 28);
        this.quit = new JLabel(new FlatSVGIcon("contents/quit.svg", 15, 15));
        this.quit.setHorizontalAlignment(0);
        this.quit.setBounds(VideoPlayer.frame.getSize().width - 20, 4, 15, 15);
        this.quit.addMouseListener(new MouseListener(){
            private boolean accept = false;

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                VideoPlayer.this.quit.setIcon(new FlatSVGIcon("contents/quit_pressed.svg", 15, 15));
                this.accept = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                block34: {
                    File concat;
                    if (!this.accept) break block34;
                    if (preview.exists()) {
                        preview.delete();
                    }
                    if (waveform.exists()) {
                        waveform.delete();
                    }
                    if ((concat = new File(String.valueOf(Shutter.dirTemp) + "concat.txt")).exists()) {
                        concat.delete();
                    }
                    if (FFMPEG.isRunning) {
                        FFMPEG.process.destroy();
                    }
                    Shutter.caseInAndOut.setSelected(false);
                    btnStop.doClick();
                    videoPath = null;
                    lblVideo.setVisible(false);
                    VideoPlayer.playerStop();
                    slider.setValue(0);
                    btnPlay.setText(Shutter.language.getProperty("btnPlay"));
                    btnPlay.setEnabled(false);
                    btnPrevious.setEnabled(false);
                    btnNext.setEnabled(false);
                    btnStop.setEnabled(false);
                    caseInternalTc.setEnabled(false);
                    caseInternalTc.setSelected(false);
                    Utils.changeFrameVisibility(frame, true);
                    switch (Shutter.comboFonctions.getSelectedItem().toString()) {
                        case "MPEG-1": 
                        case "MPEG-2": 
                        case "AV1": 
                        case "OGV": 
                        case "VP8": 
                        case "VP9": 
                        case "WMV": 
                        case "Xvid": 
                        case "H.264": 
                        case "H.265": 
                        case "MJPEG": 
                        case "Blu-ray": {
                            FFPROBE.setLength();
                        }
                    }
                    if (Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles"))) {
                        Shutter.caseInAndOut.setSelected(false);
                        SubtitlesTimeline.frame.dispose();
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                VideoPlayer.this.quit.setIcon(new FlatSVGIcon("contents/quit_hover.svg", 15, 15));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                VideoPlayer.this.quit.setIcon(new FlatSVGIcon("contents/quit.svg", 15, 15));
                this.accept = false;
            }
        });
        this.fullscreen = new JLabel(new FlatSVGIcon("contents/max.svg", 15, 15));
        this.fullscreen.setHorizontalAlignment(0);
        this.fullscreen.setBounds(this.quit.getLocation().x - 20, 4, 15, 15);
        this.fullscreen.addMouseListener(new MouseListener(){
            private boolean accept = false;

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                VideoPlayer.this.fullscreen.setIcon(new FlatSVGIcon("contents/max_pressed.svg", 15, 15));
                this.accept = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                GraphicsConfiguration config = frame.getGraphicsConfiguration();
                GraphicsDevice myScreen = config.getDevice();
                GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
                GraphicsDevice[] allScreens = env.getScreenDevices();
                int screenIndex = -1;
                int i = 0;
                while (i < allScreens.length) {
                    if (allScreens[i].equals(myScreen)) {
                        screenIndex = i;
                        break;
                    }
                    ++i;
                }
                DisplayMode dm = allScreens[screenIndex].getDisplayMode();
                int refreshRate = dm.getRefreshRate();
                screenRefreshRate = refreshRate == 0 ? 16.666666 : 1000.0 / (double)refreshRate;
                int screenHeight = allScreens[screenIndex].getDisplayMode().getHeight();
                int screenWidth = allScreens[screenIndex].getDisplayMode().getWidth();
                if (this.accept && frame.getHeight() < screenHeight - taskBarHeight) {
                    if (player.getHeight() > player.getWidth()) {
                        frame.setBounds(0, 0, screenWidth, screenHeight - taskBarHeight);
                    } else {
                        int setWidth = (int)((float)(screenHeight - VideoPlayer.this.topPanel.getHeight() - taskBarHeight - btnCapture.getHeight() - btnPlay.getHeight() - slider.getHeight() * 2 - lblDuration.getHeight() - 40) * ((float)(player.getWidth() * 2) / (float)player.getHeight()));
                        if (setWidth <= screenWidth) {
                            frame.setSize(setWidth, screenHeight - taskBarHeight);
                        } else {
                            frame.setSize(screenWidth, screenHeight - taskBarHeight);
                        }
                        if (System.getProperty("os.name").contains("Windows")) {
                            frame.setLocation(allScreens[screenIndex].getDefaultConfiguration().getBounds().x + allScreens[screenIndex].getDefaultConfiguration().getBounds().width - VideoPlayer.frame.getSize().width, allScreens[screenIndex].getDefaultConfiguration().getBounds().y);
                        } else {
                            frame.setLocation(allScreens[screenIndex].getDefaultConfiguration().getBounds().x + allScreens[screenIndex].getDisplayMode().getWidth() - VideoPlayer.frame.getSize().width, allScreens[screenIndex].getDefaultConfiguration().getBounds().y);
                        }
                    }
                } else if (this.accept) {
                    frame.setSize(1300, 624);
                    Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
                    frame.setLocation(dim.width / 2 - VideoPlayer.frame.getSize().width / 2, dim.height / 2 - VideoPlayer.frame.getSize().height / 2);
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                VideoPlayer.this.resizeAll();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                VideoPlayer.this.fullscreen.setIcon(new FlatSVGIcon("contents/max_hover.svg", 15, 15));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                VideoPlayer.this.fullscreen.setIcon(new FlatSVGIcon("contents/max.svg", 15, 15));
                this.accept = false;
            }
        });
        this.reduce = new JLabel(new FlatSVGIcon("contents/reduce.svg", 15, 15));
        this.reduce.setHorizontalAlignment(0);
        this.reduce.setBounds(this.fullscreen.getLocation().x - 20, 4, 15, 15);
        this.reduce.addMouseListener(new MouseListener(){
            private boolean accept = false;

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                VideoPlayer.this.reduce.setIcon(new FlatSVGIcon("contents/reduce_pressed.svg", 15, 15));
                this.accept = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this.accept) {
                    frame.setState(1);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                VideoPlayer.this.reduce.setIcon(new FlatSVGIcon("contents/reduce_hover.svg", 15, 15));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                VideoPlayer.this.reduce.setIcon(new FlatSVGIcon("contents/reduce.svg", 15, 15));
                this.accept = false;
            }
        });
        this.bottomImage = new JLabel();
        ImageIcon imageIcon = new ImageIcon(this.header.getImage().getScaledInstance(this.topPanel.getSize().width, this.topPanel.getSize().height, 16));
        this.bottomImage.setIcon(imageIcon);
        this.bottomImage.setBounds(0, 0, VideoPlayer.frame.getSize().width, 28);
        this.bottomImage.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent down) {
                if (down.getClickCount() == 2) {
                    GraphicsConfiguration config = frame.getGraphicsConfiguration();
                    GraphicsDevice myScreen = config.getDevice();
                    GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
                    GraphicsDevice[] allScreens = env.getScreenDevices();
                    int screenIndex = -1;
                    int i = 0;
                    while (i < allScreens.length) {
                        if (allScreens[i].equals(myScreen)) {
                            screenIndex = i;
                            break;
                        }
                        ++i;
                    }
                    DisplayMode dm = allScreens[screenIndex].getDisplayMode();
                    int refreshRate = dm.getRefreshRate();
                    screenRefreshRate = refreshRate == 0 ? 16.666666 : 1000.0 / (double)refreshRate;
                    int screenHeight = allScreens[screenIndex].getDisplayMode().getHeight();
                    int screenWidth = allScreens[screenIndex].getDisplayMode().getWidth();
                    if (frame.getHeight() < screenHeight - taskBarHeight) {
                        if (player.getHeight() > player.getWidth()) {
                            frame.setBounds(0, 0, screenWidth, screenHeight - taskBarHeight);
                        } else {
                            int setWidth = (int)((float)(screenHeight - VideoPlayer.this.topPanel.getHeight() - taskBarHeight - btnCapture.getHeight() - btnPlay.getHeight() - slider.getHeight() * 2 - lblDuration.getHeight() - 40) * ((float)(player.getWidth() * 2) / (float)player.getHeight()));
                            if (setWidth <= screenWidth) {
                                frame.setSize(setWidth, screenHeight - taskBarHeight);
                            } else {
                                frame.setSize(screenWidth, screenHeight - taskBarHeight);
                            }
                            if (System.getProperty("os.name").contains("Windows")) {
                                frame.setLocation(allScreens[screenIndex].getDefaultConfiguration().getBounds().x + allScreens[screenIndex].getDefaultConfiguration().getBounds().width - VideoPlayer.frame.getSize().width, allScreens[screenIndex].getDefaultConfiguration().getBounds().y);
                            } else {
                                frame.setLocation(allScreens[screenIndex].getDefaultConfiguration().getBounds().x + allScreens[screenIndex].getDisplayMode().getWidth() - VideoPlayer.frame.getSize().width, allScreens[screenIndex].getDefaultConfiguration().getBounds().y);
                            }
                        }
                    } else {
                        frame.setSize(1300, 624);
                        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
                        frame.setLocation(dim.width / 2 - VideoPlayer.frame.getSize().width / 2, dim.height / 2 - VideoPlayer.frame.getSize().height / 2);
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    VideoPlayer.this.resizeAll();
                }
            }

            @Override
            public void mousePressed(MouseEvent down) {
                MousePositionX = down.getPoint().x;
                MousePositionY = down.getPoint().y;
                frame.toFront();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (Shutter.liste.getSize() > 0 && !Shutter.fileList.getSelectedValue().equals(videoPath)) {
                    VideoPlayer.setMedia();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.bottomImage.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                frame.setLocation(MouseInfo.getPointerInfo().getLocation().x - MousePositionX, MouseInfo.getPointerInfo().getLocation().y - MousePositionY);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        this.title.setHorizontalAlignment(0);
        this.title.setBounds(0, 0, frame.getWidth(), 28);
        this.title.setFont(new Font(Shutter.magnetoFont, 0, 17));
        this.topPanel.add(this.title);
        this.topImage = new JLabel();
        this.topImage.setIcon(imageIcon);
        this.topImage.setBounds(this.title.getBounds());
        this.topPanel.add(this.reduce);
        this.topPanel.add(this.fullscreen);
        this.topPanel.add(this.quit);
        this.topPanel.add(this.topImage);
        this.topPanel.add(this.bottomImage);
        frame.getContentPane().add(this.topPanel);
    }

    private void grpIn() {
        grpIn = new JPanel();
        grpIn.setLayout(null);
        grpIn.setBorder(BorderFactory.createTitledBorder(new RoundedLineBorder(new Color(65, 65, 65), 1, 5, true), String.valueOf(Shutter.language.getProperty("grpIn")) + " ", 0, 0, new Font(Shutter.montserratFont, 0, 12), Color.WHITE));
        grpIn.setBackground(new Color(45, 45, 45));
        grpIn.setBounds(6, VideoPlayer.frame.getSize().height - 84, 156, 52);
        frame.getContentPane().add(grpIn);
        caseInH = new JTextField();
        caseInH.setName("caseInH");
        caseInH.setText("00");
        caseInH.setHorizontalAlignment(0);
        caseInH.setFont(new Font(Shutter.freeSansFont, 0, 14));
        caseInH.setColumns(10);
        caseInH.setBounds(6, 17, 36, 26);
        grpIn.add(caseInH);
        caseInM = new JTextField();
        caseInM.setName("caseInM");
        caseInM.setText("00");
        caseInM.setHorizontalAlignment(0);
        caseInM.setFont(new Font(Shutter.freeSansFont, 0, 14));
        caseInM.setColumns(10);
        caseInM.setBounds(42, 17, 36, 26);
        grpIn.add(caseInM);
        caseInS = new JTextField();
        caseInS.setName("caseInS");
        caseInS.setText("00");
        caseInS.setHorizontalAlignment(0);
        caseInS.setFont(new Font(Shutter.freeSansFont, 0, 14));
        caseInS.setColumns(10);
        caseInS.setBounds(78, 17, 36, 26);
        grpIn.add(caseInS);
        caseInF = new JTextField();
        caseInF.setName("caseInF");
        caseInF.setText("00");
        caseInF.setHorizontalAlignment(0);
        caseInF.setFont(new Font(Shutter.freeSansFont, 0, 14));
        caseInF.setColumns(10);
        caseInF.setBounds(114, 17, 36, 26);
        grpIn.add(caseInF);
        btnPreview = new JLabel(new FlatSVGIcon("contents/preview.svg", 16, 16));
        btnPreview.setHorizontalAlignment(0);
        btnPreview.setBounds(VideoPlayer.frame.getSize().width - 36, VideoPlayer.frame.getSize().height - 26, 16, 16);
        btnPreview.setToolTipText(Shutter.language.getProperty("preview"));
        if (!Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles")) && !Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionReplaceAudio"))) {
            frame.getContentPane().add(btnPreview);
        }
        btnPreview.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                FFMPEG.toSDL(true);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                btnPreview.setIcon(new FlatSVGIcon("contents/preview_hover.svg", 16, 16));
                frame.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                btnPreview.setIcon(new FlatSVGIcon("contents/preview.svg", 16, 16));
                frame.setCursor(Cursor.getPredefinedCursor(0));
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }
        });
        splitValue = new JTextField();
        splitValue.setName("splitValue");
        splitValue.setText("10");
        splitValue.setVisible(false);
        splitValue.setHorizontalAlignment(4);
        splitValue.setFont(new Font(Shutter.freeSansFont, 0, 12));
        splitValue.setColumns(10);
        splitValue.setBounds(VideoPlayer.frame.getSize().width - 48, VideoPlayer.frame.getSize().height - 26, 34, 16);
        frame.getContentPane().add(splitValue);
        splitValue.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (splitValue.getText().length() > 0 && e.getKeyCode() == 10) {
                    waveformContainer.repaint();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (splitValue.getText().length() >= 4) {
                    splitValue.setText("");
                }
            }
        });
        lblSplitSec = new JLabel(Shutter.language.getProperty("lblSec"));
        lblSplitSec.setHorizontalAlignment(4);
        lblSplitSec.setFont(new Font(Shutter.freeSansFont, 0, 12));
        lblSplitSec.setVisible(false);
        lblSplitSec.setBounds(splitValue.getX() + splitValue.getWidth() + 2, splitValue.getY(), VideoPlayer.lblSplitSec.getPreferredSize().width, 16);
        frame.getContentPane().add(lblSplitSec);
        comboMode.setName("comboMode");
        comboMode.setFont(new Font(Shutter.freeSansFont, 0, 11));
        comboMode.setMaximumRowCount(3);
        comboMode.setSize(76, 22);
        if (!Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles")) && !Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionReplaceAudio"))) {
            frame.getContentPane().add(comboMode);
        }
        comboMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (comboMode.getSelectedItem().equals(Shutter.language.getProperty("removeMode")) && showInfoMessage) {
                    JOptionPane.showMessageDialog(frame, Shutter.language.getProperty("mayNotWorkWithGOP"), String.valueOf(Shutter.language.getProperty("mode")) + " " + Shutter.language.getProperty("removeMode"), 1);
                    showInfoMessage = false;
                    btnPreview.setVisible(true);
                    splitValue.setVisible(false);
                    lblSplitSec.setVisible(false);
                } else if (comboMode.getSelectedItem().equals(Shutter.language.getProperty("splitMode"))) {
                    btnPreview.setVisible(false);
                    splitValue.setVisible(true);
                    lblSplitSec.setVisible(true);
                } else {
                    btnPreview.setVisible(true);
                    splitValue.setVisible(false);
                    lblSplitSec.setVisible(false);
                }
                waveformContainer.repaint();
            }
        });
        lblMode = new JLabel(Shutter.language.getProperty("mode"));
        lblMode.setHorizontalAlignment(4);
        lblMode.setFont(new Font(Shutter.freeSansFont, 0, 13));
        if (!Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles")) && !Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionReplaceAudio"))) {
            frame.getContentPane().add(lblMode);
        }
        sliderSpeed = new JSlider();
        sliderSpeed.setMaximum(4);
        sliderSpeed.setValue(2);
        sliderSpeed.setMinorTickSpacing(1);
        sliderSpeed.setMajorTickSpacing(1);
        sliderSpeed.setSize(80, 22);
        if (!Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles")) && !Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionReplaceAudio"))) {
            frame.getContentPane().add(sliderSpeed);
        }
        sliderSpeed.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (sliderSpeed.isEnabled()) {
                    if (e.getX() < 20) {
                        sliderSpeed.setValue(0);
                        lblSpeed.setText(String.valueOf(Shutter.language.getProperty("conformBySpeed")) + " x0.25");
                    } else if (e.getX() > 10 && e.getX() < 30) {
                        sliderSpeed.setValue(1);
                        lblSpeed.setText(String.valueOf(Shutter.language.getProperty("conformBySpeed")) + " x0.5");
                    } else if (e.getX() > 30 && e.getX() < 50) {
                        sliderSpeed.setValue(2);
                        lblSpeed.setText(String.valueOf(Shutter.language.getProperty("conformBySpeed")) + " x1");
                    } else if (e.getX() > 50 && e.getX() < 70) {
                        sliderSpeed.setValue(3);
                        lblSpeed.setText(String.valueOf(Shutter.language.getProperty("conformBySpeed")) + " x1.5");
                    } else if (e.getX() > 70) {
                        sliderSpeed.setValue(4);
                        lblSpeed.setText(String.valueOf(Shutter.language.getProperty("conformBySpeed")) + " x2");
                    }
                    lblSpeed.setBounds(sliderSpeed.getX() - VideoPlayer.lblSpeed.getPreferredSize().width - 2, sliderSpeed.getY() + 2, VideoPlayer.lblSpeed.getPreferredSize().width, 16);
                }
            }

            @Override
            public void mouseMoved(MouseEvent arg0) {
            }
        });
        sliderSpeed.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && sliderSpeed.isEnabled()) {
                    sliderSpeed.setValue(2);
                    lblSpeed.setText(String.valueOf(Shutter.language.getProperty("conformBySpeed")) + " x1");
                    if (slider.getValue() > 0) {
                        frameIsComplete = false;
                        VideoPlayer.playerSetTime(slider.getValue());
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (sliderSpeed.isEnabled()) {
                    if (e.getX() < 20) {
                        sliderSpeed.setValue(0);
                        lblSpeed.setText(String.valueOf(Shutter.language.getProperty("conformBySpeed")) + " x0.25");
                    } else if (e.getX() > 10 && e.getX() < 30) {
                        sliderSpeed.setValue(1);
                        lblSpeed.setText(String.valueOf(Shutter.language.getProperty("conformBySpeed")) + " x0.5");
                    } else if (e.getX() > 30 && e.getX() < 50) {
                        sliderSpeed.setValue(2);
                        lblSpeed.setText(String.valueOf(Shutter.language.getProperty("conformBySpeed")) + " x1");
                    } else if (e.getX() > 50 && e.getX() < 70) {
                        sliderSpeed.setValue(3);
                        lblSpeed.setText(String.valueOf(Shutter.language.getProperty("conformBySpeed")) + " x1.5");
                    } else if (e.getX() > 70) {
                        sliderSpeed.setValue(4);
                        lblSpeed.setText(String.valueOf(Shutter.language.getProperty("conformBySpeed")) + " x2");
                    }
                    lblSpeed.setBounds(sliderSpeed.getX() - VideoPlayer.lblSpeed.getPreferredSize().width - 2, sliderSpeed.getY() + 2, VideoPlayer.lblSpeed.getPreferredSize().width, 16);
                    if (slider.getValue() > 0) {
                        frameIsComplete = false;
                        VideoPlayer.playerSetTime(slider.getValue());
                    }
                }
            }
        });
        lblSpeed = new JLabel(String.valueOf(Shutter.language.getProperty("conformBySpeed")) + " x1");
        lblSpeed.setHorizontalAlignment(4);
        lblSpeed.setFont(new Font(Shutter.freeSansFont, 0, 13));
        if (!Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles")) && !Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionReplaceAudio"))) {
            frame.getContentPane().add(lblSpeed);
        }
        caseInH.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (!caseInH.getText().isEmpty()) {
                    if (e.getKeyCode() == 38 || e.getKeyCode() == 39) {
                        caseInH.setText(String.valueOf(Integer.parseInt(caseInH.getText()) + 1));
                        if (caseInH.getText().length() == 1) {
                            caseInH.setText("0" + caseInH.getText());
                        }
                    }
                    if (e.getKeyCode() == 40 || e.getKeyCode() == 37) {
                        caseInH.setText(String.valueOf(Integer.parseInt(caseInH.getText()) - 1));
                        if (caseInH.getText().length() == 1) {
                            caseInH.setText("0" + caseInH.getText());
                        }
                    }
                }
                if (caseInH.getText().length() > 1 || e.getKeyCode() == 10) {
                    if (caseInH.getText().length() == 1) {
                        caseInH.setText("0" + caseInH.getText());
                    }
                    playerCurrentFrame = (float)(Integer.parseInt(caseInH.getText()) * 3600 + Integer.parseInt(caseInM.getText()) * 60 + Integer.parseInt(caseInS.getText())) * FFPROBE.currentFPS + (float)Integer.parseInt(caseInF.getText());
                    playerCurrentFrame = Timecode.getNonDropFrameTC(playerCurrentFrame);
                    VideoPlayer.playerSetTime(playerCurrentFrame);
                    playerInMark = Math.round((float)VideoPlayer.waveformContainer.getSize().width * playerCurrentFrame / (float)slider.getMaximum());
                    waveformContainer.repaint();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (caseInH.getText().length() >= 2) {
                    caseInH.setText("");
                }
            }
        });
        caseInH.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                if (caseInH.getText().length() == 1) {
                    caseInH.setText("0" + caseInH.getText());
                }
            }
        });
        caseInM.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (!caseInM.getText().isEmpty()) {
                    if (e.getKeyCode() == 38 || e.getKeyCode() == 39) {
                        caseInM.setText(String.valueOf(Integer.parseInt(caseInM.getText()) + 1));
                        if (caseInM.getText().length() == 1) {
                            caseInM.setText("0" + caseInM.getText());
                        }
                    }
                    if (e.getKeyCode() == 40 || e.getKeyCode() == 37) {
                        caseInM.setText(String.valueOf(Integer.parseInt(caseInM.getText()) - 1));
                        if (caseInM.getText().length() == 1) {
                            caseInM.setText("0" + caseInM.getText());
                        }
                    }
                }
                if (caseInM.getText().length() > 1 || e.getKeyCode() == 10) {
                    if (caseInM.getText().length() == 1) {
                        caseInM.setText("0" + caseInM.getText());
                    }
                    playerCurrentFrame = (float)(Integer.parseInt(caseInH.getText()) * 3600 + Integer.parseInt(caseInM.getText()) * 60 + Integer.parseInt(caseInS.getText())) * FFPROBE.currentFPS + (float)Integer.parseInt(caseInF.getText());
                    playerCurrentFrame = Timecode.getNonDropFrameTC(playerCurrentFrame);
                    VideoPlayer.playerSetTime(playerCurrentFrame);
                    playerInMark = Math.round((float)VideoPlayer.waveformContainer.getSize().width * playerCurrentFrame / (float)slider.getMaximum());
                    waveformContainer.repaint();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (caseInM.getText().length() >= 2) {
                    caseInM.setText("");
                }
            }
        });
        caseInM.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                if (caseInM.getText().length() == 1) {
                    caseInM.setText("0" + caseInM.getText());
                }
            }
        });
        caseInS.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (!caseInS.getText().isEmpty()) {
                    if (e.getKeyCode() == 38 || e.getKeyCode() == 39) {
                        caseInS.setText(String.valueOf(Integer.parseInt(caseInS.getText()) + 1));
                        if (caseInS.getText().length() == 1) {
                            caseInS.setText("0" + caseInS.getText());
                        }
                    }
                    if (e.getKeyCode() == 40 || e.getKeyCode() == 37) {
                        caseInS.setText(String.valueOf(Integer.parseInt(caseInS.getText()) - 1));
                        if (caseInS.getText().length() == 1) {
                            caseInS.setText("0" + caseInS.getText());
                        }
                    }
                }
                if (caseInS.getText().length() > 1 || e.getKeyCode() == 10) {
                    if (caseInS.getText().length() == 1) {
                        caseInS.setText("0" + caseInS.getText());
                    }
                    playerCurrentFrame = (float)(Integer.parseInt(caseInH.getText()) * 3600 + Integer.parseInt(caseInM.getText()) * 60 + Integer.parseInt(caseInS.getText())) * FFPROBE.currentFPS + (float)Integer.parseInt(caseInF.getText());
                    playerCurrentFrame = Timecode.getNonDropFrameTC(playerCurrentFrame);
                    VideoPlayer.playerSetTime(playerCurrentFrame);
                    playerInMark = Math.round((float)VideoPlayer.waveformContainer.getSize().width * playerCurrentFrame / (float)slider.getMaximum());
                    waveformContainer.repaint();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (caseInS.getText().length() >= 2) {
                    caseInS.setText("");
                }
            }
        });
        caseInS.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                if (caseInS.getText().length() == 1) {
                    caseInS.setText("0" + caseInS.getText());
                }
            }
        });
        caseInF.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (!caseInF.getText().isEmpty()) {
                    if (e.getKeyCode() == 38 || e.getKeyCode() == 39) {
                        caseInF.setText(String.valueOf(Integer.parseInt(caseInF.getText()) + 1));
                        if (caseInF.getText().length() == 1) {
                            caseInF.setText("0" + caseInF.getText());
                        }
                    }
                    if (e.getKeyCode() == 40 || e.getKeyCode() == 37) {
                        caseInF.setText(String.valueOf(Integer.parseInt(caseInF.getText()) - 1));
                        if (caseInF.getText().length() == 1) {
                            caseInF.setText("0" + caseInF.getText());
                        }
                    }
                }
                if (caseInF.getText().length() > 1 || e.getKeyCode() == 10) {
                    if (caseInF.getText().length() == 1) {
                        caseInF.setText("0" + caseInF.getText());
                    }
                    playerCurrentFrame = (float)(Integer.parseInt(caseInH.getText()) * 3600 + Integer.parseInt(caseInM.getText()) * 60 + Integer.parseInt(caseInS.getText())) * FFPROBE.currentFPS + (float)Integer.parseInt(caseInF.getText());
                    playerCurrentFrame = Timecode.getNonDropFrameTC(playerCurrentFrame);
                    VideoPlayer.playerSetTime(playerCurrentFrame);
                    playerInMark = Math.round((float)VideoPlayer.waveformContainer.getSize().width * playerCurrentFrame / (float)slider.getMaximum());
                    waveformContainer.repaint();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (caseInF.getText().length() >= 2) {
                    caseInF.setText("");
                }
            }
        });
        caseInF.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                if (caseInF.getText().length() == 1) {
                    caseInF.setText("0" + caseInF.getText());
                }
            }
        });
    }

    private static void updateGrpIn(float timeIn) {
        if (timeIn > 0.0f) {
            timeIn = Timecode.setNonDropFrameTC(timeIn);
        }
        caseInH.setText(formatter.format(Math.floor(timeIn / FFPROBE.currentFPS / 3600.0f)));
        caseInM.setText(formatter.format(Math.floor(timeIn / FFPROBE.currentFPS / 60.0f) % 60.0));
        caseInS.setText(formatter.format(Math.floor(timeIn / FFPROBE.currentFPS) % 60.0));
        caseInF.setText(formatter.format(Math.floor(timeIn % FFPROBE.currentFPS)));
    }

    private void grpOut() {
        grpOut = new JPanel();
        grpOut.setLayout(null);
        grpOut.setBorder(BorderFactory.createTitledBorder(new RoundedLineBorder(new Color(65, 65, 65), 1, 5, true), String.valueOf(Shutter.language.getProperty("grpOut")) + " ", 0, 0, new Font(Shutter.montserratFont, 0, 12), Color.WHITE));
        grpOut.setBackground(new Color(45, 45, 45));
        grpOut.setBounds(frame.getWidth() - grpIn.getWidth() - 12, grpIn.getY(), grpIn.getWidth(), grpIn.getHeight());
        frame.getContentPane().add(grpOut);
        caseVuMeter = new JCheckBox(Shutter.language.getProperty("caseVuMeter"));
        caseVuMeter.setName("caseVuMeter");
        caseVuMeter.setFont(new Font(Shutter.freeSansFont, 0, 12));
        caseVuMeter.setSelected(Settings.videoPlayerCaseVuMeter);
        frame.getContentPane().add(caseVuMeter);
        caseVuMeter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                frameIsComplete = false;
                VideoPlayer.playerSetTime(slider.getValue());
                Settings.videoPlayerCaseVuMeter = caseVuMeter.isSelected();
            }
        });
        caseGPU = new JCheckBox(Shutter.language.getProperty("caseGPU"));
        caseGPU.setName("caseGPU");
        caseGPU.setFont(new Font(Shutter.freeSansFont, 0, 12));
        caseGPU.setSelected(Settings.videoPlayerCaseGPUDecoding);
        frame.getContentPane().add(caseGPU);
        caseGPU.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                frameIsComplete = false;
                VideoPlayer.playerSetTime(slider.getValue());
                Settings.videoPlayerCaseGPUDecoding = caseGPU.isSelected();
            }
        });
        casePlaySound = new JCheckBox(Shutter.language.getProperty("casePlaySound"));
        casePlaySound.setName("casePlaySound");
        casePlaySound.setFont(new Font(Shutter.freeSansFont, 0, 12));
        casePlaySound.setSelected(Settings.videoPlayerCasePlaySound);
        frame.getContentPane().add(casePlaySound);
        casePlaySound.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Settings.videoPlayerCasePlaySound = casePlaySound.isSelected();
            }
        });
        caseInternalTc = new JCheckBox(Shutter.language.getProperty("caseTcInterne"));
        caseInternalTc.setFont(new Font(Shutter.freeSansFont, 0, 12));
        frame.getContentPane().add(caseInternalTc);
        caseInternalTc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (caseInternalTc.isSelected()) {
                    FFPROBE.Data(videoPath);
                    do {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } while (FFPROBE.isRunning);
                    if (FFPROBE.timecode1.equals("")) {
                        MEDIAINFO.run(videoPath, false);
                        do {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        } while (MEDIAINFO.isRunning);
                    }
                    if (FFPROBE.timecode1.equals("")) {
                        caseInternalTc.setSelected(false);
                        offset = 0.0f;
                    } else {
                        offset = (float)(Integer.valueOf(FFPROBE.timecode1) * 3600) * FFPROBE.currentFPS + (float)(Integer.valueOf(FFPROBE.timecode2) * 60) * FFPROBE.currentFPS + (float)Integer.valueOf(FFPROBE.timecode3).intValue() * FFPROBE.currentFPS + (float)Integer.valueOf(FFPROBE.timecode4).intValue();
                    }
                } else {
                    offset = 0.0f;
                }
                sliderChange = true;
                VideoPlayer.getTimePoint(playerCurrentFrame);
                sliderChange = false;
            }
        });
        caseOutH = new JTextField();
        caseOutH.setName("caseOutH");
        caseOutH.setText("00");
        caseOutH.setHorizontalAlignment(0);
        caseOutH.setFont(new Font(Shutter.freeSansFont, 0, 14));
        caseOutH.setColumns(10);
        caseOutH.setBounds(6, 17, 36, 26);
        grpOut.add(caseOutH);
        caseOutM = new JTextField();
        caseOutM.setName("caseOutM");
        caseOutM.setText("00");
        caseOutM.setHorizontalAlignment(0);
        caseOutM.setFont(new Font(Shutter.freeSansFont, 0, 14));
        caseOutM.setColumns(10);
        caseOutM.setBounds(42, 17, 36, 26);
        grpOut.add(caseOutM);
        caseOutS = new JTextField();
        caseOutS.setName("caseOutS");
        caseOutS.setText("00");
        caseOutS.setHorizontalAlignment(0);
        caseOutS.setFont(new Font(Shutter.freeSansFont, 0, 14));
        caseOutS.setColumns(10);
        caseOutS.setBounds(78, 17, 36, 26);
        grpOut.add(caseOutS);
        caseOutF = new JTextField();
        caseOutF.setName("caseOutF");
        caseOutF.setText("00");
        caseOutF.setHorizontalAlignment(0);
        caseOutF.setFont(new Font(Shutter.freeSansFont, 0, 14));
        caseOutF.setColumns(10);
        caseOutF.setBounds(114, 17, 36, 26);
        grpOut.add(caseOutF);
        caseOutH.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (!caseOutH.getText().isEmpty()) {
                    if (e.getKeyCode() == 38 || e.getKeyCode() == 39) {
                        caseOutH.setText(String.valueOf(Integer.parseInt(caseOutH.getText()) + 1));
                        if (caseOutH.getText().length() == 1) {
                            caseOutH.setText("0" + caseOutH.getText());
                        }
                    }
                    if (e.getKeyCode() == 40 || e.getKeyCode() == 37) {
                        caseOutH.setText(String.valueOf(Integer.parseInt(caseOutH.getText()) - 1));
                        if (caseOutH.getText().length() == 1) {
                            caseOutH.setText("0" + caseOutH.getText());
                        }
                    }
                }
                if (caseOutH.getText().length() > 1 || e.getKeyCode() == 10) {
                    if (caseOutH.getText().length() == 1) {
                        caseOutH.setText("0" + caseOutH.getText());
                    }
                    playerCurrentFrame = (float)(Integer.parseInt(caseOutH.getText()) * 3600 + Integer.parseInt(caseOutM.getText()) * 60 + Integer.parseInt(caseOutS.getText())) * FFPROBE.currentFPS + (float)Integer.parseInt(caseOutF.getText()) - 1.0f;
                    playerCurrentFrame = Timecode.getNonDropFrameTC(playerCurrentFrame);
                    VideoPlayer.playerSetTime(playerCurrentFrame);
                    playerOutMark = Math.round((float)VideoPlayer.waveformContainer.getSize().width * playerCurrentFrame / (float)slider.getMaximum());
                    waveformContainer.repaint();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (caseOutH.getText().length() >= 2) {
                    caseOutH.setText("");
                }
            }
        });
        caseOutH.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                if (caseOutH.getText().length() == 1) {
                    caseOutH.setText("0" + caseOutH.getText());
                }
            }
        });
        caseOutM.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (!caseOutM.getText().isEmpty()) {
                    if (e.getKeyCode() == 38 || e.getKeyCode() == 39) {
                        caseOutM.setText(String.valueOf(Integer.parseInt(caseOutM.getText()) + 1));
                        if (caseOutM.getText().length() == 1) {
                            caseOutM.setText("0" + caseOutM.getText());
                        }
                    }
                    if (e.getKeyCode() == 40 || e.getKeyCode() == 37) {
                        caseOutM.setText(String.valueOf(Integer.parseInt(caseOutM.getText()) - 1));
                        if (caseOutM.getText().length() == 1) {
                            caseOutM.setText("0" + caseOutM.getText());
                        }
                    }
                }
                if (caseOutM.getText().length() > 1 || e.getKeyCode() == 10) {
                    if (caseOutM.getText().length() == 1) {
                        caseOutM.setText("0" + caseOutM.getText());
                    }
                    playerCurrentFrame = (float)(Integer.parseInt(caseOutH.getText()) * 3600 + Integer.parseInt(caseOutM.getText()) * 60 + Integer.parseInt(caseOutS.getText())) * FFPROBE.currentFPS + (float)Integer.parseInt(caseOutF.getText()) - 1.0f;
                    playerCurrentFrame = Timecode.getNonDropFrameTC(playerCurrentFrame);
                    VideoPlayer.playerSetTime(playerCurrentFrame);
                    playerOutMark = Math.round((float)VideoPlayer.waveformContainer.getSize().width * playerCurrentFrame / (float)slider.getMaximum());
                    waveformContainer.repaint();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (caseOutM.getText().length() >= 2) {
                    caseOutM.setText("");
                }
            }
        });
        caseOutM.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                if (caseOutM.getText().length() == 1) {
                    caseOutM.setText("0" + caseOutM.getText());
                }
            }
        });
        caseOutS.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (!caseOutS.getText().isEmpty()) {
                    if (e.getKeyCode() == 38 || e.getKeyCode() == 39) {
                        caseOutS.setText(String.valueOf(Integer.parseInt(caseOutS.getText()) + 1));
                        if (caseOutS.getText().length() == 1) {
                            caseOutS.setText("0" + caseOutS.getText());
                        }
                    }
                    if (e.getKeyCode() == 40 || e.getKeyCode() == 37) {
                        caseOutS.setText(String.valueOf(Integer.parseInt(caseOutS.getText()) - 1));
                        if (caseOutS.getText().length() == 1) {
                            caseOutS.setText("0" + caseOutS.getText());
                        }
                    }
                }
                if (caseOutS.getText().length() > 1 || e.getKeyCode() == 10) {
                    if (caseOutS.getText().length() == 1) {
                        caseOutS.setText("0" + caseOutS.getText());
                    }
                    playerCurrentFrame = (float)(Integer.parseInt(caseOutH.getText()) * 3600 + Integer.parseInt(caseOutM.getText()) * 60 + Integer.parseInt(caseOutS.getText())) * FFPROBE.currentFPS + (float)Integer.parseInt(caseOutF.getText()) - 1.0f;
                    playerCurrentFrame = Timecode.getNonDropFrameTC(playerCurrentFrame);
                    VideoPlayer.playerSetTime(playerCurrentFrame);
                    playerOutMark = Math.round((float)VideoPlayer.waveformContainer.getSize().width * playerCurrentFrame / (float)slider.getMaximum());
                    waveformContainer.repaint();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (caseOutS.getText().length() >= 2) {
                    caseOutS.setText("");
                }
            }
        });
        caseOutS.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                if (caseOutS.getText().length() == 1) {
                    caseOutS.setText("0" + caseOutS.getText());
                }
            }
        });
        caseOutF.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (!caseOutF.getText().isEmpty()) {
                    if (e.getKeyCode() == 38 || e.getKeyCode() == 39) {
                        caseOutF.setText(String.valueOf(Integer.parseInt(caseOutF.getText()) + 1));
                        if (caseOutF.getText().length() == 1) {
                            caseOutF.setText("0" + caseOutF.getText());
                        }
                    }
                    if (e.getKeyCode() == 40 || e.getKeyCode() == 37) {
                        caseOutF.setText(String.valueOf(Integer.parseInt(caseOutF.getText()) - 1));
                        if (caseOutF.getText().length() == 1) {
                            caseOutF.setText("0" + caseOutF.getText());
                        }
                    }
                }
                if (caseOutF.getText().length() > 1 || e.getKeyCode() == 10) {
                    if (caseOutF.getText().length() == 1) {
                        caseOutF.setText("0" + caseOutF.getText());
                    }
                    playerCurrentFrame = (float)(Integer.parseInt(caseOutH.getText()) * 3600 + Integer.parseInt(caseOutM.getText()) * 60 + Integer.parseInt(caseOutS.getText())) * FFPROBE.currentFPS + (float)Integer.parseInt(caseOutF.getText()) - 1.0f;
                    playerCurrentFrame = Timecode.getNonDropFrameTC(playerCurrentFrame);
                    VideoPlayer.playerSetTime(playerCurrentFrame);
                    playerOutMark = Math.round((float)VideoPlayer.waveformContainer.getSize().width * playerCurrentFrame / (float)slider.getMaximum());
                    waveformContainer.repaint();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (caseOutF.getText().length() >= 2) {
                    caseOutF.setText("");
                }
            }
        });
        caseOutF.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                if (caseOutF.getText().length() == 1) {
                    caseOutF.setText("0" + caseOutF.getText());
                }
            }
        });
    }

    private static void updateGrpOut(float timeOut) {
        if (playerOutMark < waveformContainer.getWidth() - 2) {
            timeOut = Timecode.setNonDropFrameTC(timeOut);
            caseOutH.setText(formatter.format(Math.floor(timeOut / FFPROBE.currentFPS / 3600.0f)));
            caseOutM.setText(formatter.format(Math.floor(timeOut / FFPROBE.currentFPS / 60.0f) % 60.0));
            caseOutS.setText(formatter.format(Math.floor(timeOut / FFPROBE.currentFPS) % 60.0));
            caseOutF.setText(formatter.format(Math.floor(timeOut % FFPROBE.currentFPS)));
        } else {
            caseOutH.setText(formatter.format(FFPROBE.totalLength / 3600000));
            caseOutM.setText(formatter.format(FFPROBE.totalLength / 60000 % 60));
            caseOutS.setText(formatter.format(FFPROBE.totalLength / 1000 % 60));
            caseOutF.setText(formatter.format((int)Math.floor((float)FFPROBE.totalLength / (1000.0f / FFPROBE.currentFPS) % FFPROBE.currentFPS)));
        }
    }

    private void grpColorimetry() {
        grpColorimetry = new JPanel();
        grpColorimetry.setLayout(null);
        grpColorimetry.setBorder(BorderFactory.createTitledBorder(new RoundedLineBorder(new Color(65, 65, 65), 1, 5, true), String.valueOf(Shutter.language.getProperty("frameColorImage")) + " ", 0, 0, new Font(Shutter.montserratFont, 0, 12), Color.WHITE));
        grpColorimetry.setBackground(new Color(45, 45, 45));
        grpColorimetry.setBounds(6, btnCapture.getY() + btnCapture.getHeight() + 6, 314, 17);
        frame.getContentPane().add(grpColorimetry);
        grpColorimetry.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int grpInSize = frame.getHeight() - grpIn.getY();
                if (!waveformContainer.isVisible()) {
                    grpInSize = 0;
                }
                final int sized = frame.getHeight() - grpInSize - grpColorimetry.getY() - 40 - 12;
                if (VideoPlayer.grpColorimetry.getSize().height > 17) {
                    Thread changeSize = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                int i = sized;
                                do {
                                    long startTime = System.currentTimeMillis() + 1L;
                                    i = Settings.btnDisableAnimations.isSelected() ? 17 : (i -= 2);
                                    grpColorimetry.setSize(grpColorimetry.getWidth(), i);
                                    (this).VideoPlayer.this.scrollBarColorimetry.setSize(11, grpColorimetry.getHeight() - 11);
                                    grpCorrections.setLocation(VideoPlayer.grpColorimetry.getLocation().x, VideoPlayer.grpColorimetry.getSize().height + VideoPlayer.grpColorimetry.getLocation().y + 6);
                                    grpTransitions.setLocation(VideoPlayer.grpColorimetry.getLocation().x, VideoPlayer.grpCorrections.getSize().height + VideoPlayer.grpCorrections.getLocation().y + 6);
                                    Shutter.animateSections(startTime);
                                } while (i > 17);
                                if (grpColorimetry.getHeight() < 17) {
                                    grpColorimetry.setSize(grpColorimetry.getWidth(), 17);
                                }
                                (this).VideoPlayer.this.scrollBarColorimetry.setValue(0);
                                (this).VideoPlayer.this.scrollBarColorimetry.setVisible(false);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                    changeSize.start();
                } else {
                    Thread changeSize = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                long startTime;
                                int i = 17;
                                do {
                                    startTime = System.currentTimeMillis() + 1L;
                                    i = Settings.btnDisableAnimations.isSelected() ? sized : (i += 2);
                                    if (grpColorimetry.getHeight() < btnReset.getY() + btnReset.getHeight() + 30) {
                                        grpColorimetry.setSize(grpColorimetry.getWidth(), i);
                                        panelColorimetryComponents.setSize(grpColorimetry.getWidth() - 18, grpColorimetry.getHeight() - 25);
                                        (this).VideoPlayer.this.scrollBarColorimetry.setSize(11, grpColorimetry.getHeight() - 11);
                                        grpCorrections.setLocation(VideoPlayer.grpColorimetry.getLocation().x, VideoPlayer.grpColorimetry.getSize().height + VideoPlayer.grpColorimetry.getLocation().y + 6);
                                        grpTransitions.setLocation(VideoPlayer.grpColorimetry.getLocation().x, VideoPlayer.grpCorrections.getSize().height + VideoPlayer.grpCorrections.getLocation().y + 6);
                                        int maxHeight = grpIn.getY();
                                        if (!grpIn.isVisible()) {
                                            maxHeight = frame.getHeight();
                                        }
                                        if (grpCorrections.getY() + grpCorrections.getHeight() >= maxHeight - 17 - 12 && grpCorrections.getHeight() > 17) {
                                            grpCorrections.setSize(grpCorrections.getWidth(), grpCorrections.getHeight() - 2);
                                            grpTransitions.setLocation(VideoPlayer.grpColorimetry.getLocation().x, VideoPlayer.grpCorrections.getSize().height + VideoPlayer.grpCorrections.getLocation().y + 6);
                                        }
                                        if (grpTransitions.getY() + grpTransitions.getHeight() >= maxHeight - 6 && grpTransitions.getHeight() > 17) {
                                            grpTransitions.setSize(grpTransitions.getWidth(), grpTransitions.getHeight() - 2);
                                        }
                                    }
                                    if (Settings.btnDisableAnimations.isSelected() && grpColorimetry.getHeight() > 17) {
                                        int grpInSize = frame.getHeight() - grpIn.getY();
                                        if (!waveformContainer.isVisible()) {
                                            grpInSize = 0;
                                        }
                                        grpColorimetry.setSize(grpColorimetry.getWidth(), frame.getHeight() - grpInSize - grpColorimetry.getY() - grpCorrections.getHeight() - 12);
                                        if (grpColorimetry.getHeight() > btnReset.getY() + btnReset.getHeight() + 30) {
                                            grpColorimetry.setSize(grpColorimetry.getWidth(), btnReset.getY() + btnReset.getHeight() + 30);
                                        }
                                        panelColorimetryComponents.setSize(grpColorimetry.getWidth() - 18, grpColorimetry.getHeight() - 25);
                                        grpCorrections.setLocation(VideoPlayer.grpColorimetry.getLocation().x, VideoPlayer.grpColorimetry.getSize().height + VideoPlayer.grpColorimetry.getLocation().y + 6);
                                        grpTransitions.setLocation(VideoPlayer.grpColorimetry.getLocation().x, VideoPlayer.grpCorrections.getSize().height + VideoPlayer.grpCorrections.getLocation().y + 6);
                                    }
                                    Shutter.animateSections(startTime);
                                } while (i < sized);
                                if (grpColorimetry.getHeight() < btnReset.getY() + btnReset.getHeight() + 30) {
                                    (this).VideoPlayer.this.scrollBarColorimetry.setMaximum(btnReset.getY() + btnReset.getHeight() + 15 - panelColorimetryComponents.getHeight());
                                    (this).VideoPlayer.this.scrollBarColorimetry.setVisible(true);
                                } else {
                                    (this).VideoPlayer.this.scrollBarColorimetry.setVisible(false);
                                }
                                if (grpCorrections.getHeight() > 17 && grpCorrections.getHeight() < 144) {
                                    i = grpCorrections.getHeight();
                                    do {
                                        startTime = System.currentTimeMillis() + 1L;
                                        i = Settings.btnDisableAnimations.isSelected() ? 17 : --i;
                                        grpCorrections.setSize(grpCorrections.getWidth(), i);
                                        grpTransitions.setLocation(VideoPlayer.grpColorimetry.getLocation().x, VideoPlayer.grpCorrections.getSize().height + VideoPlayer.grpCorrections.getLocation().y + 6);
                                        Shutter.animateSections(startTime);
                                    } while (i > 17);
                                } else if (grpCorrections.getHeight() < 17) {
                                    grpCorrections.setSize(grpCorrections.getWidth(), 17);
                                    grpTransitions.setLocation(VideoPlayer.grpColorimetry.getLocation().x, VideoPlayer.grpCorrections.getSize().height + VideoPlayer.grpCorrections.getLocation().y + 6);
                                }
                                if (grpTransitions.getHeight() > 17 && grpTransitions.getHeight() < 104) {
                                    i = grpTransitions.getHeight();
                                    do {
                                        startTime = System.currentTimeMillis() + 1L;
                                        i = Settings.btnDisableAnimations.isSelected() ? 17 : --i;
                                        grpTransitions.setSize(grpTransitions.getWidth(), i);
                                        Shutter.animateSections(startTime);
                                    } while (i > 17);
                                } else if (grpTransitions.getHeight() < 17) {
                                    grpTransitions.setSize(grpTransitions.getWidth(), 17);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                    changeSize.start();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        panelColorimetryComponents = new JPanel();
        panelColorimetryComponents.setBackground(new Color(45, 45, 45));
        panelColorimetryComponents.setOpaque(true);
        panelColorimetryComponents.setLayout(null);
        panelColorimetryComponents.setSize(grpColorimetry.getWidth() - 18, grpColorimetry.getHeight() - 25);
        panelColorimetryComponents.setLocation(4, 15);
        grpColorimetry.add(panelColorimetryComponents);
        this.scrollBarColorimetry = new JScrollBar();
        this.scrollBarColorimetry.setBackground(new Color(45, 45, 45));
        this.scrollBarColorimetry.setOrientation(1);
        this.scrollBarColorimetry.setSize(11, grpColorimetry.getHeight() - 11);
        this.scrollBarColorimetry.setLocation(grpColorimetry.getWidth() - this.scrollBarColorimetry.getWidth() - 3, 8);
        this.scrollBarColorimetry.setVisible(false);
        this.scrollBarColorimetry.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent ae) {
                int scrollIncrement = VideoPlayer.this.scrollBarColorimetry.getValue() - VideoPlayer.this.scrollColorimetryValue;
                Component[] componentArray = panelColorimetryComponents.getComponents();
                int n = componentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Component c = componentArray[n2];
                    if (c instanceof JLabel || c instanceof JSlider && c.getName() != null || c instanceof JComboBox || c instanceof JButton || c instanceof JCheckBox) {
                        c.setLocation(c.getLocation().x, c.getLocation().y - scrollIncrement);
                    }
                    ++n2;
                }
                VideoPlayer.this.scrollColorimetryValue = VideoPlayer.this.scrollBarColorimetry.getValue();
            }
        });
        grpColorimetry.add(this.scrollBarColorimetry);
        panelColorimetryComponents.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (VideoPlayer.this.scrollBarColorimetry.isVisible()) {
                    VideoPlayer.this.scrollBarColorimetry.setValue(VideoPlayer.this.scrollBarColorimetry.getValue() + e.getWheelRotation() * 10);
                }
            }
        });
        caseEnableColorimetry.setName("caseEnableColorimetry");
        caseEnableColorimetry.setBounds(4, 2, 90, 23);
        caseEnableColorimetry.setForeground(Color.WHITE);
        caseEnableColorimetry.setFont(new Font(Shutter.freeSansFont, 0, 12));
        caseEnableColorimetry.setSelected(true);
        panelColorimetryComponents.add(caseEnableColorimetry);
        caseEnableColorimetry.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                VideoPlayer.loadImage(true);
            }
        });
        final JLabel lblExposure = new JLabel(Shutter.language.getProperty("lblExposure"));
        lblExposure.setFont(new Font(Shutter.freeSansFont, 0, 13));
        lblExposure.setBounds(6, caseEnableColorimetry.getY() + caseEnableColorimetry.getHeight() + 4, 250, 16);
        panelColorimetryComponents.add(lblExposure);
        panelColorimetryComponents.add(lblExposure);
        sliderExposure.setName("sliderExposure");
        sliderExposure.setMaximum(100);
        sliderExposure.setMinimum(-100);
        sliderExposure.setValue(0);
        sliderExposure.setFont(new Font(Shutter.freeSansFont, 0, 11));
        sliderExposure.setBounds(4, lblExposure.getY() + lblExposure.getHeight(), 284, 22);
        sliderExposure.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    sliderExposure.setValue(0);
                    lblExposure.setText(Shutter.language.getProperty("lblExposure"));
                }
            }
        });
        sliderExposure.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (sliderExposure.getValue() == 0) {
                    lblExposure.setText(Shutter.language.getProperty("lblExposure"));
                } else {
                    lblExposure.setText(String.valueOf(Shutter.language.getProperty("lblExposure")) + " " + sliderExposure.getValue());
                }
                VideoPlayer.loadImage(false);
            }
        });
        panelColorimetryComponents.add(sliderExposure);
        final JLabel lblGamma = new JLabel(Shutter.language.getProperty("lblGamma"));
        lblGamma.setFont(new Font(Shutter.freeSansFont, 0, 13));
        lblGamma.setBounds(6, sliderExposure.getY() + sliderExposure.getHeight() + 4, lblExposure.getSize().width, 16);
        panelColorimetryComponents.add(lblGamma);
        panelColorimetryComponents.add(lblGamma);
        sliderGamma.setName("sliderGamma");
        sliderGamma.setMaximum(90);
        sliderGamma.setMinimum(-90);
        sliderGamma.setValue(0);
        sliderGamma.setFont(new Font(Shutter.freeSansFont, 0, 11));
        sliderGamma.setBounds(4, lblGamma.getY() + lblGamma.getHeight(), sliderExposure.getWidth(), 22);
        sliderGamma.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    sliderGamma.setValue(0);
                    lblGamma.setText(Shutter.language.getProperty("lblGamma"));
                }
            }
        });
        sliderGamma.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (sliderGamma.getValue() == 0) {
                    lblGamma.setText(Shutter.language.getProperty("lblGamma"));
                } else {
                    lblGamma.setText(String.valueOf(Shutter.language.getProperty("lblGamma")) + " " + sliderGamma.getValue());
                }
                VideoPlayer.loadImage(false);
            }
        });
        panelColorimetryComponents.add(sliderGamma);
        final JLabel lblContrast = new JLabel(Shutter.language.getProperty("lblContrast"));
        lblContrast.setFont(new Font(Shutter.freeSansFont, 0, 13));
        lblContrast.setBounds(6, sliderGamma.getY() + sliderGamma.getHeight() + 4, lblExposure.getSize().width, 16);
        panelColorimetryComponents.add(lblContrast);
        panelColorimetryComponents.add(lblContrast);
        sliderContrast.setName("sliderContrast");
        sliderContrast.setMaximum(100);
        sliderContrast.setMinimum(-100);
        sliderContrast.setValue(0);
        sliderContrast.setFont(new Font(Shutter.freeSansFont, 0, 11));
        sliderContrast.setBounds(4, lblContrast.getY() + lblContrast.getHeight(), sliderExposure.getWidth(), 22);
        sliderContrast.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    sliderContrast.setValue(0);
                    lblContrast.setText(Shutter.language.getProperty("lblContrast"));
                }
            }
        });
        sliderContrast.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (sliderContrast.getValue() == 0) {
                    lblContrast.setText(Shutter.language.getProperty("lblContrast"));
                } else {
                    lblContrast.setText(String.valueOf(Shutter.language.getProperty("lblContrast")) + " " + sliderContrast.getValue());
                }
                VideoPlayer.loadImage(false);
            }
        });
        panelColorimetryComponents.add(sliderContrast);
        final JLabel lblWhite = new JLabel(Shutter.language.getProperty("lblWhite"));
        lblWhite.setFont(new Font(Shutter.freeSansFont, 0, 13));
        lblWhite.setBounds(6, sliderContrast.getY() + sliderContrast.getHeight() + 4, lblExposure.getSize().width, 16);
        panelColorimetryComponents.add(lblWhite);
        panelColorimetryComponents.add(lblWhite);
        sliderWhite.setName("sliderWhite");
        sliderWhite.setMaximum(100);
        sliderWhite.setMinimum(-100);
        sliderWhite.setValue(0);
        sliderWhite.setFont(new Font(Shutter.freeSansFont, 0, 11));
        sliderWhite.setBounds(4, lblWhite.getY() + lblWhite.getHeight(), sliderExposure.getWidth(), 22);
        sliderWhite.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    sliderWhite.setValue(0);
                    lblWhite.setText(Shutter.language.getProperty("lblWhite"));
                }
            }
        });
        sliderWhite.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (sliderWhite.getValue() == 0) {
                    lblWhite.setText(Shutter.language.getProperty("lblWhite"));
                } else {
                    lblWhite.setText(String.valueOf(Shutter.language.getProperty("lblWhite")) + " " + sliderWhite.getValue());
                }
                VideoPlayer.loadImage(false);
            }
        });
        panelColorimetryComponents.add(sliderWhite);
        final JLabel lblBlack = new JLabel(Shutter.language.getProperty("lblBlack"));
        lblBlack.setFont(new Font(Shutter.freeSansFont, 0, 13));
        lblBlack.setBounds(6, sliderWhite.getY() + sliderWhite.getHeight() + 4, lblExposure.getSize().width, 16);
        panelColorimetryComponents.add(lblBlack);
        panelColorimetryComponents.add(lblBlack);
        sliderBlack.setName("sliderBlack");
        sliderBlack.setMaximum(100);
        sliderBlack.setMinimum(-100);
        sliderBlack.setValue(0);
        sliderBlack.setFont(new Font(Shutter.freeSansFont, 0, 11));
        sliderBlack.setBounds(4, lblBlack.getY() + lblBlack.getHeight(), sliderExposure.getWidth(), 22);
        sliderBlack.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    sliderBlack.setValue(0);
                    lblBlack.setText(Shutter.language.getProperty("lblBlack"));
                }
            }
        });
        sliderBlack.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (sliderBlack.getValue() == 0) {
                    lblBlack.setText(Shutter.language.getProperty("lblBlack"));
                } else {
                    lblBlack.setText(String.valueOf(Shutter.language.getProperty("lblBlack")) + " " + sliderBlack.getValue());
                }
                VideoPlayer.loadImage(false);
            }
        });
        panelColorimetryComponents.add(sliderBlack);
        final JLabel lblHighlights = new JLabel(Shutter.language.getProperty("lblHighlights"));
        lblHighlights.setFont(new Font(Shutter.freeSansFont, 0, 13));
        lblHighlights.setBounds(6, sliderBlack.getY() + sliderBlack.getHeight() + 4, lblExposure.getSize().width, 16);
        panelColorimetryComponents.add(lblHighlights);
        panelColorimetryComponents.add(lblHighlights);
        sliderHighlights.setName("sliderHighlights");
        sliderHighlights.setMaximum(100);
        sliderHighlights.setMinimum(-100);
        sliderHighlights.setValue(0);
        sliderHighlights.setFont(new Font(Shutter.freeSansFont, 0, 11));
        sliderHighlights.setBounds(4, lblHighlights.getY() + lblHighlights.getHeight(), sliderExposure.getWidth(), 22);
        sliderHighlights.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    sliderHighlights.setValue(0);
                    lblHighlights.setText(Shutter.language.getProperty("lblHighlights"));
                }
            }
        });
        sliderHighlights.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (sliderHighlights.getValue() == 0) {
                    lblHighlights.setText(Shutter.language.getProperty("lblHighlights"));
                } else {
                    lblHighlights.setText(String.valueOf(Shutter.language.getProperty("lblHighlights")) + " " + sliderHighlights.getValue());
                }
                VideoPlayer.loadImage(false);
            }
        });
        panelColorimetryComponents.add(sliderHighlights);
        final JLabel lblMediums = new JLabel(Shutter.language.getProperty("lblMediums"));
        lblMediums.setFont(new Font(Shutter.freeSansFont, 0, 13));
        lblMediums.setBounds(6, sliderHighlights.getY() + sliderHighlights.getHeight() + 4, lblExposure.getSize().width, 16);
        panelColorimetryComponents.add(lblMediums);
        panelColorimetryComponents.add(lblMediums);
        sliderMediums.setName("sliderMediums");
        sliderMediums.setMaximum(100);
        sliderMediums.setMinimum(-100);
        sliderMediums.setValue(0);
        sliderMediums.setFont(new Font(Shutter.freeSansFont, 0, 11));
        sliderMediums.setBounds(4, lblMediums.getY() + lblMediums.getHeight(), sliderExposure.getWidth(), 22);
        sliderMediums.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    sliderMediums.setValue(0);
                    lblMediums.setText(Shutter.language.getProperty("lblMediums"));
                }
            }
        });
        sliderMediums.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (sliderMediums.getValue() == 0) {
                    lblMediums.setText(Shutter.language.getProperty("lblMediums"));
                } else {
                    lblMediums.setText(String.valueOf(Shutter.language.getProperty("lblMediums")) + " " + sliderMediums.getValue());
                }
                VideoPlayer.loadImage(false);
            }
        });
        panelColorimetryComponents.add(sliderMediums);
        final JLabel lblShadows = new JLabel(Shutter.language.getProperty("lblShadows"));
        lblShadows.setFont(new Font(Shutter.freeSansFont, 0, 13));
        lblShadows.setBounds(6, sliderMediums.getY() + sliderMediums.getHeight() + 4, lblExposure.getSize().width, 16);
        panelColorimetryComponents.add(lblShadows);
        panelColorimetryComponents.add(lblShadows);
        sliderShadows.setName("sliderShadows");
        sliderShadows.setMaximum(100);
        sliderShadows.setMinimum(-100);
        sliderShadows.setValue(0);
        sliderShadows.setFont(new Font(Shutter.freeSansFont, 0, 11));
        sliderShadows.setBounds(4, lblShadows.getY() + lblShadows.getHeight(), sliderExposure.getWidth(), 22);
        sliderShadows.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    sliderShadows.setValue(0);
                    lblShadows.setText(Shutter.language.getProperty("lblShadows"));
                }
            }
        });
        sliderShadows.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (sliderShadows.getValue() == 0) {
                    lblShadows.setText(Shutter.language.getProperty("lblShadows"));
                } else {
                    lblShadows.setText(String.valueOf(Shutter.language.getProperty("lblShadows")) + " " + sliderShadows.getValue());
                }
                VideoPlayer.loadImage(false);
            }
        });
        panelColorimetryComponents.add(sliderShadows);
        final JLabel lblBalance = new JLabel(Shutter.language.getProperty("lblBalance"));
        lblBalance.setFont(new Font(Shutter.freeSansFont, 0, 13));
        lblBalance.setBounds(6, sliderShadows.getY() + sliderShadows.getHeight() + 4, lblExposure.getSize().width, 16);
        panelColorimetryComponents.add(lblBalance);
        panelColorimetryComponents.add(lblBalance);
        sliderBalance.setName("sliderBalance");
        sliderBalance.setMaximum(12000);
        sliderBalance.setMinimum(1000);
        sliderBalance.setValue(6500);
        sliderBalance.setFont(new Font(Shutter.freeSansFont, 0, 11));
        sliderBalance.setBounds(4, lblBalance.getY() + lblBalance.getHeight(), sliderExposure.getWidth(), 22);
        sliderBalance.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    sliderBalance.setValue(6500);
                    lblBalance.setText(Shutter.language.getProperty("lblBalance"));
                }
            }
        });
        sliderBalance.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (sliderBalance.getValue() == 6500) {
                    lblBalance.setText(Shutter.language.getProperty("lblBalance"));
                } else {
                    lblBalance.setText(String.valueOf(Shutter.language.getProperty("lblBalance")) + " " + sliderBalance.getValue() + "k");
                }
                VideoPlayer.loadImage(false);
            }
        });
        panelColorimetryComponents.add(sliderBalance);
        final JLabel lblHUE = new JLabel(Shutter.language.getProperty("lblHUE"));
        lblHUE.setFont(new Font(Shutter.freeSansFont, 0, 13));
        lblHUE.setBounds(6, sliderBalance.getY() + sliderBalance.getHeight() + 4, lblExposure.getSize().width, 16);
        panelColorimetryComponents.add(lblHUE);
        panelColorimetryComponents.add(lblHUE);
        sliderHUE.setName("sliderHUE");
        sliderHUE.setMaximum(100);
        sliderHUE.setMinimum(-100);
        sliderHUE.setValue(0);
        sliderHUE.setFont(new Font(Shutter.freeSansFont, 0, 11));
        sliderHUE.setBounds(4, lblHUE.getY() + lblHUE.getHeight(), sliderExposure.getWidth(), 22);
        sliderHUE.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    sliderHUE.setValue(0);
                    lblHUE.setText(Shutter.language.getProperty("lblHUE"));
                }
            }
        });
        sliderHUE.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (sliderHUE.getValue() == 0) {
                    lblHUE.setText(Shutter.language.getProperty("lblHUE"));
                } else {
                    lblHUE.setText(String.valueOf(Shutter.language.getProperty("lblHUE")) + " " + sliderHUE.getValue());
                }
                VideoPlayer.loadImage(false);
            }
        });
        panelColorimetryComponents.add(sliderHUE);
        JLabel lblRGB = new JLabel(Shutter.language.getProperty("lblRGB"));
        lblRGB.setFont(new Font(Shutter.freeSansFont, 0, 13));
        lblRGB.setBounds(6, sliderHUE.getY() + sliderHUE.getHeight() + 6, lblRGB.getPreferredSize().width + 4, 16);
        panelColorimetryComponents.add(lblRGB);
        panelColorimetryComponents.add(lblRGB);
        comboRGB.setName("comboRGB");
        comboRGB.setModel(new DefaultComboBoxModel<String>(new String[]{Shutter.language.getProperty("setAll"), Shutter.language.getProperty("setHigh"), Shutter.language.getProperty("setMedium"), Shutter.language.getProperty("setLow")}));
        comboRGB.setMaximumRowCount(10);
        comboRGB.setEditable(false);
        comboRGB.setSelectedIndex(0);
        comboRGB.setFont(new Font(Shutter.freeSansFont, 0, 10));
        comboRGB.setBounds(lblRGB.getX() + lblRGB.getWidth() + 3, lblRGB.getY() - 3, 100, 22);
        panelColorimetryComponents.add(comboRGB);
        comboRGB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setAll"))) {
                    sliderRED.setValue(Colorimetry.allR);
                    sliderGREEN.setValue(Colorimetry.allG);
                    sliderBLUE.setValue(Colorimetry.allB);
                } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setLow"))) {
                    sliderRED.setValue(Colorimetry.lowR);
                    sliderGREEN.setValue(Colorimetry.lowG);
                    sliderBLUE.setValue(Colorimetry.lowB);
                } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setMedium"))) {
                    sliderRED.setValue(Colorimetry.mediumR);
                    sliderGREEN.setValue(Colorimetry.mediumG);
                    sliderBLUE.setValue(Colorimetry.mediumB);
                } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setHigh"))) {
                    sliderRED.setValue(Colorimetry.highR);
                    sliderGREEN.setValue(Colorimetry.highG);
                    sliderBLUE.setValue(Colorimetry.highB);
                }
            }
        });
        final JLabel lblR = new JLabel(Shutter.language.getProperty("lblRED"));
        lblR.setFont(new Font(Shutter.freeSansFont, 0, 13));
        lblR.setBounds(6, comboRGB.getY() + comboRGB.getHeight() + 3, lblExposure.getSize().width, 16);
        panelColorimetryComponents.add(lblR);
        panelColorimetryComponents.add(lblR);
        sliderRED.setName("sliderRED");
        sliderRED.setMaximum(100);
        sliderRED.setMinimum(-100);
        sliderRED.setValue(0);
        sliderRED.setFont(new Font(Shutter.freeSansFont, 0, 11));
        sliderRED.setBounds(4, lblR.getY() + lblR.getHeight(), sliderExposure.getWidth(), 22);
        sliderRED.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    sliderRED.setValue(0);
                    lblR.setText(Shutter.language.getProperty("lblRED"));
                    if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setAll"))) {
                        Colorimetry.allR = sliderRED.getValue();
                    } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setLow"))) {
                        Colorimetry.lowR = sliderRED.getValue();
                    } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setMedium"))) {
                        Colorimetry.mediumR = sliderRED.getValue();
                    } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setHigh"))) {
                        Colorimetry.highR = sliderRED.getValue();
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setAll"))) {
                    Colorimetry.allR = sliderRED.getValue();
                } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setLow"))) {
                    Colorimetry.lowR = sliderRED.getValue();
                } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setMedium"))) {
                    Colorimetry.mediumR = sliderRED.getValue();
                } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setHigh"))) {
                    Colorimetry.highR = sliderRED.getValue();
                }
            }
        });
        sliderRED.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (sliderRED.getValue() == 0) {
                    lblR.setText(Shutter.language.getProperty("lblRED"));
                } else {
                    lblR.setText(String.valueOf(Shutter.language.getProperty("lblRED")) + " " + sliderRED.getValue());
                }
                if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setAll"))) {
                    Colorimetry.allR = sliderRED.getValue();
                } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setLow"))) {
                    Colorimetry.lowR = sliderRED.getValue();
                } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setMedium"))) {
                    Colorimetry.mediumR = sliderRED.getValue();
                } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setHigh"))) {
                    Colorimetry.highR = sliderRED.getValue();
                }
                VideoPlayer.loadImage(false);
            }
        });
        panelColorimetryComponents.add(sliderRED);
        final JLabel lblG = new JLabel(Shutter.language.getProperty("lblGREEN"));
        lblG.setFont(new Font(Shutter.freeSansFont, 0, 13));
        lblG.setBounds(6, sliderRED.getY() + sliderRED.getHeight() + 4, lblExposure.getSize().width, 16);
        panelColorimetryComponents.add(lblG);
        panelColorimetryComponents.add(lblG);
        sliderGREEN.setName("sliderGREEN");
        sliderGREEN.setMaximum(100);
        sliderGREEN.setMinimum(-100);
        sliderGREEN.setValue(0);
        sliderGREEN.setFont(new Font(Shutter.freeSansFont, 0, 11));
        sliderGREEN.setBounds(4, lblG.getY() + lblG.getHeight(), sliderExposure.getWidth(), 22);
        sliderGREEN.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    sliderGREEN.setValue(0);
                    lblG.setText(Shutter.language.getProperty("lblGREEN"));
                    if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setAll"))) {
                        Colorimetry.allG = sliderGREEN.getValue();
                    } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setLow"))) {
                        Colorimetry.lowG = sliderGREEN.getValue();
                    } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setMedium"))) {
                        Colorimetry.mediumG = sliderGREEN.getValue();
                    } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setHigh"))) {
                        Colorimetry.highG = sliderGREEN.getValue();
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setAll"))) {
                    Colorimetry.allG = sliderGREEN.getValue();
                } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setLow"))) {
                    Colorimetry.lowG = sliderGREEN.getValue();
                } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setMedium"))) {
                    Colorimetry.mediumG = sliderGREEN.getValue();
                } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setHigh"))) {
                    Colorimetry.highG = sliderGREEN.getValue();
                }
            }
        });
        sliderGREEN.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (sliderGREEN.getValue() == 0) {
                    lblG.setText(Shutter.language.getProperty("lblGREEN"));
                } else {
                    lblG.setText(String.valueOf(Shutter.language.getProperty("lblGREEN")) + " " + sliderGREEN.getValue());
                }
                if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setAll"))) {
                    Colorimetry.allG = sliderGREEN.getValue();
                } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setLow"))) {
                    Colorimetry.lowG = sliderGREEN.getValue();
                } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setMedium"))) {
                    Colorimetry.mediumG = sliderGREEN.getValue();
                } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setHigh"))) {
                    Colorimetry.highG = sliderGREEN.getValue();
                }
                VideoPlayer.loadImage(false);
            }
        });
        panelColorimetryComponents.add(sliderGREEN);
        final JLabel lblB = new JLabel(Shutter.language.getProperty("lblBLUE"));
        lblB.setFont(new Font(Shutter.freeSansFont, 0, 13));
        lblB.setBounds(6, sliderGREEN.getY() + sliderGREEN.getHeight() + 4, lblExposure.getSize().width, 16);
        panelColorimetryComponents.add(lblB);
        panelColorimetryComponents.add(lblB);
        sliderBLUE.setName("sliderBLUE");
        sliderBLUE.setMaximum(100);
        sliderBLUE.setMinimum(-100);
        sliderBLUE.setValue(0);
        sliderBLUE.setFont(new Font(Shutter.freeSansFont, 0, 11));
        sliderBLUE.setBounds(4, lblB.getY() + lblB.getHeight(), sliderExposure.getWidth(), 22);
        sliderBLUE.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    sliderBLUE.setValue(0);
                    lblB.setText(Shutter.language.getProperty("lblBLUE"));
                    if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setAll"))) {
                        Colorimetry.allB = sliderBLUE.getValue();
                    } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setLow"))) {
                        Colorimetry.lowB = sliderBLUE.getValue();
                    } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setMedium"))) {
                        Colorimetry.mediumB = sliderBLUE.getValue();
                    } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setHigh"))) {
                        Colorimetry.highB = sliderBLUE.getValue();
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setAll"))) {
                    Colorimetry.allB = sliderBLUE.getValue();
                } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setLow"))) {
                    Colorimetry.lowB = sliderBLUE.getValue();
                } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setMedium"))) {
                    Colorimetry.mediumB = sliderBLUE.getValue();
                } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setHigh"))) {
                    Colorimetry.highB = sliderBLUE.getValue();
                }
            }
        });
        sliderBLUE.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (sliderBLUE.getValue() == 0) {
                    lblB.setText(Shutter.language.getProperty("lblBLUE"));
                } else {
                    lblB.setText(String.valueOf(Shutter.language.getProperty("lblBLUE")) + " " + sliderBLUE.getValue());
                }
                if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setAll"))) {
                    Colorimetry.allB = sliderBLUE.getValue();
                } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setLow"))) {
                    Colorimetry.lowB = sliderBLUE.getValue();
                } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setMedium"))) {
                    Colorimetry.mediumB = sliderBLUE.getValue();
                } else if (comboRGB.getSelectedItem().equals(Shutter.language.getProperty("setHigh"))) {
                    Colorimetry.highB = sliderBLUE.getValue();
                }
                VideoPlayer.loadImage(false);
            }
        });
        panelColorimetryComponents.add(sliderBLUE);
        final JLabel lblSaturation = new JLabel(Shutter.language.getProperty("lblSaturation"));
        lblSaturation.setFont(new Font(Shutter.freeSansFont, 0, 13));
        lblSaturation.setBounds(6, sliderBLUE.getY() + sliderBLUE.getHeight() + 4, lblExposure.getSize().width, 16);
        panelColorimetryComponents.add(lblSaturation);
        panelColorimetryComponents.add(lblSaturation);
        sliderSaturation.setName("sliderSaturation");
        sliderSaturation.setMaximum(100);
        sliderSaturation.setMinimum(-100);
        sliderSaturation.setValue(0);
        sliderSaturation.setFont(new Font(Shutter.freeSansFont, 0, 11));
        sliderSaturation.setBounds(4, lblSaturation.getY() + lblSaturation.getHeight(), sliderExposure.getWidth(), 22);
        sliderSaturation.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    sliderSaturation.setValue(0);
                    lblSaturation.setText(Shutter.language.getProperty("lblSaturation"));
                }
            }
        });
        sliderSaturation.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (sliderSaturation.getValue() == 0) {
                    lblSaturation.setText(Shutter.language.getProperty("lblSaturation"));
                } else {
                    lblSaturation.setText(String.valueOf(Shutter.language.getProperty("lblSaturation")) + " " + sliderSaturation.getValue());
                }
                VideoPlayer.loadImage(false);
            }
        });
        panelColorimetryComponents.add(sliderSaturation);
        final JLabel lblVibrance = new JLabel(Shutter.language.getProperty("lblVibrance"));
        lblVibrance.setFont(new Font(Shutter.freeSansFont, 0, 13));
        lblVibrance.setBounds(6, sliderSaturation.getY() + sliderSaturation.getHeight() + 4, lblExposure.getSize().width, 16);
        panelColorimetryComponents.add(lblVibrance);
        panelColorimetryComponents.add(lblVibrance);
        sliderVibrance.setName("sliderVibrance");
        sliderVibrance.setMaximum(100);
        sliderVibrance.setMinimum(-100);
        sliderVibrance.setValue(0);
        sliderVibrance.setFont(new Font(Shutter.freeSansFont, 0, 11));
        sliderVibrance.setBounds(4, lblVibrance.getY() + lblVibrance.getHeight(), sliderExposure.getWidth(), 22);
        panelColorimetryComponents.add(sliderVibrance);
        comboVibrance.setName("comboVibrance");
        comboVibrance.setModel(new DefaultComboBoxModel<String>(new String[]{Shutter.language.getProperty("intensity"), Shutter.language.getProperty("red"), Shutter.language.getProperty("green"), Shutter.language.getProperty("blue")}));
        comboVibrance.setMaximumRowCount(10);
        comboVibrance.setEditable(false);
        comboVibrance.setSelectedIndex(0);
        comboVibrance.setFont(new Font(Shutter.freeSansFont, 0, 10));
        comboVibrance.setBounds(this.scrollBarColorimetry.getX() - this.scrollBarColorimetry.getWidth() - 94, lblVibrance.getY() - 3, 100, 22);
        panelColorimetryComponents.add(comboVibrance);
        comboVibrance.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (comboVibrance.getSelectedItem().equals(Shutter.language.getProperty("intensity"))) {
                    sliderVibrance.setValue(Colorimetry.vibranceValue);
                } else if (comboVibrance.getSelectedItem().equals(Shutter.language.getProperty("red"))) {
                    sliderVibrance.setValue(Colorimetry.vibranceR);
                } else if (comboVibrance.getSelectedItem().equals(Shutter.language.getProperty("green"))) {
                    sliderVibrance.setValue(Colorimetry.vibranceG);
                } else if (comboVibrance.getSelectedItem().equals(Shutter.language.getProperty("blue"))) {
                    sliderVibrance.setValue(Colorimetry.vibranceB);
                }
            }
        });
        sliderVibrance.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    sliderVibrance.setValue(0);
                    lblVibrance.setText(Shutter.language.getProperty("lblVibrance"));
                    if (comboVibrance.getSelectedItem().equals(Shutter.language.getProperty("intensity"))) {
                        Colorimetry.vibranceValue = sliderVibrance.getValue();
                    } else if (comboVibrance.getSelectedItem().equals(Shutter.language.getProperty("red"))) {
                        Colorimetry.vibranceR = sliderVibrance.getValue();
                    } else if (comboVibrance.getSelectedItem().equals(Shutter.language.getProperty("green"))) {
                        Colorimetry.vibranceG = sliderVibrance.getValue();
                    } else if (comboVibrance.getSelectedItem().equals(Shutter.language.getProperty("setHigh"))) {
                        Colorimetry.vibranceB = sliderVibrance.getValue();
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (comboVibrance.getSelectedItem().equals(Shutter.language.getProperty("intensity"))) {
                    Colorimetry.vibranceValue = sliderVibrance.getValue();
                } else if (comboVibrance.getSelectedItem().equals(Shutter.language.getProperty("red"))) {
                    Colorimetry.vibranceR = sliderVibrance.getValue();
                } else if (comboVibrance.getSelectedItem().equals(Shutter.language.getProperty("green"))) {
                    Colorimetry.vibranceG = sliderVibrance.getValue();
                } else if (comboVibrance.getSelectedItem().equals(Shutter.language.getProperty("blue"))) {
                    Colorimetry.vibranceB = sliderVibrance.getValue();
                }
            }
        });
        sliderVibrance.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (sliderVibrance.getValue() == 0) {
                    lblVibrance.setText(Shutter.language.getProperty("lblVibrance"));
                } else {
                    lblVibrance.setText(String.valueOf(Shutter.language.getProperty("lblVibrance")) + " " + sliderVibrance.getValue());
                }
                if (comboVibrance.getSelectedItem().equals(Shutter.language.getProperty("intensity"))) {
                    Colorimetry.vibranceValue = sliderVibrance.getValue();
                } else if (comboVibrance.getSelectedItem().equals(Shutter.language.getProperty("red"))) {
                    Colorimetry.vibranceR = sliderVibrance.getValue();
                } else if (comboVibrance.getSelectedItem().equals(Shutter.language.getProperty("green"))) {
                    Colorimetry.vibranceG = sliderVibrance.getValue();
                } else if (comboVibrance.getSelectedItem().equals(Shutter.language.getProperty("blue"))) {
                    Colorimetry.vibranceB = sliderVibrance.getValue();
                }
                VideoPlayer.loadImage(false);
            }
        });
        final JLabel lblGrain = new JLabel(Shutter.language.getProperty("lblGrain"));
        lblGrain.setFont(new Font(Shutter.freeSansFont, 0, 13));
        lblGrain.setBounds(6, sliderVibrance.getY() + sliderVibrance.getHeight() + 4, lblExposure.getSize().width, 16);
        panelColorimetryComponents.add(lblGrain);
        panelColorimetryComponents.add(lblGrain);
        sliderGrain.setName("sliderGrain");
        sliderGrain.setMaximum(100);
        sliderGrain.setMinimum(-100);
        sliderGrain.setValue(0);
        sliderGrain.setFont(new Font(Shutter.freeSansFont, 0, 11));
        sliderGrain.setBounds(4, lblGrain.getY() + lblGrain.getHeight(), sliderExposure.getWidth(), 22);
        sliderGrain.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    sliderGrain.setValue(0);
                    lblGrain.setText(Shutter.language.getProperty("lblGrain"));
                }
            }
        });
        sliderGrain.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (sliderGrain.getValue() == 0) {
                    lblGrain.setText(Shutter.language.getProperty("lblGrain"));
                } else {
                    lblGrain.setText(String.valueOf(Shutter.language.getProperty("lblGrain")) + " " + sliderGrain.getValue());
                }
                VideoPlayer.loadImage(false);
            }
        });
        panelColorimetryComponents.add(sliderGrain);
        final JLabel lblVignette = new JLabel(Shutter.language.getProperty("lblVignette"));
        lblVignette.setFont(new Font(Shutter.freeSansFont, 0, 13));
        lblVignette.setBounds(6, sliderGrain.getY() + sliderGrain.getHeight() + 4, lblExposure.getSize().width, 16);
        panelColorimetryComponents.add(lblVignette);
        panelColorimetryComponents.add(lblVignette);
        sliderVignette.setName("sliderVignette");
        sliderVignette.setMaximum(100);
        sliderVignette.setMinimum(-100);
        sliderVignette.setValue(0);
        sliderVignette.setFont(new Font(Shutter.freeSansFont, 0, 11));
        sliderVignette.setBounds(4, lblVignette.getY() + lblVignette.getHeight(), sliderExposure.getWidth(), 22);
        sliderVignette.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    sliderVignette.setValue(0);
                    lblVignette.setText(Shutter.language.getProperty("lblVignette"));
                }
            }
        });
        sliderVignette.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (sliderVignette.getValue() == 0) {
                    lblVignette.setText(Shutter.language.getProperty("lblVignette"));
                } else {
                    lblVignette.setText(String.valueOf(Shutter.language.getProperty("lblVignette")) + " " + sliderVignette.getValue());
                }
                VideoPlayer.loadImage(false);
            }
        });
        panelColorimetryComponents.add(sliderVignette);
        final JLabel lblAngle = new JLabel(Shutter.language.getProperty("caseAngle"));
        lblAngle.setFont(new Font(Shutter.freeSansFont, 0, 13));
        lblAngle.setBounds(6, sliderVignette.getY() + sliderVignette.getHeight() + 3, lblExposure.getSize().width, 16);
        panelColorimetryComponents.add(lblAngle);
        sliderAngle.setName("sliderAngle");
        sliderAngle.setMaximum(100);
        sliderAngle.setMinimum(-100);
        sliderAngle.setValue(0);
        sliderAngle.setFont(new Font(Shutter.freeSansFont, 0, 11));
        sliderAngle.setBounds(4, lblAngle.getY() + lblAngle.getHeight(), sliderExposure.getWidth(), 22);
        panelColorimetryComponents.add(sliderAngle);
        sliderAngle.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    sliderAngle.setValue(0);
                    lblAngle.setText(Shutter.language.getProperty("caseAngle"));
                }
            }
        });
        sliderAngle.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (sliderAngle.getValue() == 0) {
                    lblAngle.setText(Shutter.language.getProperty("caseAngle"));
                } else {
                    lblAngle.setText(String.valueOf(Shutter.language.getProperty("caseAngle")) + " " + sliderAngle.getValue());
                }
                VideoPlayer.loadImage(false);
            }
        });
        btnReset = new JButton(Shutter.language.getProperty("btnReset"));
        btnReset.setFont(new Font(Shutter.montserratFont, 0, 12));
        btnReset.setBounds(6, sliderAngle.getY() + sliderAngle.getHeight() + 6, sliderAngle.getWidth(), 21);
        panelColorimetryComponents.add(btnReset);
        btnReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Colorimetry.allR = 0;
                Colorimetry.allG = 0;
                Colorimetry.allB = 0;
                Colorimetry.highR = 0;
                Colorimetry.highG = 0;
                Colorimetry.highB = 0;
                Colorimetry.mediumR = 0;
                Colorimetry.mediumG = 0;
                Colorimetry.mediumB = 0;
                Colorimetry.lowR = 0;
                Colorimetry.lowG = 0;
                Colorimetry.lowB = 0;
                Colorimetry.vibranceValue = 0;
                Colorimetry.vibranceR = 0;
                Colorimetry.vibranceG = 0;
                Colorimetry.vibranceB = 0;
                Colorimetry.balanceAll = "";
                Colorimetry.balanceHigh = "";
                Colorimetry.balanceMedium = "";
                Colorimetry.balanceLow = "";
                sliderExposure.setValue(0);
                sliderGamma.setValue(0);
                sliderContrast.setValue(0);
                sliderHighlights.setValue(0);
                sliderMediums.setValue(0);
                sliderShadows.setValue(0);
                sliderWhite.setValue(0);
                sliderBlack.setValue(0);
                sliderBalance.setValue(6500);
                sliderHUE.setValue(0);
                sliderRED.setValue(0);
                sliderGREEN.setValue(0);
                sliderBLUE.setValue(0);
                sliderVibrance.setValue(0);
                sliderSaturation.setValue(0);
                sliderGrain.setValue(0);
                sliderVignette.setValue(0);
                sliderAngle.setValue(0);
                comboRGB.setSelectedIndex(0);
                comboVibrance.setSelectedIndex(0);
            }
        });
    }

    private void grpCorrections() {
        grpCorrections = new JPanel();
        grpCorrections.setLayout(null);
        grpCorrections.setBorder(BorderFactory.createTitledBorder(new RoundedLineBorder(new Color(65, 65, 65), 1, 5, true), String.valueOf(Shutter.language.getProperty("grpCorrections")) + " ", 0, 0, new Font(Shutter.montserratFont, 0, 12), Color.WHITE));
        grpCorrections.setBackground(new Color(45, 45, 45));
        grpCorrections.setBounds(grpColorimetry.getX(), grpColorimetry.getY() + grpColorimetry.getHeight() + 6, grpColorimetry.getWidth(), 17);
        frame.getContentPane().add(grpCorrections);
        grpCorrections.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int size = 25;
                Component[] componentArray = grpCorrections.getComponents();
                int n = componentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Component c = componentArray[n2];
                    if (c instanceof JCheckBox) {
                        size += 17;
                    }
                    ++n2;
                }
                final int sized = size;
                if (VideoPlayer.grpCorrections.getSize().height < sized) {
                    Thread changeSize = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                int i = 17;
                                do {
                                    long startTime = System.currentTimeMillis() + 1L;
                                    i = Settings.btnDisableAnimations.isSelected() ? sized : ++i;
                                    grpCorrections.setSize(grpCorrections.getWidth(), i);
                                    grpTransitions.setLocation(VideoPlayer.grpColorimetry.getLocation().x, VideoPlayer.grpCorrections.getSize().height + VideoPlayer.grpCorrections.getLocation().y + 6);
                                    int maxHeight = grpIn.getY();
                                    if (!grpIn.isVisible()) {
                                        maxHeight = frame.getHeight();
                                    }
                                    if (grpTransitions.getY() + grpTransitions.getHeight() >= maxHeight - 6) {
                                        grpColorimetry.setSize(grpColorimetry.getWidth(), grpColorimetry.getHeight() - 1);
                                        panelColorimetryComponents.setSize(grpColorimetry.getWidth() - 18, grpColorimetry.getHeight() - 25);
                                        if (!(this).VideoPlayer.this.scrollBarColorimetry.isVisible()) {
                                            (this).VideoPlayer.this.scrollBarColorimetry.setVisible(true);
                                        }
                                        (this).VideoPlayer.this.scrollBarColorimetry.setValue(0);
                                        (this).VideoPlayer.this.scrollBarColorimetry.setSize(11, grpColorimetry.getHeight() - 11);
                                        (this).VideoPlayer.this.scrollBarColorimetry.setMaximum(btnReset.getY() + btnReset.getHeight() + 15 - panelColorimetryComponents.getHeight());
                                        grpCorrections.setLocation(grpCorrections.getX(), grpCorrections.getY() - 1);
                                    }
                                    Shutter.animateSections(startTime);
                                } while (i < sized);
                                if (Settings.btnDisableAnimations.isSelected()) {
                                    VideoPlayer.this.resizeAll();
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                    changeSize.start();
                } else {
                    Thread changeSize = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                int i = sized;
                                do {
                                    long startTime = System.currentTimeMillis() + 1L;
                                    i = Settings.btnDisableAnimations.isSelected() ? 17 : --i;
                                    grpCorrections.setSize(grpCorrections.getWidth(), i);
                                    grpTransitions.setLocation(VideoPlayer.grpColorimetry.getLocation().x, VideoPlayer.grpCorrections.getSize().height + VideoPlayer.grpCorrections.getLocation().y + 6);
                                    Shutter.animateSections(startTime);
                                } while (i > 17);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                    changeSize.start();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        caseStabilisation.setName("caseStabilisation");
        caseStabilisation.setFont(new Font(Shutter.freeSansFont, 0, 12));
        caseStabilisation.setSize(VideoPlayer.caseStabilisation.getPreferredSize().width, 23);
        caseStabilisation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (grpCorrections.getHeight() <= 17) {
                    caseStabilisation.setSelected(false);
                }
                if (caseStabilisation.isSelected() && !Shutter.inputDeviceIsRunning && FFPROBE.totalLength > 40) {
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            frame.setCursor(Cursor.getPredefinedCursor(3));
                            frame.setVisible(false);
                            File file = new File(videoPath);
                            try {
                                InputAndOutput.getInputAndOutput();
                                stabilisation = Corrections.setStabilisation("", file, file.getName(), "");
                                do {
                                    Thread.sleep(100L);
                                } while (FFMPEG.isRunning);
                                Shutter.enableAll();
                                Shutter.progressBar1.setValue(0);
                                Shutter.lblCurrentEncoding.setText(Shutter.language.getProperty("lblEncodageEnCours"));
                                frame.setCursor(Cursor.getPredefinedCursor(0));
                                frame.setVisible(true);
                                if (FFMPEG.cancelled) {
                                    stabilisation = "";
                                } else {
                                    btnPlay.setText(Shutter.language.getProperty("btnPause"));
                                    float timeIn = (float)(Integer.parseInt(caseInH.getText()) * 3600 + Integer.parseInt(caseInM.getText()) * 60 + Integer.parseInt(caseInS.getText())) * FFPROBE.currentFPS + (float)Integer.parseInt(caseInF.getText());
                                    timeIn = Timecode.getNonDropFrameTC(timeIn);
                                    VideoPlayer.playerSetTime(timeIn);
                                    do {
                                        Thread.sleep(100L);
                                    } while (!VideoPlayer.playerIsPlaying());
                                    do {
                                        Thread.sleep(100L);
                                    } while (VideoPlayer.playerIsPlaying());
                                    stabilisation = "";
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    });
                    t.start();
                } else {
                    stabilisation = "";
                    VideoPlayer.loadImage(false);
                }
            }
        });
        caseDeflicker.setName("caseDeflicker");
        caseDeflicker.setFont(new Font(Shutter.freeSansFont, 0, 12));
        caseDeflicker.setSize(VideoPlayer.caseDeflicker.getPreferredSize().width, 23);
        caseDeflicker.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                VideoPlayer.loadImage(false);
            }
        });
        caseBanding.setName("caseBanding");
        caseBanding.setFont(new Font(Shutter.freeSansFont, 0, 12));
        caseBanding.setSize(VideoPlayer.caseBanding.getPreferredSize().width + 10, 23);
        caseBanding.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                VideoPlayer.loadImage(false);
            }
        });
        caseLimiter.setName("caseLimiter");
        caseLimiter.setFont(new Font(Shutter.freeSansFont, 0, 12));
        caseLimiter.setSize(VideoPlayer.caseLimiter.getPreferredSize().width, 23);
        caseLimiter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                VideoPlayer.loadImage(false);
            }
        });
        caseDetails.setName("caseDetails");
        caseDetails.setToolTipText(Shutter.language.getProperty("tooltipDetails"));
        caseDetails.setFont(new Font(Shutter.freeSansFont, 0, 12));
        caseDetails.setSize(VideoPlayer.caseDetails.getPreferredSize().width + 14, 23);
        caseDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!caseDetails.isSelected()) {
                    sliderDetails.setValue(0);
                    VideoPlayer.loadImage(false);
                }
            }
        });
        sliderDetails = new JSlider();
        sliderDetails.setName("sliderDetails");
        sliderDetails.setMinorTickSpacing(1);
        sliderDetails.setMaximum(10);
        sliderDetails.setMinimum(-10);
        sliderDetails.setValue(0);
        sliderDetails.setSize(120, 22);
        sliderDetails.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                float value = (float)sliderDetails.getValue() / 10.0f;
                if (value != 0.0f) {
                    caseDetails.setSelected(true);
                } else {
                    caseDetails.setSelected(false);
                }
                caseDetails.setText(String.valueOf(Shutter.language.getProperty("details")) + " " + value);
                VideoPlayer.loadImage(false);
            }
        });
        sliderDetails.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent arg0) {
                caseDetails.setSelected(true);
                sliderDetails.setEnabled(true);
            }
        });
        caseDenoise.setName("caseDenoise");
        caseDenoise.setFont(new Font(Shutter.freeSansFont, 0, 12));
        caseDenoise.setSize(VideoPlayer.caseDenoise.getPreferredSize().width + 14, 23);
        caseDenoise.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!caseDenoise.isSelected()) {
                    sliderDenoise.setValue(0);
                    VideoPlayer.loadImage(false);
                }
            }
        });
        sliderDenoise = new JSlider();
        sliderDenoise.setName("sliderDenoise");
        sliderDenoise.setMinorTickSpacing(1);
        sliderDenoise.setMaximum(10);
        sliderDenoise.setMinimum(0);
        sliderDenoise.setValue(0);
        sliderDenoise.setSize(sliderDetails.getWidth(), 22);
        sliderDenoise.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                int value = sliderDenoise.getValue();
                if (value != 0) {
                    caseDenoise.setSelected(true);
                } else {
                    caseDenoise.setSelected(false);
                }
                caseDenoise.setText(String.valueOf(Shutter.language.getProperty("noiseSuppression")) + " " + value);
                VideoPlayer.loadImage(false);
            }
        });
        sliderDenoise.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent arg0) {
                caseDenoise.setSelected(true);
                sliderDenoise.setEnabled(true);
            }
        });
        caseSmoothExposure.setName("caseSmoothExposure");
        caseSmoothExposure.setFont(new Font(Shutter.freeSansFont, 0, 12));
        caseSmoothExposure.setSize(VideoPlayer.caseSmoothExposure.getPreferredSize().width + 20, 23);
        caseSmoothExposure.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (!caseSmoothExposure.isSelected()) {
                    sliderSmoothExposure.setValue(0);
                    VideoPlayer.loadImage(false);
                }
            }
        });
        sliderSmoothExposure = new JSlider();
        sliderSmoothExposure.setName("sliderSmoothExposure");
        sliderSmoothExposure.setMinorTickSpacing(1);
        sliderSmoothExposure.setMaximum(100);
        sliderSmoothExposure.setMinimum(0);
        sliderSmoothExposure.setValue(0);
        sliderSmoothExposure.setSize(sliderDetails.getWidth(), 22);
        sliderSmoothExposure.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                int value = sliderSmoothExposure.getValue();
                if (value != 0) {
                    caseSmoothExposure.setSelected(true);
                } else {
                    caseSmoothExposure.setSelected(false);
                }
                caseSmoothExposure.setText(String.valueOf(Shutter.language.getProperty("smoothExposure")) + " " + value);
                VideoPlayer.loadImage(false);
            }
        });
        sliderSmoothExposure.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent arg0) {
                caseSmoothExposure.setSelected(true);
                sliderSmoothExposure.setEnabled(true);
            }
        });
        caseStabilisation.setLocation(7, 14);
        grpCorrections.add(caseStabilisation);
        caseDeflicker.setLocation(7, VideoPlayer.caseStabilisation.getLocation().y + 17);
        grpCorrections.add(caseDeflicker);
        caseBanding.setLocation(7, VideoPlayer.caseDeflicker.getLocation().y + 17);
        grpCorrections.add(caseBanding);
        caseLimiter.setLocation(7, VideoPlayer.caseBanding.getLocation().y + 17);
        grpCorrections.add(caseLimiter);
        caseDetails.setLocation(7, VideoPlayer.caseLimiter.getLocation().y + 17);
        grpCorrections.add(caseDetails);
        sliderDetails.setLocation(grpCorrections.getWidth() - sliderDetails.getWidth() - 14, VideoPlayer.caseDetails.getLocation().y);
        grpCorrections.add(sliderDetails);
        caseDenoise.setLocation(7, VideoPlayer.caseDetails.getLocation().y + 17);
        grpCorrections.add(caseDenoise);
        sliderDenoise.setLocation(sliderDetails.getX(), VideoPlayer.caseDenoise.getLocation().y);
        grpCorrections.add(sliderDenoise);
        caseSmoothExposure.setLocation(7, VideoPlayer.caseDenoise.getLocation().y + 17);
        grpCorrections.add(caseSmoothExposure);
        sliderSmoothExposure.setLocation(sliderDetails.getX(), VideoPlayer.caseSmoothExposure.getLocation().y);
        grpCorrections.add(sliderSmoothExposure);
    }

    private void grpTransitions() {
        grpTransitions = new JPanel();
        grpTransitions.setLayout(null);
        grpTransitions.setVisible(true);
        grpTransitions.setBorder(BorderFactory.createTitledBorder(new RoundedLineBorder(new Color(65, 65, 65), 1, 5, true), String.valueOf(Shutter.language.getProperty("grpTransitions")) + " ", 0, 0, new Font(Shutter.montserratFont, 0, 12), Color.WHITE));
        grpTransitions.setBackground(new Color(45, 45, 45));
        grpTransitions.setBounds(grpCorrections.getX(), grpCorrections.getY() + grpCorrections.getHeight() + 6, grpCorrections.getWidth(), 17);
        frame.getContentPane().add(grpTransitions);
        grpTransitions.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int size = 104;
                final int sized = size;
                if (VideoPlayer.grpTransitions.getSize().height < sized) {
                    Thread changeSize = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                int i = 17;
                                do {
                                    long startTime = System.currentTimeMillis() + 1L;
                                    i = Settings.btnDisableAnimations.isSelected() ? sized : ++i;
                                    grpTransitions.setSize(grpTransitions.getWidth(), i);
                                    int maxHeight = grpIn.getY();
                                    if (!grpIn.isVisible()) {
                                        maxHeight = frame.getHeight();
                                    }
                                    if (grpTransitions.getY() + grpTransitions.getHeight() >= maxHeight - 6 && grpTransitions.getHeight() > 17) {
                                        grpColorimetry.setSize(grpColorimetry.getWidth(), grpColorimetry.getHeight() - 1);
                                        grpCorrections.setLocation(VideoPlayer.grpColorimetry.getLocation().x, VideoPlayer.grpColorimetry.getSize().height + VideoPlayer.grpColorimetry.getLocation().y + 6);
                                        panelColorimetryComponents.setSize(grpColorimetry.getWidth() - 18, grpColorimetry.getHeight() - 25);
                                        if (!(this).VideoPlayer.this.scrollBarColorimetry.isVisible()) {
                                            (this).VideoPlayer.this.scrollBarColorimetry.setVisible(true);
                                        }
                                        (this).VideoPlayer.this.scrollBarColorimetry.setValue(0);
                                        (this).VideoPlayer.this.scrollBarColorimetry.setSize(11, grpColorimetry.getHeight() - 11);
                                        (this).VideoPlayer.this.scrollBarColorimetry.setMaximum(btnReset.getY() + btnReset.getHeight() + 15 - panelColorimetryComponents.getHeight());
                                        grpTransitions.setLocation(grpTransitions.getX(), grpTransitions.getY() - 1);
                                    }
                                    Shutter.animateSections(startTime);
                                } while (i < sized);
                                if (Settings.btnDisableAnimations.isSelected()) {
                                    VideoPlayer.this.resizeAll();
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                    changeSize.start();
                } else {
                    Thread changeSize = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                int i = sized;
                                do {
                                    long startTime = System.currentTimeMillis() + 1L;
                                    i = Settings.btnDisableAnimations.isSelected() ? 17 : --i;
                                    grpTransitions.setSize(grpTransitions.getWidth(), i);
                                    Shutter.animateSections(startTime);
                                } while (i > 17);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                    changeSize.start();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        caseVideoFadeIn = new JCheckBox(Shutter.language.getProperty("lblVideoFadeIn"));
        caseVideoFadeIn.setName("caseVideoFadeIn");
        caseVideoFadeIn.setFont(new Font(Shutter.freeSansFont, 0, 12));
        caseVideoFadeIn.setBounds(7, 16, VideoPlayer.caseVideoFadeIn.getPreferredSize().width, 23);
        grpTransitions.add(caseVideoFadeIn);
        caseVideoFadeIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (caseVideoFadeIn.isSelected()) {
                    spinnerVideoFadeIn.setEnabled(true);
                    float timeIn = (float)(Integer.parseInt(caseInH.getText()) * 3600 + Integer.parseInt(caseInM.getText()) * 60 + Integer.parseInt(caseInS.getText())) * FFPROBE.currentFPS + (float)Integer.parseInt(caseInF.getText());
                    playTransition = true;
                    VideoPlayer.playerSetTime(timeIn);
                    btnPlay.setText(Shutter.language.getProperty("btnPause"));
                    playerLoop = true;
                } else {
                    spinnerVideoFadeIn.setEnabled(false);
                }
                Utils.textFieldBackground();
            }
        });
        spinnerVideoFadeIn.setHorizontalAlignment(0);
        spinnerVideoFadeIn.setName("spinnerVideoFadeIn");
        spinnerVideoFadeIn.setEnabled(false);
        spinnerVideoFadeIn.setFont(new Font(Shutter.freeSansFont, 0, 11));
        if (Shutter.getLanguage.equals(Locale.of("en").getDisplayLanguage())) {
            spinnerVideoFadeIn.setBounds(VideoPlayer.caseVideoFadeIn.getLocation().x + caseVideoFadeIn.getWidth() + 12, VideoPlayer.caseVideoFadeIn.getLocation().y + 3, 41, 16);
        } else {
            spinnerVideoFadeIn.setBounds(VideoPlayer.caseVideoFadeIn.getLocation().x + caseVideoFadeIn.getWidth() + 6, VideoPlayer.caseVideoFadeIn.getLocation().y + 3, 41, 16);
        }
        grpTransitions.add(spinnerVideoFadeIn);
        spinnerVideoFadeIn.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        JLabel videoInFrames = new JLabel(Shutter.language.getProperty("lblFrames"));
        videoInFrames.setFont(new Font(Shutter.freeSansFont, 0, 12));
        videoInFrames.setBounds(VideoPlayer.spinnerVideoFadeIn.getLocation().x + spinnerVideoFadeIn.getWidth() + 4, spinnerVideoFadeIn.getY(), videoInFrames.getPreferredSize().width + 4, 16);
        grpTransitions.add(videoInFrames);
        lblFadeInColor = new JLabel(Shutter.language.getProperty("black"));
        lblFadeInColor.setName("lblFadeInColor");
        lblFadeInColor.setBackground(new Color(60, 60, 60));
        lblFadeInColor.setHorizontalAlignment(0);
        lblFadeInColor.setOpaque(true);
        lblFadeInColor.setFont(new Font(Shutter.montserratFont, 0, 12));
        lblFadeInColor.setSize(55, 16);
        lblFadeInColor.setLocation(videoInFrames.getLocation().x + videoInFrames.getWidth() + 3, spinnerVideoFadeIn.getY() + 1);
        grpTransitions.add(lblFadeInColor);
        lblFadeInColor.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (lblFadeInColor.getText().equals(Shutter.language.getProperty("black"))) {
                    lblFadeInColor.setText(Shutter.language.getProperty("white"));
                } else {
                    lblFadeInColor.setText(Shutter.language.getProperty("black"));
                }
                if (caseVideoFadeIn.isSelected()) {
                    float timeIn = (float)(Integer.parseInt(caseInH.getText()) * 3600 + Integer.parseInt(caseInM.getText()) * 60 + Integer.parseInt(caseInS.getText())) * FFPROBE.currentFPS + (float)Integer.parseInt(caseInF.getText());
                    playTransition = true;
                    VideoPlayer.playerSetTime(timeIn);
                    btnPlay.setText(Shutter.language.getProperty("btnPause"));
                    playerLoop = true;
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                frame.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                frame.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        caseAudioFadeIn = new JCheckBox(Shutter.language.getProperty("lblAudioFadeIn"));
        caseAudioFadeIn.setName("caseAudioFadeIn");
        caseAudioFadeIn.setFont(new Font(Shutter.freeSansFont, 0, 12));
        caseAudioFadeIn.setBounds(7, caseVideoFadeIn.getY() + 17, VideoPlayer.caseAudioFadeIn.getPreferredSize().width, 23);
        grpTransitions.add(caseAudioFadeIn);
        caseAudioFadeIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (caseAudioFadeIn.isSelected()) {
                    spinnerAudioFadeIn.setEnabled(true);
                    float timeIn = (float)(Integer.parseInt(caseInH.getText()) * 3600 + Integer.parseInt(caseInM.getText()) * 60 + Integer.parseInt(caseInS.getText())) * FFPROBE.currentFPS + (float)Integer.parseInt(caseInF.getText());
                    playTransition = true;
                    VideoPlayer.playerSetTime(timeIn);
                    btnPlay.setText(Shutter.language.getProperty("btnPause"));
                    playerLoop = true;
                } else {
                    spinnerAudioFadeIn.setEnabled(false);
                }
                Utils.textFieldBackground();
            }
        });
        spinnerAudioFadeIn.setHorizontalAlignment(0);
        spinnerAudioFadeIn.setName("spinnerAudioFadeIn");
        spinnerAudioFadeIn.setEnabled(false);
        spinnerAudioFadeIn.setFont(new Font(Shutter.freeSansFont, 0, 11));
        spinnerAudioFadeIn.setBounds(spinnerVideoFadeIn.getX(), VideoPlayer.caseAudioFadeIn.getLocation().y + 3, spinnerVideoFadeIn.getWidth(), 16);
        grpTransitions.add(spinnerAudioFadeIn);
        spinnerAudioFadeIn.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        JLabel audioInFrames = new JLabel(videoInFrames.getText());
        audioInFrames.setFont(new Font(Shutter.freeSansFont, 0, 12));
        audioInFrames.setBounds(VideoPlayer.spinnerAudioFadeIn.getLocation().x + spinnerAudioFadeIn.getWidth() + 4, spinnerAudioFadeIn.getY(), videoInFrames.getWidth(), 16);
        grpTransitions.add(audioInFrames);
        caseVideoFadeOut = new JCheckBox(Shutter.language.getProperty("lblVideoFadeOut"));
        caseVideoFadeOut.setName("caseVideoFadeOut");
        caseVideoFadeOut.setFont(new Font(Shutter.freeSansFont, 0, 12));
        caseVideoFadeOut.setBounds(7, caseAudioFadeIn.getY() + caseAudioFadeIn.getHeight(), VideoPlayer.caseVideoFadeOut.getPreferredSize().width, 23);
        grpTransitions.add(caseVideoFadeOut);
        caseVideoFadeOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (Shutter.inputDeviceIsRunning) {
                    JOptionPane.showMessageDialog(frame, Shutter.language.getProperty("incompatibleInputDevice"), Shutter.language.getProperty("menuItemScreenRecord"), 0);
                    caseVideoFadeOut.setSelected(false);
                }
                if (caseVideoFadeOut.isSelected()) {
                    spinnerVideoFadeOut.setEnabled(true);
                    float timeOut = (float)(Integer.parseInt(caseOutH.getText()) * 3600 + Integer.parseInt(caseOutM.getText()) * 60 + Integer.parseInt(caseOutS.getText())) * FFPROBE.currentFPS + (float)Integer.parseInt(caseOutF.getText());
                    int spinnerValue = Integer.parseInt(spinnerVideoFadeOut.getText());
                    if (Integer.parseInt(spinnerAudioFadeOut.getText()) > spinnerValue) {
                        spinnerValue = Integer.parseInt(spinnerAudioFadeOut.getText());
                    }
                    playerCurrentFrame = timeOut - (float)(spinnerValue * 2);
                    VideoPlayer.playerSetTime(playerCurrentFrame);
                    long time = System.currentTimeMillis();
                    if (!VideoPlayer.playerIsPlaying()) {
                        do {
                            try {
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        } while (System.currentTimeMillis() - time <= 1000L && setTime.isAlive());
                    }
                    btnPlay.setText(Shutter.language.getProperty("btnPause"));
                    playerLoop = true;
                } else {
                    spinnerVideoFadeOut.setEnabled(false);
                }
                Utils.textFieldBackground();
            }
        });
        spinnerVideoFadeOut.setHorizontalAlignment(0);
        spinnerVideoFadeOut.setName("spinnerVideoFadeOut");
        spinnerVideoFadeOut.setEnabled(false);
        spinnerVideoFadeOut.setFont(new Font(Shutter.freeSansFont, 0, 11));
        spinnerVideoFadeOut.setBounds(spinnerVideoFadeIn.getX(), VideoPlayer.caseVideoFadeOut.getLocation().y + 3, spinnerVideoFadeIn.getWidth(), 16);
        grpTransitions.add(spinnerVideoFadeOut);
        spinnerVideoFadeOut.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        JLabel videoOutFrames = new JLabel(videoInFrames.getText());
        videoOutFrames.setFont(new Font(Shutter.freeSansFont, 0, 12));
        videoOutFrames.setBounds(VideoPlayer.spinnerVideoFadeOut.getLocation().x + spinnerVideoFadeOut.getWidth() + 4, spinnerVideoFadeOut.getY(), videoInFrames.getWidth(), 16);
        grpTransitions.add(videoOutFrames);
        lblFadeOutColor = new JLabel(Shutter.language.getProperty("black"));
        lblFadeOutColor.setName("lblFadeOutColor");
        lblFadeOutColor.setBackground(new Color(60, 60, 60));
        lblFadeOutColor.setHorizontalAlignment(0);
        lblFadeOutColor.setOpaque(true);
        lblFadeOutColor.setFont(new Font(Shutter.montserratFont, 0, 12));
        lblFadeOutColor.setSize(55, 16);
        lblFadeOutColor.setLocation(lblFadeInColor.getX(), spinnerVideoFadeOut.getY() + 1);
        grpTransitions.add(lblFadeOutColor);
        lblFadeOutColor.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (lblFadeOutColor.getText().equals(Shutter.language.getProperty("black"))) {
                    lblFadeOutColor.setText(Shutter.language.getProperty("white"));
                } else {
                    lblFadeOutColor.setText(Shutter.language.getProperty("black"));
                }
                if (caseVideoFadeOut.isSelected()) {
                    float timeOut = (float)(Integer.parseInt(caseOutH.getText()) * 3600 + Integer.parseInt(caseOutM.getText()) * 60 + Integer.parseInt(caseOutS.getText())) * FFPROBE.currentFPS + (float)Integer.parseInt(caseOutF.getText());
                    int spinnerValue = Integer.parseInt(spinnerVideoFadeOut.getText());
                    if (Integer.parseInt(spinnerAudioFadeOut.getText()) > spinnerValue) {
                        spinnerValue = Integer.parseInt(spinnerAudioFadeOut.getText());
                    }
                    playerCurrentFrame = timeOut - (float)(spinnerValue * 2);
                    VideoPlayer.playerSetTime(playerCurrentFrame);
                    long time = System.currentTimeMillis();
                    if (!VideoPlayer.playerIsPlaying()) {
                        do {
                            try {
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        } while (System.currentTimeMillis() - time <= 1000L && setTime.isAlive());
                    }
                    btnPlay.setText(Shutter.language.getProperty("btnPause"));
                    playerLoop = true;
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                frame.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                frame.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        caseAudioFadeOut = new JCheckBox(Shutter.language.getProperty("lblAudioFadeOut"));
        caseAudioFadeOut.setName("caseAudioFadeOut");
        caseAudioFadeOut.setFont(new Font(Shutter.freeSansFont, 0, 12));
        caseAudioFadeOut.setBounds(7, caseVideoFadeOut.getY() + 17, VideoPlayer.caseAudioFadeOut.getPreferredSize().width, 23);
        grpTransitions.add(caseAudioFadeOut);
        caseAudioFadeOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (Shutter.inputDeviceIsRunning) {
                    JOptionPane.showMessageDialog(frame, Shutter.language.getProperty("incompatibleInputDevice"), Shutter.language.getProperty("menuItemScreenRecord"), 0);
                    caseAudioFadeOut.setSelected(false);
                }
                if (caseAudioFadeOut.isSelected()) {
                    spinnerAudioFadeOut.setEnabled(true);
                    float timeOut = (float)(Integer.parseInt(caseOutH.getText()) * 3600 + Integer.parseInt(caseOutM.getText()) * 60 + Integer.parseInt(caseOutS.getText())) * FFPROBE.currentFPS + (float)Integer.parseInt(caseOutF.getText());
                    int spinnerValue = Integer.parseInt(spinnerVideoFadeOut.getText());
                    if (Integer.parseInt(spinnerAudioFadeOut.getText()) > spinnerValue) {
                        spinnerValue = Integer.parseInt(spinnerAudioFadeOut.getText());
                    }
                    playerCurrentFrame = timeOut - (float)(spinnerValue * 2);
                    VideoPlayer.playerSetTime(playerCurrentFrame);
                    long time = System.currentTimeMillis();
                    if (!VideoPlayer.playerIsPlaying()) {
                        do {
                            try {
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        } while (System.currentTimeMillis() - time <= 1000L && setTime.isAlive());
                    }
                    btnPlay.setText(Shutter.language.getProperty("btnPause"));
                    playerLoop = true;
                } else {
                    spinnerAudioFadeOut.setEnabled(false);
                }
                Utils.textFieldBackground();
            }
        });
        spinnerAudioFadeOut.setHorizontalAlignment(0);
        spinnerAudioFadeOut.setName("spinnerAudioFadeOut");
        spinnerAudioFadeOut.setEnabled(false);
        spinnerAudioFadeOut.setFont(new Font(Shutter.freeSansFont, 0, 11));
        spinnerAudioFadeOut.setBounds(spinnerVideoFadeIn.getX(), VideoPlayer.caseAudioFadeOut.getLocation().y + 3, spinnerVideoFadeIn.getWidth(), 16);
        grpTransitions.add(spinnerAudioFadeOut);
        spinnerAudioFadeOut.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        JLabel audioOutFrames = new JLabel(videoInFrames.getText());
        audioOutFrames.setFont(new Font(Shutter.freeSansFont, 0, 12));
        audioOutFrames.setBounds(VideoPlayer.spinnerAudioFadeOut.getLocation().x + spinnerAudioFadeOut.getWidth() + 4, spinnerAudioFadeOut.getY(), videoInFrames.getWidth(), 16);
        grpTransitions.add(audioOutFrames);
    }

    private void grpCrop() {
        grpCrop = new JPanel();
        grpCrop.setLayout(null);
        grpCrop.setBorder(BorderFactory.createTitledBorder(new RoundedLineBorder(new Color(65, 65, 65), 1, 5, true), String.valueOf(Shutter.language.getProperty("frameCropImage")) + " ", 0, 0, new Font(Shutter.montserratFont, 0, 12), Color.WHITE));
        grpCrop.setBackground(new Color(45, 45, 45));
        grpCrop.setSize(grpColorimetry.getWidth(), 17);
        grpCrop.setLocation(frame.getWidth() - grpCrop.getWidth() - 6, grpColorimetry.getY());
        frame.getContentPane().add(grpCrop);
        grpCrop.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int sized = 90;
                if (VideoPlayer.grpCrop.getSize().height < 90) {
                    Thread changeSize = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                long startTime;
                                int i = 17;
                                do {
                                    startTime = System.currentTimeMillis() + 1L;
                                    i = Settings.btnDisableAnimations.isSelected() ? 90 : ++i;
                                    grpCrop.setSize(grpCrop.getWidth(), i);
                                    grpOverlay.setLocation(VideoPlayer.grpCrop.getLocation().x, VideoPlayer.grpCrop.getSize().height + VideoPlayer.grpCrop.getLocation().y + 6);
                                    grpSubtitles.setLocation(VideoPlayer.grpOverlay.getLocation().x, VideoPlayer.grpOverlay.getSize().height + VideoPlayer.grpOverlay.getLocation().y + 6);
                                    grpWatermark.setLocation(VideoPlayer.grpSubtitles.getLocation().x, VideoPlayer.grpSubtitles.getSize().height + VideoPlayer.grpSubtitles.getLocation().y + 6);
                                    if (grpWatermark.getY() + grpWatermark.getHeight() >= grpOut.getY() - 6) {
                                        grpOverlay.setSize(grpOverlay.getWidth(), grpOverlay.getHeight() - 1);
                                        grpSubtitles.setLocation(VideoPlayer.grpOverlay.getLocation().x, VideoPlayer.grpOverlay.getSize().height + VideoPlayer.grpOverlay.getLocation().y + 6);
                                        grpWatermark.setLocation(VideoPlayer.grpSubtitles.getLocation().x, VideoPlayer.grpSubtitles.getSize().height + VideoPlayer.grpSubtitles.getLocation().y + 6);
                                    }
                                    Shutter.animateSections(startTime);
                                } while (i < 90);
                                if (grpOverlay.getHeight() > 17 && grpOverlay.getHeight() < 278) {
                                    i = grpOverlay.getHeight();
                                    do {
                                        startTime = System.currentTimeMillis() + 1L;
                                        i = Settings.btnDisableAnimations.isSelected() ? 17 : --i;
                                        grpOverlay.setSize(grpOverlay.getWidth(), i);
                                        grpSubtitles.setLocation(VideoPlayer.grpOverlay.getLocation().x, VideoPlayer.grpOverlay.getSize().height + VideoPlayer.grpOverlay.getLocation().y + 6);
                                        grpWatermark.setLocation(VideoPlayer.grpSubtitles.getLocation().x, VideoPlayer.grpSubtitles.getSize().height + VideoPlayer.grpSubtitles.getLocation().y + 6);
                                        Shutter.animateSections(startTime);
                                    } while (i > 17);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                    changeSize.start();
                } else {
                    Thread changeSize = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                int i = 90;
                                do {
                                    long startTime = System.currentTimeMillis() + 1L;
                                    i = Settings.btnDisableAnimations.isSelected() ? 17 : --i;
                                    grpCrop.setSize(grpCrop.getWidth(), i);
                                    grpOverlay.setLocation(VideoPlayer.grpCrop.getLocation().x, VideoPlayer.grpCrop.getSize().height + VideoPlayer.grpCrop.getLocation().y + 6);
                                    grpSubtitles.setLocation(VideoPlayer.grpOverlay.getLocation().x, VideoPlayer.grpOverlay.getSize().height + VideoPlayer.grpOverlay.getLocation().y + 6);
                                    grpWatermark.setLocation(VideoPlayer.grpSubtitles.getLocation().x, VideoPlayer.grpSubtitles.getSize().height + VideoPlayer.grpSubtitles.getLocation().y + 6);
                                    Shutter.animateSections(startTime);
                                } while (i > 17);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                    changeSize.start();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        caseEnableCrop.setName("caseEnableCrop");
        caseEnableCrop.setBounds(8, 16, 90, 23);
        caseEnableCrop.setFont(new Font(Shutter.freeSansFont, 0, 12));
        caseEnableCrop.setSelected(false);
        grpCrop.add(caseEnableCrop);
        caseEnableCrop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (caseEnableCrop.isSelected()) {
                    float squareRatio = (float)FFPROBE.imageWidth / (float)FFPROBE.imageHeight;
                    if (!Shutter.inputDeviceIsRunning && FFPROBE.imageRatio != squareRatio) {
                        ratioChanged = true;
                        FFPROBE.imageRatio = squareRatio;
                        VideoPlayer.this.resizeAll();
                        frameIsComplete = false;
                        VideoPlayer.playerSetTime(playerCurrentFrame);
                    }
                    selection.setBounds(player.getWidth() / 4, player.getHeight() / 4, player.getWidth() / 2, player.getHeight() / 2);
                    anchorRight = VideoPlayer.selection.getLocation().x + selection.getWidth();
                    anchorBottom = VideoPlayer.selection.getLocation().y + selection.getHeight();
                    Component[] componentArray = grpCrop.getComponents();
                    int n = componentArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Component c = componentArray[n2];
                        c.setEnabled(true);
                        ++n2;
                    }
                    frameCropX = VideoPlayer.player.getLocation().x;
                    frameCropY = VideoPlayer.player.getLocation().y;
                    anchorRight = VideoPlayer.selection.getLocation().x + selection.getWidth();
                    anchorBottom = VideoPlayer.selection.getLocation().y + selection.getHeight();
                    VideoPlayer.checkSelection();
                    player.add(selection);
                    player.add(overImage);
                } else {
                    if (!Shutter.inputDeviceIsRunning && ratioChanged) {
                        FFPROBE.Data(videoPath);
                        do {
                            try {
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException squareRatio) {
                                // empty catch block
                            }
                        } while (FFPROBE.isRunning);
                        VideoPlayer.this.resizeAll();
                        frameIsComplete = false;
                        VideoPlayer.playerSetTime(playerCurrentFrame);
                    }
                    ratioChanged = false;
                    Component[] componentArray = grpCrop.getComponents();
                    int n = componentArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        Component c = componentArray[n3];
                        if (!(c instanceof JCheckBox)) {
                            c.setEnabled(false);
                        }
                        ++n3;
                    }
                    player.remove(selection);
                    player.remove(overImage);
                    comboPreset.setSelectedIndex(0);
                }
                if (frameVideo != null) {
                    player.repaint();
                }
            }
        });
        JLabel lblPresets = new JLabel(Shutter.language.getProperty("lblPresets"));
        lblPresets.setFont(new Font(Shutter.freeSansFont, 0, 12));
        lblPresets.setEnabled(false);
        lblPresets.setBounds(caseEnableCrop.getX() + caseEnableCrop.getWidth() + 7, caseEnableCrop.getY() + 3, lblPresets.getPreferredSize().width, 16);
        grpCrop.add(lblPresets);
        String[] presetsList = new String[]{Shutter.language.getProperty("aucun"), "auto", "2.75", "2.55", "2.39", "2.35", "2.33", "1.91", "1.85", "16/9", "4/3", "1", "9/16"};
        comboPreset.setName("comboPreset");
        comboPreset.setModel(new DefaultComboBoxModel<String>(presetsList));
        comboPreset.setMaximumRowCount(10);
        comboPreset.setEnabled(false);
        comboPreset.setEditable(true);
        comboPreset.setSelectedIndex(0);
        comboPreset.setFont(new Font(Shutter.freeSansFont, 0, 11));
        comboPreset.setBounds(lblPresets.getX() + lblPresets.getWidth() + 4, lblPresets.getY() - 2, 82, 22);
        grpCrop.add(comboPreset);
        comboPreset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                block21: {
                    if (comboPreset.getSelectedIndex() == 0) {
                        selection.setBounds(player.getWidth() / 4, player.getHeight() / 4, player.getWidth() / 2, player.getHeight() / 2);
                        anchorRight = VideoPlayer.selection.getLocation().x + selection.getWidth();
                        anchorBottom = VideoPlayer.selection.getLocation().y + selection.getHeight();
                        VideoPlayer.checkSelection();
                    } else if (comboPreset.getSelectedIndex() == 1) {
                        frame.setCursor(Cursor.getPredefinedCursor(3));
                        Thread t = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                File file = new File(videoPath);
                                String cmd = System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Linux") ? " -an -t 1 -vf cropdetect -f null -" : " -an -t 1 -vf cropdetect -f null -\"";
                                FFMPEG.cropdetect = "";
                                String inputPoint = " -ss " + playerCurrentFrame * inputFramerateMS + "ms";
                                if (FFPROBE.totalLength <= 40 || Shutter.caseEnableSequence.isSelected()) {
                                    inputPoint = "";
                                }
                                FFMPEG.run(String.valueOf(inputPoint) + " -i " + '\"' + file + '\"' + cmd);
                                try {
                                    do {
                                        Thread.sleep(100L);
                                    } while (FFMPEG.runProcess.isAlive());
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                Shutter.enableAll();
                                if (FFMPEG.cropdetect != "") {
                                    String[] c = FFMPEG.cropdetect.split(":");
                                    textCropPosX.setText(c[2]);
                                    textCropWidth.setText(c[0]);
                                    textCropHeight.setText(c[1]);
                                    textCropPosY.setText(c[3]);
                                    int x = Math.round((float)(Integer.valueOf(textCropPosX.getText()) * player.getHeight()) / (float)FFPROBE.imageHeight);
                                    int y = Math.round((float)(Integer.valueOf(textCropPosY.getText()) * player.getWidth()) / (float)FFPROBE.imageWidth);
                                    int width = (int)Math.ceil((float)(Integer.valueOf(textCropWidth.getText()) * player.getHeight()) / (float)FFPROBE.imageHeight);
                                    int height = (int)Math.floor((float)(Integer.valueOf(textCropHeight.getText()) * player.getWidth()) / (float)FFPROBE.imageWidth);
                                    if (width > player.getWidth()) {
                                        width = player.getWidth();
                                    }
                                    if (height > player.getHeight()) {
                                        height = player.getHeight();
                                    }
                                    selection.setBounds(x, y, width, height);
                                }
                                frame.setCursor(Cursor.getPredefinedCursor(0));
                            }
                        });
                        t.start();
                    } else if (!comboPreset.getSelectedItem().toString().isEmpty()) {
                        try {
                            float outputRatio;
                            String[] s = FFPROBE.imageResolution.split("x");
                            int w = Integer.parseInt(s[0]);
                            int h = Integer.parseInt(s[1]);
                            String inputRatio = String.valueOf((float)Integer.parseInt(s[0]) / (float)Integer.parseInt(s[1]));
                            if (inputRatio.length() > 4) {
                                inputRatio = inputRatio.substring(0, 4);
                            }
                            if (comboPreset.getSelectedItem().toString().contains("/")) {
                                String[] d = comboPreset.getSelectedItem().toString().split("/");
                                outputRatio = (float)Integer.parseInt(d[0]) / (float)Integer.parseInt(d[1]);
                            } else {
                                outputRatio = Float.parseFloat(comboPreset.getSelectedItem().toString());
                            }
                            if (outputRatio == 1.33f) {
                                outputRatio = 1.3333334f;
                            } else if (outputRatio == 0.8f) {
                                outputRatio = 0.8f;
                            } else if (outputRatio == 1.77f) {
                                outputRatio = 1.7777778f;
                            } else if (outputRatio == 2.33f) {
                                outputRatio = 2.3333333f;
                            }
                            if (outputRatio < Float.parseFloat(inputRatio)) {
                                textCropPosY.setText("0");
                                textCropHeight.setText(s[1]);
                                textCropWidth.setText(String.valueOf(Math.round((float)h * outputRatio)));
                                textCropPosX.setText(String.valueOf((w - Integer.parseInt(textCropWidth.getText())) / 2));
                            } else {
                                textCropPosX.setText("0");
                                textCropWidth.setText(s[0]);
                                textCropHeight.setText(String.valueOf(Math.round((float)w / outputRatio)));
                                textCropPosY.setText(String.valueOf((h - Integer.parseInt(textCropHeight.getText())) / 2));
                            }
                            int x = Math.round((float)(Integer.valueOf(textCropPosX.getText()) * player.getHeight()) / (float)FFPROBE.imageHeight);
                            int y = Math.round((float)(Integer.valueOf(textCropPosY.getText()) * player.getWidth()) / (float)FFPROBE.imageWidth);
                            int width = (int)Math.ceil((float)(Integer.valueOf(textCropWidth.getText()) * player.getHeight()) / (float)FFPROBE.imageHeight);
                            int height = (int)Math.floor((float)(Integer.valueOf(textCropHeight.getText()) * player.getWidth()) / (float)FFPROBE.imageWidth);
                            if (width > player.getWidth()) {
                                width = player.getWidth();
                            }
                            if (height > player.getHeight()) {
                                height = player.getHeight();
                            }
                            selection.setBounds(x, y, width, height);
                        }
                        catch (Exception er) {
                            if (comboPreset.getSelectedItem().toString() == "") break block21;
                            JOptionPane.showMessageDialog(frame, Shutter.language.getProperty("wrongValue"), Shutter.language.getProperty("wrongFormat"), 0);
                        }
                    }
                }
            }
        });
        selection = new JPanel();
        selection.setOpaque(false);
        selection.setBorder(BorderFactory.createDashedBorder(Utils.themeColor, 4.0f, 4.0f));
        selection.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                selectionDrag = true;
                int mouseX = MouseInfo.getPointerInfo().getLocation().x - VideoPlayer.frame.getLocation().x - startCropX - frameCropX;
                int mouseY = MouseInfo.getPointerInfo().getLocation().y - VideoPlayer.frame.getLocation().y - startCropY - frameCropY;
                if (mouseX < 0) {
                    mouseX = 0;
                }
                if (mouseY < 0) {
                    mouseY = 0;
                }
                int mouseInPictureX = MouseInfo.getPointerInfo().getLocation().x - VideoPlayer.frame.getLocation().x - frameCropX;
                int mouseInPictureY = MouseInfo.getPointerInfo().getLocation().y - VideoPlayer.frame.getLocation().y - frameCropY;
                if (frame.getCursor() == Cursor.getPredefinedCursor(6)) {
                    if (mouseInPictureX >= 0 && mouseInPictureY >= 0) {
                        selection.setLocation(mouseX, mouseY);
                        if (shift) {
                            selection.setSize(2 * anchorRight - 2 * mouseX - selection.getWidth(), 2 * anchorBottom - 2 * mouseY - selection.getHeight());
                        } else {
                            selection.setSize(anchorRight - mouseX, anchorBottom - mouseY);
                        }
                    } else if (mouseInPictureX < 0) {
                        selection.setBounds(0, selection.getY(), selection.getWidth(), selection.getHeight());
                    } else if (mouseInPictureY < 0) {
                        selection.setBounds(selection.getX(), 0, selection.getWidth(), selection.getHeight());
                    }
                } else if (frame.getCursor() == Cursor.getPredefinedCursor(8)) {
                    if (mouseInPictureY >= 0) {
                        selection.setLocation(VideoPlayer.selection.getLocation().x, mouseY);
                        if (shift) {
                            selection.setSize(VideoPlayer.selection.getSize().width, 2 * anchorBottom - 2 * mouseY - selection.getHeight());
                        } else {
                            selection.setSize(VideoPlayer.selection.getSize().width, anchorBottom - mouseY);
                        }
                    } else {
                        selection.setBounds(selection.getX(), 0, selection.getWidth(), selection.getHeight());
                    }
                } else if (frame.getCursor() == Cursor.getPredefinedCursor(7)) {
                    if (mouseInPictureY >= 0 && mouseInPictureX <= player.getWidth()) {
                        if (shift) {
                            selection.setLocation(VideoPlayer.selection.getLocation().x + (selection.getWidth() - e.getX()), mouseY);
                            selection.setSize(e.getX() - (selection.getWidth() - e.getX()), 2 * anchorBottom - 2 * mouseY - selection.getHeight());
                        } else {
                            selection.setLocation(VideoPlayer.selection.getLocation().x, mouseY);
                            selection.setSize(e.getX(), anchorBottom - mouseY);
                        }
                    } else if (mouseInPictureY < 0) {
                        selection.setBounds(selection.getX(), 0, selection.getWidth(), selection.getHeight());
                    } else if (mouseInPictureX > player.getWidth()) {
                        selection.setBounds(selection.getX(), selection.getY(), player.getWidth() - selection.getX(), selection.getHeight());
                    }
                } else if (frame.getCursor() == Cursor.getPredefinedCursor(11)) {
                    if (mouseInPictureX <= player.getWidth()) {
                        if (shift) {
                            selection.setLocation(VideoPlayer.selection.getLocation().x + (selection.getWidth() - e.getX()), VideoPlayer.selection.getLocation().y);
                            selection.setSize(e.getX() - (selection.getWidth() - e.getX()), VideoPlayer.selection.getSize().height);
                        } else {
                            selection.setSize(e.getX(), VideoPlayer.selection.getSize().height);
                        }
                    } else {
                        selection.setBounds(selection.getX(), selection.getY(), player.getWidth() - selection.getX(), selection.getHeight());
                    }
                } else if (frame.getCursor() == Cursor.getPredefinedCursor(5)) {
                    if (mouseInPictureY <= player.getHeight() && mouseInPictureX <= player.getWidth()) {
                        if (shift) {
                            selection.setLocation(VideoPlayer.selection.getLocation().x + (selection.getWidth() - e.getX()), VideoPlayer.selection.getLocation().y + (selection.getHeight() - e.getY()));
                            selection.setSize(e.getX() - (selection.getWidth() - e.getX()), e.getY() - (selection.getHeight() - e.getY()));
                        } else {
                            selection.setSize(e.getX(), e.getY());
                        }
                    } else if (mouseInPictureY > player.getHeight()) {
                        selection.setBounds(selection.getX(), selection.getY(), selection.getWidth(), player.getHeight() - selection.getY());
                    } else if (mouseInPictureX > player.getWidth()) {
                        selection.setBounds(selection.getX(), selection.getY(), player.getWidth() - selection.getX(), selection.getHeight());
                    }
                } else if (frame.getCursor() == Cursor.getPredefinedCursor(9)) {
                    if (mouseInPictureY < player.getHeight()) {
                        if (shift) {
                            textCropPosY.setText("0");
                            selection.setLocation(VideoPlayer.selection.getLocation().x, VideoPlayer.selection.getLocation().y + (selection.getHeight() - e.getY()));
                            selection.setSize(VideoPlayer.selection.getSize().width, e.getY() - (selection.getHeight() - e.getY()));
                        } else {
                            selection.setSize(VideoPlayer.selection.getSize().width, e.getY());
                        }
                    } else {
                        selection.setBounds(selection.getX(), selection.getY(), selection.getWidth(), player.getHeight() - selection.getY());
                    }
                } else if (frame.getCursor() == Cursor.getPredefinedCursor(4)) {
                    if (mouseInPictureY <= player.getHeight() && mouseInPictureX >= 0) {
                        if (shift) {
                            selection.setLocation(mouseX, VideoPlayer.selection.getLocation().y + (selection.getHeight() - e.getY()));
                            selection.setSize(2 * anchorRight - 2 * mouseX - selection.getWidth(), e.getY() - (selection.getHeight() - e.getY()));
                        } else {
                            selection.setLocation(mouseX, VideoPlayer.selection.getLocation().y);
                            selection.setSize(anchorRight - mouseX, e.getY());
                        }
                    } else if (mouseInPictureY > player.getHeight()) {
                        selection.setBounds(selection.getX(), selection.getY(), selection.getWidth(), player.getHeight() - selection.getY());
                    } else if (mouseInPictureX < 0) {
                        selection.setBounds(0, selection.getY(), selection.getWidth(), selection.getHeight());
                    }
                } else if (frame.getCursor() == Cursor.getPredefinedCursor(10)) {
                    if (mouseInPictureX >= 0) {
                        selection.setLocation(mouseX, VideoPlayer.selection.getLocation().y);
                        if (shift) {
                            selection.setSize(2 * anchorRight - 2 * mouseX - selection.getWidth(), VideoPlayer.selection.getSize().height);
                        } else {
                            selection.setSize(anchorRight - mouseX, VideoPlayer.selection.getSize().height);
                        }
                    } else {
                        selection.setBounds(0, selection.getY(), selection.getWidth(), selection.getHeight());
                    }
                } else if (frame.getCursor() == Cursor.getPredefinedCursor(13)) {
                    if (shift && ctrl) {
                        selection.setLocation(mouseX, VideoPlayer.selection.getLocation().y);
                    } else if (shift) {
                        selection.setLocation(VideoPlayer.selection.getLocation().x, mouseY);
                    } else if (ctrl) {
                        selection.setLocation(mouseX, VideoPlayer.selection.getLocation().y);
                    } else {
                        selection.setLocation(mouseX, mouseY);
                    }
                }
                if (selection.getX() < 0) {
                    selection.setLocation(0, selection.getY());
                }
                if (selection.getY() < 0) {
                    selection.setLocation(selection.getX(), 0);
                }
                if (selection.getX() + selection.getWidth() > player.getWidth()) {
                    selection.setLocation(player.getWidth() - selection.getWidth(), selection.getY());
                }
                if (selection.getY() + selection.getHeight() > player.getHeight()) {
                    selection.setLocation(selection.getX(), player.getHeight() - selection.getHeight());
                }
                anchorRight = VideoPlayer.selection.getLocation().x + selection.getWidth();
                anchorBottom = VideoPlayer.selection.getLocation().y + selection.getHeight();
                VideoPlayer.checkSelection();
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (!selectionDrag) {
                    if (e.getX() <= 10 && e.getY() <= 10) {
                        frame.setCursor(Cursor.getPredefinedCursor(6));
                    } else if (e.getX() <= selection.getWidth() - 10 && e.getY() <= 10) {
                        frame.setCursor(Cursor.getPredefinedCursor(8));
                    } else if (e.getX() <= selection.getWidth() && e.getX() >= selection.getWidth() - 10 && e.getY() <= 10) {
                        frame.setCursor(Cursor.getPredefinedCursor(7));
                    } else if (e.getX() <= selection.getWidth() && e.getX() >= selection.getWidth() - 10 && e.getY() >= 10 && e.getY() <= selection.getHeight() - 10) {
                        frame.setCursor(Cursor.getPredefinedCursor(11));
                    } else if (e.getX() <= selection.getWidth() && e.getX() >= selection.getWidth() - 10 && e.getY() <= selection.getHeight() && e.getY() >= selection.getHeight() - 10) {
                        frame.setCursor(Cursor.getPredefinedCursor(5));
                    } else if (e.getX() <= selection.getWidth() - 10 && e.getX() >= 10 && e.getY() <= selection.getHeight() && e.getY() >= selection.getHeight() - 10) {
                        frame.setCursor(Cursor.getPredefinedCursor(9));
                    } else if (e.getX() <= 10 && e.getY() <= selection.getHeight() && e.getY() >= selection.getHeight() - 10) {
                        frame.setCursor(Cursor.getPredefinedCursor(4));
                    } else if (e.getX() <= 10 && e.getY() >= 10 && e.getY() <= selection.getHeight() - 10) {
                        frame.setCursor(Cursor.getPredefinedCursor(10));
                    } else {
                        frame.setCursor(Cursor.getPredefinedCursor(13));
                    }
                }
            }
        });
        selection.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                startCropX = e.getPoint().x;
                startCropY = e.getPoint().y;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                selectionDrag = false;
                if (VideoPlayer.selection.getLocation().x <= 0 && VideoPlayer.selection.getLocation().y <= 0) {
                    selection.setLocation(0, 0);
                } else if (VideoPlayer.selection.getLocation().x + selection.getWidth() > player.getWidth() && VideoPlayer.selection.getLocation().y <= 0) {
                    selection.setLocation(player.getWidth() - selection.getWidth(), 0);
                } else if (VideoPlayer.selection.getLocation().x <= 0 && VideoPlayer.selection.getLocation().y + selection.getHeight() > player.getHeight()) {
                    selection.setLocation(0, player.getHeight() - selection.getHeight());
                } else if (VideoPlayer.selection.getLocation().x + selection.getWidth() > player.getWidth() && VideoPlayer.selection.getLocation().y + selection.getHeight() > player.getHeight()) {
                    selection.setLocation(player.getWidth() - selection.getWidth(), player.getHeight() - selection.getHeight());
                } else if (VideoPlayer.selection.getLocation().x + selection.getWidth() > player.getWidth()) {
                    selection.setLocation(player.getWidth() - selection.getWidth(), VideoPlayer.selection.getLocation().y);
                } else if (VideoPlayer.selection.getLocation().y + selection.getHeight() > player.getHeight()) {
                    selection.setLocation(VideoPlayer.selection.getLocation().x, player.getHeight() - selection.getHeight());
                } else if (VideoPlayer.selection.getLocation().x <= 0) {
                    selection.setLocation(0, VideoPlayer.selection.getLocation().y);
                } else if (VideoPlayer.selection.getLocation().y <= 0) {
                    selection.setLocation(VideoPlayer.selection.getLocation().x, 0);
                }
            }
        });
        overImage = new JPanel(){

            @Override
            public void paintComponent(Graphics g) {
                Graphics2D g2d = (Graphics2D)g;
                Area outter = new Area(new Rectangle(0, 0, player.getWidth(), player.getHeight()));
                Rectangle inner = new Rectangle(VideoPlayer.selection.getLocation().x, VideoPlayer.selection.getLocation().y, selection.getWidth(), selection.getHeight());
                outter.subtract(new Area(inner));
                g2d.setColor(new Color(0, 0, 0, 180));
                g2d.fill(outter);
            }
        };
        overImage.setBounds(0, 0, player.getWidth(), player.getHeight());
        overImage.setOpaque(false);
        overImage.setLayout(null);
        overImage.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 2 && !e.isConsumed()) {
                    selection.setBounds(player.getWidth() / 4, player.getHeight() / 4, player.getWidth() / 2, player.getHeight() / 2);
                    anchorRight = VideoPlayer.selection.getLocation().x + selection.getWidth();
                    anchorBottom = VideoPlayer.selection.getLocation().y + selection.getHeight();
                    VideoPlayer.checkSelection();
                    comboPreset.setSelectedIndex(0);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (!selectionDrag) {
                    frame.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        JLabel cropPosX = new JLabel(Shutter.language.getProperty("posX"));
        cropPosX.setHorizontalAlignment(4);
        cropPosX.setFont(new Font(Shutter.freeSansFont, 0, 12));
        cropPosX.setForeground(Utils.themeColor);
        cropPosX.setEnabled(false);
        cropPosX.setBounds(24, caseEnableCrop.getY() + caseEnableCrop.getHeight() + 4, cropPosX.getPreferredSize().width, 16);
        textCropPosX = new JTextField("0");
        textCropPosX.setName("textCropPosX");
        textCropPosX.setBounds(cropPosX.getLocation().x + cropPosX.getWidth() + 2, cropPosX.getLocation().y, 34, 16);
        textCropPosX.setHorizontalAlignment(4);
        textCropPosX.setEnabled(false);
        textCropPosX.setFont(new Font(Shutter.freeSansFont, 0, 12));
        JLabel cropPx1 = new JLabel("px");
        cropPx1.setFont(new Font(Shutter.freeSansFont, 0, 12));
        cropPx1.setForeground(Utils.themeColor);
        cropPx1.setEnabled(false);
        cropPx1.setBounds(VideoPlayer.textCropPosX.getLocation().x + textCropPosX.getWidth() + 2, cropPosX.getLocation().y, cropPx1.getPreferredSize().width, 16);
        textCropPosX.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (textCropPosX.getText().length() > 0 && e.getKeyCode() == 10) {
                    int value = Math.round((float)(Integer.valueOf(textCropPosX.getText()) * player.getHeight()) / (float)FFPROBE.imageHeight);
                    selection.setLocation(value, VideoPlayer.selection.getLocation().y);
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (textCropPosX.getText().length() >= 4) {
                    textCropPosX.setText("");
                }
            }
        });
        textCropPosX.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                textCropPosX.setCursor(Cursor.getPredefinedCursor(2));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                textCropPosX.setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                textCropPosX.setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mousePressed(MouseEvent e) {
                MousePositionX = e.getX();
                mouseCropOffsetX = Integer.parseInt(textCropPosX.getText());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        textCropPosX.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (textCropPosX.getCursor() == Cursor.getPredefinedCursor(13)) {
                    textCropPosX.setText(String.valueOf(mouseCropOffsetX + (e.getX() - MousePositionX)));
                    selection.setLocation(Math.round((float)Integer.valueOf(textCropPosX.getText()).intValue() / imageRatio), VideoPlayer.selection.getLocation().y);
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        JLabel cropPosY = new JLabel(Shutter.language.getProperty("posY"));
        cropPosY.setHorizontalAlignment(4);
        cropPosY.setFont(new Font(Shutter.freeSansFont, 0, 12));
        cropPosY.setForeground(Utils.themeColor);
        cropPosY.setEnabled(false);
        cropPosY.setBounds(cropPx1.getX() + cropPx1.getWidth() + 30, cropPosX.getLocation().y, cropPosX.getWidth(), 16);
        textCropPosY = new JTextField("0");
        textCropPosY.setName("textCropPosY");
        textCropPosY.setBounds(cropPosY.getLocation().x + cropPosY.getWidth() + 2, cropPosY.getLocation().y, textCropPosX.getWidth(), 16);
        textCropPosY.setHorizontalAlignment(4);
        textCropPosY.setEnabled(false);
        textCropPosY.setFont(new Font(Shutter.freeSansFont, 0, 12));
        textCropPosY.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (textCropPosY.getText().length() > 0 && e.getKeyCode() == 10) {
                    int value = Math.round((float)(Integer.valueOf(textCropPosY.getText()) * player.getWidth()) / (float)FFPROBE.imageWidth);
                    selection.setLocation(VideoPlayer.selection.getLocation().x, value);
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (textCropPosY.getText().length() >= 4) {
                    textCropPosY.setText("");
                }
            }
        });
        textCropPosY.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                textCropPosY.setCursor(Cursor.getPredefinedCursor(2));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                textCropPosY.setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                textCropPosY.setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mousePressed(MouseEvent e) {
                MousePositionY = e.getY();
                mouseCropOffsetY = Integer.parseInt(textCropPosY.getText());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        textCropPosY.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (textCropPosY.getCursor() == Cursor.getPredefinedCursor(13)) {
                    textCropPosY.setText(String.valueOf(mouseCropOffsetY + (e.getY() - MousePositionY)));
                    selection.setLocation(VideoPlayer.selection.getLocation().x, Math.round((float)Integer.valueOf(textCropPosY.getText()).intValue() / imageRatio));
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        JLabel cropPx2 = new JLabel("px");
        cropPx2.setFont(new Font(Shutter.freeSansFont, 0, 12));
        cropPx2.setForeground(Utils.themeColor);
        cropPx2.setEnabled(false);
        cropPx2.setBounds(VideoPlayer.textCropPosY.getLocation().x + textCropPosY.getWidth() + 2, cropPosY.getLocation().y, cropPosX.getPreferredSize().width, 16);
        JLabel lblWidth = new JLabel(Shutter.language.getProperty("lblWidth"));
        lblWidth.setHorizontalAlignment(4);
        lblWidth.setFont(new Font(Shutter.freeSansFont, 0, 12));
        lblWidth.setForeground(Utils.themeColor);
        lblWidth.setEnabled(false);
        lblWidth.setBounds(textCropPosX.getX() - lblWidth.getPreferredSize().width - 2, cropPosX.getY() + cropPosX.getHeight() + 4, lblWidth.getPreferredSize().width, 16);
        textCropWidth = new JTextField("0");
        textCropWidth.setName("textCropWidth");
        textCropWidth.setBounds(textCropPosX.getX(), textCropPosX.getY() + textCropPosX.getHeight() + 4, textCropPosX.getWidth(), 16);
        textCropWidth.setHorizontalAlignment(4);
        textCropWidth.setEnabled(false);
        textCropWidth.setFont(new Font(Shutter.freeSansFont, 0, 12));
        textCropWidth.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (textCropWidth.getText().length() > 0 && e.getKeyCode() == 10) {
                    int value = Math.round((float)(Integer.valueOf(textCropWidth.getText()) * player.getHeight()) / (float)FFPROBE.imageHeight);
                    selection.setSize(value, selection.getHeight());
                    VideoPlayer.checkSelection();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (textCropWidth.getText().length() >= 4) {
                    textCropWidth.setText("");
                }
            }
        });
        textCropWidth.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                textCropWidth.setCursor(Cursor.getPredefinedCursor(2));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                textCropWidth.setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                textCropWidth.setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mousePressed(MouseEvent e) {
                MousePositionX = e.getX();
                mouseCropOffsetX = Integer.parseInt(textCropWidth.getText());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        textCropWidth.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (textCropWidth.getCursor() == Cursor.getPredefinedCursor(13)) {
                    textCropWidth.setText(String.valueOf(mouseCropOffsetX + (e.getX() - MousePositionX)));
                    int value = Math.round((float)(Integer.valueOf(textCropWidth.getText()) * player.getHeight()) / (float)FFPROBE.imageHeight);
                    selection.setSize(value, selection.getHeight());
                    VideoPlayer.checkSelection();
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        JLabel cropPx3 = new JLabel("px");
        cropPx3.setFont(new Font(Shutter.freeSansFont, 0, 12));
        cropPx3.setForeground(Utils.themeColor);
        cropPx3.setEnabled(false);
        cropPx3.setBounds(cropPx1.getX(), lblWidth.getY(), cropPosX.getPreferredSize().width, 16);
        JLabel lblHeight = new JLabel(Shutter.language.getProperty("lblHeight"));
        lblHeight.setHorizontalAlignment(4);
        lblHeight.setFont(new Font(Shutter.freeSansFont, 0, 12));
        lblHeight.setForeground(Utils.themeColor);
        lblHeight.setEnabled(false);
        lblHeight.setBounds(textCropPosY.getX() - lblHeight.getPreferredSize().width - 2, cropPosY.getY() + cropPosY.getHeight() + 4, lblHeight.getPreferredSize().width, 16);
        textCropHeight = new JTextField("0");
        textCropHeight.setName("textCropHeight");
        textCropHeight.setBounds(lblHeight.getLocation().x + lblHeight.getWidth() + 2, textCropWidth.getY(), textCropPosX.getWidth(), 16);
        textCropHeight.setHorizontalAlignment(4);
        textCropHeight.setEnabled(false);
        textCropHeight.setFont(new Font(Shutter.freeSansFont, 0, 12));
        textCropHeight.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (textCropHeight.getText().length() > 0 && e.getKeyCode() == 10) {
                    int value = Math.round((float)(Integer.valueOf(textCropHeight.getText()) * player.getWidth()) / (float)FFPROBE.imageWidth);
                    selection.setSize(selection.getWidth(), value);
                    VideoPlayer.checkSelection();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (textCropHeight.getText().length() >= 4) {
                    textCropHeight.setText("");
                }
            }
        });
        textCropHeight.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                textCropHeight.setCursor(Cursor.getPredefinedCursor(2));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                textCropHeight.setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                textCropHeight.setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mousePressed(MouseEvent e) {
                MousePositionY = e.getY();
                mouseCropOffsetY = Integer.parseInt(textCropHeight.getText());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        textCropHeight.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (textCropHeight.getCursor() == Cursor.getPredefinedCursor(13)) {
                    textCropHeight.setText(String.valueOf(mouseCropOffsetY + (e.getY() - MousePositionY)));
                    int value = Math.round((float)(Integer.valueOf(textCropHeight.getText()) * player.getHeight()) / (float)FFPROBE.imageHeight);
                    selection.setSize(selection.getWidth(), value);
                    VideoPlayer.checkSelection();
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        JLabel cropPx4 = new JLabel("px");
        cropPx4.setFont(new Font(Shutter.freeSansFont, 0, 12));
        cropPx4.setForeground(Utils.themeColor);
        cropPx4.setEnabled(false);
        cropPx4.setBounds(cropPx2.getX(), lblHeight.getY(), cropPosX.getPreferredSize().width, 16);
        grpCrop.add(cropPosX);
        grpCrop.add(textCropPosX);
        grpCrop.add(cropPx1);
        grpCrop.add(cropPosY);
        grpCrop.add(textCropPosY);
        grpCrop.add(cropPx2);
        grpCrop.add(lblWidth);
        grpCrop.add(textCropWidth);
        grpCrop.add(cropPx3);
        grpCrop.add(lblHeight);
        grpCrop.add(textCropHeight);
        grpCrop.add(cropPx4);
        Component[] componentArray = grpCrop.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (!(c instanceof JCheckBox)) {
                c.setEnabled(false);
            }
            ++n2;
        }
    }

    public static void checkSelection() {
        float ratioW = (float)FFPROBE.imageWidth / (float)player.getWidth();
        float ratioH = (float)FFPROBE.imageHeight / (float)player.getHeight();
        int outW = Math.round((float)selection.getWidth() * ratioW);
        int outH = Math.round((float)selection.getHeight() * ratioH);
        int Px = Math.round((float)VideoPlayer.selection.getLocation().x * ratioW);
        int Py = Math.round((float)VideoPlayer.selection.getLocation().y * ratioH);
        if (textCropWidth.getText().matches("[0-9]+") && textCropHeight.getText().matches("[0-9]+")) {
            if (Px + Integer.valueOf(textCropWidth.getText()) > FFPROBE.imageWidth) {
                Px += FFPROBE.imageWidth - (Px + Integer.valueOf(textCropWidth.getText()));
            }
            if (Py + Integer.valueOf(textCropHeight.getText()) > FFPROBE.imageHeight) {
                Py += FFPROBE.imageHeight - (Py + Integer.valueOf(textCropHeight.getText()));
            }
            if (Integer.valueOf(textCropWidth.getText()) != FFPROBE.imageWidth) {
                textCropPosX.setText(String.valueOf(Px));
            }
            if (Integer.valueOf(textCropHeight.getText()) != FFPROBE.imageHeight) {
                textCropPosY.setText(String.valueOf(Py));
            }
        } else {
            textCropPosX.setText(String.valueOf(Px));
            textCropPosY.setText(String.valueOf(Py));
        }
        if (frame.getCursor() != Cursor.getPredefinedCursor(13)) {
            textCropWidth.setText(String.valueOf(outW));
            textCropHeight.setText(String.valueOf(outH));
        }
        if (caseEnableCrop.isSelected()) {
            comboPreset.getEditor().setItem((double)Math.round((double)outW / (double)outH * 100.0) / 100.0);
        } else {
            comboPreset.getEditor().setItem(Shutter.language.getProperty("aucun"));
        }
    }

    private void grpOverlay() {
        grpOverlay = new JPanel();
        grpOverlay.setLayout(null);
        grpOverlay.setBorder(BorderFactory.createTitledBorder(new RoundedLineBorder(new Color(65, 65, 65), 1, 5, true), String.valueOf(Shutter.language.getProperty("caseAddOverlay")) + " ", 0, 0, new Font(Shutter.montserratFont, 0, 12), Color.WHITE));
        grpOverlay.setBackground(new Color(45, 45, 45));
        grpOverlay.setSize(grpCrop.getWidth(), 17);
        grpOverlay.setLocation(frame.getWidth() - grpOverlay.getWidth() - 6, grpCrop.getY() + grpCrop.getHeight() + 6);
        frame.getContentPane().add(grpOverlay);
        grpOverlay.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int sized = 278;
                if (VideoPlayer.grpOverlay.getSize().height < 278) {
                    Thread changeSize = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                long startTime;
                                int i = 17;
                                do {
                                    startTime = System.currentTimeMillis() + 1L;
                                    i = Settings.btnDisableAnimations.isSelected() ? 278 : ++i;
                                    grpOverlay.setSize(grpOverlay.getWidth(), i);
                                    grpSubtitles.setLocation(VideoPlayer.grpOverlay.getLocation().x, VideoPlayer.grpOverlay.getSize().height + VideoPlayer.grpOverlay.getLocation().y + 6);
                                    grpWatermark.setLocation(VideoPlayer.grpSubtitles.getLocation().x, VideoPlayer.grpSubtitles.getSize().height + VideoPlayer.grpSubtitles.getLocation().y + 6);
                                    if (grpWatermark.getY() + grpWatermark.getHeight() >= grpOut.getY() - 6) {
                                        if (grpSubtitles.getHeight() > 17) {
                                            grpSubtitles.setSize(grpSubtitles.getWidth(), grpSubtitles.getHeight() - 1);
                                            grpWatermark.setLocation(VideoPlayer.grpSubtitles.getLocation().x, VideoPlayer.grpSubtitles.getSize().height + VideoPlayer.grpSubtitles.getLocation().y + 6);
                                        }
                                        if (grpWatermark.getHeight() > 17) {
                                            grpWatermark.setSize(grpWatermark.getWidth(), grpWatermark.getHeight() - 1);
                                        }
                                    }
                                    Shutter.animateSections(startTime);
                                } while (i < 278);
                                if (grpSubtitles.getHeight() > 17 && grpSubtitles.getHeight() < 131) {
                                    i = grpSubtitles.getHeight();
                                    do {
                                        startTime = System.currentTimeMillis() + 1L;
                                        i = Settings.btnDisableAnimations.isSelected() ? 17 : --i;
                                        grpSubtitles.setSize(grpSubtitles.getWidth(), i);
                                        grpWatermark.setLocation(VideoPlayer.grpSubtitles.getLocation().x, VideoPlayer.grpSubtitles.getSize().height + VideoPlayer.grpSubtitles.getLocation().y + 6);
                                        Shutter.animateSections(startTime);
                                    } while (i > 17);
                                }
                                if (grpWatermark.getHeight() > 17 && grpWatermark.getHeight() < 90) {
                                    i = grpWatermark.getHeight();
                                    do {
                                        startTime = System.currentTimeMillis() + 1L;
                                        i = Settings.btnDisableAnimations.isSelected() ? 17 : --i;
                                        grpWatermark.setSize(grpWatermark.getWidth(), i);
                                        Shutter.animateSections(startTime);
                                    } while (i > 17);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                    changeSize.start();
                } else {
                    Thread changeSize = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                int i = 278;
                                do {
                                    long startTime = System.currentTimeMillis() + 1L;
                                    i = Settings.btnDisableAnimations.isSelected() ? 17 : --i;
                                    grpOverlay.setSize(grpOverlay.getWidth(), i);
                                    grpSubtitles.setLocation(VideoPlayer.grpOverlay.getLocation().x, VideoPlayer.grpOverlay.getSize().height + VideoPlayer.grpOverlay.getLocation().y + 6);
                                    grpWatermark.setLocation(VideoPlayer.grpSubtitles.getLocation().x, VideoPlayer.grpSubtitles.getSize().height + VideoPlayer.grpSubtitles.getLocation().y + 6);
                                    Shutter.animateSections(startTime);
                                } while (i > 17);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                    changeSize.start();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        JLabel lblFont = new JLabel(Shutter.language.getProperty("lblFont"));
        lblFont.setAlignmentX(4.0f);
        lblFont.setForeground(Utils.themeColor);
        lblFont.setFont(new Font(Shutter.freeSansFont, 0, 12));
        lblFont.setBounds(12, 24, lblFont.getPreferredSize().width, 16);
        grpOverlay.add(lblFont);
        final String[] Fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        comboOverlayFont = new JComboBox<String>(Fonts);
        comboOverlayFont.setName("comboOverlayFont");
        comboOverlayFont.setSelectedItem("Arial");
        comboOverlayFont.setFont(new Font("Arial", 0, 11));
        comboOverlayFont.setRenderer(new ComboRendererOverlay(comboOverlayFont));
        comboOverlayFont.setEditable(true);
        comboOverlayFont.setLocation(lblFont.getX() + lblFont.getWidth() + 7, lblFont.getY() - 4);
        comboOverlayFont.setSize(grpOverlay.getWidth() - comboOverlayFont.getX() - 10, 22);
        grpOverlay.add(comboOverlayFont);
        comboOverlayFont.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){
            String text = "";

            @Override
            public void keyReleased(KeyEvent e) {
                if (comboOverlayFont.getEditor().toString().length() <= 1) {
                    this.text = String.valueOf(e.getKeyChar());
                }
                if (Character.isLetterOrDigit(e.getKeyChar())) {
                    comboOverlayFont.setModel(new DefaultComboBoxModel<String>(Fonts));
                    this.text = String.valueOf(this.text) + e.getKeyChar();
                    ArrayList<String> newList = new ArrayList<String>();
                    int i = 0;
                    while (i < comboOverlayFont.getItemCount()) {
                        if (Fonts[i].toString().length() >= this.text.length() && Fonts[i].toString().toLowerCase().substring(0, this.text.length()).contains(this.text) && !Fonts[i].toString().contains(":")) {
                            newList.add(Fonts[i].toString());
                        }
                        ++i;
                    }
                    comboOverlayFont.getEditor().setItem(this.text);
                    if (!newList.isEmpty()) {
                        comboOverlayFont.setModel(new DefaultComboBoxModel<Object>(newList.toArray()));
                        comboOverlayFont.showPopup();
                    }
                } else if (e.getKeyCode() == 8 || e.getKeyCode() == 27) {
                    comboOverlayFont.setModel(new DefaultComboBoxModel<String>(Fonts));
                    comboOverlayFont.getEditor().setItem("");
                    comboOverlayFont.hidePopup();
                    this.text = "";
                } else if (e.getKeyCode() == 40) {
                    e.consume();
                } else {
                    comboOverlayFont.hidePopup();
                }
            }
        });
        comboOverlayFont.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                comboOverlayFont.setFont(new Font(comboOverlayFont.getSelectedItem().toString(), 0, 11));
                timecode.repaint();
                fileName.repaint();
            }
        });
        JLabel lblColor = new JLabel(Shutter.language.getProperty("lblColor"));
        lblColor.setAlignmentX(4.0f);
        lblColor.setForeground(Utils.themeColor);
        lblColor.setFont(new Font(Shutter.freeSansFont, 0, 12));
        lblColor.setBounds(lblFont.getX(), lblFont.getY() + lblFont.getHeight() + 11, lblColor.getPreferredSize().width + 4, 16);
        grpOverlay.add(lblColor);
        panelTcColor = new JPanel();
        panelTcColor.setName("panelTcColor");
        panelTcColor.setBorder(BorderFactory.createMatteBorder(3, 3, 3, 3, Color.BLACK));
        panelTcColor.setBackground(foregroundColor);
        panelTcColor.setBounds(lblColor.getLocation().x + lblColor.getWidth(), lblColor.getY() - 4, 41, 22);
        grpOverlay.add(panelTcColor);
        panelTcColor.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                foregroundColor = JColorChooser.showDialog(frame, Shutter.language.getProperty("chooseColor"), Color.WHITE);
                if (foregroundColor != null) {
                    panelTcColor.setBackground(foregroundColor);
                    timecode.repaint();
                    fileName.repaint();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        lblTcBackground = new JLabel(Shutter.language.getProperty("lblBackgroundOn"));
        lblTcBackground.setName("lblTcBackground");
        lblTcBackground.setBackground(new Color(60, 60, 60));
        lblTcBackground.setHorizontalAlignment(0);
        lblTcBackground.setOpaque(true);
        lblTcBackground.setFont(new Font(Shutter.montserratFont, 0, 11));
        lblTcBackground.setBounds(VideoPlayer.panelTcColor.getLocation().x + panelTcColor.getWidth() + 7, lblColor.getLocation().y - 1, 80, 16);
        grpOverlay.add(lblTcBackground);
        lblTcBackground.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                if (lblTcBackground.getText().equals(Shutter.language.getProperty("lblBackgroundOn"))) {
                    lblTcBackground.setText(Shutter.language.getProperty("aucun"));
                    textTcOpacity.setText("100");
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    textNameOpacity.setText("100");
                } else {
                    lblTcBackground.setText(Shutter.language.getProperty("lblBackgroundOn"));
                    textTcOpacity.setText("50");
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    textNameOpacity.setText("50");
                }
                timecode.repaint();
                fileName.repaint();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                frame.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                frame.setCursor(Cursor.getPredefinedCursor(0));
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        JLabel lblColor2 = new JLabel(Shutter.language.getProperty("lblColor"));
        lblColor2.setAlignmentX(4.0f);
        lblColor2.setForeground(Utils.themeColor);
        lblColor2.setFont(new Font(Shutter.freeSansFont, 0, 12));
        lblColor2.setBounds(VideoPlayer.lblTcBackground.getLocation().x + lblTcBackground.getWidth() + 7, lblColor.getY(), lblColor2.getPreferredSize().width + 4, 16);
        grpOverlay.add(lblColor2);
        panelTcColor2 = new JPanel();
        panelTcColor2.setName("panelTcColor2");
        panelTcColor2.setBorder(BorderFactory.createMatteBorder(3, 3, 3, 3, Color.BLACK));
        panelTcColor2.setBackground(backgroundColor);
        panelTcColor2.setBounds(lblColor2.getLocation().x + lblColor2.getWidth(), panelTcColor.getY(), 41, 22);
        grpOverlay.add(panelTcColor2);
        panelTcColor2.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                backgroundColor = JColorChooser.showDialog(frame, Shutter.language.getProperty("chooseColor"), Color.WHITE);
                if (backgroundColor != null) {
                    panelTcColor2.setBackground(backgroundColor);
                    timecode.repaint();
                    fileName.repaint();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        caseAddTimecode.setName("caseAddTimecode");
        caseAddTimecode.setSelected(false);
        caseAddTimecode.setFont(new Font(Shutter.freeSansFont, 0, 12));
        caseAddTimecode.setSize(VideoPlayer.caseAddTimecode.getPreferredSize().width, 23);
        caseAddTimecode.setLocation(8, lblColor.getY() + lblColor.getHeight() + 9);
        grpOverlay.add(caseAddTimecode);
        caseAddTimecode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (caseAddTimecode.isSelected()) {
                    timecode.repaint();
                    TC1.setEnabled(true);
                    TC2.setEnabled(true);
                    TC3.setEnabled(true);
                    TC4.setEnabled(true);
                    caseShowTimecode.setSelected(false);
                    player.add(timecode);
                    if (caseEnableCrop.isSelected()) {
                        player.remove(selection);
                        player.remove(overImage);
                        player.add(selection);
                        player.add(overImage);
                    }
                } else {
                    FFPROBE.timecode1 = "";
                    FFPROBE.timecode2 = "";
                    FFPROBE.timecode3 = "";
                    FFPROBE.timecode4 = "";
                    TC1.setEnabled(false);
                    TC2.setEnabled(false);
                    TC3.setEnabled(false);
                    TC4.setEnabled(false);
                    player.remove(timecode);
                }
                VideoPlayer.refreshTimecodeAndText();
                player.repaint();
            }
        });
        timecode = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2 = (Graphics2D)g;
                boolean resetLocation = false;
                if (this.getWidth() == 1) {
                    resetLocation = true;
                }
                int width = this.getWidth();
                int height = this.getHeight();
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                Font font = new Font(comboOverlayFont.getSelectedItem().toString(), 0, Math.round((float)Integer.parseInt(textTcSize.getText()) / imageRatio));
                font.deriveFont((float)Integer.parseInt(textTcSize.getText()) / imageRatio);
                g2.setFont(font);
                String dropFrame = ":";
                if (!(FFPROBE.dropFrameTC.equals(":") || FFPROBE.currentFPS != 29.97f && FFPROBE.currentFPS != 59.94f)) {
                    dropFrame = ";";
                }
                if (Shutter.caseConform.isSelected()) {
                    dropFrame = Shutter.comboFPS.getSelectedItem().toString().equals("29,97") || Shutter.comboFPS.getSelectedItem().toString().equals("59,94") ? ";" : ":";
                }
                String str = "00:00:00" + dropFrame + "00";
                if (caseAddTimecode.isSelected() || caseShowTimecode.isSelected()) {
                    float currentTime;
                    float offset;
                    float tcH = 0.0f;
                    float tcM = 0.0f;
                    float tcS = 0.0f;
                    float tcF = 0.0f;
                    if (!(!caseAddTimecode.isSelected() || TC1.getText().isEmpty() || TC2.getText().isEmpty() || TC3.getText().isEmpty() || TC4.getText().isEmpty())) {
                        tcH = Integer.valueOf(TC1.getText()).intValue();
                        tcM = Integer.valueOf(TC2.getText()).intValue();
                        tcS = Integer.valueOf(TC3.getText()).intValue();
                        tcF = Integer.valueOf(TC4.getText()).intValue();
                    } else if (caseShowTimecode.isSelected() && !FFPROBE.timecode1.equals("")) {
                        tcH = Integer.valueOf(FFPROBE.timecode1).intValue();
                        tcM = Integer.valueOf(FFPROBE.timecode2).intValue();
                        tcS = Integer.valueOf(FFPROBE.timecode3).intValue();
                        tcF = Integer.valueOf(FFPROBE.timecode4).intValue();
                    }
                    tcH = tcH * 3600.0f * FFPROBE.currentFPS;
                    tcM = tcM * 60.0f * FFPROBE.currentFPS;
                    tcS *= FFPROBE.currentFPS;
                    float timeIn = (float)(Integer.parseInt(caseInH.getText()) * 3600 + Integer.parseInt(caseInM.getText()) * 60 + Integer.parseInt(caseInS.getText())) * FFPROBE.currentFPS + (float)Integer.parseInt(caseInF.getText());
                    if (caseShowTimecode.isSelected()) {
                        timeIn = 0.0f;
                    }
                    if ((offset = (currentTime = Timecode.setNonDropFrameTC(playerCurrentFrame)) - timeIn + tcH + tcM + tcS + tcF) < 0.0f) {
                        offset = 0.0f;
                    }
                    String h = formatter.format(Math.floor(offset / FFPROBE.currentFPS / 3600.0f));
                    String m = formatter.format(Math.floor(offset / FFPROBE.currentFPS / 60.0f) % 60.0);
                    String s = formatter.format(Math.floor(offset / FFPROBE.currentFPS) % 60.0);
                    String f = formatter.format(Math.floor(offset % FFPROBE.currentFPS));
                    str = caseAddTimecode.isSelected() && lblTimecode.getText().equals(Shutter.language.getProperty("lblFrameNumber")) ? String.format("%.0f", Float.valueOf(offset)) : String.valueOf(h) + ":" + m + ":" + s + dropFrame + f;
                }
                Rectangle bounds = this.getStringBounds(g2, str, 0.0f, 0.0f);
                if (lblTcBackground.getText().equals(Shutter.language.getProperty("lblBackgroundOn"))) {
                    g2.setColor(new Color(backgroundColor.getRed(), backgroundColor.getGreen(), backgroundColor.getBlue(), (int)((float)(Integer.parseInt(textTcOpacity.getText()) * 255) / 100.0f)));
                } else {
                    g2.setColor(new Color(0, 0, 0, 0));
                }
                GraphicsConfiguration gfxConfig = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
                AffineTransform transform = gfxConfig.getDefaultTransform();
                if (System.getProperty("os.name").contains("Mac") && !transform.isIdentity()) {
                    g2.fillRect(0, 0, bounds.width, bounds.height / 2);
                } else {
                    g2.fillRect(0, 0, bounds.width, bounds.height);
                }
                if (lblTcBackground.getText().equals(Shutter.language.getProperty("aucun"))) {
                    g2.setColor(new Color(foregroundColor.getRed(), foregroundColor.getGreen(), foregroundColor.getBlue(), (int)((float)(Integer.parseInt(textNameOpacity.getText()) * 255) / 100.0f)));
                } else {
                    g2.setColor(foregroundColor);
                }
                if (System.getProperty("os.name").contains("Mac") && !transform.isIdentity()) {
                    Integer offset = bounds.height + (int)bounds.getY();
                    g2.drawString(str, -2, bounds.height / 2 - offset / 2);
                } else {
                    Integer offset = bounds.height + (int)bounds.getY();
                    g2.drawString(str, -2, bounds.height - offset);
                }
                this.setSize(bounds.width, bounds.height);
                if (resetLocation) {
                    timecode.setLocation(player.getWidth() / 2 - timecode.getWidth() / 2, timecode.getHeight());
                    tcLocX = VideoPlayer.timecode.getLocation().x;
                    tcLocY = VideoPlayer.timecode.getLocation().y;
                } else if (textTcSize.hasFocus()) {
                    timecode.setLocation(timecode.getX() + (width - timecode.getWidth()) / 2, timecode.getY() + (height - timecode.getHeight()) / 2);
                    tcLocX = VideoPlayer.timecode.getLocation().x;
                    tcLocY = VideoPlayer.timecode.getLocation().y;
                }
                VideoPlayer.refreshTimecodeAndText();
            }

            private Rectangle getStringBounds(Graphics2D g2, String str, float x, float y) {
                FontRenderContext frc = g2.getFontRenderContext();
                GlyphVector gv = g2.getFont().createGlyphVector(frc, str);
                return gv.getPixelBounds(null, x, y);
            }
        };
        timecode.setSize(1, 1);
        timecode.setLayout(null);
        timecode.setOpaque(false);
        timecode.setBackground(new Color(0, 0, 0, 0));
        timecode.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    timecode.setLocation(player.getWidth() / 2 - timecode.getWidth() / 2, timecode.getHeight());
                    VideoPlayer.refreshTimecodeAndText();
                    tcLocX = VideoPlayer.timecode.getLocation().x;
                    tcLocY = VideoPlayer.timecode.getLocation().y;
                }
                VideoPlayer.this.tcPosX = e.getLocationOnScreen().x;
                VideoPlayer.this.tcPosY = e.getLocationOnScreen().y;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                tcLocX = VideoPlayer.timecode.getLocation().x;
                tcLocY = VideoPlayer.timecode.getLocation().y;
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                frame.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        timecode.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                timecode.setLocation(MouseInfo.getPointerInfo().getLocation().x - VideoPlayer.this.tcPosX + tcLocX, MouseInfo.getPointerInfo().getLocation().y - VideoPlayer.this.tcPosY + tcLocY);
                textTcPosX.setText(String.valueOf(Math.round((float)VideoPlayer.timecode.getLocation().x * imageRatio)));
                textTcPosY.setText(String.valueOf(Math.round((float)VideoPlayer.timecode.getLocation().y * imageRatio)));
            }

            @Override
            public void mouseMoved(MouseEvent arg0) {
            }
        });
        lblTimecode.setName("lblTimecode");
        lblTimecode.setBackground(new Color(60, 60, 60));
        lblTimecode.setHorizontalAlignment(0);
        lblTimecode.setOpaque(true);
        lblTimecode.setFont(new Font(Shutter.montserratFont, 0, 11));
        lblTimecode.setBounds(VideoPlayer.caseAddTimecode.getLocation().x + caseAddTimecode.getWidth() + 2, VideoPlayer.caseAddTimecode.getLocation().y + 3, 70, 16);
        grpOverlay.add(lblTimecode);
        lblTimecode.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                if (lblTimecode.getText().equals(Shutter.language.getProperty("lblTimecode"))) {
                    lblTimecode.setText(Shutter.language.getProperty("lblFrameNumber"));
                } else {
                    lblTimecode.setText(Shutter.language.getProperty("lblTimecode"));
                }
                if (frameVideo != null) {
                    player.repaint();
                }
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
                frame.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
                frame.setCursor(Cursor.getPredefinedCursor(0));
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }
        });
        TC1.setName("TC1");
        TC1.setEnabled(false);
        TC1.setText("00");
        TC1.setHorizontalAlignment(0);
        TC1.setFont(new Font(Shutter.freeSansFont, 0, 14));
        TC1.setColumns(10);
        TC1.setBounds(lblTimecode.getX() + lblTimecode.getWidth() + 7, caseAddTimecode.getY(), 32, 21);
        grpOverlay.add(TC1);
        TC2.setName("TC2");
        TC2.setEnabled(false);
        TC2.setText("00");
        TC2.setHorizontalAlignment(0);
        TC2.setFont(new Font(Shutter.freeSansFont, 0, 14));
        TC2.setColumns(10);
        TC2.setBounds(TC1.getX() + 34, TC1.getY(), 32, 21);
        grpOverlay.add(TC2);
        TC3.setName("TC3");
        TC3.setEnabled(false);
        TC3.setText("00");
        TC3.setHorizontalAlignment(0);
        TC3.setFont(new Font(Shutter.freeSansFont, 0, 14));
        TC3.setColumns(10);
        TC3.setBounds(TC2.getX() + 34, TC1.getY(), 32, 21);
        grpOverlay.add(TC3);
        TC4.setName("TC4");
        TC4.setEnabled(false);
        TC4.setText("00");
        TC4.setHorizontalAlignment(0);
        TC4.setFont(new Font(Shutter.freeSansFont, 0, 14));
        TC4.setColumns(10);
        TC4.setBounds(TC3.getX() + 34, TC1.getY(), 32, 21);
        grpOverlay.add(TC4);
        TC1.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (TC1.getText().length() >= 2) {
                    TC1.setText("");
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                timecode.repaint();
            }
        });
        TC2.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (TC2.getText().length() >= 2) {
                    TC2.setText("");
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                timecode.repaint();
            }
        });
        TC3.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (TC3.getText().length() >= 2) {
                    TC3.setText("");
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                timecode.repaint();
            }
        });
        TC4.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (TC4.getText().length() >= 2) {
                    TC4.setText("");
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                timecode.repaint();
            }
        });
        caseShowTimecode.setName("caseShowTimecode");
        caseShowTimecode.setSelected(false);
        caseShowTimecode.setFont(new Font(Shutter.freeSansFont, 0, 12));
        caseShowTimecode.setEnabled(true);
        caseShowTimecode.setSize(VideoPlayer.caseShowTimecode.getPreferredSize().width, 23);
        caseShowTimecode.setLocation(caseAddTimecode.getX(), caseAddTimecode.getY() + caseAddTimecode.getHeight());
        grpOverlay.add(caseShowTimecode);
        caseShowTimecode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (caseShowTimecode.isSelected()) {
                    if (!Utils.inputDeviceIsRunning) {
                        if (FFPROBE.timecode1.equals("")) {
                            MEDIAINFO.run(videoPath, false);
                            do {
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            } while (MEDIAINFO.isRunning);
                        }
                        if (FFPROBE.timecode1.equals("")) {
                            caseShowTimecode.setSelected(false);
                            caseAddTimecode.doClick();
                        } else {
                            TC1.setEnabled(false);
                            TC2.setEnabled(false);
                            TC3.setEnabled(false);
                            TC4.setEnabled(false);
                            caseAddTimecode.setSelected(false);
                            player.add(timecode);
                            if (caseEnableCrop.isSelected()) {
                                player.remove(selection);
                                player.remove(overImage);
                                player.add(selection);
                                player.add(overImage);
                            }
                        }
                    }
                } else {
                    player.remove(timecode);
                }
                VideoPlayer.refreshTimecodeAndText();
                player.repaint();
            }
        });
        JLabel posX = new JLabel(Shutter.language.getProperty("posX"));
        posX.setHorizontalAlignment(2);
        posX.setFont(new Font(Shutter.freeSansFont, 0, 12));
        posX.setForeground(Utils.themeColor);
        posX.setAlignmentX(4.0f);
        posX.setBounds(24, caseShowTimecode.getY() + caseShowTimecode.getHeight() + 6, posX.getPreferredSize().width, 16);
        grpOverlay.add(posX);
        textTcPosX = new JTextField(String.valueOf((Object)Math.round((float)VideoPlayer.timecode.getLocation().x * imageRatio)));
        textTcPosX.setName("textTcPosX");
        textTcPosX.setBounds(posX.getLocation().x + posX.getWidth() + 2, posX.getLocation().y, 34, 16);
        textTcPosX.setHorizontalAlignment(4);
        textTcPosX.setFont(new Font(Shutter.freeSansFont, 0, 12));
        grpOverlay.add(textTcPosX);
        textTcPosX.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (textTcPosX.getText().length() > 0 && e.getKeyCode() == 10) {
                    timecode.setLocation(Math.round((float)Integer.valueOf(textTcPosX.getText()).intValue() / imageRatio), VideoPlayer.timecode.getLocation().y);
                }
                tcLocX = VideoPlayer.timecode.getLocation().x;
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (textTcPosX.getText().length() >= 4) {
                    textTcPosX.setText("");
                }
            }
        });
        textTcPosX.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                textTcPosX.setCursor(Cursor.getPredefinedCursor(2));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                textTcPosX.setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                textTcPosX.setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mousePressed(MouseEvent e) {
                MouseTcPosition.mouseX = e.getX();
                MouseTcPosition.offsetX = Integer.parseInt(textTcPosX.getText());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                tcLocX = VideoPlayer.timecode.getLocation().x;
            }
        });
        textTcPosX.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (textTcPosX.getCursor() == Cursor.getPredefinedCursor(13)) {
                    textTcPosX.setText(String.valueOf(MouseTcPosition.offsetX + (e.getX() - MouseTcPosition.mouseX)));
                    timecode.setLocation(Math.round((float)Integer.valueOf(textTcPosX.getText()).intValue() / imageRatio), VideoPlayer.timecode.getLocation().y);
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        JLabel px1 = new JLabel("px");
        px1.setEnabled(false);
        px1.setFont(new Font(Shutter.freeSansFont, 0, 12));
        px1.setForeground(Utils.themeColor);
        px1.setBounds(VideoPlayer.textTcPosX.getLocation().x + textTcPosX.getWidth() + 2, posX.getY(), px1.getPreferredSize().width, 16);
        grpOverlay.add(px1);
        JLabel posY = new JLabel(Shutter.language.getProperty("posY"));
        posY.setFont(new Font(Shutter.freeSansFont, 0, 12));
        posY.setForeground(Utils.themeColor);
        posY.setAlignmentX(4.0f);
        posY.setBounds(px1.getX() + px1.getWidth() + 30, posX.getLocation().y, posY.getPreferredSize().width, 16);
        grpOverlay.add(posY);
        textTcPosY = new JTextField(String.valueOf((Object)Math.round((float)VideoPlayer.timecode.getLocation().y * imageRatio)));
        textTcPosY.setName("textTcPosY");
        textTcPosY.setBounds(posY.getLocation().x + posY.getWidth() + 2, posY.getLocation().y, 34, 16);
        textTcPosY.setHorizontalAlignment(4);
        textTcPosY.setFont(new Font(Shutter.freeSansFont, 0, 12));
        grpOverlay.add(textTcPosY);
        textTcPosY.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (textTcPosY.getText().length() > 0 && e.getKeyCode() == 10) {
                    timecode.setLocation(VideoPlayer.timecode.getLocation().x, Math.round((float)Integer.valueOf(textTcPosY.getText()).intValue() / imageRatio));
                }
                tcLocY = VideoPlayer.timecode.getLocation().y;
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (textTcPosY.getText().length() >= 4) {
                    textTcPosY.setText("");
                }
            }
        });
        textTcPosY.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                textTcPosY.setCursor(Cursor.getPredefinedCursor(2));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                textTcPosY.setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                textTcPosY.setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mousePressed(MouseEvent e) {
                MouseTcPosition.mouseY = e.getY();
                MouseTcPosition.offsetY = Integer.parseInt(textTcPosY.getText());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                tcLocY = VideoPlayer.timecode.getLocation().y;
            }
        });
        textTcPosY.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (textTcPosY.getCursor() == Cursor.getPredefinedCursor(13)) {
                    textTcPosY.setText(String.valueOf(MouseTcPosition.offsetY + (e.getY() - MouseTcPosition.mouseY)));
                    timecode.setLocation(VideoPlayer.timecode.getLocation().x, Math.round((float)Integer.valueOf(textTcPosY.getText()).intValue() / imageRatio));
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        JLabel px2 = new JLabel("px");
        px2.setEnabled(false);
        px2.setFont(new Font(Shutter.freeSansFont, 0, 12));
        px2.setForeground(Utils.themeColor);
        px2.setBounds(VideoPlayer.textTcPosY.getLocation().x + textTcPosY.getWidth() + 2, posX.getY(), px1.getPreferredSize().width, 16);
        grpOverlay.add(px2);
        JLabel lblSizeTC = new JLabel(Shutter.language.getProperty("lblSize"));
        lblSizeTC.setFont(new Font(Shutter.freeSansFont, 0, 12));
        lblSizeTC.setAlignmentX(4.0f);
        lblSizeTC.setForeground(Utils.themeColor);
        lblSizeTC.setBounds(textTcPosX.getX() - lblSizeTC.getPreferredSize().width - 2, posX.getY() + posX.getHeight() + 6, lblSizeTC.getPreferredSize().width + 2, 16);
        grpOverlay.add(lblSizeTC);
        textTcSize = new JTextField(String.valueOf(Math.round(27.0f * imageRatio)));
        textTcSize.setName("textTcSize");
        textTcSize.setHorizontalAlignment(4);
        textTcSize.setFont(new Font(Shutter.freeSansFont, 0, 11));
        textTcSize.setBounds(VideoPlayer.textTcPosX.getLocation().x, lblSizeTC.getLocation().y, 34, 16);
        grpOverlay.add(textTcSize);
        textTcSize.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                textTcSize.setCursor(Cursor.getPredefinedCursor(2));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                textTcSize.setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                textTcSize.setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mousePressed(MouseEvent e) {
                MouseTcPosition.mouseX = e.getX();
                MouseTcPosition.offsetX = Integer.parseInt(textTcSize.getText());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (textTcSize.getCursor().equals(Cursor.getPredefinedCursor(13))) {
                    frame.requestFocus();
                }
            }
        });
        textTcSize.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                textTcSize.requestFocus();
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (textTcSize.getText().length() > 0 && e.getKeyCode() == 10) {
                    if (Integer.parseInt(textTcSize.getText()) < 5) {
                        textTcSize.setText("5");
                    }
                    timecode.repaint();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (textTcSize.getText().length() >= 3) {
                    textTcSize.setText("");
                }
            }
        });
        textTcSize.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (textTcSize.getText().length() > 0) {
                    int value = MouseTcPosition.offsetX + (e.getX() - MouseTcPosition.mouseX);
                    if (value < 5) {
                        textTcSize.setText("5");
                    } else {
                        textTcSize.setText(String.valueOf(value));
                    }
                    timecode.repaint();
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        JLabel percent1 = new JLabel("%");
        percent1.setEnabled(false);
        percent1.setFont(new Font(Shutter.freeSansFont, 0, 12));
        percent1.setForeground(Utils.themeColor);
        percent1.setBounds(VideoPlayer.textTcSize.getLocation().x + textTcSize.getWidth() + 2, lblSizeTC.getY(), percent1.getPreferredSize().width + 4, 16);
        grpOverlay.add(percent1);
        JLabel lblOpacityTC = new JLabel(Shutter.language.getProperty("lblOpacity"));
        lblOpacityTC.setFont(new Font(Shutter.freeSansFont, 0, 12));
        lblOpacityTC.setAlignmentX(4.0f);
        lblOpacityTC.setForeground(Utils.themeColor);
        lblOpacityTC.setBounds(textTcPosY.getX() - lblOpacityTC.getPreferredSize().width - 2, lblSizeTC.getLocation().y, lblOpacityTC.getPreferredSize().width, 16);
        grpOverlay.add(lblOpacityTC);
        textTcOpacity = new JTextField("50");
        textTcOpacity.setName("textTcOpacity");
        textTcOpacity.setHorizontalAlignment(4);
        textTcOpacity.setFont(new Font(Shutter.freeSansFont, 0, 11));
        textTcOpacity.setBounds(VideoPlayer.textTcPosY.getLocation().x, lblSizeTC.getLocation().y, textTcSize.getWidth(), 16);
        grpOverlay.add(textTcOpacity);
        textTcOpacity.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                textTcOpacity.setCursor(Cursor.getPredefinedCursor(2));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                textTcOpacity.setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                textTcOpacity.setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mousePressed(MouseEvent e) {
                MouseTcPosition.mouseX = e.getX();
                MouseTcPosition.offsetX = Integer.parseInt(textTcOpacity.getText());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        textTcOpacity.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (textTcOpacity.getCursor() == Cursor.getPredefinedCursor(13) && textTcOpacity.getText().length() > 0) {
                    if (Integer.valueOf(textTcOpacity.getText()) > 100) {
                        textTcOpacity.setText("100");
                    } else if (Integer.valueOf(textTcOpacity.getText()) < 1) {
                        textTcOpacity.setText("1");
                    }
                    timecode.repaint();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (textTcOpacity.getText().length() >= 3) {
                    textTcOpacity.setText("");
                }
            }
        });
        textTcOpacity.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (textTcOpacity.getText().length() > 0) {
                    int value = MouseTcPosition.offsetX + (e.getX() - MouseTcPosition.mouseX);
                    if (value > 100) {
                        textTcOpacity.setText("100");
                    } else if (value < 1) {
                        textTcOpacity.setText("1");
                    } else {
                        textTcOpacity.setText(String.valueOf(value));
                    }
                    timecode.repaint();
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        JLabel percent2 = new JLabel("%");
        percent2.setEnabled(false);
        percent2.setFont(new Font(Shutter.freeSansFont, 0, 12));
        percent2.setForeground(Utils.themeColor);
        percent2.setBounds(VideoPlayer.textTcOpacity.getLocation().x + textTcOpacity.getWidth() + 2, lblOpacityTC.getY(), percent1.getPreferredSize().width + 4, 16);
        grpOverlay.add(percent2);
        caseAddText.setName("caseAddText");
        caseAddText.setSelected(false);
        caseAddText.setFont(new Font(Shutter.freeSansFont, 0, 12));
        caseAddText.setSize(VideoPlayer.caseAddText.getPreferredSize().width + 4, 23);
        caseAddText.setLocation(caseAddTimecode.getX(), lblSizeTC.getY() + lblSizeTC.getHeight() + 8);
        grpOverlay.add(caseAddText);
        caseAddText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (caseAddText.isSelected()) {
                    caseShowFileName.setSelected(false);
                    text.setEnabled(true);
                    if (text.getText().length() > 0) {
                        player.add(fileName);
                        if (caseEnableCrop.isSelected()) {
                            player.remove(selection);
                            player.remove(overImage);
                            player.add(selection);
                            player.add(overImage);
                        }
                    }
                } else {
                    text.setEnabled(false);
                    player.remove(fileName);
                }
                VideoPlayer.refreshTimecodeAndText();
                player.repaint();
            }
        });
        text.setName("text");
        text.setEnabled(false);
        text.setLocation(VideoPlayer.caseAddText.getLocation().x + caseAddText.getWidth() + 7, VideoPlayer.caseAddText.getLocation().y + 1);
        text.setSize(grpOverlay.getWidth() - text.getX() - 10, 21);
        text.setHorizontalAlignment(2);
        text.setFont(new Font("SansSerif", 0, 12));
        grpOverlay.add(text);
        text.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                textTime = System.currentTimeMillis();
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == ':' || e.getKeyChar() == '\"' || e.getKeyChar() == '\'' || e.getKeyChar() == ';' || e.getKeyChar() == ',') {
                    e.consume();
                } else if (changeText == null || !changeText.isAlive()) {
                    changeText = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            do {
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            } while (System.currentTimeMillis() - textTime < 500L);
                            player.add(fileName);
                            if (caseEnableCrop.isSelected()) {
                                player.remove(selection);
                                player.remove(overImage);
                                player.add(selection);
                                player.add(overImage);
                            }
                            fileName.repaint();
                        }
                    });
                    changeText.start();
                }
            }
        });
        caseShowFileName.setName("caseShowFileName");
        caseShowFileName.setSelected(false);
        caseShowFileName.setFont(new Font(Shutter.freeSansFont, 0, 12));
        caseShowFileName.setSize(VideoPlayer.caseShowFileName.getPreferredSize().width, 23);
        caseShowFileName.setLocation(caseAddText.getX(), caseAddText.getY() + caseAddText.getHeight());
        grpOverlay.add(caseShowFileName);
        caseShowFileName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (caseShowFileName.isSelected()) {
                    caseAddText.setSelected(false);
                    text.setEnabled(false);
                    player.add(fileName);
                    if (caseEnableCrop.isSelected()) {
                        player.remove(selection);
                        player.remove(overImage);
                        player.add(selection);
                        player.add(overImage);
                    }
                } else {
                    player.remove(fileName);
                }
                VideoPlayer.refreshTimecodeAndText();
                player.repaint();
            }
        });
        fileName = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                if (caseShowFileName.isSelected() || caseAddText.isSelected() && text.getText().length() > 0) {
                    super.paintComponent(g);
                    Graphics2D g2 = (Graphics2D)g;
                    boolean resetLocation = false;
                    if (this.getWidth() == 1) {
                        resetLocation = true;
                    }
                    int width = this.getWidth();
                    int height = this.getHeight();
                    g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    Font font = new Font(comboOverlayFont.getSelectedItem().toString(), 0, Math.round((float)Integer.parseInt(textNameSize.getText()) / imageRatio));
                    font.deriveFont((float)Integer.parseInt(textNameSize.getText()) / imageRatio);
                    g2.setFont(font);
                    String file = videoPath;
                    if (Shutter.scanIsRunning) {
                        File dir = new File(Shutter.liste.firstElement());
                        File[] fileArray = dir.listFiles();
                        int n = fileArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File f = fileArray[n2];
                            if (!f.isHidden() && f.isFile()) {
                                file = f.toString();
                                break;
                            }
                            ++n2;
                        }
                    }
                    String ext = file.substring(file.lastIndexOf("."));
                    String str = new File(file).getName().replace(ext, "");
                    if (caseAddText.isSelected()) {
                        str = text.getText();
                    }
                    Rectangle bounds = this.getStringBounds(g2, str, 0.0f, 0.0f);
                    if (lblTcBackground.getText().equals(Shutter.language.getProperty("lblBackgroundOn"))) {
                        g2.setColor(new Color(backgroundColor.getRed(), backgroundColor.getGreen(), backgroundColor.getBlue(), (int)((float)(Integer.parseInt(textNameOpacity.getText()) * 255) / 100.0f)));
                    } else {
                        g2.setColor(new Color(0, 0, 0, 0));
                    }
                    GraphicsConfiguration gfxConfig = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
                    AffineTransform transform = gfxConfig.getDefaultTransform();
                    if (System.getProperty("os.name").contains("Mac") && !transform.isIdentity()) {
                        g2.fillRect(0, 0, bounds.width, bounds.height / 2);
                    } else {
                        g2.fillRect(0, 0, bounds.width, bounds.height);
                    }
                    if (lblTcBackground.getText().equals(Shutter.language.getProperty("aucun"))) {
                        g2.setColor(new Color(foregroundColor.getRed(), foregroundColor.getGreen(), foregroundColor.getBlue(), (int)((float)(Integer.parseInt(textNameOpacity.getText()) * 255) / 100.0f)));
                    } else {
                        g2.setColor(foregroundColor);
                    }
                    if (System.getProperty("os.name").contains("Mac") && !transform.isIdentity()) {
                        Integer offset = bounds.height + (int)bounds.getY();
                        g2.drawString(str, -2, bounds.height / 2 - offset / 2);
                    } else {
                        Integer offset = bounds.height + (int)bounds.getY();
                        g2.drawString(str, -2, bounds.height - offset);
                    }
                    fileName.setSize(bounds.width, bounds.height);
                    if (resetLocation) {
                        fileName.setLocation(player.getWidth() / 2 - fileName.getWidth() / 2, player.getHeight() - fileName.getHeight() - fileName.getHeight() / 2);
                        fileLocX = VideoPlayer.fileName.getLocation().x;
                        fileLocY = VideoPlayer.fileName.getLocation().y;
                    } else if (textNameSize.hasFocus()) {
                        fileName.setLocation(fileName.getX() + (width - fileName.getWidth()) / 2, fileName.getY() + (height - fileName.getHeight()) / 2);
                        fileLocX = VideoPlayer.fileName.getLocation().x;
                        fileLocY = VideoPlayer.fileName.getLocation().y;
                    }
                    VideoPlayer.refreshTimecodeAndText();
                }
            }

            private Rectangle getStringBounds(Graphics2D g2, String str, float x, float y) {
                FontRenderContext frc = g2.getFontRenderContext();
                GlyphVector gv = g2.getFont().createGlyphVector(frc, str);
                return gv.getPixelBounds(null, x, y);
            }
        };
        fileName.setSize(1, 1);
        fileName.setLayout(null);
        fileName.setOpaque(false);
        fileName.setBackground(new Color(0, 0, 0, 0));
        fileName.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    fileName.setLocation(player.getWidth() / 2 - fileName.getWidth() / 2, player.getHeight() - fileName.getHeight() - fileName.getHeight() / 2);
                    VideoPlayer.refreshTimecodeAndText();
                    fileLocX = VideoPlayer.fileName.getLocation().x;
                    fileLocY = VideoPlayer.fileName.getLocation().y;
                }
                filePosX = e.getLocationOnScreen().x;
                filePosY = e.getLocationOnScreen().y;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                fileLocX = VideoPlayer.fileName.getLocation().x;
                fileLocY = VideoPlayer.fileName.getLocation().y;
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                frame.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        fileName.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                fileName.setLocation(MouseInfo.getPointerInfo().getLocation().x - filePosX + fileLocX, MouseInfo.getPointerInfo().getLocation().y - filePosY + fileLocY);
                textNamePosX.setText(String.valueOf(Math.round((float)VideoPlayer.fileName.getLocation().x * imageRatio)));
                textNamePosY.setText(String.valueOf(Math.round((float)VideoPlayer.fileName.getLocation().y * imageRatio)));
            }

            @Override
            public void mouseMoved(MouseEvent arg0) {
            }
        });
        JLabel posX2 = new JLabel(Shutter.language.getProperty("posX"));
        posX2.setHorizontalAlignment(2);
        posX2.setFont(new Font(Shutter.freeSansFont, 0, 12));
        posX2.setForeground(Utils.themeColor);
        posX2.setAlignmentX(4.0f);
        posX2.setBounds(posX.getX(), caseShowFileName.getY() + caseShowFileName.getHeight() + 6, posX.getWidth(), 16);
        grpOverlay.add(posX2);
        textNamePosX = new JTextField(String.valueOf((Object)Math.round((float)VideoPlayer.fileName.getLocation().x * imageRatio)));
        textNamePosX.setName("textNamePosX");
        textNamePosX.setBounds(posX2.getLocation().x + posX2.getWidth() + 2, posX2.getLocation().y, 34, 16);
        textNamePosX.setHorizontalAlignment(4);
        textNamePosX.setFont(new Font(Shutter.freeSansFont, 0, 12));
        grpOverlay.add(textNamePosX);
        textNamePosX.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (textNamePosX.getText().length() > 0 && e.getKeyCode() == 10) {
                    fileName.setLocation(Math.round((float)Integer.valueOf(textNamePosX.getText()).intValue() / imageRatio), VideoPlayer.fileName.getLocation().y);
                }
                fileLocX = VideoPlayer.fileName.getLocation().x;
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (textNamePosX.getText().length() >= 4) {
                    textNamePosX.setText("");
                }
            }
        });
        textNamePosX.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                textNamePosX.setCursor(Cursor.getPredefinedCursor(2));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                textNamePosX.setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                textNamePosX.setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mousePressed(MouseEvent e) {
                MouseNamePosition.mouseX = e.getX();
                MouseNamePosition.offsetX = Integer.parseInt(textNamePosX.getText());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                fileLocX = VideoPlayer.fileName.getLocation().x;
            }
        });
        textNamePosX.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (textNamePosX.getCursor() == Cursor.getPredefinedCursor(13)) {
                    textNamePosX.setText(String.valueOf(MouseNamePosition.offsetX + (e.getX() - MouseNamePosition.mouseX)));
                    fileName.setLocation(Math.round((float)Integer.valueOf(textNamePosX.getText()).intValue() / imageRatio), VideoPlayer.fileName.getLocation().y);
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        JLabel px3 = new JLabel("px");
        px3.setEnabled(false);
        px3.setFont(new Font(Shutter.freeSansFont, 0, 12));
        px3.setForeground(Utils.themeColor);
        px3.setBounds(VideoPlayer.textNamePosX.getLocation().x + textNamePosX.getWidth() + 2, posX2.getY(), px1.getPreferredSize().width, 16);
        grpOverlay.add(px3);
        JLabel posY2 = new JLabel(Shutter.language.getProperty("posY"));
        posY2.setFont(new Font(Shutter.freeSansFont, 0, 12));
        posY2.setForeground(Utils.themeColor);
        posY2.setAlignmentX(4.0f);
        posY2.setBounds(px3.getX() + px3.getWidth() + 30, posX2.getLocation().y, posX.getWidth(), 16);
        grpOverlay.add(posY2);
        textNamePosY = new JTextField(String.valueOf((Object)Math.round((float)VideoPlayer.fileName.getLocation().y * imageRatio)));
        textNamePosY.setName("textNamePosY");
        textNamePosY.setBounds(posY2.getLocation().x + posY2.getWidth() + 2, posY2.getLocation().y, 34, 16);
        textNamePosY.setHorizontalAlignment(4);
        textNamePosY.setFont(new Font(Shutter.freeSansFont, 0, 12));
        grpOverlay.add(textNamePosY);
        textNamePosY.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (textNamePosY.getText().length() > 0 && e.getKeyCode() == 10) {
                    fileName.setLocation(VideoPlayer.fileName.getLocation().x, Math.round((float)Integer.valueOf(textNamePosY.getText()).intValue() / imageRatio));
                }
                fileLocY = VideoPlayer.fileName.getLocation().y;
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (textNamePosY.getText().length() >= 4) {
                    textNamePosY.setText("");
                }
            }
        });
        textNamePosY.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                textNamePosY.setCursor(Cursor.getPredefinedCursor(2));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                textNamePosY.setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                textNamePosY.setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mousePressed(MouseEvent e) {
                MouseNamePosition.mouseY = e.getY();
                MouseNamePosition.offsetY = Integer.parseInt(textNamePosY.getText());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                fileLocY = VideoPlayer.fileName.getLocation().y;
            }
        });
        textNamePosY.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (textNamePosY.getCursor() == Cursor.getPredefinedCursor(13)) {
                    textNamePosY.setText(String.valueOf(MouseNamePosition.offsetY + (e.getY() - MouseNamePosition.mouseY)));
                    fileName.setLocation(VideoPlayer.fileName.getLocation().x, Math.round((float)Integer.valueOf(textNamePosY.getText()).intValue() / imageRatio));
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        JLabel px4 = new JLabel("px");
        px4.setEnabled(false);
        px4.setFont(new Font(Shutter.freeSansFont, 0, 12));
        px4.setForeground(Utils.themeColor);
        px4.setBounds(VideoPlayer.textNamePosY.getLocation().x + textNamePosY.getWidth() + 2, posY2.getY(), px1.getPreferredSize().width, 16);
        grpOverlay.add(px4);
        JLabel lblSizeName = new JLabel(Shutter.language.getProperty("lblSize"));
        lblSizeName.setFont(new Font(Shutter.freeSansFont, 0, 12));
        lblSizeName.setAlignmentX(4.0f);
        lblSizeName.setForeground(Utils.themeColor);
        lblSizeName.setBounds(lblSizeTC.getX(), posX2.getY() + posX2.getHeight() + 6, lblSizeTC.getWidth(), 16);
        grpOverlay.add(lblSizeName);
        textNameSize = new JTextField(String.valueOf(Math.round(27.0f * imageRatio)));
        textNameSize.setName("textNameSize");
        textNameSize.setHorizontalAlignment(4);
        textNameSize.setFont(new Font(Shutter.freeSansFont, 0, 11));
        textNameSize.setBounds(VideoPlayer.textNamePosX.getLocation().x, lblSizeName.getLocation().y, textNamePosX.getWidth(), 16);
        grpOverlay.add(textNameSize);
        textNameSize.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                textNameSize.setCursor(Cursor.getPredefinedCursor(2));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                textNameSize.setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                textNameSize.setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mousePressed(MouseEvent e) {
                MouseNamePosition.mouseX = e.getX();
                MouseNamePosition.offsetX = Integer.parseInt(textNameSize.getText());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (textNameSize.getCursor().equals(Cursor.getPredefinedCursor(13))) {
                    frame.requestFocus();
                }
            }
        });
        textNameSize.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                textNameSize.requestFocus();
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (textNameSize.getText().length() > 0 && e.getKeyCode() == 10) {
                    if (Integer.parseInt(textNameSize.getText()) < 5) {
                        textNameSize.setText("5");
                    }
                    fileName.repaint();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (textNameSize.getText().length() >= 3) {
                    textNameSize.setText("");
                }
            }
        });
        textNameSize.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (textNameSize.getText().length() > 0) {
                    int value = MouseNamePosition.offsetX + (e.getX() - MouseNamePosition.mouseX);
                    if (value < 5) {
                        textNameSize.setText("5");
                    } else {
                        textNameSize.setText(String.valueOf(value));
                    }
                    fileName.repaint();
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        JLabel percent3 = new JLabel("%");
        percent3.setEnabled(false);
        percent3.setFont(new Font(Shutter.freeSansFont, 0, 12));
        percent3.setForeground(Utils.themeColor);
        percent3.setBounds(VideoPlayer.textNameSize.getLocation().x + textNameSize.getWidth() + 2, lblSizeName.getY(), percent1.getPreferredSize().width, 16);
        grpOverlay.add(percent3);
        JLabel lblOpacityName = new JLabel(Shutter.language.getProperty("lblOpacity"));
        lblOpacityName.setFont(new Font(Shutter.freeSansFont, 0, 12));
        lblOpacityName.setAlignmentX(4.0f);
        lblOpacityName.setForeground(Utils.themeColor);
        lblOpacityName.setBounds(lblOpacityTC.getX(), lblSizeName.getLocation().y, lblOpacityTC.getWidth(), 16);
        grpOverlay.add(lblOpacityName);
        textNameOpacity = new JTextField("50");
        textNameOpacity.setName("spinnerNameOpacity");
        textNameOpacity.setHorizontalAlignment(4);
        textNameOpacity.setFont(new Font(Shutter.freeSansFont, 0, 11));
        textNameOpacity.setBounds(textNamePosY.getX(), lblSizeName.getLocation().y, textNameSize.getWidth(), 16);
        grpOverlay.add(textNameOpacity);
        textNameOpacity.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                textNameOpacity.setCursor(Cursor.getPredefinedCursor(2));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                textNameOpacity.setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                textNameOpacity.setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mousePressed(MouseEvent e) {
                MouseNamePosition.mouseX = e.getX();
                MouseNamePosition.offsetX = Integer.parseInt(textNameOpacity.getText());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        textNameOpacity.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (textNameOpacity.getCursor() == Cursor.getPredefinedCursor(13) && textNameOpacity.getText().length() > 0) {
                    if (Integer.valueOf(textNameOpacity.getText()) > 100) {
                        textNameOpacity.setText("100");
                    } else if (Integer.valueOf(textNameOpacity.getText()) < 1) {
                        textNameOpacity.setText("1");
                    }
                    fileName.repaint();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (textNameOpacity.getText().length() >= 3) {
                    textNameOpacity.setText("");
                }
            }
        });
        textNameOpacity.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (textNameOpacity.getText().length() > 0) {
                    int value = MouseNamePosition.offsetX + (e.getX() - MouseNamePosition.mouseX);
                    if (value > 100) {
                        textNameOpacity.setText("100");
                    } else if (value < 1) {
                        textNameOpacity.setText("1");
                    } else {
                        textNameOpacity.setText(String.valueOf(value));
                    }
                    fileName.repaint();
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        JLabel percent4 = new JLabel("%");
        percent4.setEnabled(false);
        percent4.setFont(new Font(Shutter.freeSansFont, 0, 12));
        percent4.setForeground(Utils.themeColor);
        percent4.setBounds(VideoPlayer.textNameOpacity.getLocation().x + textNameOpacity.getWidth() + 2, lblOpacityName.getY(), percent1.getPreferredSize().width, 16);
        grpOverlay.add(percent4);
    }

    private static void refreshTimecodeAndText() {
        String c;
        if (foregroundColor != null) {
            c = Integer.toHexString(foregroundColor.getRGB()).substring(2);
            foregroundHex = String.valueOf(c.substring(0, 2)) + c.substring(2, 4) + c.substring(4, 6);
        } else {
            foregroundColor = new Color(255, 255, 255);
        }
        if (backgroundColor != null) {
            c = Integer.toHexString(backgroundColor.getRGB()).substring(2);
            backgroundHex = String.valueOf(c.substring(0, 2)) + c.substring(2, 4) + c.substring(4, 6);
        } else {
            backgroundColor = new Color(0, 0, 0);
        }
        if (lblTcBackground.getText().equals(Shutter.language.getProperty("lblBackgroundOn"))) {
            backgroundTcAlpha = Integer.toHexString((int)((float)(Integer.parseInt(textTcOpacity.getText()) * 255)) / 100);
            foregroundTcAlpha = "ff";
            backgroundNameAlpha = Integer.toHexString((int)((float)(Integer.parseInt(textNameOpacity.getText()) * 255)) / 100);
            foregroundNameAlpha = "ff";
        } else {
            backgroundTcAlpha = "0";
            foregroundTcAlpha = Integer.toHexString((int)((float)(Integer.parseInt(textTcOpacity.getText()) * 255)) / 100);
            backgroundNameAlpha = "0";
            foregroundNameAlpha = Integer.toHexString((int)((float)(Integer.parseInt(textNameOpacity.getText()) * 255)) / 100);
        }
        if (backgroundTcAlpha.length() < 2) {
            backgroundTcAlpha = "0" + backgroundTcAlpha;
        }
        if (foregroundTcAlpha.length() < 2) {
            foregroundTcAlpha = "0" + foregroundTcAlpha;
        }
        if (backgroundNameAlpha.length() < 2) {
            backgroundNameAlpha = "0" + backgroundNameAlpha;
        }
        if (foregroundNameAlpha.length() < 2) {
            foregroundNameAlpha = "0" + foregroundNameAlpha;
        }
        if (caseAddTimecode.isSelected() || caseShowTimecode.isSelected()) {
            textTcPosX.setText(String.valueOf(Math.round((float)VideoPlayer.timecode.getLocation().x * imageRatio)));
            textTcPosY.setText(String.valueOf(Math.round((float)VideoPlayer.timecode.getLocation().y * imageRatio)));
        } else {
            textTcPosX.setText("0");
            textTcPosY.setText("0");
        }
        if (caseShowFileName.isSelected() || caseAddText.isSelected()) {
            textNamePosX.setText(String.valueOf(Math.round((float)VideoPlayer.fileName.getLocation().x * imageRatio)));
            textNamePosY.setText(String.valueOf(Math.round((float)VideoPlayer.fileName.getLocation().y * imageRatio)));
        } else {
            textNamePosX.setText("0");
            textNamePosY.setText("0");
        }
    }

    private void grpSubtitles() {
        grpSubtitles = new JPanel();
        grpSubtitles.setLayout(null);
        grpSubtitles.setBorder(BorderFactory.createTitledBorder(new RoundedLineBorder(new Color(65, 65, 65), 1, 5, true), String.valueOf(Shutter.language.getProperty("caseSubtitles")) + " ", 0, 0, new Font(Shutter.montserratFont, 0, 12), Color.WHITE));
        grpSubtitles.setBackground(new Color(45, 45, 45));
        grpSubtitles.setSize(grpCrop.getWidth(), 17);
        grpSubtitles.setLocation(frame.getWidth() - grpSubtitles.getWidth() - 6, grpOverlay.getY() + grpOverlay.getHeight() + 6);
        frame.getContentPane().add(grpSubtitles);
        grpSubtitles.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int sized = 131;
                if (VideoPlayer.grpSubtitles.getSize().height < 131) {
                    Thread changeSize = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                long startTime;
                                int i = 17;
                                do {
                                    startTime = System.currentTimeMillis() + 1L;
                                    i = Settings.btnDisableAnimations.isSelected() ? 131 : ++i;
                                    grpSubtitles.setSize(grpSubtitles.getWidth(), i);
                                    grpWatermark.setLocation(VideoPlayer.grpSubtitles.getLocation().x, VideoPlayer.grpSubtitles.getSize().height + VideoPlayer.grpSubtitles.getLocation().y + 6);
                                    if (grpWatermark.getY() + grpWatermark.getHeight() >= grpOut.getY() - 6) {
                                        grpOverlay.setSize(grpOverlay.getWidth(), grpOverlay.getHeight() - 1);
                                        grpSubtitles.setLocation(VideoPlayer.grpOverlay.getLocation().x, VideoPlayer.grpOverlay.getSize().height + VideoPlayer.grpOverlay.getLocation().y + 6);
                                        grpWatermark.setLocation(VideoPlayer.grpSubtitles.getLocation().x, VideoPlayer.grpSubtitles.getSize().height + VideoPlayer.grpSubtitles.getLocation().y + 6);
                                    }
                                    Shutter.animateSections(startTime);
                                } while (i < 131);
                                if (grpOverlay.getHeight() > 17 && grpOverlay.getHeight() < 278) {
                                    i = grpOverlay.getHeight();
                                    do {
                                        startTime = System.currentTimeMillis() + 1L;
                                        i = Settings.btnDisableAnimations.isSelected() ? 17 : --i;
                                        grpOverlay.setSize(grpOverlay.getWidth(), i);
                                        grpSubtitles.setLocation(VideoPlayer.grpOverlay.getLocation().x, VideoPlayer.grpOverlay.getSize().height + VideoPlayer.grpOverlay.getLocation().y + 6);
                                        grpWatermark.setLocation(VideoPlayer.grpSubtitles.getLocation().x, VideoPlayer.grpSubtitles.getSize().height + VideoPlayer.grpSubtitles.getLocation().y + 6);
                                        Shutter.animateSections(startTime);
                                    } while (i > 17);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                    changeSize.start();
                } else {
                    Thread changeSize = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                int i = 131;
                                do {
                                    long startTime = System.currentTimeMillis() + 1L;
                                    i = Settings.btnDisableAnimations.isSelected() ? 17 : --i;
                                    grpSubtitles.setSize(grpSubtitles.getWidth(), i);
                                    grpWatermark.setLocation(VideoPlayer.grpSubtitles.getLocation().x, VideoPlayer.grpSubtitles.getSize().height + VideoPlayer.grpSubtitles.getLocation().y + 6);
                                    Shutter.animateSections(startTime);
                                } while (i > 17);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                    changeSize.start();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        caseAddSubtitles.setName("caseAddSubtitles");
        caseAddSubtitles.setBounds(8, 16, VideoPlayer.caseAddSubtitles.getPreferredSize().width + 8, 23);
        caseAddSubtitles.setFont(new Font(Shutter.freeSansFont, 0, 12));
        caseAddSubtitles.setSelected(false);
        grpSubtitles.add(caseAddSubtitles);
        caseAddSubtitles.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (caseAddSubtitles.isSelected()) {
                    if (Shutter.comboFonctions.getSelectedItem().toString().equals(Shutter.language.getProperty("functionRewrap"))) {
                        Shutter.casePreserveSubs.setSelected(false);
                    }
                    if (Shutter.comboFonctions.getSelectedItem().toString().equals(Shutter.language.getProperty("functionSubtitles"))) {
                        Shutter.subtitlesFile = System.getProperty("os.name").contains("Windows") ? new File(SubtitlesTimeline.srt.getName()) : new File(String.valueOf(Shutter.dirTemp) + SubtitlesTimeline.srt.getName());
                        Object[] options = new Object[]{Shutter.language.getProperty("subtitlesBurn"), Shutter.language.getProperty("subtitlesEmbed")};
                        int sub = JOptionPane.showOptionDialog(frame, Shutter.language.getProperty("chooseSubsIntegration"), Shutter.language.getProperty("caseSubtitles"), 1, 3, null, options, options[0]);
                        if (sub == 0) {
                            Shutter.comboFonctions.setModel(new DefaultComboBoxModel<String>(Shutter.functionsList));
                            Shutter.comboFonctions.setSelectedItem("H.264");
                            lblVideo.setText("");
                            VideoPlayer.setMedia();
                            Shutter.caseInAndOut.doClick();
                            caseAddSubtitles.setSelected(true);
                            Shutter.subtitlesBurn = true;
                            subtitlesFile = SubtitlesTimeline.srt;
                            this.writeSub(subtitlesFile.toString(), StandardCharsets.UTF_8);
                            subsCanvas.setSize((int)((float)Integer.parseInt(textSubsWidth.getText()) / ((float)FFPROBE.imageHeight / (float)player.getHeight())), (int)((float)player.getHeight() + (float)Integer.parseInt(textSubtitlesPosition.getText()) / ((float)FFPROBE.imageHeight / (float)player.getHeight())));
                            subsCanvas.setLocation((player.getWidth() - subsCanvas.getWidth()) / 2, 0);
                            player.add(subsCanvas);
                            grpSubtitles.setSize(grpSubtitles.getWidth(), 131);
                            grpWatermark.setLocation(VideoPlayer.grpSubtitles.getLocation().x, VideoPlayer.grpSubtitles.getSize().height + VideoPlayer.grpSubtitles.getLocation().y + 6);
                            if (grpWatermark.getY() + grpWatermark.getHeight() >= grpOut.getY() - 6) {
                                grpOverlay.setSize(grpOverlay.getWidth(), grpOverlay.getHeight() - 1);
                                grpSubtitles.setLocation(VideoPlayer.grpOverlay.getLocation().x, VideoPlayer.grpOverlay.getSize().height + VideoPlayer.grpOverlay.getLocation().y + 6);
                                grpWatermark.setLocation(VideoPlayer.grpSubtitles.getLocation().x, VideoPlayer.grpSubtitles.getSize().height + VideoPlayer.grpSubtitles.getLocation().y + 6);
                            }
                            Component[] componentArray = grpSubtitles.getComponents();
                            int n = componentArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Component c = componentArray[n2];
                                c.setEnabled(true);
                                ++n2;
                            }
                        } else {
                            Shutter.subtitlesBurn = false;
                            subtitlesFile = new File(SubtitlesTimeline.srt.toString());
                            Shutter.changeSections(false);
                            Shutter.caseDisplay.setSelected(false);
                            Thread copySRT = new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    block18: {
                                        try {
                                            try {
                                                Shutter.disableAll();
                                                File fileIn = new File(videoPath);
                                                String extension = videoPath.toString().substring(fileIn.toString().lastIndexOf("."));
                                                File fileOut = new File(fileIn.toString().replace(extension, "_subs" + extension));
                                                String cmd = " -c copy -c:s mov_text -map v:0? -map a? -map 1:s -y ";
                                                if (extension.equals(".mkv")) {
                                                    cmd = " -c copy -c:s srt -map v:0? -map a? -map 1:s -y ";
                                                }
                                                FFMPEG.run(" -i \"" + fileIn + '\"' + " -i " + '\"' + subtitlesFile + '\"' + cmd + '\"' + fileOut + '\"');
                                                Shutter.lblCurrentEncoding.setForeground(Color.LIGHT_GRAY);
                                                Shutter.lblCurrentEncoding.setText(fileIn.getName());
                                                do {
                                                    Thread.sleep(10L);
                                                } while (FFMPEG.runProcess.isAlive());
                                                if (FFMPEG.error || fileOut.length() == 0L) {
                                                    FFMPEG.errorList.append(fileIn.getName());
                                                    FFMPEG.errorList.append(System.lineSeparator());
                                                    fileOut.delete();
                                                }
                                                if (Shutter.cancelled) {
                                                    fileOut.delete();
                                                }
                                                if (!Shutter.cancelled && !FFMPEG.error) {
                                                    Shutter.lblFilesEnded.setText(FunctionUtils.completedFiles(1));
                                                }
                                                if (!Shutter.caseOpenFolderAtEnd1.isSelected() || Shutter.cancelled || FFMPEG.error) break block18;
                                                if (System.getProperty("os.name").contains("Mac")) {
                                                    try {
                                                        Runtime.getRuntime().exec(new String[]{"/usr/bin/open", "-R", fileOut.toString()});
                                                    }
                                                    catch (Exception exception) {}
                                                    break block18;
                                                }
                                                if (System.getProperty("os.name").contains("Linux")) {
                                                    try {
                                                        Desktop.getDesktop().open(fileOut);
                                                    }
                                                    catch (Exception exception) {}
                                                    break block18;
                                                }
                                                try {
                                                    Runtime.getRuntime().exec("explorer.exe /select," + fileOut.toString());
                                                }
                                                catch (IOException iOException) {
                                                }
                                            }
                                            catch (Exception exception) {
                                                Shutter.enfOfFunction();
                                            }
                                        }
                                        finally {
                                            Shutter.enfOfFunction();
                                        }
                                    }
                                }
                            });
                            copySRT.start();
                        }
                    } else {
                        File video = new File(Shutter.liste.elementAt(0).toString());
                        String ext = video.toString().substring(video.toString().lastIndexOf("."));
                        FileDialog dialog = new FileDialog((Frame)frame, Shutter.language.getProperty("chooseSubtitles"), 0);
                        char slash = '/';
                        if (System.getProperty("os.name").contains("Windows")) {
                            slash = '\\';
                        }
                        if (new File(video.toString().replace(ext, ".srt")).exists()) {
                            dialog.setDirectory(String.valueOf(video.getParent()) + slash);
                            dialog.setFile(video.getName().replace(ext, ".srt"));
                        } else if (new File(video.toString().replace(ext, ".vtt")).exists()) {
                            dialog.setDirectory(String.valueOf(video.getParent()) + slash);
                            dialog.setFile(video.getName().replace(ext, ".vtt"));
                        } else if (new File(video.toString().replace(ext, ".ass")).exists()) {
                            dialog.setDirectory(String.valueOf(video.getParent()) + slash);
                            dialog.setFile(video.getName().replace(ext, ".ass"));
                        } else if (new File(video.toString().replace(ext, ".ssa")).exists()) {
                            dialog.setDirectory(String.valueOf(video.getParent()) + slash);
                            dialog.setFile(video.getName().replace(ext, ".ssa"));
                        } else if (new File(video.toString().replace(ext, ".scc")).exists()) {
                            dialog.setDirectory(String.valueOf(video.getParent()) + slash);
                            dialog.setFile(video.getName().replace(ext, ".scc"));
                        } else {
                            dialog.setDirectory(new File(videoPath).getParent());
                            dialog.setFile("*.srt;*.vtt;*.ass;*.ssa;*.scc");
                            dialog.setLocation(VideoPlayer.frame.getLocation().x - 50, VideoPlayer.frame.getLocation().y + 50);
                            dialog.setAlwaysOnTop(true);
                            dialog.setMultipleMode(false);
                            dialog.setVisible(true);
                        }
                        if (dialog.getFile() != null) {
                            String input = dialog.getFile().substring(dialog.getFile().lastIndexOf("."));
                            if (input.equals(".srt") || input.equals(".vtt") || input.equals(".ssa") || input.equals(".ass") || input.equals(".scc")) {
                                Shutter.subtitlesFile = System.getProperty("os.name").contains("Windows") ? new File(dialog.getFile()) : new File(String.valueOf(Shutter.dirTemp) + dialog.getFile());
                                if (input.equals(".srt") || input.equals(".vtt")) {
                                    Object[] options = new Object[]{Shutter.language.getProperty("subtitlesBurn"), Shutter.language.getProperty("subtitlesEmbed")};
                                    int sub = 0;
                                    if (Shutter.comboFonctions.getSelectedItem().toString().equals(Shutter.language.getProperty("functionRewrap"))) {
                                        sub = 1;
                                    }
                                    if (!(Shutter.comboFilter.getSelectedItem().toString().equals(".mxf") || Shutter.comboFonctions.getSelectedItem().toString().equals("XAVC") || Shutter.caseCreateOPATOM.isSelected() || Shutter.comboFonctions.getSelectedItem().toString().equals(Shutter.language.getProperty("functionRewrap")))) {
                                        sub = JOptionPane.showOptionDialog(frame, Shutter.language.getProperty("chooseSubsIntegration"), Shutter.language.getProperty("caseAddSubtitles"), 1, 3, null, options, options[0]);
                                    }
                                    if (sub == 0) {
                                        Shutter.subtitlesBurn = true;
                                        if (input.equals(".vtt")) {
                                            Shutter.subtitlesFile = new File(subtitlesFile.toString().replace(".vtt", ".srt"));
                                            FFMPEG.run(" -i \"" + dialog.getDirectory() + dialog.getFile().toString() + '\"' + " -y " + '\"' + subtitlesFile.toString().replace(".srt", "_vtt.srt") + '\"');
                                            do {
                                                try {
                                                    Thread.sleep(10L);
                                                }
                                                catch (InterruptedException interruptedException) {
                                                    // empty catch block
                                                }
                                            } while (FFMPEG.runProcess.isAlive());
                                            Shutter.enableAll();
                                            subtitlesFile = new File(subtitlesFile.toString().replace(".srt", "_vtt.srt"));
                                        } else {
                                            subtitlesFile = new File(String.valueOf(dialog.getDirectory()) + dialog.getFile().toString());
                                        }
                                        this.writeSub(subtitlesFile.toString(), StandardCharsets.UTF_8);
                                        subsCanvas.setSize((int)((float)Integer.parseInt(textSubsWidth.getText()) / ((float)FFPROBE.imageHeight / (float)player.getHeight())), (int)((float)player.getHeight() + (float)Integer.parseInt(textSubtitlesPosition.getText()) / ((float)FFPROBE.imageHeight / (float)player.getHeight())));
                                        subsCanvas.setLocation((player.getWidth() - subsCanvas.getWidth()) / 2, 0);
                                        player.add(subsCanvas);
                                        Component[] componentArray = grpSubtitles.getComponents();
                                        int n = componentArray.length;
                                        int n3 = 0;
                                        while (n3 < n) {
                                            Component c = componentArray[n3];
                                            c.setEnabled(true);
                                            ++n3;
                                        }
                                    } else {
                                        SubtitlesEmbed.subtitlesFile1.setText(String.valueOf(dialog.getDirectory()) + dialog.getFile().toString());
                                        if (SubtitlesEmbed.frame == null) {
                                            new SubtitlesEmbed();
                                        } else {
                                            Utils.changeDialogVisibility(SubtitlesEmbed.frame, false);
                                        }
                                        Shutter.subtitlesBurn = false;
                                        Shutter.changeSections(false);
                                        Shutter.caseDisplay.setSelected(false);
                                        if (caseAddSubtitles.isSelected()) {
                                            Component[] componentArray = grpSubtitles.getComponents();
                                            int n = componentArray.length;
                                            int n4 = 0;
                                            while (n4 < n) {
                                                Component c = componentArray[n4];
                                                if (!(c instanceof JCheckBox)) {
                                                    c.setEnabled(false);
                                                }
                                                ++n4;
                                            }
                                        }
                                        JOptionPane.showMessageDialog(frame, Shutter.language.getProperty("previewNotAvailable"), Shutter.language.getProperty("caseSubtitles"), 1);
                                    }
                                    sliderSpeed.setEnabled(false);
                                    sliderSpeed.setValue(2);
                                    lblSpeed.setText(String.valueOf(Shutter.language.getProperty("conformBySpeed")) + " x1");
                                    lblSpeed.setBounds(sliderSpeed.getX() - VideoPlayer.lblSpeed.getPreferredSize().width - 2, sliderSpeed.getY() + 2, VideoPlayer.lblSpeed.getPreferredSize().width, 16);
                                } else {
                                    Object[] options = new Object[]{Shutter.language.getProperty("subtitlesBurn"), Shutter.language.getProperty("subtitlesEmbed")};
                                    int sub = 0;
                                    if (!(Shutter.comboFilter.getSelectedItem().toString().equals(".mxf") || Shutter.comboFonctions.getSelectedItem().toString().equals("XAVC") || Shutter.caseCreateOPATOM.isSelected())) {
                                        sub = JOptionPane.showOptionDialog(frame, Shutter.language.getProperty("chooseSubsIntegration"), Shutter.language.getProperty("caseAddSubtitles"), 1, 3, null, options, options[0]);
                                    }
                                    if (sub == 0) {
                                        Shutter.subtitlesBurn = true;
                                        try {
                                            FileUtils.copyFile(new File(String.valueOf(dialog.getDirectory()) + dialog.getFile().toString()), Shutter.subtitlesFile);
                                        }
                                        catch (IOException c) {}
                                    } else {
                                        SubtitlesEmbed.subtitlesFile1.setText(String.valueOf(dialog.getDirectory()) + dialog.getFile().toString());
                                        if (SubtitlesEmbed.frame == null) {
                                            new SubtitlesEmbed();
                                        } else {
                                            Utils.changeDialogVisibility(SubtitlesEmbed.frame, false);
                                        }
                                        Shutter.subtitlesBurn = false;
                                        Shutter.changeSections(false);
                                        Shutter.caseDisplay.setSelected(false);
                                    }
                                    Component[] componentArray = grpSubtitles.getComponents();
                                    int n = componentArray.length;
                                    int n5 = 0;
                                    while (n5 < n) {
                                        Component c = componentArray[n5];
                                        if (!(c instanceof JCheckBox)) {
                                            c.setEnabled(false);
                                        }
                                        ++n5;
                                    }
                                    JOptionPane.showMessageDialog(frame, Shutter.language.getProperty("previewNotAvailable"), Shutter.language.getProperty("caseSubtitles"), 1);
                                }
                                sliderSpeed.setEnabled(false);
                                sliderSpeed.setValue(2);
                                lblSpeed.setText(String.valueOf(Shutter.language.getProperty("conformBySpeed")) + " x1");
                                lblSpeed.setBounds(sliderSpeed.getX() - VideoPlayer.lblSpeed.getPreferredSize().width - 2, sliderSpeed.getY() + 2, VideoPlayer.lblSpeed.getPreferredSize().width, 16);
                            } else {
                                JOptionPane.showConfirmDialog(frame, Shutter.language.getProperty("invalidSubtitles"), Shutter.language.getProperty("subtitlesFileError"), -1);
                                caseAddSubtitles.setSelected(false);
                            }
                        } else {
                            caseAddSubtitles.setSelected(false);
                        }
                    }
                } else {
                    player.remove(subsCanvas);
                    caseAddSubtitles.setSelected(false);
                    VideoPlayer.loadImage(true);
                    Component[] componentArray = grpSubtitles.getComponents();
                    int n = componentArray.length;
                    int n6 = 0;
                    while (n6 < n) {
                        Component c = componentArray[n6];
                        if (!(c instanceof JCheckBox)) {
                            c.setEnabled(false);
                        }
                        ++n6;
                    }
                    sliderSpeed.setEnabled(true);
                }
            }

            private void writeSub(String srt, Charset encoding) {
                try {
                    VideoPlayer.writeCurrentSubs(playerCurrentFrame);
                    VideoPlayer.loadImage(true);
                }
                catch (Exception e) {
                    if (encoding == StandardCharsets.UTF_8) {
                        this.writeSub(srt, StandardCharsets.ISO_8859_1);
                    }
                    caseAddSubtitles.setSelected(false);
                    player.remove(subsCanvas);
                }
            }
        });
        JLabel lblFont = new JLabel(Shutter.language.getProperty("lblFont"));
        lblFont.setAlignmentX(4.0f);
        lblFont.setForeground(Utils.themeColor);
        lblFont.setFont(new Font(Shutter.freeSansFont, 0, 12));
        lblFont.setBounds(12, caseAddSubtitles.getY() + caseAddSubtitles.getHeight() + 7, lblFont.getPreferredSize().width, 16);
        grpSubtitles.add(lblFont);
        final String[] Fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        comboSubsFont = new JComboBox<String>(Fonts);
        comboSubsFont.setName("comboSubsFont");
        comboSubsFont.setSelectedItem("Arial");
        comboSubsFont.setFont(new Font("Arial", 0, 11));
        comboSubsFont.setRenderer(new ComboRenderer(comboSubsFont));
        comboSubsFont.setEditable(true);
        comboSubsFont.setBounds(lblFont.getX() + lblFont.getWidth() + 7, lblFont.getY() - 4, 110, 22);
        grpSubtitles.add(comboSubsFont);
        comboSubsFont.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){
            String text = "";

            @Override
            public void keyReleased(KeyEvent e) {
                if (comboSubsFont.getEditor().toString().length() <= 1) {
                    this.text = String.valueOf(e.getKeyChar());
                }
                if (Character.isLetterOrDigit(e.getKeyChar())) {
                    comboSubsFont.setModel(new DefaultComboBoxModel<String>(Fonts));
                    this.text = String.valueOf(this.text) + e.getKeyChar();
                    ArrayList<String> newList = new ArrayList<String>();
                    int i = 0;
                    while (i < comboSubsFont.getItemCount()) {
                        if (Fonts[i].toString().length() >= this.text.length() && Fonts[i].toString().toLowerCase().substring(0, this.text.length()).contains(this.text) && !Fonts[i].toString().contains(":")) {
                            newList.add(Fonts[i].toString());
                        }
                        ++i;
                    }
                    comboSubsFont.getEditor().setItem(this.text);
                    if (!newList.isEmpty()) {
                        comboSubsFont.setModel(new DefaultComboBoxModel<Object>(newList.toArray()));
                        comboSubsFont.showPopup();
                    }
                } else if (e.getKeyCode() == 8 || e.getKeyCode() == 27) {
                    comboSubsFont.setModel(new DefaultComboBoxModel<String>(Fonts));
                    comboSubsFont.getEditor().setItem("");
                    comboSubsFont.hidePopup();
                    this.text = "";
                } else if (e.getKeyCode() == 40) {
                    e.consume();
                } else {
                    comboSubsFont.hidePopup();
                }
            }
        });
        comboSubsFont.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                comboSubsFont.setFont(new Font(comboSubsFont.getSelectedItem().toString(), 0, 11));
                VideoPlayer.loadImage(false);
            }
        });
        btnG = new JButton(Shutter.language.getProperty("btnG"));
        btnG.setFont(new Font(Shutter.montserratFont, 0, 13));
        btnG.setForeground(Color.BLACK);
        btnG.setName("btnG");
        btnG.setBounds(VideoPlayer.comboSubsFont.getLocation().x + comboSubsFont.getWidth() + 4, comboSubsFont.getY(), 22, 22);
        grpSubtitles.add(btnG);
        btnG.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (btnG.getForeground() == Color.BLACK) {
                    btnG.setForeground(Utils.themeColor);
                } else {
                    btnG.setForeground(Color.BLACK);
                }
                VideoPlayer.loadImage(true);
            }
        });
        btnI = new JButton("I");
        btnI.setFont(new Font("Courier New", 2, 13));
        btnI.setForeground(Color.BLACK);
        btnI.setName("btnI");
        btnI.setBounds(VideoPlayer.btnG.getLocation().x + btnG.getWidth() + 2, comboSubsFont.getY(), 22, 22);
        grpSubtitles.add(btnI);
        btnI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (btnI.getForeground() == Color.BLACK) {
                    btnI.setForeground(Utils.themeColor);
                } else {
                    btnI.setForeground(Color.BLACK);
                }
                VideoPlayer.loadImage(true);
            }
        });
        JLabel lblSubtitlesPosition = new JLabel(Shutter.language.getProperty("lblSubtitlesPosition"));
        lblSubtitlesPosition.setAlignmentX(4.0f);
        lblSubtitlesPosition.setForeground(Utils.themeColor);
        lblSubtitlesPosition.setFont(new Font(Shutter.freeSansFont, 0, 12));
        lblSubtitlesPosition.setBounds(VideoPlayer.btnI.getLocation().x + btnI.getWidth() + 6, comboSubsFont.getY() + 3, lblSubtitlesPosition.getPreferredSize().width, 16);
        grpSubtitles.add(lblSubtitlesPosition);
        textSubtitlesPosition = new JTextField("0");
        textSubtitlesPosition.setName("textSubtitlesPosition");
        textSubtitlesPosition.setFont(new Font(Shutter.freeSansFont, 0, 11));
        textSubtitlesPosition.setHorizontalAlignment(4);
        textSubtitlesPosition.setBounds(lblSubtitlesPosition.getLocation().x + lblSubtitlesPosition.getWidth() + 2, lblSubtitlesPosition.getLocation().y, 34, 16);
        grpSubtitles.add(textSubtitlesPosition);
        textSubtitlesPosition.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                textSubtitlesPosition.setCursor(Cursor.getPredefinedCursor(2));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                textSubtitlesPosition.setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                textSubtitlesPosition.setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mousePressed(MouseEvent e) {
                MouseSubsPosition.mouseY = e.getY();
                MouseSubsPosition.offsetY = Integer.parseInt(textSubtitlesPosition.getText());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        textSubtitlesPosition.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                VideoPlayer.refreshSubtitles();
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        textSubtitlesPosition.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (textSubtitlesPosition.getCursor() == Cursor.getPredefinedCursor(13) && textSubtitlesPosition.getText().length() > 0) {
                    textSubtitlesPosition.setText(String.valueOf(MouseSubsPosition.offsetY + (e.getY() - MouseSubsPosition.mouseY)));
                    VideoPlayer.refreshSubtitles();
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        JLabel px1 = new JLabel("px");
        px1.setEnabled(false);
        px1.setFont(new Font(Shutter.freeSansFont, 0, 12));
        px1.setForeground(Utils.themeColor);
        px1.setBounds(VideoPlayer.textSubtitlesPosition.getLocation().x + textSubtitlesPosition.getWidth() + 2, lblSubtitlesPosition.getY(), px1.getPreferredSize().width, 16);
        grpSubtitles.add(px1);
        JLabel lblWidth = new JLabel(Shutter.language.getProperty("lblWidth"));
        lblWidth.setFont(new Font(Shutter.freeSansFont, 0, 12));
        lblWidth.setAlignmentX(4.0f);
        lblWidth.setForeground(Utils.themeColor);
        lblWidth.setBounds(lblFont.getX(), lblFont.getY() + lblFont.getHeight() + 11, lblWidth.getPreferredSize().width, 16);
        grpSubtitles.add(lblWidth);
        textSubsWidth.setText(String.valueOf(FFPROBE.imageWidth));
        textSubsWidth.setName("textSubsWidth");
        textSubsWidth.setHorizontalAlignment(4);
        textSubsWidth.setBounds(lblWidth.getX() + lblWidth.getWidth() + 5, lblWidth.getLocation().y, 34, 16);
        textSubsWidth.setHorizontalAlignment(4);
        textSubsWidth.setFont(new Font(Shutter.freeSansFont, 0, 12));
        grpSubtitles.add(textSubsWidth);
        textSubsWidth.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (textSubsWidth.getText().length() > 0 && e.getKeyCode() == 10) {
                    if (Integer.parseInt(textSubsWidth.getText()) >= FFPROBE.imageWidth) {
                        textSubsWidth.setText(String.valueOf(FFPROBE.imageWidth));
                        subsCanvas.setBounds(0, 0, player.getWidth(), (int)((float)player.getHeight() + (float)Integer.parseInt(textSubtitlesPosition.getText()) / ((float)FFPROBE.imageHeight / (float)player.getHeight())));
                    } else {
                        subsCanvas.setSize((int)((float)Integer.parseInt(textSubsWidth.getText()) / ((float)FFPROBE.imageHeight / (float)player.getHeight())), (int)((float)player.getHeight() + (float)Integer.parseInt(textSubtitlesPosition.getText()) / ((float)FFPROBE.imageHeight / (float)player.getHeight())));
                        subsCanvas.setLocation((player.getWidth() - subsCanvas.getWidth()) / 2, 0);
                    }
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (textSubsWidth.getText().length() >= 4) {
                    textSubsWidth.setText("");
                }
            }
        });
        textSubsWidth.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                textSubsWidth.setCursor(Cursor.getPredefinedCursor(2));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                textSubsWidth.setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                textSubsWidth.setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mousePressed(MouseEvent e) {
                MouseSubSize.mouseX = e.getX();
                MouseSubSize.offsetX = Integer.parseInt(textSubsWidth.getText());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                VideoPlayer.loadImage(true);
            }
        });
        textSubsWidth.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (textSubsWidth.getCursor() == Cursor.getPredefinedCursor(13)) {
                    textSubsWidth.setText(String.valueOf(MouseSubSize.offsetX + (e.getX() - MouseSubSize.mouseX)));
                }
                if (Integer.parseInt(textSubsWidth.getText()) >= FFPROBE.imageWidth) {
                    textSubsWidth.setText(String.valueOf(FFPROBE.imageWidth));
                    subsCanvas.setBounds(0, 0, player.getWidth(), (int)((float)player.getHeight() + (float)Integer.parseInt(textSubtitlesPosition.getText()) / ((float)FFPROBE.imageHeight / (float)player.getHeight())));
                } else {
                    subsCanvas.setSize((int)((float)Integer.parseInt(textSubsWidth.getText()) / ((float)FFPROBE.imageHeight / (float)player.getHeight())), (int)((float)player.getHeight() + (float)Integer.parseInt(textSubtitlesPosition.getText()) / ((float)FFPROBE.imageHeight / (float)player.getHeight())));
                    subsCanvas.setLocation((player.getWidth() - subsCanvas.getWidth()) / 2, 0);
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        JLabel widthPx = new JLabel("px");
        widthPx.setEnabled(false);
        widthPx.setFont(new Font(Shutter.freeSansFont, 0, 12));
        widthPx.setForeground(Utils.themeColor);
        widthPx.setBounds(VideoPlayer.textSubsWidth.getLocation().x + textSubsWidth.getWidth() + 2, lblWidth.getY(), px1.getPreferredSize().width, 16);
        grpSubtitles.add(widthPx);
        JLabel lblColor = new JLabel(Shutter.language.getProperty("lblColor"));
        lblColor.setAlignmentX(4.0f);
        lblColor.setForeground(Utils.themeColor);
        lblColor.setFont(new Font(Shutter.freeSansFont, 0, 12));
        lblColor.setBounds(widthPx.getLocation().x + widthPx.getWidth() + 7, lblWidth.getY(), lblColor.getPreferredSize().width + 4, 16);
        grpSubtitles.add(lblColor);
        panelSubsColor = new JPanel();
        panelSubsColor.setName("panelSubsColor");
        panelSubsColor.setBorder(BorderFactory.createMatteBorder(3, 3, 3, 3, Color.BLACK));
        panelSubsColor.setBackground(fontSubsColor);
        panelSubsColor.setBounds(lblColor.getLocation().x + lblColor.getWidth(), lblColor.getY() - 4, 41, 22);
        grpSubtitles.add(panelSubsColor);
        panelSubsColor.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                fontSubsColor = JColorChooser.showDialog(frame, Shutter.language.getProperty("chooseColor"), Color.WHITE);
                if (fontSubsColor != null) {
                    panelSubsColor.setBackground(fontSubsColor);
                    VideoPlayer.loadImage(true);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        JLabel lblSize = new JLabel(Shutter.language.getProperty("lblSize"));
        lblSize.setFont(new Font(Shutter.freeSansFont, 0, 12));
        lblSize.setAlignmentX(4.0f);
        lblSize.setForeground(Utils.themeColor);
        lblSize.setBounds(VideoPlayer.panelSubsColor.getLocation().x + panelSubsColor.getWidth() + 7, lblColor.getLocation().y, lblSize.getPreferredSize().width, 16);
        grpSubtitles.add(lblSize);
        textSubsSize = new JTextField("18");
        textSubsSize.setName("textSubsSize");
        textSubsSize.setHorizontalAlignment(4);
        textSubsSize.setFont(new Font(Shutter.freeSansFont, 0, 11));
        textSubsSize.setBounds(lblSize.getLocation().x + lblSize.getWidth() + 5, lblColor.getLocation().y, 34, 16);
        grpSubtitles.add(textSubsSize);
        textSubsSize.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                textSubsSize.setCursor(Cursor.getPredefinedCursor(2));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                textSubsSize.setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                textSubsSize.setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mousePressed(MouseEvent e) {
                MouseSubsPosition.mouseX = e.getX();
                MouseSubsPosition.offsetX = Integer.parseInt(textSubsSize.getText());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        textSubsSize.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                VideoPlayer.loadImage(false);
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (textSubsSize.getText().length() >= 3) {
                    textSubsSize.setText("");
                }
            }
        });
        textSubsSize.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (textSubsSize.getText().length() > 0 && textSubsSize.getCursor() == Cursor.getPredefinedCursor(13)) {
                    int value = MouseSubsPosition.offsetX + (e.getX() - MouseSubsPosition.mouseX);
                    if (value < 1) {
                        textSubsSize.setText("1");
                    } else {
                        textSubsSize.setText(String.valueOf(value));
                    }
                    VideoPlayer.loadImage(false);
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        JLabel percent1 = new JLabel("%");
        percent1.setEnabled(false);
        percent1.setFont(new Font(Shutter.freeSansFont, 0, 12));
        percent1.setForeground(Utils.themeColor);
        percent1.setBounds(VideoPlayer.textSubsSize.getLocation().x + textSubsSize.getWidth() + 2, lblSize.getY(), px1.getPreferredSize().width, 16);
        if (!Shutter.getLanguage.equals(Locale.of("pl").getDisplayLanguage())) {
            grpSubtitles.add(percent1);
        }
        lblSubsBackground = new JLabel(Shutter.language.getProperty("lblBackgroundOff"));
        lblSubsBackground.setName("lblSubsBackground");
        lblSubsBackground.setBackground(new Color(60, 60, 60));
        lblSubsBackground.setHorizontalAlignment(0);
        lblSubsBackground.setOpaque(true);
        lblSubsBackground.setFont(new Font(Shutter.montserratFont, 0, 11));
        lblSubsBackground.setBounds(lblWidth.getX(), lblColor.getY() + lblColor.getHeight() + 13, 80, 16);
        grpSubtitles.add(lblSubsBackground);
        lblSubsBackground.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                if (lblSubsBackground.getText().equals(Shutter.language.getProperty("lblBackgroundOff"))) {
                    lblSubsBackground.setText(Shutter.language.getProperty("lblBackgroundOn"));
                    lblSubsOutline.setText(Shutter.language.getProperty("lblOpacity"));
                } else {
                    lblSubsBackground.setText(Shutter.language.getProperty("lblBackgroundOff"));
                    lblSubsOutline.setText(Shutter.language.getProperty("lblSize"));
                }
                VideoPlayer.loadImage(true);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                frame.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                frame.setCursor(Cursor.getPredefinedCursor(0));
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        JLabel lblColor2 = new JLabel(Shutter.language.getProperty("lblColor"));
        lblColor2.setAlignmentX(4.0f);
        lblColor2.setForeground(Utils.themeColor);
        lblColor2.setFont(new Font(Shutter.freeSansFont, 0, 12));
        lblColor2.setBounds(VideoPlayer.lblSubsBackground.getLocation().x + lblSubsBackground.getWidth() + 7, lblSubsBackground.getY(), lblColor2.getPreferredSize().width + 4, 16);
        grpSubtitles.add(lblColor2);
        panelSubsColor2 = new JPanel();
        panelSubsColor2.setName("panelSubsColor2");
        panelSubsColor2.setBorder(BorderFactory.createMatteBorder(3, 3, 3, 3, Color.BLACK));
        panelSubsColor2.setBackground(backgroundSubsColor);
        panelSubsColor2.setBounds(lblColor2.getLocation().x + lblColor2.getWidth(), lblColor2.getY() - 4, 41, 22);
        grpSubtitles.add(panelSubsColor2);
        panelSubsColor2.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                backgroundSubsColor = JColorChooser.showDialog(frame, Shutter.language.getProperty("chooseColor"), Color.WHITE);
                if (backgroundSubsColor != null) {
                    panelSubsColor2.setBackground(backgroundSubsColor);
                    VideoPlayer.loadImage(true);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        lblSubsOutline = Shutter.getLanguage.equals(Locale.of("pl").getDisplayLanguage()) ? new JLabel(Shutter.language.getProperty("lblSize")) : new JLabel(Shutter.language.getProperty("lblOpacity"));
        lblSubsOutline.setFont(new Font(Shutter.freeSansFont, 0, 12));
        lblSubsOutline.setName("lblSubsOutline");
        lblSubsOutline.setForeground(Utils.themeColor);
        lblSubsOutline.setAlignmentX(4.0f);
        lblSubsOutline.setBounds(VideoPlayer.panelSubsColor2.getLocation().x + panelSubsColor2.getWidth() + 7, lblColor2.getLocation().y, VideoPlayer.lblSubsOutline.getPreferredSize().width + 2, 16);
        lblSubsOutline.setText(Shutter.language.getProperty("lblSize"));
        grpSubtitles.add(lblSubsOutline);
        textSubsOutline = new JTextField("50");
        textSubsOutline.setName("textSubsOutline");
        textSubsOutline.setHorizontalAlignment(4);
        textSubsOutline.setFont(new Font(Shutter.freeSansFont, 0, 11));
        textSubsOutline.setBounds(VideoPlayer.lblSubsOutline.getLocation().x + lblSubsOutline.getWidth() + 5, lblColor2.getLocation().y, 34, 16);
        grpSubtitles.add(textSubsOutline);
        textSubsOutline.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                textSubsOutline.setCursor(Cursor.getPredefinedCursor(2));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                textSubsOutline.setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                textSubsOutline.setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mousePressed(MouseEvent e) {
                MouseSubsPosition.mouseX = e.getX();
                MouseSubsPosition.offsetX = Integer.parseInt(textSubsOutline.getText());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        textSubsOutline.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                VideoPlayer.loadImage(false);
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (textSubsOutline.getText().length() >= 3) {
                    textSubsOutline.setText("");
                }
            }
        });
        textSubsOutline.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (textSubsOutline.getText().length() > 0 && textSubsOutline.getCursor() == Cursor.getPredefinedCursor(13)) {
                    int value = MouseSubsPosition.offsetX + (e.getX() - MouseSubsPosition.mouseX);
                    if (value < 1) {
                        textSubsOutline.setText("1");
                    } else if (value > 100) {
                        textSubsOutline.setText("100");
                    } else {
                        textSubsOutline.setText(String.valueOf(value));
                    }
                    VideoPlayer.loadImage(false);
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        JLabel percent2 = new JLabel("%");
        percent2.setEnabled(false);
        percent2.setFont(new Font(Shutter.freeSansFont, 0, 12));
        percent2.setForeground(Utils.themeColor);
        percent2.setBounds(VideoPlayer.textSubsOutline.getLocation().x + textSubsOutline.getWidth() + 2, lblSubsOutline.getY(), px1.getPreferredSize().width, 16);
        grpSubtitles.add(percent2);
        subsCanvas = new JPanel();
        subsCanvas.setBorder(BorderFactory.createDashedBorder(Color.WHITE, 4.0f, 4.0f));
        subsCanvas.setOpaque(false);
        subsCanvas.setBounds(0, 0, player.getWidth(), player.getHeight());
        subsCanvas.setBackground(new Color(0, 0, 0, 0));
        Component[] componentArray = grpSubtitles.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (!(c instanceof JCheckBox)) {
                c.setEnabled(false);
            }
            ++n2;
        }
    }

    private static void refreshSubtitles() {
        if (alphaHeight == 0) {
            alphaHeight = FFPROBE.imageHeight;
        }
        int v = Integer.parseInt(textSubtitlesPosition.getText());
        int sz = Integer.parseInt(textSubsSize.getText());
        int newValue = Math.round((float)sz * ((float)alphaHeight / (float)(FFPROBE.imageHeight + v)));
        if (newValue > 0) {
            textSubsSize.setText(String.valueOf(newValue));
        }
        alphaHeight = FFPROBE.imageHeight + v;
        if (Integer.parseInt(textSubsWidth.getText()) >= FFPROBE.imageWidth) {
            subsCanvas.setBounds(0, 0, player.getWidth(), (int)((float)player.getHeight() + (float)Integer.parseInt(textSubtitlesPosition.getText()) / ((float)FFPROBE.imageHeight / (float)player.getHeight())));
        } else {
            subsCanvas.setSize((int)((float)Integer.parseInt(textSubsWidth.getText()) / ((float)FFPROBE.imageHeight / (float)player.getHeight())), (int)((float)player.getHeight() + (float)Integer.parseInt(textSubtitlesPosition.getText()) / ((float)FFPROBE.imageHeight / (float)player.getHeight())));
            subsCanvas.setLocation((player.getWidth() - subsCanvas.getWidth()) / 2, 0);
        }
        VideoPlayer.loadImage(false);
    }

    public static void writeCurrentSubs(float inputTime) {
        if (caseAddSubtitles.isSelected() && Shutter.subtitlesFile.toString().substring(Shutter.subtitlesFile.toString().lastIndexOf(".")).equals(".srt")) {
            try {
                String line;
                BufferedReader bufferedReader = Files.newBufferedReader(Paths.get(subtitlesFile.toString(), new String[0]), StandardCharsets.UTF_8);
                BufferedWriter bufferedWriter = Files.newBufferedWriter(Paths.get(Shutter.subtitlesFile.toString(), new String[0]), StandardCharsets.UTF_8, new OpenOption[0]);
                int subNumber = 0;
                while ((line = bufferedReader.readLine()) != null) {
                    if ((line = line.replace("\ufeff", "")).matches("[0-9]+")) {
                        subNumber = Integer.parseInt(line);
                        bufferedWriter.write(line);
                        bufferedWriter.newLine();
                    }
                    if (line.contains("-->")) {
                        String[] split = line.split("-->");
                        String[] inTimecode = split[0].replace(",", ":").replace(" ", "").split(":");
                        String[] outTimecode = split[1].replace(",", ":").replace(" ", "").split(":");
                        int inH = Integer.parseInt(inTimecode[0]) * 3600;
                        int inM = Integer.parseInt(inTimecode[1]) * 60;
                        int inS = Integer.parseInt(inTimecode[2]);
                        int inF = Integer.parseInt(inTimecode[3]);
                        float subsInTime = (float)(inH + inM + inS) * FFPROBE.currentFPS + (float)inF / inputFramerateMS;
                        if (subNumber == 1) {
                            sliderChange = true;
                            slider.setValue((int)subsInTime);
                            sliderChange = false;
                            waveformContainer.repaint();
                        }
                        int outH = Integer.parseInt(outTimecode[0]) * 3600;
                        int outM = Integer.parseInt(outTimecode[1]) * 60;
                        int outS = Integer.parseInt(outTimecode[2]);
                        int outF = Integer.parseInt(outTimecode[3]);
                        float subsOuTime = (float)(outH + outM + outS) * FFPROBE.currentFPS + (float)outF / inputFramerateMS;
                        long inOffset = (long)(subsInTime - inputTime);
                        long outOffset = (long)(subsOuTime - inputTime);
                        String iH = formatter.format(Math.floor((float)inOffset / FFPROBE.currentFPS / 3600.0f));
                        String iM = formatter.format(Math.floor((float)inOffset / FFPROBE.currentFPS / 60.0f) % 60.0);
                        String iS = formatter.format(Math.floor((float)inOffset / FFPROBE.currentFPS) % 60.0);
                        String iF = formatterToMs.format(Math.floor((float)inOffset % FFPROBE.currentFPS * inputFramerateMS));
                        String oH = formatter.format(Math.floor((float)outOffset / FFPROBE.currentFPS / 3600.0f));
                        String oM = formatter.format(Math.floor((float)outOffset / FFPROBE.currentFPS / 60.0f) % 60.0);
                        String oS = formatter.format(Math.floor((float)outOffset / FFPROBE.currentFPS) % 60.0);
                        String oF = formatterToMs.format(Math.floor((float)outOffset % FFPROBE.currentFPS * inputFramerateMS));
                        bufferedWriter.write(String.valueOf(iH) + ":" + iM + ":" + iS + "," + iF + " --> " + oH + ":" + oM + ":" + oS + "," + oF);
                        bufferedWriter.newLine();
                        continue;
                    }
                    if (!(line.contains("-->") || line.matches("[0-9]+") || line.isEmpty())) {
                        if (lblSubsBackground.getText().equals(Shutter.language.getProperty("lblBackgroundOn"))) {
                            bufferedWriter.write("\\h" + line + "\\h");
                        } else {
                            bufferedWriter.write(line);
                        }
                        bufferedWriter.newLine();
                        continue;
                    }
                    if (!line.isEmpty()) continue;
                    bufferedWriter.newLine();
                }
                bufferedReader.close();
                bufferedWriter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void grpWatermark() {
        grpWatermark = new JPanel();
        grpWatermark.setLayout(null);
        grpWatermark.setBorder(BorderFactory.createTitledBorder(new RoundedLineBorder(new Color(65, 65, 65), 1, 5, true), String.valueOf(Shutter.language.getProperty("caseLogo")) + " ", 0, 0, new Font(Shutter.montserratFont, 0, 12), Color.WHITE));
        grpWatermark.setBackground(new Color(45, 45, 45));
        grpWatermark.setSize(grpCrop.getWidth(), 17);
        grpWatermark.setLocation(frame.getWidth() - grpWatermark.getWidth() - 6, grpSubtitles.getY() + grpSubtitles.getHeight() + 6);
        frame.getContentPane().add(grpWatermark);
        grpWatermark.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int sized = 90;
                if (VideoPlayer.grpWatermark.getSize().height < 90) {
                    Thread changeSize = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                long startTime;
                                int i = 17;
                                do {
                                    startTime = System.currentTimeMillis() + 1L;
                                    i = Settings.btnDisableAnimations.isSelected() ? 90 : ++i;
                                    grpWatermark.setSize(grpWatermark.getWidth(), i);
                                    if (grpWatermark.getY() + grpWatermark.getHeight() >= grpOut.getY() - 6) {
                                        grpOverlay.setSize(grpOverlay.getWidth(), grpOverlay.getHeight() - 1);
                                        grpSubtitles.setLocation(VideoPlayer.grpOverlay.getLocation().x, VideoPlayer.grpOverlay.getSize().height + VideoPlayer.grpOverlay.getLocation().y + 6);
                                        grpWatermark.setLocation(VideoPlayer.grpSubtitles.getLocation().x, VideoPlayer.grpSubtitles.getSize().height + VideoPlayer.grpSubtitles.getLocation().y + 6);
                                    }
                                    Shutter.animateSections(startTime);
                                } while (i < 90);
                                if (grpOverlay.getHeight() > 17 && grpOverlay.getHeight() < 278) {
                                    i = grpOverlay.getHeight();
                                    do {
                                        startTime = System.currentTimeMillis() + 1L;
                                        i = Settings.btnDisableAnimations.isSelected() ? 17 : --i;
                                        grpOverlay.setSize(grpOverlay.getWidth(), i);
                                        grpSubtitles.setLocation(VideoPlayer.grpOverlay.getLocation().x, VideoPlayer.grpOverlay.getSize().height + VideoPlayer.grpOverlay.getLocation().y + 6);
                                        grpWatermark.setLocation(VideoPlayer.grpSubtitles.getLocation().x, VideoPlayer.grpSubtitles.getSize().height + VideoPlayer.grpSubtitles.getLocation().y + 6);
                                        Shutter.animateSections(startTime);
                                    } while (i > 17);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                    changeSize.start();
                } else {
                    Thread changeSize = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                int i = 90;
                                do {
                                    long startTime = System.currentTimeMillis() + 1L;
                                    i = Settings.btnDisableAnimations.isSelected() ? 17 : --i;
                                    grpWatermark.setSize(grpWatermark.getWidth(), i);
                                    Shutter.animateSections(startTime);
                                } while (i > 17);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    });
                    changeSize.start();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        logo = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                Graphics2D g2d = (Graphics2D)g;
                if (textWatermarkOpacity.getText().length() > 0 && Integer.parseInt(textWatermarkOpacity.getText()) <= 100) {
                    g2d.setComposite(AlphaComposite.getInstance(3, (float)Integer.valueOf(textWatermarkOpacity.getText()).intValue() / 100.0f));
                }
                if (logoPNG != null) {
                    g2d.drawImage(logoPNG, 0, 0, null);
                }
            }
        };
        logo.setLayout(null);
        logo.setOpaque(false);
        logo.setBackground(new Color(0, 0, 0, 50));
        logo.setSize(player.getWidth(), player.getHeight());
        logo.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 2 && !e.isConsumed()) {
                    logo.setLocation((int)Math.floor(player.getWidth() / 2 - logo.getWidth() / 2), (int)Math.floor(player.getHeight() / 2 - logo.getHeight() / 2));
                    textWatermarkPosX.setText(String.valueOf((Object)((int)Math.floor((float)VideoPlayer.logo.getLocation().x * imageRatio))));
                    textWatermarkPosY.setText(String.valueOf((Object)((int)Math.floor((float)VideoPlayer.logo.getLocation().y * imageRatio))));
                } else {
                    VideoPlayer.this.logoPosX = e.getLocationOnScreen().x;
                    VideoPlayer.this.logoPosY = e.getLocationOnScreen().y;
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                logoLocX = VideoPlayer.logo.getLocation().x;
                logoLocY = VideoPlayer.logo.getLocation().y;
            }
        });
        logo.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                logo.setLocation(MouseInfo.getPointerInfo().getLocation().x - VideoPlayer.this.logoPosX + logoLocX, MouseInfo.getPointerInfo().getLocation().y - VideoPlayer.this.logoPosY + logoLocY);
                textWatermarkPosX.setText(String.valueOf((Object)((int)Math.floor((float)VideoPlayer.logo.getLocation().x * imageRatio))));
                textWatermarkPosY.setText(String.valueOf((Object)((int)Math.floor((float)VideoPlayer.logo.getLocation().y * imageRatio))));
            }

            @Override
            public void mouseMoved(MouseEvent arg0) {
            }
        });
        caseAddWatermark.setName("caseAddWatermark");
        caseAddWatermark.setBounds(8, 16, VideoPlayer.caseAddWatermark.getPreferredSize().width + 8, 23);
        caseAddWatermark.setFont(new Font(Shutter.freeSansFont, 0, 12));
        caseAddWatermark.setSelected(false);
        grpWatermark.add(caseAddWatermark);
        caseAddWatermark.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (caseAddWatermark.isSelected()) {
                    boolean addDevice = false;
                    if (RecordInputDevice.comboInputVideo != null && RecordInputDevice.comboInputVideo.getSelectedIndex() > 0) {
                        addDevice = true;
                    }
                    if (Shutter.inputDeviceIsRunning && Shutter.liste.getElementAt(0).equals("Capture.current.screen") && System.getProperty("os.name").contains("Windows") && !addDevice) {
                        int reply = JOptionPane.showConfirmDialog(frame, Shutter.language.getProperty("addInputDevice"), Shutter.language.getProperty("menuItemInputDevice"), 0, -1);
                        if (reply == 0) {
                            addDevice = true;
                            caseAddWatermark.doClick();
                            Shutter.caseInAndOut.doClick();
                            Shutter.inputDevice.doClick();
                            Shutter.inputDeviceIsRunning = false;
                        } else {
                            Shutter.overlayDeviceIsRunning = false;
                        }
                    }
                    if (Shutter.liste.getSize() == 0) {
                        JOptionPane.showMessageDialog(frame, Shutter.language.getProperty("addFileToList"), Shutter.language.getProperty("noFileInList"), 0);
                        caseAddWatermark.setSelected(false);
                    } else if (addDevice) {
                        Component[] componentArray = grpWatermark.getComponents();
                        int n = componentArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Component c = componentArray[n2];
                            c.setEnabled(true);
                            ++n2;
                        }
                        VideoPlayer.loadWatermark(Integer.parseInt(textWatermarkSize.getText()));
                        player.add(logo);
                        textWatermarkPosX.setText(String.valueOf((Object)((int)Math.floor((float)VideoPlayer.logo.getLocation().x * imageRatio))));
                        textWatermarkPosY.setText(String.valueOf((Object)((int)Math.floor((float)VideoPlayer.logo.getLocation().y * imageRatio))));
                        if (caseEnableCrop.isSelected()) {
                            player.remove(selection);
                            player.remove(overImage);
                            player.add(selection);
                            player.add(overImage);
                        }
                        VideoPlayer.this.resizeAll();
                    } else {
                        FileDialog dialog = new FileDialog((Frame)frame, Shutter.language.getProperty("chooseLogo"), 0);
                        dialog.setDirectory(new File(videoPath).getParent());
                        dialog.setLocation(VideoPlayer.frame.getLocation().x - 50, VideoPlayer.frame.getLocation().y + 50);
                        dialog.setAlwaysOnTop(true);
                        dialog.setMultipleMode(false);
                        dialog.setVisible(true);
                        if (dialog.getFile() != null) {
                            logoFile = String.valueOf(dialog.getDirectory()) + dialog.getFile().toString();
                            Component[] componentArray = grpWatermark.getComponents();
                            int n = componentArray.length;
                            int n3 = 0;
                            while (n3 < n) {
                                Component c = componentArray[n3];
                                c.setEnabled(true);
                                ++n3;
                            }
                            VideoPlayer.loadWatermark(Integer.parseInt(textWatermarkSize.getText()));
                            player.add(logo);
                            textWatermarkPosX.setText(String.valueOf((Object)((int)Math.floor((float)VideoPlayer.logo.getLocation().x * imageRatio))));
                            textWatermarkPosY.setText(String.valueOf((Object)((int)Math.floor((float)VideoPlayer.logo.getLocation().y * imageRatio))));
                            if (caseEnableCrop.isSelected()) {
                                player.remove(selection);
                                player.remove(overImage);
                                player.add(selection);
                                player.add(overImage);
                            }
                        } else {
                            if (Shutter.overlayDeviceIsRunning) {
                                Shutter.overlayDeviceIsRunning = false;
                            }
                            caseAddWatermark.setSelected(false);
                        }
                    }
                } else {
                    Component[] componentArray = grpWatermark.getComponents();
                    int n = componentArray.length;
                    int n4 = 0;
                    while (n4 < n) {
                        Component c = componentArray[n4];
                        if (!(c instanceof JCheckBox)) {
                            c.setEnabled(false);
                        }
                        ++n4;
                    }
                    player.remove(logo);
                    logoPNG = null;
                }
                if (frameVideo != null) {
                    player.repaint();
                }
            }
        });
        caseSafeArea = new JCheckBox(Shutter.language.getProperty("caseSafeArea"));
        caseSafeArea.setName("caseSafeArea");
        caseSafeArea.setFont(new Font(Shutter.freeSansFont, 0, 12));
        caseSafeArea.setSize(VideoPlayer.caseSafeArea.getPreferredSize().width, 23);
        caseSafeArea.setLocation(caseAddWatermark.getX() + caseAddWatermark.getWidth() + 4, caseAddWatermark.getY());
        grpWatermark.add(caseSafeArea);
        final JPanel safeArea = new JPanel(){

            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(new Color(200, 200, 200));
                g.drawRect(player.getX() + (int)((float)((double)player.getWidth() * 0.07) / 2.0f), player.getY() + (int)((float)((double)player.getHeight() * 0.07) / 2.0f), (int)((double)player.getWidth() * 0.93), (int)((double)player.getHeight() * 0.93));
                g.drawRect(player.getX() + (int)((float)((double)player.getWidth() * 0.1) / 2.0f), player.getY() + (int)((float)((double)player.getHeight() * 0.1) / 2.0f), (int)((double)player.getWidth() * 0.9), (int)((double)player.getHeight() * 0.9));
            }
        };
        safeArea.setOpaque(false);
        safeArea.setBackground(new Color(0, 0, 0, 0));
        safeArea.setSize(player.getWidth(), player.getHeight());
        frame.getGlassPane().setVisible(false);
        caseSafeArea.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (caseSafeArea.isSelected()) {
                    frame.setGlassPane(safeArea);
                    frame.getGlassPane().setVisible(true);
                } else {
                    frame.getGlassPane().setVisible(false);
                }
            }
        });
        JLabel watermarkPosX = new JLabel(Shutter.language.getProperty("posX"));
        watermarkPosX.setHorizontalAlignment(4);
        watermarkPosX.setEnabled(false);
        watermarkPosX.setFont(new Font(Shutter.freeSansFont, 0, 12));
        watermarkPosX.setForeground(Utils.themeColor);
        watermarkPosX.setBounds(24, caseAddWatermark.getY() + caseAddWatermark.getHeight() + 4, watermarkPosX.getPreferredSize().width, 16);
        textWatermarkPosX = new JTextField(String.valueOf((Object)((int)Math.floor((float)VideoPlayer.logo.getLocation().x * imageRatio))));
        textWatermarkPosX.setName("textWatermarkPosX");
        textWatermarkPosX.setEnabled(false);
        textWatermarkPosX.setBounds(watermarkPosX.getLocation().x + watermarkPosX.getWidth() + 2, watermarkPosX.getLocation().y, 34, 16);
        textWatermarkPosX.setHorizontalAlignment(4);
        textWatermarkPosX.setFont(new Font(Shutter.freeSansFont, 0, 12));
        JLabel px1 = new JLabel("px");
        px1.setEnabled(false);
        px1.setFont(new Font(Shutter.freeSansFont, 0, 12));
        px1.setForeground(Utils.themeColor);
        px1.setBounds(VideoPlayer.textWatermarkPosX.getLocation().x + textWatermarkPosX.getWidth() + 2, watermarkPosX.getY(), px1.getPreferredSize().width, 16);
        textWatermarkPosX.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (textWatermarkPosX.getText().length() > 0 && e.getKeyCode() == 10) {
                    logo.setLocation((int)Math.floor((float)Integer.valueOf(textWatermarkPosX.getText()).intValue() / imageRatio), VideoPlayer.logo.getLocation().y);
                    logoLocX = VideoPlayer.logo.getLocation().x;
                    logoLocY = VideoPlayer.logo.getLocation().y;
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (textWatermarkPosX.getText().length() >= 4) {
                    textWatermarkPosX.setText("");
                }
            }
        });
        textWatermarkPosX.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                textWatermarkPosX.setCursor(Cursor.getPredefinedCursor(2));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                textWatermarkPosX.setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                textWatermarkPosX.setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mousePressed(MouseEvent e) {
                MouseLogoPosition.mouseX = e.getX();
                MouseLogoPosition.offsetX = Integer.parseInt(textWatermarkPosX.getText());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                logoLocX = VideoPlayer.logo.getLocation().x;
                logoLocY = VideoPlayer.logo.getLocation().y;
            }
        });
        textWatermarkPosX.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (textWatermarkPosX.getCursor() == Cursor.getPredefinedCursor(13)) {
                    textWatermarkPosX.setText(String.valueOf(MouseLogoPosition.offsetX + (e.getX() - MouseLogoPosition.mouseX)));
                    logo.setLocation((int)Math.floor((float)Integer.valueOf(textWatermarkPosX.getText()).intValue() / imageRatio), VideoPlayer.logo.getLocation().y);
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        JLabel watermarkPosY = new JLabel(Shutter.language.getProperty("posY"));
        watermarkPosY.setHorizontalAlignment(4);
        watermarkPosY.setEnabled(false);
        watermarkPosY.setFont(new Font(Shutter.freeSansFont, 0, 12));
        watermarkPosY.setForeground(Utils.themeColor);
        watermarkPosY.setBounds(px1.getX() + px1.getWidth() + 30, watermarkPosX.getLocation().y, watermarkPosX.getWidth(), 16);
        textWatermarkPosY = new JTextField(String.valueOf((Object)((int)Math.floor((float)VideoPlayer.logo.getLocation().y * imageRatio))));
        textWatermarkPosY.setName("textWatermarkPosY");
        textWatermarkPosY.setEnabled(false);
        textWatermarkPosY.setBounds(watermarkPosY.getLocation().x + watermarkPosY.getWidth() + 2, watermarkPosX.getY(), 34, 16);
        textWatermarkPosY.setHorizontalAlignment(4);
        textWatermarkPosY.setFont(new Font(Shutter.freeSansFont, 0, 12));
        textWatermarkPosY.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (textWatermarkPosY.getText().length() > 0 && e.getKeyCode() == 10) {
                    logo.setLocation(VideoPlayer.logo.getLocation().x, (int)Math.floor((float)Integer.valueOf(textWatermarkPosY.getText()).intValue() / imageRatio));
                    logoLocX = VideoPlayer.logo.getLocation().x;
                    logoLocY = VideoPlayer.logo.getLocation().y;
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (textWatermarkPosY.getText().length() >= 4) {
                    textWatermarkPosY.setText("");
                }
            }
        });
        textWatermarkPosY.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                textWatermarkPosY.setCursor(Cursor.getPredefinedCursor(2));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                textWatermarkPosY.setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                textWatermarkPosY.setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mousePressed(MouseEvent e) {
                MouseLogoPosition.mouseY = e.getY();
                MouseLogoPosition.offsetY = Integer.parseInt(textWatermarkPosY.getText());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                logoLocX = VideoPlayer.logo.getLocation().x;
                logoLocY = VideoPlayer.logo.getLocation().y;
            }
        });
        textWatermarkPosY.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (textWatermarkPosY.getCursor() == Cursor.getPredefinedCursor(13)) {
                    textWatermarkPosY.setText(String.valueOf(MouseLogoPosition.offsetY + (e.getY() - MouseLogoPosition.mouseY)));
                    logo.setLocation(VideoPlayer.logo.getLocation().x, (int)Math.floor((float)Integer.valueOf(textWatermarkPosY.getText()).intValue() / imageRatio));
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        JLabel px2 = new JLabel("px");
        px2.setEnabled(false);
        px2.setFont(new Font(Shutter.freeSansFont, 0, 12));
        px2.setForeground(Utils.themeColor);
        px2.setBounds(VideoPlayer.textWatermarkPosY.getLocation().x + textWatermarkPosY.getWidth() + 2, watermarkPosX.getY(), watermarkPosX.getPreferredSize().width, 16);
        JLabel watermarkSize = new JLabel(Shutter.language.getProperty("lblSize"));
        watermarkSize.setEnabled(false);
        watermarkSize.setHorizontalAlignment(4);
        watermarkSize.setFont(new Font(Shutter.freeSansFont, 0, 12));
        watermarkSize.setForeground(Utils.themeColor);
        watermarkSize.setBounds(watermarkPosX.getX(), watermarkPosX.getY() + watermarkPosX.getHeight() + 4, watermarkSize.getPreferredSize().width, 16);
        textWatermarkSize = new JTextField("100");
        textWatermarkSize.setName("textWatermarkSize");
        textWatermarkSize.setEnabled(false);
        textWatermarkSize.setBounds(VideoPlayer.textWatermarkPosX.getLocation().x, watermarkSize.getY(), 34, 16);
        textWatermarkSize.setHorizontalAlignment(4);
        textWatermarkSize.setFont(new Font(Shutter.freeSansFont, 0, 12));
        textWatermarkSize.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                textWatermarkSize.setCursor(Cursor.getPredefinedCursor(2));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                textWatermarkSize.setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                textWatermarkSize.setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mousePressed(MouseEvent e) {
                MouseLogoPosition.mouseX = e.getX();
                MouseLogoPosition.offsetX = Integer.parseInt(textWatermarkSize.getText());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                textWatermarkPosX.setText(String.valueOf((Object)((int)Math.floor((float)VideoPlayer.logo.getLocation().x * imageRatio))));
                textWatermarkPosY.setText(String.valueOf((Object)((int)Math.floor((float)VideoPlayer.logo.getLocation().y * imageRatio))));
                logoLocX = VideoPlayer.logo.getLocation().x;
                logoLocY = VideoPlayer.logo.getLocation().y;
            }
        });
        textWatermarkSize.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (textWatermarkSize.getText().length() > 0) {
                    VideoPlayer.loadWatermark(Integer.parseInt(textWatermarkSize.getText()));
                    textWatermarkPosX.setText(String.valueOf((Object)((int)Math.floor((float)VideoPlayer.logo.getLocation().x * imageRatio))));
                    textWatermarkPosY.setText(String.valueOf((Object)((int)Math.floor((float)VideoPlayer.logo.getLocation().y * imageRatio))));
                    logoLocX = VideoPlayer.logo.getLocation().x;
                    logoLocY = VideoPlayer.logo.getLocation().y;
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (textWatermarkSize.getText().length() >= 3) {
                    textWatermarkSize.setText("");
                }
            }
        });
        textWatermarkSize.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (textWatermarkSize.getText().length() > 0) {
                    int value = MouseLogoPosition.offsetX + (e.getX() - MouseLogoPosition.mouseX);
                    if (value < 1) {
                        textWatermarkSize.setText("1");
                    } else {
                        textWatermarkSize.setText(String.valueOf(value));
                    }
                    VideoPlayer.loadWatermark(Integer.parseInt(textWatermarkSize.getText()));
                    textWatermarkPosX.setText(String.valueOf((Object)((int)Math.floor((float)VideoPlayer.logo.getLocation().x * imageRatio))));
                    textWatermarkPosY.setText(String.valueOf((Object)((int)Math.floor((float)VideoPlayer.logo.getLocation().y * imageRatio))));
                    logoLocX = VideoPlayer.logo.getLocation().x;
                    logoLocY = VideoPlayer.logo.getLocation().y;
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        JLabel percent1 = new JLabel("%");
        percent1.setEnabled(false);
        percent1.setFont(new Font(Shutter.freeSansFont, 0, 12));
        percent1.setForeground(Utils.themeColor);
        percent1.setBounds(VideoPlayer.textWatermarkSize.getLocation().x + textWatermarkSize.getWidth() + 2, watermarkSize.getY(), percent1.getPreferredSize().width, 16);
        JLabel watermarkOpacity = new JLabel(Shutter.language.getProperty("lblOpacity"));
        watermarkOpacity.setEnabled(false);
        watermarkOpacity.setHorizontalAlignment(4);
        watermarkOpacity.setFont(new Font(Shutter.freeSansFont, 0, 12));
        watermarkOpacity.setForeground(Utils.themeColor);
        watermarkOpacity.setBounds(textWatermarkPosY.getX() - watermarkOpacity.getPreferredSize().width - 2, textWatermarkPosY.getY() + textWatermarkPosY.getHeight() + 4, watermarkOpacity.getPreferredSize().width, 16);
        textWatermarkOpacity = new JTextField("100");
        textWatermarkOpacity.setEnabled(false);
        textWatermarkOpacity.setName("textWatermarkOpacity");
        textWatermarkOpacity.setBounds(VideoPlayer.textWatermarkPosY.getLocation().x, watermarkOpacity.getY(), 34, 16);
        textWatermarkOpacity.setHorizontalAlignment(4);
        textWatermarkOpacity.setFont(new Font(Shutter.freeSansFont, 0, 12));
        textWatermarkOpacity.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                textWatermarkOpacity.setCursor(Cursor.getPredefinedCursor(2));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                textWatermarkOpacity.setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                textWatermarkOpacity.setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mousePressed(MouseEvent e) {
                MouseLogoPosition.mouseX = e.getX();
                MouseLogoPosition.offsetX = Integer.parseInt(textWatermarkOpacity.getText());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        });
        textWatermarkOpacity.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                logo.repaint();
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (textWatermarkSize.getCursor() == Cursor.getPredefinedCursor(13) && textWatermarkOpacity.getText().length() > 0) {
                    if (Integer.valueOf(textWatermarkOpacity.getText()) > 100) {
                        textWatermarkOpacity.setText("100");
                    } else if (Integer.valueOf(textWatermarkOpacity.getText()) < 1) {
                        textWatermarkOpacity.setText("1");
                    }
                    logo.repaint();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (textWatermarkOpacity.getText().length() >= 3) {
                    textWatermarkOpacity.setText("");
                }
            }
        });
        textWatermarkOpacity.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (textWatermarkOpacity.getText().length() > 0) {
                    int value = MouseLogoPosition.offsetX + (e.getX() - MouseLogoPosition.mouseX);
                    if (value > 100) {
                        textWatermarkOpacity.setText("100");
                    } else if (value < 1) {
                        textWatermarkOpacity.setText("1");
                    } else {
                        textWatermarkOpacity.setText(String.valueOf(value));
                    }
                    logo.repaint();
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        JLabel percent2 = new JLabel("%");
        percent2.setEnabled(false);
        percent2.setFont(new Font(Shutter.freeSansFont, 0, 12));
        percent2.setForeground(Utils.themeColor);
        percent2.setBounds(VideoPlayer.textWatermarkOpacity.getLocation().x + textWatermarkOpacity.getWidth() + 2, watermarkOpacity.getY(), percent2.getPreferredSize().width, 16);
        grpWatermark.add(watermarkPosX);
        grpWatermark.add(textWatermarkPosX);
        grpWatermark.add(px1);
        grpWatermark.add(watermarkPosY);
        grpWatermark.add(textWatermarkPosY);
        grpWatermark.add(px2);
        grpWatermark.add(watermarkSize);
        grpWatermark.add(textWatermarkSize);
        grpWatermark.add(percent1);
        grpWatermark.add(watermarkOpacity);
        grpWatermark.add(textWatermarkOpacity);
        grpWatermark.add(percent2);
        Component[] componentArray = grpWatermark.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (!(c instanceof JCheckBox)) {
                c.setEnabled(false);
            }
            ++n2;
        }
    }

    public static boolean loadWatermark(int size) {
        block26: {
            try {
                try {
                    if (Shutter.overlayDeviceIsRunning) {
                        RecordInputDevice.setOverlayDevice();
                    } else {
                        FFPROBE.Data(logoFile);
                        do {
                            try {
                                Thread.sleep(10L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        } while (FFPROBE.isRunning);
                    }
                    int logoFinalSizeWidth = (int)Math.floor((float)FFPROBE.imageWidth / imageRatio);
                    int logoFinalSizeHeight = (int)Math.floor((float)FFPROBE.imageHeight / imageRatio);
                    logoFinalSizeWidth = (int)Math.floor((double)logoFinalSizeWidth * ((double)size / 100.0));
                    logoFinalSizeHeight = (int)Math.floor((double)logoFinalSizeHeight * ((double)size / 100.0));
                    int newPosX = (int)Math.floor((logo.getWidth() - logoFinalSizeWidth) / 2);
                    int newPosY = (int)Math.floor((logo.getHeight() - logoFinalSizeHeight) / 2);
                    if (Shutter.overlayDeviceIsRunning) {
                        FFMPEG.run(" -v quiet " + RecordInputDevice.setOverlayDevice() + " -vframes 1 -an -vf scale=" + logoFinalSizeWidth + ":" + logoFinalSizeHeight + " -c:v png -pix_fmt bgra -sws_flags bicubic -f image2pipe pipe:-");
                    } else {
                        FFMPEG.run(" -v quiet -i \"" + logoFile + '\"' + " -vframes 1 -an -vf scale=" + logoFinalSizeWidth + ":" + logoFinalSizeHeight + " -c:v png -pix_fmt bgra -sws_flags bicubic -f image2pipe pipe:-");
                    }
                    do {
                        Thread.sleep(10L);
                    } while (!FFMPEG.process.isAlive());
                    InputStream videoInput = FFMPEG.process.getInputStream();
                    BufferedInputStream is = new BufferedInputStream(videoInput);
                    logoPNG = ImageIO.read(is);
                    if (logo.getWidth() == 0) {
                        logo.setLocation((int)Math.floor(player.getWidth() / 2 - logoFinalSizeWidth / 2), (int)Math.floor(player.getHeight() / 2 - logoFinalSizeHeight / 2));
                    } else {
                        logo.setLocation(VideoPlayer.logo.getLocation().x + newPosX, VideoPlayer.logo.getLocation().y + newPosY);
                    }
                    logo.setSize(logoFinalSizeWidth, logoFinalSizeHeight);
                    logoLocX = VideoPlayer.logo.getLocation().x;
                    logoLocY = VideoPlayer.logo.getLocation().y;
                    logo.repaint();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(frame, Shutter.language.getProperty("cantLoadLogo"), Shutter.language.getProperty("error"), 0);
                    try {
                        FFPROBE.Data(videoPath);
                        do {
                            Thread.sleep(10L);
                        } while (FFPROBE.isRunning);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    Shutter.enableAll();
                    if (RenderQueue.frame != null && RenderQueue.frame.isVisible()) {
                        Shutter.btnStart.setText(Shutter.language.getProperty("btnAddToRender"));
                        break block26;
                    }
                    Shutter.btnStart.setText(Shutter.language.getProperty("btnStartFunction"));
                }
            }
            finally {
                try {
                    FFPROBE.Data(videoPath);
                    do {
                        Thread.sleep(10L);
                    } while (FFPROBE.isRunning);
                }
                catch (InterruptedException interruptedException) {}
                Shutter.enableAll();
                if (RenderQueue.frame != null && RenderQueue.frame.isVisible()) {
                    Shutter.btnStart.setText(Shutter.language.getProperty("btnAddToRender"));
                } else {
                    Shutter.btnStart.setText(Shutter.language.getProperty("btnStartFunction"));
                }
            }
        }
        return true;
    }

    public static void loadImage(boolean forceRefresh) {
        if (forceRefresh) {
            Thread waitProcess = new Thread(new Runnable(){

                @Override
                public void run() {
                    do {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } while (runProcess.isAlive());
                }
            });
            waitProcess.start();
        }
        if (forceRefresh || !runProcess.isAlive()) {
            runProcess = new Thread(new Runnable(){

                @Override
                public void run() {
                    boolean display = false;
                    if (Shutter.caseDisplay.isSelected()) {
                        display = true;
                        Shutter.caseDisplay.setSelected(false);
                    }
                    if (VideoPlayer.playerIsPlaying()) {
                        btnPlay.doClick();
                    }
                    try {
                        try {
                            InputStream videoInput;
                            BufferedInputStream is;
                            boolean isRaw;
                            String extension;
                            File file;
                            block80: {
                                file = new File(videoPath);
                                extension = file.toString().substring(file.toString().lastIndexOf("."));
                                isRaw = false;
                                if (preview.exists()) break block80;
                                switch (extension.toLowerCase()) {
                                    case ".3fr": 
                                    case ".arw": 
                                    case ".cr2": 
                                    case ".cr3": 
                                    case ".crw": 
                                    case ".dng": 
                                    case ".kdc": 
                                    case ".mrw": 
                                    case ".nef": 
                                    case ".nrw": 
                                    case ".orf": 
                                    case ".pef": 
                                    case ".r3d": 
                                    case ".ptx": 
                                    case ".raf": 
                                    case ".rw2": 
                                    case ".srw": 
                                    case ".x3f": {
                                        isRaw = true;
                                    }
                                }
                                if (extension.toLowerCase().equals(".pdf")) {
                                    XPDF.toFFPROBE(file.toString());
                                    do {
                                        Thread.sleep(100L);
                                    } while (XPDF.isRunning);
                                } else if (isRaw) {
                                    EXIFTOOL.run(file.toString());
                                    do {
                                        Thread.sleep(100L);
                                    } while (EXIFTOOL.isRunning);
                                }
                                Console.consoleFFMPEG.append(String.valueOf(System.lineSeparator()) + Shutter.language.getProperty("tempFolder") + " " + Shutter.dirTemp + System.lineSeparator() + System.lineSeparator());
                            }
                            if (caseShowTimecode.isSelected() && FFPROBE.timecode1.equals("")) {
                                caseShowTimecode.setSelected(false);
                                caseShowTimecode.setEnabled(false);
                                caseAddTimecode.setSelected(true);
                                TC1.setEnabled(true);
                                TC2.setEnabled(true);
                                TC3.setEnabled(true);
                                TC4.setEnabled(true);
                            }
                            String deinterlace = "";
                            if (!isRaw && !extension.toLowerCase().equals(".pdf") && FFPROBE.interlaced != null && FFPROBE.interlaced.equals("1")) {
                                deinterlace = " -vf yadif=0:" + FFPROBE.fieldOrder + ":0";
                            }
                            String inputPoint = " -ss " + playerCurrentFrame * inputFramerateMS + "ms";
                            if (FFPROBE.totalLength <= 40 || Shutter.caseEnableSequence.isSelected()) {
                                inputPoint = "";
                            }
                            String cmd = String.valueOf(deinterlace) + " -vframes 1 -an -s " + player.getWidth() + "x" + player.getHeight() + " -sws_flags bicubic -y ";
                            if (Shutter.caseRotate.isSelected() && (Shutter.comboRotate.getSelectedIndex() == 0 || Shutter.comboRotate.getSelectedIndex() == 1)) {
                                cmd = String.valueOf(deinterlace) + " -vframes 1 -an -s " + player.getHeight() + "x" + player.getWidth() + " -sws_flags bicubic -y ";
                            }
                            String EXRGamma = "";
                            if (extension.toLowerCase().equals(".exr")) {
                                EXRGamma = Colorimetry.setInputCodec(extension);
                            }
                            if (!new File(String.valueOf(Shutter.dirTemp) + "preview.bmp").exists() && !caseAddSubtitles.isSelected()) {
                                if (extension.toLowerCase().equals(".pdf")) {
                                    frame.setCursor(Cursor.getPredefinedCursor(3));
                                    XPDF.run(" -r 300 -f 1 -l 1 \"" + file.toString() + '\"' + " - | PathToFFMPEG -i -" + cmd + '\"' + preview + '\"');
                                } else if (isRaw) {
                                    frame.setCursor(Cursor.getPredefinedCursor(3));
                                    DCRAW.run(" -v -w -c -q 0 -o 1 -h -6 -g 2.4 12.92 \"" + file.toString() + '\"' + " | PathToFFMPEG -i -" + cmd + '\"' + preview + '\"');
                                } else if (Shutter.inputDeviceIsRunning) {
                                    showFPS.setVisible(false);
                                    frame.setCursor(Cursor.getPredefinedCursor(3));
                                    frame.setVisible(false);
                                    FFMPEG.run(" " + RecordInputDevice.setInputDevices() + cmd + '\"' + preview + '\"');
                                } else {
                                    FFMPEG.run(String.valueOf(EXRGamma) + inputPoint + " -i " + '\"' + file.toString() + '\"' + cmd + '\"' + preview + '\"');
                                }
                                do {
                                    Thread.sleep(10L);
                                } while (FFMPEG.isRunning && !FFMPEG.error || XPDF.isRunning && !XPDF.error || DCRAW.isRunning && !DCRAW.error);
                                frame.setCursor(Cursor.getPredefinedCursor(0));
                            }
                            if (Shutter.inputDeviceIsRunning && !preview.exists()) {
                                cmd = " -vframes 1 -an " + VideoPlayer.setFilter("", "", true) + " ";
                                frame.setVisible(false);
                                FFMPEG.run(" " + RecordInputDevice.setInputDevices() + cmd + '\"' + preview + '\"');
                            } else if (caseAddSubtitles.isSelected()) {
                                FFMPEG.run(String.valueOf(EXRGamma) + " -v quiet" + inputPoint + " -i " + '\"' + videoPath + '\"' + VideoPlayer.setFilter("", "", true) + " -vframes 1 -c:v bmp -f image2pipe pipe:-");
                            } else {
                                FFMPEG.run(String.valueOf(EXRGamma) + " -v quiet -i " + '\"' + preview + '\"' + VideoPlayer.setFilter("", "", true) + " -vframes 1 -c:v bmp -f image2pipe pipe:-");
                            }
                            do {
                                Thread.sleep(10L);
                            } while (!FFMPEG.process.isAlive());
                            if (Shutter.caseInAndOut.isSelected()) {
                                frame.setVisible(true);
                            }
                            if ((frameVideo = ImageIO.read(is = new BufferedInputStream(videoInput = FFMPEG.process.getInputStream()))) != null) {
                                player.repaint();
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            Shutter.enableAll();
                            if (RenderQueue.frame != null && RenderQueue.frame.isVisible()) {
                                Shutter.btnStart.setText(Shutter.language.getProperty("btnAddToRender"));
                            } else {
                                Shutter.btnStart.setText(Shutter.language.getProperty("btnStartFunction"));
                            }
                            if (display) {
                                Shutter.caseDisplay.setSelected(true);
                            }
                        }
                    }
                    finally {
                        Shutter.enableAll();
                        if (RenderQueue.frame != null && RenderQueue.frame.isVisible()) {
                            Shutter.btnStart.setText(Shutter.language.getProperty("btnAddToRender"));
                        } else {
                            Shutter.btnStart.setText(Shutter.language.getProperty("btnStartFunction"));
                        }
                        if (display) {
                            Shutter.caseDisplay.setSelected(true);
                        }
                    }
                }
            });
            runProcess.start();
        }
    }

    private static String setFilter(String yadif, String speed, boolean noGPU) {
        String background = "";
        if (caseAddSubtitles.isSelected() && Shutter.subtitlesFile.toString().substring(Shutter.subtitlesFile.toString().lastIndexOf(".")).equals(".srt")) {
            String c;
            if (fontSubsColor != null) {
                c = Integer.toHexString(fontSubsColor.getRGB()).substring(2);
                subsHex = String.valueOf(c.substring(4, 6)) + c.substring(2, 4) + c.substring(0, 2);
            }
            if (backgroundSubsColor != null) {
                c = Integer.toHexString(backgroundSubsColor.getRGB()).substring(2);
                subsHex2 = String.valueOf(c.substring(4, 6)) + c.substring(2, 4) + c.substring(0, 2);
            }
            subsAlpha = "00";
            outline = "1";
            if (lblSubsBackground.getText().equals(Shutter.language.getProperty("lblBackgroundOn"))) {
                int o = (int)(255.0f - (float)(Integer.valueOf(textSubsOutline.getText()) * 255) / 100.0f);
                subsAlpha = Integer.toHexString(o);
            } else {
                outline = String.valueOf((float)Integer.valueOf(textSubsOutline.getText()).intValue() * 2.0f / 100.0f);
            }
            background = lblSubsBackground.getText().equals(Shutter.language.getProperty("lblBackgroundOn")) ? ",BorderStyle=4,BackColour=&H" + subsAlpha + subsHex2 + "&,Outline=0" : ",Outline=" + outline + ",OutlineColour=&H" + subsAlpha + subsHex2 + "&";
            if (btnG.getForeground() != Color.BLACK) {
                background = String.valueOf(background) + ",Bold=1";
            }
            if (btnI.getForeground() != Color.BLACK) {
                background = String.valueOf(background) + ",Italic=1";
            }
        }
        String filter = " -vf \"";
        if (yadif != "") {
            filter = String.valueOf(filter) + yadif + ",";
        }
        int width = player.getWidth();
        int height = player.getHeight();
        if (Shutter.caseRotate.isSelected() && (Shutter.comboRotate.getSelectedIndex() == 0 || Shutter.comboRotate.getSelectedIndex() == 1)) {
            width = player.getHeight();
            height = player.getWidth();
        }
        String algorithm = "bilinear";
        if (mouseIsPressed) {
            algorithm = "neighbor";
        }
        if (FFMPEG.isGPUCompatible && caseGPU.isSelected() && !noGPU) {
            String bitDepth = "nv12";
            if (FFPROBE.imageDepth == 10) {
                bitDepth = "p010";
            }
            if (FFMPEG.cudaAvailable) {
                filter = filter.replace("yadif", "yadif_cuda");
                filter = String.valueOf(filter) + "scale_cuda=" + width + ":" + height + ":interp_algo=" + algorithm.replace("neighbor", "nearest").replace("bilinear", "bicubic") + ",hwdownload,format=" + bitDepth;
            } else {
                filter = FFMPEG.qsvAvailable && yadif == "" ? String.valueOf(filter) + "scale_qsv=" + width + ":" + height + ":mode=low_power,hwdownload,format=" + bitDepth : String.valueOf(filter) + "scale=" + width + ":" + height + ":sws_flags=" + algorithm + ":sws_dither=none";
            }
        } else {
            filter = String.valueOf(filter) + "scale=" + width + ":" + height + ":sws_flags=" + algorithm + ":sws_dither=none";
        }
        if (FFPROBE.pixelformat.contains("a")) {
            filter = String.valueOf(filter) + ",split=2[bg][fg];[bg]drawbox=c=0x2d2d2d:replace=1:t=fill[bg];[bg][fg]overlay=0:0,format=rgb24";
        }
        if (speed != "") {
            filter = String.valueOf(filter) + "," + speed;
        }
        String eq = "";
        if (stabilisation != "") {
            eq = stabilisation;
        }
        if (!preview.exists()) {
            eq = ImageSequence.setBlend(eq);
        }
        eq = Colorimetry.setLUT(eq);
        eq = Colorimetry.setLevels(eq);
        eq = Colorimetry.setColormatrix(eq);
        if (Shutter.caseRotate.isSelected() || Shutter.caseMiror.isSelected()) {
            eq = settings.Image.setRotate(eq);
        }
        if (caseEnableColorimetry.isSelected()) {
            String color = Colorimetry.setEQ(false);
            if (eq != "" && color != "") {
                eq = String.valueOf(eq) + "," + color;
            } else if (color != "") {
                eq = String.valueOf(eq) + color;
            }
            if (sliderAngle.getValue() != 0) {
                eq = eq.contains("scale") ? eq.replace("scale=" + FFPROBE.imageWidth + ":" + FFPROBE.imageHeight, "scale=" + player.getWidth() + ":" + player.getHeight()) : String.valueOf(eq) + ",scale=" + player.getWidth() + ":" + player.getHeight();
            }
        }
        eq = Corrections.setDeflicker(eq);
        eq = Corrections.setDeband(eq);
        eq = Corrections.setDetails(eq);
        eq = Corrections.setDenoiser(eq);
        if (!preview.exists()) {
            eq = Corrections.setSmoothExposure(eq);
        }
        eq = Corrections.setLimiter(eq);
        if (caseVideoFadeIn.isSelected() || caseVideoFadeOut.isSelected()) {
            eq = Transitions.setVideoFade(eq, true);
        }
        if (!eq.isEmpty()) {
            filter = String.valueOf(filter) + "," + eq;
        }
        if (caseVuMeter.isSelected() && FFPROBE.hasAudio && !caseAddSubtitles.isSelected() && !preview.exists()) {
            String aspeed = "";
            if (sliderSpeed.getValue() != 2) {
                aspeed = sliderSpeed.getValue() != 0 ? String.valueOf(aspeed) + "atempo=" + (float)sliderSpeed.getValue() / 2.0f + "," : String.valueOf(aspeed) + "atempo=0.5,atempo=0.5,";
            }
            String channels = "";
            String audioOutput = "";
            int i = 0;
            while (i < FFPROBE.channels) {
                channels = String.valueOf(channels) + "[0:a:" + i + "]" + aspeed + "showvolume=f=0:w=" + player.getWidth() + ":h=" + Math.round(player.getHeight() / 90) + ":t=0:b=0:v=0:o=v:s=0:p=0.5[a" + i + "];";
                audioOutput = String.valueOf(audioOutput) + "[a" + i + "]";
                ++i;
            }
            if (FFPROBE.channels > 1) {
                audioOutput = String.valueOf(audioOutput) + "hstack=" + i + "[volume];";
            } else {
                audioOutput = audioOutput.replace("[a0]", "");
                channels = channels.replace("[a0]", "[volume]");
            }
            filter = " -filter_complex \"[0:v]" + filter.replace(" -vf ", "").replace("\"", "") + "[v];" + channels + audioOutput + "[v][volume]overlay=W-w:H-h";
        }
        filter = String.valueOf(filter) + '\"';
        if (caseAddSubtitles.isSelected() && Shutter.subtitlesBurn && Shutter.subtitlesFile.toString().substring(Shutter.subtitlesFile.toString().lastIndexOf(".")).equals(".srt")) {
            caseVuMeter.setEnabled(false);
            int subsWidth = (int)((float)Integer.parseInt(textSubsWidth.getText()) / imageRatio);
            int subsPosY = (int)((float)Integer.parseInt(textSubtitlesPosition.getText()) / imageRatio);
            return " -f lavfi -i \"color=black@0.0,format=rgba,scale=" + subsWidth + ":" + player.getHeight() + "+" + subsPosY + ",subtitles='" + Shutter.subtitlesFile.toString() + "':alpha=1:force_style='FontName=" + comboSubsFont.getSelectedItem().toString() + ",FontSize=" + textSubsSize.getText() + ",PrimaryColour=&H" + subsHex + "&" + background + "'" + '\"' + " -filter_complex " + '\"' + "[0:v]" + filter.replace(" -vf ", "").replace("\"", "") + "[v];[v][1:v]overlay=x=" + (player.getWidth() - subsWidth) / 2 + ",scale=" + player.getWidth() + ":" + player.getHeight() + '\"';
        }
        caseVuMeter.setEnabled(true);
        return filter;
    }

    private void resizeAll() {
        if (preview.exists()) {
            preview.delete();
        }
        this.topPanel.setBounds(0, 0, VideoPlayer.frame.getSize().width, 28);
        this.topImage.setLocation(VideoPlayer.frame.getSize().width / 2 - this.topImage.getSize().width / 2, 0);
        this.quit.setBounds(VideoPlayer.frame.getSize().width - 20, 4, 15, 15);
        this.fullscreen.setBounds(this.quit.getLocation().x - 20, 4, 15, 15);
        this.reduce.setBounds(this.fullscreen.getLocation().x - 20, 4, 15, 15);
        ImageIcon imageIcon = new ImageIcon(this.header.getImage().getScaledInstance(this.topPanel.getSize().width, this.topPanel.getSize().height, 16));
        this.bottomImage.setIcon(imageIcon);
        this.bottomImage.setBounds(0, 0, VideoPlayer.frame.getSize().width, 28);
        btnCapture.setBounds(9, this.topPanel.getSize().height + 10, 310, 21);
        this.btnApply.setBounds(VideoPlayer.frame.getSize().width - 8 - 308 - 2, this.topPanel.getSize().height + 10, 310, 21);
        btnPreview.setBounds(VideoPlayer.frame.getSize().width - 36, VideoPlayer.frame.getSize().height - 26, 16, 16);
        splitValue.setBounds(VideoPlayer.frame.getSize().width - 48, VideoPlayer.frame.getSize().height - 26, 34, 16);
        lblSplitSec.setBounds(splitValue.getX() + splitValue.getWidth() + 2, splitValue.getY(), VideoPlayer.lblSplitSec.getPreferredSize().width, 16);
        grpIn.setBounds(6, VideoPlayer.frame.getSize().height - 84, 156, 52);
        grpOut.setBounds(frame.getWidth() - grpIn.getWidth() - 12, grpIn.getY(), grpIn.getWidth(), grpIn.getHeight());
        if (grpColorimetry.getHeight() > 17) {
            int grpInSize = frame.getHeight() - grpIn.getY();
            if (!waveformContainer.isVisible()) {
                grpInSize = 0;
            }
            grpColorimetry.setSize(grpColorimetry.getWidth(), frame.getHeight() - grpInSize - grpColorimetry.getY() - grpCorrections.getHeight() - grpTransitions.getHeight() - 18);
            if (grpColorimetry.getHeight() > btnReset.getY() + btnReset.getHeight() + 30) {
                grpColorimetry.setSize(grpColorimetry.getWidth(), btnReset.getY() + btnReset.getHeight() + 30);
            }
            panelColorimetryComponents.setSize(grpColorimetry.getWidth() - 18, grpColorimetry.getHeight() - 25);
            grpCorrections.setLocation(VideoPlayer.grpColorimetry.getLocation().x, VideoPlayer.grpColorimetry.getSize().height + VideoPlayer.grpColorimetry.getLocation().y + 6);
            grpTransitions.setLocation(VideoPlayer.grpColorimetry.getLocation().x, VideoPlayer.grpCorrections.getSize().height + VideoPlayer.grpCorrections.getLocation().y + 6);
        }
        this.scrollBarColorimetry.setValue(0);
        if (grpColorimetry.getHeight() < btnReset.getY() + btnReset.getHeight() + 30) {
            this.scrollBarColorimetry.setSize(11, grpColorimetry.getHeight() - 11);
            this.scrollBarColorimetry.setMaximum(btnReset.getY() + btnReset.getHeight() + 15 - panelColorimetryComponents.getHeight());
            this.scrollBarColorimetry.setVisible(true);
        } else {
            this.scrollBarColorimetry.setVisible(false);
        }
        comboMode.setLocation(splitValue.getX() - 74 - 5, VideoPlayer.frame.getSize().height - 16 - 12 - 1);
        lblMode.setBounds(comboMode.getX() - VideoPlayer.lblMode.getPreferredSize().width - 4, VideoPlayer.frame.getSize().height - 16 - 12 + 2, VideoPlayer.lblMode.getPreferredSize().width, 16);
        caseVuMeter.setBounds(lblMode.getX() - VideoPlayer.caseVuMeter.getPreferredSize().width - 5, comboMode.getY(), VideoPlayer.caseVuMeter.getPreferredSize().width, 23);
        caseGPU.setBounds(caseVuMeter.getX() - VideoPlayer.caseGPU.getPreferredSize().width - 5, comboMode.getY(), VideoPlayer.caseGPU.getPreferredSize().width, 23);
        caseInternalTc.setBounds(grpIn.getX(), VideoPlayer.frame.getSize().height - 16 - 12, VideoPlayer.caseInternalTc.getPreferredSize().width, 23);
        casePlaySound.setBounds(caseInternalTc.getX() + caseInternalTc.getWidth() + 4, caseInternalTc.getY(), VideoPlayer.casePlaySound.getPreferredSize().width, 23);
        float timeIn = (float)(Integer.parseInt(caseInH.getText()) * 3600 + Integer.parseInt(caseInM.getText()) * 60 + Integer.parseInt(caseInS.getText())) * FFPROBE.currentFPS + (float)Integer.parseInt(caseInF.getText());
        float timeOut = (float)(Integer.parseInt(caseOutH.getText()) * 3600 + Integer.parseInt(caseOutM.getText()) * 60 + Integer.parseInt(caseOutS.getText())) * FFPROBE.currentFPS + (float)Integer.parseInt(caseOutF.getText());
        VideoPlayer.addWaveform(false);
        slider.setBounds(VideoPlayer.grpIn.getLocation().x + VideoPlayer.grpIn.getSize().width + 6, VideoPlayer.grpIn.getLocation().y, VideoPlayer.frame.getSize().width - (VideoPlayer.grpIn.getLocation().x + VideoPlayer.grpIn.getSize().width + 6) * 2 - 6, 60);
        waveformContainer.setBounds(slider.getX(), slider.getY() + 7, slider.getWidth(), grpIn.getHeight() - 9);
        waveformIcon.setBounds(waveformContainer.getBounds());
        if (playerCurrentFrame <= 1.0f) {
            cursorWaveform.setBounds(0, 0, 2, VideoPlayer.waveformContainer.getSize().height);
        } else if (cursorWaveform.getX() > waveformContainer.getWidth() - 2) {
            cursorWaveform.setLocation(waveformContainer.getWidth() - 2, 0);
        } else {
            cursorWaveform.setBounds(Math.round((float)(VideoPlayer.waveformContainer.getSize().width * slider.getValue()) / (float)slider.getMaximum()), 0, 2, VideoPlayer.waveformContainer.getSize().height);
        }
        playerInMark = Math.round((float)VideoPlayer.waveformContainer.getSize().width * timeIn / totalFrames);
        playerOutMark = (float)((int)Math.ceil(timeOut)) < totalFrames ? Math.round(((float)VideoPlayer.waveformContainer.getSize().width * timeOut - 1.0f) / totalFrames) : waveformContainer.getWidth() - 2;
        waveformContainer.repaint();
        lblPosition.setBounds(slider.getX(), slider.getY() - 16, slider.getWidth(), 16);
        lblDuration.setBounds(slider.getX(), slider.getY() + slider.getHeight() - 2, slider.getWidth(), 16);
        float ratio = FFPROBE.imageRatio;
        if (Shutter.caseRotate.isSelected() && (Shutter.comboRotate.getSelectedIndex() == 0 || Shutter.comboRotate.getSelectedIndex() == 1)) {
            ratio = (float)FFPROBE.imageHeight / (float)FFPROBE.imageWidth;
        }
        if (Shutter.caseForcerDAR.isSelected()) {
            if (Shutter.comboDAR.getSelectedItem().toString().contains(":")) {
                String[] s = Shutter.comboDAR.getSelectedItem().toString().split(":");
                ratio = (float)Integer.parseInt(s[0]) / (float)Integer.parseInt(s[1]);
            } else {
                ratio = Float.parseFloat(Shutter.comboDAR.getSelectedItem().toString());
            }
        }
        if (ratio < 1.3f) {
            int maxHeight = frame.getHeight() - (frame.getHeight() - lblPosition.getY()) - btnCapture.getY() - btnCapture.getHeight() - 64;
            if (FFPROBE.totalLength <= 40 || Shutter.caseEnableSequence.isSelected()) {
                maxHeight = frame.getHeight() - btnCapture.getY() - btnCapture.getHeight() - 24;
            }
            player.setSize((int)((float)maxHeight * ratio), maxHeight);
        } else {
            int maxWidth = frame.getWidth() - grpCrop.getWidth() * 2 - 24;
            player.setSize(maxWidth, (int)((float)maxWidth / ratio));
        }
        if (FFPROBE.totalLength <= 40 || Shutter.caseEnableSequence.isSelected()) {
            player.setLocation((VideoPlayer.frame.getSize().width - VideoPlayer.player.getSize().width) / 2, frame.getHeight() / 2 - player.getHeight() / 2 + 28);
        } else {
            player.setLocation((VideoPlayer.frame.getSize().width - VideoPlayer.player.getSize().width) / 2, frame.getHeight() / 2 - player.getHeight() / 2 - 32);
        }
        player.setSize(player.getWidth() - player.getWidth() % 4, player.getHeight());
        imageRatio = (float)FFPROBE.imageWidth / (float)player.getWidth();
        grpOverlay.setLocation(frame.getWidth() - grpOverlay.getWidth() - 6, grpCrop.getY() + grpCrop.getHeight() + 6);
        grpSubtitles.setLocation(frame.getWidth() - grpSubtitles.getWidth() - 6, grpOverlay.getY() + grpOverlay.getHeight() + 6);
        if (caseAddSubtitles.isSelected()) {
            if (Integer.parseInt(textSubsWidth.getText()) >= FFPROBE.imageWidth) {
                subsCanvas.setBounds(0, 0, player.getWidth(), (int)((float)player.getHeight() + (float)Integer.parseInt(textSubtitlesPosition.getText()) / ((float)FFPROBE.imageHeight / (float)player.getHeight())));
            } else {
                subsCanvas.setSize((int)((float)Integer.parseInt(textSubsWidth.getText()) / ((float)FFPROBE.imageHeight / (float)player.getHeight())), (int)((float)player.getHeight() + (float)Integer.parseInt(textSubtitlesPosition.getText()) / ((float)FFPROBE.imageHeight / (float)player.getHeight())));
                subsCanvas.setLocation((player.getWidth() - subsCanvas.getWidth()) / 2, 0);
            }
        }
        grpWatermark.setLocation(frame.getWidth() - grpWatermark.getWidth() - 6, grpSubtitles.getY() + grpSubtitles.getHeight() + 6);
        if (caseAddWatermark.isSelected()) {
            VideoPlayer.loadWatermark(Integer.parseInt(textWatermarkSize.getText()));
            logo.setLocation((int)Math.floor((float)Integer.valueOf(textWatermarkPosX.getText()).intValue() / imageRatio), (int)Math.floor((float)Integer.valueOf(textWatermarkPosY.getText()).intValue() / imageRatio));
        }
        if (grpWatermark.getY() + grpWatermark.getHeight() >= grpOut.getY() - 6) {
            grpOverlay.setSize(grpOverlay.getWidth(), 17);
            grpSubtitles.setLocation(VideoPlayer.grpOverlay.getLocation().x, VideoPlayer.grpOverlay.getSize().height + VideoPlayer.grpOverlay.getLocation().y + 6);
            grpWatermark.setLocation(VideoPlayer.grpSubtitles.getLocation().x, VideoPlayer.grpSubtitles.getSize().height + VideoPlayer.grpSubtitles.getLocation().y + 6);
        }
        grpCrop.setLocation(frame.getWidth() - grpCrop.getWidth() - 6, grpColorimetry.getY());
        overImage.setBounds(0, 0, player.getWidth(), player.getHeight());
        frameCropX = VideoPlayer.player.getLocation().x;
        frameCropY = VideoPlayer.player.getLocation().y;
        if (caseEnableCrop.isSelected()) {
            selection.setLocation(Math.round((float)Integer.valueOf(textCropPosX.getText()).intValue() / imageRatio), Math.round((float)Integer.valueOf(textCropPosY.getText()).intValue() / imageRatio));
            int w = Math.round((float)(Integer.valueOf(textCropWidth.getText()) * player.getHeight()) / (float)FFPROBE.imageHeight);
            int h = Math.round((float)(Integer.valueOf(textCropHeight.getText()) * player.getHeight()) / (float)FFPROBE.imageHeight);
            if (w > player.getWidth()) {
                w = player.getWidth();
            }
            if (h > player.getHeight()) {
                h = player.getHeight();
            }
            selection.setSize(w, h);
        } else {
            selection.setBounds(player.getWidth() / 4, player.getHeight() / 4, player.getWidth() / 2, player.getHeight() / 2);
            anchorRight = VideoPlayer.selection.getLocation().x + selection.getWidth();
            anchorBottom = VideoPlayer.selection.getLocation().y + selection.getHeight();
        }
        if (caseAddTimecode.isSelected() || caseShowTimecode.isSelected()) {
            timecode.setLocation(Math.round((float)Integer.valueOf(textTcPosX.getText()).intValue() / imageRatio), Math.round((float)Integer.valueOf(textTcPosY.getText()).intValue() / imageRatio));
            tcLocX = VideoPlayer.timecode.getLocation().x;
            tcLocY = VideoPlayer.timecode.getLocation().y;
        }
        if (caseAddText.isSelected() || caseShowFileName.isSelected()) {
            fileName.setLocation(Math.round((float)Integer.valueOf(textNamePosX.getText()).intValue() / imageRatio), Math.round((float)Integer.valueOf(textNamePosY.getText()).intValue() / imageRatio));
            fileLocX = VideoPlayer.fileName.getLocation().x;
            fileLocY = VideoPlayer.fileName.getLocation().y;
        }
        btnPrevious.setBounds(VideoPlayer.player.getLocation().x + VideoPlayer.player.getSize().width / 2 - 21 - 4, VideoPlayer.player.getLocation().y + VideoPlayer.player.getSize().height + 10, 22, 21);
        btnNext.setBounds(VideoPlayer.player.getLocation().x + VideoPlayer.player.getSize().width / 2 + 4, VideoPlayer.btnPrevious.getLocation().y, 22, 21);
        btnPlay.setBounds(VideoPlayer.btnPrevious.getLocation().x - 80 - 4, VideoPlayer.btnPrevious.getLocation().y, 80, 21);
        btnStop.setBounds(VideoPlayer.btnNext.getLocation().x + VideoPlayer.btnNext.getSize().width + 4, VideoPlayer.btnNext.getLocation().y, 80, 21);
        btnMarkIn.setBounds(VideoPlayer.btnPlay.getLocation().x - 22 - 4, VideoPlayer.btnPlay.getLocation().y, 22, 21);
        btnGoToIn.setBounds(VideoPlayer.btnMarkIn.getLocation().x - 40 - 4, VideoPlayer.btnMarkIn.getLocation().y, 40, 21);
        btnMarkOut.setBounds(VideoPlayer.btnStop.getLocation().x + VideoPlayer.btnStop.getSize().width + 4, VideoPlayer.btnStop.getLocation().y, 22, 21);
        btnGoToOut.setBounds(VideoPlayer.btnMarkOut.getLocation().x + VideoPlayer.btnMarkOut.getSize().width + 4, VideoPlayer.btnMarkOut.getLocation().y, 40, 21);
        showFPS.setBounds(player.getX() + player.getWidth() / 2, player.getY() - 18, player.getWidth() / 2, VideoPlayer.showFPS.getPreferredSize().height);
        showScale.setBounds(player.getX(), showFPS.getY(), player.getWidth() / 2, VideoPlayer.showScale.getPreferredSize().height);
        btnPreviousFile.setBounds(player.getX(), btnCapture.getY(), 84, 21);
        btnNextFile.setBounds(player.getX() + player.getWidth() - 84, btnPreviousFile.getY(), btnPreviousFile.getWidth(), 21);
        lblVideo.setBounds(btnPreviousFile.getX() + btnPreviousFile.getWidth() + 3, this.topPanel.getSize().height + 12, btnNextFile.getX() - btnPreviousFile.getX() + btnPreviousFile.getWidth() - 174, 16);
        sliderSpeed.setLocation(btnGoToIn.getX() - sliderSpeed.getWidth() - 4, btnGoToIn.getY() + 1);
        lblSpeed.setBounds(sliderSpeed.getX() - VideoPlayer.lblSpeed.getPreferredSize().width - 2, sliderSpeed.getY() + 2, VideoPlayer.lblSpeed.getPreferredSize().width, 16);
        lblVolume.setLocation(btnGoToOut.getX() + btnGoToOut.getWidth() + 7, lblSpeed.getY());
        sliderVolume.setBounds(lblVolume.getX() + lblVolume.getWidth() + 1, sliderSpeed.getY(), sliderSpeed.getWidth(), 22);
        this.title.setBounds(0, 0, frame.getWidth(), 28);
        if (!windowDrag) {
            if (Shutter.inputDeviceIsRunning || FFPROBE.totalLength <= 40) {
                VideoPlayer.loadImage(false);
                waveformIcon.setVisible(false);
            } else if (btnPlay.isEnabled()) {
                VideoPlayer.playerFreeze();
            }
        }
        VideoPlayer.refreshTimecodeAndText();
    }

    public static void totalDuration() {
        block33: {
            try {
                float totalIn = (float)(Integer.parseInt(caseInH.getText()) * 3600 + Integer.parseInt(caseInM.getText()) * 60 + Integer.parseInt(caseInS.getText())) * FFPROBE.currentFPS + (float)Integer.parseInt(caseInF.getText());
                float totalOut = (float)(Integer.parseInt(caseOutH.getText()) * 3600 + Integer.parseInt(caseOutM.getText()) * 60 + Integer.parseInt(caseOutS.getText())) * FFPROBE.currentFPS + (float)Integer.parseInt(caseOutF.getText());
                float total = totalOut - totalIn;
                total = Timecode.getNonDropFrameTC(total);
                if (comboMode.getSelectedItem().equals(Shutter.language.getProperty("removeMode"))) {
                    total = totalFrames - total;
                }
                durationH = (int)Math.floor(total / FFPROBE.currentFPS / 3600.0f);
                durationM = (int)Math.floor(total / FFPROBE.currentFPS / 60.0f % 60.0f);
                durationS = (int)Math.floor(total / FFPROBE.currentFPS % 60.0f);
                durationF = Math.round(total % FFPROBE.currentFPS);
                lblDuration.setText(String.valueOf(Shutter.language.getProperty("lblDuree")) + " " + durationH + "h " + durationM + "min " + durationS + "sec " + durationF + "i" + " | " + Shutter.language.getProperty("lblTotalFrames") + " " + (int)Math.ceil(total));
                if (total <= 0.0f) {
                    lblDuration.setVisible(false);
                    break block33;
                }
                if (!waveformContainer.isVisible() || Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles"))) break block33;
                lblDuration.setVisible(true);
                switch (Shutter.comboFonctions.getSelectedItem().toString()) {
                    case "MPEG-1": 
                    case "MPEG-2": 
                    case "AV1": 
                    case "OGV": 
                    case "VP8": 
                    case "VP9": 
                    case "WMV": 
                    case "Xvid": 
                    case "H.264": 
                    case "H.265": 
                    case "MJPEG": 
                    case "Blu-ray": {
                        Shutter.textH.setText(formatter.format(Math.floor(total / FFPROBE.currentFPS / 3600.0f)));
                        Shutter.textM.setText(formatter.format(Math.floor(total / FFPROBE.currentFPS / 60.0f) % 60.0));
                        Shutter.textS.setText(formatter.format(Math.floor(total / FFPROBE.currentFPS) % 60.0));
                        Shutter.textF.setText(formatter.format(Math.round(total % FFPROBE.currentFPS)));
                        FFPROBE.setFilesize();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void getTimePoint(float time) {
        if (caseInternalTc.isSelected()) {
            time += offset;
        }
        if (time - offset >= totalFrames) {
            sliderChange = true;
            slider.setValue(slider.getMaximum());
            sliderChange = false;
        }
        time = Timecode.setNonDropFrameTC(time);
        if (playerVideo != null && time - offset < totalFrames - 1.0f) {
            String h = formatter.format(Math.floor(time / FFPROBE.currentFPS / 3600.0f));
            String m = formatter.format(Math.floor(time / FFPROBE.currentFPS / 60.0f) % 60.0);
            String s = formatter.format(Math.floor(time / FFPROBE.currentFPS) % 60.0);
            String f = formatter.format(Math.floor(time % FFPROBE.currentFPS));
            String dropFrame = ":";
            if (Timecode.isDropFrame()) {
                dropFrame = ";";
            }
            lblPosition.setText(String.valueOf(Shutter.language.getProperty("grpTimecode")) + Shutter.language.getProperty("colon") + " " + h + ":" + m + ":" + s + dropFrame + f);
            if (waveformContainer.getCursor().equals(Cursor.getPredefinedCursor(10)) && mouseIsPressed) {
                VideoPlayer.updateGrpIn(time - offset);
            }
            if (waveformContainer.getCursor().equals(Cursor.getPredefinedCursor(11)) && mouseIsPressed) {
                VideoPlayer.updateGrpOut(time - offset + 1.0f);
            }
            if (!sliderChange && !windowDrag) {
                slider.setValue((int)playerCurrentFrame);
                int newValue = Math.round((float)(VideoPlayer.waveformContainer.getSize().width * slider.getValue()) / (float)slider.getMaximum());
                if (cursorWaveform != null) {
                    if (playerCurrentFrame <= 1.0f) {
                        cursorWaveform.setLocation(0, 0);
                    } else if (cursorWaveform.getX() > waveformContainer.getWidth() - 2) {
                        cursorWaveform.setLocation(waveformContainer.getWidth() - 2, 0);
                    } else if (newValue != cursorWaveform.getX()) {
                        cursorWaveform.setLocation(newValue, 0);
                    }
                }
            }
        }
        if (time - offset >= totalFrames - 2.0f) {
            btnPlay.setText(Shutter.language.getProperty("btnPlay"));
        }
    }

    public static void loadSettings(final File encFile) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        frame.setCursor(Cursor.getPredefinedCursor(3));
                        do {
                            Thread.sleep(10L);
                        } while (btnPlay == null);
                        File fXmlFile = encFile;
                        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                        Document doc = dBuilder.parse(fXmlFile);
                        doc.getDocumentElement().normalize();
                        NodeList nList = doc.getElementsByTagName("Component");
                        int temp = 0;
                        while (temp < nList.getLength()) {
                            Node nNode = nList.item(temp);
                            if (nNode.getNodeType() == 1) {
                                String[] s2;
                                Component p;
                                Element eElement = (Element)nNode;
                                Component[] componentArray = frame.getContentPane().getComponents();
                                int n = componentArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    p = componentArray[n2];
                                    if (p.getName() != "" && p.getName() != null && p.getName().equals(eElement.getElementsByTagName("Name").item(0).getFirstChild().getTextContent()) && p instanceof JCheckBox) {
                                        if (Boolean.valueOf(eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent()).booleanValue()) {
                                            if (!((JCheckBox)p).isSelected()) {
                                                ((JCheckBox)p).doClick();
                                            }
                                        } else if (((JCheckBox)p).isSelected()) {
                                            ((JCheckBox)p).doClick();
                                        }
                                        ((JCheckBox)p).setEnabled(Boolean.valueOf(eElement.getElementsByTagName("Enable").item(0).getFirstChild().getTextContent()));
                                        ((JCheckBox)p).setVisible(Boolean.valueOf(eElement.getElementsByTagName("Visible").item(0).getFirstChild().getTextContent()));
                                    }
                                    ++n2;
                                }
                                componentArray = panelColorimetryComponents.getComponents();
                                n = componentArray.length;
                                n2 = 0;
                                while (n2 < n) {
                                    p = componentArray[n2];
                                    if (p.getName() != "" && p.getName() != null && p.getName().equals(eElement.getElementsByTagName("Name").item(0).getFirstChild().getTextContent()) && p instanceof JSlider) {
                                        ((JSlider)p).setValue(Integer.valueOf(eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent()));
                                        ((JSlider)p).setEnabled(Boolean.valueOf(eElement.getElementsByTagName("Enable").item(0).getFirstChild().getTextContent()));
                                        ((JSlider)p).setVisible(Boolean.valueOf(eElement.getElementsByTagName("Visible").item(0).getFirstChild().getTextContent()));
                                    }
                                    ++n2;
                                }
                                componentArray = grpCorrections.getComponents();
                                n = componentArray.length;
                                n2 = 0;
                                while (n2 < n) {
                                    p = componentArray[n2];
                                    if (p.getName() != "" && p.getName() != null && p.getName().equals(eElement.getElementsByTagName("Name").item(0).getFirstChild().getTextContent())) {
                                        if (p instanceof JCheckBox) {
                                            if (Boolean.valueOf(eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent()).booleanValue()) {
                                                if (!((JCheckBox)p).isSelected()) {
                                                    ((JCheckBox)p).doClick();
                                                }
                                            } else if (((JCheckBox)p).isSelected()) {
                                                ((JCheckBox)p).doClick();
                                            }
                                            ((JCheckBox)p).setEnabled(Boolean.valueOf(eElement.getElementsByTagName("Enable").item(0).getFirstChild().getTextContent()));
                                            ((JCheckBox)p).setVisible(Boolean.valueOf(eElement.getElementsByTagName("Visible").item(0).getFirstChild().getTextContent()));
                                        } else if (p instanceof JSlider) {
                                            ((JSlider)p).setValue(Integer.valueOf(eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent()));
                                            ((JSlider)p).setEnabled(Boolean.valueOf(eElement.getElementsByTagName("Enable").item(0).getFirstChild().getTextContent()));
                                            ((JSlider)p).setVisible(Boolean.valueOf(eElement.getElementsByTagName("Visible").item(0).getFirstChild().getTextContent()));
                                        }
                                    }
                                    ++n2;
                                }
                                componentArray = grpCrop.getComponents();
                                n = componentArray.length;
                                n2 = 0;
                                while (n2 < n) {
                                    p = componentArray[n2];
                                    if (p.getName() != "" && p.getName() != null && p.getName().equals(eElement.getElementsByTagName("Name").item(0).getFirstChild().getTextContent())) {
                                        if (p instanceof JCheckBox) {
                                            if (Boolean.valueOf(eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent()).booleanValue()) {
                                                if (!((JCheckBox)p).isSelected()) {
                                                    ((JCheckBox)p).doClick();
                                                }
                                            } else if (((JCheckBox)p).isSelected()) {
                                                ((JCheckBox)p).doClick();
                                            }
                                            ((JCheckBox)p).setEnabled(Boolean.valueOf(eElement.getElementsByTagName("Enable").item(0).getFirstChild().getTextContent()));
                                            ((JCheckBox)p).setVisible(Boolean.valueOf(eElement.getElementsByTagName("Visible").item(0).getFirstChild().getTextContent()));
                                        } else if (p instanceof JTextField) {
                                            int value;
                                            ((JTextField)p).setText(eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent());
                                            ((JTextField)p).setEnabled(Boolean.valueOf(eElement.getElementsByTagName("Enable").item(0).getFirstChild().getTextContent()));
                                            ((JTextField)p).setVisible(Boolean.valueOf(eElement.getElementsByTagName("Visible").item(0).getFirstChild().getTextContent()));
                                            if (p.getName().equals("textPosX") && textCropPosX.getText().length() > 0) {
                                                value = Math.round((float)(Integer.valueOf(textCropPosX.getText()) * player.getHeight()) / (float)FFPROBE.imageHeight);
                                                selection.setLocation(value, VideoPlayer.selection.getLocation().y);
                                            }
                                            if (p.getName().equals("textPosY") && textCropPosY.getText().length() > 0) {
                                                value = Math.round((float)(Integer.valueOf(textCropPosY.getText()) * player.getWidth()) / (float)FFPROBE.imageWidth);
                                                selection.setLocation(VideoPlayer.selection.getLocation().x, value);
                                            }
                                            if (p.getName().equals("textWidth") && textCropWidth.getText().length() > 0) {
                                                value = Math.round((float)(Integer.valueOf(textCropWidth.getText()) * player.getHeight()) / (float)FFPROBE.imageHeight);
                                                selection.setSize(value, selection.getHeight());
                                            }
                                            if (p.getName().equals("textHeight") && textCropHeight.getText().length() > 0) {
                                                value = Math.round((float)(Integer.valueOf(textCropHeight.getText()) * player.getWidth()) / (float)FFPROBE.imageWidth);
                                                selection.setSize(selection.getWidth(), value);
                                            }
                                        }
                                    }
                                    ++n2;
                                }
                                componentArray = grpOverlay.getComponents();
                                n = componentArray.length;
                                n2 = 0;
                                while (n2 < n) {
                                    p = componentArray[n2];
                                    if (p.getName() != "" && p.getName() != null && p.getName().equals(eElement.getElementsByTagName("Name").item(0).getFirstChild().getTextContent())) {
                                        if (p instanceof JPanel) {
                                            String[] s = eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent().replace("]", "").replace("r=", "").replace("g=", "").replace("b=", "").split("\\[");
                                            s2 = s[1].split(",");
                                            ((JPanel)p).setBackground(new Color(Integer.valueOf(s2[0]), Integer.valueOf(s2[1]), Integer.valueOf(s2[2])));
                                            if (p.getName().equals("panelTcColor")) {
                                                foregroundColor = panelTcColor.getBackground();
                                            } else if (p.getName().equals("panelTcColor2")) {
                                                backgroundColor = panelTcColor2.getBackground();
                                            }
                                        }
                                        if (p instanceof JCheckBox) {
                                            if (Boolean.valueOf(eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent()).booleanValue()) {
                                                if (!((JCheckBox)p).isSelected()) {
                                                    ((JCheckBox)p).doClick();
                                                }
                                            } else if (((JCheckBox)p).isSelected()) {
                                                ((JCheckBox)p).doClick();
                                            }
                                            ((JCheckBox)p).setEnabled(Boolean.valueOf(eElement.getElementsByTagName("Enable").item(0).getFirstChild().getTextContent()));
                                            ((JCheckBox)p).setVisible(Boolean.valueOf(eElement.getElementsByTagName("Visible").item(0).getFirstChild().getTextContent()));
                                        } else if (p instanceof JLabel) {
                                            ((JLabel)p).setText(eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent());
                                            ((JLabel)p).setEnabled(Boolean.valueOf(eElement.getElementsByTagName("Enable").item(0).getFirstChild().getTextContent()));
                                            ((JLabel)p).setVisible(Boolean.valueOf(eElement.getElementsByTagName("Visible").item(0).getFirstChild().getTextContent()));
                                        } else if (p instanceof JComboBox) {
                                            ((JComboBox)p).setSelectedItem(eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent());
                                            ((JComboBox)p).setEnabled(Boolean.valueOf(eElement.getElementsByTagName("Enable").item(0).getFirstChild().getTextContent()));
                                            ((JComboBox)p).setVisible(Boolean.valueOf(eElement.getElementsByTagName("Visible").item(0).getFirstChild().getTextContent()));
                                        } else if (p instanceof JTextField) {
                                            long time = System.currentTimeMillis();
                                            do {
                                                try {
                                                    Thread.sleep(100L);
                                                }
                                                catch (InterruptedException interruptedException) {
                                                    // empty catch block
                                                }
                                                if (System.currentTimeMillis() - time <= 1000L) continue;
                                                frameIsComplete = true;
                                            } while (!frameIsComplete);
                                            ((JTextField)p).setText(eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent());
                                            ((JTextField)p).setEnabled(Boolean.valueOf(eElement.getElementsByTagName("Enable").item(0).getFirstChild().getTextContent()));
                                            ((JTextField)p).setVisible(Boolean.valueOf(eElement.getElementsByTagName("Visible").item(0).getFirstChild().getTextContent()));
                                            if (p.getName().equals("textNamePosX")) {
                                                fileName.setLocation(Math.round((float)Integer.valueOf(textNamePosX.getText()).intValue() / imageRatio), VideoPlayer.fileName.getLocation().y);
                                            }
                                            if (p.getName().equals("textNamePosY")) {
                                                fileName.setLocation(VideoPlayer.fileName.getLocation().x, Math.round((float)Integer.valueOf(textNamePosY.getText()).intValue() / imageRatio));
                                            }
                                            if (p.getName().equals("textTcPosY")) {
                                                timecode.setLocation(VideoPlayer.timecode.getLocation().x, Math.round((float)Integer.valueOf(textTcPosY.getText()).intValue() / imageRatio));
                                            }
                                            if (p.getName().equals("textTcPosX")) {
                                                timecode.setLocation(Math.round((float)Integer.valueOf(textTcPosX.getText()).intValue() / imageRatio), VideoPlayer.timecode.getLocation().y);
                                            }
                                        }
                                    }
                                    ++n2;
                                }
                                componentArray = grpSubtitles.getComponents();
                                n = componentArray.length;
                                n2 = 0;
                                while (n2 < n) {
                                    p = componentArray[n2];
                                    if (p.getName() != "" && p.getName() != null && p.getName().equals(eElement.getElementsByTagName("Name").item(0).getFirstChild().getTextContent())) {
                                        if (p instanceof JCheckBox) {
                                            if (Boolean.valueOf(eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent()).booleanValue()) {
                                                if (!((JCheckBox)p).isSelected()) {
                                                    ((JCheckBox)p).doClick();
                                                }
                                            } else if (((JCheckBox)p).isSelected()) {
                                                ((JCheckBox)p).doClick();
                                            }
                                            ((JCheckBox)p).setEnabled(Boolean.valueOf(eElement.getElementsByTagName("Enable").item(0).getFirstChild().getTextContent()));
                                            ((JCheckBox)p).setVisible(Boolean.valueOf(eElement.getElementsByTagName("Visible").item(0).getFirstChild().getTextContent()));
                                        } else if (p instanceof JPanel) {
                                            String[] s = eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent().replace("]", "").replace("r=", "").replace("g=", "").replace("b=", "").split("\\[");
                                            s2 = s[1].split(",");
                                            ((JPanel)p).setBackground(new Color(Integer.valueOf(s2[0]), Integer.valueOf(s2[1]), Integer.valueOf(s2[2])));
                                            if (p.getName().equals("panelSubsColor")) {
                                                fontSubsColor = panelSubsColor.getBackground();
                                            } else if (p.getName().equals("panelSubsColor2")) {
                                                backgroundSubsColor = panelSubsColor2.getBackground();
                                            }
                                        } else if (p instanceof JButton) {
                                            String[] s = eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent().replace("]", "").replace("r=", "").replace("g=", "").replace("b=", "").split("\\[");
                                            s2 = s[1].split(",");
                                            if (Integer.valueOf(s2[0]) == 0 && Integer.valueOf(s2[1]) == 0 && Integer.valueOf(s2[2]) == 0) {
                                                ((JButton)p).setForeground(Color.BLACK);
                                            } else {
                                                ((JButton)p).setForeground(new Color(Integer.valueOf(s2[0]), Integer.valueOf(s2[1]), Integer.valueOf(s2[2])));
                                            }
                                        } else if (p instanceof JLabel) {
                                            ((JLabel)p).setText(eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent());
                                            ((JLabel)p).setEnabled(Boolean.valueOf(eElement.getElementsByTagName("Enable").item(0).getFirstChild().getTextContent()));
                                            ((JLabel)p).setVisible(Boolean.valueOf(eElement.getElementsByTagName("Visible").item(0).getFirstChild().getTextContent()));
                                        } else if (p instanceof JComboBox) {
                                            ((JComboBox)p).setSelectedItem(eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent());
                                            ((JComboBox)p).setEnabled(Boolean.valueOf(eElement.getElementsByTagName("Enable").item(0).getFirstChild().getTextContent()));
                                            ((JComboBox)p).setVisible(Boolean.valueOf(eElement.getElementsByTagName("Visible").item(0).getFirstChild().getTextContent()));
                                        } else if (p instanceof JTextField) {
                                            ((JTextField)p).setText(eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent());
                                            ((JTextField)p).setEnabled(Boolean.valueOf(eElement.getElementsByTagName("Enable").item(0).getFirstChild().getTextContent()));
                                            ((JTextField)p).setVisible(Boolean.valueOf(eElement.getElementsByTagName("Visible").item(0).getFirstChild().getTextContent()));
                                        }
                                    }
                                    ++n2;
                                }
                                componentArray = grpWatermark.getComponents();
                                n = componentArray.length;
                                n2 = 0;
                                while (n2 < n) {
                                    p = componentArray[n2];
                                    if (p.getName() != "" && p.getName() != null && p.getName().equals(eElement.getElementsByTagName("Name").item(0).getFirstChild().getTextContent())) {
                                        if (p instanceof JCheckBox) {
                                            if (Boolean.valueOf(eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent()).booleanValue()) {
                                                if (!((JCheckBox)p).isSelected()) {
                                                    ((JCheckBox)p).doClick();
                                                }
                                            } else if (((JCheckBox)p).isSelected()) {
                                                ((JCheckBox)p).doClick();
                                            }
                                            ((JCheckBox)p).setEnabled(Boolean.valueOf(eElement.getElementsByTagName("Enable").item(0).getFirstChild().getTextContent()));
                                            ((JCheckBox)p).setVisible(Boolean.valueOf(eElement.getElementsByTagName("Visible").item(0).getFirstChild().getTextContent()));
                                        } else if (p instanceof JTextField) {
                                            ((JTextField)p).setText(eElement.getElementsByTagName("Value").item(0).getFirstChild().getTextContent());
                                            ((JTextField)p).setEnabled(Boolean.valueOf(eElement.getElementsByTagName("Enable").item(0).getFirstChild().getTextContent()));
                                            ((JTextField)p).setVisible(Boolean.valueOf(eElement.getElementsByTagName("Visible").item(0).getFirstChild().getTextContent()));
                                        }
                                    }
                                    ++n2;
                                }
                            }
                            ++temp;
                        }
                        VideoPlayer.loadImage(false);
                        if (frameVideo != null) {
                            player.repaint();
                        }
                        if (caseEnableCrop.isSelected()) {
                            selection.setLocation(Math.round((float)Integer.valueOf(textCropPosX.getText()).intValue() / imageRatio), Math.round((float)Integer.valueOf(textCropPosY.getText()).intValue() / imageRatio));
                            int w = Math.round((float)(Integer.valueOf(textCropWidth.getText()) * player.getHeight()) / (float)FFPROBE.imageHeight);
                            int h = Math.round((float)(Integer.valueOf(textCropHeight.getText()) * player.getHeight()) / (float)FFPROBE.imageHeight);
                            if (w > player.getWidth()) {
                                w = player.getWidth();
                            }
                            if (h > player.getHeight()) {
                                h = player.getHeight();
                            }
                            selection.setSize(w, h);
                            frameCropX = VideoPlayer.player.getLocation().x;
                            frameCropY = VideoPlayer.player.getLocation().y;
                            anchorRight = VideoPlayer.selection.getLocation().x + selection.getWidth();
                            anchorBottom = VideoPlayer.selection.getLocation().y + selection.getHeight();
                            VideoPlayer.checkSelection();
                        }
                        if (caseAddTimecode.isSelected() || caseShowTimecode.isSelected()) {
                            timecode.setLocation(Math.round((float)Integer.valueOf(textTcPosX.getText()).intValue() / imageRatio), Math.round((float)Integer.valueOf(textTcPosY.getText()).intValue() / imageRatio));
                            tcLocX = VideoPlayer.timecode.getLocation().x;
                            tcLocY = VideoPlayer.timecode.getLocation().y;
                        }
                        if (caseAddText.isSelected() || caseShowFileName.isSelected()) {
                            fileName.setLocation(Math.round((float)Integer.valueOf(textNamePosX.getText()).intValue() / imageRatio), Math.round((float)Integer.valueOf(textNamePosY.getText()).intValue() / imageRatio));
                            fileLocX = VideoPlayer.fileName.getLocation().x;
                            fileLocY = VideoPlayer.fileName.getLocation().y;
                        }
                        if (caseAddSubtitles.isSelected()) {
                            if (Integer.parseInt(textSubsWidth.getText()) >= FFPROBE.imageWidth) {
                                subsCanvas.setBounds(0, 0, player.getWidth(), (int)((float)player.getHeight() + (float)Integer.parseInt(textSubtitlesPosition.getText()) / ((float)FFPROBE.imageHeight / (float)player.getHeight())));
                            } else {
                                subsCanvas.setSize((int)((float)Integer.parseInt(textSubsWidth.getText()) / ((float)FFPROBE.imageHeight / (float)player.getHeight())), (int)((float)player.getHeight() + (float)Integer.parseInt(textSubtitlesPosition.getText()) / ((float)FFPROBE.imageHeight / (float)player.getHeight())));
                                subsCanvas.setLocation((player.getWidth() - subsCanvas.getWidth()) / 2, 0);
                            }
                        }
                        if (caseAddWatermark.isSelected()) {
                            VideoPlayer.loadWatermark(Integer.parseInt(textWatermarkSize.getText()));
                            logo.setLocation((int)Math.floor((float)Integer.valueOf(textWatermarkPosX.getText()).intValue() / imageRatio), (int)Math.floor((float)Integer.valueOf(textWatermarkPosY.getText()).intValue() / imageRatio));
                            logoLocX = VideoPlayer.logo.getLocation().x;
                            logoLocY = VideoPlayer.logo.getLocation().y;
                        }
                        timecode.repaint();
                        fileName.repaint();
                        selection.repaint();
                        overImage.repaint();
                    }
                    catch (Exception exception) {
                        frame.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
                finally {
                    frame.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        t.start();
    }

    private class ComboRenderer
    extends BasicComboBoxRenderer {
        private static final long serialVersionUID = 1L;
        private JComboBox comboBox;
        final DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();
        private int row;

        private ComboRenderer(JComboBox fontsBox) {
            this.comboBox = fontsBox;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (list.getModel().getSize() > 0) {
                Accessible accessible = this.comboBox.getUI().getAccessibleChild(this.comboBox, 0);
            }
            JLabel renderer = (JLabel)this.defaultRenderer.getListCellRendererComponent((JList<?>)list, value, this.row, isSelected, cellHasFocus);
            Object fntObj = value;
            String fontFamilyName = (String)fntObj;
            this.setFont(new Font(fontFamilyName, 0, 16));
            return this;
        }
    }

    private class ComboRendererOverlay
    extends BasicComboBoxRenderer {
        private static final long serialVersionUID = 1L;
        private JComboBox comboBox;
        final DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();
        private int row;

        private ComboRendererOverlay(JComboBox fontsBox) {
            this.comboBox = fontsBox;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (list.getModel().getSize() > 0) {
                Accessible accessible = this.comboBox.getUI().getAccessibleChild(this.comboBox, 0);
            }
            JLabel renderer = (JLabel)this.defaultRenderer.getListCellRendererComponent((JList<?>)list, value, this.row, isSelected, cellHasFocus);
            Object fntObj = value;
            String fontFamilyName = (String)fntObj;
            this.setFont(new Font(fontFamilyName, 0, 16));
            return this;
        }
    }

    private static class MouseLogoPosition {
        static int mouseX;
        static int offsetX;
        static int mouseY;
        static int offsetY;

        private MouseLogoPosition() {
        }
    }

    private static class MouseNamePosition {
        static int mouseX;
        static int offsetX;
        static int mouseY;
        static int offsetY;

        private MouseNamePosition() {
        }
    }

    private static class MouseSubSize {
        static int mouseX;
        static int offsetX;

        private MouseSubSize() {
        }
    }

    private static class MouseSubsPosition {
        static int mouseX;
        static int offsetX;
        static int mouseY;
        static int offsetY;

        private MouseSubsPosition() {
        }
    }

    private static class MouseTcPosition {
        static int mouseX;
        static int offsetX;
        static int mouseY;
        static int offsetY;

        private MouseTcPosition() {
        }
    }
}

