/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.Shutter;
import application.SubtitlesEdit;
import application.SubtitlesHelp;
import application.Utils;
import application.VideoPlayer;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.event.WindowStateListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import library.FFPROBE;
import org.apache.commons.io.FileUtils;

public class SubtitlesTimeline {
    public static JFrame frame;
    public static JTextPane txtSubtitles;
    private static JButton lblHelp;
    public static File srt;
    public static int number;
    public static long actualSubIn;
    public static long actualSubOut;
    private static int previousSub;
    private static ArrayList<Integer> selectedSubs;
    public static Color fontColor;
    public static int fontSize;
    public static long timeIn;
    private static long keyboardTime;
    private static boolean keyboardLoop;
    private static boolean isSaving;
    private static int currentFrameHeight;
    public static double currentCursorPosition;
    public static long currentTime;
    public static JScrollBar timelineScrollBar;
    private static int currentScrollBarValue;
    public static double zoom;
    boolean enableZoom = false;
    private static boolean enableAutoScroll;
    private static boolean control;
    private static boolean shift;
    private static boolean controlRight;
    private static boolean txtSubtitlesHasFocus;
    public static JButton btnAdd;
    public static JButton btnCut;
    public static JButton btnDelete;
    private static JButton btnEditAll;
    public static JButton btnStart;
    public static JButton btnEnd;
    private JButton btnI = new JButton("I");
    private JButton btnG = new JButton(Shutter.language.getProperty("btnG"));
    private static JCheckBox caseShowWaveform;
    private static JLabel lblOffset;
    public static JTextField textOffset;
    public static final JPanel timeline;
    public static final JPanel cursor;
    public static JLabel waveform;
    private static Thread waveformReload;
    private static File dirTemp;
    private static int MousePositionX;
    private static int MouseTextWidth;
    private static int MouseTextLocationX;

    static {
        number = 0;
        actualSubIn = 0L;
        actualSubOut = 0L;
        previousSub = number;
        selectedSubs = new ArrayList();
        keyboardLoop = false;
        isSaving = false;
        currentCursorPosition = 1.0;
        currentTime = System.currentTimeMillis();
        timelineScrollBar = new JScrollBar();
        zoom = 0.1;
        enableAutoScroll = true;
        control = false;
        shift = false;
        controlRight = false;
        txtSubtitlesHasFocus = false;
        btnEditAll = new JButton(Shutter.language.getProperty("btnModify"));
        caseShowWaveform = new JCheckBox(Shutter.language.getProperty("caseShowWaveform"));
        lblOffset = new JLabel(Shutter.language.getProperty("lblOffset"));
        textOffset = new JTextField("0");
        timeline = new JPanel();
        cursor = new JPanel();
        waveform = null;
        dirTemp = new File(String.valueOf(Shutter.dirTemp) + "subtitles");
    }

    public SubtitlesTimeline(int positionX, int positionY) {
        frame = new JFrame();
        frame.setResizable(true);
        frame.setDefaultCloseOperation(2);
        frame.setIconImage(new ImageIcon(this.getClass().getClassLoader().getResource("contents/icon.png")).getImage());
        frame.getContentPane().setBackground(new Color(45, 45, 45));
        frame.getContentPane().setLayout(null);
        frame.setAlwaysOnTop(true);
        frame.setSize(1000, 270);
        currentFrameHeight = 270;
        frame.setMinimumSize(new Dimension(1000, 270));
        frame.setLocation(positionX, positionY);
        frame.setForeground(Color.WHITE);
        Toolkit.getDefaultToolkit().setDynamicLayout(false);
        frame.setTitle(String.valueOf(Shutter.language.getProperty("frameSubtitles")) + " - 0 " + Shutter.language.getProperty("subtitlesLower"));
        frame.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent arg0) {
                if (frame.hasFocus() || txtSubtitles.hasFocus()) {
                    SubtitlesEdit.isWriting = false;
                }
            }
        });
        frame.addWindowListener(new WindowListener(){

            @Override
            public void windowActivated(WindowEvent arg0) {
            }

            @Override
            public void windowClosed(WindowEvent arg0) {
                Utils.changeFrameVisibility(VideoPlayer.frame, true);
                if (VideoPlayer.playerVideo != null) {
                    VideoPlayer.playerStop();
                }
                Shutter.caseInAndOut.setSelected(false);
                Utils.changeFrameVisibility(Shutter.frame, false);
                Utils.changeFrameVisibility(frame, true);
                if (Shutter.comboFonctions.getSelectedItem().equals("H.264") || Shutter.comboFonctions.getSelectedItem().equals("H.264")) {
                    FFPROBE.setLength();
                }
                if (Shutter.comboFonctions.getSelectedItem().equals(Shutter.language.getProperty("functionSubtitles"))) {
                    Shutter.caseInAndOut.setSelected(false);
                    frame.dispose();
                    if (SubtitlesHelp.frame != null) {
                        SubtitlesHelp.frame.dispose();
                    }
                    if (SubtitlesEdit.frame != null) {
                        SubtitlesEdit.frame.dispose();
                    }
                }
                if (srt.exists()) {
                    int q = JOptionPane.showConfirmDialog(Shutter.frame, Shutter.language.getProperty("integrateSRT"), Shutter.language.getProperty("subtitles"), 0);
                    if (q == 0) {
                        if (VideoPlayer.caseAddSubtitles.isSelected()) {
                            VideoPlayer.caseAddSubtitles.doClick();
                        }
                        VideoPlayer.caseAddSubtitles.doClick();
                    } else if (Shutter.caseOpenFolderAtEnd1.isSelected()) {
                        if (System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Linux")) {
                            try {
                                Runtime.getRuntime().exec(new String[]{"/usr/bin/open", "-R", srt.toString()});
                            }
                            catch (Exception exception) {}
                        } else if (System.getProperty("os.name").contains("Linux")) {
                            try {
                                Desktop.getDesktop().open(srt.getParentFile());
                            }
                            catch (Exception exception) {}
                        } else {
                            try {
                                Runtime.getRuntime().exec("explorer.exe /select," + srt.toString());
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (dirTemp.exists()) {
                    try {
                        FileUtils.deleteDirectory(dirTemp);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (VideoPlayer.waveform.exists()) {
                    VideoPlayer.waveform.delete();
                }
                timeline.removeAll();
            }

            @Override
            public void windowClosing(WindowEvent arg0) {
            }

            @Override
            public void windowDeactivated(WindowEvent arg0) {
            }

            @Override
            public void windowDeiconified(WindowEvent arg0) {
            }

            @Override
            public void windowIconified(WindowEvent arg0) {
            }

            @Override
            public void windowOpened(WindowEvent arg0) {
                if (dirTemp.exists()) {
                    try {
                        FileUtils.deleteDirectory(dirTemp);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                SubtitlesTimeline.subtitlesNumber();
                SubtitlesTimeline.setSubtitles(srt);
            }
        });
        frame.addWindowStateListener(new WindowStateListener(){

            @Override
            public void windowStateChanged(WindowEvent e) {
                if (e.getNewState() == 6) {
                    frame.setExtendedState(0);
                }
                frame.setBounds(0, GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds().height - frame.getHeight(), Toolkit.getDefaultToolkit().getScreenSize().width, 270);
                VideoPlayer.addWaveform(true);
            }
        });
        frame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                frame.setSize(Math.round(frame.getWidth() / 100) * 100, frame.getHeight());
                VideoPlayer.addWaveform(true);
            }
        });
        txtSubtitles = new JTextPane();
        SimpleAttributeSet attribs = new SimpleAttributeSet();
        StyleConstants.setAlignment(attribs, 1);
        txtSubtitles.setCaretColor(Color.BLACK);
        txtSubtitles.setParagraphAttributes(attribs, true);
        txtSubtitles.setSelectionColor(new Color(71, 163, 236, 127));
        txtSubtitles.setFont(new Font(Shutter.montserratFont, 0, 12));
        if (System.getProperty("os.name").contains("Windows")) {
            txtSubtitles.setBounds(10, 36, frame.getWidth() - 36, 36);
        } else {
            txtSubtitles.setBounds(10, 36, frame.getWidth() - 24, 36);
        }
        txtSubtitles.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                String[] text = txtSubtitles.getText().split("\\r?\\n");
                if (e.getKeyCode() == 10 && text.length > 1) {
                    e.consume();
                }
                keyboardTime = System.currentTimeMillis();
                if (txtSubtitles.getText().equals("Title") && e.getKeyCode() != 32 && (e.getModifiersEx() & 0x100) == 0 && (e.getModifiersEx() & 0x80) == 0) {
                    txtSubtitles.setText("");
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (((e.getModifiersEx() & 0x100) != 0 || (e.getModifiersEx() & 0x80) != 0) && e.getKeyCode() == 65) {
                    txtSubtitles.setSelectionStart(0);
                    txtSubtitles.setSelectionEnd(txtSubtitles.getText().length());
                }
                if (e.getKeyCode() != 36 && e.getKeyCode() != 35 && e.getKeyCode() != 9) {
                    boolean newSubtitle = true;
                    if (txtSubtitles.getText().isEmpty() || txtSubtitles.getText() == null || txtSubtitles.getText() == "") {
                        if (KeyEvent.getKeyText(e.getKeyCode()).length() == 1) {
                            txtSubtitles.setText(String.valueOf(e.getKeyChar()));
                        }
                    } else if (!txtSubtitlesHasFocus && KeyEvent.getKeyText(e.getKeyCode()).length() == 1 && txtSubtitles.getText().equals("Title") && e.getKeyCode() != 32 && (e.getModifiersEx() & 0x100) == 0 && (e.getModifiersEx() & 0x80) == 0 && e.getKeyCode() != 9) {
                        txtSubtitles.setText("");
                        txtSubtitles.setText(String.valueOf(txtSubtitles.getText()) + e.getKeyChar());
                    }
                    Component[] componentArray = timeline.getComponents();
                    int n = componentArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Component c = componentArray[n2];
                        if (c instanceof JTextPane && SubtitlesTimeline.cursor.getLocation().x >= c.getLocation().x && SubtitlesTimeline.cursor.getLocation().x < c.getLocation().x + c.getWidth()) {
                            ((JTextPane)c).setText(txtSubtitles.getText());
                            SubtitlesTimeline.repaintTimeline();
                            newSubtitle = false;
                            break;
                        }
                        ++n2;
                    }
                    if (newSubtitle) {
                        SubtitlesTimeline.addSubtitles(false);
                    } else if (txtSubtitles.getText().length() > 0) {
                        this.keyboardSaveTime();
                    }
                }
            }

            private void keyboardSaveTime() {
                if (!keyboardLoop) {
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            do {
                                keyboardLoop = true;
                                try {
                                    Thread.sleep(100L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            } while (keyboardTime + 1000L > System.currentTimeMillis());
                            SubtitlesTimeline.saveSubtitles(true, false);
                            keyboardLoop = false;
                        }
                    });
                    t.start();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        frame.getContentPane().add(txtSubtitles);
        JLabel lblTexte = new JLabel(Shutter.language.getProperty("lblTexte"));
        lblTexte.setFont(new Font(Shutter.freeSansFont, 0, 13));
        lblTexte.setBounds(10, 12, lblTexte.getPreferredSize().width, 14);
        frame.getContentPane().add(lblTexte);
        this.btnI.setFont(new Font("Courier New", 2, 13));
        this.btnI.setBounds(lblTexte.getLocation().x + lblTexte.getWidth() + 7, 8, 22, 22);
        frame.getContentPane().add(this.btnI);
        this.btnI.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String[] text = txtSubtitles.getText().split("\\r?\\n");
                if (txtSubtitles.getText().contains("<i>")) {
                    txtSubtitles.setText(txtSubtitles.getText().replace("<i>", "").replace("</i>", ""));
                } else if (txtSubtitles.getSelectedText() != null && text[0].contains(txtSubtitles.getSelectedText())) {
                    txtSubtitles.setText("<i>" + text[0] + "</i>" + System.lineSeparator() + text[1]);
                } else if (txtSubtitles.getSelectedText() != null && text[1].contains(txtSubtitles.getSelectedText())) {
                    txtSubtitles.setText(String.valueOf(text[0]) + System.lineSeparator() + "<i>" + text[1] + "</i>");
                } else {
                    txtSubtitles.setText("<i>" + txtSubtitles.getText() + "</i>");
                }
                Component[] componentArray = timeline.getComponents();
                int n = componentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Component c = componentArray[n2];
                    if (c instanceof JTextPane && SubtitlesTimeline.cursor.getLocation().x >= c.getLocation().x && SubtitlesTimeline.cursor.getLocation().x < c.getLocation().x + c.getWidth()) {
                        ((JTextPane)c).setText(txtSubtitles.getText());
                        SubtitlesTimeline.repaintTimeline();
                        break;
                    }
                    ++n2;
                }
                if (txtSubtitles.getText().length() > 0) {
                    SubtitlesTimeline.saveSubtitles(true, false);
                }
            }
        });
        this.btnG.setFont(new Font(Shutter.montserratFont, 0, 13));
        this.btnG.setBounds(this.btnI.getLocation().x + this.btnI.getWidth() + 4, 8, 22, 22);
        frame.getContentPane().add(this.btnG);
        this.btnG.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String[] text = txtSubtitles.getText().split("\\r?\\n");
                if (txtSubtitles.getText().contains("<b>")) {
                    txtSubtitles.setText(txtSubtitles.getText().replace("<b>", "").replace("</b>", ""));
                } else if (txtSubtitles.getSelectedText() != null && text[0].contains(txtSubtitles.getSelectedText())) {
                    txtSubtitles.setText("<b>" + text[0] + "</b>" + System.lineSeparator() + text[1]);
                } else if (txtSubtitles.getSelectedText() != null && text[1].contains(txtSubtitles.getSelectedText())) {
                    txtSubtitles.setText(String.valueOf(text[0]) + System.lineSeparator() + "<b>" + text[1] + "</b>");
                } else {
                    txtSubtitles.setText("<b>" + txtSubtitles.getText() + "</b>");
                }
                Component[] componentArray = timeline.getComponents();
                int n = componentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Component c = componentArray[n2];
                    if (c instanceof JTextPane && SubtitlesTimeline.cursor.getLocation().x >= c.getLocation().x && SubtitlesTimeline.cursor.getLocation().x < c.getLocation().x + c.getWidth()) {
                        ((JTextPane)c).setText(txtSubtitles.getText());
                        SubtitlesTimeline.repaintTimeline();
                        break;
                    }
                    ++n2;
                }
                if (txtSubtitles.getText().length() > 0) {
                    SubtitlesTimeline.saveSubtitles(true, false);
                }
            }
        });
        lblHelp = new JButton(Shutter.language.getProperty("lblHelp"));
        lblHelp.setFont(new Font(Shutter.montserratFont, 0, 12));
        lblHelp.setBounds(this.btnG.getX() + this.btnG.getWidth() + 4, 8, SubtitlesTimeline.lblHelp.getPreferredSize().width, 22);
        frame.getContentPane().add(lblHelp);
        lblHelp.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                if (SubtitlesHelp.frame == null) {
                    new SubtitlesHelp();
                } else if (SubtitlesHelp.frame.isVisible()) {
                    SubtitlesHelp.frame.setVisible(false);
                } else if (!SubtitlesHelp.frame.isVisible()) {
                    SubtitlesHelp.frame.setVisible(true);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }
        });
        btnEditAll.setFont(new Font(Shutter.montserratFont, 0, 12));
        btnEditAll.setSize(SubtitlesTimeline.btnEditAll.getPreferredSize().width, 21);
        if (System.getProperty("os.name").contains("Windows")) {
            btnEditAll.setLocation(frame.getWidth() - btnEditAll.getWidth() - 22, 8);
        } else {
            btnEditAll.setLocation(frame.getWidth() - btnEditAll.getWidth() - 10, 8);
        }
        frame.getContentPane().add(btnEditAll);
        btnEditAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SubtitlesEdit.frame == null) {
                    new SubtitlesEdit();
                    SubtitlesEdit.refreshSubtitles();
                } else if (SubtitlesEdit.frame.isVisible()) {
                    SubtitlesEdit.frame.setVisible(false);
                } else if (!SubtitlesEdit.frame.isVisible()) {
                    SubtitlesEdit.frame.setVisible(true);
                    SubtitlesEdit.refreshSubtitles();
                }
            }
        });
        btnAdd = new JButton(Shutter.language.getProperty("btnAdd"));
        btnAdd.setFont(new Font(Shutter.montserratFont, 0, 12));
        btnAdd.setBounds(SubtitlesTimeline.btnEditAll.getLocation().x - btnAdd.getWidth() - 2, 8, SubtitlesTimeline.btnAdd.getPreferredSize().width, 21);
        frame.getContentPane().add(btnAdd);
        btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SubtitlesTimeline.addSubtitles(true);
            }
        });
        btnDelete = new JButton(Shutter.language.getProperty("btnDelete"));
        btnDelete.setFont(new Font(Shutter.montserratFont, 0, 12));
        btnDelete.setMargin(new Insets(0, 0, 0, 0));
        btnDelete.setBounds(SubtitlesTimeline.btnAdd.getLocation().x - btnDelete.getWidth() - 2, 8, 80, 21);
        btnDelete.setEnabled(false);
        frame.getContentPane().add(btnDelete);
        btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int q = JOptionPane.showConfirmDialog(frame, Shutter.language.getProperty("deleteConfirmation"), Shutter.language.getProperty("subtitlesDelete"), 0);
                if (q == 0) {
                    if (selectedSubs.size() != 0) {
                        int supp = 0;
                        int index = 0;
                        while (index < selectedSubs.size()) {
                            timeline.remove(selectedSubs.get(index) - supp);
                            ++supp;
                            ++index;
                        }
                        selectedSubs.clear();
                        SubtitlesTimeline.saveSubtitles(true, false);
                        timeIn = 0L;
                    } else {
                        SubtitlesTimeline.deleteSubtitles();
                    }
                }
            }
        });
        btnCut = new JButton(Shutter.language.getProperty("cutUpper"));
        btnCut.setFont(new Font(Shutter.montserratFont, 0, 12));
        btnCut.setBounds(SubtitlesTimeline.btnDelete.getLocation().x - btnCut.getWidth() - 2, 8, SubtitlesTimeline.btnCut.getPreferredSize().width, 21);
        btnCut.setEnabled(false);
        frame.getContentPane().add(btnCut);
        btnCut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (selectedSubs.size() != 0) {
                    int index = 0;
                    while (index < selectedSubs.size()) {
                        ((JComponent)timeline.getComponent(selectedSubs.get(index))).setBorder(new RoundedBorder(5, Utils.themeColor));
                        ((JComponent)timeline.getComponent(selectedSubs.get(index))).setForeground(Color.WHITE);
                        ++index;
                    }
                    selectedSubs.clear();
                    SubtitlesTimeline.repaintTimeline();
                }
                int subSize = 0;
                Component[] componentArray = timeline.getComponents();
                int n = componentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Component c = componentArray[n2];
                    if (c instanceof JTextPane && SubtitlesTimeline.cursor.getLocation().x > c.getLocation().x && SubtitlesTimeline.cursor.getLocation().x < c.getLocation().x + c.getWidth()) {
                        subSize = c.getWidth();
                        c.setBounds(c.getX(), c.getY(), c.getWidth() - (c.getX() + c.getWidth() - cursor.getX()), c.getHeight());
                        timeline.add(SubtitlesTimeline.addText(((JTextPane)c).getText(), (int)((double)SubtitlesTimeline.cursor.getLocation().x + (double)timelineScrollBar.getValue() * zoom), subSize - c.getWidth()));
                        SubtitlesTimeline.saveSubtitles(true, false);
                        timeIn = 0L;
                        break;
                    }
                    ++n2;
                }
            }
        });
        btnEnd = new JButton(Shutter.language.getProperty("btnFin"));
        btnEnd.setFont(new Font(Shutter.montserratFont, 0, 12));
        btnEnd.setBounds(SubtitlesTimeline.btnCut.getLocation().x - btnEnd.getWidth() - 2, 8, SubtitlesTimeline.btnEnd.getPreferredSize().width, 21);
        btnEnd.setEnabled(false);
        frame.getContentPane().add(btnEnd);
        btnEnd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int sub = 0;
                boolean outside = true;
                Component[] componentArray = timeline.getComponents();
                int n = componentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Component c = componentArray[n2];
                    if (c instanceof JTextPane) {
                        if (c.getX() + c.getWidth() < cursor.getX()) {
                            ++sub;
                        }
                        if (SubtitlesTimeline.cursor.getLocation().x > c.getLocation().x && SubtitlesTimeline.cursor.getLocation().x <= c.getLocation().x + c.getWidth()) {
                            c.setBounds(c.getX(), c.getY(), c.getWidth() - (c.getX() + c.getWidth() - cursor.getX()), c.getHeight());
                            outside = false;
                            break;
                        }
                    }
                    ++n2;
                }
                if (outside) {
                    timeline.getComponent(sub).setSize(cursor.getX() - timeline.getComponent(sub).getX(), timeline.getComponent(sub).getHeight());
                }
                SubtitlesTimeline.saveSubtitles(true, false);
            }
        });
        btnStart = new JButton(Shutter.language.getProperty("btnDebut"));
        btnStart.setFont(new Font(Shutter.montserratFont, 0, 12));
        btnStart.setBounds(SubtitlesTimeline.btnEnd.getLocation().x - btnStart.getWidth() - 2, 8, SubtitlesTimeline.btnStart.getPreferredSize().width, 21);
        btnStart.setEnabled(false);
        frame.getContentPane().add(btnStart);
        btnStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int sub = 1;
                boolean outside = true;
                Component[] componentArray = timeline.getComponents();
                int n = componentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Component c = componentArray[n2];
                    if (c instanceof JTextPane) {
                        if (c.getX() < cursor.getX()) {
                            ++sub;
                        }
                        if (SubtitlesTimeline.cursor.getLocation().x >= c.getLocation().x && SubtitlesTimeline.cursor.getLocation().x < c.getLocation().x + c.getWidth()) {
                            c.setBounds(cursor.getX(), c.getY(), c.getWidth() - (cursor.getX() - c.getX()), c.getHeight());
                            outside = false;
                            break;
                        }
                    }
                    timeIn = 0L;
                    ++n2;
                }
                if (outside) {
                    int subX = timeline.getComponent(sub).getX();
                    int subW = timeline.getComponent(sub).getWidth();
                    timeline.getComponent(sub).setLocation(cursor.getX(), timeline.getComponent(sub).getY());
                    timeline.getComponent(sub).setSize(subW + (subX - cursor.getX()), timeline.getComponent(sub).getHeight());
                }
                SubtitlesTimeline.saveSubtitles(true, false);
            }
        });
        caseShowWaveform.setSelected(true);
        caseShowWaveform.setEnabled(false);
        caseShowWaveform.setFont(new Font(Shutter.freeSansFont, 0, 12));
        caseShowWaveform.setBounds(btnStart.getX() - caseShowWaveform.getWidth() - 20, 6, SubtitlesTimeline.caseShowWaveform.getPreferredSize().width, 23);
        frame.getContentPane().add(caseShowWaveform);
        caseShowWaveform.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (caseShowWaveform.isSelected()) {
                    timeline.removeAll();
                    SubtitlesTimeline.setSubtitles(srt);
                } else if (waveform != null) {
                    timeline.remove(waveform);
                    SubtitlesTimeline.repaintTimeline();
                }
            }
        });
        final JLabel images = new JLabel("i");
        images.setFont(new Font(Shutter.montserratFont, 0, 12));
        images.setBounds(caseShowWaveform.getX() - images.getWidth() - 7, 9, 10, 16);
        frame.getContentPane().add(images);
        textOffset.setBounds(images.getX() - images.getWidth() - 27, SubtitlesTimeline.lblOffset.getLocation().y, 34, 16);
        textOffset.setHorizontalAlignment(4);
        textOffset.setFont(new Font(Shutter.freeSansFont, 0, 12));
        frame.getContentPane().add(textOffset);
        textOffset.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                textOffset.setFocusable(true);
                textOffset.requestFocus();
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (textOffset.getText().length() > 0 && e.getKeyCode() == 10) {
                    Component[] componentArray = timeline.getComponents();
                    int n = componentArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Component c = componentArray[n2];
                        if (c instanceof JTextPane) {
                            c.setLocation((int)((double)c.getX() + Math.ceil((double)((float)Integer.parseInt(textOffset.getText()) * (1000.0f / FFPROBE.currentFPS)) * zoom)), c.getY());
                        }
                        ++n2;
                    }
                    SubtitlesTimeline.saveSubtitles(true, false);
                    textOffset.setText("0");
                    textOffset.setFocusable(false);
                    frame.requestFocus();
                } else if (e.getKeyCode() == 27) {
                    textOffset.setText("0");
                    textOffset.setFocusable(false);
                    frame.requestFocus();
                } else {
                    textOffset.setFocusable(true);
                    textOffset.requestFocus();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                char caracter = e.getKeyChar();
                if (!String.valueOf(caracter).matches("[0-9\\-]+") && caracter != '\uffff' || String.valueOf(caracter).matches("[\u00e9\u00e8\u00e7\u00e0\u00f9]")) {
                    e.consume();
                } else if (textOffset.getText().length() >= 4) {
                    textOffset.setText("");
                }
            }
        });
        textOffset.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                textOffset.setFocusable(true);
                textOffset.requestFocus();
                textOffset.setCursor(Cursor.getPredefinedCursor(2));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                textOffset.setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                textOffset.setCursor(Cursor.getPredefinedCursor(13));
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Offset.mouseX = e.getX();
                Offset.offset = Integer.parseInt(textOffset.getText());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (textOffset.getCursor() == Cursor.getPredefinedCursor(13)) {
                    Component[] componentArray = timeline.getComponents();
                    int n = componentArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Component c = componentArray[n2];
                        if (c instanceof JTextPane) {
                            c.setLocation((int)((double)c.getX() + Math.ceil((double)((float)Integer.parseInt(textOffset.getText()) * (1000.0f / FFPROBE.currentFPS)) * zoom)), c.getY());
                        }
                        ++n2;
                    }
                    SubtitlesTimeline.saveSubtitles(true, false);
                    textOffset.setText("0");
                    textOffset.setFocusable(false);
                    frame.requestFocus();
                }
            }
        });
        textOffset.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (textOffset.getCursor() == Cursor.getPredefinedCursor(13)) {
                    textOffset.setText(String.valueOf(Offset.offset + (e.getX() - Offset.mouseX)));
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        lblOffset.setHorizontalAlignment(2);
        lblOffset.setFont(new Font(Shutter.freeSansFont, 0, 13));
        lblOffset.setAlignmentX(4.0f);
        lblOffset.setBounds(textOffset.getX() - lblOffset.getWidth() - 7, 9, SubtitlesTimeline.lblOffset.getPreferredSize().width, 16);
        frame.getContentPane().add(lblOffset);
        SubtitlesTimeline.refreshData();
        KeyListener keyListener = new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                Component c;
                int n;
                int n2;
                Component[] componentArray;
                if ((e.getModifiersEx() & 0x100) != 0 || (e.getModifiersEx() & 0x80) != 0) {
                    control = true;
                    SubtitlesTimeline.this.enableZoom = true;
                    if (e.getKeyCode() == 16) {
                        shift = true;
                    }
                    if (e.getKeyCode() == 18) {
                        controlRight = true;
                    }
                }
                if (e.getKeyCode() == 9) {
                    e.consume();
                    componentArray = frame.getContentPane().getComponents();
                    n2 = componentArray.length;
                    n = 0;
                    while (n < n2) {
                        c = componentArray[n];
                        c.setFocusable(false);
                        ++n;
                    }
                    txtSubtitles.setFocusable(true);
                    if (txtSubtitles.hasFocus()) {
                        frame.requestFocus();
                    } else {
                        txtSubtitles.requestFocus();
                    }
                }
                if (control) {
                    if (e.getKeyCode() == 73) {
                        SubtitlesTimeline.this.btnI.doClick();
                    }
                    if (e.getKeyCode() == 66) {
                        SubtitlesTimeline.this.btnG.doClick();
                    }
                    if (e.getKeyCode() == 88 && txtSubtitles.getSelectionStart() != txtSubtitles.getSelectionEnd()) {
                        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(txtSubtitles.getText().substring(txtSubtitles.getSelectionStart(), txtSubtitles.getSelectionEnd())), null);
                        txtSubtitles.setText(txtSubtitles.getText().replace(txtSubtitles.getText().substring(txtSubtitles.getSelectionStart(), txtSubtitles.getSelectionEnd()), ""));
                        componentArray = timeline.getComponents();
                        n2 = componentArray.length;
                        n = 0;
                        while (n < n2) {
                            c = componentArray[n];
                            if (c instanceof JTextPane && SubtitlesTimeline.cursor.getLocation().x >= c.getLocation().x && SubtitlesTimeline.cursor.getLocation().x < c.getLocation().x + c.getWidth()) {
                                ((JTextPane)c).setText(txtSubtitles.getText());
                                SubtitlesTimeline.repaintTimeline();
                                break;
                            }
                            ++n;
                        }
                    }
                    if (frame.hasFocus() && e.getKeyCode() == 65) {
                        int index = 0;
                        selectedSubs.clear();
                        Component[] componentArray2 = timeline.getComponents();
                        int n3 = componentArray2.length;
                        n2 = 0;
                        while (n2 < n3) {
                            Component c2 = componentArray2[n2];
                            if (c2 instanceof JTextPane) {
                                ((JComponent)c2).setBorder(new RoundedBorder(5, Color.RED));
                                c2.setForeground(Color.RED);
                                selectedSubs.add(++index);
                                SubtitlesTimeline.repaintTimeline();
                            }
                            ++n2;
                        }
                    }
                    if (e.getKeyCode() == 67) {
                        if (txtSubtitles.getSelectionStart() != txtSubtitles.getSelectionEnd()) {
                            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(txtSubtitles.getText().substring(txtSubtitles.getSelectionStart(), txtSubtitles.getSelectionEnd())), null);
                        } else {
                            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(txtSubtitles.getText()), null);
                        }
                    }
                    if (e.getKeyCode() == 86) {
                        SubtitlesTimeline.this.PasteFromClipBoard();
                    }
                    if (e.getKeyCode() == 90 && !shift) {
                        frame.requestFocus();
                        SubtitlesTimeline.loadBackupSubtitles();
                    } else if (e.getKeyCode() == 90 && shift || e.getKeyCode() == 89) {
                        frame.requestFocus();
                        SubtitlesTimeline.loadRestoreSubtitles();
                    }
                    if (e.getKeyCode() == 107) {
                        VideoPlayer.sliderVolume.setValue(VideoPlayer.sliderVolume.getValue() + 2);
                    }
                    if (e.getKeyCode() == 109) {
                        VideoPlayer.sliderVolume.setValue(VideoPlayer.sliderVolume.getValue() - 2);
                    }
                }
                if (frame.hasFocus()) {
                    int time;
                    if (e.getKeyCode() == 36) {
                        enableAutoScroll = false;
                        cursor.setLocation(0, cursor.getY());
                        SubtitlesTimeline.setVideoPosition(0);
                        timelineScrollBar.setValue(0);
                        enableAutoScroll = true;
                    }
                    if (e.getKeyCode() == 35 && (time = (int)((double)(timeline.getComponent(number).getX() + timeline.getComponent(number).getWidth()) / zoom)) > 0) {
                        SubtitlesTimeline.setVideoPosition(time);
                    }
                    if (e.getKeyCode() == 87 && caseShowWaveform.isEnabled()) {
                        caseShowWaveform.doClick();
                    }
                    if (e.getKeyCode() == 73 && !control) {
                        btnStart.doClick();
                    }
                    if (e.getKeyCode() == 79) {
                        btnEnd.doClick();
                        timeIn = 0L;
                    }
                    if (e.getKeyCode() == 32 || e.getKeyCode() == 75) {
                        VideoPlayer.btnPlay.doClick();
                    }
                    if (e.getKeyCode() == 74) {
                        SubtitlesTimeline.setVideoPosition((int)(VideoPlayer.playerCurrentFrame * VideoPlayer.inputFramerateMS - 1000.0f / FFPROBE.currentFPS * 11.0f));
                    }
                    if (e.getKeyCode() == 76) {
                        SubtitlesTimeline.setVideoPosition((int)(VideoPlayer.playerCurrentFrame * VideoPlayer.inputFramerateMS + 1000.0f / FFPROBE.currentFPS * 9.0f));
                    }
                    if (e.getKeyCode() == 10) {
                        btnAdd.doClick();
                    }
                    if (e.getKeyCode() == 8 || e.getKeyCode() == 127) {
                        btnDelete.doClick();
                    }
                    if (e.getKeyCode() == 67 && !control) {
                        btnCut.doClick();
                    }
                    if (e.getKeyCode() == 38) {
                        SubtitlesTimeline.nextSubtitle();
                    } else if (e.getKeyCode() == 40) {
                        SubtitlesTimeline.previousSubtitle();
                    }
                    if (e.getKeyCode() == 37) {
                        VideoPlayer.btnPrevious.doClick();
                    } else if (e.getKeyCode() == 39) {
                        VideoPlayer.btnNext.doClick();
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 157 || e.getKeyCode() == 17) {
                    SubtitlesTimeline.this.enableZoom = false;
                    control = false;
                }
                if (e.getKeyCode() == 16) {
                    shift = false;
                }
                if (e.getKeyCode() == 18) {
                    controlRight = false;
                }
                VideoPlayer.player.repaint();
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        };
        MouseWheelListener mouseWheelListener = new MouseWheelListener(){
            Thread t;
            long mouseScrollTime = System.currentTimeMillis();

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (SubtitlesTimeline.this.enableZoom) {
                    enableAutoScroll = false;
                    double actualZoom = zoom;
                    if (zoom >= 0.1) {
                        zoom -= (double)e.getWheelRotation() / 10.0;
                        if (caseShowWaveform.isEnabled() && caseShowWaveform.isSelected()) {
                            VideoPlayer.addWaveform(true);
                            waveform.setVisible(true);
                        }
                    } else {
                        zoom -= (double)e.getWheelRotation() / 100.0;
                        if (caseShowWaveform.isEnabled() && caseShowWaveform.isSelected()) {
                            waveform.setVisible(false);
                        }
                    }
                    if (zoom < 0.01) {
                        zoom = 0.01;
                    }
                    DecimalFormat numberFormat = new DecimalFormat("0.0");
                    if (zoom < 0.1) {
                        numberFormat = new DecimalFormat("0.00");
                    }
                    zoom = (int)((double)((float)VideoPlayer.slider.getMaximum() * VideoPlayer.inputFramerateMS) - (double)frame.getWidth() / zoom) > 0 ? Double.parseDouble(numberFormat.format(zoom).replace(",", ".")) : actualZoom;
                    timeline.setSize((int)((double)((float)(VideoPlayer.slider.getMaximum() - 2) * VideoPlayer.inputFramerateMS) * zoom), timeline.getHeight());
                    timelineScrollBar.setMaximum(timeline.getWidth() - frame.getWidth());
                    cursor.setLocation((int)((double)SubtitlesTimeline.setTime((int)((float)VideoPlayer.slider.getValue() * VideoPlayer.inputFramerateMS)) * zoom), cursor.getY());
                    enableAutoScroll = true;
                    timeline.removeAll();
                    SubtitlesTimeline.setSubtitles(srt);
                } else {
                    this.mouseScrollTime = System.currentTimeMillis();
                    if (VideoPlayer.frameVideo != null) {
                        int newValue = timelineScrollBar.getValue() + e.getWheelRotation() * 100;
                        if (zoom < 0.1) {
                            newValue = timelineScrollBar.getValue() + e.getWheelRotation() * 10;
                        }
                        timelineScrollBar.setValue(newValue);
                        if (this.t == null || !this.t.isAlive()) {
                            this.t = new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    do {
                                        try {
                                            Thread.sleep(100L);
                                        }
                                        catch (InterruptedException interruptedException) {
                                            // empty catch block
                                        }
                                    } while (System.currentTimeMillis() - mouseScrollTime < 300L);
                                    VideoPlayer.addWaveform(true);
                                }
                            });
                            this.t.start();
                        }
                    }
                }
            }
        };
        frame.addKeyListener(keyListener);
        frame.addMouseWheelListener(mouseWheelListener);
        txtSubtitles.addKeyListener(keyListener);
        Toolkit.getDefaultToolkit().addAWTEventListener(new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                KeyEvent ke = (KeyEvent)event;
                if (ke.getID() == 401 && !txtSubtitles.hasFocus() && !SubtitlesEdit.isWriting) {
                    frame.requestFocus();
                }
            }
        }, 8L);
        Utils.changeFrameVisibility(frame, false);
        final JPanel timelineBackround = new JPanel();
        timelineBackround.setBackground(new Color(45, 45, 45));
        timelineBackround.setLayout(null);
        timelineBackround.setBorder(BorderFactory.createTitledBorder(new MatteBorder(1, 0, 1, 0, Color.LIGHT_GRAY), String.valueOf(Shutter.language.getProperty("lblTimeline")) + " ", 2, 2, new Font(Shutter.montserratFont, 0, 12), Color.WHITE));
        timelineBackround.setBounds(0, 80, frame.getWidth(), frame.getContentPane().getHeight() - 97);
        frame.getContentPane().add(timelineBackround);
        timeline.setBackground(new Color(45, 45, 45));
        timeline.setLayout(null);
        timeline.setBounds(0, 15, (int)((double)((float)(VideoPlayer.slider.getMaximum() - 2) * VideoPlayer.inputFramerateMS) * zoom), timelineBackround.getHeight() - 20);
        timelineBackround.add(timeline);
        timeline.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                frame.requestFocus();
                VideoPlayer.sliderChange = true;
                cursor.setLocation(e.getX(), SubtitlesTimeline.cursor.getLocation().y);
                VideoPlayer.slider.setValue((int)((double)(e.getX() - 2) / zoom / (double)VideoPlayer.inputFramerateMS));
                if (selectedSubs.size() != 0) {
                    int index = 0;
                    while (index < selectedSubs.size()) {
                        ((JComponent)timeline.getComponent(selectedSubs.get(index))).setBorder(new RoundedBorder(5, Utils.themeColor));
                        ((JComponent)timeline.getComponent(selectedSubs.get(index))).setForeground(Color.WHITE);
                        ++index;
                    }
                }
                selectedSubs.clear();
                SubtitlesTimeline.repaintTimeline();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                VideoPlayer.sliderChange = false;
                VideoPlayer.getTimePoint(VideoPlayer.playerCurrentFrame - 1.0f);
            }
        });
        timeline.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                VideoPlayer.sliderChange = true;
                if (e.getX() >= 0 && e.getX() <= timeline.getWidth() - 12) {
                    cursor.setLocation(e.getX(), SubtitlesTimeline.cursor.getLocation().y);
                    VideoPlayer.slider.setValue((int)((double)(e.getX() - 2) / zoom / (double)VideoPlayer.inputFramerateMS));
                    VideoPlayer.cursorWaveform.setLocation((int)((long)VideoPlayer.waveformContainer.getSize().width * (long)VideoPlayer.slider.getValue() / (long)VideoPlayer.slider.getMaximum()), VideoPlayer.cursorWaveform.getLocation().y);
                } else if (e.getX() < 0) {
                    cursor.setLocation(0, SubtitlesTimeline.cursor.getLocation().y);
                    VideoPlayer.cursorWaveform.setLocation(0, VideoPlayer.cursorWaveform.getLocation().y);
                    VideoPlayer.slider.setValue(0);
                } else if (e.getX() > timeline.getWidth() - 12) {
                    cursor.setLocation(timeline.getWidth() - 12, SubtitlesTimeline.cursor.getLocation().y);
                    VideoPlayer.cursorWaveform.setLocation(timeline.getWidth() - 2, VideoPlayer.cursorWaveform.getLocation().y);
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        timelineScrollBar.setVisible(true);
        timelineScrollBar.setValue(0);
        timelineScrollBar.setBackground(new Color(45, 45, 45));
        timelineScrollBar.setOrientation(0);
        timelineScrollBar.setBounds(0, 0, frame.getContentPane().getWidth(), 17);
        final JPanel scrollBarPanel = new JPanel();
        scrollBarPanel.setBackground(new Color(45, 45, 45));
        scrollBarPanel.setLayout(null);
        scrollBarPanel.setBounds(0, frame.getContentPane().getHeight() - 17, frame.getContentPane().getWidth(), 17);
        frame.getContentPane().add(scrollBarPanel);
        scrollBarPanel.add(timelineScrollBar);
        timelineScrollBar.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
                enableAutoScroll = false;
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
                enableAutoScroll = true;
                VideoPlayer.addWaveform(true);
            }
        });
        timelineScrollBar.addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent ae) {
                timeline.setLocation(0 - timelineScrollBar.getValue(), SubtitlesTimeline.timeline.getLocation().y);
            }
        });
        cursor.setBackground(Color.RED);
        cursor.setBounds(0, 0, 2, timeline.getHeight());
        timeline.add(cursor);
        frame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                if (System.getProperty("os.name").contains("Windows")) {
                    txtSubtitles.setBounds(10, 36, frame.getWidth() - 36, 36);
                } else {
                    txtSubtitles.setBounds(10, 36, frame.getWidth() - 24, 36);
                }
                timelineBackround.setBounds(0, 80, frame.getWidth(), frame.getContentPane().getHeight() - 97);
                timeline.setBounds(0, 15, (int)((double)((float)VideoPlayer.slider.getMaximum() * VideoPlayer.inputFramerateMS) * zoom), timelineBackround.getHeight() - 20);
                timelineScrollBar.setMaximum(timeline.getWidth() - frame.getWidth());
                scrollBarPanel.setBounds(0, frame.getContentPane().getHeight() - 17, frame.getContentPane().getWidth(), 17);
                timelineScrollBar.setBounds(0, 0, frame.getContentPane().getWidth(), 17);
                cursor.setBounds(0, 0, 2, timeline.getHeight());
                if (System.getProperty("os.name").contains("Windows")) {
                    btnEditAll.setLocation(frame.getWidth() - btnEditAll.getWidth() - 24, 8);
                } else {
                    btnEditAll.setLocation(frame.getWidth() - btnEditAll.getWidth() - 12, 8);
                }
                btnAdd.setBounds(SubtitlesTimeline.btnEditAll.getLocation().x - btnAdd.getWidth() - 2, 8, SubtitlesTimeline.btnAdd.getPreferredSize().width, 21);
                btnDelete.setBounds(SubtitlesTimeline.btnAdd.getLocation().x - btnDelete.getWidth() - 2, 8, 80, 21);
                btnCut.setBounds(SubtitlesTimeline.btnDelete.getLocation().x - btnCut.getWidth() - 2, 8, SubtitlesTimeline.btnCut.getPreferredSize().width, 21);
                btnEnd.setBounds(SubtitlesTimeline.btnCut.getLocation().x - btnEnd.getWidth() - 2, 8, SubtitlesTimeline.btnEnd.getPreferredSize().width, 21);
                btnStart.setBounds(SubtitlesTimeline.btnEnd.getLocation().x - btnStart.getWidth() - 2, 8, SubtitlesTimeline.btnStart.getPreferredSize().width, 21);
                caseShowWaveform.setBounds(btnStart.getX() - caseShowWaveform.getWidth() - 20, 6, SubtitlesTimeline.caseShowWaveform.getPreferredSize().width, 23);
                images.setBounds(caseShowWaveform.getX() - images.getWidth() - 7, 9, 10, 16);
                textOffset.setBounds(images.getX() - images.getWidth() - 27, SubtitlesTimeline.lblOffset.getLocation().y, 34, 16);
                lblOffset.setBounds(textOffset.getX() - lblOffset.getWidth() - 7, 9, SubtitlesTimeline.lblOffset.getPreferredSize().width, 16);
                lblHelp.setBounds(SubtitlesTimeline.this.btnG.getX() + SubtitlesTimeline.this.btnG.getWidth() + 4, 8, SubtitlesTimeline.lblHelp.getPreferredSize().width, 22);
                if (frame.getHeight() != currentFrameHeight) {
                    frame.setCursor(Cursor.getPredefinedCursor(3));
                    currentFrameHeight = frame.getHeight();
                    timeline.removeAll();
                    frame.setCursor(Cursor.getPredefinedCursor(0));
                }
                if (srt.exists()) {
                    SubtitlesTimeline.setSubtitles(srt);
                }
            }
        });
        Component[] componentArray = frame.getContentPane().getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            c.setFocusable(false);
            ++n2;
        }
        txtSubtitles.setFocusable(true);
        frame.requestFocus();
    }

    public static void refreshData() {
        try {
            if (enableAutoScroll) {
                int posX = (int)((float)VideoPlayer.slider.getValue() * VideoPlayer.inputFramerateMS);
                cursor.setLocation((int)((double)SubtitlesTimeline.setTime(posX) * zoom), cursor.getY());
            }
            if (!txtSubtitles.hasFocus()) {
                timeIn = (long)(VideoPlayer.playerCurrentFrame * VideoPlayer.inputFramerateMS);
                txtSubtitles.setText("");
                btnDelete.setEnabled(false);
                btnCut.setEnabled(false);
                Component[] componentArray = timeline.getComponents();
                int n = componentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Component c = componentArray[n2];
                    if (c instanceof JTextPane && SubtitlesTimeline.cursor.getLocation().x >= c.getLocation().x && SubtitlesTimeline.cursor.getLocation().x < c.getLocation().x + c.getWidth()) {
                        txtSubtitles.setText(((JTextPane)c).getText());
                        actualSubIn = c.getLocation().x;
                        actualSubOut = c.getLocation().x + c.getWidth();
                        btnDelete.setEnabled(true);
                        btnCut.setEnabled(true);
                        if (VideoPlayer.frameControl || !frame.hasFocus() && !txtSubtitles.hasFocus()) break;
                        SubtitlesEdit.refreshSubtitles();
                        break;
                    }
                    ++n2;
                }
            }
            if (enableAutoScroll) {
                if (SubtitlesTimeline.cursor.getLocation().x - timelineScrollBar.getValue() >= frame.getContentPane().getWidth()) {
                    timelineScrollBar.setValue(SubtitlesTimeline.cursor.getLocation().x - frame.getWidth() / 2);
                } else if (SubtitlesTimeline.cursor.getLocation().x + 2 - timelineScrollBar.getValue() < 0) {
                    timelineScrollBar.setValue(SubtitlesTimeline.cursor.getLocation().x - frame.getWidth() / 2);
                }
                timelineScrollBar.setValue(SubtitlesTimeline.setTime(timelineScrollBar.getValue()));
                if (currentScrollBarValue != timelineScrollBar.getValue() || waveformReload == null) {
                    currentScrollBarValue = timelineScrollBar.getValue();
                    if (waveformReload == null || !waveformReload.isAlive()) {
                        waveformReload = new Thread(new Runnable(){

                            @Override
                            public void run() {
                                do {
                                    try {
                                        Thread.sleep(100L);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                } while (VideoPlayer.addWaveformIsRunning);
                                VideoPlayer.addWaveform(true);
                            }
                        });
                        waveformReload.start();
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static JTextPane addText(String subContent, int x, int size) {
        final JTextPane text = new JTextPane();
        text.setBackground(new Color(45, 45, 45, 120));
        text.setForeground(Color.WHITE);
        text.setText(subContent);
        text.setBorder(new RoundedBorder(5, Utils.themeColor));
        text.setCursor(Cursor.getPredefinedCursor(13));
        text.setHighlighter(null);
        text.setEditable(false);
        text.setBounds((int)((double)x - (double)timelineScrollBar.getValue() * zoom), 20, size, timeline.getHeight() - 30);
        text.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent down) {
                if (down.getClickCount() == 2) {
                    SubtitlesTimeline.setVideoPosition((int)((double)text.getX() / zoom));
                }
            }

            @Override
            public void mousePressed(MouseEvent down) {
                int n;
                int index;
                if (control) {
                    if (text.getForeground() == Color.RED) {
                        text.setBorder(new RoundedBorder(5, Utils.themeColor));
                        text.setForeground(Color.WHITE);
                    } else {
                        text.setBorder(new RoundedBorder(5, Color.RED));
                        text.setForeground(Color.RED);
                        if (shift) {
                            index = 0;
                            boolean setColor = false;
                            selectedSubs.clear();
                            Component[] componentArray = timeline.getComponents();
                            int n2 = componentArray.length;
                            n = 0;
                            while (n < n2) {
                                Component c = componentArray[n];
                                if (c instanceof JTextPane) {
                                    ++index;
                                    if (c.getForeground() == Color.RED) {
                                        setColor = !setColor;
                                        selectedSubs.add(index);
                                    } else if (setColor) {
                                        ((JComponent)c).setBorder(new RoundedBorder(5, Color.RED));
                                        c.setForeground(Color.RED);
                                        selectedSubs.add(index);
                                    }
                                }
                                ++n;
                            }
                        }
                    }
                }
                index = 0;
                selectedSubs.clear();
                Component[] componentArray = timeline.getComponents();
                n = componentArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Component c = componentArray[n3];
                    if (c instanceof JTextPane) {
                        ++index;
                        if (c.getForeground() == Color.RED) {
                            selectedSubs.add(index);
                        }
                    }
                    ++n3;
                }
                MousePositionX = down.getPoint().x;
                MouseTextWidth = text.getWidth();
                MouseTextLocationX = down.getXOnScreen();
                if (zoom < 0.1) {
                    enableAutoScroll = false;
                    SubtitlesTimeline.setVideoPosition((int)((double)(down.getXOnScreen() - SubtitlesTimeline.frame.getLocation().x - MousePositionX + timelineScrollBar.getValue()) / zoom));
                    zoom = 0.1;
                    timeline.setSize((int)((double)((float)(VideoPlayer.slider.getMaximum() - 2) * VideoPlayer.inputFramerateMS) * zoom), timeline.getHeight());
                    timelineScrollBar.setMaximum(timeline.getWidth() - frame.getWidth());
                    cursor.setLocation((int)((double)SubtitlesTimeline.setTime(VideoPlayer.slider.getValue()) * zoom), cursor.getY());
                    enableAutoScroll = true;
                    timeline.removeAll();
                    SubtitlesTimeline.setSubtitles(srt);
                    if (caseShowWaveform.isEnabled() && caseShowWaveform.isSelected()) {
                        VideoPlayer.addWaveform(true);
                        waveform.setVisible(true);
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getClickCount() < 2 && !control) {
                    SubtitlesTimeline.saveSubtitles(true, false);
                }
                frame.requestFocus();
                timeIn = 0L;
                if (!control) {
                    if (selectedSubs.size() != 0) {
                        int index = 0;
                        while (index < selectedSubs.size()) {
                            ((JComponent)timeline.getComponent(selectedSubs.get(index))).setBorder(new RoundedBorder(5, Utils.themeColor));
                            ((JComponent)timeline.getComponent(selectedSubs.get(index))).setForeground(Color.WHITE);
                            ++index;
                        }
                    }
                    selectedSubs.clear();
                }
                enableAutoScroll = true;
                SubtitlesTimeline.repaintTimeline();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        text.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                int previousSubX = 0;
                int previousSubW = 0;
                int nextSub = 0;
                int nextSubX = 0;
                int nextSubW = 0;
                if (selectedSubs.size() == 0) {
                    previousSub = number;
                    Component[] componentArray = timeline.getComponents();
                    int n = componentArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Component c = componentArray[n2];
                        if (c instanceof JTextPane) {
                            --previousSub;
                            if (c.getLocation().x + c.getWidth() <= text.getLocation().x) {
                                previousSubX = c.getLocation().x;
                                previousSubW = c.getWidth();
                                ++previousSub;
                            }
                        }
                        ++n2;
                    }
                    nextSub = previousSub + 2;
                    if (nextSub <= number) {
                        nextSubX = SubtitlesTimeline.timeline.getComponent((int)nextSub).getLocation().x;
                        nextSubW = timeline.getComponent(nextSub).getWidth();
                    }
                } else {
                    int index = 0;
                    while (index < selectedSubs.size()) {
                        if (text.getLocation().x == SubtitlesTimeline.timeline.getComponent((int)SubtitlesTimeline.selectedSubs.get((int)index).intValue()).getLocation().x) {
                            previousSub = selectedSubs.get(index) - 1;
                            previousSubX = SubtitlesTimeline.timeline.getComponent((int)SubtitlesTimeline.previousSub).getLocation().x;
                            previousSubW = timeline.getComponent(previousSub).getWidth();
                            break;
                        }
                        ++index;
                    }
                    if (selectedSubs.get(selectedSubs.size() - 1) + 1 <= timeline.getComponents().length - 1) {
                        nextSub = selectedSubs.get(selectedSubs.size() - 1) + 1;
                        nextSubX = SubtitlesTimeline.timeline.getComponent((int)nextSub).getLocation().x;
                        nextSubW = timeline.getComponent(nextSub).getWidth();
                    }
                }
                int mouseOffset = 8;
                if (System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Linux")) {
                    mouseOffset = 0;
                }
                int oldPosX = 0;
                if (text.getCursor() == Cursor.getPredefinedCursor(13)) {
                    if (selectedSubs.size() != 0) {
                        oldPosX = text.getX();
                    }
                    if (control && text.getX() >= cursor.getX() && cursor.getX() > previousSubX + previousSubW && !controlRight) {
                        text.setLocation(cursor.getX() + mouseOffset, text.getLocation().y);
                    } else if (control && text.getX() <= cursor.getX() && cursor.getX() < nextSubX + nextSubW && controlRight) {
                        text.setLocation(cursor.getX() + mouseOffset - text.getWidth(), text.getLocation().y);
                    } else if (control && controlRight && text.getX() <= nextSubX) {
                        text.setLocation(nextSubX + mouseOffset - text.getWidth(), text.getLocation().y);
                    } else if (control && text.getX() >= previousSubX && text.getX() != cursor.getX()) {
                        text.setLocation(previousSubX + previousSubW + mouseOffset, text.getLocation().y);
                    } else {
                        text.setLocation(e.getXOnScreen() - SubtitlesTimeline.frame.getLocation().x - MousePositionX + timelineScrollBar.getValue(), text.getLocation().y);
                    }
                } else if (text.getCursor() == Cursor.getPredefinedCursor(10) && text.getWidth() > 0) {
                    text.setSize(MouseTextWidth - (e.getXOnScreen() - MouseTextLocationX), text.getHeight());
                    text.setLocation(e.getXOnScreen() - SubtitlesTimeline.frame.getLocation().x - MousePositionX + timelineScrollBar.getValue() - mouseOffset, text.getLocation().y);
                } else if (text.getCursor() == Cursor.getPredefinedCursor(11) && text.getWidth() > 0) {
                    text.setSize(e.getX() - mouseOffset, text.getHeight());
                }
                if (text.getCursor() != Cursor.getPredefinedCursor(11)) {
                    int posX = (int)((double)((float)((double)(text.getLocation().x - mouseOffset) + (double)timelineScrollBar.getValue() * zoom)) / zoom);
                    text.setLocation((int)((double)SubtitlesTimeline.setTime(posX) * zoom - (double)timelineScrollBar.getValue() * zoom), text.getY());
                }
                if (text.getCursor() == Cursor.getPredefinedCursor(10) || text.getCursor() == Cursor.getPredefinedCursor(11)) {
                    int size = (int)((double)((float)((double)(text.getLocation().x + text.getWidth() + mouseOffset) + (double)timelineScrollBar.getValue() * zoom)) / zoom);
                    text.setSize((int)((double)SubtitlesTimeline.setTimeFloor(size) * zoom - (double)timelineScrollBar.getValue() * zoom) - text.getX(), text.getHeight());
                }
                if (selectedSubs.size() != 0) {
                    int index = 0;
                    while (index < selectedSubs.size()) {
                        if (selectedSubs.get(index) != previousSub + 1) {
                            int offset = timeline.getComponent(previousSub + 1).getX() - oldPosX;
                            timeline.getComponent(selectedSubs.get(index)).setLocation(timeline.getComponent(selectedSubs.get(index)).getX() + offset, text.getLocation().y);
                        }
                        ++index;
                    }
                } else {
                    if (text.getX() <= previousSubX + previousSubW && (double)text.getX() > 0.0 - (double)timelineScrollBar.getValue() * zoom) {
                        timeline.getComponent(previousSub).setSize(text.getX() - previousSubX, text.getHeight());
                        if (timeline.getComponent(previousSub).getWidth() <= 0) {
                            timeline.remove(previousSub);
                            --number;
                        }
                    }
                    if (text.getX() + text.getWidth() >= nextSubX && nextSubX != 0 && nextSub <= number) {
                        timeline.getComponent(nextSub).setLocation(text.getX() + text.getWidth(), text.getY());
                        if (text.getCursor() == Cursor.getPredefinedCursor(13)) {
                            timeline.getComponent(nextSub).setLocation(text.getX() + text.getWidth(), text.getY());
                            timeline.getComponent(nextSub).setSize(nextSubW - (timeline.getComponent(nextSub).getX() - nextSubX), text.getHeight());
                        } else if (text.getCursor() == Cursor.getPredefinedCursor(11)) {
                            timeline.getComponent(nextSub).setLocation(text.getX() + text.getWidth(), text.getY());
                            timeline.getComponent(nextSub).setSize(timeline.getComponent(nextSub).getWidth() - (timeline.getComponent(nextSub).getX() - nextSubX), text.getHeight());
                        }
                        if (timeline.getComponent(nextSub).getWidth() < 0) {
                            timeline.remove(nextSub);
                            --number;
                        }
                    }
                }
                if (text.getLocation().x < 0) {
                    text.setLocation(0, text.getLocation().y);
                }
                if (text.getLocation().x + text.getWidth() > timeline.getWidth()) {
                    text.setLocation(timeline.getWidth() - text.getWidth(), text.getLocation().y);
                }
                if (e.getXOnScreen() > frame.getX() + frame.getWidth()) {
                    enableAutoScroll = false;
                    timelineScrollBar.setValue(timelineScrollBar.getValue() + (e.getXOnScreen() - (frame.getX() + frame.getWidth())));
                } else if (e.getXOnScreen() < frame.getX() && timelineScrollBar.getValue() > 0) {
                    enableAutoScroll = false;
                    timelineScrollBar.setValue(timelineScrollBar.getValue() - (frame.getX() - e.getXOnScreen()));
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (selectedSubs.size() != 0) {
                    text.setCursor(Cursor.getPredefinedCursor(13));
                } else if (e.getX() > -10 && e.getX() < 10) {
                    text.setCursor(Cursor.getPredefinedCursor(10));
                } else if (e.getX() > text.getWidth() - 10 && e.getX() < text.getWidth() + 10) {
                    text.setCursor(Cursor.getPredefinedCursor(11));
                } else {
                    text.setCursor(Cursor.getPredefinedCursor(13));
                }
            }
        });
        return text;
    }

    public static void setSubtitles(File srt) {
        block28: {
            if (srt.exists() && timeline.getComponents().length <= 1) {
                frame.setCursor(Cursor.getPredefinedCursor(3));
                timeline.add((Component)cursor, 0);
                int index = 1;
                BufferedReader reader = null;
                try {
                    try {
                        if (srt.exists()) {
                            String line;
                            reader = Files.newBufferedReader(Paths.get(srt.toString(), new String[0]), StandardCharsets.UTF_8);
                            while ((line = reader.readLine()) != null) {
                                if ((line = line.replace("\ufeff", "")).isEmpty() || line.matches("[0-9]+")) continue;
                                String[] s = line.replace(",", ":").split(" ");
                                String[] tcInPoint = s[0].split(":");
                                String[] tcOutPoint = s[2].split(":");
                                int inH = Integer.parseInt(tcInPoint[0]) * 3600000;
                                int inM = Integer.parseInt(tcInPoint[1]) * 60000;
                                int inS = Integer.parseInt(tcInPoint[2]) * 1000;
                                int inF = Integer.parseInt(tcInPoint[3]);
                                int outH = Integer.parseInt(tcOutPoint[0]) * 3600000;
                                int outM = Integer.parseInt(tcOutPoint[1]) * 60000;
                                int outS = Integer.parseInt(tcOutPoint[2]) * 1000;
                                int outF = Integer.parseInt(tcOutPoint[3]);
                                int inPoint = (int)((double)(inH + inM + inS + inF) * zoom);
                                int outPoint = (int)((double)(outH + outM + outS + outF) * zoom);
                                StringBuilder subContent = new StringBuilder();
                                int i = 0;
                                while ((line = reader.readLine()) != null && !line.isEmpty()) {
                                    if (++i == 1) {
                                        subContent.append(line);
                                        continue;
                                    }
                                    subContent.append(String.valueOf(System.lineSeparator()) + line);
                                }
                                if (inPoint < outPoint) {
                                    timeline.add((Component)SubtitlesTimeline.addText(subContent.toString(), (int)((double)inPoint + (double)timelineScrollBar.getValue() * zoom), outPoint - inPoint), index);
                                } else {
                                    --index;
                                }
                                if (index > 1 && timeline.getComponent(index - 1).getX() + timeline.getComponent(index - 1).getWidth() > inPoint) {
                                    timeline.getComponent(index - 1).setSize(inPoint - timeline.getComponent(index - 1).getX(), timeline.getComponent(index - 1).getHeight());
                                }
                                ++index;
                            }
                            SubtitlesTimeline.repaintTimeline();
                        }
                    }
                    catch (Exception e) {
                        System.out.println(e);
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        caseShowWaveform.setEnabled(true);
                        if (caseShowWaveform.isSelected()) {
                            Thread addWaveform = new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    if (!VideoPlayer.waveform.exists()) {
                                        while (!VideoPlayer.waveform.exists()) {
                                            try {
                                                Thread.sleep(100L);
                                            }
                                            catch (InterruptedException interruptedException) {
                                                // empty catch block
                                            }
                                        }
                                        caseShowWaveform.setEnabled(true);
                                    }
                                    try {
                                        timeline.add(waveform);
                                        SubtitlesTimeline.repaintTimeline();
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            });
                            addWaveform.start();
                        }
                        frame.setCursor(Cursor.getPredefinedCursor(0));
                        break block28;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        reader.close();
                    }
                    catch (IOException addWaveform) {
                        // empty catch block
                    }
                    caseShowWaveform.setEnabled(true);
                    if (caseShowWaveform.isSelected()) {
                        Thread addWaveform = new Thread(new /* invalid duplicate definition of identical inner class */);
                        addWaveform.start();
                    }
                    frame.setCursor(Cursor.getPredefinedCursor(0));
                    throw throwable;
                }
                try {
                    reader.close();
                }
                catch (IOException addWaveform) {
                    // empty catch block
                }
                caseShowWaveform.setEnabled(true);
                if (caseShowWaveform.isSelected()) {
                    Thread addWaveform = new Thread(new /* invalid duplicate definition of identical inner class */);
                    addWaveform.start();
                }
                frame.setCursor(Cursor.getPredefinedCursor(0));
            } else {
                if (VideoPlayer.waveform.exists() && caseShowWaveform.isSelected() && waveform != null) {
                    timeline.remove(waveform);
                }
                int index = number;
                while (index > 1) {
                    if (index <= timeline.getComponentCount() - 1 && timeline.getComponent(index).getX() < timeline.getComponent(index - 1).getX()) {
                        int newIndex = index;
                        while (--index != 0 && timeline.getComponent(index).getX() >= timeline.getComponent(newIndex).getX()) {
                        }
                        Component toAdd = timeline.getComponent(newIndex);
                        timeline.remove(newIndex);
                        timeline.add(toAdd, index + 1);
                        break;
                    }
                    --index;
                }
                if (VideoPlayer.waveform.exists() && caseShowWaveform.isSelected() && waveform != null) {
                    timeline.add(waveform);
                }
                SubtitlesTimeline.repaintTimeline();
            }
        }
    }

    private static void previousSubtitle() {
        int time = 0;
        Component[] componentArray = timeline.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c instanceof JTextPane && (c.getLocation().x < SubtitlesTimeline.cursor.getLocation().x || c.getLocation().x + c.getWidth() < SubtitlesTimeline.cursor.getLocation().x)) {
                time = (int)((double)c.getLocation().x / zoom);
                if (c.getLocation().x + c.getWidth() < SubtitlesTimeline.cursor.getLocation().x) {
                    time = (int)((double)(c.getLocation().x + c.getWidth()) / zoom);
                }
            }
            ++n2;
        }
        SubtitlesTimeline.setVideoPosition(time);
    }

    private static void nextSubtitle() {
        int time = 0;
        Component[] componentArray = timeline.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c instanceof JTextPane) {
                if (c.getLocation().x > SubtitlesTimeline.cursor.getLocation().x) {
                    time = (int)((double)c.getLocation().x / zoom);
                    break;
                }
                if (c.getLocation().x + c.getWidth() > SubtitlesTimeline.cursor.getLocation().x) {
                    time = (int)((double)(c.getLocation().x + c.getWidth()) / zoom);
                    break;
                }
            }
            ++n2;
        }
        if (time > 0) {
            SubtitlesTimeline.setVideoPosition(time);
        }
    }

    private static void addSubtitles(boolean empty) {
        Component c;
        int previousSub = 0;
        int previousSubX = 0;
        int previousSubW = 0;
        int nextSubX = 0;
        boolean changeSize = false;
        Component[] componentArray = timeline.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            c = componentArray[n2];
            if (c instanceof JTextPane) {
                ++previousSub;
                if (SubtitlesTimeline.cursor.getLocation().x >= c.getLocation().x && SubtitlesTimeline.cursor.getLocation().x < c.getLocation().x + c.getWidth()) {
                    previousSubX = c.getLocation().x;
                    previousSubW = c.getWidth();
                    break;
                }
            }
            ++n2;
        }
        componentArray = timeline.getComponents();
        n = componentArray.length;
        n2 = 0;
        while (n2 < n) {
            c = componentArray[n2];
            if (c instanceof JTextPane && (int)((double)c.getLocation().x + (double)timelineScrollBar.getValue() * zoom) >= (int)((double)SubtitlesTimeline.cursor.getLocation().x + (double)timelineScrollBar.getValue() * zoom)) {
                nextSubX = (int)((double)c.getLocation().x + (double)timelineScrollBar.getValue() * zoom);
                changeSize = true;
                break;
            }
            ++n2;
        }
        int size = (int)(1000.0 * zoom);
        if (changeSize && (int)((double)nextSubX - ((double)SubtitlesTimeline.cursor.getLocation().x + (double)timelineScrollBar.getValue() * zoom)) < size) {
            size = (int)((double)nextSubX - ((double)SubtitlesTimeline.cursor.getLocation().x + (double)timelineScrollBar.getValue() * zoom));
        }
        if (cursor.getX() != previousSubX || previousSubX == 0) {
            if (cursor.getX() <= previousSubX + previousSubW && (double)cursor.getX() > 0.0 - (double)timelineScrollBar.getValue() * zoom) {
                timeline.getComponent(previousSub).setSize(cursor.getX() - previousSubX, timeline.getComponent(previousSub).getHeight());
                if (timeline.getComponent(previousSub).getWidth() <= 0) {
                    timeline.remove(previousSub);
                }
            }
            if (empty) {
                timeline.add(SubtitlesTimeline.addText("Title", (int)((double)SubtitlesTimeline.cursor.getLocation().x + (double)timelineScrollBar.getValue() * zoom), size));
            } else {
                timeline.add(SubtitlesTimeline.addText(txtSubtitles.getText(), (int)((double)SubtitlesTimeline.cursor.getLocation().x + (double)timelineScrollBar.getValue() * zoom), size));
            }
            SubtitlesTimeline.saveSubtitles(true, false);
            timeIn = 0L;
        }
    }

    private static void deleteSubtitles() {
        int n = 0;
        Component[] componentArray = timeline.getComponents();
        int n2 = componentArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Component c = componentArray[n3];
            if (c instanceof JTextPane) {
                ++n;
                if (SubtitlesTimeline.cursor.getLocation().x >= c.getLocation().x && SubtitlesTimeline.cursor.getLocation().x < c.getLocation().x + c.getWidth()) {
                    timeline.remove(n);
                    SubtitlesTimeline.saveSubtitles(true, false);
                    break;
                }
            }
            ++n3;
        }
        timeIn = 0L;
    }

    public static void loadBackupSubtitles() {
        File backupFile = new File(dirTemp + "/backup_1.srt");
        if (srt.exists() && backupFile.exists()) {
            File restoreFile;
            if (!dirTemp.exists()) {
                dirTemp.mkdir();
            }
            if ((restoreFile = new File(dirTemp + "/restore_1.srt")).exists()) {
                int n = 1;
                while ((restoreFile = new File(dirTemp + "/restore_" + ++n + ".srt")).exists()) {
                }
            }
            try {
                FileUtils.copyFile(srt, restoreFile);
            }
            catch (IOException n) {
                // empty catch block
            }
        }
        if (dirTemp.exists() && backupFile.exists()) {
            int n = 1;
            while (backupFile.exists()) {
                backupFile = new File(dirTemp + "/backup_" + ++n + ".srt");
            }
            File fileToRestore = new File(dirTemp + "/backup_" + (n - 1) + ".srt");
            timeline.removeAll();
            SubtitlesTimeline.setSubtitles(fileToRestore);
            fileToRestore.delete();
            SubtitlesTimeline.saveSubtitles(false, true);
            timeIn = 0L;
        }
    }

    public static void loadRestoreSubtitles() {
        File restoreFile = new File(dirTemp + "/restore_1.srt");
        if (dirTemp.exists() && restoreFile.exists()) {
            int n = 1;
            while (restoreFile.exists()) {
                restoreFile = new File(dirTemp + "/restore_" + ++n + ".srt");
            }
            File fileToRestore = new File(dirTemp + "/restore_" + (n - 1) + ".srt");
            timeline.removeAll();
            SubtitlesTimeline.setSubtitles(fileToRestore);
            fileToRestore.delete();
            SubtitlesTimeline.saveSubtitles(true, true);
            timeIn = 0L;
        }
    }

    private static void saveSubtitles(boolean backup, boolean restore) {
        if (!isSaving) {
            File restoreFile;
            isSaving = true;
            if (srt.exists() && backup) {
                File backupFile;
                if (!dirTemp.exists()) {
                    dirTemp.mkdir();
                }
                if ((backupFile = new File(dirTemp + "/backup_1.srt")).exists()) {
                    int n = 1;
                    while ((backupFile = new File(dirTemp + "/backup_" + ++n + ".srt")).exists()) {
                    }
                }
                try {
                    FileUtils.copyFile(srt, backupFile);
                }
                catch (IOException n) {
                    // empty catch block
                }
            }
            if (dirTemp.exists() && !restore && (restoreFile = new File(dirTemp + "/restore_1.srt")).exists()) {
                int n = 1;
                do {
                    restoreFile.delete();
                } while ((restoreFile = new File(dirTemp + "/restore_" + ++n + ".srt")).exists());
            }
            BufferedWriter writer = null;
            try {
                try {
                    writer = Files.newBufferedWriter(Paths.get(srt.toString(), new String[0]), StandardCharsets.UTF_8, new OpenOption[0]);
                    int n = 0;
                    ArrayList<Integer> subtitles = new ArrayList<Integer>();
                    Component[] componentArray = timeline.getComponents();
                    int n2 = componentArray.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        Component c = componentArray[n3];
                        if (c instanceof JTextPane) {
                            subtitles.add(c.getX());
                        }
                        ++n3;
                    }
                    Collections.sort(subtitles);
                    ArrayList<String> sortedSubtitles = new ArrayList<String>();
                    block23: for (Integer subtitle : subtitles) {
                        Component[] componentArray2 = timeline.getComponents();
                        int n4 = componentArray2.length;
                        int n5 = 0;
                        while (n5 < n4) {
                            Component c = componentArray2[n5];
                            if (c instanceof JTextPane && c.getX() == subtitle.intValue()) {
                                if (((JTextPane)c).getText().isEmpty() || ((JTextPane)c).getText() == null || ((JTextPane)c).getText() == "") continue block23;
                                sortedSubtitles.add(String.valueOf(c.getX()) + "|" + (c.getX() + c.getWidth()) + "|" + ((JTextPane)c).getText());
                                continue block23;
                            }
                            ++n5;
                        }
                    }
                    for (String subtitle : sortedSubtitles) {
                        String[] s = subtitle.split("\\|");
                        if (++n == 1) {
                            writer.write(String.valueOf(n) + System.lineSeparator());
                        } else {
                            writer.write(String.valueOf(System.lineSeparator()) + System.lineSeparator() + n + System.lineSeparator());
                        }
                        DecimalFormat f = new DecimalFormat("00");
                        DecimalFormat f2 = new DecimalFormat("000");
                        int inPoint = (int)((double)Integer.parseInt(s[0]) / zoom);
                        int outPoint = (int)((double)Integer.parseInt(s[1]) / zoom);
                        int inH = (int)((float)inPoint / 3600000.0f % 60.0f);
                        int inM = (int)((float)inPoint / 60000.0f % 60.0f);
                        int inS = (int)((float)inPoint / 1000.0f % 60.0f);
                        int inF = inPoint % 1000;
                        inF = (int)(Math.ceil((float)inF / (1000.0f / FFPROBE.currentFPS)) * (double)(1000.0f / FFPROBE.currentFPS));
                        int outH = (int)((float)outPoint / 3600000.0f % 60.0f);
                        int outM = (int)((float)outPoint / 60000.0f % 60.0f);
                        int outS = (int)((float)outPoint / 1000.0f % 60.0f);
                        int outF = outPoint % 1000;
                        outF = (int)(Math.ceil((float)outF / (1000.0f / FFPROBE.currentFPS)) * (double)(1000.0f / FFPROBE.currentFPS));
                        writer.write(String.valueOf(f.format(inH)) + ":" + f.format(inM) + ":" + f.format(inS) + "," + f2.format(inF) + " --> " + f.format(outH) + ":" + f.format(outM) + ":" + f.format(outS) + "," + f2.format(outF) + System.lineSeparator());
                        writer.write(s[2]);
                    }
                }
                catch (IOException iOException) {
                    try {
                        try {
                            writer.close();
                        }
                        catch (IOException iOException2) {
                            SubtitlesTimeline.subtitlesNumber();
                            SubtitlesTimeline.setSubtitles(srt);
                            isSaving = false;
                            VideoPlayer.player.repaint();
                            SubtitlesEdit.refreshSubtitles();
                        }
                    }
                    finally {
                        SubtitlesTimeline.subtitlesNumber();
                        SubtitlesTimeline.setSubtitles(srt);
                        isSaving = false;
                        VideoPlayer.player.repaint();
                        SubtitlesEdit.refreshSubtitles();
                    }
                }
            }
            finally {
                block37: {
                    try {
                        try {
                            writer.close();
                        }
                        catch (IOException iOException) {
                            SubtitlesTimeline.subtitlesNumber();
                            SubtitlesTimeline.setSubtitles(srt);
                            isSaving = false;
                            VideoPlayer.player.repaint();
                            SubtitlesEdit.refreshSubtitles();
                            break block37;
                        }
                    }
                    catch (Throwable throwable) {
                        SubtitlesTimeline.subtitlesNumber();
                        SubtitlesTimeline.setSubtitles(srt);
                        isSaving = false;
                        VideoPlayer.player.repaint();
                        SubtitlesEdit.refreshSubtitles();
                        throw throwable;
                    }
                    SubtitlesTimeline.subtitlesNumber();
                    SubtitlesTimeline.setSubtitles(srt);
                    isSaving = false;
                    VideoPlayer.player.repaint();
                    SubtitlesEdit.refreshSubtitles();
                }
            }
        }
    }

    private static void setVideoPosition(int time) {
        VideoPlayer.playerSetTime((float)time / VideoPlayer.inputFramerateMS);
    }

    public static int setTime(int rawTime) {
        int frames = rawTime % 1000;
        int time = rawTime - frames;
        int F = (int)(Math.ceil((float)frames / (1000.0f / FFPROBE.currentFPS)) * (double)(1000.0f / FFPROBE.currentFPS));
        return time + F;
    }

    public static int setTimeFloor(int rawTime) {
        int frames = rawTime % 1000;
        int time = rawTime - frames;
        int F = (int)(Math.floor((float)frames / (1000.0f / FFPROBE.currentFPS)) * (double)(1000.0f / FFPROBE.currentFPS));
        return time + F;
    }

    public static void subtitlesNumber() {
        block14: {
            BufferedReader reader = null;
            try {
                try {
                    String line;
                    if (!srt.exists()) {
                        srt.createNewFile();
                        timeline.removeAll();
                        timeline.add((Component)cursor, 0);
                    }
                    number = 0;
                    reader = Files.newBufferedReader(Paths.get(srt.toString(), new String[0]), StandardCharsets.UTF_8);
                    while ((line = reader.readLine()) != null) {
                        if (!(line = line.replace("\ufeff", "")).matches("[0-9]+") || Integer.parseInt(line) != number + 1) continue;
                        number = Integer.parseInt(line);
                    }
                    frame.setTitle(String.valueOf(Shutter.language.getProperty("frameSubtitles")) + " - " + number + " " + Shutter.language.getProperty("subtitlesLower"));
                }
                catch (Exception exception) {
                    try {
                        reader.close();
                    }
                    catch (Exception exception2) {}
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    reader.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                reader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (number > 0) {
            btnStart.setEnabled(true);
            btnEnd.setEnabled(true);
        }
    }

    private static void repaintTimeline() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                timeline.invalidate();
                timeline.validate();
                timeline.repaint();
            }
        });
    }

    private void PasteFromClipBoard() {
        Clipboard sysClip = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable clipTf = sysClip.getContents(null);
        if (clipTf != null && clipTf.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                boolean newSubtitle = true;
                if (txtSubtitles.getText().equals("Title")) {
                    txtSubtitles.setText((String)clipTf.getTransferData(DataFlavor.stringFlavor));
                } else if (frame.hasFocus()) {
                    txtSubtitles.setText(String.valueOf(txtSubtitles.getText()) + (String)clipTf.getTransferData(DataFlavor.stringFlavor));
                }
                Component[] componentArray = timeline.getComponents();
                int n = componentArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Component c = componentArray[n2];
                    if (c instanceof JTextPane && SubtitlesTimeline.cursor.getLocation().x >= c.getLocation().x && SubtitlesTimeline.cursor.getLocation().x < c.getLocation().x + c.getWidth()) {
                        ((JTextPane)c).setText(txtSubtitles.getText());
                        SubtitlesTimeline.repaintTimeline();
                        newSubtitle = false;
                        break;
                    }
                    ++n2;
                }
                if (newSubtitle) {
                    SubtitlesTimeline.addSubtitles(false);
                }
                if (txtSubtitles.getText().length() > 0) {
                    SubtitlesTimeline.saveSubtitles(true, false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class Offset {
        static int mouseX;
        static int offset;

        private Offset() {
        }
    }

    public static class RoundedBorder
    implements Border {
        private int radius;
        private Color color;

        RoundedBorder(int radius, Color color) {
            this.radius = radius;
            this.color = color;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(this.radius + 1, this.radius + 1, this.radius + 2, this.radius);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(this.color);
            g.drawRoundRect(x, y, width - 1, height - 1, this.radius, this.radius);
        }
    }
}

