/*
 * Decompiled with CFR 0.152.
 */
package application;

import application.Shutter;
import application.Utils;
import com.formdev.flatlaf.extras.FlatSVGIcon;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import library.FFMPEG;
import library.FFPROBE;
import settings.FunctionUtils;

public class SceneDetection {
    public static JFrame frame;
    private static JPanel topPanel;
    private boolean drag;
    private JLabel quit;
    private JLabel reduce;
    private JLabel topImage;
    private JLabel bottomImage;
    private static JLabel lblBottomArrow;
    private static JButton btnEDL;
    public static JLabel lblEdit;
    public static JTable table;
    public static DefaultTableModel tableRow;
    private static JSpinner tolerance;
    public static JButton btnAnalyze;
    public static JScrollPane scrollPane;
    private static int MousePositionX;
    private static int MousePositionY;
    public static File outputFolder;
    public static File outputFile;
    public static boolean isRunning;
    private static StringBuilder errorList;
    private static int complete;

    static {
        isRunning = false;
        errorList = new StringBuilder();
    }

    public SceneDetection(boolean runAnalyse) {
        frame = new JFrame();
        frame.getContentPane().setBackground(new Color(45, 45, 45));
        frame.setDefaultCloseOperation(2);
        frame.setTitle(Shutter.language.getProperty("frameDetectionCoupe"));
        frame.setForeground(Color.WHITE);
        frame.getContentPane().setLayout(null);
        frame.setSize(400, 584);
        frame.setMinimumSize(new Dimension(400, 138));
        frame.setResizable(false);
        frame.setAlwaysOnTop(true);
        if (!frame.isUndecorated()) {
            frame.setUndecorated(true);
            Area shape1 = new Area(new RoundRectangle2D.Double(0.0, 0.0, frame.getWidth(), frame.getHeight(), 15.0, 15.0));
            Area shape2 = new Area(new Rectangle(0, frame.getHeight() - 15, frame.getWidth(), 15));
            shape1.add(shape2);
            frame.setShape(shape1);
            frame.getRootPane().setBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, new Color(100, 100, 100)));
            frame.setIconImage(new ImageIcon(this.getClass().getClassLoader().getResource("contents/icon.png")).getImage());
            frame.setLocation(Shutter.frame.getLocation().x - SceneDetection.frame.getSize().width - 20, Shutter.frame.getLocation().y);
        }
        this.topPanel();
        this.content();
        this.drag = false;
        frame.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (SceneDetection.this.drag) {
                    frame.setSize(SceneDetection.frame.getSize().width, e.getY() + 10);
                    scrollPane.setSize(SceneDetection.scrollPane.getSize().width, SceneDetection.frame.getSize().height - 136);
                    lblBottomArrow.setLocation(0, SceneDetection.frame.getSize().height - SceneDetection.lblBottomArrow.getSize().height);
                    btnEDL.setBounds(9, 65 + scrollPane.getHeight() + 6, scrollPane.getWidth(), 21);
                    lblEdit.setLocation(frame.getWidth() / 2 - lblEdit.getWidth() / 2, 65 + scrollPane.getHeight() + 31);
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (MouseInfo.getPointerInfo().getLocation().y - SceneDetection.frame.getLocation().y > SceneDetection.frame.getSize().height - 20) {
                    frame.setCursor(Cursor.getPredefinedCursor(9));
                } else if (!SceneDetection.this.drag) {
                    frame.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        frame.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (frame.getCursor().getType() == 9) {
                    SceneDetection.this.drag = true;
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                SceneDetection.this.drag = false;
                frame.setCursor(Cursor.getPredefinedCursor(0));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (SceneDetection.frame.getSize().height <= 90) {
                    frame.setSize(SceneDetection.frame.getSize().width, 100);
                    lblBottomArrow.setLocation(0, SceneDetection.frame.getSize().height - SceneDetection.lblBottomArrow.getSize().height);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (frame.getCursor().getType() == 9) {
                    frame.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowDeiconified(WindowEvent we) {
                frame.toFront();
            }
        });
        frame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e2) {
                Area shape1 = new Area(new RoundRectangle2D.Double(0.0, 0.0, frame.getWidth(), frame.getHeight(), 15.0, 15.0));
                Area shape2 = new Area(new Rectangle(0, frame.getHeight() - 15, frame.getWidth(), 15));
                shape1.add(shape2);
                frame.setShape(shape1);
            }
        });
        Utils.changeFrameVisibility(frame, false);
        if (runAnalyse) {
            btnAnalyze.doClick();
        }
    }

    private void topPanel() {
        topPanel = new JPanel();
        topPanel.setLayout(null);
        topPanel.setBounds(0, 0, SceneDetection.frame.getSize().width, 28);
        this.quit = new JLabel(new FlatSVGIcon("contents/quit.svg", 15, 15));
        this.quit.setBounds(SceneDetection.frame.getSize().width - 20, 4, 15, 15);
        ImageIcon image = new ImageIcon(this.getClass().getClassLoader().getResource("contents/header.png"));
        Image scaledImage = image.getImage().getScaledInstance(SceneDetection.topPanel.getSize().width, SceneDetection.topPanel.getSize().height, 4);
        ImageIcon header = new ImageIcon(scaledImage);
        this.bottomImage = new JLabel(header);
        this.bottomImage.setBounds(0, 0, SceneDetection.frame.getSize().width, 28);
        JLabel title = new JLabel(Shutter.language.getProperty("frameDetectionCoupe"));
        title.setHorizontalAlignment(0);
        title.setBounds(0, 0, frame.getWidth(), 28);
        title.setFont(new Font(Shutter.magnetoFont, 0, 17));
        topPanel.add(title);
        this.topImage = new JLabel();
        ImageIcon imageIcon = new ImageIcon(header.getImage().getScaledInstance(SceneDetection.topPanel.getSize().width, SceneDetection.topPanel.getSize().height, 1));
        this.topImage.setIcon(imageIcon);
        this.topImage.setBounds(title.getBounds());
        this.reduce = new JLabel(new FlatSVGIcon("contents/reduce.svg", 15, 15));
        this.reduce.setHorizontalAlignment(0);
        this.reduce.setBounds(this.quit.getLocation().x - 20, 4, 15, 15);
        this.reduce.addMouseListener(new MouseListener(){
            private boolean accept = false;

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                SceneDetection.this.reduce.setIcon(new FlatSVGIcon("contents/reduce_pressed.svg", 15, 15));
                this.accept = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this.accept) {
                    frame.setState(1);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                SceneDetection.this.reduce.setIcon(new FlatSVGIcon("contents/reduce_hover.svg", 15, 15));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                SceneDetection.this.reduce.setIcon(new FlatSVGIcon("contents/reduce.svg", 15, 15));
                this.accept = false;
            }
        });
        topPanel.add(this.quit);
        topPanel.add(this.reduce);
        topPanel.add(this.topImage);
        topPanel.add(this.bottomImage);
        this.quit.addMouseListener(new MouseListener(){
            private boolean accept = false;

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                SceneDetection.this.quit.setIcon(new FlatSVGIcon("contents/quit_pressed.svg", 15, 15));
                this.accept = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this.accept) {
                    if (FFMPEG.runProcess.isAlive()) {
                        Shutter.btnCancel.doClick();
                    }
                    if (!Shutter.btnCancel.isEnabled()) {
                        if (outputFolder.exists()) {
                            SceneDetection.deleteDirectory(outputFolder);
                        }
                        Utils.changeFrameVisibility(frame, true);
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                SceneDetection.this.quit.setIcon(new FlatSVGIcon("contents/quit_hover.svg", 15, 15));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                SceneDetection.this.quit.setIcon(new FlatSVGIcon("contents/quit.svg", 15, 15));
                this.accept = false;
            }
        });
        topPanel.setBounds(0, 0, SceneDetection.frame.getSize().width, 28);
        frame.getContentPane().add(topPanel);
        this.bottomImage.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent down) {
            }

            @Override
            public void mousePressed(MouseEvent down) {
                MousePositionX = down.getPoint().x;
                MousePositionY = down.getPoint().y;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.bottomImage.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                frame.setLocation(MouseInfo.getPointerInfo().getLocation().x - MousePositionX, MouseInfo.getPointerInfo().getLocation().y - MousePositionY);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
    }

    private void content() {
        scrollPane = new JScrollPane();
        scrollPane.setBounds(9, 65, 380, SceneDetection.frame.getSize().height - 136);
        frame.getContentPane().add(scrollPane);
        JLabel lblSensibility = new JLabel(Shutter.language.getProperty("lblSensibility"));
        lblSensibility.setFont(new Font(Shutter.freeSansFont, 0, 12));
        lblSensibility.setBounds(10, 38, lblSensibility.getPreferredSize().width, 15);
        frame.getContentPane().add(lblSensibility);
        tolerance = new JSpinner(new SpinnerNumberModel(80, 0, 100, 10));
        tolerance.setBounds(lblSensibility.getX() + lblSensibility.getWidth() + 4, lblSensibility.getY() - 3, 55, 21);
        frame.getContentPane().add(tolerance);
        JLabel lblPourcentage = new JLabel("%");
        lblPourcentage.setFont(new Font(Shutter.freeSansFont, 0, 12));
        lblPourcentage.setBounds(tolerance.getX() + tolerance.getWidth() + 4, lblSensibility.getY(), 11, 15);
        frame.getContentPane().add(lblPourcentage);
        btnAnalyze = new JButton(Shutter.language.getProperty("btnAnalyse"));
        btnAnalyze.setFont(new Font(Shutter.montserratFont, 0, 12));
        btnAnalyze.setLocation(lblPourcentage.getX() + lblPourcentage.getWidth() + 7, lblSensibility.getY() - 3);
        btnAnalyze.setSize(frame.getWidth() - (tolerance.getX() + tolerance.getWidth()) - 34, 21);
        frame.getContentPane().add(btnAnalyze);
        btnAnalyze.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                tolerance.setEnabled(false);
                btnAnalyze.setEnabled(false);
                btnEDL.setEnabled(false);
                lblEdit.setVisible(false);
                if (outputFolder != null && outputFolder.exists()) {
                    SceneDetection.deleteDirectory(outputFolder);
                }
                if (tableRow != null) {
                    tableRow.setRowCount(0);
                }
                SceneDetection.runAnalyse();
            }
        });
        lblBottomArrow = new JLabel("\u25b2\u25bc");
        lblBottomArrow.setHorizontalAlignment(0);
        lblBottomArrow.setFont(new Font(Shutter.freeSansFont, 0, 20));
        lblBottomArrow.setSize(new Dimension(SceneDetection.frame.getSize().width, 20));
        lblBottomArrow.setLocation(0, SceneDetection.frame.getSize().height - SceneDetection.lblBottomArrow.getSize().height);
        lblBottomArrow.setVisible(true);
        frame.getContentPane().add(lblBottomArrow);
        btnEDL = new JButton(Shutter.language.getProperty("btnEDL"));
        btnEDL.setFont(new Font(Shutter.montserratFont, 0, 12));
        btnEDL.setEnabled(false);
        btnEDL.setBounds(9, 65 + scrollPane.getHeight() + 6, scrollPane.getWidth(), 21);
        frame.getContentPane().add(btnEDL);
        btnEDL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                frame.setCursor(Cursor.getPredefinedCursor(3));
                frame.setVisible(false);
                final FileDialog dialog = new FileDialog((Frame)frame, Shutter.language.getProperty("saveEDL"), 1);
                if (System.getProperty("os.name").contains("Mac") || System.getProperty("os.name").contains("Linux")) {
                    dialog.setDirectory(String.valueOf(System.getProperty("user.home")) + "/Desktop");
                } else {
                    dialog.setDirectory(String.valueOf(System.getProperty("user.home")) + "\\Desktop");
                }
                dialog.setLocation(SceneDetection.frame.getLocation().x - 50, SceneDetection.frame.getLocation().y + 50);
                dialog.setAlwaysOnTop(true);
                dialog.setVisible(true);
                frame.setCursor(Cursor.getPredefinedCursor(0));
                frame.setVisible(true);
                frame.toFront();
                if (dialog.getFile() != null) {
                    Thread runProcess = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            PrintWriter writer = null;
                            try {
                                writer = new PrintWriter(String.valueOf(dialog.getDirectory()) + dialog.getFile().replace(".edl", "") + ".edl", "UTF-8");
                                DecimalFormat formatEDL = new DecimalFormat("000000");
                                writer.println("TITLE: " + dialog.getFile());
                                int countItemsEDL = 0;
                                int i = 0;
                                while (i < tableRow.getRowCount()) {
                                    String timecodeStart = String.valueOf(tableRow.getValueAt(i, 2));
                                    String[] tcStart = timecodeStart.split(":");
                                    String tcIn = String.valueOf(tcStart[0]) + ":" + tcStart[1] + ":" + tcStart[2] + ":" + tcStart[3];
                                    long offset = tcStart[0] != "" && FFPROBE.timecode2 != "" && FFPROBE.timecode3 != "" && FFPROBE.timecode4 != "" ? (long)(Math.round(Integer.parseInt(FFPROBE.timecode1) * 3600 * Math.round(FFPROBE.currentFPS)) + Math.round(Integer.parseInt(FFPROBE.timecode2) * 60 * Math.round(FFPROBE.currentFPS)) + Math.round(Integer.parseInt(FFPROBE.timecode3) * Math.round(FFPROBE.currentFPS)) + Integer.parseInt(FFPROBE.timecode4)) : 0L;
                                    long totalFramesIn = Math.round(Integer.parseInt(tcStart[0]) * 3600 * Math.round(FFPROBE.currentFPS)) + Math.round(Integer.parseInt(tcStart[1]) * 60 * Math.round(FFPROBE.currentFPS)) + Math.round(Integer.parseInt(tcStart[2]) * Math.round(FFPROBE.currentFPS)) + Integer.parseInt(tcStart[3]);
                                    totalFramesIn = offset + totalFramesIn;
                                    DecimalFormat formatter = new DecimalFormat("00");
                                    String tcInVideo = String.valueOf(formatter.format(Math.round(totalFramesIn / (long)Math.round(FFPROBE.currentFPS)) / 3600)) + ":" + formatter.format(Math.round(totalFramesIn / (long)Math.round(FFPROBE.currentFPS) / 60L) % 60) + ":" + formatter.format(Math.round(totalFramesIn / (long)Math.round(FFPROBE.currentFPS) % 60L)) + ":" + formatter.format(totalFramesIn % (long)Math.round(FFPROBE.currentFPS));
                                    long totalFramesOut = 0L;
                                    if (i < tableRow.getRowCount() - 1) {
                                        String timecodeEnd = String.valueOf(tableRow.getValueAt(i + 1, 2));
                                        String[] tcEnd = timecodeEnd.split(":");
                                        totalFramesOut = Math.round(Integer.parseInt(tcEnd[0]) * 3600 * Math.round(FFPROBE.currentFPS)) + Math.round(Integer.parseInt(tcEnd[1]) * 60 * Math.round(FFPROBE.currentFPS)) + Math.round(Integer.parseInt(tcEnd[2]) * Math.round(FFPROBE.currentFPS)) + Integer.parseInt(tcEnd[3]);
                                    } else {
                                        String[] tc = FFPROBE.getVideoLengthTC.split(":");
                                        totalFramesOut = Math.round(Integer.parseInt(tc[0]) * 3600 * Math.round(FFPROBE.currentFPS)) + Math.round(Integer.parseInt(tc[1]) * 60 * Math.round(FFPROBE.currentFPS)) + Math.round(Integer.parseInt(tc[2]) * Math.round(FFPROBE.currentFPS)) + Integer.parseInt(tc[3]) * 10 / (1000 / Math.round(FFPROBE.currentFPS));
                                    }
                                    String tcOutTimeLine = String.valueOf(formatter.format(Math.round(totalFramesOut / (long)Math.round(FFPROBE.currentFPS)) / 3600)) + ":" + formatter.format(Math.round(totalFramesOut / (long)Math.round(FFPROBE.currentFPS) / 60L) % 60) + ":" + formatter.format(Math.round(totalFramesOut / (long)Math.round(FFPROBE.currentFPS) % 60L)) + ":" + formatter.format(totalFramesOut % (long)Math.round(FFPROBE.currentFPS));
                                    totalFramesOut = offset + totalFramesOut;
                                    String tcOutVideo = String.valueOf(formatter.format(Math.round(totalFramesOut / (long)Math.round(FFPROBE.currentFPS)) / 3600)) + ":" + formatter.format(Math.round(totalFramesOut / (long)Math.round(FFPROBE.currentFPS) / 60L) % 60) + ":" + formatter.format(Math.round(totalFramesOut / (long)Math.round(FFPROBE.currentFPS) % 60L)) + ":" + formatter.format(totalFramesOut % (long)Math.round(FFPROBE.currentFPS));
                                    String ext = outputFile.toString().substring(outputFile.toString().lastIndexOf("."));
                                    String cutName = i % 2 == 0 ? outputFile.toString().replace(" ", "_") : outputFile.toString().replace(" ", "_").replace(ext, "_" + Shutter.language.getProperty("cut") + ext);
                                    writer.println(String.valueOf(formatEDL.format(countItemsEDL + 1)) + "  " + cutName + " V     C        " + tcInVideo + " " + tcOutVideo + " " + tcIn + " " + tcOutTimeLine);
                                    writer.println(String.valueOf(formatEDL.format(countItemsEDL + 2)) + "  " + cutName + " A     C        " + tcInVideo + " " + tcOutVideo + " " + tcIn + " " + tcOutTimeLine);
                                    writer.println(String.valueOf(formatEDL.format(countItemsEDL + 3)) + "  " + cutName + " A2    C        " + tcInVideo + " " + tcOutVideo + " " + tcIn + " " + tcOutTimeLine);
                                    countItemsEDL += 3;
                                    ++i;
                                }
                            }
                            catch (Exception e) {
                                System.out.println(e);
                            }
                            writer.close();
                            JOptionPane.showMessageDialog(frame, Shutter.language.getProperty("fileCreated"), "EDL", 1);
                        }
                    });
                    runProcess.start();
                }
            }
        });
        lblEdit = new JLabel(Shutter.language.getProperty("lblEdit"));
        lblEdit.setForeground(Utils.themeColor);
        lblEdit.setHorizontalAlignment(0);
        lblEdit.setFont(new Font(Shutter.montserratFont, 0, 13));
        lblEdit.setSize(SceneDetection.lblEdit.getPreferredSize().width, 15);
        lblEdit.setLocation(frame.getWidth() / 2 - lblEdit.getWidth() / 2, 65 + scrollPane.getHeight() + 31);
        lblEdit.setVisible(false);
        frame.getContentPane().add(lblEdit);
    }

    private static void newTable() {
        ImageIcon imageIcon = new ImageIcon(String.valueOf(outputFolder.toString()) + "/0.png");
        ImageIcon icon = new ImageIcon(imageIcon.getImage().getScaledInstance(142, 80, 1));
        Object[][] firstImage = new Object[][]{{"1", icon, "00:00:00:00"}};
        tableRow = new DefaultTableModel(firstImage, new String[]{"N\u00b0", Shutter.language.getProperty("cut"), Shutter.language.getProperty("lblTimecode")});
        DefaultTableCellRenderer dtcr = new DefaultTableCellRenderer();
        dtcr.setHorizontalAlignment(0);
        table = new JTable(tableRow){

            public Class getColumnClass(int column) {
                return this.getValueAt(0, column).getClass();
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        DefaultTableCellRenderer centerRenderer = new DefaultTableCellRenderer();
        centerRenderer.setHorizontalAlignment(0);
        table.getColumnModel().getColumn(0).setCellRenderer(centerRenderer);
        table.getColumnModel().getColumn(2).setCellRenderer(centerRenderer);
        table.setShowVerticalLines(false);
        table.setSelectionMode(0);
        table.setRowHeight(80);
        table.getColumnModel().getColumn(0).setPreferredWidth(18);
        table.getColumnModel().getColumn(1).setPreferredWidth(table.getColumnModel().getColumn(1).getPreferredWidth());
        table.setBounds(9, 65, 380, frame.getHeight() - 134);
        scrollPane.setViewportView(table);
        table.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (!(e.getKeyCode() != 127 && e.getKeyCode() != 8 || FFMPEG.isRunning || table.getSelectedRowCount() <= 0)) {
                    File imageToDelete = new File(String.valueOf(outputFolder.toString()) + "/" + table.getSelectedRow() + ".png");
                    imageToDelete.delete();
                    int i = 0;
                    File[] fileArray = outputFolder.listFiles();
                    int n = fileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File file = fileArray[n2];
                        if (file.toString().substring(file.toString().lastIndexOf(".")).equals(".png")) {
                            file.renameTo(new File(String.valueOf(outputFolder.toString()) + "/" + i + ".png"));
                        }
                        ++i;
                        ++n2;
                    }
                    tableRow.removeRow(table.getSelectedRow());
                    int n3 = 0;
                    while (n3 < tableRow.getRowCount()) {
                        table.getModel().setValueAt(String.valueOf(n3 + 1), n3, 0);
                        ++n3;
                    }
                    table.repaint();
                }
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
            }

            @Override
            public void keyTyped(KeyEvent arg0) {
            }
        });
        final JPopupMenu popupListe = new JPopupMenu();
        JMenuItem visualiser = new JMenuItem(Shutter.language.getProperty("menuItemVisualiser"));
        JMenuItem ouvrirDossier = new JMenuItem(Shutter.language.getProperty("menuItemOuvrirDossier"));
        JMenuItem copieTimeCode = new JMenuItem(Shutter.language.getProperty("menuItemCopyTimecode"));
        visualiser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Desktop.getDesktop().open(new File(outputFolder + "/" + table.getSelectedRow() + ".png"));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        ouvrirDossier.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Desktop.getDesktop().open(outputFolder);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        copieTimeCode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String timecode = tableRow.getValueAt(table.getSelectedRow(), 2).toString();
                StringSelection stringSelection = new StringSelection(timecode);
                Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
                clpbrd.setContents(stringSelection, null);
            }
        });
        popupListe.add(visualiser);
        popupListe.add(ouvrirDossier);
        popupListe.add(copieTimeCode);
        table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1 && table.getSelectedRowCount() == 1) {
                    try {
                        Desktop.getDesktop().open(new File(outputFolder + "/" + table.getSelectedRow() + ".png"));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (e.getButton() == 3 || (e.getModifiersEx() & 0x80) == 2 && e.getButton() == 1) {
                    popupListe.show(table, e.getX() - 30, e.getY());
                }
            }
        });
    }

    public static void runAnalyse() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                complete = 0;
                Shutter.lblFilesEnded.setText(FunctionUtils.completedFiles(complete));
                int i = 0;
                while (i < Shutter.liste.getSize()) {
                    File file = new File(Shutter.liste.getElementAt(i));
                    if (i > 0) {
                        new SceneDetection(false);
                    }
                    try {
                        FFPROBE.Data(file.toString());
                        do {
                            Thread.sleep(100L);
                        } while (FFPROBE.isRunning);
                        String filename = file.getName();
                        Shutter.lblCurrentEncoding.setText(filename);
                        String sortie = file.getParent();
                        String extension = filename.substring(filename.lastIndexOf("."));
                        outputFolder = new File(String.valueOf(sortie) + "/" + filename.replace(extension, ""));
                        outputFolder.mkdir();
                        outputFile = new File(file.getName());
                        String cmd = " -f image2 -vframes 1 ";
                        FFMPEG.run(" -i \"" + file.toString() + '\"' + cmd + "-y " + '\"' + outputFolder.toString() + "/0.png" + '\"');
                        do {
                            Thread.sleep(100L);
                        } while (FFMPEG.runProcess.isAlive());
                        SceneDetection.newTable();
                        String tol = String.valueOf((float)(100 - Integer.valueOf(tolerance.getValue().toString())) / 100.0f);
                        cmd = " -vf select=\"gt(scene\\," + tol + ")" + '\"' + ",showinfo -vsync 2 -f image2 ";
                        FFMPEG.run(" -i \"" + file.toString() + '\"' + cmd + "-y " + '\"' + outputFolder.toString() + "/%01d.png" + '\"');
                        do {
                            Thread.sleep(100L);
                        } while (FFMPEG.runProcess.isAlive());
                        SceneDetection.lastAction();
                    }
                    catch (InterruptedException e) {
                        FFMPEG.error = true;
                    }
                    ++i;
                }
                if (errorList.length() != 0) {
                    JOptionPane.showMessageDialog(Shutter.frame, String.valueOf(Shutter.language.getProperty("notProcessedFiles")) + " " + '\n' + '\n' + errorList.toString(), Shutter.language.getProperty("encodingError"), 0);
                }
                errorList.setLength(0);
                FFMPEG.enfOfFunction();
            }
        });
        thread.start();
    }

    private static void lastAction() {
        if (FFMPEG.error) {
            errorList.append(System.lineSeparator());
        }
        if (!FFMPEG.cancelled && !FFMPEG.error) {
            Shutter.lblFilesEnded.setText(FunctionUtils.completedFiles(++complete));
        }
        tolerance.setEnabled(true);
        btnAnalyze.setEnabled(true);
        btnEDL.setEnabled(true);
        lblEdit.setVisible(true);
    }

    public static boolean deleteDirectory(File dir) {
        if (!dir.exists() || !dir.isDirectory()) {
            return false;
        }
        String[] files = dir.list();
        int i = 0;
        int len = files.length;
        while (i < len) {
            File f = new File(dir, files[i]);
            if (f.isDirectory()) {
                SceneDetection.deleteDirectory(f);
            } else {
                f.delete();
            }
            ++i;
        }
        return dir.delete();
    }
}

