/**
 * This load profile represents a constant load over the entire duration:
 *  ▲
 *  │
 *  │
 *  ├────────────────── maxLoad
 *  │
 *  └──────────────────►
 */
module.exports = {
  id: 'constant',
  params: ['maxLoad'],

  /**
   * A constant load is created by returning the maxLoad regardless of the elapsed time.
   *
   * @param  {Number} params.maxLoad - The maximum load this load profile should evaluate to.
   * @return {Number} The evaluated load for this point in time.
   */
  evaluate ({ maxLoad }) {
    // A maxLoad of 0 isn't necessarily invalid, but it's best to avoid weird behavior unless we have a specific use
    // case for it.
    if (maxLoad <= 0) {
      throw new RangeError('Maximum load must be a non-zero positive integer.');
    }

    return maxLoad;
  }
};
