const { expect } = require('chai'),
    { consoleFormat } = require('../format');

describe('Console Format', () => {
    it('should not fail for undefined', () => {
        expect(consoleFormat()).to.equal('undefined undefined undefined undefined');
    });

    it('should not fail for missing of all property', () => {
        expect(consoleFormat({})).to.equal('undefined undefined undefined undefined');
    });

    it('should not fail for missing of single property level', () => {
        let expectedMessage = '12345 origin undefined "foo"';
        // eslint-disable-next-line max-len
        expect(consoleFormat({ origin: 'origin', timestamp: 12345, messages: 'foo' })).to.equal(expectedMessage);
    });

    it('should not fail for additional property level (sessionId)', () => {
        let expectedMessage = '12345 origin info "foo"';
        // eslint-disable-next-line max-len
        expect(consoleFormat({ origin: 'origin', level: 'info', sessionId: 1234567, timestamp: 12345, messages: 'foo' })).to.equal(expectedMessage);
    });

    it('should stringify message object', () => {
        let expectedMessage = '12345 origin error {"foo":"bar"}';
        // eslint-disable-next-line max-len
        expect(consoleFormat({ level: 'error', sessionId: 123, origin: 'origin', timestamp: 12345, messages: { foo: 'bar' } })).to.equal(expectedMessage);
    });

    it('should stringify message array', () => {
        let expectedMessage = '12345 origin error "foo","bar"';
        // eslint-disable-next-line max-len
        expect(consoleFormat({ level: 'error', sessionId: 123, origin: 'origin', timestamp: 12345, messages: ['foo', 'bar'] })).to.equal(expectedMessage);
    });

    it('should stringify message array of objects', () => {
        let expectedMessage = '12345 origin error {"foo":"bar"}';
        // eslint-disable-next-line max-len
        expect(consoleFormat({ level: 'error', sessionId: 123, origin: 'origin', timestamp: 12345, messages: [{ foo: 'bar' }] })).to.equal(expectedMessage);
    });

    it('should stringify circular JSON', () => {
        let expectedMessage = '12345 origin error {"a":["~","~a"]},[{"a":"~"},"~"]',
            message = [{}];

        message[0].a = message;
        message.push(message);

        // eslint-disable-next-line max-len
        expect(consoleFormat({ level: 'error', sessionId: 123, origin: 'origin', timestamp: 12345, messages: message })).to.equal(expectedMessage);
    });
});
