'use strict';
const MetricAggregator = require('./metric-aggregator');

/**
 * Calculates metrics for different metrics as well as their request id grouping.
 * This is oblivious to the time window grouping
 */
class MetricSummary {
	constructor () {
		this.metricsAggregator = {
      aggregatedMetrics: new MetricAggregator(),
      groupedByRequest: {}
    };
	}

	_addRequestMetric ({ metricName, requestId, value, isError }) {
		if (!this.metricsAggregator.groupedByRequest[requestId]) {
			this.metricsAggregator.groupedByRequest[requestId] = new MetricAggregator();
		}

		this.metricsAggregator.groupedByRequest[requestId].add({ metricName, value, isError });
	}

  /**
   * Adds the metric data point. Will impact the metrics
   * @param {Object} params
   * @param {String} params.metricName - Name of the metric for which data point is being added
   * @param {String} params.requestId - Request id for which the metric is emitted.
   * @param {Number} params.value - Value of the metric for which data point is being added
   */
  add ({ metricName, requestId, value, isError }) {
    this.metricsAggregator.aggregatedMetrics.add({ metricName, value, isError });
    requestId && this._addRequestMetric({ metricName, requestId, value, isError });
  }

  /**
   * returns the metrics for the data-points that were added, with aggregates as well as grouped by request id
   * @returns {Object}
   */
	getMetrics () {
    const summary = {
      aggregatedMetrics: this.metricsAggregator.aggregatedMetrics.getMetrics(),
      groupedByRequest: {
      }
    };

    Object.keys(this.metricsAggregator.groupedByRequest).forEach((key) => {
      summary.groupedByRequest[key] = { aggregatedMetrics: this.metricsAggregator.groupedByRequest[key].getMetrics() };
    });

		return summary;
	}
}

module.exports = MetricSummary;
