"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Client = void 0;
const grpc_js_1 = require("@grpc/grpc-js");
const descriptor_1 = require("./descriptor");
const services = __importStar(require("./reflection_grpc_pb"));
const reflection_pb_1 = require("./reflection_pb");
const descriptor_2 = require("@postman/protobufjs/ext/descriptor");
const lodash_set_1 = __importDefault(require("lodash.set"));
class Client {
    constructor(url, credentials, options, metadata) {
        this.fileDescriptorCache = new Map();
        this.fileDescriptorCache = new Map();
        this.metadata = metadata || new grpc_js_1.Metadata();
        this.grpcClient = new services.ServerReflectionClient(url, credentials, options);
    }
    listServices() {
        return new Promise((resolve, reject) => {
            function dataCallback(response) {
                var _a;
                if (response.hasListServicesResponse()) {
                    const services = (_a = response
                        .getListServicesResponse()) === null || _a === void 0 ? void 0 : _a.getServiceList().map(svc => {
                        return svc.getName();
                    });
                    resolve(services || []);
                }
                else {
                    reject(Error());
                }
            }
            function errorCallback(e) {
                reject(e);
            }
            const request = new reflection_pb_1.ServerReflectionRequest();
            request.setListServices('*');
            const grpcCall = this.grpcClient.serverReflectionInfo(this.metadata);
            grpcCall.on('data', dataCallback);
            grpcCall.on('error', errorCallback);
            grpcCall.write(request);
            grpcCall.end();
        });
    }
    fileContainingSymbol(symbol) {
        return new Promise((resolve, reject) => {
            this.getFileContainingSymbol(symbol)
                .then(val => resolve(this.resolveFileDescriptorSet(val)))
                .catch(err => reject(err));
        });
    }
    fileByFilename(filename) {
        return new Promise((resolve, reject) => {
            this.getFilesByFilenames([filename])
                .then(val => resolve(this.resolveFileDescriptorSet(val)))
                .catch(err => reject(err));
        });
    }
    async resolveFileDescriptorSet(fileDescriptorProtos) {
        const fileDescriptorMap = await this.resolveDescriptorRecursive(fileDescriptorProtos);
        const fileDescriptorSet = descriptor_2.FileDescriptorSet.create();
        lodash_set_1.default(fileDescriptorSet, 'file', Array.from(fileDescriptorMap.values()));
        return descriptor_1.getDescriptorRootFromDescriptorSet(fileDescriptorSet);
    }
    async resolveDescriptorRecursive(fileDescriptorProtos = [], fileDescriptorMap = new Map()) {
        await Promise.all(fileDescriptorProtos.map(async (fileDescriptorProto) => {
            if (fileDescriptorMap.has(fileDescriptorProto.name)) {
                return;
            }
            else {
                fileDescriptorMap.set(fileDescriptorProto.name, fileDescriptorProto);
            }
            const dependencies = (fileDescriptorProto.dependency || []).filter((dependency) => !fileDescriptorMap.has(dependency));
            if (dependencies.length) {
                await this.resolveDescriptorRecursive(await this.getFilesByFilenames(dependencies), fileDescriptorMap);
            }
        }));
        return fileDescriptorMap;
    }
    getFileContainingSymbol(symbol) {
        const fileDescriptorCache = this.fileDescriptorCache;
        return new Promise((resolve, reject) => {
            function dataCallback(response) {
                var _a;
                if (response.hasFileDescriptorResponse()) {
                    const fileDescriptorProtoBytes = (((_a = response
                        .getFileDescriptorResponse()) === null || _a === void 0 ? void 0 : _a.getFileDescriptorProtoList()) || []);
                    resolve(fileDescriptorProtoBytes.map(descriptorByte => {
                        const fileDescriptorProto = descriptor_2.FileDescriptorProto.decode(descriptorByte);
                        fileDescriptorCache.set(fileDescriptorProto.name, fileDescriptorProto);
                        return fileDescriptorProto;
                    }));
                }
                else {
                    reject(Error());
                }
            }
            function errorCallback(e) {
                reject(e);
            }
            const request = new reflection_pb_1.ServerReflectionRequest();
            request.setFileContainingSymbol(symbol);
            const grpcCall = this.grpcClient.serverReflectionInfo(this.metadata);
            grpcCall.on('data', dataCallback);
            grpcCall.on('error', errorCallback);
            grpcCall.write(request);
            grpcCall.end();
        });
    }
    getFilesByFilenames(symbols) {
        const result = [];
        const fileDescriptorCache = this.fileDescriptorCache;
        const symbolsToFetch = symbols.filter(symbol => {
            const cached = fileDescriptorCache.get(symbol);
            if (cached) {
                result.push(cached);
                return false;
            }
            return true;
        });
        if (symbolsToFetch.length === 0) {
            return Promise.resolve(result);
        }
        return new Promise((resolve, reject) => {
            function dataCallback(response) {
                var _a, _b;
                if (response.hasFileDescriptorResponse()) {
                    (_b = (_a = response
                        .getFileDescriptorResponse()) === null || _a === void 0 ? void 0 : _a.getFileDescriptorProtoList()) === null || _b === void 0 ? void 0 : _b.forEach(descriptorByte => {
                        if (descriptorByte instanceof Uint8Array) {
                            const fileDescriptorProto = descriptor_2.FileDescriptorProto.decode(descriptorByte);
                            fileDescriptorCache.set(fileDescriptorProto.name, fileDescriptorProto);
                            result.push(fileDescriptorProto);
                        }
                    });
                }
                else {
                    reject(Error());
                }
            }
            function errorCallback(e) {
                reject(e);
            }
            const grpcCall = this.grpcClient.serverReflectionInfo(this.metadata);
            grpcCall.on('data', dataCallback);
            grpcCall.on('error', errorCallback);
            grpcCall.on('end', () => {
                resolve(result);
            });
            symbolsToFetch.forEach(symbol => {
                const request = new reflection_pb_1.ServerReflectionRequest();
                grpcCall.write(request.setFileByFilename(symbol));
            });
            grpcCall.end();
        });
    }
}
exports.Client = Client;
//# sourceMappingURL=client.js.map