# Postman App Updater @postman/app-updater

> This is a simple module which helps in orchestrating the `auto-updater` modules.

Right now it is orchestrating the [electron.auto-updater](https://electronjs.org/docs/api/auto-updater) module.

Example:

```javascript
    const AppUpdaterAdapter = {

        getCurrentVersion () {
          // eg: return '0.0.2'
        },

        getLastKnownVersion (cb) {
          // eg: cb('0.0.1')
        },

        setLastKnownVersion (version) {
          // Handle storing the version
        },

        getAutoUpdater () {
          // auto-updater to be used.
          // eg: return electron.autoUpdater;
        }
    },
    Updater = new require('@postman/app-updater')(AppUpdaterAdapter);
```
#
# Events

## Event: 'checkingForUpdates'
  Only for **`macOS`** and **`windows`**

  This will be emitted when the `auto-updater` start checking for updates

## Event: 'updateAvailable'

  ## Returns

  - `event` Object
  - `notes` [String]
  - `name` [String]
  - `date` [String]
  - `url` [String]

  This will be emitted when the  `auto-updater` finds the update is available.

  Happens when the updateURL returns **200** status code with update information.

**On Windows only `name` is available.**

## Event: 'updateDownloaded'
  This will be emitted when the `auto-updater` downloaded the update.

## Event: 'updateNotAvailable'

  This will be emitted when the `auto-updater` finds that there is not update available.

  Happens when the updateURL returns **204** status code.

## Event: 'beforeAppQuit'

  This will be emitted before the module calls the `auto-updater.quitAndInstall()` in the `restartAndUpdate` method.

## Event: 'versionUpdated'

  ## Returns
  - `lastKnownVersion` [String]
  - `currentVersion` String

  This will be emitted when the `checkVersionUpdate` method finds that there is a version update happened.

#
# Constructor
## For Linux
When a linux app is updated, it will start the new app with command line flags `--updated` and `--eid=$eid`. These flags are used to cleanup the the installation directory. Old tar files, unfinished packages and old extracted packages will be deleted.

# Methods

## Method: 'Updater.downloadUpdate(updateInfo)'

  - `updateInfo` Object
  - `updateInfo.updateServerDomain` String
  - `updateInfo.platform` String
  - `updateInfo.version` String
  - `updateInfo.channel` String

  This method will orchestrate the auto-updater to download the update if available.

  ### For Windows and MacOS:

  When this method it called, It generates the `updateURL` using `Updater.getFeedURL(updateInfo)`

  It calls `auto-updater.setFeedUrl(updateURL)` and then it calls `auto-updater.checkForUpdates()`

  ### Fires
  - `checkingForUpdates`
  - `updateAvailable`
  - `updateDownloaded`
  - `updateNotAvailable`
  - `error`

## Method: 'Updater.restartToUpdate()'

  This method is used quit the app and initiate the restart of the app to update.

  It first triggers the `quittingApp` event then calls `autoUpdater.quitAndInstall()`

  ### Fires
  - `quittingApp`

## Method: 'Updater.checkVersionUpdate()'

  This method is used to check whether there is a version update happened, and also to store the current version.

  ### Fires
  - `versionUpdated`


The implementation of `electron.auto-updater` is explained in this [wiki](https://postmanlabs.atlassian.net/wiki/spaces/ENGINEERING/pages/340066360/AutoUpdate+Electron+1.8.3+Squirrel+integration)
