/* unity.vapi generated by valac 0.56.2, do not modify. */

[CCode (gir_namespace = "Unity", gir_version = "7.0")]
namespace Unity {
	namespace Internal {
		namespace IO {
		}
		namespace Utils {
			namespace Diff {
			}
		}
	}
	[CCode (cheader_filename = "unity.h")]
	public abstract class AbstractPreview : GLib.Object {
		protected AbstractPreview ();
		public abstract uint8[] serialize_as (Unity.SerializationType serialization_type);
	}
	[CCode (cheader_filename = "unity.h")]
	public abstract class AbstractScope : GLib.Object {
		protected AbstractScope ();
		public virtual Unity.ActivationResponse? activate (Unity.ScopeResult result, Unity.SearchMetadata metadata, string? action_id);
		public abstract Unity.ResultPreviewer create_previewer (Unity.ScopeResult result, Unity.SearchMetadata metadata);
		public abstract Unity.ScopeSearchBase create_search_for_query (Unity.SearchContext search_context);
		public abstract Unity.CategorySet get_categories ();
		public abstract Unity.FilterSet get_filters ();
		public abstract string get_group_name ();
		public abstract Unity.Schema get_schema ();
		public virtual string get_search_hint ();
		public abstract string get_unique_name ();
		public virtual string normalize_search_query (string search_query);
		public void results_invalidated (Unity.SearchType search_type);
		public signal void results_invalidated_internal (Unity.SearchType search_type);
	}
	[CCode (cheader_filename = "unity.h")]
	public class ActivationResponse : GLib.Object {
		public ActivationResponse (Unity.HandledType handled, string goto_uri = "");
		public ActivationResponse.with_preview (Unity.Preview preview);
		public ActivationResponse.with_search (string search_string, Unity.FilterSet? filter_set, Unity.SearchMetadata? search_metadata);
		public string goto_uri { get; set construct; }
		public Unity.HandledType handled { get; construct; }
	}
	[CCode (cheader_filename = "unity.h")]
	public class AggregatedScopeSearch : Unity.DeprecatedScopeSearch {
		public AggregatedScopeSearch (Unity.AggregatorScope owner, string channel_id, GLib.HashTable<string,GLib.Variant> hints, Dee.SerializableModel results_model);
		public void push_filter_settings (Unity.FilterSet filters);
		public async void push_results (string scope_id, Dee.SerializableModel results_model, string[] category_ids);
		protected override void run ();
		protected override void run_async (Unity.ScopeSearchBaseCallback cb);
		public async GLib.HashTable<string,GLib.Variant> search_scope (string scope_id, string search_string, Unity.SearchType search_type, GLib.HashTable<string,GLib.Variant>? hints) throws GLib.Error;
		public signal void category_order_changed (uint32[] category_indices);
		public signal void transaction_complete (string origin_scope_id);
	}
	[CCode (cheader_filename = "unity.h")]
	public class AggregatorActivation : GLib.Object {
		public AggregatorActivation (string channel_id, string scope_id, uint action_type, Unity.ScopeResult? result);
		public uint action_type { get; set; }
		public string channel_id { get; set; }
		public GLib.HashTable<string,GLib.Variant> hints { get; internal set; }
		public string scope_id { get; set; }
		public Unity.ScopeResult? scope_result { get; set; }
	}
	[CCode (cheader_filename = "unity.h")]
	public abstract class AggregatorScope : Unity.DeprecatedScopeBase {
		public enum MergeMode {
			CATEGORY_ID,
			OWNER_SCOPE
		}
		public enum SortFlags {
			ASCENDING,
			DESCENDING,
			CASE_INSENSITIVE
		}
		protected AggregatorScope (string dbus_path_, string id_, Unity.AggregatorScope.MergeMode merge_mode = AggregatorScope.MergeMode.OWNER_SCOPE, bool proxy_filter_hints = false);
		public virtual async Unity.ActivationResponse? activate (Unity.AggregatorActivation activation);
		public void add_constraint (int category_index, string field);
		public void add_sorter (uint category_index, string field, Unity.AggregatorScope.SortFlags flags);
		public abstract int category_index_for_scope_id (string scope_id);
		public abstract async void search (Unity.AggregatedScopeSearch scope_search);
		public bool automatic_flushing { get; set; }
		public Unity.AggregatorScope.MergeMode merge_mode { get; set; }
		public bool proxy_filter_hints { get; set; }
	}
	[CCode (cheader_filename = "unity.h")]
	public class AnnotatedIcon : GLib.Object {
		public AnnotatedIcon (GLib.Icon base_icon);
		public void set_colorize_rgba (double r, double g, double b, double a);
		public string to_string ();
		public Unity.CategoryType category { get; set; }
		public GLib.Icon icon { get; set; }
		public string ribbon { get; set; }
		public Unity.IconSizeHint size_hint { get; set; }
	}
	[CCode (cheader_filename = "unity.h")]
	public class AppInfoManager : GLib.Object {
		public void clear ();
		public unowned string[]? get_categories (string id);
		public static Unity.AppInfoManager get_default ();
		[Version (deprecated = true, replacement = "AppInfoManager.get_default")]
		public static Unity.AppInfoManager get_instance ();
		public unowned string[]? get_keywords (string id);
		public string? get_path (string id);
		public GLib.AppInfo? lookup (string id);
		public async GLib.AppInfo? lookup_async (string id) throws GLib.Error;
		public signal void changed (string id, GLib.AppInfo? new_appinfo);
	}
	[CCode (cheader_filename = "unity.h")]
	public class ApplicationPreview : Unity.Preview {
		public ApplicationPreview (string title, string subtitle, string description, GLib.Icon? icon, GLib.Icon? screenshot);
		public void set_rating (float rating, uint num_ratings);
		public GLib.Icon app_icon { get; set; }
		public string copyright { get; set; }
		public string last_update { get; set; }
		public string license { get; set; }
	}
	[CCode (cheader_filename = "unity.h")]
	public abstract class Cancellable : GLib.Object {
		protected Cancellable ();
		public abstract void cancel ();
		public static Unity.Cancellable create ();
		public virtual GLib.Cancellable? get_gcancellable ();
		public abstract bool is_cancelled ();
	}
	[CCode (cheader_filename = "unity.h")]
	public class Category : GLib.Object {
		public Category (string id, string name, GLib.Icon icon_hint, Unity.CategoryRenderer renderer = CategoryRenderer.VERTICAL_TILE);
		public void add_metadata_provider (Unity.MetadataProvider provider);
		public Unity.CategoryContentType content_type { get; set construct; }
		public Unity.CategoryRenderer default_renderer { get; construct; }
		public GLib.Icon? icon_hint { get; construct; }
		public string id { get; construct; }
		public string name { get; construct; }
		public string renderer { get; }
		public string renderer_hint { get; set; }
	}
	[CCode (cheader_filename = "unity.h")]
	public class CategorySet : GLib.Object {
		public CategorySet ();
		public virtual void add (Unity.Category category);
		public virtual GLib.List<weak Unity.Category> get_categories ();
	}
	[CCode (cheader_filename = "unity.h")]
	public class CheckOptionFilter : Unity.OptionsFilter {
		public CheckOptionFilter (string id, string display_name, GLib.Icon? icon_hint = null, bool collapsed = false);
	}
	[CCode (cheader_filename = "unity.h")]
	public class CheckOptionFilterCompact : Unity.OptionsFilter {
		public CheckOptionFilterCompact (string id, string display_name, GLib.Icon? icon_hint = null, bool collapsed = false);
	}
	[CCode (cheader_filename = "unity.h")]
	public class DeprecatedScope : Unity.DeprecatedScopeBase {
		public DeprecatedScope (string dbus_path_, string id_);
		public virtual async Unity.ActivationResponse? activate_result (Unity.ScopeResult result);
		public virtual async Unity.Preview? preview_result (Unity.ScopeResult result);
		public void queue_search_changed (Unity.SearchType search_type);
		public signal Unity.ActivationResponse? activate_uri (string uri);
		[Signal (detailed = true)]
		public signal string generate_search_key (Unity.DeprecatedScopeSearch search);
		public signal Unity.Preview? preview_uri (string uri);
		public signal void search_changed (Unity.DeprecatedScopeSearch search, Unity.SearchType search_type, GLib.Cancellable cancellable);
	}
	[CCode (cheader_filename = "unity.h")]
	public abstract class DeprecatedScopeBase : GLib.Object {
		protected DeprecatedScopeBase (string dbus_path_, string id_);
		protected override void constructed ();
		public void export () throws GLib.Error;
		public void unexport ();
		public Unity.CategorySet categories { get; set; }
		public string dbus_path { get; construct; }
		public Unity.FilterSet filters { get; set; }
		public string id { get; construct; }
		public bool is_master { get; construct; }
		public Unity.Schema schema { get; set; }
		public string search_hint { get; set; }
		public bool search_in_global { get; set; }
		public Unity.OptionsFilter sources { get; internal set; }
		public bool visible { get; set; }
		public signal void active_sources_changed (string[] active_ids);
	}
	[CCode (cheader_filename = "unity.h")]
	public class DeprecatedScopeSearch : Unity.ScopeSearchBase {
		public bool equals (Unity.DeprecatedScopeSearch other);
		public unowned Unity.Filter? get_filter (string filter_id);
		protected override void run ();
		protected override void run_async (Unity.ScopeSearchBaseCallback cb);
		public void set_reply_hint (string key, GLib.Variant variant);
		public string channel_id { get; construct; }
		public GLib.HashTable<string,GLib.Variant> hints { get; construct; }
		public weak Unity.DeprecatedScopeBase owner { get; construct; }
		public Dee.SerializableModel results_model { get; construct; }
		public string search_string { get; }
		public Unity.SearchType search_type { get; }
		public signal void finished ();
	}
	[CCode (cheader_filename = "unity.h")]
	public abstract class Filter : GLib.Object, Dee.Serializable {
		protected Filter ();
		public bool collapsed { get; internal set construct; }
		public string display_name { get; internal set construct; }
		public bool filtering { get; internal set construct; }
		public GLib.Icon? icon_hint { get; construct; }
		public string id { get; construct; }
		public Unity.FilterRenderer renderer { get; construct; }
		public bool visible { get; set construct; }
		public signal void changed ();
	}
	[CCode (cheader_filename = "unity.h")]
	public class FilterOption : GLib.Object {
		public FilterOption (string id, string display_name, GLib.Icon? icon_hint = null, bool active = false);
		public bool active { get; set construct; }
		public string display_name { get; construct; }
		public GLib.Icon icon_hint { get; construct; }
		public string id { get; construct; }
	}
	[CCode (cheader_filename = "unity.h")]
	public class FilterSet : GLib.Object {
		public FilterSet ();
		public virtual void add (Unity.Filter filter);
		public virtual unowned Unity.Filter? get_filter_by_id (string filter_id);
		public virtual GLib.List<weak Unity.Filter> get_filters ();
	}
	[CCode (cheader_filename = "unity.h")]
	public class GenericPreview : Unity.Preview {
		public GenericPreview (string title, string description, GLib.Icon? image);
	}
	[CCode (cheader_filename = "unity.h")]
	public class GeoCoordinate : GLib.Object {
		public double altitude;
		public double latitude;
		public double longitude;
		public GeoCoordinate (double latitude_, double longitude_);
		public bool has_valid_altitude ();
		public GeoCoordinate.with_altitude (double latitude_, double longitude_, double altitude_);
	}
	[CCode (cheader_filename = "unity.h")]
	public class InfoHint : GLib.InitiallyUnowned {
		public InfoHint (string id, string display_name, GLib.Icon? icon_hint, string data);
		public InfoHint.with_variant (string id, string display_name, GLib.Icon? icon_hint, GLib.Variant data);
		public GLib.Variant data { get; construct; }
		public string display_name { get; construct; }
		public GLib.Icon? icon_hint { get; construct; }
		public string id { get; construct; }
	}
	[CCode (cheader_filename = "unity.h")]
	public class Inspector : GLib.Object {
		public static unowned Unity.Inspector get_default ();
		public string? unity_bus_name { get; }
		public bool unity_running { get; }
	}
	[CCode (cheader_filename = "unity.h")]
	public class LauncherEntry : Dee.Serializable, GLib.Object {
		public static Unity.LauncherEntry get_for_app_uri (string app_uri);
		public static Unity.LauncherEntry get_for_desktop_file (string desktop_file);
		public static Unity.LauncherEntry get_for_desktop_id (string desktop_id);
		public string app_uri { get; set construct; }
		public int64 count { get; set; }
		public bool count_visible { get; set; }
		public double progress { get; set; }
		public bool progress_visible { get; set; }
		public Dbusmenu.Menuitem? quicklist { get; set; }
		public bool urgent { get; set; }
	}
	[CCode (cheader_filename = "unity.h")]
	public class LauncherFavorites : GLib.Object {
		public GLib.AppInfo[] enumerate_app_infos ();
		public string[] enumerate_ids ();
		public static unowned Unity.LauncherFavorites get_default ();
		public bool has_app_id (string app_id);
		public bool has_app_info (GLib.AppInfo appinfo);
		public GLib.AppInfo? lookup (string app_id);
		public signal void changed ();
	}
	[CCode (cheader_filename = "unity.h")]
	public class MasterScope : Unity.AggregatorScope {
		public MasterScope (string dbus_path_, string id_);
		public override int category_index_for_scope_id (string scope_id);
		protected override async void search (Unity.AggregatedScopeSearch scope_search);
		public string no_content_hint { get; set; }
	}
	[CCode (cheader_filename = "unity.h")]
	public abstract class MetadataProvider : GLib.Object {
		protected MetadataProvider ();
	}
	[CCode (cheader_filename = "unity.h")]
	public class MoviePreview : Unity.Preview {
		public MoviePreview (string title, string subtitle, string description, GLib.Icon? image);
		public void set_rating (float rating, uint num_ratings);
		public string year { get; set; }
	}
	[CCode (cheader_filename = "unity.h")]
	public class MultiRangeFilter : Unity.OptionsFilter {
		public MultiRangeFilter (string id, string display_name, GLib.Icon? icon_hint = null, bool collapsed = false);
		public Unity.FilterOption? get_first_active ();
		public Unity.FilterOption? get_last_active ();
	}
	[CCode (cheader_filename = "unity.h")]
	public class MusicPlayer : GLib.Object {
		public MusicPlayer (string desktop);
		public bool add_playlist (Unity.Playlist p);
		public void edit_playlist_name (string id, string name);
		public void export ();
		public Unity.Playlist[] get_playlists ();
		public bool remove_playlist (Unity.Playlist p);
		public void unexport ();
		public GLib.AppInfo app_info { get; construct; }
		public bool can_go_next { get; set; }
		public bool can_go_previous { get; set; }
		public bool can_pause { get; set; }
		public bool can_play { get; set; }
		public Unity.Playlist current_playlist { get; set; }
		public Unity.TrackMetadata current_track { get; set; }
		public string desktop_file_name { get; construct; }
		public bool is_blacklisted { get; set; }
		public Unity.PlaybackState playback_state { get; set; }
		public Dbusmenu.Menuitem? player_menu { get; set; }
		public string title { get; set; }
		public Dbusmenu.Menuitem? track_menu { get; set; }
		public signal void activate_playlist (GLib.ObjectPath playlist_id);
		public signal void next ();
		public signal void play_pause ();
		public signal void previous ();
		public signal void raise ();
	}
	[CCode (cheader_filename = "unity.h")]
	public class MusicPreview : Unity.Preview {
		public enum TrackState {
			STOPPED,
			PLAYING,
			PAUSED
		}
		public MusicPreview (string title, string subtitle, GLib.Icon? image);
		public void add_track (Unity.TrackMetadata track);
	}
	[CCode (cheader_filename = "unity.h")]
	public class OptionsFilter : Unity.Filter {
		public enum SortType {
			MANUAL,
			DISPLAY_NAME,
			ID
		}
		public GLib.List<Unity.FilterOption> options;
		public OptionsFilter ();
		public Unity.FilterOption add_option (string id, string display_name, GLib.Icon? icon_hint = null);
		public Unity.FilterOption? get_option (string id);
		public bool remove_option (string id);
		public bool show_all_button { get; set; }
		public Unity.OptionsFilter.SortType sort_type { get; set; }
	}
	[CCode (cheader_filename = "unity.h")]
	public class PaymentPreview : Unity.Preview {
		public enum Type {
			APPLICATION,
			MUSIC,
			ERROR
		}
		public PaymentPreview (string title, string subtitle, GLib.Icon? image);
		public PaymentPreview.for_application (string title, string subtitle, GLib.Icon? image);
		public PaymentPreview.for_error (string title, string subtitle, GLib.Icon? image);
		public PaymentPreview.for_music (string title, string subtitle, GLib.Icon? image);
		public PaymentPreview.for_type (string title, string subtitle, GLib.Icon? image, Unity.PaymentPreview.Type type);
		public string email { get; set; }
		public string header { get; set; }
		public string payment_method { get; set; }
		public Unity.PaymentPreview.Type preview_type { get; set; }
		public string purchase_prize { get; set; }
		public string purchase_type { get; set; }
	}
	[CCode (cheader_filename = "unity.h")]
	public class Playlist : GLib.Object {
		public Playlist (string id);
		public GLib.DateTime creation_date { get; set; }
		public GLib.Icon icon { get; set; }
		public string id { get; construct; }
		public GLib.DateTime last_play_date { get; set; }
		public GLib.DateTime modification_date { get; set; }
		public string name { get; set; }
	}
	[CCode (cheader_filename = "unity.h")]
	public class PreferencesManager : GLib.Object {
		public enum RemoteContent {
			ALL,
			NONE
		}
		public static Unity.PreferencesManager get_default ();
		public string[] always_search { get; set; }
		public string[] disabled_scopes { get; set; }
		public string[] home_lens_default_view { get; set; }
		public string[] home_lens_priority { get; set; }
		public Unity.PreferencesManager.RemoteContent remote_content_search { get; set; }
	}
	[CCode (cheader_filename = "unity.h")]
	public abstract class Preview : Unity.AbstractPreview, Dee.Serializable {
		protected Preview ();
		public void add_action (Unity.PreviewAction action);
		public void add_info (Unity.InfoHint info_hint);
		protected override uint8[] serialize_as (Unity.SerializationType serialize_type);
		public string description_markup { get; set; }
		public GLib.Icon? image { get; set; }
		public string image_source_uri { get; set; }
		public string subtitle { get; set; }
		public string title { get; set; }
	}
	[CCode (cheader_filename = "unity.h")]
	public class PreviewAction : GLib.Object, Dee.Serializable {
		public PreviewAction (string id, string display_name, GLib.Icon? icon_hint);
		public PreviewAction.with_layout_hint (string id, string display_name, GLib.Icon? icon_hint, Unity.LayoutHint layout);
		public PreviewAction.with_uri (string uri, string display_name, GLib.Icon? icon_hint);
		public string display_name { get; construct; }
		public string extra_text { get; set; }
		public GLib.HashTable<string,GLib.Variant>? hints { get; }
		public GLib.Icon? icon_hint { get; construct; }
		public string id { get; construct; }
		public Unity.LayoutHint layout_hint { get; construct; }
		public signal Unity.ActivationResponse activated (string uri);
	}
	[CCode (cheader_filename = "unity.h")]
	public class ProgressSourceProvider : Unity.MetadataProvider {
		public ProgressSourceProvider (string dbus_name, string dbus_path);
		public string dbus_name { get; construct; }
		public string dbus_path { get; construct; }
	}
	[CCode (cheader_filename = "unity.h")]
	public class RadioOptionFilter : Unity.OptionsFilter {
		public RadioOptionFilter (string id, string display_name, GLib.Icon? icon_hint = null, bool collapsed = false);
		public Unity.FilterOption? get_active_option ();
	}
	[CCode (cheader_filename = "unity.h")]
	public class RatingsFilter : Unity.Filter {
		public RatingsFilter (string id, string display_name, GLib.Icon? icon_hint = null, bool collapsed = false);
		public float rating { get; internal set construct; }
	}
	[CCode (cheader_filename = "unity.h")]
	public abstract class ResultPreviewer : GLib.Object {
		public Unity.Cancellable cancellable;
		public Unity.SearchMetadata metadata;
		public Unity.ScopeResult result;
		protected ResultPreviewer ();
		public abstract Unity.AbstractPreview? run ();
		public virtual void run_async (Unity.AbstractPreviewCallback async_callback);
		public void set_scope_result (Unity.ScopeResult scope_result);
		public void set_search_metadata (Unity.SearchMetadata search_metadata);
	}
	[CCode (cheader_filename = "unity.h")]
	public abstract class ResultSet : GLib.Object {
		public int ttl;
		protected ResultSet ();
		public abstract void add_result (Unity.ScopeResult result);
		public virtual void add_result_from_variant (GLib.Variant variant);
		public virtual void flush ();
	}
	[CCode (cheader_filename = "unity.h")]
	public class Schema : GLib.Object {
		public struct FieldInfo {
			public string name;
			public string schema;
			public Unity.Schema.FieldType type;
		}
		public enum FieldType {
			OPTIONAL,
			REQUIRED
		}
		public Schema ();
		public virtual void add_field (string name, string schema, Unity.Schema.FieldType type);
		public virtual GLib.List<weak Unity.Schema.FieldInfo?> get_fields ();
	}
	[CCode (cheader_filename = "unity.h")]
	public class ScopeDBusConnector : GLib.Object {
		public ScopeDBusConnector (Unity.AbstractScope scope);
		public void export () throws GLib.Error;
		public static void quit ();
		public static void run ();
		public void unexport ();
		public Unity.AbstractScope scope { get; construct; }
	}
	[CCode (cheader_filename = "unity.h")]
	public class ScopeLoader : GLib.Object {
		public ScopeLoader ();
		public virtual void export_scopes (GLib.List<Unity.AbstractScope> scopes) throws GLib.Error;
		public virtual GLib.List<Unity.AbstractScope> get_scopes (string module_name, string? module_type) throws GLib.Error;
		public void load_group (string group_name) throws GLib.Error;
		public void load_module (string module, string? module_type) throws GLib.Error;
		public void load_scope (string scope_id) throws GLib.Error;
	}
	[CCode (cheader_filename = "unity.h")]
	public abstract class ScopeSearchBase : GLib.Object {
		public Unity.SearchContext? search_context;
		protected ScopeSearchBase ();
		public abstract void run ();
		public virtual void run_async (Unity.ScopeSearchBaseCallback async_callback);
		public virtual void set_search_context (Unity.SearchContext ctx);
	}
	[CCode (cheader_filename = "unity.h")]
	public class SearchMetadata : GLib.Object {
		public SearchMetadata ();
		public static Unity.SearchMetadata create (GLib.HashTable<string,GLib.Variant>? metadata);
		public static Unity.SearchMetadata create_from_variant (GLib.Variant metadata);
		public string? form_factor { get; }
		public string? locale { get; }
		public Unity.GeoCoordinate? location { get; }
	}
	[CCode (cheader_filename = "unity.h")]
	public class SimpleScope : Unity.AbstractScope {
		public delegate Unity.ActivationResponse? ActivateFunc (Unity.ScopeResult result, Unity.SearchMetadata metadata, string? action_id);
		public delegate void PreviewRunAsyncFunc (Unity.ResultPreviewer previewer, Unity.AbstractPreviewCallback cb);
		public delegate Unity.AbstractPreview? PreviewRunFunc (Unity.ResultPreviewer previewer);
		public delegate void SearchRunAsyncFunc (Unity.ScopeSearchBase search, Unity.ScopeSearchBaseCallback cb);
		public delegate void SearchRunFunc (Unity.ScopeSearchBase search);
		public SimpleScope ();
		protected override Unity.ActivationResponse? activate (Unity.ScopeResult result, Unity.SearchMetadata metadata, string? action_id);
		protected override Unity.ResultPreviewer create_previewer (Unity.ScopeResult result, Unity.SearchMetadata metadata);
		protected override Unity.ScopeSearchBase create_search_for_query (Unity.SearchContext ctx);
		protected override Unity.CategorySet get_categories ();
		protected override Unity.FilterSet get_filters ();
		protected override string get_group_name ();
		protected override Unity.Schema get_schema ();
		protected override string get_search_hint ();
		protected override string get_unique_name ();
		public void set_activate_func (owned Unity.SimpleScope.ActivateFunc? func);
		public void set_preview_async_func (owned Unity.SimpleScope.PreviewRunAsyncFunc? func);
		public void set_preview_func (owned Unity.SimpleScope.PreviewRunFunc func);
		public void set_search_async_func (owned Unity.SimpleScope.SearchRunAsyncFunc? func);
		public void set_search_func (owned Unity.SimpleScope.SearchRunFunc func);
		public Unity.CategorySet category_set { get; set; }
		public Unity.FilterSet filter_set { get; set; }
		public string group_name { get; set; }
		public Unity.Schema schema { get; set; }
		public string search_hint { get; set; }
		public string unique_name { get; set; }
	}
	[CCode (cheader_filename = "unity.h")]
	public class SocialPreview : Unity.Preview {
		public class Comment : GLib.InitiallyUnowned {
			public Comment (string id, string name, string text, string time);
			public string id { get; construct; }
			public string name { get; construct; }
			public string text { get; construct; }
			public string time { get; construct; }
		}
		public SocialPreview (string sender, string subtitle, string content, GLib.Icon? avatar);
		public void add_comment (Unity.SocialPreview.Comment comment);
		public GLib.Icon avatar { get; set; }
		public string content { get; set; }
		public string sender { get; set; }
	}
	[CCode (cheader_filename = "unity.h")]
	public class TrackMetadata : GLib.Object {
		public TrackMetadata ();
		public TrackMetadata.full (string uri, int track_no, string title, string artist, string album, uint length);
		public string album { get; set; }
		public GLib.Icon art_icon { get; set; }
		public GLib.File art_location { get; set; }
		public string artist { get; set; }
		public uint length { get; set; }
		public string title { get; set; }
		public int track_no { get; set; }
		public string uri { get; set; }
	}
	[CCode (cheader_filename = "unity.h")]
	public struct ActivePlaylistContainer {
		public bool valid;
		public Unity.PlaylistDetails details;
	}
	[CCode (cheader_filename = "unity.h")]
	public struct PlaylistDetails {
		public GLib.ObjectPath id;
		public string name;
		public string icon_name;
	}
	[CCode (cheader_filename = "unity.h")]
	public struct ScopeResult {
		public string uri;
		public string icon_hint;
		public uint category;
		public Unity.ResultType result_type;
		public string mimetype;
		public string title;
		public string comment;
		public string dnd_uri;
		public GLib.HashTable<string,GLib.Variant>? metadata;
		public static Unity.ScopeResult? create (string uri, string? icon_hint, uint category, Unity.ResultType result_type, string mimetype, string title, string comment, string dnd_uri, GLib.HashTable<string,GLib.Variant> metadata);
		public static Unity.ScopeResult? create_from_variant (GLib.Variant variant);
	}
	[CCode (cheader_filename = "unity.h")]
	public struct SearchContext {
		public string search_query;
		public Unity.SearchType search_type;
		public Unity.FilterSet filter_state;
		public Unity.SearchMetadata search_metadata;
		public Unity.ResultSet result_set;
		public Unity.Cancellable cancellable;
		public static Unity.SearchContext? create (string search_query, Unity.SearchType search_type, Unity.FilterSet? filter_state, GLib.HashTable<string,GLib.Variant>? metadata, Unity.ResultSet result_set, Unity.Cancellable? cancellable);
		public void set_search_metadata (Unity.SearchMetadata metadata);
	}
	[CCode (cheader_filename = "unity.h")]
	public enum CategoryContentType {
		DEFAULT,
		APPLICATIONS,
		MUSIC,
		VIDEO,
		PLACES,
		SOCIAL,
		WEATHER;
		public static Unity.CategoryContentType from_string (string content_type);
		public static unowned string to_string (Unity.CategoryContentType val);
	}
	[CCode (cheader_filename = "unity.h")]
	public enum CategoryRenderer {
		DEFAULT,
		GRID,
		CAROUSEL,
		LIST,
		DYNAMIC,
		SPECIAL,
		VERTICAL_TILE,
		HORIZONTAL_TILE;
		public static Unity.CategoryRenderer from_string (string renderer_name);
		public static unowned string to_string (Unity.CategoryRenderer val);
	}
	[CCode (cheader_filename = "unity.h")]
	public enum CategoryType {
		NONE,
		APPLICATION,
		BOOK,
		MUSIC,
		MOVIE,
		GAMES,
		ELECTRONICS,
		COMPUTERS,
		OFFICE,
		HOME,
		GARDEN,
		PETS,
		TOYS,
		CHILDREN,
		BABY,
		CLOTHES,
		SHOES,
		WATCHES,
		SPORTS,
		OUTDOORS,
		GROCERY,
		HEALTH,
		BEAUTY,
		DIY,
		TOOLS,
		CAR,
		N_CATEGORIES
	}
	[CCode (cheader_filename = "unity.h")]
	public enum FilterRenderer {
		CHECK_OPTIONS,
		RADIO_OPTIONS,
		MULTIRANGE,
		RATINGS,
		CHECK_OPTIONS_COMPACT;
		public static unowned string to_string (Unity.FilterRenderer renderer);
		public static Unity.FilterRenderer from_string (string renderer_name);
	}
	[CCode (cheader_filename = "unity.h")]
	public enum HandledType {
		NOT_HANDLED,
		SHOW_DASH,
		HIDE_DASH,
		GOTO_DASH_URI,
		SHOW_PREVIEW,
		PERFORM_SEARCH
	}
	[CCode (cheader_filename = "unity.h")]
	public enum IconSizeHint {
		DEFAULT,
		SMALL,
		LARGE
	}
	[CCode (cheader_filename = "unity.h")]
	public enum LayoutHint {
		NONE,
		LEFT,
		RIGHT,
		TOP,
		BOTTOM
	}
	[CCode (cheader_filename = "unity.h")]
	public enum PlaybackState {
		PLAYING,
		PAUSED
	}
	[CCode (cheader_filename = "unity.h")]
	public enum ResultType {
		DEFAULT,
		PERSONAL,
		SEMI_PERSONAL
	}
	[CCode (cheader_filename = "unity.h")]
	public enum SearchType {
		DEFAULT,
		GLOBAL,
		N_TYPES
	}
	[CCode (cheader_filename = "unity.h")]
	public enum SerializationType {
		BINARY,
		JSON
	}
	[CCode (cheader_filename = "unity.h")]
	public delegate void AbstractPreviewCallback (Unity.ResultPreviewer previewer, Unity.AbstractPreview? preview);
	[CCode (cheader_filename = "unity.h")]
	public delegate void ScopeSearchBaseCallback (Unity.ScopeSearchBase instance);
	[CCode (cheader_filename = "unity.h")]
	public const int SCOPE_API_VERSION;
	[CCode (cheader_filename = "unity.h")]
	public static void object_unref (void* object);
	[CCode (cheader_filename = "unity.h")]
	public static int scope_module_get_version ();
	[CCode (cheader_filename = "unity.h")]
	public static GLib.List<Unity.AbstractScope> scope_module_load_scopes () throws GLib.Error;
}
