/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3.framebody;

import java.nio.ByteBuffer;
import java.util.List;
import org.jaudiotagger.tag.InvalidTagException;
import org.jaudiotagger.tag.datatype.Pair;
import org.jaudiotagger.tag.datatype.PairedTextEncodedStringNullTerminated;
import org.jaudiotagger.tag.id3.framebody.AbstractFrameBodyPairs;
import org.jaudiotagger.tag.id3.framebody.FrameBodyIPLS;
import org.jaudiotagger.tag.id3.framebody.ID3v24FrameBody;
import org.jaudiotagger.tag.id3.valuepair.StandardIPLSKey;

public class FrameBodyTIPL
extends AbstractFrameBodyPairs
implements ID3v24FrameBody {
    public static final String ENGINEER = StandardIPLSKey.ENGINEER.getKey();
    public static final String MIXER = StandardIPLSKey.MIXER.getKey();
    public static final String DJMIXER = StandardIPLSKey.DJMIXER.getKey();
    public static final String PRODUCER = StandardIPLSKey.PRODUCER.getKey();
    public static final String ARRANGER = StandardIPLSKey.ARRANGER.getKey();

    public FrameBodyTIPL() {
    }

    public FrameBodyTIPL(byte textEncoding, String text) {
        super(textEncoding, text);
    }

    public FrameBodyTIPL(ByteBuffer byteBuffer, int frameSize) throws InvalidTagException {
        super(byteBuffer, frameSize);
    }

    public FrameBodyTIPL(FrameBodyIPLS body) {
        this.setObjectValue("TextEncoding", body.getTextEncoding());
        this.setObjectValue("Text", body.getPairing());
    }

    public FrameBodyTIPL(byte textEncoding, List<Pair> pairs) {
        this.setObjectValue("TextEncoding", textEncoding);
        PairedTextEncodedStringNullTerminated.ValuePairs values = new PairedTextEncodedStringNullTerminated.ValuePairs();
        for (Pair next : pairs) {
            values.add(next);
        }
        this.setObjectValue("Text", values);
    }

    @Override
    public String getIdentifier() {
        return "TIPL";
    }
}

