/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.io;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import org.jaudiotagger.audio.asf.data.Chunk;
import org.jaudiotagger.audio.asf.data.ContainerType;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.data.MetadataContainer;
import org.jaudiotagger.audio.asf.data.MetadataDescriptor;
import org.jaudiotagger.audio.asf.io.ChunkReader;
import org.jaudiotagger.audio.asf.util.Utils;

public class MetadataReader
implements ChunkReader {
    private static final GUID[] APPLYING = new GUID[]{ContainerType.EXTENDED_CONTENT.getContainerGUID(), ContainerType.METADATA_OBJECT.getContainerGUID(), ContainerType.METADATA_LIBRARY_OBJECT.getContainerGUID()};

    @Override
    public boolean canFail() {
        return false;
    }

    @Override
    public GUID[] getApplyingIds() {
        return (GUID[])APPLYING.clone();
    }

    @Override
    public Chunk read(GUID guid, InputStream stream, long streamPosition) throws IOException {
        BigInteger chunkLen = Utils.readBig64(stream);
        MetadataContainer result = new MetadataContainer(guid, streamPosition, chunkLen);
        boolean isExtDesc = result.getContainerType() == ContainerType.EXTENDED_CONTENT;
        int recordCount = Utils.readUINT16(stream);
        for (int i = 0; i < recordCount; ++i) {
            long dataLen;
            int languageIndex = 0;
            int streamNumber = 0;
            if (!isExtDesc) {
                languageIndex = Utils.readUINT16(stream);
                assert (languageIndex >= 0 && languageIndex < 127);
                assert (result.getContainerType() == ContainerType.METADATA_LIBRARY_OBJECT || languageIndex == 0);
                streamNumber = Utils.readUINT16(stream);
                assert (streamNumber >= 0 && streamNumber <= 127);
            }
            int nameLen = Utils.readUINT16(stream);
            String recordName = null;
            if (isExtDesc) {
                recordName = Utils.readFixedSizeUTF16Str(stream, nameLen);
            }
            int dataType = Utils.readUINT16(stream);
            assert (dataType >= 0 && dataType <= 6);
            long l = dataLen = isExtDesc ? (long)Utils.readUINT16(stream) : Utils.readUINT32(stream);
            assert (dataLen >= 0L);
            assert (result.getContainerType() == ContainerType.METADATA_LIBRARY_OBJECT || dataLen <= MetadataDescriptor.DWORD_MAXVALUE);
            if (!isExtDesc) {
                recordName = Utils.readFixedSizeUTF16Str(stream, nameLen);
            }
            MetadataDescriptor descriptor = new MetadataDescriptor(result.getContainerType(), recordName, dataType, streamNumber, languageIndex);
            switch (dataType) {
                case 0: {
                    descriptor.setStringValue(Utils.readFixedSizeUTF16Str(stream, (int)dataLen));
                    break;
                }
                case 1: {
                    descriptor.setBinaryValue(Utils.readBinary(stream, dataLen));
                    break;
                }
                case 2: {
                    assert (isExtDesc && dataLen == 4L || !isExtDesc && dataLen == 2L);
                    descriptor.setBooleanValue(this.readBoolean(stream, (int)dataLen));
                    break;
                }
                case 3: {
                    assert (dataLen == 4L);
                    descriptor.setDWordValue(Utils.readUINT32(stream));
                    break;
                }
                case 5: {
                    assert (dataLen == 2L);
                    descriptor.setWordValue(Utils.readUINT16(stream));
                    break;
                }
                case 4: {
                    assert (dataLen == 8L);
                    descriptor.setQWordValue(Utils.readUINT64(stream));
                    break;
                }
                case 6: {
                    assert (dataLen == 16L);
                    descriptor.setGUIDValue(Utils.readGUID(stream));
                    break;
                }
                default: {
                    descriptor.setStringValue("Invalid datatype: " + new String(Utils.readBinary(stream, dataLen)));
                }
            }
            result.addDescriptor(descriptor);
        }
        return result;
    }

    private boolean readBoolean(InputStream stream, int length) throws IOException {
        byte[] tmp = new byte[length];
        stream.read(tmp);
        return tmp[length - 1] == 1;
    }
}

