/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.ant.gettext;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.Commandline;
import org.xnap.commons.ant.gettext.AbstractGettextTask;

public class GettextMergeKeysTask
extends AbstractGettextTask {
    protected String msgmergeCmd = "msgmerge";

    public void setMsgmergeCmd(String string) {
        this.msgmergeCmd = string;
    }

    private void checkPreconditions() throws BuildException {
        if (this.poDirectory == null) {
            throw new BuildException("poDirectory must be set for msgmerge");
        }
    }

    public void execute() {
        this.checkPreconditions();
        this.log("Invoking msgmerge for po files in '" + this.poDirectory + "'.");
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(this.poDirectory);
        directoryScanner.setIncludes(new String[]{"**/*.po"});
        directoryScanner.scan();
        String[] stringArray = directoryScanner.getIncludedFiles();
        for (int j = 0; j < stringArray.length; ++j) {
            this.log("Processing " + stringArray[j]);
            Commandline commandline = new Commandline();
            commandline.setExecutable(this.msgmergeCmd);
            commandline.createArgument().setValue("-q");
            commandline.createArgument().setValue("--backup=numbered");
            commandline.createArgument().setValue("-U");
            commandline.createArgument().setFile(new File(this.poDirectory, stringArray[j]));
            commandline.createArgument().setValue(new File(this.poDirectory, this.keysFile).getAbsolutePath());
            this.log("Executing: " + commandline.toString(), 2);
            this.runCommandLineAndWait(commandline);
        }
    }
}

