/*
 * Decompiled with CFR 0.152.
 */
package org.xnap.commons.ant.gettext;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.FileSet;
import org.xnap.commons.ant.gettext.AbstractGettextTask;
import org.xnap.commons.ant.gettext.GettextUtils;

public class GettextExtractKeysTask
extends AbstractGettextTask {
    protected Vector filesets = new Vector();
    private String xgettextCommand = "xgettext";
    private String encoding = "utf-8";
    private String keywords = "-ktrc:1c,2 -ktrnc:1c,2,3 -ktr -kmarktr -ktrn:1,2 -k";

    public void addFileSet(FileSet fileSet) {
        this.filesets.add(fileSet);
    }

    public void setXgettextCommand(String string) {
        this.xgettextCommand = string;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setKeywords(String string) {
        this.keywords = string;
    }

    private void checkPreconditions() throws BuildException {
        if (this.poDirectory == null) {
            throw new BuildException("poDirectory must be set for xgettext");
        }
        if (this.filesets.isEmpty()) {
            throw new BuildException("at least one fileset must be specified to search for .java files in");
        }
    }

    public void execute() {
        FileSet fileSet;
        this.checkPreconditions();
        ArrayList<String> arrayList = new ArrayList<String>();
        Object object = this.filesets.iterator();
        while (object.hasNext()) {
            fileSet = (FileSet)object.next();
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
            String[] stringArray = directoryScanner.getIncludedFiles();
            File file = fileSet.getDir(this.getProject());
            String string = GettextUtils.getRelativePath(file, this.getLocation());
            this.log(string);
            for (int j = 0; j < stringArray.length; ++j) {
                arrayList.add(GettextUtils.createAbsolutePath(string, stringArray[j]));
            }
        }
        object = this.createListFile(arrayList);
        fileSet = new Commandline();
        fileSet.setExecutable(this.xgettextCommand);
        fileSet.createArgument().setValue("-c");
        fileSet.createArgument().setValue("--from-code=" + this.encoding);
        fileSet.createArgument().setValue("--output=" + new File(this.poDirectory, this.keysFile).getAbsolutePath());
        fileSet.createArgument().setValue("--language=Java");
        fileSet.createArgument().setLine(this.keywords);
        fileSet.createArgument().setValue("--files-from=" + ((File)object).getAbsolutePath());
        this.log("Executing: " + fileSet.toString());
        this.runCommandLineAndWait((Commandline)fileSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createListFile(List list) {
        try {
            File file = File.createTempFile("srcfiles", null);
            this.log(file.getAbsolutePath());
            file.deleteOnExit();
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            try {
                Iterator iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    String string = (String)iterator2.next();
                    bufferedWriter.write(string);
                    bufferedWriter.newLine();
                }
            }
            finally {
                bufferedWriter.close();
            }
            return file;
        }
        catch (IOException iOException) {
            this.log(iOException.getMessage());
            return null;
        }
    }
}

