/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.util;

import com.frostwire.jlibtorrent.Address;
import com.limegroup.gnutella.settings.ConnectionSettings;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.Random;

public final class NetworkUtils {
    private NetworkUtils() {
    }

    public static boolean isValidPort(int port, int minValidPort, int maxValidPort) {
        return port >= minValidPort && port <= maxValidPort;
    }

    public static byte[] getBytes(SocketAddress addr) throws UnknownHostException {
        InetSocketAddress iaddr = (InetSocketAddress)addr;
        if (iaddr.isUnresolved()) {
            throw new UnknownHostException(iaddr.toString());
        }
        return NetworkUtils.getBytes(iaddr.getAddress(), iaddr.getPort());
    }

    private static byte[] getBytes(InetAddress addr, int port) {
        if (!NetworkUtils.isValidPort(port, ConnectionSettings.PORT_RANGE_0.getDefaultValue(), ConnectionSettings.PORT_RANGE_1.getDefaultValue())) {
            throw new IllegalArgumentException("Port out of range: " + port);
        }
        byte[] address2 = addr.getAddress();
        byte[] dst = new byte[address2.length + 2];
        System.arraycopy(address2, 0, dst, 0, address2.length);
        dst[dst.length - 2] = (byte)(port >> 8 & 0xFF);
        dst[dst.length - 1] = (byte)(port & 0xFF);
        return dst;
    }

    public static int getPortInRange(boolean useManualRange, int defaultPort0, int defaultPort1, int manualPort0, int manualPort1) {
        int port0 = defaultPort0;
        int port1 = defaultPort1;
        if (useManualRange) {
            port0 = manualPort0;
            port1 = manualPort1;
        }
        int port = port0 + new Random().nextInt(port1 - port0 + 1);
        return port;
    }

    public static String getLibtorrentFormattedNetworkInterface(boolean useCustomNetworkInterface, String defaultInetAddress, String customInetAddress, int port) {
        Object iface = defaultInetAddress;
        if (useCustomNetworkInterface) {
            iface = customInetAddress;
        }
        if (((String)iface).equals("0.0.0.0")) {
            iface = "0.0.0.0:" + port + ",[::]:" + port;
        } else {
            if (((String)iface).contains(":")) {
                iface = "[" + (String)iface + "]";
            }
            iface = (String)iface + ":" + port;
        }
        return iface;
    }

    public static boolean isLinkLocal(Address address2) {
        String address_str = address2.toString();
        return "fe80::1%lo0".equals(address_str);
    }
}

