/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class LCS {
    public static String lcsHtml(String s1, String s2) {
        String rs1 = new StringBuffer(s1).reverse().toString();
        String rs2 = new StringBuffer(s2).reverse().toString();
        LcsString seq = new LcsString(rs1, rs2, true);
        return seq.getHtml();
    }

    protected static class LcsString
    extends LongestCommonSubsequence<Character> {
        private final boolean ignoreCase;
        private final String x;
        private final String y;

        LcsString(String from, String to, boolean ignoreCase) {
            this.x = from;
            this.y = to;
            this.ignoreCase = ignoreCase;
        }

        @Override
        protected int lengthOfY() {
            return this.y.length();
        }

        @Override
        protected int lengthOfX() {
            return this.x.length();
        }

        @Override
        protected Character valueOfX(int index) {
            return Character.valueOf(this.x.charAt(index));
        }

        @Override
        protected Character valueOfY(int index) {
            return Character.valueOf(this.y.charAt(index));
        }

        @Override
        protected boolean equals(Character x1, Character y1) {
            if (this.ignoreCase) {
                return null == x1 && null == y1 || x1 != null && y1 != null && Character.toLowerCase(x1.charValue()) == Character.toLowerCase(y1.charValue());
            }
            return super.equals(x1, y1);
        }

        private String getHtml() {
            LongestCommonSubsequence.DiffType type = null;
            List diffs = this.diff();
            Collections.reverse(diffs);
            StringBuilder buf = new StringBuilder();
            block6: for (LongestCommonSubsequence.DiffEntry entry2 : diffs) {
                if (type != entry2.getType()) {
                    if (type != null) {
                        int indx = buf.lastIndexOf("<b>");
                        if (buf.length() - indx > 6) {
                            buf.append("</b>");
                        } else {
                            buf.replace(indx, indx + 3, "");
                        }
                    }
                    switch (entry2.getType()) {
                        case REMOVE: 
                        case ADD: {
                            type = null;
                            break;
                        }
                        default: {
                            buf.append("<b>");
                            type = entry2.getType();
                        }
                    }
                }
                switch (entry2.getType()) {
                    case REMOVE: {
                        continue block6;
                    }
                }
                buf.append(this.escapeHtml((Character)entry2.getValue()));
            }
            if (type != null) {
                buf.append("<b>");
            }
            return "<html>" + String.valueOf(buf) + "</html>";
        }

        private String escapeHtml(Character ch) {
            return switch (ch.charValue()) {
                case '<' -> "&lt;";
                case '>' -> "&gt;";
                case '\"' -> "\\&quot;";
                default -> ch.toString();
            };
        }
    }

    public static abstract class LongestCommonSubsequence<VALUE> {
        private int[][] c;
        private ArrayList<DiffEntry<VALUE>> diff;

        LongestCommonSubsequence() {
        }

        protected abstract int lengthOfY();

        protected abstract int lengthOfX();

        protected abstract VALUE valueOfX(int var1);

        protected abstract VALUE valueOfY(int var1);

        boolean equals(VALUE x1, VALUE y1) {
            if (null == x1 && null == y1) {
                return true;
            }
            assert (x1 != null);
            return x1.equals(y1);
        }

        boolean isXYEqual(int i2, int j) {
            return this.equals(this.valueOfXInternal(i2), this.valueOfYInternal(j));
        }

        private VALUE valueOfXInternal(int i2) {
            return this.valueOfX(i2 - 1);
        }

        private VALUE valueOfYInternal(int j) {
            return this.valueOfY(j - 1);
        }

        void calculateLcs() {
            int i2;
            if (this.c != null) {
                return;
            }
            this.c = new int[this.lengthOfX() + 1][];
            for (i2 = 0; i2 < this.c.length; ++i2) {
                this.c[i2] = new int[this.lengthOfY() + 1];
            }
            for (i2 = 1; i2 < this.c.length; ++i2) {
                for (int j = 1; j < this.c[i2].length; ++j) {
                    this.c[i2][j] = this.isXYEqual(i2, j) ? this.c[i2 - 1][j - 1] + 1 : Math.max(this.c[i2][j - 1], this.c[i2 - 1][j]);
                }
            }
        }

        List<DiffEntry<VALUE>> diff() {
            this.calculateLcs();
            if (this.diff == null) {
                this.diff = new ArrayList();
                this.diff(this.lengthOfX(), this.lengthOfY());
            }
            return this.diff;
        }

        private void diff(int i2, int j) {
            this.calculateLcs();
            while (i2 != 0 || j != 0) {
                if (i2 > 0 && j > 0 && this.isXYEqual(i2, j)) {
                    this.diff.add(new DiffEntry<VALUE>(DiffType.NONE, this.valueOfYInternal(j)));
                    --i2;
                    --j;
                    continue;
                }
                if (j > 0 && (i2 == 0 || this.c[i2][j - 1] >= this.c[i2 - 1][j])) {
                    this.diff.add(new DiffEntry<VALUE>(DiffType.ADD, this.valueOfYInternal(j)));
                    --j;
                    continue;
                }
                if (i2 <= 0 || j != 0 && this.c[i2][j - 1] >= this.c[i2 - 1][j]) continue;
                this.diff.add(new DiffEntry<VALUE>(DiffType.REMOVE, this.valueOfXInternal(i2)));
                --i2;
            }
            Collections.reverse(this.diff);
        }

        public String toString() {
            int j;
            this.calculateLcs();
            StringBuilder buf = new StringBuilder();
            buf.append("  ");
            for (j = 1; j <= this.lengthOfY(); ++j) {
                buf.append(this.valueOfYInternal(j));
            }
            buf.append("\n");
            buf.append(" ");
            for (j = 0; j < this.c[0].length; ++j) {
                buf.append(this.c[0][j]);
            }
            buf.append("\n");
            for (int i2 = 1; i2 < this.c.length; ++i2) {
                buf.append(this.valueOfXInternal(i2));
                for (int j2 = 0; j2 < this.c[i2].length; ++j2) {
                    buf.append(this.c[i2][j2]);
                }
                buf.append("\n");
            }
            return buf.toString();
        }

        static class DiffEntry<VALUE> {
            private DiffType type;
            private VALUE value;

            DiffEntry(DiffType type, VALUE value) {
                this.type = type;
                this.value = value;
            }

            DiffType getType() {
                return this.type;
            }

            public void setType(DiffType type) {
                this.type = type;
            }

            VALUE getValue() {
                return this.value;
            }

            public void setValue(VALUE value) {
                this.value = value;
            }

            public String toString() {
                return this.type.toString() + this.value.toString();
            }
        }

        public static enum DiffType {
            ADD("+", "add"),
            REMOVE("-", "remove"),
            NONE(" ", "none");

            private final String val;
            private final String name;

            private DiffType(String val, String name) {
                this.val = val;
                this.name = name;
            }

            public String toString() {
                return this.val;
            }

            public String getName() {
                return this.name;
            }
        }
    }
}

