/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.util;

import com.frostwire.util.Logger;
import com.frostwire.util.OSUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedList;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.limewire.util.CommonUtils;
import org.limewire.util.SystemUtils;

public class FileUtils {
    private static final Logger LOG = Logger.getLogger(FileUtils.class);

    public static String getCanonicalPath(File f) throws IOException {
        try {
            return f.getCanonicalPath();
        }
        catch (IOException ioe) {
            String msg = ioe.getMessage();
            if (OSUtils.isWindows() && msg != null && msg.contains("There are no more files")) {
                return f.getAbsolutePath();
            }
            throw ioe;
        }
    }

    public static File getCanonicalFile(File f) throws IOException {
        try {
            return f.getCanonicalFile();
        }
        catch (IOException ioe) {
            String msg = ioe.getMessage();
            if (OSUtils.isWindows() && msg != null && msg.contains("There are no more files")) {
                return f.getAbsoluteFile();
            }
            throw ioe;
        }
    }

    public static boolean isAncestor(File a, File b) {
        while (b != null) {
            if (b.equals(a)) {
                return true;
            }
            b = b.getParentFile();
        }
        return false;
    }

    public static boolean isReallyInParentPath(File testParent, File testChild) throws IOException {
        String testParentName = FileUtils.getCanonicalPath(testParent);
        File testChildParentFile = testChild.getAbsoluteFile().getParentFile();
        if (testChildParentFile == null) {
            testChildParentFile = testChild.getAbsoluteFile();
        }
        String testChildParentName = FileUtils.getCanonicalPath(testChildParentFile);
        return testChildParentName.startsWith(testParentName);
    }

    public static boolean setWriteable(File f) {
        String fName;
        if (!f.exists()) {
            return true;
        }
        if (f.canWrite()) {
            if (OSUtils.isWindows()) {
                return true;
            }
            if (!f.isDirectory()) {
                return true;
            }
        }
        try {
            fName = f.getCanonicalPath();
        }
        catch (IOException ioe) {
            fName = f.getPath();
        }
        String[] cmds = null;
        if (OSUtils.isWindows() || OSUtils.isMacOSX()) {
            SystemUtils.setWriteable(fName);
        } else if (!OSUtils.isOS2()) {
            cmds = f.isDirectory() ? new String[]{"chmod", "u+w+x", fName} : new String[]{"chmod", "u+w", fName};
        }
        if (cmds != null) {
            try {
                Process p = Runtime.getRuntime().exec(cmds);
                p.waitFor();
            }
            catch (IOException | InterruptedException | SecurityException exception) {
                // empty catch block
            }
        }
        return f.canWrite();
    }

    public static File[] getFilesRecursive(File directory, String[] filter) {
        ArrayList<File> dirs = new ArrayList<File>();
        ArrayList<File> retFileArray = new ArrayList<File>();
        File[] retArray = new File[]{};
        if (directory.exists() && directory.isDirectory()) {
            dirs.add(directory);
        }
        while (dirs.size() > 0) {
            File currDir = (File)dirs.remove(0);
            String[] listedFiles = currDir.list();
            for (int i2 = 0; listedFiles != null && i2 < listedFiles.length; ++i2) {
                File currFile = new File(currDir, listedFiles[i2]);
                if (currFile.isDirectory()) {
                    dirs.add(currFile);
                    continue;
                }
                if (!currFile.isFile()) continue;
                boolean shouldAdd = false;
                if (filter == null) {
                    shouldAdd = true;
                } else {
                    String ext = FilenameUtils.getExtension(currFile.getName());
                    for (int j = 0; j < filter.length && ext != null; ++j) {
                        if (!ext.equalsIgnoreCase(filter[j])) continue;
                        shouldAdd = true;
                        break;
                    }
                }
                if (!shouldAdd) continue;
                retFileArray.add(currFile);
            }
        }
        if (!retFileArray.isEmpty()) {
            retArray = new File[retFileArray.size()];
            for (int i3 = 0; i3 < retArray.length; ++i3) {
                retArray[i3] = (File)retFileArray.get(i3);
            }
        }
        return retArray;
    }

    public static boolean delete(File file, boolean moveToTrash) {
        if (!file.exists()) {
            return false;
        }
        if (moveToTrash) {
            if (OSUtils.isMacOSX()) {
                return FileUtils.moveToTrashOSX(file);
            }
            if (OSUtils.isWindows()) {
                return SystemUtils.recycle(file);
            }
            throw new IllegalArgumentException("OS does not support trash");
        }
        return FileUtils.deleteRecursive(file);
    }

    private static boolean moveToTrashOSX(File file) {
        try {
            String[] command = FileUtils.moveToTrashCommand(file);
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.redirectErrorStream();
            Process process = builder.start();
            FileUtils.consumeAllInput(process);
            process.waitFor();
        }
        catch (InterruptedException err) {
            LOG.error("InterruptedException", err);
        }
        catch (IOException err) {
            LOG.error("IOException", err);
        }
        return !file.exists();
    }

    private static void consumeAllInput(Process p) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(p.getInputStream());){
            byte[] buf = new byte[1024];
            while (((InputStream)in).read(buf, 0, buf.length) >= 0) {
            }
        }
    }

    private static String[] moveToTrashCommand(File file) {
        String path = null;
        try {
            path = file.getCanonicalPath();
        }
        catch (IOException err) {
            LOG.error("IOException", err);
            path = file.getAbsolutePath();
        }
        String fileOrFolder = file.isFile() ? "file" : "folder";
        return new String[]{"osascript", "-e", "set unixPath to \"" + path + "\"", "-e", "set hfsPath to POSIX file unixPath", "-e", "tell application \"Finder\"", "-e", "if " + fileOrFolder + " hfsPath exists then", "-e", "move " + fileOrFolder + " hfsPath to trash", "-e", "end if", "-e", "end tell"};
    }

    private static boolean deleteRecursive(File directory) {
        File[] files;
        String canonicalParent;
        try {
            canonicalParent = FileUtils.getCanonicalPath(directory);
        }
        catch (IOException ioe) {
            return false;
        }
        if (!directory.isDirectory()) {
            return directory.delete();
        }
        for (File file : files = directory.listFiles()) {
            try {
                if (!FileUtils.getCanonicalPath(file).startsWith(canonicalParent)) {
                    continue;
                }
            }
            catch (IOException ioe) {
                return false;
            }
            if (FileUtils.deleteRecursive(file)) continue;
            return false;
        }
        return directory.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static long copy(File src, long amount, File dst) {
        long amountToRead;
        int BUFFER_SIZE = 1024;
        BufferedInputStream in = null;
        OutputStream out = null;
        try {
            int read;
            in = new BufferedInputStream(new FileInputStream(src));
            out = new BufferedOutputStream(new FileOutputStream(dst));
            byte[] buf = new byte[1024];
            for (amountToRead = amount; amountToRead > 0L && (read = ((InputStream)in).read(buf, 0, (int)Math.min(1024L, amountToRead))) != -1; amountToRead -= (long)read) {
                out.write(buf, 0, read);
            }
        }
        catch (IOException iOException) {
            IOUtils.closeQuietly(in);
            if (out != null) {
                try {
                    out.flush();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
            }
            IOUtils.closeQuietly(out);
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                if (out != null) {
                    try {
                        out.flush();
                    }
                    catch (IOException iOException3) {
                        // empty catch block
                    }
                }
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(in);
        if (out != null) {
            try {
                out.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        IOUtils.closeQuietly(out);
        return amount - amountToRead;
    }

    public static boolean copy(File src, File dst) {
        long length = src.length();
        return FileUtils.copy(src, (int)length, dst) == length;
    }

    public static File getJarFromClasspath(ClassLoader classLoader, String markerFile) {
        String url;
        if (classLoader == null) {
            throw new IllegalArgumentException();
        }
        URL messagesURL = classLoader.getResource(markerFile);
        if (messagesURL != null && (url = CommonUtils.decode(messagesURL.toExternalForm())) != null && url.startsWith("jar:file:")) {
            url = url.substring("jar:file:".length());
            url = url.substring(0, url.length() - markerFile.length() - "!/".length());
            return new File(url);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File[] listFiles(File directoryFile) {
        LinkedList<File> files = new LinkedList<File>();
        DirectoryStream<Path> dir = null;
        try {
            dir = Files.newDirectoryStream(directoryFile.toPath());
            for (Path child : dir) {
                files.add(child.toFile());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (dir != null) {
                IOUtils.closeQuietly(dir);
            }
        }
        return files.toArray(new File[0]);
    }

    public static boolean hasExtension(String filename, String ... extensionsWithoutDot) {
        String extension = FilenameUtils.getExtension(filename).toLowerCase();
        for (String ext : extensionsWithoutDot) {
            if (!ext.equalsIgnoreCase(extension)) continue;
            return true;
        }
        return false;
    }

    public static File buildFile(File savePath, String name) {
        String baseName = FilenameUtils.getBaseName(name);
        String ext = FilenameUtils.getExtension(name);
        File f = new File(savePath, name);
        for (int i2 = 1; f.exists() && i2 < Integer.MAX_VALUE; ++i2) {
            f = new File(savePath, baseName + " (" + i2 + ")." + ext);
        }
        return f;
    }
}

