/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.setting;

import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.limewire.setting.AbstractSetting;
import org.limewire.setting.BooleanSetting;
import org.limewire.setting.BooleanSettingImpl;
import org.limewire.setting.ByteSetting;
import org.limewire.setting.CharArraySetting;
import org.limewire.setting.ColorSetting;
import org.limewire.setting.FileArraySetting;
import org.limewire.setting.FileSetSetting;
import org.limewire.setting.FileSetting;
import org.limewire.setting.FloatSetting;
import org.limewire.setting.FontNameSetting;
import org.limewire.setting.IntSetting;
import org.limewire.setting.LongSetting;
import org.limewire.setting.Setting;
import org.limewire.setting.StringArraySetting;
import org.limewire.setting.StringSetSetting;
import org.limewire.setting.StringSetting;
import org.limewire.util.FileUtils;

public final class SettingsFactory
implements Iterable<AbstractSetting> {
    private static final long EXPIRY_INTERVAL = 1209600000L;
    private static boolean loadSaveFailureEncountered = false;
    private final String HEADING;
    private final Properties DEFAULT_PROPS = new Properties();
    private final Properties PROPS = new Properties(this.DEFAULT_PROPS);
    private LongSetting LAST_EXPIRE_TIME = null;
    private final File SETTINGS_FILE;
    private final ArrayList<AbstractSetting> settings = new ArrayList(10);
    private boolean expired = false;

    public SettingsFactory(File settingsFile, String heading) {
        this.SETTINGS_FILE = settingsFile;
        if (this.SETTINGS_FILE.isDirectory()) {
            this.SETTINGS_FILE.delete();
        }
        this.HEADING = heading;
        this.reload();
    }

    public static boolean hasLoadSaveFailure() {
        return loadSaveFailureEncountered;
    }

    private static void markFailure() {
        loadSaveFailureEncountered = true;
    }

    public static void resetLoadSaveFailure() {
        loadSaveFailureEncountered = false;
    }

    @Override
    public synchronized Iterator<AbstractSetting> iterator() {
        return this.settings.iterator();
    }

    public synchronized void reload() {
        if (!this.SETTINGS_FILE.isFile()) {
            this.setExpireValue();
            return;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.SETTINGS_FILE);
            try {
                this.PROPS.load(fis);
            }
            catch (IllegalArgumentException | StringIndexOutOfBoundsException runtimeException) {
            }
            catch (IOException e) {
                SettingsFactory.markFailure();
            }
        }
        catch (FileNotFoundException e) {
            block9: {
                try {
                    if (!this.SETTINGS_FILE.exists()) break block9;
                    SettingsFactory.markFailure();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fis);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly(fis);
        }
        IOUtils.closeQuietly(fis);
        for (Setting setting : this.settings) {
            setting.reload();
        }
        this.setExpireValue();
    }

    private synchronized void setExpireValue() {
        if (this.LAST_EXPIRE_TIME == null) {
            this.LAST_EXPIRE_TIME = this.createLongSetting("LAST_EXPIRE_TIME", 0L);
            boolean bl = this.expired = this.LAST_EXPIRE_TIME.getValue() + 1209600000L < System.currentTimeMillis();
            if (this.expired) {
                this.LAST_EXPIRE_TIME.setValue(System.currentTimeMillis());
            }
        }
    }

    public synchronized boolean revertToDefault() {
        boolean any = false;
        for (Setting setting : this.settings) {
            any |= setting.revertToDefault();
        }
        return any;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void save() {
        Properties toSave = (Properties)this.PROPS.clone();
        for (Setting setting : this.settings) {
            if (setting.shouldAlwaysSave() || !setting.isDefault()) continue;
            toSave.remove(setting.getKey());
        }
        BufferedOutputStream out = null;
        try {
            block13: {
                File file;
                if (this.SETTINGS_FILE.isDirectory()) {
                    this.SETTINGS_FILE.delete();
                }
                if ((file = this.SETTINGS_FILE.getParentFile()) != null) {
                    file.mkdirs();
                }
                FileUtils.setWriteable(this.SETTINGS_FILE);
                if (this.SETTINGS_FILE.exists() && !this.SETTINGS_FILE.canRead()) {
                    this.SETTINGS_FILE.delete();
                }
                try {
                    out = new BufferedOutputStream(new FileOutputStream(this.SETTINGS_FILE));
                }
                catch (IOException ioe) {
                    if (!this.SETTINGS_FILE.exists()) break block13;
                    this.SETTINGS_FILE.delete();
                    out = new BufferedOutputStream(new FileOutputStream(this.SETTINGS_FILE));
                }
            }
            if (out != null) {
                toSave.store(out, this.HEADING);
            } else {
                SettingsFactory.markFailure();
            }
            IOUtils.closeQuietly(out);
        }
        catch (IOException iOException) {
            SettingsFactory.markFailure();
        }
        finally {
            IOUtils.closeQuietly(out);
        }
    }

    public String toString() {
        return this.PROPS.toString();
    }

    public Properties getProperties() {
        return this.PROPS;
    }

    public synchronized StringSetting createStringSetting(String key, String defaultValue) {
        StringSetting result = new StringSetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue);
        this.handleSettingInternal(result);
        return result;
    }

    public synchronized BooleanSetting createBooleanSetting(String key, boolean defaultValue) {
        BooleanSettingImpl result = new BooleanSettingImpl(this.DEFAULT_PROPS, this.PROPS, key, defaultValue);
        this.handleSettingInternal(result);
        return result;
    }

    public synchronized IntSetting createIntSetting(String key, int defaultValue) {
        IntSetting result = new IntSetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue);
        this.handleSettingInternal(result);
        return result;
    }

    synchronized ByteSetting createByteSetting(String key, byte defaultValue) {
        ByteSetting result = new ByteSetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue);
        this.handleSettingInternal(result);
        return result;
    }

    public synchronized LongSetting createLongSetting(String key, long defaultValue) {
        LongSetting result = new LongSetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue);
        this.handleSettingInternal(result);
        return result;
    }

    public synchronized FileSetting createFileSetting(String key, File defaultValue) {
        File parent;
        String parentString = defaultValue.getParent();
        if (parentString != null && !(parent = new File(parentString)).isDirectory()) {
            parent.mkdirs();
        }
        FileSetting result = new FileSetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue);
        this.handleSettingInternal(result);
        return result;
    }

    synchronized ColorSetting createColorSetting(String key, Color defaultValue) {
        ColorSetting result = ColorSetting.createColorSetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue);
        this.handleSettingInternal(result);
        return result;
    }

    public synchronized CharArraySetting createCharArraySetting(String key, char[] defaultValue) {
        CharArraySetting result = new CharArraySetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue);
        this.handleSettingInternal(result);
        return result;
    }

    public synchronized FloatSetting createFloatSetting(String key, float defaultValue) {
        FloatSetting result = new FloatSetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue);
        this.handleSettingInternal(result);
        return result;
    }

    public synchronized StringArraySetting createStringArraySetting(String key, String[] defaultValue) {
        StringArraySetting result = new StringArraySetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue);
        this.handleSettingInternal(result);
        return result;
    }

    synchronized StringSetSetting createStringSetSetting(String key, String defaultValue) {
        StringSetSetting result = new StringSetSetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue);
        this.handleSettingInternal(result);
        return result;
    }

    synchronized FileArraySetting createFileArraySetting(String key, File[] defaultValue) {
        FileArraySetting result = new FileArraySetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue);
        this.handleSettingInternal(result);
        return result;
    }

    public synchronized FileSetSetting createFileSetSetting(String key, File[] defaultValue) {
        FileSetSetting result = new FileSetSetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue);
        this.handleSettingInternal(result);
        return result;
    }

    public synchronized IntSetting createExpirableIntSetting(String key, int defaultValue) {
        IntSetting result = this.createIntSetting(key, defaultValue);
        if (this.expired) {
            result.revertToDefault();
        }
        return result;
    }

    synchronized FontNameSetting createFontNameSetting(String key, String defaultValue) {
        FontNameSetting result = new FontNameSetting(this.DEFAULT_PROPS, this.PROPS, key, defaultValue);
        this.handleSettingInternal(result);
        return result;
    }

    private synchronized void handleSettingInternal(AbstractSetting setting) {
        this.settings.add(setting);
        setting.reload();
    }
}

