/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.setting;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.limewire.setting.AbstractSetting;

public class FileSetSetting
extends AbstractSetting {
    private Set<File> value;

    FileSetSetting(Properties defaultProps, Properties props, String key, File[] defaultValue) {
        super(defaultProps, props, key, FileSetSetting.decode(new HashSet<File>(Arrays.asList(defaultValue))));
        this.setPrivate(true);
    }

    private static Set<File> encode(String src) {
        if (src == null || src.length() == 0) {
            return new HashSet<File>();
        }
        StringTokenizer tokenizer = new StringTokenizer(src, ";");
        int size = tokenizer.countTokens();
        HashSet<File> set = new HashSet<File>();
        for (int i2 = 0; i2 < size; ++i2) {
            set.add(new File(tokenizer.nextToken()));
        }
        return set;
    }

    private static String decode(Set<? extends File> src) {
        if (src == null || src.isEmpty()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        for (File file : src) {
            buffer.append(file.getAbsolutePath()).append(';');
        }
        if (buffer.length() > 0) {
            buffer.setLength(buffer.length() - 1);
        }
        return buffer.toString();
    }

    public Set<File> getValue() {
        return this.value;
    }

    public void setValue(Set<? extends File> value) {
        this.setValueInternal(FileSetSetting.decode(value));
    }

    public synchronized void add(File file) {
        this.value.add(file);
        this.setValue(this.value);
    }

    public synchronized boolean remove(File file) {
        if (this.value.remove(file)) {
            this.setValue(this.value);
            return true;
        }
        return false;
    }

    public synchronized void removeAll() {
        this.value.clear();
        this.setValue(this.value);
    }

    public synchronized boolean contains(File file) {
        return this.value.contains(file);
    }

    @Override
    protected synchronized void loadValue(String sValue) {
        this.value = FileSetSetting.encode(sValue);
    }
}

