/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.setting;

import java.awt.Color;
import java.util.Properties;
import org.limewire.setting.AbstractSetting;

public final class ColorSetting
extends AbstractSetting {
    private Color value;

    private ColorSetting(Properties defaultProps, Properties props, String key, String value) {
        super(defaultProps, props, key, value);
    }

    static ColorSetting createColorSetting(Properties defaultProps, Properties props, String key, Color defaultColor) {
        return new ColorSetting(defaultProps, props, key, ColorSetting.formatColor(defaultColor));
    }

    private static String formatColor(Color color) {
        Object red = Integer.toHexString(color.getRed());
        Object green = Integer.toHexString(color.getGreen());
        Object blue = Integer.toHexString(color.getBlue());
        if (((String)red).length() == 1) {
            red = "0" + (String)red;
        }
        if (((String)green).length() == 1) {
            green = "0" + (String)green;
        }
        if (((String)blue).length() == 1) {
            blue = "0" + (String)blue;
        }
        return "#" + (String)red + (String)green + (String)blue;
    }

    public Color getValue() {
        return this.value;
    }

    public void setValue(Color value) {
        this.setValueInternal(ColorSetting.formatColor(value));
        this.value = value;
    }

    @Override
    protected void loadValue(String sValue) {
        sValue = sValue.trim();
        try {
            int r = Integer.parseInt(sValue.substring(1, 3), 16);
            int g = Integer.parseInt(sValue.substring(3, 5), 16);
            int b = Integer.parseInt(sValue.substring(5, 7), 16);
            this.value = new Color(r, g, b);
        }
        catch (NumberFormatException | StringIndexOutOfBoundsException nfe) {
            this.revertToDefault();
        }
    }
}

