/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.limewire.collection.TrieEdge;
import org.limewire.collection.UnmodifiableIterator;

final class TrieNode<E> {
    private E value = null;
    private final ArrayList<TrieEdge<E>> children = new ArrayList(0);

    public TrieNode() {
    }

    public TrieNode(E value) {
        this.value = value;
    }

    public E getValue() {
        return this.value;
    }

    public void setValue(E value) {
        this.value = value;
    }

    private TrieEdge<E> get(int i2) {
        return this.children.get(i2);
    }

    private int search(char c, boolean exact) {
        int low = 0;
        int high = this.children.size() - 1;
        while (low <= high) {
            int middle = (low + high) / 2;
            char cmiddle = this.get(middle).getLabelStart();
            if (cmiddle < c) {
                low = middle + 1;
                continue;
            }
            if (c < cmiddle) {
                high = middle - 1;
                continue;
            }
            return middle;
        }
        if (exact) {
            return -1;
        }
        return high;
    }

    public TrieEdge<E> get(char labelStart) {
        int i2 = this.search(labelStart, true);
        if (i2 < 0) {
            return null;
        }
        TrieEdge<E> ret = this.get(i2);
        assert (ret.getLabelStart() == labelStart);
        return ret;
    }

    public void put(String label, TrieNode<E> child) {
        char labelStart;
        int i2 = 0;
        assert ((i2 = this.search(labelStart = label.charAt(0), false)) < 0 || this.get(i2).getLabelStart() != labelStart) : "Precondition of TrieNode.put violated.";
        try {
            this.children.add(i2 + 1, new TrieEdge<E>(label, child));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean remove(char labelStart) {
        int i2 = this.search(labelStart, true);
        if (i2 < 0) {
            return false;
        }
        assert (this.get(i2).getLabelStart() == labelStart);
        this.children.remove(i2);
        return true;
    }

    public void trim() {
        this.children.trimToSize();
    }

    public Iterator<TrieNode<E>> childrenForward() {
        return new ChildrenForwardIterator();
    }

    public Iterator<String> labelsForward() {
        return new LabelForwardIterator();
    }

    public String toString() {
        E val = this.getValue();
        if (val != null) {
            return val.toString();
        }
        return "NULL";
    }

    private class ChildrenForwardIterator
    extends UnmodifiableIterator<TrieNode<E>> {
        int i = 0;

        private ChildrenForwardIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.i < TrieNode.this.children.size();
        }

        @Override
        public TrieNode<E> next() {
            if (this.i < TrieNode.this.children.size()) {
                return TrieNode.this.get(this.i++).getChild();
            }
            throw new NoSuchElementException();
        }
    }

    private class LabelForwardIterator
    extends UnmodifiableIterator<String> {
        int i = 0;

        private LabelForwardIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.i < TrieNode.this.children.size();
        }

        @Override
        public String next() {
            if (this.i < TrieNode.this.children.size()) {
                return TrieNode.this.get(this.i++).getLabel();
            }
            throw new NoSuchElementException();
        }
    }
}

