/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import org.limewire.collection.EmptyIterator;
import org.limewire.collection.Trie;

public class PatriciaTrie<K, V>
extends AbstractMap<K, V>
implements Trie<K, V>,
Serializable {
    private static final long serialVersionUID = 110232526181493307L;
    private final TrieEntry<K, V> root = new TrieEntry<Object, Object>(null, null, -1);
    private final KeyAnalyzer<? super K> keyAnalyzer;
    private int size = 0;
    private transient int modCount = 0;
    private volatile transient Set<K> keySet = null;
    private volatile transient Collection<V> values = null;
    private volatile transient Set<Map.Entry<K, V>> entrySet = null;

    public PatriciaTrie(KeyAnalyzer<? super K> keyAnalyzer) {
        this.keyAnalyzer = keyAnalyzer;
    }

    private static boolean isValidBitIndex(int bitIndex) {
        return 0 <= bitIndex && bitIndex <= Integer.MAX_VALUE;
    }

    private static boolean isNullBitKey(int bitIndex) {
        return bitIndex == -1;
    }

    private static boolean isEqualBitKey(int bitIndex) {
        return bitIndex == -2;
    }

    private static boolean valEquals(Object o1, Object o2) {
        return Objects.equals(o1, o2);
    }

    public KeyAnalyzer<? super K> getKeyAnalyzer() {
        return this.keyAnalyzer;
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.keyAnalyzer;
    }

    @Override
    public void clear() {
        this.root.key = null;
        this.root.bitIndex = -1;
        this.root.value = null;
        this.root.parent = null;
        this.root.left = this.root;
        this.root.right = null;
        this.root.predecessor = this.root;
        this.size = 0;
        this.incrementModCount();
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    private void incrementSize() {
        ++this.size;
        this.incrementModCount();
    }

    private void decrementSize() {
        --this.size;
        this.incrementModCount();
    }

    private void incrementModCount() {
        ++this.modCount;
    }

    @Override
    public V put(K key, V value) {
        if (key == null) {
            throw new NullPointerException("Key cannot be null");
        }
        int keyLength = this.length(key);
        if (keyLength == 0) {
            if (this.root.isEmpty()) {
                this.incrementSize();
            } else {
                this.incrementModCount();
            }
            return this.root.setKeyValue(key, value);
        }
        TrieEntry<K, V> found = this.getNearestEntryForKey(key, keyLength);
        if (key.equals(found.key)) {
            if (found.isEmpty()) {
                this.incrementSize();
            } else {
                this.incrementModCount();
            }
            return found.setKeyValue(key, value);
        }
        int bitIndex = this.bitIndex(key, found.key);
        if (PatriciaTrie.isValidBitIndex(bitIndex)) {
            TrieEntry<K, V> t = new TrieEntry<K, V>(key, value, bitIndex);
            this.addEntry(t, keyLength);
            this.incrementSize();
            return null;
        }
        if (PatriciaTrie.isNullBitKey(bitIndex)) {
            if (this.root.isEmpty()) {
                this.incrementSize();
            } else {
                this.incrementModCount();
            }
            return this.root.setKeyValue(key, value);
        }
        if (PatriciaTrie.isEqualBitKey(bitIndex) && found != this.root) {
            this.incrementModCount();
            return found.setKeyValue(key, value);
        }
        throw new IndexOutOfBoundsException("Failed to put: " + String.valueOf(key) + " -> " + String.valueOf(value) + ", " + bitIndex);
    }

    private TrieEntry<K, V> addEntry(TrieEntry<K, V> toAdd, int keyLength) {
        TrieEntry current = this.root.left;
        TrieEntry<K, V> path = this.root;
        while (true) {
            if (current.bitIndex >= toAdd.bitIndex || current.bitIndex <= path.bitIndex) {
                toAdd.predecessor = toAdd;
                if (!this.isBitSet(toAdd.key, keyLength, toAdd.bitIndex)) {
                    toAdd.left = toAdd;
                    toAdd.right = current;
                } else {
                    toAdd.left = current;
                    toAdd.right = toAdd;
                }
                toAdd.parent = path;
                if (current.bitIndex >= toAdd.bitIndex) {
                    current.parent = toAdd;
                }
                if (current.bitIndex <= path.bitIndex) {
                    current.predecessor = toAdd;
                }
                if (path == this.root || !this.isBitSet(toAdd.key, keyLength, path.bitIndex)) {
                    path.left = toAdd;
                } else {
                    path.right = toAdd;
                }
                return toAdd;
            }
            path = current;
            if (!this.isBitSet(toAdd.key, keyLength, current.bitIndex)) {
                current = current.left;
                continue;
            }
            current = current.right;
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    @Override
    public V get(Object k) {
        TrieEntry<K, V> entry2 = this.getEntry(k);
        return entry2 != null ? (V)entry2.getValue() : null;
    }

    private TrieEntry<K, V> getEntry(Object k) {
        K key = this.asKey(k);
        if (key == null) {
            return null;
        }
        int keyLength = this.length(key);
        TrieEntry<K, V> entry2 = this.getNearestEntryForKey(key, keyLength);
        return !entry2.isEmpty() && key.equals(entry2.key) ? entry2 : null;
    }

    private K asKey(Object key) {
        try {
            return (K)key;
        }
        catch (ClassCastException cce) {
            return null;
        }
    }

    private TrieEntry<K, V> getNearestEntryForKey(K key, int keyLength) {
        TrieEntry current = this.root.left;
        TrieEntry<K, V> path = this.root;
        while (current.bitIndex > path.bitIndex) {
            path = current;
            if (!this.isBitSet(key, keyLength, current.bitIndex)) {
                current = current.left;
                continue;
            }
            current = current.right;
        }
        return current;
    }

    @Override
    public V select(K key) {
        TrieEntry[] result;
        int keyLength = this.length(key);
        if (!this.selectR(this.root.left, -1, key, keyLength, result = new TrieEntry[1])) {
            TrieEntry e = result[0];
            return e.getValue();
        }
        return null;
    }

    private boolean selectR(TrieEntry<K, V> h, int bitIndex, K key, int keyLength, TrieEntry<?, ?>[] result) {
        if (h.bitIndex <= bitIndex) {
            if (!h.isEmpty()) {
                result[0] = h;
                return false;
            }
            return true;
        }
        if (!this.isBitSet(key, keyLength, h.bitIndex)) {
            if (this.selectR(h.left, h.bitIndex, key, keyLength, result)) {
                return this.selectR(h.right, h.bitIndex, key, keyLength, result);
            }
        } else if (this.selectR(h.right, h.bitIndex, key, keyLength, result)) {
            return this.selectR(h.left, h.bitIndex, key, keyLength, result);
        }
        return false;
    }

    @Override
    public Map.Entry<K, V> select(K key, Trie.Cursor<? super K, ? super V> cursor) {
        int keyLength = this.length(key);
        TrieEntry[] result = new TrieEntry[]{null};
        this.selectR(this.root.left, -1, key, keyLength, cursor, result);
        return result[0];
    }

    private boolean selectR(TrieEntry<K, V> h, int bitIndex, K key, int keyLength, Trie.Cursor<? super K, ? super V> cursor, TrieEntry<?, ?>[] result) {
        if (h.bitIndex <= bitIndex) {
            if (!h.isEmpty()) {
                Trie.Cursor.SelectStatus ret = cursor.select(h);
                switch (ret) {
                    case REMOVE: {
                        throw new UnsupportedOperationException("cannot remove during select");
                    }
                    case EXIT: {
                        result[0] = h;
                        return false;
                    }
                    case REMOVE_AND_EXIT: {
                        TrieEntry<K, V> entry2 = new TrieEntry<K, V>(h.getKey(), h.getValue(), -1);
                        result[0] = entry2;
                        this.removeEntry(h);
                        return false;
                    }
                }
            }
            return true;
        }
        if (!this.isBitSet(key, keyLength, h.bitIndex)) {
            if (this.selectR(h.left, h.bitIndex, key, keyLength, cursor, result)) {
                return this.selectR(h.right, h.bitIndex, key, keyLength, cursor, result);
            }
        } else if (this.selectR(h.right, h.bitIndex, key, keyLength, cursor, result)) {
            return this.selectR(h.left, h.bitIndex, key, keyLength, cursor, result);
        }
        return false;
    }

    @Override
    public SortedMap<K, V> getPrefixedBy(K key) {
        return this.getPrefixedByBits(key, 0, this.keyAnalyzer.length(key));
    }

    @Override
    public SortedMap<K, V> getPrefixedBy(K key, int length) {
        return this.getPrefixedByBits(key, 0, length * this.keyAnalyzer.bitsPerElement());
    }

    @Override
    public SortedMap<K, V> getPrefixedBy(K key, int offset, int length) {
        return this.getPrefixedByBits(key, offset * this.keyAnalyzer.bitsPerElement(), length * this.keyAnalyzer.bitsPerElement());
    }

    @Override
    public SortedMap<K, V> getPrefixedByBits(K key, int bitLength) {
        return this.getPrefixedByBits(key, 0, bitLength);
    }

    private SortedMap<K, V> getPrefixedByBits(K key, int offset, int length) {
        int offsetLength = offset + length;
        if (offsetLength > this.length(key)) {
            throw new IllegalArgumentException(offset + " + " + length + " > " + this.length(key));
        }
        if (offsetLength == 0) {
            return this;
        }
        return new PrefixSubMap(key, offset, length);
    }

    @Override
    public boolean containsKey(Object k) {
        K key = this.asKey(k);
        if (key == null) {
            return false;
        }
        int keyLength = this.length(key);
        TrieEntry<K, V> entry2 = this.getNearestEntryForKey(key, keyLength);
        return !entry2.isEmpty() && key.equals(entry2.key);
    }

    @Override
    public boolean containsValue(Object o) {
        for (V v : this.values()) {
            if (!PatriciaTrie.valEquals(v, o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V remove(Object k) {
        K key = this.asKey(k);
        if (key == null) {
            return null;
        }
        int keyLength = this.length(key);
        TrieEntry current = this.root.left;
        TrieEntry<K, V> path = this.root;
        while (true) {
            if (current.bitIndex <= path.bitIndex) {
                if (!current.isEmpty() && key.equals(current.key)) {
                    return this.removeEntry(current);
                }
                return null;
            }
            path = current;
            if (!this.isBitSet(key, keyLength, current.bitIndex)) {
                current = current.left;
                continue;
            }
            current = current.right;
        }
    }

    private V removeEntry(TrieEntry<K, V> h) {
        if (h != this.root) {
            if (h.isInternalNode()) {
                this.removeInternalEntry(h);
            } else {
                this.removeExternalEntry(h);
            }
        }
        this.decrementSize();
        return h.setKeyValue(null, null);
    }

    private void removeExternalEntry(TrieEntry<K, V> h) {
        TrieEntry child;
        if (h == this.root) {
            throw new IllegalArgumentException("Cannot delete root Entry!");
        }
        if (!h.isExternalNode()) {
            throw new IllegalArgumentException(String.valueOf(h) + " is not an external Entry!");
        }
        TrieEntry parent = h.parent;
        TrieEntry trieEntry = child = h.left == h ? h.right : h.left;
        if (parent.left == h) {
            parent.left = child;
        } else {
            parent.right = child;
        }
        if (child.bitIndex > parent.bitIndex) {
            child.parent = parent;
        } else {
            child.predecessor = parent;
        }
    }

    private void removeInternalEntry(TrieEntry<K, V> h) {
        TrieEntry child;
        if (h == this.root) {
            throw new IllegalArgumentException("Cannot delete root Entry!");
        }
        if (!h.isInternalNode()) {
            throw new IllegalArgumentException(String.valueOf(h) + " is not an internal Entry!");
        }
        TrieEntry p = h.predecessor;
        p.bitIndex = h.bitIndex;
        TrieEntry parent = p.parent;
        TrieEntry trieEntry = child = p.left == h ? p.right : p.left;
        if (p.predecessor == p && p.parent != h) {
            p.predecessor = p.parent;
        }
        if (parent.left == p) {
            parent.left = child;
        } else {
            parent.right = child;
        }
        if (child.bitIndex > parent.bitIndex) {
            child.parent = parent;
        }
        if (h.left.parent == h) {
            h.left.parent = p;
        }
        if (h.right.parent == h) {
            h.right.parent = p;
        }
        if (h.parent.left == h) {
            h.parent.left = p;
        } else {
            h.parent.right = p;
        }
        p.parent = h.parent;
        p.left = h.left;
        p.right = h.right;
        if (this.isValidUplink(p.left, p)) {
            p.left.predecessor = p;
        }
        if (this.isValidUplink(p.right, p)) {
            p.right.predecessor = p;
        }
    }

    private TrieEntry<K, V> previousEntry(TrieEntry<K, V> start) {
        if (start.predecessor == null) {
            throw new IllegalArgumentException("must have come from somewhere!");
        }
        if (start.predecessor.right == start) {
            if (this.isValidUplink(start.predecessor.left, start.predecessor)) {
                return start.predecessor.left;
            }
            return this.followRight(start.predecessor.left);
        }
        TrieEntry node = start.predecessor;
        while (node.parent != null && node == node.parent.left) {
            node = node.parent;
        }
        if (node.parent == null) {
            return null;
        }
        if (this.isValidUplink(node.parent.left, node.parent)) {
            if (node.parent.left == this.root) {
                if (this.root.isEmpty()) {
                    return null;
                }
                return this.root;
            }
            return node.parent.left;
        }
        return this.followRight(node.parent.left);
    }

    private TrieEntry<K, V> nextEntry(TrieEntry<K, V> node) {
        if (node == null) {
            return this.firstEntry();
        }
        return this.nextEntryImpl(node.predecessor, node, null);
    }

    private TrieEntry<K, V> nextEntryInSubtree(TrieEntry<K, V> node, TrieEntry<K, V> parentOfSubtree) {
        if (node == null) {
            return this.firstEntry();
        }
        return this.nextEntryImpl(node.predecessor, node, parentOfSubtree);
    }

    private TrieEntry<K, V> nextEntryImpl(TrieEntry<K, V> start, TrieEntry<K, V> previous, TrieEntry<K, V> tree) {
        TrieEntry<K, V> current = start;
        if (previous == null || start != previous.predecessor) {
            while (!current.left.isEmpty() && previous != current.left) {
                if (this.isValidUplink(current.left, current)) {
                    return current.left;
                }
                current = current.left;
            }
        }
        if (current.isEmpty()) {
            return null;
        }
        if (current.right == null) {
            return null;
        }
        if (previous != current.right) {
            if (this.isValidUplink(current.right, current)) {
                return current.right;
            }
            return this.nextEntryImpl(current.right, previous, tree);
        }
        while (current == current.parent.right) {
            if (current == tree) {
                return null;
            }
            current = current.parent;
        }
        if (current == tree) {
            return null;
        }
        if (current.parent.right == null) {
            return null;
        }
        if (previous != current.parent.right && this.isValidUplink(current.parent.right, current.parent)) {
            return current.parent.right;
        }
        if (current.parent.right == current.parent) {
            return null;
        }
        return this.nextEntryImpl(current.parent.right, previous, tree);
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Trie[").append(this.size()).append("]={\n");
        Iterator<Map.Entry<K, V>> i2 = this.newEntryIterator();
        while (i2.hasNext()) {
            buffer.append("  ").append(i2.next().toString()).append("\n");
        }
        buffer.append("}\n");
        return buffer.toString();
    }

    @Override
    public Map.Entry<K, V> traverse(Trie.Cursor<? super K, ? super V> cursor) {
        TrieEntry<K, V> entry2 = this.nextEntry(null);
        while (entry2 != null) {
            TrieEntry<K, V> current = entry2;
            Trie.Cursor.SelectStatus ret = cursor.select(current);
            entry2 = this.nextEntry(current);
            switch (ret) {
                case EXIT: {
                    return current;
                }
                case REMOVE: {
                    this.removeEntry(current);
                    break;
                }
                case REMOVE_AND_EXIT: {
                    TrieEntry<K, V> value = new TrieEntry<K, V>(current.getKey(), current.getValue(), -1);
                    this.removeEntry(current);
                    return value;
                }
            }
        }
        return null;
    }

    private boolean isValidUplink(TrieEntry<K, V> next, TrieEntry<K, V> from) {
        return next != null && next.bitIndex <= from.bitIndex && !next.isEmpty();
    }

    private int length(K key) {
        if (key == null) {
            return 0;
        }
        return this.keyAnalyzer.length(key);
    }

    private boolean isBitSet(K key, int keyLength, int bitIndex) {
        return key != null && this.keyAnalyzer.isBitSet(key, keyLength, bitIndex);
    }

    private int bitIndex(K key, K foundKey) {
        return this.keyAnalyzer.bitIndex(key, 0, this.length(key), foundKey, 0, this.length(foundKey));
    }

    private Iterator<K> newKeyIterator() {
        return new KeyIterator(this);
    }

    private Iterator<V> newValueIterator() {
        return new ValueIterator(this);
    }

    private Iterator<Map.Entry<K, V>> newEntryIterator() {
        return new EntryIterator(this);
    }

    @Override
    public Set<K> keySet() {
        KeySet ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    @Override
    public Collection<V> values() {
        Values vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    @Override
    private TrieEntry<K, V> firstEntry() {
        if (this.isEmpty()) {
            return null;
        }
        return this.followLeft(this.root);
    }

    private TrieEntry<K, V> followLeft(TrieEntry<K, V> node) {
        while (true) {
            TrieEntry child;
            if ((child = node.left).isEmpty()) {
                child = node.right;
            }
            if (child.bitIndex <= node.bitIndex) {
                return child;
            }
            node = child;
        }
    }

    @Override
    private TrieEntry<K, V> lastEntry() {
        return this.followRight(this.root.left);
    }

    private TrieEntry<K, V> followRight(TrieEntry<K, V> node) {
        if (node.right == null) {
            return null;
        }
        while (node.right.bitIndex > node.bitIndex) {
            node = node.right;
        }
        return node.right;
    }

    @Override
    public K firstKey() {
        return this.firstEntry().getKey();
    }

    @Override
    public SortedMap<K, V> headMap(K toKey) {
        return new SubMap(null, toKey);
    }

    @Override
    public K lastKey() {
        TrieEntry<K, V> entry2 = this.lastEntry();
        if (entry2 != null) {
            return entry2.getKey();
        }
        return null;
    }

    @Override
    public SortedMap<K, V> subMap(K fromKey, K toKey) {
        return new SubMap(fromKey, toKey);
    }

    @Override
    public SortedMap<K, V> tailMap(K fromKey) {
        return new SubMap(fromKey, null);
    }

    private TrieEntry<K, V> higherEntry(K key) {
        int keyLength = this.length(key);
        if (keyLength == 0) {
            if (!this.root.isEmpty()) {
                if (this.size() > 1) {
                    return this.nextEntry(this.root);
                }
                return null;
            }
            return this.firstEntry();
        }
        TrieEntry<K, V> found = this.getNearestEntryForKey(key, keyLength);
        if (key.equals(found.key)) {
            return this.nextEntry(found);
        }
        int bitIndex = this.bitIndex(key, found.key);
        if (PatriciaTrie.isValidBitIndex(bitIndex)) {
            TrieEntry<K, Object> added = new TrieEntry<K, Object>(key, null, bitIndex);
            this.addEntry(added, keyLength);
            this.incrementSize();
            TrieEntry<K, Object> ceil = this.nextEntry(added);
            this.removeEntry(added);
            this.modCount -= 2;
            return ceil;
        }
        if (PatriciaTrie.isNullBitKey(bitIndex)) {
            if (!this.root.isEmpty()) {
                return this.firstEntry();
            }
            if (this.size() > 1) {
                return this.nextEntry(this.firstEntry());
            }
            return null;
        }
        if (PatriciaTrie.isEqualBitKey(bitIndex)) {
            return this.nextEntry(found);
        }
        throw new IllegalStateException("invalid lookup: " + String.valueOf(key));
    }

    private TrieEntry<K, V> ceilingEntry(K key) {
        int keyLength = this.length(key);
        if (keyLength == 0) {
            if (!this.root.isEmpty()) {
                return this.root;
            }
            return this.firstEntry();
        }
        TrieEntry<K, V> found = this.getNearestEntryForKey(key, keyLength);
        if (key.equals(found.key)) {
            return found;
        }
        int bitIndex = this.bitIndex(key, found.key);
        if (PatriciaTrie.isValidBitIndex(bitIndex)) {
            TrieEntry<K, Object> added = new TrieEntry<K, Object>(key, null, bitIndex);
            this.addEntry(added, keyLength);
            this.incrementSize();
            TrieEntry<K, Object> ceil = this.nextEntry(added);
            this.removeEntry(added);
            this.modCount -= 2;
            return ceil;
        }
        if (PatriciaTrie.isNullBitKey(bitIndex)) {
            if (!this.root.isEmpty()) {
                return this.root;
            }
            return this.firstEntry();
        }
        if (PatriciaTrie.isEqualBitKey(bitIndex)) {
            return found;
        }
        throw new IllegalStateException("invalid lookup: " + String.valueOf(key));
    }

    private TrieEntry<K, V> lowerEntry(K key) {
        int keyLength = this.length(key);
        if (keyLength == 0) {
            return null;
        }
        TrieEntry<K, V> found = this.getNearestEntryForKey(key, keyLength);
        if (key.equals(found.key)) {
            return this.previousEntry(found);
        }
        int bitIndex = this.bitIndex(key, found.key);
        if (PatriciaTrie.isValidBitIndex(bitIndex)) {
            TrieEntry<K, Object> added = new TrieEntry<K, Object>(key, null, bitIndex);
            this.addEntry(added, keyLength);
            this.incrementSize();
            TrieEntry<K, Object> prior = this.previousEntry(added);
            this.removeEntry(added);
            this.modCount -= 2;
            return prior;
        }
        if (PatriciaTrie.isNullBitKey(bitIndex)) {
            return null;
        }
        if (PatriciaTrie.isEqualBitKey(bitIndex)) {
            return this.previousEntry(found);
        }
        throw new IllegalStateException("invalid lookup: " + String.valueOf(key));
    }

    private TrieEntry<K, V> floorEntry(K key) {
        int keyLength = this.length(key);
        if (keyLength == 0) {
            if (!this.root.isEmpty()) {
                return this.root;
            }
            return null;
        }
        TrieEntry<K, V> found = this.getNearestEntryForKey(key, keyLength);
        if (key.equals(found.key)) {
            return found;
        }
        int bitIndex = this.bitIndex(key, found.key);
        if (PatriciaTrie.isValidBitIndex(bitIndex)) {
            TrieEntry<K, Object> added = new TrieEntry<K, Object>(key, null, bitIndex);
            this.addEntry(added, keyLength);
            this.incrementSize();
            TrieEntry<K, Object> floor = this.previousEntry(added);
            this.removeEntry(added);
            this.modCount -= 2;
            return floor;
        }
        if (PatriciaTrie.isNullBitKey(bitIndex)) {
            if (!this.root.isEmpty()) {
                return this.root;
            }
            return null;
        }
        if (PatriciaTrie.isEqualBitKey(bitIndex)) {
            return found;
        }
        throw new IllegalStateException("invalid lookup: " + String.valueOf(key));
    }

    private TrieEntry<K, V> subtree(K prefix, int offset, int length) {
        TrieEntry<K, V> entry2;
        TrieEntry current = this.root.left;
        TrieEntry<K, V> path = this.root;
        while (current.bitIndex > path.bitIndex && length >= current.bitIndex) {
            path = current;
            if (!this.isBitSet(prefix, length + offset, current.bitIndex + offset)) {
                current = current.left;
                continue;
            }
            current = current.right;
        }
        TrieEntry<K, V> trieEntry = entry2 = current.isEmpty() ? path : current;
        if (entry2.isEmpty()) {
            return null;
        }
        int offsetLength = offset + length;
        if (entry2 == this.root && this.length(entry2.getKey()) < offsetLength) {
            return null;
        }
        if (this.isBitSet(prefix, offsetLength, offsetLength) != this.isBitSet(entry2.key, this.length(entry2.key), length)) {
            return null;
        }
        int bitIndex = this.keyAnalyzer.bitIndex(prefix, offset, length, entry2.key, 0, this.length(entry2.getKey()));
        if (bitIndex >= 0 && bitIndex < length) {
            return null;
        }
        return entry2;
    }

    private static class TrieEntry<K, V>
    implements Map.Entry<K, V>,
    Serializable {
        private static final long serialVersionUID = 4596023148184140013L;
        private K key;
        private V value;
        private int bitIndex;
        private TrieEntry<K, V> parent;
        private TrieEntry<K, V> left;
        private TrieEntry<K, V> right;
        private TrieEntry<K, V> predecessor;

        private TrieEntry(K key, V value, int bitIndex) {
            this.key = key;
            this.value = value;
            this.bitIndex = bitIndex;
            this.parent = null;
            this.left = this;
            this.right = null;
            this.predecessor = this;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof Map.Entry) {
                Object k2;
                Map.Entry e = (Map.Entry)o;
                K k1 = this.getKey();
                if (Objects.equals(k1, k2 = e.getKey())) {
                    V v1 = this.getValue();
                    Object v2 = e.getValue();
                    return Objects.equals(v1, v2);
                }
                return false;
            }
            return false;
        }

        boolean isEmpty() {
            return this.key == null;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V o = this.value;
            this.value = value;
            return o;
        }

        private V setKeyValue(K key, V value) {
            this.key = key;
            return this.setValue(value);
        }

        private boolean isInternalNode() {
            return this.left != this && this.right != this;
        }

        private boolean isExternalNode() {
            return !this.isInternalNode();
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            if (this.bitIndex == -1) {
                buffer.append("RootEntry(");
            } else {
                buffer.append("Entry(");
            }
            buffer.append("key=").append(this.getKey()).append(" [").append(this.bitIndex).append("], ");
            buffer.append("value=").append(this.getValue()).append(", ");
            if (this.parent != null) {
                if (this.parent.bitIndex == -1) {
                    buffer.append("parent=").append("ROOT");
                } else {
                    buffer.append("parent=").append(this.parent.getKey()).append(" [").append(this.parent.bitIndex).append("]");
                }
            } else {
                buffer.append("parent=").append("null");
            }
            buffer.append(", ");
            if (this.left != null) {
                if (this.left.bitIndex == -1) {
                    buffer.append("left=").append("ROOT");
                } else {
                    buffer.append("left=").append(this.left.getKey()).append(" [").append(this.left.bitIndex).append("]");
                }
            } else {
                buffer.append("left=").append("null");
            }
            buffer.append(", ");
            if (this.right != null) {
                if (this.right.bitIndex == -1) {
                    buffer.append("right=").append("ROOT");
                } else {
                    buffer.append("right=").append(this.right.getKey()).append(" [").append(this.right.bitIndex).append("]");
                }
            } else {
                buffer.append("right=").append("null");
            }
            buffer.append(", ");
            if (this.predecessor != null) {
                if (this.predecessor.bitIndex == -1) {
                    buffer.append("predecessor=").append("ROOT");
                } else {
                    buffer.append("predecessor=").append(this.predecessor.getKey()).append(" [").append(this.predecessor.bitIndex).append("]");
                }
            }
            buffer.append(")");
            return buffer.toString();
        }
    }

    public static interface KeyAnalyzer<K>
    extends Comparator<K>,
    Serializable {
        public static final int NULL_BIT_KEY = -1;
        public static final int EQUAL_BIT_KEY = -2;

        public int length(K var1);

        public boolean isBitSet(K var1, int var2, int var3);

        public int bitIndex(K var1, int var2, int var3, K var4, int var5, int var6);

        public int bitsPerElement();

        public boolean isPrefix(K var1, int var2, int var3, K var4);
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return PatriciaTrie.this.newEntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            TrieEntry candidate = PatriciaTrie.this.getEntry(((Map.Entry)o).getKey());
            return candidate != null && candidate.equals(o);
        }

        @Override
        public boolean remove(Object o) {
            int size = this.size();
            PatriciaTrie.this.remove(o);
            return size != this.size();
        }

        @Override
        public int size() {
            return PatriciaTrie.this.size;
        }

        @Override
        public void clear() {
            PatriciaTrie.this.clear();
        }
    }

    private class PrefixSubMap
    extends SubMap {
        private static final long serialVersionUID = -1736000794623484155L;
        final K prefix;
        final int offset;
        final int length;
        int size;
        private transient int keyModCount;

        PrefixSubMap(K prefix, int offset, int length) {
            this.keyModCount = 0;
            this.prefix = prefix;
            this.offset = offset;
            this.length = length;
            this.fromInclusive = false;
        }

        @Override
        public K firstKey() {
            Object first;
            this.fixup();
            TrieEntry e = this.fromKey == null ? PatriciaTrie.this.firstEntry() : PatriciaTrie.this.higherEntry(this.fromKey);
            Object object = first = e != null ? e.getKey() : null;
            if (e == null || !PatriciaTrie.this.keyAnalyzer.isPrefix(this.prefix, this.offset, this.length, first)) {
                throw new NoSuchElementException();
            }
            return first;
        }

        @Override
        public K lastKey() {
            Object last;
            this.fixup();
            TrieEntry e = this.toKey == null ? PatriciaTrie.this.lastEntry() : PatriciaTrie.this.lowerEntry(this.toKey);
            Object object = last = e != null ? e.getKey() : null;
            if (e == null || !PatriciaTrie.this.keyAnalyzer.isPrefix(this.prefix, this.offset, this.length, last)) {
                throw new NoSuchElementException();
            }
            return last;
        }

        @Override
        protected boolean inRange(K key) {
            return PatriciaTrie.this.keyAnalyzer.isPrefix(this.prefix, this.offset, this.length, key);
        }

        @Override
        protected boolean inRange2(K key) {
            return PatriciaTrie.this.keyAnalyzer.isPrefix(this.prefix, this.offset, this.length, key);
        }

        @Override
        protected boolean inToRange(K key, boolean forceInclusive) {
            return PatriciaTrie.this.keyAnalyzer.isPrefix(this.prefix, this.offset, this.length, key);
        }

        @Override
        protected boolean inFromRange(K key, boolean forceInclusive) {
            return PatriciaTrie.this.keyAnalyzer.isPrefix(this.prefix, this.offset, this.length, key);
        }

        private void fixup() {
            if (PatriciaTrie.this.modCount != this.keyModCount) {
                Iterator iter = this.entrySet().iterator();
                this.size = 0;
                Map.Entry entry2 = null;
                if (iter.hasNext()) {
                    entry2 = iter.next();
                    this.size = 1;
                }
                Object object = this.fromKey = entry2 == null ? null : (Object)entry2.getKey();
                if (this.fromKey != null) {
                    TrieEntry prior = PatriciaTrie.this.previousEntry((TrieEntry)entry2);
                    this.fromKey = prior == null ? null : prior.getKey();
                }
                this.toKey = this.fromKey;
                while (iter.hasNext()) {
                    ++this.size;
                    entry2 = iter.next();
                }
                Object object2 = this.toKey = entry2 == null ? null : (Object)entry2.getKey();
                if (this.toKey != null) {
                    this.toKey = (entry2 = PatriciaTrie.this.nextEntry((TrieEntry)entry2)) == null ? null : entry2.getKey();
                }
                this.keyModCount = PatriciaTrie.this.modCount;
            }
        }

        @Override
        protected Set<Map.Entry<K, V>> newSubMapEntrySet() {
            return new PrefixEntrySetView();
        }

        /*
         * Signature claims super is org.limewire.collection.PatriciaTrie$SubMap.EntrySetView, not org.limewire.collection.PatriciaTrie$SubMap$EntrySetView - discarding signature.
         */
        private class PrefixEntrySetView
        extends SubMap.EntrySetView {
            private TrieEntry<K, V> prefixStart;
            private int iterModCount;

            private PrefixEntrySetView() {
                this.iterModCount = 0;
            }

            @Override
            public int size() {
                PrefixSubMap.this.fixup();
                return PrefixSubMap.this.size;
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                if (PatriciaTrie.this.modCount != this.iterModCount) {
                    this.prefixStart = PatriciaTrie.this.subtree(PrefixSubMap.this.prefix, PrefixSubMap.this.offset, PrefixSubMap.this.length);
                    this.iterModCount = PatriciaTrie.this.modCount;
                }
                if (this.prefixStart == null) {
                    return EmptyIterator.emptyIterator();
                }
                if (PrefixSubMap.this.length >= this.prefixStart.bitIndex) {
                    return new SingletonIterator(this.prefixStart);
                }
                return new PrefixEntryIterator(this.prefixStart, PrefixSubMap.this.prefix, PrefixSubMap.this.offset, PrefixSubMap.this.length);
            }
        }
    }

    private class KeyIterator
    extends NodeIterator<K> {
        private KeyIterator(PatriciaTrie patriciaTrie) {
        }

        @Override
        public K next() {
            return this.nextEntry().getKey();
        }
    }

    private class ValueIterator
    extends NodeIterator<V> {
        private ValueIterator(PatriciaTrie patriciaTrie) {
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }
    }

    private class EntryIterator
    extends NodeIterator<Map.Entry<K, V>> {
        private EntryIterator(PatriciaTrie patriciaTrie) {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return PatriciaTrie.this.newKeyIterator();
        }

        @Override
        public int size() {
            return PatriciaTrie.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return PatriciaTrie.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            int size = this.size();
            PatriciaTrie.this.remove(o);
            return size != this.size();
        }

        @Override
        public void clear() {
            PatriciaTrie.this.clear();
        }
    }

    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return PatriciaTrie.this.newValueIterator();
        }

        @Override
        public int size() {
            return PatriciaTrie.this.size;
        }

        @Override
        public boolean contains(Object o) {
            return PatriciaTrie.this.containsValue(o);
        }

        @Override
        public void clear() {
            PatriciaTrie.this.clear();
        }

        @Override
        public boolean remove(Object o) {
            Iterator i2 = this.iterator();
            while (i2.hasNext()) {
                Object v = i2.next();
                if (!PatriciaTrie.valEquals(v, o)) continue;
                i2.remove();
                return true;
            }
            return false;
        }
    }

    private class SubMap
    extends AbstractMap<K, V>
    implements SortedMap<K, V>,
    Serializable {
        private static final long serialVersionUID = 4268580791803450065L;
        K fromKey;
        K toKey;
        boolean fromInclusive;
        boolean toInclusive;
        private transient Set<Map.Entry<K, V>> entrySet;

        SubMap() {
        }

        SubMap(K fromKey, K toKey) {
            if (fromKey == null && toKey == null) {
                throw new IllegalArgumentException("must have a from or to!");
            }
            if (fromKey != null && toKey != null && PatriciaTrie.this.keyAnalyzer.compare(fromKey, toKey) > 0) {
                throw new IllegalArgumentException("fromKey > toKey");
            }
            this.fromKey = fromKey;
            this.toKey = toKey;
            this.fromInclusive = true;
        }

        @Override
        public boolean isEmpty() {
            return this.entrySet().isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.inRange(key) && PatriciaTrie.this.containsKey(key);
        }

        @Override
        public V remove(Object key) {
            if (!this.inRange(key)) {
                return null;
            }
            return PatriciaTrie.this.remove(key);
        }

        @Override
        public V get(Object key) {
            if (!this.inRange(key)) {
                return null;
            }
            return PatriciaTrie.this.get(key);
        }

        @Override
        public V put(K key, V value) {
            if (!this.inRange(key)) {
                throw new IllegalArgumentException("key out of range");
            }
            return PatriciaTrie.this.put(key, value);
        }

        @Override
        public Comparator<? super K> comparator() {
            return PatriciaTrie.this.keyAnalyzer;
        }

        @Override
        public K firstKey() {
            Object first;
            TrieEntry e = this.fromKey == null ? PatriciaTrie.this.firstEntry() : (this.fromInclusive ? PatriciaTrie.this.ceilingEntry(this.fromKey) : PatriciaTrie.this.higherEntry(this.fromKey));
            Object k = first = e != null ? (Object)e.getKey() : null;
            if (e == null || this.toKey != null && !this.inToRange(first, false)) {
                throw new NoSuchElementException();
            }
            return first;
        }

        @Override
        public K lastKey() {
            Object last;
            TrieEntry e = this.toKey == null ? PatriciaTrie.this.lastEntry() : (this.toInclusive ? PatriciaTrie.this.floorEntry(this.toKey) : PatriciaTrie.this.lowerEntry(this.toKey));
            Object k = last = e != null ? (Object)e.getKey() : null;
            if (e == null || this.fromKey != null && !this.inFromRange(last, false)) {
                throw new NoSuchElementException();
            }
            return last;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            if (this.entrySet == null) {
                this.entrySet = this.newSubMapEntrySet();
            }
            return this.entrySet;
        }

        Set<Map.Entry<K, V>> newSubMapEntrySet() {
            return new EntrySetView();
        }

        @Override
        public SortedMap<K, V> subMap(K fromKey, K toKey) {
            if (!this.inRange2(fromKey)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            if (!this.inRange2(toKey)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new SubMap(fromKey, toKey);
        }

        @Override
        public SortedMap<K, V> headMap(K toKey) {
            if (!this.inRange2(toKey)) {
                throw new IllegalArgumentException("toKey out of range");
            }
            return new SubMap(this.fromKey, toKey);
        }

        @Override
        public SortedMap<K, V> tailMap(K fromKey) {
            if (!this.inRange2(fromKey)) {
                throw new IllegalArgumentException("fromKey out of range");
            }
            return new SubMap(fromKey, this.toKey);
        }

        boolean inRange(K key) {
            return !(this.fromKey != null && !this.inFromRange(key, false) || this.toKey != null && !this.inToRange(key, false));
        }

        boolean inRange2(K key) {
            return !(this.fromKey != null && !this.inFromRange(key, false) || this.toKey != null && !this.inToRange(key, true));
        }

        boolean inToRange(K key, boolean forceInclusive) {
            int ret = PatriciaTrie.this.keyAnalyzer.compare(key, this.toKey);
            if (this.toInclusive || forceInclusive) {
                return ret <= 0;
            }
            return ret < 0;
        }

        boolean inFromRange(K key, boolean forceInclusive) {
            int ret = PatriciaTrie.this.keyAnalyzer.compare(key, this.fromKey);
            if (this.fromInclusive || forceInclusive) {
                return ret >= 0;
            }
            return ret > 0;
        }

        class EntrySetView
        extends AbstractSet<Map.Entry<K, V>> {
            private transient int size = -1;
            private transient int sizeModCount;

            EntrySetView() {
            }

            @Override
            public int size() {
                if (this.size == -1 || this.sizeModCount != PatriciaTrie.this.modCount) {
                    this.size = 0;
                    this.sizeModCount = PatriciaTrie.this.modCount;
                    for (Map.Entry ignored : this) {
                        ++this.size;
                    }
                }
                return this.size;
            }

            @Override
            public boolean isEmpty() {
                return !this.iterator().hasNext();
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry2 = (Map.Entry)o;
                Object key = entry2.getKey();
                if (!SubMap.this.inRange(key)) {
                    return false;
                }
                TrieEntry node = PatriciaTrie.this.getEntry(key);
                return node != null && PatriciaTrie.valEquals(node.getValue(), entry2.getValue());
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry2 = (Map.Entry)o;
                Object key = entry2.getKey();
                if (!SubMap.this.inRange(key)) {
                    return false;
                }
                TrieEntry node = PatriciaTrie.this.getEntry(key);
                if (node != null && PatriciaTrie.valEquals(node.getValue(), entry2.getValue())) {
                    PatriciaTrie.this.removeEntry(node);
                    return true;
                }
                return false;
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new SubMapEntryIterator(PatriciaTrie.this, SubMap.this.fromKey == null ? PatriciaTrie.this.firstEntry() : PatriciaTrie.this.ceilingEntry(SubMap.this.fromKey), SubMap.this.toKey == null ? null : PatriciaTrie.this.ceilingEntry(SubMap.this.toKey));
            }
        }
    }

    private class SubMapEntryIterator
    extends NodeIterator<Map.Entry<K, V>> {
        private final K firstExcludedKey;

        SubMapEntryIterator(PatriciaTrie patriciaTrie, TrieEntry<K, V> first, TrieEntry<K, V> firstExcluded) {
            super(first);
            this.firstExcludedKey = firstExcluded == null ? null : firstExcluded.key;
        }

        @Override
        public boolean hasNext() {
            return this.next != null && this.next.key != this.firstExcludedKey;
        }

        @Override
        public Map.Entry<K, V> next() {
            if (this.next == null || this.next.key == this.firstExcludedKey) {
                throw new NoSuchElementException();
            }
            return this.nextEntry();
        }
    }

    private class PrefixEntryIterator
    extends NodeIterator<Map.Entry<K, V>> {
        final K prefix;
        final int offset;
        final int length;
        boolean lastOne;
        TrieEntry<K, V> subtree;

        PrefixEntryIterator(TrieEntry<K, V> startScan, K prefix, int offset, int length) {
            this.subtree = startScan;
            this.next = PatriciaTrie.this.followLeft(startScan);
            this.prefix = prefix;
            this.offset = offset;
            this.length = length;
        }

        @Override
        public Map.Entry<K, V> next() {
            TrieEntry entry2 = this.nextEntry();
            if (this.lastOne) {
                this.next = null;
            }
            return entry2;
        }

        @Override
        protected TrieEntry<K, V> findNext(TrieEntry<K, V> prior) {
            return PatriciaTrie.this.nextEntryInSubtree(prior, this.subtree);
        }

        @Override
        public void remove() {
            boolean needsFixing = false;
            int bitIdx = this.subtree.bitIndex;
            if (this.current == this.subtree) {
                needsFixing = true;
            }
            super.remove();
            if (bitIdx != this.subtree.bitIndex || needsFixing) {
                this.subtree = PatriciaTrie.this.subtree(this.prefix, this.offset, this.length);
            }
            if (this.length >= this.subtree.bitIndex) {
                this.lastOne = true;
            }
        }
    }

    private abstract class NodeIterator<E>
    implements Iterator<E> {
        TrieEntry<K, V> next;
        TrieEntry<K, V> current;
        int expectedModCount;

        NodeIterator() {
            this.expectedModCount = PatriciaTrie.this.modCount;
            this.next = PatriciaTrie.this.nextEntry(null);
        }

        NodeIterator(TrieEntry<K, V> firstEntry) {
            this.expectedModCount = PatriciaTrie.this.modCount;
            this.next = firstEntry;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        TrieEntry<K, V> nextEntry() {
            if (PatriciaTrie.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            TrieEntry e = this.next;
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.next = this.findNext(e);
            this.current = e;
            return e;
        }

        TrieEntry<K, V> findNext(TrieEntry<K, V> prior) {
            return PatriciaTrie.this.nextEntry(prior);
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            if (PatriciaTrie.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            TrieEntry node = this.current;
            this.current = null;
            PatriciaTrie.this.removeEntry(node);
            this.expectedModCount = PatriciaTrie.this.modCount;
        }
    }

    private class SingletonIterator
    implements Iterator<Map.Entry<K, V>> {
        private final TrieEntry<K, V> entry;
        private int hit = 0;

        SingletonIterator(TrieEntry<K, V> entry2) {
            this.entry = entry2;
        }

        @Override
        public boolean hasNext() {
            return this.hit == 0;
        }

        @Override
        public Map.Entry<K, V> next() {
            if (this.hit != 0) {
                throw new NoSuchElementException();
            }
            ++this.hit;
            return this.entry;
        }

        @Override
        public void remove() {
            if (this.hit != 1) {
                throw new IllegalStateException();
            }
            ++this.hit;
            PatriciaTrie.this.removeEntry(this.entry);
        }
    }
}

