/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import org.jaudiotagger.audio.mp3.MP3File;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.FieldDataInvalidException;
import org.jaudiotagger.tag.FieldKey;
import org.jaudiotagger.tag.KeyNotFoundException;
import org.jaudiotagger.tag.Tag;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.TagNotFoundException;
import org.jaudiotagger.tag.TagOptionSingleton;
import org.jaudiotagger.tag.id3.AbstractID3v1Tag;
import org.jaudiotagger.tag.id3.AbstractTag;
import org.jaudiotagger.tag.id3.ID3Tags;
import org.jaudiotagger.tag.id3.ID3v11Tag;
import org.jaudiotagger.tag.id3.ID3v1FieldKey;
import org.jaudiotagger.tag.id3.ID3v1Iterator;
import org.jaudiotagger.tag.id3.ID3v1TagField;
import org.jaudiotagger.tag.images.Artwork;
import org.jaudiotagger.tag.reference.GenreTypes;

public class ID3v1Tag
extends AbstractID3v1Tag
implements Tag {
    static EnumMap<FieldKey, ID3v1FieldKey> tagFieldToID3v1Field = new EnumMap(FieldKey.class);
    protected static final String TYPE_COMMENT = "comment";
    protected static final int FIELD_COMMENT_LENGTH = 30;
    protected static final int FIELD_COMMENT_POS = 97;
    protected static final int BYTE_TO_UNSIGNED = 255;
    protected static final int GENRE_UNDEFINED = 255;
    protected String album = "";
    protected String artist = "";
    protected String comment = "";
    protected String title = "";
    protected String year = "";
    protected byte genre = (byte)-1;
    private static final byte RELEASE = 1;
    private static final byte MAJOR_VERSION = 0;
    private static final byte REVISION = 0;

    @Override
    public byte getRelease() {
        return 1;
    }

    @Override
    public byte getMajorVersion() {
        return 0;
    }

    @Override
    public byte getRevision() {
        return 0;
    }

    public ID3v1Tag() {
    }

    public ID3v1Tag(ID3v1Tag copyObject) {
        super(copyObject);
        this.album = copyObject.album;
        this.artist = copyObject.artist;
        this.comment = copyObject.comment;
        this.title = copyObject.title;
        this.year = copyObject.year;
        this.genre = copyObject.genre;
    }

    public ID3v1Tag(AbstractTag mp3tag) {
        if (mp3tag != null) {
            if (mp3tag instanceof ID3v1Tag) {
                throw new UnsupportedOperationException("Copy Constructor not called. Please type cast the argument");
            }
            ID3v11Tag convertedTag = mp3tag instanceof ID3v11Tag ? (ID3v11Tag)mp3tag : new ID3v11Tag(mp3tag);
            this.album = convertedTag.album;
            this.artist = convertedTag.artist;
            this.comment = convertedTag.comment;
            this.title = convertedTag.title;
            this.year = convertedTag.year;
            this.genre = convertedTag.genre;
        }
    }

    public ID3v1Tag(RandomAccessFile file, String loggingFilename) throws TagNotFoundException, IOException {
        this.setLoggingFilename(loggingFilename);
        FileChannel fc = file.getChannel();
        if (file.length() < 128L) {
            throw new IOException("File not large enough to contain a tag");
        }
        fc.position(file.length() - 128L);
        ByteBuffer byteBuffer = ByteBuffer.allocate(128);
        fc.read(byteBuffer);
        byteBuffer.flip();
        this.read(byteBuffer);
    }

    public ID3v1Tag(RandomAccessFile file) throws TagNotFoundException, IOException {
        this(file, "");
    }

    @Override
    public void addField(TagField field) {
    }

    @Override
    public List<String> getAll(FieldKey genericKey) throws KeyNotFoundException {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.getFirst(genericKey.name()));
        return list;
    }

    @Override
    public List<TagField> getFields(String id) {
        if (FieldKey.ARTIST.name().equals(id)) {
            return this.getArtist();
        }
        if (FieldKey.ALBUM.name().equals(id)) {
            return this.getAlbum();
        }
        if (FieldKey.TITLE.name().equals(id)) {
            return this.getTitle();
        }
        if (FieldKey.GENRE.name().equals(id)) {
            return this.getGenre();
        }
        if (FieldKey.YEAR.name().equals(id)) {
            return this.getYear();
        }
        if (FieldKey.COMMENT.name().equals(id)) {
            return this.getComment();
        }
        return new ArrayList<TagField>();
    }

    @Override
    public int getFieldCount() {
        return 6;
    }

    @Override
    public int getFieldCountIncludingSubValues() {
        return this.getFieldCount();
    }

    protected List<TagField> returnFieldToList(ID3v1TagField field) {
        ArrayList<TagField> fields = new ArrayList<TagField>();
        fields.add(field);
        return fields;
    }

    public void setAlbum(String album) {
        if (album == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        this.album = ID3Tags.truncate(album, 30);
    }

    public String getFirstAlbum() {
        return this.album;
    }

    public List<TagField> getAlbum() {
        if (this.getFirstAlbum().length() > 0) {
            ID3v1TagField field = new ID3v1TagField(ID3v1FieldKey.ALBUM.name(), this.getFirstAlbum());
            return this.returnFieldToList(field);
        }
        return new ArrayList<TagField>();
    }

    public void setArtist(String artist) {
        if (artist == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        this.artist = ID3Tags.truncate(artist, 30);
    }

    public String getFirstArtist() {
        return this.artist;
    }

    public List<TagField> getArtist() {
        if (this.getFirstArtist().length() > 0) {
            ID3v1TagField field = new ID3v1TagField(ID3v1FieldKey.ARTIST.name(), this.getFirstArtist());
            return this.returnFieldToList(field);
        }
        return new ArrayList<TagField>();
    }

    public void setComment(String comment) {
        if (comment == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        this.comment = ID3Tags.truncate(comment, 30);
    }

    public List<TagField> getComment() {
        if (this.getFirstComment().length() > 0) {
            ID3v1TagField field = new ID3v1TagField(ID3v1FieldKey.COMMENT.name(), this.getFirstComment());
            return this.returnFieldToList(field);
        }
        return new ArrayList<TagField>();
    }

    public String getFirstComment() {
        return this.comment;
    }

    public void setGenre(String genreVal) {
        if (genreVal == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        Integer genreID = GenreTypes.getInstanceOf().getIdForValue(genreVal);
        this.genre = genreID != null ? genreID.byteValue() : (byte)-1;
    }

    public String getFirstGenre() {
        Integer genreId = this.genre & 0xFF;
        String genreValue = GenreTypes.getInstanceOf().getValueForId(genreId);
        if (genreValue == null) {
            return "";
        }
        return genreValue;
    }

    public List<TagField> getGenre() {
        if (this.getFirst(FieldKey.GENRE).length() > 0) {
            ID3v1TagField field = new ID3v1TagField(ID3v1FieldKey.GENRE.name(), this.getFirst(FieldKey.GENRE));
            return this.returnFieldToList(field);
        }
        return new ArrayList<TagField>();
    }

    public void setTitle(String title) {
        if (title == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        this.title = ID3Tags.truncate(title, 30);
    }

    public String getFirstTitle() {
        return this.title;
    }

    public List<TagField> getTitle() {
        if (this.getFirst(FieldKey.TITLE).length() > 0) {
            ID3v1TagField field = new ID3v1TagField(ID3v1FieldKey.TITLE.name(), this.getFirst(FieldKey.TITLE));
            return this.returnFieldToList(field);
        }
        return new ArrayList<TagField>();
    }

    public void setYear(String year) {
        this.year = ID3Tags.truncate(year, 4);
    }

    public String getFirstYear() {
        return this.year;
    }

    public List<TagField> getYear() {
        if (this.getFirst(FieldKey.YEAR).length() > 0) {
            ID3v1TagField field = new ID3v1TagField(ID3v1FieldKey.YEAR.name(), this.getFirst(FieldKey.YEAR));
            return this.returnFieldToList(field);
        }
        return new ArrayList<TagField>();
    }

    public String getFirstTrack() {
        throw new UnsupportedOperationException("ID3v10 cannot store track numbers");
    }

    public List<TagField> getTrack() {
        throw new UnsupportedOperationException("ID3v10 cannot store track numbers");
    }

    @Override
    public TagField getFirstField(String id) {
        List<TagField> results = null;
        if (FieldKey.ARTIST.name().equals(id)) {
            results = this.getArtist();
        } else if (FieldKey.ALBUM.name().equals(id)) {
            results = this.getAlbum();
        } else if (FieldKey.TITLE.name().equals(id)) {
            results = this.getTitle();
        } else if (FieldKey.GENRE.name().equals(id)) {
            results = this.getGenre();
        } else if (FieldKey.YEAR.name().equals(id)) {
            results = this.getYear();
        } else if (FieldKey.COMMENT.name().equals(id)) {
            results = this.getComment();
        }
        if (results != null && results.size() > 0) {
            return results.get(0);
        }
        return null;
    }

    @Override
    public Iterator<TagField> getFields() {
        throw new UnsupportedOperationException("TODO:Not done yet");
    }

    @Override
    public boolean hasCommonFields() {
        return true;
    }

    @Override
    public boolean hasField(FieldKey genericKey) {
        return this.getFirst(genericKey).length() > 0;
    }

    @Override
    public boolean hasField(String id) {
        try {
            FieldKey key = FieldKey.valueOf(id.toUpperCase());
            return this.hasField(key);
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.getFirst(FieldKey.TITLE).length() <= 0 && this.getFirstArtist().length() <= 0 && this.getFirstAlbum().length() <= 0 && this.getFirst(FieldKey.GENRE).length() <= 0 && this.getFirst(FieldKey.YEAR).length() <= 0 && this.getFirstComment().length() <= 0;
    }

    @Override
    public void setField(FieldKey genericKey, String ... value) throws KeyNotFoundException, FieldDataInvalidException {
        TagField tagfield = this.createField(genericKey, value);
        this.setField(tagfield);
    }

    @Override
    public void addField(FieldKey genericKey, String ... value) throws KeyNotFoundException, FieldDataInvalidException {
        this.setField(genericKey, value);
    }

    @Override
    public void setField(TagField field) {
        FieldKey genericKey = FieldKey.valueOf(field.getId());
        switch (genericKey) {
            case ARTIST: {
                this.setArtist(field.toString());
                break;
            }
            case ALBUM: {
                this.setAlbum(field.toString());
                break;
            }
            case TITLE: {
                this.setTitle(field.toString());
                break;
            }
            case GENRE: {
                this.setGenre(field.toString());
                break;
            }
            case YEAR: {
                this.setYear(field.toString());
                break;
            }
            case COMMENT: {
                this.setComment(field.toString());
            }
        }
    }

    @Override
    public boolean setEncoding(Charset encoding) {
        return true;
    }

    @Override
    public TagField createField(FieldKey genericKey, String ... values2) {
        String value = values2[0];
        if (genericKey == null) {
            throw new IllegalArgumentException(ErrorMessage.GENERAL_INVALID_NULL_ARGUMENT.getMsg());
        }
        ID3v1FieldKey idv1FieldKey = tagFieldToID3v1Field.get((Object)genericKey);
        if (idv1FieldKey == null) {
            throw new KeyNotFoundException(ErrorMessage.INVALID_FIELD_FOR_ID3V1TAG.getMsg(genericKey.name()));
        }
        return new ID3v1TagField(idv1FieldKey.name(), value);
    }

    public Charset getEncoding() {
        return StandardCharsets.ISO_8859_1;
    }

    @Override
    public TagField getFirstField(FieldKey genericKey) {
        List<TagField> l = this.getFields(genericKey);
        return l.size() != 0 ? l.get(0) : null;
    }

    @Override
    public List<TagField> getFields(FieldKey genericKey) {
        switch (genericKey) {
            case ARTIST: {
                return this.getArtist();
            }
            case ALBUM: {
                return this.getAlbum();
            }
            case TITLE: {
                return this.getTitle();
            }
            case GENRE: {
                return this.getGenre();
            }
            case YEAR: {
                return this.getYear();
            }
            case COMMENT: {
                return this.getComment();
            }
        }
        return new ArrayList<TagField>();
    }

    @Override
    public String getFirst(String genericKey) {
        FieldKey matchingKey = FieldKey.valueOf(genericKey);
        if (matchingKey != null) {
            return this.getFirst(matchingKey);
        }
        return "";
    }

    @Override
    public String getFirst(FieldKey genericKey) {
        switch (genericKey) {
            case ARTIST: {
                return this.getFirstArtist();
            }
            case ALBUM: {
                return this.getFirstAlbum();
            }
            case TITLE: {
                return this.getFirstTitle();
            }
            case GENRE: {
                return this.getFirstGenre();
            }
            case YEAR: {
                return this.getFirstYear();
            }
            case COMMENT: {
                return this.getFirstComment();
            }
        }
        return "";
    }

    public String getSubValue(FieldKey id, int n, int m) {
        return this.getValue(id, n);
    }

    @Override
    public String getValue(FieldKey genericKey, int index) {
        return this.getFirst(genericKey);
    }

    @Override
    public void deleteField(FieldKey genericKey) {
        switch (genericKey) {
            case ARTIST: {
                this.setArtist("");
                break;
            }
            case ALBUM: {
                this.setAlbum("");
                break;
            }
            case TITLE: {
                this.setTitle("");
                break;
            }
            case GENRE: {
                this.setGenre("");
                break;
            }
            case YEAR: {
                this.setYear("");
                break;
            }
            case COMMENT: {
                this.setComment("");
            }
        }
    }

    @Override
    public void deleteField(String id) {
        FieldKey key = FieldKey.valueOf(id);
        if (key != null) {
            this.deleteField(key);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ID3v1Tag)) {
            return false;
        }
        ID3v1Tag object = (ID3v1Tag)obj;
        if (!this.album.equals(object.album)) {
            return false;
        }
        if (!this.artist.equals(object.artist)) {
            return false;
        }
        if (!this.comment.equals(object.comment)) {
            return false;
        }
        if (this.genre != object.genre) {
            return false;
        }
        if (!this.title.equals(object.title)) {
            return false;
        }
        return this.year.equals(object.year) && super.equals(obj);
    }

    @Override
    public Iterator iterator() {
        return new ID3v1Iterator(this);
    }

    @Override
    public void read(ByteBuffer byteBuffer) throws TagNotFoundException {
        if (!this.seek(byteBuffer)) {
            throw new TagNotFoundException(this.getLoggingFilename() + ":ID3v1 tag not found");
        }
        logger.finer(this.getLoggingFilename() + ":Reading v1 tag");
        byte[] dataBuffer = new byte[128];
        byteBuffer.position(0);
        byteBuffer.get(dataBuffer, 0, 128);
        this.title = new String(dataBuffer, 3, 30, StandardCharsets.ISO_8859_1).trim();
        Matcher m = AbstractID3v1Tag.endofStringPattern.matcher(this.title);
        if (m.find()) {
            this.title = this.title.substring(0, m.start());
        }
        this.artist = new String(dataBuffer, 33, 30, StandardCharsets.ISO_8859_1).trim();
        m = AbstractID3v1Tag.endofStringPattern.matcher(this.artist);
        if (m.find()) {
            this.artist = this.artist.substring(0, m.start());
        }
        this.album = new String(dataBuffer, 63, 30, StandardCharsets.ISO_8859_1).trim();
        m = AbstractID3v1Tag.endofStringPattern.matcher(this.album);
        logger.finest(this.getLoggingFilename() + ":Orig Album is:" + this.comment + ":");
        if (m.find()) {
            this.album = this.album.substring(0, m.start());
            logger.finest(this.getLoggingFilename() + ":Album is:" + this.album + ":");
        }
        this.year = new String(dataBuffer, 93, 4, StandardCharsets.ISO_8859_1).trim();
        m = AbstractID3v1Tag.endofStringPattern.matcher(this.year);
        if (m.find()) {
            this.year = this.year.substring(0, m.start());
        }
        this.comment = new String(dataBuffer, 97, 30, StandardCharsets.ISO_8859_1).trim();
        m = AbstractID3v1Tag.endofStringPattern.matcher(this.comment);
        logger.finest(this.getLoggingFilename() + ":Orig Comment is:" + this.comment + ":");
        if (m.find()) {
            this.comment = this.comment.substring(0, m.start());
            logger.finest(this.getLoggingFilename() + ":Comment is:" + this.comment + ":");
        }
        this.genre = dataBuffer[127];
    }

    @Override
    public boolean seek(ByteBuffer byteBuffer) {
        byte[] buffer = new byte[3];
        byteBuffer.get(buffer, 0, 3);
        return Arrays.equals(buffer, TAG_ID);
    }

    @Override
    public void write(RandomAccessFile file) throws IOException {
        int i2;
        String str;
        logger.config("Saving ID3v1 tag to file");
        byte[] buffer = new byte[128];
        this.delete(file);
        file.seek(file.length());
        System.arraycopy(TAG_ID, 0, buffer, 0, TAG_ID.length);
        int offset = 3;
        if (TagOptionSingleton.getInstance().isId3v1SaveTitle()) {
            str = ID3Tags.truncate(this.title, 30);
            for (i2 = 0; i2 < str.length(); ++i2) {
                buffer[i2 + offset] = (byte)str.charAt(i2);
            }
        }
        offset = 33;
        if (TagOptionSingleton.getInstance().isId3v1SaveArtist()) {
            str = ID3Tags.truncate(this.artist, 30);
            for (i2 = 0; i2 < str.length(); ++i2) {
                buffer[i2 + offset] = (byte)str.charAt(i2);
            }
        }
        offset = 63;
        if (TagOptionSingleton.getInstance().isId3v1SaveAlbum()) {
            str = ID3Tags.truncate(this.album, 30);
            for (i2 = 0; i2 < str.length(); ++i2) {
                buffer[i2 + offset] = (byte)str.charAt(i2);
            }
        }
        offset = 93;
        if (TagOptionSingleton.getInstance().isId3v1SaveYear()) {
            str = ID3Tags.truncate(this.year, 4);
            for (i2 = 0; i2 < str.length(); ++i2) {
                buffer[i2 + offset] = (byte)str.charAt(i2);
            }
        }
        offset = 97;
        if (TagOptionSingleton.getInstance().isId3v1SaveComment()) {
            str = ID3Tags.truncate(this.comment, 30);
            for (i2 = 0; i2 < str.length(); ++i2) {
                buffer[i2 + offset] = (byte)str.charAt(i2);
            }
        }
        offset = 127;
        if (TagOptionSingleton.getInstance().isId3v1SaveGenre()) {
            buffer[offset] = this.genre;
        }
        file.write(buffer);
        logger.config("Saved ID3v1 tag to file");
    }

    public void createStructure() {
        MP3File.getStructureFormatter().openHeadingElement("tag", this.getIdentifier());
        MP3File.getStructureFormatter().addElement("title", this.title);
        MP3File.getStructureFormatter().addElement("artist", this.artist);
        MP3File.getStructureFormatter().addElement("album", this.album);
        MP3File.getStructureFormatter().addElement("year", this.year);
        MP3File.getStructureFormatter().addElement(TYPE_COMMENT, this.comment);
        MP3File.getStructureFormatter().addElement("genre", this.genre);
        MP3File.getStructureFormatter().closeHeadingElement("tag");
    }

    @Override
    public List<Artwork> getArtworkList() {
        return Collections.emptyList();
    }

    @Override
    public Artwork getFirstArtwork() {
        return null;
    }

    @Override
    public TagField createField(Artwork artwork) throws FieldDataInvalidException {
        throw new UnsupportedOperationException(ErrorMessage.GENERIC_NOT_SUPPORTED.getMsg());
    }

    @Override
    public void setField(Artwork artwork) throws FieldDataInvalidException {
        throw new UnsupportedOperationException(ErrorMessage.GENERIC_NOT_SUPPORTED.getMsg());
    }

    @Override
    public void addField(Artwork artwork) throws FieldDataInvalidException {
        throw new UnsupportedOperationException(ErrorMessage.GENERIC_NOT_SUPPORTED.getMsg());
    }

    @Override
    public void deleteArtworkField() throws KeyNotFoundException {
        throw new UnsupportedOperationException(ErrorMessage.GENERIC_NOT_SUPPORTED.getMsg());
    }

    @Override
    public TagField createCompilationField(boolean value) throws KeyNotFoundException, FieldDataInvalidException {
        throw new UnsupportedOperationException(ErrorMessage.GENERIC_NOT_SUPPORTED.getMsg());
    }

    static {
        tagFieldToID3v1Field.put(FieldKey.ARTIST, ID3v1FieldKey.ARTIST);
        tagFieldToID3v1Field.put(FieldKey.ALBUM, ID3v1FieldKey.ALBUM);
        tagFieldToID3v1Field.put(FieldKey.TITLE, ID3v1FieldKey.TITLE);
        tagFieldToID3v1Field.put(FieldKey.TRACK, ID3v1FieldKey.TRACK);
        tagFieldToID3v1Field.put(FieldKey.YEAR, ID3v1FieldKey.YEAR);
        tagFieldToID3v1Field.put(FieldKey.GENRE, ID3v1FieldKey.GENRE);
        tagFieldToID3v1Field.put(FieldKey.COMMENT, ID3v1FieldKey.COMMENT);
    }
}

