/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.id3;

import java.nio.ByteBuffer;

public class ID3SyncSafeInteger {
    public static final int INTEGRAL_SIZE = 4;
    public static final int MAX_SAFE_SIZE = 127;

    public static int bufferToValue(byte[] buffer) {
        return ((buffer[0] & 0xFF) << 21) + ((buffer[1] & 0xFF) << 14) + ((buffer[2] & 0xFF) << 7) + (buffer[3] & 0xFF);
    }

    public static int bufferToValue(ByteBuffer buffer) {
        byte[] byteBuffer = new byte[4];
        buffer.get(byteBuffer, 0, 4);
        return ID3SyncSafeInteger.bufferToValue(byteBuffer);
    }

    protected static boolean isBufferNotSyncSafe(ByteBuffer buffer) {
        int position = buffer.position();
        for (int i2 = 0; i2 < 4; ++i2) {
            byte nextByte = buffer.get(position + i2);
            if ((nextByte & 0x80) <= 0) continue;
            return true;
        }
        return false;
    }

    protected static boolean isBufferEmpty(byte[] buffer) {
        for (byte aBuffer : buffer) {
            if (aBuffer == 0) continue;
            return false;
        }
        return true;
    }

    protected static byte[] valueToBuffer(int size) {
        byte[] buffer = new byte[]{(byte)((size & 0xFE00000) >> 21), (byte)((size & 0x1FC000) >> 14), (byte)((size & 0x3F80) >> 7), (byte)(size & 0x7F)};
        return buffer;
    }
}

