/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.datatype;

import java.util.logging.Level;
import org.jaudiotagger.tag.InvalidDataTypeException;
import org.jaudiotagger.tag.datatype.AbstractDataType;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;
import org.jaudiotagger.tag.id3.ID3Tags;

public class NumberFixedLength
extends AbstractDataType {
    public NumberFixedLength(String identifier, AbstractTagFrameBody frameBody, int size) {
        super(identifier, frameBody);
        if (size < 0) {
            throw new IllegalArgumentException("Length is less than zero: " + size);
        }
        this.size = size;
    }

    public NumberFixedLength(NumberFixedLength copy) {
        super(copy);
        this.size = copy.size;
    }

    public void setSize(int size) {
        if (size > 0) {
            this.size = size;
        }
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public void setValue(Object value) {
        if (!(value instanceof Number)) {
            throw new IllegalArgumentException("Invalid value type for NumberFixedLength:" + value.getClass());
        }
        super.setValue(value);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof NumberFixedLength)) {
            return false;
        }
        NumberFixedLength object = (NumberFixedLength)obj;
        return this.size == object.size && super.equals(obj);
    }

    @Override
    public void readByteArray(byte[] arr, int offset) throws InvalidDataTypeException {
        if (arr == null) {
            throw new NullPointerException("Byte array is null");
        }
        if (offset < 0 || offset >= arr.length) {
            throw new InvalidDataTypeException("Offset to byte array is out of bounds: offset = " + offset + ", array.length = " + arr.length);
        }
        if (offset + this.size > arr.length) {
            throw new InvalidDataTypeException("Offset plus size to byte array is out of bounds: offset = " + offset + ", size = " + this.size + " + arr.length " + arr.length);
        }
        long lvalue = 0L;
        for (int i2 = offset; i2 < offset + this.size; ++i2) {
            lvalue <<= 8;
            lvalue += (long)(arr[i2] & 0xFF);
        }
        this.value = lvalue;
        if (logger.isLoggable(Level.CONFIG)) {
            logger.config("Read NumberFixedlength:" + this.value);
        }
    }

    public String toString() {
        if (this.value == null) {
            return "";
        }
        return this.value.toString();
    }

    @Override
    public byte[] writeByteArray() {
        byte[] arr = new byte[this.size];
        if (this.value != null) {
            long temp = ID3Tags.getWholeNumber(this.value);
            for (int i2 = this.size - 1; i2 >= 0; --i2) {
                arr[i2] = (byte)(temp & 0xFFL);
                temp >>= 8;
            }
        }
        return arr;
    }
}

