/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.datatype;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.jaudiotagger.tag.InvalidDataTypeException;
import org.jaudiotagger.tag.datatype.AbstractDataType;
import org.jaudiotagger.tag.id3.AbstractTagFrameBody;

public abstract class AbstractDataTypeList<T extends AbstractDataType>
extends AbstractDataType {
    public AbstractDataTypeList(String identifier, AbstractTagFrameBody frameBody) {
        super(identifier, frameBody);
        this.setValue(new ArrayList());
    }

    protected AbstractDataTypeList(AbstractDataTypeList<T> copy) {
        super(copy);
    }

    @Override
    public List<T> getValue() {
        return (List)super.getValue();
    }

    public void setValue(List<T> list) {
        super.setValue(list == null ? new ArrayList() : new ArrayList<T>(list));
    }

    @Override
    public int getSize() {
        int size = 0;
        Iterator iterator2 = this.getValue().iterator();
        while (iterator2.hasNext()) {
            AbstractDataType t = (AbstractDataType)iterator2.next();
            size += t.getSize();
        }
        return size;
    }

    @Override
    public void readByteArray(byte[] buffer, int offset) throws InvalidDataTypeException {
        T data;
        if (buffer == null) {
            throw new NullPointerException("Byte array is null");
        }
        if (offset < 0) {
            throw new IndexOutOfBoundsException("Offset to byte array is out of bounds: offset = " + offset + ", array.length = " + buffer.length);
        }
        if (offset >= buffer.length) {
            this.getValue().clear();
            return;
        }
        for (int currentOffset = offset; currentOffset < buffer.length; currentOffset += ((AbstractDataType)data).getSize()) {
            data = this.createListElement();
            ((AbstractDataType)data).readByteArray(buffer, currentOffset);
            ((AbstractDataType)data).setBody(this.frameBody);
            this.getValue().add(data);
        }
    }

    protected abstract T createListElement();

    @Override
    public byte[] writeByteArray() {
        if (logger.isLoggable(Level.CONFIG)) {
            logger.config("Writing DataTypeList " + this.getIdentifier());
        }
        byte[] buffer = new byte[this.getSize()];
        int offset = 0;
        Iterator iterator2 = this.getValue().iterator();
        while (iterator2.hasNext()) {
            AbstractDataType data = (AbstractDataType)iterator2.next();
            byte[] bytes = data.writeByteArray();
            System.arraycopy(bytes, 0, buffer, offset, bytes.length);
            offset += bytes.length;
        }
        return buffer;
    }

    public int hashCode() {
        return this.getValue() != null ? this.getValue().hashCode() : 0;
    }

    public String toString() {
        return this.getValue() != null ? this.getValue().toString() : "{}";
    }
}

