/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.asf;

import java.nio.charset.Charset;
import org.jaudiotagger.audio.asf.data.AsfHeader;
import org.jaudiotagger.audio.asf.data.MetadataDescriptor;
import org.jaudiotagger.audio.asf.util.Utils;
import org.jaudiotagger.tag.TagTextField;
import org.jaudiotagger.tag.asf.AsfFieldKey;
import org.jaudiotagger.tag.asf.AsfTagField;

public class AsfTagTextField
extends AsfTagField
implements TagTextField {
    public AsfTagTextField(AsfFieldKey field, String value) {
        super(field);
        this.toWrap.setString(value);
    }

    public AsfTagTextField(MetadataDescriptor source2) {
        super(source2);
        if (source2.getType() == 1) {
            throw new IllegalArgumentException("Cannot interpret binary as string.");
        }
    }

    public AsfTagTextField(String fieldKey, String value) {
        super(fieldKey);
        this.toWrap.setString(value);
    }

    @Override
    public String getContent() {
        return this.getDescriptor().getString();
    }

    @Override
    public Charset getEncoding() {
        return AsfHeader.ASF_CHARSET;
    }

    @Override
    public boolean isEmpty() {
        return Utils.isBlank(this.getContent());
    }

    @Override
    public void setContent(String content) {
        this.getDescriptor().setString(content);
    }

    @Override
    public void setEncoding(Charset encoding) {
        if (!AsfHeader.ASF_CHARSET.equals(encoding)) {
            throw new IllegalArgumentException("Only UTF-16LE is possible with ASF.");
        }
    }
}

