/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.ogg.util;

import java.util.logging.Logger;

public class OggCRCFactory {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.ogg");
    private static long[] crc_lookup = new long[256];
    private static boolean init = false;

    public static void init() {
        for (int i2 = 0; i2 < 256; ++i2) {
            long r = i2 << 24;
            for (int j = 0; j < 8; ++j) {
                if ((r & 0x80000000L) != 0L) {
                    r = r << 1 ^ 0x4C11DB7L;
                    continue;
                }
                r <<= 1;
            }
            OggCRCFactory.crc_lookup[i2] = r;
        }
        init = true;
    }

    public boolean checkCRC(byte[] data, byte[] crc) {
        return new String(crc).equals(new String(OggCRCFactory.computeCRC(data)));
    }

    public static byte[] computeCRC(byte[] data) {
        if (!init) {
            OggCRCFactory.init();
        }
        long crc_reg = 0L;
        for (byte aData : data) {
            int tmp = (int)(crc_reg >>> 24 & 0xFFL ^ (long)OggCRCFactory.u(aData));
            crc_reg = crc_reg << 8 ^ crc_lookup[tmp];
            crc_reg &= 0xFFFFFFFFFFFFFFFFL;
        }
        byte[] sum = new byte[]{(byte)(crc_reg & 0xFFL), (byte)(crc_reg >>> 8 & 0xFFL), (byte)(crc_reg >>> 16 & 0xFFL), (byte)(crc_reg >>> 24 & 0xFFL)};
        return sum;
    }

    private static int u(int n) {
        return n & 0xFF;
    }
}

