/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.generic;

import java.io.DataInput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.utils.FileTypeUtil;

public class Utils {
    public static int BITS_IN_BYTE_MULTIPLIER = 8;
    public static int KILOBYTE_MULTIPLIER = 1000;
    private static final Logger logger = Logger.getLogger("org.jaudiotagger.audio.generic.utils");
    private static final int MAX_BASE_TEMP_FILENAME_LENGTH = 20;

    public static String getExtension(File f) {
        String name = f.getName().toLowerCase();
        int i2 = name.lastIndexOf(".");
        if (i2 == -1) {
            return "";
        }
        return name.substring(i2 + 1);
    }

    public static String getMagicExtension(File f) throws IOException {
        String fileType = FileTypeUtil.getMagicFileType(f);
        return FileTypeUtil.getMagicExt(fileType);
    }

    public static long getLongLE(ByteBuffer b, int start, int end) {
        long number = 0L;
        for (int i2 = 0; i2 < end - start + 1; ++i2) {
            number += (long)((b.get(start + i2) & 0xFF) << i2 * 8);
        }
        return number;
    }

    public static long getLongBE(ByteBuffer b, int start, int end) {
        long number = 0L;
        for (int i2 = 0; i2 < end - start + 1; ++i2) {
            number += (long)(b.get(end - i2) & 0xFF) << i2 * 8;
        }
        return number;
    }

    public static int getIntLE(byte[] b) {
        return (int)Utils.getLongLE(ByteBuffer.wrap(b), 0, b.length - 1);
    }

    public static int getIntLE(byte[] b, int start, int end) {
        return (int)Utils.getLongLE(ByteBuffer.wrap(b), start, end);
    }

    public static int getIntBE(ByteBuffer b, int start, int end) {
        return (int)Utils.getLongBE(b, start, end);
    }

    public static short getShortBE(ByteBuffer b, int start, int end) {
        return (short)Utils.getIntBE(b, start, end);
    }

    public static byte[] getSizeBEInt32(int size) {
        byte[] b = new byte[]{(byte)(size >> 24 & 0xFF), (byte)(size >> 16 & 0xFF), (byte)(size >> 8 & 0xFF), (byte)(size & 0xFF)};
        return b;
    }

    public static byte[] getSizeBEInt16(short size) {
        byte[] b = new byte[]{(byte)(size >> 8 & 0xFF), (byte)(size & 0xFF)};
        return b;
    }

    public static byte[] getSizeLEInt32(int size) {
        byte[] b = new byte[]{(byte)(size & 0xFF), (byte)((long)(size >>> 8) & 0xFFL), (byte)((long)(size >>> 16) & 0xFFL), (byte)((long)(size >>> 24) & 0xFFL)};
        return b;
    }

    public static String readPascalString(ByteBuffer bb) throws IOException {
        int len = Utils.u(bb.get());
        byte[] buf = new byte[len];
        bb.get(buf);
        return new String(buf, 0, len, StandardCharsets.ISO_8859_1);
    }

    public static String getString(ByteBuffer buffer, int offset, int length, Charset encoding) {
        byte[] b = new byte[length];
        buffer.position(buffer.position() + offset);
        buffer.get(b);
        return new String(b, 0, length, encoding);
    }

    public static String getString(ByteBuffer buffer, Charset encoding) {
        byte[] b = new byte[buffer.remaining()];
        buffer.get(b);
        return new String(b, 0, b.length, encoding);
    }

    public static long readUint32(DataInput di) throws IOException {
        byte[] buf8 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        di.readFully(buf8, 4, 4);
        return ByteBuffer.wrap(buf8).getLong();
    }

    public static int readUint16(DataInput di) throws IOException {
        byte[] buf = new byte[]{0, 0, 0, 0};
        di.readFully(buf, 2, 2);
        return ByteBuffer.wrap(buf).getInt();
    }

    public static String readString(DataInput di, int charsToRead) throws IOException {
        byte[] buf = new byte[charsToRead];
        di.readFully(buf);
        return new String(buf, StandardCharsets.US_ASCII);
    }

    public static String getBaseFilenameForTempFile(File file) {
        String filename = Utils.getMinBaseFilenameAllowedForTempFile(file);
        if (filename.length() <= 20) {
            return filename;
        }
        return filename.substring(0, 20);
    }

    public static String getMinBaseFilenameAllowedForTempFile(File file) {
        String s = AudioFile.getBaseFilename(file);
        if (s.length() >= 3) {
            return s;
        }
        if (s.length() == 1) {
            return s + "000";
        }
        if (s.length() == 1) {
            return s + "00";
        }
        if (s.length() == 2) {
            return s + "0";
        }
        return s;
    }

    public static boolean rename(File fromFile, File toFile) {
        logger.log(Level.CONFIG, "Renaming From:" + fromFile.getAbsolutePath() + " to " + toFile.getAbsolutePath());
        if (toFile.exists()) {
            logger.log(Level.SEVERE, "Destination File:" + toFile + " already exists");
            return false;
        }
        boolean result = fromFile.renameTo(toFile);
        if (!result) {
            if (Utils.copy(fromFile, toFile)) {
                boolean deleteResult = fromFile.delete();
                if (!deleteResult) {
                    logger.log(Level.SEVERE, "Unable to delete File:" + fromFile);
                    toFile.delete();
                    return false;
                }
                return true;
            }
            return false;
        }
        return true;
    }

    public static boolean copy(File fromFile, File toFile) {
        try {
            Utils.copyThrowsOnException(fromFile, toFile);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String readFourBytesAsChars(ByteBuffer bytes) {
        byte[] b = new byte[4];
        bytes.get(b);
        return new String(b, StandardCharsets.ISO_8859_1);
    }

    public static String readThreeBytesAsChars(ByteBuffer bytes) {
        byte[] b = new byte[3];
        bytes.get(b);
        return new String(b, StandardCharsets.ISO_8859_1);
    }

    public static long u(int n) {
        return (long)n & 0xFFFFFFFFL;
    }

    public static int u(short n) {
        return n & 0xFFFF;
    }

    public static int u(byte n) {
        return n & 0xFF;
    }

    public static ByteBuffer readFileDataIntoBufferLE(FileChannel fc, int size) throws IOException {
        ByteBuffer tagBuffer = ByteBuffer.allocateDirect(size);
        fc.read(tagBuffer);
        tagBuffer.position(0);
        tagBuffer.order(ByteOrder.LITTLE_ENDIAN);
        return tagBuffer;
    }

    public static ByteBuffer readFileDataIntoBufferBE(FileChannel fc, int size) throws IOException {
        ByteBuffer tagBuffer = ByteBuffer.allocateDirect(size);
        fc.read(tagBuffer);
        tagBuffer.position(0);
        tagBuffer.order(ByteOrder.BIG_ENDIAN);
        return tagBuffer;
    }

    public static void copyThrowsOnException(File source2, File destination) throws IOException {
        try (FileInputStream inStream = new FileInputStream(source2);
             FileOutputStream outStream = new FileOutputStream(destination);){
            FileChannel inChannel = inStream.getChannel();
            FileChannel outChannel = outStream.getChannel();
            long size = inChannel.size();
            for (long position = 0L; position < size; position += inChannel.transferTo(position, 0x100000L, outChannel)) {
            }
        }
    }

    public static boolean isOddLength(long length) {
        return (length & 1L) != 0L;
    }
}

