/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.GregorianCalendar;
import org.jaudiotagger.audio.asf.data.AsfHeader;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.logging.ErrorMessage;

public class Utils {
    public static final long DIFF_BETWEEN_ASF_DATE_AND_JAVA_DATE = 11644470000000L;
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final int MAXIMUM_STRING_LENGTH_ALLOWED = 32766;

    public static void checkStringLengthNullSafe(String value) throws IllegalArgumentException {
        if (value != null && value.length() > 32766) {
            throw new IllegalArgumentException(ErrorMessage.WMA_LENGTH_OF_STRING_IS_TOO_LARGE.getMsg(value.length() * 2));
        }
    }

    public static boolean isStringLengthValidNullSafe(String value) {
        return value == null || value.length() <= 32766;
    }

    public static void copy(InputStream source2, OutputStream dest, long amount) throws IOException {
        int read;
        byte[] buf = new byte[8192];
        for (long copied = 0L; copied < amount; copied += (long)read) {
            int toRead = 8192;
            if (amount - copied < 8192L) {
                toRead = (int)(amount - copied);
            }
            if ((read = source2.read(buf, 0, toRead)) == -1) {
                throw new IOException("Inputstream has to continue for another " + (amount - copied) + " bytes.");
            }
            dest.write(buf, 0, read);
        }
    }

    public static void flush(InputStream source2, OutputStream dest) throws IOException {
        int read;
        byte[] buf = new byte[8192];
        while ((read = source2.read(buf)) != -1) {
            dest.write(buf, 0, read);
        }
    }

    public static byte[] getBytes(long value, int byteCount) {
        byte[] result = new byte[byteCount];
        for (int i2 = 0; i2 < result.length; ++i2) {
            result[i2] = (byte)(value >>> i2 * 8 & 0xFFL);
        }
        return result;
    }

    public static byte[] getBytes(String source2, Charset charset) {
        assert (charset != null);
        assert (source2 != null);
        ByteBuffer encoded = charset.encode(source2);
        byte[] result = new byte[encoded.limit()];
        encoded.rewind();
        encoded.get(result);
        return result;
    }

    public static GregorianCalendar getDateOf(BigInteger fileTime) {
        GregorianCalendar result = new GregorianCalendar();
        BigInteger time = fileTime.divide(new BigInteger("10"));
        Date date = new Date(time.longValue() - 11644470000000L);
        result.setTime(date);
        return result;
    }

    public static boolean isBlank(String toTest) {
        if (toTest == null) {
            return true;
        }
        for (int i2 = 0; i2 < toTest.length(); ++i2) {
            if (Character.isWhitespace(toTest.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static BigInteger readBig64(InputStream stream) throws IOException {
        byte[] bytes = new byte[8];
        byte[] oa = new byte[8];
        int read = stream.read(bytes);
        if (read != 8) {
            throw new EOFException();
        }
        for (int i2 = 0; i2 < bytes.length; ++i2) {
            oa[7 - i2] = bytes[i2];
        }
        return new BigInteger(oa);
    }

    public static byte[] readBinary(InputStream stream, long size) throws IOException {
        byte[] result = new byte[(int)size];
        stream.read(result);
        return result;
    }

    public static String readCharacterSizedString(InputStream stream) throws IOException {
        StringBuilder result = new StringBuilder();
        int strLen = Utils.readUINT16(stream);
        int character = stream.read();
        character |= stream.read() << 8;
        do {
            if (character == 0) continue;
            result.append((char)character);
            character = stream.read();
            character |= stream.read() << 8;
        } while (character != 0 || result.length() + 1 > strLen);
        if (strLen != result.length() + 1) {
            throw new IllegalStateException("Invalid Data for current interpretation");
        }
        return result.toString();
    }

    public static String readFixedSizeUTF16Str(InputStream stream, int strLen) throws IOException {
        byte[] strBytes = new byte[strLen];
        int read = stream.read(strBytes);
        if (read == strBytes.length) {
            if (strBytes.length >= 2 && strBytes[strBytes.length - 1] == 0 && strBytes[strBytes.length - 2] == 0) {
                byte[] copy = new byte[strBytes.length - 2];
                System.arraycopy(strBytes, 0, copy, 0, strBytes.length - 2);
                strBytes = copy;
            }
            return new String(strBytes, "UTF-16LE");
        }
        throw new IllegalStateException("Couldn't read the necessary amount of bytes.");
    }

    public static GUID readGUID(InputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("Argument must not be null");
        }
        int[] binaryGuid = new int[16];
        for (int i2 = 0; i2 < binaryGuid.length; ++i2) {
            binaryGuid[i2] = stream.read();
        }
        return new GUID(binaryGuid);
    }

    public static int readUINT16(InputStream stream) throws IOException {
        int result = stream.read();
        return result |= stream.read() << 8;
    }

    public static long readUINT32(InputStream stream) throws IOException {
        long result = 0L;
        for (int i2 = 0; i2 <= 24; i2 += 8) {
            result |= (long)stream.read() << i2;
        }
        return result;
    }

    public static long readUINT64(InputStream stream) throws IOException {
        long result = 0L;
        for (int i2 = 0; i2 <= 56; i2 += 8) {
            result |= (long)stream.read() << i2;
        }
        return result;
    }

    public static String readUTF16LEStr(InputStream stream) throws IOException {
        int strLen = Utils.readUINT16(stream);
        byte[] buf = new byte[strLen];
        int read = stream.read(buf);
        if (read == strLen || strLen == 0 && read == -1) {
            if (buf.length >= 2 && buf[buf.length - 1] == 0 && buf[buf.length - 2] == 0) {
                byte[] copy = new byte[buf.length - 2];
                System.arraycopy(buf, 0, copy, 0, buf.length - 2);
                buf = copy;
            }
            return new String(buf, AsfHeader.ASF_CHARSET.name());
        }
        throw new IllegalStateException("Invalid Data for current interpretation");
    }

    public static void writeUINT16(int number, OutputStream out) throws IOException {
        if (number < 0) {
            throw new IllegalArgumentException("positive value expected.");
        }
        byte[] toWrite = new byte[2];
        for (int i2 = 0; i2 <= 8; i2 += 8) {
            toWrite[i2 / 8] = (byte)(number >> i2 & 0xFF);
        }
        out.write(toWrite);
    }

    public static void writeUINT32(long number, OutputStream out) throws IOException {
        if (number < 0L) {
            throw new IllegalArgumentException("positive value expected.");
        }
        byte[] toWrite = new byte[4];
        for (int i2 = 0; i2 <= 24; i2 += 8) {
            toWrite[i2 / 8] = (byte)(number >> i2 & 0xFFL);
        }
        out.write(toWrite);
    }

    public static void writeUINT64(long number, OutputStream out) throws IOException {
        if (number < 0L) {
            throw new IllegalArgumentException("positive value expected.");
        }
        byte[] toWrite = new byte[8];
        for (int i2 = 0; i2 <= 56; i2 += 8) {
            toWrite[i2 / 8] = (byte)(number >> i2 & 0xFFL);
        }
        out.write(toWrite);
    }
}

