/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.io.ChunkModifier;
import org.jaudiotagger.audio.asf.io.ModificationResult;
import org.jaudiotagger.audio.asf.util.Utils;

public class AsfStreamer {
    private void copyChunk(GUID guid, InputStream source2, OutputStream destination) throws IOException {
        long chunkSize = Utils.readUINT64(source2);
        destination.write(guid.getBytes());
        Utils.writeUINT64(chunkSize, destination);
        Utils.copy(source2, destination, chunkSize - 24L);
    }

    public void createModifiedCopy(InputStream source2, OutputStream dest, List<ChunkModifier> modifiers) throws IOException {
        byte[] fileHeader;
        ByteArrayOutputStream bos;
        byte[] reserved;
        long chunkCount;
        long headerSize;
        long chunkDiff;
        long totalDiff;
        GUID readGUID;
        ArrayList<ChunkModifier> modders = new ArrayList<ChunkModifier>();
        if (modifiers != null) {
            modders.addAll(modifiers);
        }
        if (GUID.GUID_HEADER.equals(readGUID = Utils.readGUID(source2))) {
            totalDiff = 0L;
            chunkDiff = 0L;
            headerSize = Utils.readUINT64(source2);
            chunkCount = Utils.readUINT32(source2);
            reserved = new byte[]{(byte)(source2.read() & 0xFF), (byte)(source2.read() & 0xFF)};
            bos = new ByteArrayOutputStream();
            fileHeader = null;
            for (long i2 = 0L; i2 < chunkCount; ++i2) {
                GUID curr = Utils.readGUID(source2);
                if (GUID.GUID_FILE.equals(curr)) {
                    ByteArrayOutputStream tmp = new ByteArrayOutputStream();
                    long size = Utils.readUINT64(source2);
                    Utils.writeUINT64(size, tmp);
                    Utils.copy(source2, tmp, size - 24L);
                    fileHeader = tmp.toByteArray();
                    continue;
                }
                boolean handled = false;
                for (int j = 0; j < modders.size() && !handled; ++j) {
                    if (!((ChunkModifier)modders.get(j)).isApplicable(curr)) continue;
                    ModificationResult result = ((ChunkModifier)modders.get(j)).modify(curr, source2, bos);
                    chunkDiff += (long)result.getChunkCountDifference();
                    totalDiff += result.getByteDifference();
                    modders.remove(j);
                    handled = true;
                }
                if (handled) continue;
                this.copyChunk(curr, source2, bos);
            }
            for (ChunkModifier curr : modders) {
                ModificationResult result = curr.modify(null, null, bos);
                chunkDiff += (long)result.getChunkCountDifference();
                totalDiff += result.getByteDifference();
            }
        } else {
            throw new IllegalArgumentException("No ASF header object.");
        }
        dest.write(readGUID.getBytes());
        Utils.writeUINT64(headerSize + totalDiff, dest);
        Utils.writeUINT32(chunkCount + chunkDiff, dest);
        dest.write(reserved);
        this.modifyFileHeader(new ByteArrayInputStream(fileHeader), dest, totalDiff);
        dest.write(bos.toByteArray());
        Utils.flush(source2, dest);
    }

    private void modifyFileHeader(InputStream source2, OutputStream destination, long fileSizeDiff) throws IOException {
        destination.write(GUID.GUID_FILE.getBytes());
        long chunkSize = Utils.readUINT64(source2);
        Utils.writeUINT64(chunkSize, destination);
        destination.write(Utils.readGUID(source2).getBytes());
        long fileSize = Utils.readUINT64(source2);
        Utils.writeUINT64(fileSize + fileSizeDiff, destination);
        Utils.copy(source2, destination, chunkSize - 48L);
    }
}

