/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.aiff.chunk;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import org.jaudiotagger.audio.AudioFile;
import org.jaudiotagger.audio.iff.Chunk;
import org.jaudiotagger.audio.iff.ChunkHeader;
import org.jaudiotagger.tag.TagException;
import org.jaudiotagger.tag.aiff.AiffTag;
import org.jaudiotagger.tag.id3.AbstractID3v2Tag;
import org.jaudiotagger.tag.id3.ID3v22Tag;
import org.jaudiotagger.tag.id3.ID3v23Tag;
import org.jaudiotagger.tag.id3.ID3v24Tag;

public class ID3Chunk
extends Chunk {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.aiff.chunk");
    private AiffTag aiffTag;
    private String loggingName;

    public ID3Chunk(ChunkHeader chunkHeader, ByteBuffer chunkData, AiffTag tag, String loggingName) {
        super(chunkData, chunkHeader);
        this.aiffTag = tag;
        this.loggingName = loggingName;
    }

    @Override
    public boolean readChunk() throws IOException {
        AbstractID3v2Tag id3Tag;
        AudioFile.logger.config(this.loggingName + ":Reading chunk");
        if (!this.isId3v2Tag(this.chunkData)) {
            logger.severe(this.loggingName + ":Invalid ID3 header for ID3 chunk");
            return false;
        }
        byte version = this.chunkData.get();
        switch (version) {
            case 2: {
                id3Tag = new ID3v22Tag();
                AudioFile.logger.config(this.loggingName + ":Reading ID3V2.2 tag");
                break;
            }
            case 3: {
                id3Tag = new ID3v23Tag();
                AudioFile.logger.config(this.loggingName + ":Reading ID3V2.3 tag");
                break;
            }
            case 4: {
                id3Tag = new ID3v24Tag();
                AudioFile.logger.config(this.loggingName + ":Reading ID3V2.4 tag");
                break;
            }
            default: {
                return false;
            }
        }
        this.aiffTag.setID3Tag(id3Tag);
        this.chunkData.position(0);
        try {
            id3Tag.read(this.chunkData);
        }
        catch (TagException e) {
            AudioFile.logger.severe(this.loggingName + ":Exception reading ID3 tag: " + e.getClass().getName() + ": " + e.getMessage());
            return false;
        }
        return true;
    }

    private boolean isId3v2Tag(ByteBuffer headerData) throws IOException {
        for (int i2 = 0; i2 < 3; ++i2) {
            if (headerData.get() == AbstractID3v2Tag.TAG_ID[i2]) continue;
            return false;
        }
        return true;
    }
}

