/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import com.frostwire.util.Logger;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.Timer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class TimerEventPeriodic
implements TimerEventPerformer {
    private static final Logger LOG = Logger.getLogger(TimerEventPeriodic.class);
    private final Timer timer;
    private final long frequency;
    private final boolean absolute;
    private final TimerEventPerformer performer;
    private String name;
    private TimerEvent current_event;

    TimerEventPeriodic(Timer _timer, long _frequency, boolean _absolute, TimerEventPerformer _performer) {
        this.timer = _timer;
        this.frequency = _frequency;
        this.absolute = _absolute;
        this.performer = _performer;
        long now = SystemTime.getCurrentTime();
        this.current_event = this.timer.addEvent(now, now + this.frequency, this.absolute, (TimerEventPerformer)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String _name) {
        this.name = _name;
        TimerEventPeriodic timerEventPeriodic = this;
        synchronized (timerEventPeriodic) {
            if (this.current_event != null) {
                this.current_event.setName(this.name);
            }
        }
    }

    long getFrequency() {
        return this.frequency;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform(TimerEvent event) {
        try {
            this.performer.perform(event);
        }
        catch (Throwable e) {
            LOG.error(e.getMessage(), e);
        }
        TimerEventPeriodic timerEventPeriodic = this;
        synchronized (timerEventPeriodic) {
            long now = SystemTime.getCurrentTime();
            this.current_event = this.timer.addEvent(this.name, now + this.frequency, this.absolute, (TimerEventPerformer)this);
        }
    }
}

