/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.ThreadPool;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;

public class Timer
extends AERunnable
implements SystemTime.ChangeListener {
    private final ThreadPool thread_pool;
    private Set<TimerEvent> events = new TreeSet<TimerEvent>();
    private long unique_id_next = 0L;
    private long current_when;

    public Timer(String name, int thread_pool_size) {
        this(name, thread_pool_size, 5);
    }

    private Timer(String name, int thread_pool_size, int thread_priority) {
        this.thread_pool = new ThreadPool(name, thread_pool_size);
        SystemTime.registerClockChangeListener(this);
        Thread t = new Thread((Runnable)this, "Timer:" + name);
        t.setDaemon(true);
        t.setPriority(thread_priority);
        t.start();
    }

    void setWarnWhenFull() {
        this.thread_pool.setWarnWhenFull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runSupport() {
        while (true) {
            try {
                while (true) {
                    TimerEvent event_to_run = null;
                    Timer timer = this;
                    synchronized (timer) {
                        if (this.events.isEmpty()) {
                            try {
                                this.current_when = Integer.MAX_VALUE;
                                this.wait();
                            }
                            finally {
                                this.current_when = 0L;
                            }
                        }
                        long now = SystemTime.getCurrentTime();
                        TimerEvent next_event = this.events.iterator().next();
                        long when = next_event.getWhen();
                        long delay = when - now;
                        if (delay > 0L) {
                            try {
                                this.current_when = when;
                                this.wait(delay);
                            }
                            finally {
                                this.current_when = 0L;
                            }
                        }
                        if (this.events.isEmpty()) {
                            continue;
                        }
                        now = SystemTime.getCurrentTime();
                        Iterator<TimerEvent> it = this.events.iterator();
                        TimerEvent next_event2 = it.next();
                        long rem = next_event2.getWhen() - now;
                        if (rem <= 25L) {
                            event_to_run = next_event2;
                            it.remove();
                        }
                    }
                    if (event_to_run == null) continue;
                    event_to_run.setHasRun();
                    this.thread_pool.run(event_to_run.getRunnable());
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clockChangeDetected(long current_time, long offset) {
        if (Math.abs(offset) >= 60000L) {
            Timer timer = this;
            synchronized (timer) {
                Iterator<TimerEvent> it = this.events.iterator();
                ArrayList<TimerEvent> updated_events = new ArrayList<TimerEvent>(this.events.size());
                while (it.hasNext()) {
                    TimerEvent event = it.next();
                    if (!event.isAbsolute()) {
                        TimerEventPeriodic periodic_event;
                        long freq;
                        long old_when = event.getWhen();
                        long new_when = old_when + offset;
                        TimerEventPerformer performer = event.getPerformer();
                        if (performer instanceof TimerEventPeriodic && new_when > current_time + (freq = (periodic_event = (TimerEventPeriodic)performer).getFrequency()) + 5000L) {
                            new_when = current_time + freq;
                        }
                        event.setWhen(new_when);
                    }
                    updated_events.add(event);
                }
                this.events = new TreeSet<TimerEvent>(updated_events);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clockChangeCompleted(long current_time, long offset) {
        if (Math.abs(offset) >= 60000L) {
            Timer timer = this;
            synchronized (timer) {
                Iterator<TimerEvent> it = this.events.iterator();
                boolean updated = false;
                while (it.hasNext()) {
                    TimerEventPerformer performer;
                    TimerEvent event = it.next();
                    if (event.isAbsolute() || !((performer = event.getPerformer()) instanceof TimerEventPeriodic)) continue;
                    TimerEventPeriodic periodic_event = (TimerEventPeriodic)performer;
                    long freq = periodic_event.getFrequency();
                    long old_when = event.getWhen();
                    if (old_when <= current_time + freq + 5000L) continue;
                    long adjusted_when = current_time + freq;
                    event.setWhen(adjusted_when);
                    updated = true;
                }
                if (updated) {
                    this.events = new TreeSet<TimerEvent>(new ArrayList<TimerEvent>(this.events));
                }
                this.notify();
            }
        }
    }

    synchronized void addEvent(String name, long when, TimerEventPerformer performer) {
        this.addEvent(name, SystemTime.getCurrentTime(), when, performer);
    }

    synchronized TimerEvent addEvent(String name, long when, boolean absolute, TimerEventPerformer performer) {
        return this.addEvent(name, SystemTime.getCurrentTime(), when, absolute, performer);
    }

    synchronized TimerEvent addEvent(long creation_time, long when, boolean absolute, TimerEventPerformer performer) {
        return this.addEvent(null, creation_time, when, absolute, performer);
    }

    private synchronized void addEvent(String name, long creation_time, long when, TimerEventPerformer performer) {
        this.addEvent(name, creation_time, when, false, performer);
    }

    private synchronized TimerEvent addEvent(String name, long creation_time, long when, boolean absolute, TimerEventPerformer performer) {
        TimerEvent event = new TimerEvent(this.unique_id_next++, when, absolute, performer);
        if (name != null) {
            event.setName(name);
        }
        this.events.add(event);
        if (this.current_when == Integer.MAX_VALUE || when < this.current_when) {
            this.notify();
        }
        return event;
    }

    synchronized void addPeriodicEvent(String name, long frequency, TimerEventPerformer performer) {
        this.addPeriodicEvent(name, frequency, false, performer);
    }

    private synchronized void addPeriodicEvent(String name, long frequency, boolean absolute, TimerEventPerformer performer) {
        TimerEventPeriodic periodic_performer = new TimerEventPeriodic(this, frequency, absolute, performer);
        if (name != null) {
            periodic_performer.setName(name);
        }
    }
}

