/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import org.gudy.azureus2.core3.util.CopyOnWriteList;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.Timer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class SimpleTimer {
    private static final Timer timer;
    private static final CopyOnWriteList<TimerTickReceiver> tick_receivers;

    public static void addEvent(String name, long when, TimerEventPerformer performer) {
        timer.addEvent(name, when, performer);
    }

    static void addPeriodicEvent(String name, long frequency, TimerEventPerformer performer) {
        timer.addPeriodicEvent(name, frequency, performer);
    }

    static {
        tick_receivers = new CopyOnWriteList(true);
        timer = new Timer("Simple Timer", 32);
        timer.setWarnWhenFull();
        SimpleTimer.addPeriodicEvent("SimpleTimer:ticker", 1000L, new TimerEventPerformer(){
            private int tick_count;

            @Override
            public void perform(TimerEvent event) {
                ++this.tick_count;
                if (tick_receivers.size() > 0) {
                    long mono_now = SystemTime.getMonotonousTime();
                    for (TimerTickReceiver ttr : tick_receivers) {
                        try {
                            ttr.tick(mono_now, this.tick_count);
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
    }

    static interface TimerTickReceiver {
        public void tick(long var1, int var3);
    }
}

