/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

class CopyOnWriteList<T>
implements Iterable<T> {
    private final boolean use_linked_list;
    private List<T> list = Collections.EMPTY_LIST;
    private boolean visible = false;

    CopyOnWriteList(boolean _use_linked_list) {
        this.use_linked_list = _use_linked_list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(T obj) {
        CopyOnWriteList copyOnWriteList = this;
        synchronized (copyOnWriteList) {
            if (this.visible) {
                this.list = this.use_linked_list ? new LinkedList<T>(this.list) : new ArrayList<T>(this.list);
                this.visible = false;
            } else {
                this.list.remove(obj);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<T> iterator() {
        CopyOnWriteList copyOnWriteList = this;
        synchronized (copyOnWriteList) {
            this.visible = true;
            return new CopyOnWriteListIterator(this.list.iterator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        CopyOnWriteList copyOnWriteList = this;
        synchronized (copyOnWriteList) {
            return this.list.size();
        }
    }

    private class CopyOnWriteListIterator
    implements Iterator<T> {
        private final Iterator<T> it;
        private T last;

        CopyOnWriteListIterator(Iterator<T> _it) {
            this.it = _it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public T next() {
            this.last = this.it.next();
            return this.last;
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException("next has not been called!");
            }
            CopyOnWriteList.this.remove(this.last);
        }
    }
}

